/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dmt.dataminer.controls.BaseCostMatrixDataProvider;
import oracle.dmt.dataminer.controls.BaseCostMatrixTable;
import oracle.dmt.dataminer.controls.CostMatrixInfo;
import oracle.dmt.dataminer.controls.DateCellRenderer2;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GenericTableFixedColumns;
import oracle.dmt.dataminer.controls.GraphPanel2;
import oracle.dmt.dataminer.controls.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.roc.ROCDetailDialog;
import oracle.dmt.dataminer.tviewer.roc.ROCTabPanelState;
import oracle.dmt.dataminer.tviewer.roc.ThresholdDialog;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.test.CostBenefitDetailDialog;
import oracle.dmt.dataminer.workflow.dialog.test.CostMatrixDetailDialog;
import oracle.dmt.dataminer.workflow.dialog.test.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.test.TuneState;
import oracle.dmt.dataminer.workflow.xmlschema.CostMatrixType;
import oracle.dmt.dataminer.workflow.xmlschema.ROCAccuracyType;
import oracle.dmt.dataminer.workflow.xmlschema.ROCCustomThresholdType;
import oracle.dmt.dataminer.workflow.xmlschema.TuningType;
import oracle.dmt.dataminer.workflow.xmlschema.WeightsType;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controls.ColorIcon;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;

public class ROCTabPanel
extends AbstractPropertiesDialogPanel {
    private GraphPanel2 _graphPanel;
    private boolean _loading = true;
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private JButton jClearButton;
    private JComboBox jComboAccurayTypes;
    private JButton jCostMatrixBtn;
    private JPanel jCostMatrixPanel;
    private JButton jCustomROCButton;
    private JLabel jLabel1;
    private JLabel jLabel7;
    private JLabel jMatrixLbl;
    private JLabel jMatrixLbl1;
    private GenericTable jMatrixTable;
    private JPanel jROCPanel;
    private TransparentPanel jROCTablePanel;
    private ComponentWithTitlebar<JComponent> jROCToolbar;
    private JPanel jRocControls;
    private JPanel jRocGraphPanel;
    private JScrollPane jScrollPane;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JComboBox jTargetComb;
    private JLabel jTargetLbl;
    private JButton jTuneBtn;
    private JLabel jTuneCriteriaLabel;
    private JLabel jTuneCriteriaValue;
    private GenericTable jTuneMatrixTable;
    private JLabel jTuneMethodLabel;
    private JLabel jTuneMethodValue;
    private JLabel jTuneSettingsLabel;
    private JLabel jTuneTargetLabel;
    private JLabel jTuneTargetValue;
    private JLabel jTuneThresholdLabel;
    private JLabel jTuneThresholdValue;
    private JButton jDetailBtn;
    private CustomGenericTable jROCSummaryTable;
    private static Icon _detailBtnIconEna;
    private static Icon _detailBtnIconDis;
    private JScrollPane tscroller;

    public ROCTabPanel(TraversableContext traversableContext) {
        super(traversableContext);
        boolean bl = false;
        List<TestResult> list = this.getState().getTestCompareNode().getTestResults();
        for (TestResult testResult : list) {
            if (!((ClassTestResult)testResult).rocResultExists()) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.initComponents();
            this.initGraph();
            this.initRes();
            this.initUI();
        }
    }

    private void initGraph() {
        this._graphPanel = new GraphPanel2(new DefaultGraphDataModel(null, null, null, null, null));
        this.jRocGraphPanel.add((Component)new JTextArea("Loading..."), "Center");
        this.jRocGraphPanel.updateUI();
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTargetLbl, (Component)this.jTargetComb, (String)TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleName(TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("TARGET_VALUE_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jCustomROCButton, (String)TestViewerLrb.get("ROC_CUSTOM_BTN"));
        this.jCustomROCButton.getAccessibleContext().setAccessibleName(TestViewerLrb.get("ROC_CUSTOM_BTN"));
        this.jCustomROCButton.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("ROC_CUSTOM_BTN_ADA"));
        ResourceUtils.resLabel((JLabel)this.jMatrixLbl, (Component)this.jMatrixTable, (String)DialogsLrb.get("TUNE_COMMON_PERFORMANCE_MATRIX"));
        this.jMatrixLbl.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_PERFORMANCE_MATRIX")));
        this.jMatrixLbl.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_PERFORMANCE_MATRIX_ADA"));
        this.jLabel1.setText(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_PERF_MATRIX_HINT")));
        this.jLabel1.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_PERF_MATRIX_HINT")));
        ResourceUtils.resButton((AbstractButton)this.jTuneBtn, (String)DialogsLrb.get("TUNE_COMMON_TUNE"));
        this.jTuneBtn.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TUNE")));
        this.jTuneBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_TUNE_ADA"));
        this.jTuneSettingsLabel.setText(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TUNE_SETTINGS")));
        this.jTuneSettingsLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TUNE_SETTINGS")));
        ResourceUtils.resButton((AbstractButton)this.jClearButton, (String)DialogsLrb.get("TUNE_COMMON_CLEAR"));
        this.jClearButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_CLEAR")));
        this.jClearButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_CLEAR_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneMethodLabel, (Component)this.jTuneMethodValue, (String)DialogsLrb.get("TUNE_COMMON_METHOD"));
        this.jTuneMethodLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_METHOD")));
        this.jTuneMethodLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_METHOD_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneTargetLabel, (Component)this.jTuneTargetValue, (String)DialogsLrb.get("TUNE_COMMON_TARGET"));
        this.jTuneTargetLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TARGET")));
        this.jTuneTargetLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_TARGET_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneCriteriaLabel, (Component)this.jTuneCriteriaValue, (String)DialogsLrb.get("TUNE_COMMON_CRITERIA"));
        this.jTuneCriteriaLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_CRITERIA")));
        this.jTuneCriteriaLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_CRITERIA_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneThresholdLabel, (Component)this.jTuneThresholdValue, (String)DialogsLrb.get("TUNE_COMMON_THRESHOLD"));
        this.jTuneThresholdLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_THRESHOLD")));
        this.jTuneThresholdLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_THRESHOLD_ADA"));
        ResourceUtils.resLabel((JLabel)this.jMatrixLbl1, (Component)this.jTuneMatrixTable, (String)DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX"));
        this.jMatrixLbl1.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX")));
        this.jMatrixLbl1.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX")));
        this.jMatrixLbl1.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX_ADA"));
    }

    public void initUI() {
        this._loading = true;
        this.jROCSummaryTable = new CustomGenericTable();
        this.tscroller = new JScrollPane((Component)((Object)this.jROCSummaryTable));
        this.jROCToolbar.setComponent((JComponent)this.tscroller);
        this.jROCToolbar.setLabel(new JLabel(TestViewerLrb.get("ROC_RESULT_SUMMARY_TABLE")));
        ControlBar controlBar = new ControlBar();
        this.installROCSummaryActions(controlBar);
        this.jROCToolbar.setControlBar(controlBar);
        this.initializeControls();
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    private void installROCSummaryActions(ControlBar controlBar) {
        _detailBtnIconEna = OracleIcons.getIcon((String)"lov.png");
        _detailBtnIconDis = OracleIcons.getIcon((String)"lov.png");
        this.jDetailBtn = new JButton(_detailBtnIconEna);
        this.jDetailBtn.setDisabledIcon(_detailBtnIconDis);
        this.jDetailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jDetailBtnActionPerformed(actionEvent);
            }
        });
        controlBar.add((Component)this.jDetailBtn);
    }

    private void enableControls(boolean bl) {
        this.jTargetComb.setEnabled(bl);
        this.jCustomROCButton.setEnabled(bl);
        this.jDetailBtn.setEnabled(bl && this.jROCSummaryTable.getSelectedRowCount() > 0);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.jROCSummaryTable.getSelectedRowCount() > 0) {
            String string = this.getState().getShareState().getSelectTestResult();
            bl2 = this.getState().isTuningCustom(string);
            bl4 = this.getState().isTuningBenefit(string);
            bl3 = this.getState().isTuningCost(string);
        }
        this.jTuneTargetLabel.setVisible(bl && bl2);
        this.jTuneTargetValue.setVisible(bl && bl2);
        this.jTuneThresholdLabel.setVisible(bl && bl2);
        this.jTuneThresholdValue.setVisible(bl && bl2);
        this.jTuneCriteriaLabel.setVisible(bl && bl2);
        this.jTuneCriteriaValue.setVisible(bl && bl2);
        this.jMatrixLbl1.setVisible(bl && (bl2 || bl3 || bl4));
        this.jCostMatrixBtn.setVisible(bl && (bl3 || bl4));
        this.jScrollPane2.setVisible(bl && bl2);
        this.jTuneMatrixTable.setVisible(bl && bl2);
        this.jLabel7.setVisible(bl && bl2);
    }

    private void initializeControls() {
        ROCTabPanelState rOCTabPanelState = new ROCTabPanelState(this.getState().getShareState(), null);
        rOCTabPanelState.getClass();
        this.jROCSummaryTable.setModel((TableModel)((Object)rOCTabPanelState.new ROCTabPanelState.ROCTuneTableModel(null)));
        this.jROCSummaryTable.setSelectionMode(0);
        this.jTargetComb.setModel(new DefaultComboBoxModel<String>(new String[]{"Loading..."}));
        this.jTargetComb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jTargetCombActionPerformed(actionEvent);
            }
        });
        ListSelectionModel listSelectionModel = this.jROCSummaryTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ROCTabPanel.this.jROCSummaryTableValueChanged(listSelectionEvent);
            }
        });
        this.enableControls(false);
    }

    private void jDetailBtnActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.jROCSummaryTable.getSelectedRowsInModel();
        String string = (String)this.getState().getRocState().getRocTableModel().getValueAt(nArray[0], 0);
        ROCDetailDialog rOCDetailDialog = new ROCDetailDialog(string, this.getState().getRocState().getROCData().get(string));
        if (rOCDetailDialog.invoke()) {
            // empty if block
        }
    }

    private void jROCSummaryTableValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            int[] nArray = this.jROCSummaryTable.getSelectedRowsInModel();
            String string = (String)this.getState().getRocState().getRocTableModel().getValueAt(nArray[0], 0);
            this.getState().getShareState().setSelectTestResult(string);
            this.loadConfusionMatrix();
            this.loadTuneMatrix();
            this.enableControls(true);
        }
    }

    @Override
    protected final TuneState getState() {
        return (TuneState)super.getState();
    }

    @Override
    public void tabSelected() {
        if (this.getState().getRocState().getRocTableModel() == null) {
            return;
        }
        String string = this.getState().getShareState().getSelectTestResult();
        int n = 0;
        for (int i = 0; i < this.jROCSummaryTable.getRowCount(); ++i) {
            Object object = this.getState().getRocState().getRocTableModel().getValueAt(i, 0);
            if (!string.equals(object)) continue;
            n = i;
            break;
        }
        this.jROCSummaryTable.setRowSelectionInterval(n, n);
        this.loadTuneMatrix();
        this.enableControls(true);
    }

    @Override
    public void processInput() {
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.jROCPanel = new JPanel();
        this.jRocControls = new JPanel();
        this.jTargetLbl = new JLabel();
        this.jTargetComb = new JComboBox();
        this.jCustomROCButton = new JButton();
        this.jRocGraphPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jCostMatrixPanel = new JPanel();
        this.jMatrixLbl = new JLabel();
        this.jComboAccurayTypes = new JComboBox();
        this.jScrollPane = new JScrollPane();
        this.jMatrixTable = new BaseCostMatrixTable();
        this.jLabel1 = new JLabel();
        this.jClearButton = new JButton();
        this.jTuneBtn = new JButton();
        this.jTuneSettingsLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jTuneMethodLabel = new JLabel();
        this.jTuneMethodValue = new JLabel();
        this.jTuneTargetLabel = new JLabel();
        this.jTuneTargetValue = new JLabel();
        this.jTuneCriteriaLabel = new JLabel();
        this.jTuneCriteriaValue = new JLabel();
        this.jTuneThresholdLabel = new JLabel();
        this.jTuneThresholdValue = new JLabel();
        this.jMatrixLbl1 = new JLabel();
        this.jCostMatrixBtn = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTuneMatrixTable = new BaseCostMatrixTable();
        this.jLabel7 = new JLabel();
        this.jROCTablePanel = new TransparentPanel();
        this.jROCToolbar = new ComponentWithTitlebar();
        this.setMinimumSize(new Dimension(750, 490));
        this.setPreferredSize(new Dimension(750, 490));
        this.jSplitPane1.setDividerLocation(360);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setAutoscrolls(true);
        this.jSplitPane1.setLastDividerLocation(360);
        this.jSplitPane1.setMinimumSize(new Dimension(0, 0));
        this.jSplitPane1.setName("jSplitPane1");
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setPreferredSize(new Dimension(0, 0));
        this.jSplitPane2.setDividerLocation(450);
        this.jSplitPane2.setAutoscrolls(true);
        this.jSplitPane2.setName("jSplitPane2");
        this.jSplitPane2.setOneTouchExpandable(true);
        this.jROCPanel.setAutoscrolls(true);
        this.jROCPanel.setName("jROCPanel");
        this.jROCPanel.setPreferredSize(new Dimension(300, 300));
        this.jRocControls.setName("jRocControls");
        this.jTargetLbl.setHorizontalAlignment(2);
        this.jTargetLbl.setText("Target Value:");
        this.jTargetLbl.setName("jTargetLbl");
        this.jTargetComb.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jTargetComb.setName("jTargetComb");
        this.jTargetComb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jTargetCombActionPerformed(actionEvent);
            }
        });
        this.jCustomROCButton.setHorizontalAlignment(4);
        this.jCustomROCButton.setName("jCustomROCButton");
        this.jCustomROCButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jCustomROCActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jRocControls);
        this.jRocControls.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTargetLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetComb, -2, 147, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 180, Short.MAX_VALUE).addComponent(this.jCustomROCButton).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLbl).addComponent(this.jCustomROCButton).addComponent(this.jTargetComb, -2, -1, -2))));
        this.jRocGraphPanel.setName("jRocGraphPanel");
        this.jRocGraphPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout2 = new GroupLayout(this.jROCPanel);
        this.jROCPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRocGraphPanel, -1, 449, Short.MAX_VALUE).addComponent(this.jRocControls, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jRocControls, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRocGraphPanel, -1, 325, Short.MAX_VALUE)));
        this.jSplitPane2.setLeftComponent(this.jROCPanel);
        this.jScrollPane1.setName("jScrollPane1");
        this.jCostMatrixPanel.setName("jCostMatrixPanel");
        this.jMatrixLbl.setText("Performance Matrix:");
        this.jMatrixLbl.setName("jMatrixLbl");
        this.jComboAccurayTypes.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboAccurayTypes.setName("jComboAccurayTypes");
        this.jComboAccurayTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jComboAccurayTypesActionPerformed(actionEvent);
            }
        });
        this.jScrollPane.setName("jScrollPane");
        this.jScrollPane.setPreferredSize(new Dimension(450, 200));
        this.jMatrixTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jMatrixTable.setName("jMatrixTable");
        this.jMatrixTable.setRowSelectionAllowed(false);
        this.jScrollPane.setViewportView((Component)this.jMatrixTable);
        this.jLabel1.setText("Rows: Actual; Columns: Predicted");
        this.jLabel1.setName("jLabel1");
        this.jClearButton.setText("Clear");
        this.jClearButton.setName("jClearButton");
        this.jClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jClearButtonActionPerformed(actionEvent);
            }
        });
        this.jTuneBtn.setText("Tune");
        this.jTuneBtn.setName("jTuneBtn");
        this.jTuneBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jTuneBtnActionPerformed(actionEvent);
            }
        });
        this.jTuneSettingsLabel.setText("Tune Settings");
        this.jTuneSettingsLabel.setName("jTuneSettingsLabel");
        this.jSeparator1.setName("jSeparator1");
        this.jTuneMethodLabel.setText("Method:");
        this.jTuneMethodLabel.setName("jTuneMethodLabel");
        this.jTuneMethodValue.setText("ROC");
        this.jTuneMethodValue.setName("jTuneMethodValue");
        this.jTuneTargetLabel.setText("Target Value:");
        this.jTuneTargetLabel.setName("jTuneTargetLabel");
        this.jTuneTargetValue.setText("1");
        this.jTuneTargetValue.setName("jTuneTargetValue");
        this.jTuneCriteriaLabel.setText("Criteria:");
        this.jTuneCriteriaLabel.setName("jTuneCriteriaLabel");
        this.jTuneCriteriaValue.setText("Average Accuracy");
        this.jTuneCriteriaValue.setName("jTuneCriteriaValue");
        this.jTuneThresholdLabel.setText("Threshold:");
        this.jTuneThresholdLabel.setName("jTuneThresholdLabel");
        this.jTuneThresholdValue.setText("0.56789");
        this.jTuneThresholdValue.setName("jTuneThresholdValue");
        this.jMatrixLbl1.setText("Derived Cost Matrix:");
        this.jMatrixLbl1.setName("jMatrixLbl1");
        this.jCostMatrixBtn.setText("View...");
        this.jCostMatrixBtn.setName("jCostMatrixBtn");
        this.jCostMatrixBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ROCTabPanel.this.jCostMatrixBtnActionPerformed(actionEvent);
            }
        });
        this.jScrollPane2.setName("jScrollPane2");
        this.jTuneMatrixTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTuneMatrixTable.setName("jTuneMatrixTable");
        this.jTuneMatrixTable.setRowSelectionAllowed(false);
        this.jScrollPane2.setViewportView((Component)this.jTuneMatrixTable);
        this.jLabel7.setText("Rows: Actual; Columns: Predicted");
        this.jLabel7.setName("jLabel7");
        GroupLayout groupLayout3 = new GroupLayout(this.jCostMatrixPanel);
        this.jCostMatrixPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING).addComponent(this.jMatrixLbl, GroupLayout.Alignment.LEADING).addComponent(this.jComboAccurayTypes, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(this.jTuneSettingsLabel, GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING, -1, 235, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jClearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTuneBtn)).addGroup(GroupLayout.Alignment.LEADING, groupLayout3.createSequentialGroup().addGap(71, 71, 71).addComponent(this.jTuneMethodValue).addGap(66, 66, 66)).addComponent(this.jTuneMethodLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTuneThresholdLabel).addComponent(this.jTuneTargetLabel).addComponent(this.jTuneCriteriaLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTuneTargetValue).addComponent(this.jTuneCriteriaValue).addComponent(this.jTuneThresholdValue))).addComponent(this.jLabel7, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout3.createSequentialGroup().addComponent(this.jMatrixLbl1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCostMatrixBtn))).addContainerGap(28, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jMatrixLbl).addGap(1, 1, 1).addComponent(this.jComboAccurayTypes, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGap(43, 43, 43).addComponent(this.jTuneSettingsLabel)).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneBtn).addComponent(this.jClearButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneMethodLabel).addComponent(this.jTuneMethodValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneTargetLabel).addComponent(this.jTuneTargetValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneCriteriaLabel).addComponent(this.jTuneCriteriaValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneThresholdLabel).addComponent(this.jTuneThresholdValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMatrixLbl1).addComponent(this.jCostMatrixBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addContainerGap(-1, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.jCostMatrixPanel);
        this.jSplitPane2.setRightComponent(this.jScrollPane1);
        this.jSplitPane1.setTopComponent(this.jSplitPane2);
        this.jROCTablePanel.setName("jROCTablePanel");
        this.jROCToolbar.setName("jROCToolbar");
        GroupLayout groupLayout4 = new GroupLayout((Container)this.jROCTablePanel);
        this.jROCTablePanel.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jROCToolbar, -1, 748, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jROCToolbar, -1, 124, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent((Component)this.jROCTablePanel);
        GroupLayout groupLayout5 = new GroupLayout(this);
        this.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 750, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 490, Short.MAX_VALUE));
    }

    private void jTargetCombActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        this.getState().getRocState().setSelectedTargetValue((String)this.jTargetComb.getSelectedItem());
        this._loading = true;
        this.jRocGraphPanel.removeAll();
        this.jRocGraphPanel.add((Component)new JTextArea("Loading..."), "Center");
        ROCTabPanelState rOCTabPanelState = new ROCTabPanelState(this.getState().getShareState(), null);
        rOCTabPanelState.getClass();
        this.jROCSummaryTable.setModel((TableModel)((Object)rOCTabPanelState.new ROCTabPanelState.ROCTuneTableModel(null)));
        this.enableControls(false);
        LoadUI loadUI = new LoadUI(true);
        loadUI.start();
    }

    private void jCustomROCActionPerformed(ActionEvent actionEvent) {
        ThresholdDialog thresholdDialog = new ThresholdDialog(this.getState().getRocState());
        if (thresholdDialog.invoke()) {
            this.getState().getRocState().refreshCustomThresholdData();
            this.jRocGraphPanel.removeAll();
            this.jRocGraphPanel.add((Component)new JTextArea("Loading..."), "Center");
            ROCTabPanelState rOCTabPanelState = new ROCTabPanelState(this.getState().getShareState(), null);
            rOCTabPanelState.getClass();
            this.jROCSummaryTable.setModel((TableModel)((Object)rOCTabPanelState.new ROCTabPanelState.ROCTuneTableModel(null)));
            this.enableControls(false);
            LoadUI loadUI = new LoadUI(true);
            loadUI.start();
        }
    }

    private void jComboAccurayTypesActionPerformed(ActionEvent actionEvent) {
        this.loadConfusionMatrix();
    }

    private void jTuneBtnActionPerformed(ActionEvent actionEvent) {
        Object object;
        ROCAccuracyType rOCAccuracyType = null;
        ROCCustomThresholdType rOCCustomThresholdType = null;
        double d = 0.0;
        String string = (String)this.jComboAccurayTypes.getSelectedItem();
        String string2 = this.getState().getShareState().getSelectTestResult();
        int n = 0;
        if (string.equals(TestViewerLrb.get("OVERALL_ACCURACY"))) {
            n = this.getState().getRocState().getStatisticsData().get(string2).getMaxOverallAccuracyIdx();
            rOCAccuracyType = ROCAccuracyType.MAX_ACCURACY;
        } else if (string.equals(TestViewerLrb.get("AVG_ACCURACY"))) {
            n = this.getState().getRocState().getStatisticsData().get(string2).getMaxAvgAccuracyIdx();
            rOCAccuracyType = ROCAccuracyType.AVG_ACCURACY;
        } else if (string.equals(TestViewerLrb.get("CUSTOM_ACCURACY"))) {
            n = this.getState().getRocState().getStatisticsData().get(string2).getCustomAccuracyIdx();
            rOCAccuracyType = ROCAccuracyType.CUSTOM_ACCURACY;
            d = this.getState().getRocState().getCustomThresholdValue();
            object = this.getState().getRocState().getCustomThresholdOption();
            if (((String)object).compareTo("CUSTOM_THRESHOLD_OP_HIT_RATIO") == 0) {
                rOCCustomThresholdType = ROCCustomThresholdType.HIT_RATIO;
            } else if (((String)object).compareTo("CUSTOM_THRESHOLD_OP_FALSE_ALARM") == 0) {
                rOCCustomThresholdType = ROCCustomThresholdType.FALSE_ALARM;
            } else if (((String)object).compareTo("CUSTOM_THRESHOLD_OP_FALSE_RATIO") == 0) {
                rOCCustomThresholdType = ROCCustomThresholdType.FALSE_POS_NEG_RATIO;
            }
        } else if (string.equals(TestViewerLrb.get("CURRENT_ACCURACY"))) {
            n = this.getState().getRocState().getStatisticsData().get(string2).getModelAccuracyIdx();
            rOCAccuracyType = ROCAccuracyType.CURRENT_MODEL;
        }
        if (n >= 0) {
            Object object2;
            object = this.getState().getRocState().getROCData().get(string2).get(n);
            double d2 = ((ROCTabPanelState.ROCData)object).getProb();
            this.getState().getRocState().setCustomThresholdValue(d2);
            double d3 = 1.0E-6f;
            double d4 = d2 - d3 < 0.0 ? d2 : d2 - d3;
            double d5 = (1.0 - d4) / d4;
            String string3 = this.getState().getRocState().getSelectedTargetValue();
            CostMatrixType costMatrixType = new CostMatrixType();
            TuningType.Custom.Settings.ROC rOC = new TuningType.Custom.Settings.ROC();
            rOC.setAccuracy(rOCAccuracyType);
            rOC.setThreshold(d2);
            if (rOCAccuracyType == ROCAccuracyType.CUSTOM_ACCURACY) {
                object2 = new TuningType.Custom.Settings.ROC.CustomThreshold();
                object2.setType(rOCCustomThresholdType);
                object2.setValue(d);
                rOC.setCustomThreshold((TuningType.Custom.Settings.ROC.CustomThreshold)object2);
            }
            object2 = this.getState().getModelTargetValues();
            Iterator iterator = ((Vector)object2).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Iterator iterator2 = ((Vector)object2).iterator();
                while (iterator2.hasNext()) {
                    Object e2 = iterator2.next();
                    CostMatrixType.Item item = new CostMatrixType.Item();
                    item.setActual(e.toString());
                    item.setPredict(e2.toString());
                    if (e.toString().compareTo(e2.toString()) == 0) {
                        item.setCost(0.0);
                    } else if (e.toString().compareTo(string3) == 0 && e2.toString().compareTo(string3) != 0) {
                        item.setCost(d5);
                    } else {
                        item.setCost(1.0);
                    }
                    costMatrixType.getItem().add(item);
                }
            }
            this.getState().setTuningCustom(string2, string3, rOC, costMatrixType);
            int n2 = this.jROCSummaryTable.getSelectedRow();
            this.jROCSummaryTable.tableChanged(new TableModelEvent(this.jROCSummaryTable.getModel()));
            this.jROCSummaryTable.setRowSelectionInterval(n2, n2);
            this.loadTuneMatrix();
            this.enableControls(true);
        }
    }

    private void jClearButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.getState().getShareState().getSelectTestResult();
        this.getState().setTuningNone(string);
        int n = this.jROCSummaryTable.getSelectedRow();
        this.jROCSummaryTable.tableChanged(new TableModelEvent(this.jROCSummaryTable.getModel()));
        this.jROCSummaryTable.setRowSelectionInterval(n, n);
        this.loadTuneMatrix();
        this.enableControls(true);
    }

    private void jCostMatrixBtnActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        String string = this.getState().getShareState().getSelectTestResult();
        boolean bl2 = this.getState().getBenefitState().getTuneBenefitWeight(string) != null;
        boolean bl3 = bl = this.getState().getCostState().getTuneCostMatrix(string) != null;
        if (bl2) {
            WeightsType weightsType = this.getState().getBenefitState().getTuneBenefitWeight(string);
            CostBenefitDetailDialog costBenefitDetailDialog = new CostBenefitDetailDialog(weightsType);
            costBenefitDetailDialog.invoke();
        } else if (bl) {
            CostMatrixInfo costMatrixInfo = this.getState().getCostState().getTuneCostMatrixInfo(string);
            CostMatrixDetailDialog costMatrixDetailDialog = new CostMatrixDetailDialog(costMatrixInfo);
            costMatrixDetailDialog.invoke();
        }
    }

    private void loadConfusionMatrix() {
        String string = this.getState().getShareState().getSelectTestResult();
        ROCTabPanelState.ROCData rOCData = null;
        String string2 = null;
        String string3 = null;
        String string4 = (String)this.jComboAccurayTypes.getSelectedItem();
        int n = 0;
        if (string4.equals(TestViewerLrb.get("OVERALL_ACCURACY"))) {
            n = this.getState().getRocState().getStatisticsData().get(string).getMaxOverallAccuracyIdx();
        } else if (string4.equals(TestViewerLrb.get("AVG_ACCURACY"))) {
            n = this.getState().getRocState().getStatisticsData().get(string).getMaxAvgAccuracyIdx();
        } else if (string4.equals(TestViewerLrb.get("CUSTOM_ACCURACY"))) {
            n = this.getState().getRocState().getStatisticsData().get(string).getCustomAccuracyIdx();
        } else if (string4.equals(TestViewerLrb.get("CURRENT_ACCURACY"))) {
            n = this.getState().getRocState().getStatisticsData().get(string).getModelAccuracyIdx();
        }
        rOCData = n >= 0 ? this.getState().getRocState().getROCData().get(string).get(n) : null;
        string2 = this.getState().getRocState().getSelectedTargetValue();
        Vector<Object> vector = this.getState().getModelTargetValues();
        string3 = vector.size() == 2 ? (string2.compareTo(vector.firstElement().toString()) == 0 ? vector.lastElement().toString() : vector.firstElement().toString()) : TestViewerLrb.get("OTHER_TARGETS");
        ((BaseCostMatrixTable)this.jMatrixTable).setModel(new TuneState.MatrixModel(new PerformanceMatrixDataProvider(this.getState().getRocState().getSelectedTargetValue(), string3, rOCData, this._percentageFormat)));
    }

    private void loadTuneMatrix() {
        String string = this.getState().getShareState().getSelectTestResult();
        if (this.getState().isTuningNone(string)) {
            this.jTuneMethodValue.setText(TuneState.TUNE_OPTION_NONE);
        } else if (this.getState().isTuningBenefit(string)) {
            this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_BENEFIT);
        } else if (this.getState().isTuningCost(string)) {
            this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_COST);
        } else if (this.getState().isTuningCustom(string)) {
            String string2 = null;
            TuneState.TuningCustomData tuningCustomData = this.getState().getTuningCustomData(string);
            String string3 = tuningCustomData.getTargetValue();
            Vector<Object> vector = this.getState().getModelTargetValues();
            this.jTuneTargetValue.setText(string3);
            Object object = tuningCustomData.getTuneType();
            CostMatrixType costMatrixType = tuningCustomData.getCostMatrix();
            if (object instanceof TuningType.Custom.Settings.ROC) {
                TuningType.Custom.Settings.ROC rOC = (TuningType.Custom.Settings.ROC)object;
                this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_ROC);
                ROCAccuracyType rOCAccuracyType = rOC.getAccuracy();
                if (rOCAccuracyType == ROCAccuracyType.CUSTOM_ACCURACY) {
                    TuningType.Custom.Settings.ROC.CustomThreshold customThreshold = rOC.getCustomThreshold();
                    String string4 = customThreshold.getType().value();
                    this.jTuneCriteriaValue.setText(rOCAccuracyType.value() + ", " + string4 + ": " + this._percentageFormat.format(customThreshold.getValue()));
                } else {
                    this.jTuneCriteriaValue.setText(rOCAccuracyType.value());
                }
                this.jTuneThresholdValue.setText(this._percentageFormat.format(rOC.getThreshold()));
            } else if (object instanceof TuningType.Custom.Settings.Lift) {
                TuningType.Custom.Settings.Lift lift = (TuningType.Custom.Settings.Lift)object;
                this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_LIFT);
                String string5 = lift.getType().value();
                this.jTuneCriteriaValue.setText("Quantile: " + lift.getQuantile() + " (" + string5 + ")");
                this.jTuneThresholdValue.setText(this._percentageFormat.format(lift.getThreshold()));
            } else if (object instanceof TuningType.Custom.Settings.Profit) {
                TuningType.Custom.Settings.Profit profit = (TuningType.Custom.Settings.Profit)object;
                this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_PROFIT);
                this.jTuneCriteriaValue.setText("Population: " + this._percentageFormat.format(profit.getPopulation()) + "%, ROI: " + this._percentageFormat.format(profit.getROI()) + "%");
                this.jTuneThresholdValue.setText(this._percentageFormat.format(profit.getProfit()));
            }
            string2 = vector.size() == 2 ? (string3.compareTo(vector.firstElement().toString()) == 0 ? vector.lastElement().toString() : vector.firstElement().toString()) : TestViewerLrb.get("OTHER_TARGETS");
            ((BaseCostMatrixTable)this.jTuneMatrixTable).setModel(new TuneState.MatrixModel(new TuneState.TuneMatrixDataProvider(string3, string2, costMatrixType, this._percentageFormat)));
        }
    }

    private void initConfusionMatrix() {
        this.jComboAccurayTypes.setModel(new DefaultComboBoxModel<String>(new String[]{TestViewerLrb.get("OVERALL_ACCURACY"), TestViewerLrb.get("AVG_ACCURACY"), TestViewerLrb.get("CUSTOM_ACCURACY"), TestViewerLrb.get("CURRENT_ACCURACY")}));
        this.jComboAccurayTypes.setSelectedIndex(0);
        this.loadConfusionMatrix();
    }

    class CustomGenericTable
    extends GenericTableFixedColumns {
        private DateFormat _df = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        private Preferences _p = Preferences.getPreferences();
        private ModelViewerPreferenceSettings _prefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)this._p);
        private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._prefenceSettings.getPercentagePrecisionLevel(), 0, 0);
        private NumberFormat _numericalFormat = NumericFormat.getInstance(true, this._prefenceSettings.getNumericalPrecisionLevel(), 0, 0);

        CustomGenericTable() {
            this._percentageFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
            this._percentageFormat.setMinimumIntegerDigits(1);
            this._numericalFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
            this._numericalFormat.setMinimumIntegerDigits(1);
        }

        @Override
        public void addDynamicCellRenderers() {
            NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
            this.addCellRenderer(ROCTabPanel.this.getState().getRocState().getRocTableModel().getColumnName(0), new CustomCellRenderer());
            this.addCellRenderer(ROCTabPanel.this.getState().getRocState().getRocTableModel().getColumnName(2), numberCellRenderer);
            this.addCellRenderer(ROCTabPanel.this.getState().getRocState().getRocTableModel().getColumnName(6), numberCellRenderer);
            this.addCellRenderer(ROCTabPanel.this.getState().getRocState().getRocTableModel().getColumnName(5), numberCellRenderer);
            this.addCellRenderer(ROCTabPanel.this.getState().getRocState().getRocTableModel().getColumnName(4), numberCellRenderer);
            this.addCellRenderer(ROCTabPanel.this.getState().getRocState().getRocTableModel().getColumnName(3), numberCellRenderer);
            this.addCellRenderer(ROCTabPanel.this.getState().getRocState().getRocTableModel().getColumnName(8), new DateCellRenderer2());
        }

        private String formatCellValue(Object object) {
            String string = null;
            if (object != null) {
                string = object instanceof Double ? this._percentageFormat.format((Double)object) : (object instanceof Integer ? this._numericalFormat.format(((Integer)object).intValue()) : (object instanceof BigDecimal ? this._numericalFormat.format(((BigDecimal)object).doubleValue()) : (object instanceof Date ? this._df.format(object) : object.toString())));
            }
            return string;
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = "";
            string = this.formatCellValue(object);
            return string;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string = "";
            Object object = null;
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            if (n == -1 || n2 == -1) {
                return null;
            }
            object = this.getValueAt(n, n2);
            string = this.formatCellValue(object);
            return string;
        }
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!(object instanceof String)) assert (false);
            String string = (String)object;
            Color color = ROCTabPanel.this.getState().getRocState().getParentTestViewerState().getTestResultGraphColor(string);
            this.setIcon((Icon)new ColorIcon(color));
            return component;
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        public Object construct() {
            try {
                if (this._reload) {
                    ROCTabPanel.this.getState().getRocState().refreshROCStatData();
                } else {
                    ROCTabPanel.this.getState().getRocState().load();
                }
                ROCTabPanel.this._graphPanel.initGraph(ROCTabPanel.this.getState().getRocState().getRocGraphModel());
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return ROCTabPanel.this.getState().getRocState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            int n = 1;
            try {
                if (this._success && this._ex == null) {
                    ROCTabPanel.this.jRocGraphPanel.removeAll();
                    ROCTabPanel.this.jRocGraphPanel.add((Component)ROCTabPanel.this._graphPanel, "Center");
                    ROCTabPanel.this.jRocGraphPanel.updateUI();
                    String string = ROCTabPanel.this.getState().getShareState().getSelectTestResult();
                    ROCTabPanel.this.jROCSummaryTable.setFixedColumnCount(n);
                    ROCTabPanel.this.jROCSummaryTable.setModel((TableModel)((Object)ROCTabPanel.this.getState().getRocState().getRocTableModel()));
                    String string2 = ROCTabPanel.this.getState().getRocState().getRocTableModel().getColumnName(0);
                    ROCTabPanel.this.jROCSummaryTable.setFixedColumnPreferredWidth(string2, 175);
                    ROCTabPanel.this.jROCSummaryTable.findOrCreateTableRowHeader(ROCTabPanel.this.tscroller);
                    ROCTabPanel.this.jROCSummaryTable.setSorted(true);
                    ROCTabPanel.this.jROCSummaryTable.setAutoResizeMode(0);
                    ROCTabPanel.this.jROCSummaryTable.addDynamicCellRenderers();
                    TableColumnModel tableColumnModel = ROCTabPanel.this.jROCSummaryTable.getColumnModel();
                    tableColumnModel.getColumn(1 - n).setPreferredWidth(90);
                    tableColumnModel.getColumn(2 - n).setPreferredWidth(120);
                    tableColumnModel.getColumn(6 - n).setPreferredWidth(150);
                    tableColumnModel.getColumn(5 - n).setPreferredWidth(150);
                    tableColumnModel.getColumn(4 - n).setPreferredWidth(150);
                    tableColumnModel.getColumn(3 - n).setPreferredWidth(150);
                    tableColumnModel.getColumn(7 - n).setPreferredWidth(150);
                    tableColumnModel.getColumn(8 - n).setPreferredWidth(150);
                    ROCTabPanel.this.jROCSummaryTable.setSelectionMode(0);
                    ROCTabPanel.this.jROCSummaryTable.setColumnSelectorAvailable(true);
                    ROCTabPanel.this.jROCSummaryTable.setShowToolTips(true);
                    ROCTabPanel.this.jROCSummaryTable.setSortRetainsSelection(true);
                    ROCTabPanel.this.jROCSummaryTable.setRowSelectionAllowed(true);
                    ROCTabPanel.this.jROCSummaryTable.setCellRenderers();
                    ROCTabPanel.this.jROCSummaryTable.setRowHeaderCellRenderers();
                    int n2 = 0;
                    if (string == null) {
                        double d = 0.0;
                        double d2 = 0.0;
                        for (int i = 0; i < ROCTabPanel.this.jROCSummaryTable.getRowCount(); ++i) {
                            d = (Double)ROCTabPanel.this.getState().getRocState().getRocTableModel().getValueAt(i, 2);
                            if (!(d2 < d)) continue;
                            d2 = d;
                            n2 = i;
                        }
                    } else {
                        for (int i = 0; i < ROCTabPanel.this.jROCSummaryTable.getRowCount(); ++i) {
                            Object object = ROCTabPanel.this.getState().getRocState().getRocTableModel().getValueAt(i, 0);
                            if (!string.equals(object)) continue;
                            n2 = i;
                            break;
                        }
                    }
                    ROCTabPanel.this.jROCSummaryTable.setRowSelectionInterval(n2, n2);
                    if (!this._reload) {
                        ROCTabPanel.this.jTargetComb.setModel(new DefaultComboBoxModel<String>(ROCTabPanel.this.getState().getRocState().getTargetValues()));
                        ROCTabPanel.this.jTargetComb.setSelectedItem(ROCTabPanel.this.getState().getRocState().getSelectedTargetValue());
                        ROCTabPanel.this.initConfusionMatrix();
                    } else {
                        ROCTabPanel.this.loadConfusionMatrix();
                    }
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), null, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
                }
                ROCTabPanel.this.enableControls(true);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                ROCTabPanel.this._loading = false;
            }
        }
    }

    private class PerformanceMatrixDataProvider
    implements BaseCostMatrixDataProvider {
        private String _positiveTarget;
        private String _otherTarget;
        private ROCTabPanelState.ROCData _data;
        private NumberFormat _percentageFormat;

        PerformanceMatrixDataProvider(String string, String string2, ROCTabPanelState.ROCData rOCData, NumberFormat numberFormat) {
            this._positiveTarget = string;
            this._otherTarget = string2;
            this._data = rOCData;
            this._percentageFormat = numberFormat;
        }

        @Override
        public Object[] getTargetValues() {
            return new Object[]{this._positiveTarget, this._otherTarget};
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this._data == null) {
                return null;
            }
            if (n == 0 && n2 == 0) {
                return this._percentageFormat.format(this._data.getTruePositives());
            }
            if (n == 0 && n2 == 1) {
                return this._percentageFormat.format(this._data.getFalseNegatives());
            }
            if (n == 1 && n2 == 0) {
                return this._percentageFormat.format(this._data.getFalsePositives());
            }
            if (n == 1 && n2 == 1) {
                return this._percentageFormat.format(this._data.getTrueNegatives());
            }
            return "Undefined";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }
}

