/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dmt.dataminer.controls.BaseCostMatrixDataProvider;
import oracle.dmt.dataminer.controls.BaseCostMatrixTable;
import oracle.dmt.dataminer.controls.CostMatrixInfo;
import oracle.dmt.dataminer.controls.DateCellRenderer2;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GenericTableFixedColumns;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.profit.ProfitDetailDialog;
import oracle.dmt.dataminer.tviewer.profit.ProfitInputDialog;
import oracle.dmt.dataminer.tviewer.profit.ProfitTabState;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.test.CostBenefitDetailDialog;
import oracle.dmt.dataminer.workflow.dialog.test.CostMatrixDetailDialog;
import oracle.dmt.dataminer.workflow.dialog.test.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.test.TuneState;
import oracle.dmt.dataminer.workflow.xmlschema.CostMatrixType;
import oracle.dmt.dataminer.workflow.xmlschema.ROCAccuracyType;
import oracle.dmt.dataminer.workflow.xmlschema.TuningType;
import oracle.dmt.dataminer.workflow.xmlschema.WeightsType;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controls.ColorIcon;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;

public class ProfitTabPanel
extends AbstractPropertiesDialogPanel {
    private GraphPanel _graphPanel;
    private boolean _loading = true;
    private static final String UPDATE_ALL = "UPDATE_ALL";
    private static final String UPDATE_GRAPH = "UPDATE_GRAPH";
    private static final String UPDATE_THRESHOLD = "UPDATE_THRESHOLD";
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private JButton jClearButton;
    private JButton jCostMatrixBtn;
    private JPanel jCostMatrixPanel;
    private JPanel jGraphControl;
    private JPanel jGraphPanel;
    private JPanel jGraphSelection;
    private JLabel jLabel1;
    private JLabel jLabel7;
    private JLabel jMatrixLbl;
    private JLabel jMatrixLbl1;
    private GenericTable jMatrixTable;
    private JPanel jPanel1;
    private TransparentPanel jProfitTablePanel;
    private ComponentWithTitlebar<JComponent> jProfitToolbar;
    private JSlider jQuantileSlider;
    private JScrollPane jScrollPane;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JButton jSettingsBtn;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JComboBox jTargetComb;
    private JLabel jTargetLbl;
    private JButton jTuneBtn;
    private JLabel jTuneCriteriaLabel;
    private JLabel jTuneCriteriaValue;
    private GenericTable jTuneMatrixTable;
    private JLabel jTuneMethodLabel;
    private JLabel jTuneMethodValue;
    private JLabel jTuneSettingsLabel;
    private JLabel jTuneTargetLabel;
    private JLabel jTuneTargetValue;
    private JLabel jTuneThresholdLabel;
    private JLabel jTuneThresholdValue;
    private JButton jDetailBtn;
    private CustomGenericTable jResultTable;
    private static Icon _detailBtnIconEna;
    private static Icon _detailBtnIconDis;
    private JScrollPane tscroller;

    public ProfitTabPanel(TraversableContext traversableContext) {
        super(traversableContext);
        this.initComponents();
        this.initGraph();
        this.initRes();
        this.initUI();
    }

    private void initGraph() {
        this._graphPanel = new GraphPanel(new DefaultGraphDataModel(null, null, null, null, null));
        this.jGraphPanel.add((Component)new JTextArea("Loading..."), "Center");
        this.jGraphPanel.updateUI();
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTargetLbl, (Component)this.jTargetComb, (String)TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleName(TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("TARGET_VALUE_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jSettingsBtn, (String)TestViewerLrb.get("PROFIT_SETTINGS_BTN"));
        this.jSettingsBtn.getAccessibleContext().setAccessibleName(TestViewerLrb.get("PROFIT_SETTINGS_BTN"));
        this.jSettingsBtn.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("PROFIT_SETTINGS_BTN_ADA"));
        ResourceUtils.resLabel((JLabel)this.jMatrixLbl, (Component)this.jMatrixTable, (String)DialogsLrb.get("TUNE_COMMON_PERFORMANCE_MATRIX"));
        this.jMatrixLbl.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_PERFORMANCE_MATRIX")));
        this.jMatrixLbl.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_PERFORMANCE_MATRIX_ADA"));
        this.jLabel1.setText(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_PERF_MATRIX_HINT")));
        this.jLabel1.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_PERF_MATRIX_HINT")));
        ResourceUtils.resButton((AbstractButton)this.jTuneBtn, (String)DialogsLrb.get("TUNE_COMMON_TUNE"));
        this.jTuneBtn.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TUNE")));
        this.jTuneBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_TUNE_ADA"));
        this.jTuneSettingsLabel.setText(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TUNE_SETTINGS")));
        this.jTuneSettingsLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TUNE_SETTINGS")));
        ResourceUtils.resButton((AbstractButton)this.jClearButton, (String)DialogsLrb.get("TUNE_COMMON_CLEAR"));
        this.jClearButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_CLEAR")));
        this.jClearButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_CLEAR_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneMethodLabel, (Component)this.jTuneMethodValue, (String)DialogsLrb.get("TUNE_COMMON_METHOD"));
        this.jTuneMethodLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_METHOD")));
        this.jTuneMethodLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_METHOD_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneTargetLabel, (Component)this.jTuneTargetValue, (String)DialogsLrb.get("TUNE_COMMON_TARGET"));
        this.jTuneTargetLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TARGET")));
        this.jTuneTargetLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_TARGET_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneCriteriaLabel, (Component)this.jTuneCriteriaValue, (String)DialogsLrb.get("TUNE_COMMON_CRITERIA"));
        this.jTuneCriteriaLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_CRITERIA")));
        this.jTuneCriteriaLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_CRITERIA_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneThresholdLabel, (Component)this.jTuneThresholdValue, (String)DialogsLrb.get("TUNE_COMMON_PROFIT"));
        this.jTuneThresholdLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_PROFIT")));
        this.jTuneThresholdLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_PROFIT_ADA"));
        ResourceUtils.resLabel((JLabel)this.jMatrixLbl1, (Component)this.jTuneMatrixTable, (String)DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX"));
        this.jMatrixLbl1.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX")));
        this.jMatrixLbl1.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX")));
        this.jMatrixLbl1.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX_ADA"));
    }

    public void initUI() {
        this._loading = true;
        this.jResultTable = new CustomGenericTable();
        this.tscroller = new JScrollPane((Component)((Object)this.jResultTable));
        this.jProfitToolbar.setComponent((JComponent)this.tscroller);
        ControlBar controlBar = new ControlBar();
        this.installProfitResultsActions(controlBar);
        this.jProfitToolbar.setControlBar(controlBar);
        this.initializeControls();
        LoadUI loadUI = new LoadUI(UPDATE_ALL);
        loadUI.start();
    }

    private void enableControls(boolean bl) {
        this.jTargetComb.setEnabled(bl);
        this.jSettingsBtn.setEnabled(bl);
        this.jDetailBtn.setEnabled(bl && this.jResultTable.getSelectedRowCount() > 0);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.jResultTable.getSelectedRowCount() > 0) {
            String string = this.getState().getShareState().getSelectTestResult();
            bl2 = this.getState().isTuningCustom(string);
            bl4 = this.getState().isTuningBenefit(string);
            bl3 = this.getState().isTuningCost(string);
        }
        this.jTuneTargetLabel.setVisible(bl && bl2);
        this.jTuneTargetValue.setVisible(bl && bl2);
        this.jTuneThresholdLabel.setVisible(bl && bl2);
        this.jTuneThresholdValue.setVisible(bl && bl2);
        this.jTuneCriteriaLabel.setVisible(bl && bl2);
        this.jTuneCriteriaValue.setVisible(bl && bl2);
        this.jMatrixLbl1.setVisible(bl && (bl2 || bl3 || bl4));
        this.jCostMatrixBtn.setVisible(bl && (bl3 || bl4));
        this.jScrollPane2.setVisible(bl && bl2);
        this.jTuneMatrixTable.setVisible(bl && bl2);
        this.jLabel7.setVisible(bl && bl2);
    }

    private void initializeControls() {
        this.jResultTable.setModel((TableModel)((Object)this.getState().getProfitState().getLoadingProfitTableModel()));
        this.jResultTable.setSelectionMode(0);
        this.jTargetComb.setModel(new DefaultComboBoxModel<String>(new String[]{"Loading..."}));
        ListSelectionModel listSelectionModel = this.jResultTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ProfitTabPanel.this.jResultTableValueChanged(listSelectionEvent);
            }
        });
        this.enableControls(false);
    }

    public void jResultTableValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            int[] nArray = this.jResultTable.getSelectedRowsInModel();
            String string = (String)this.getState().getProfitState().getProfitTableModel().getValueAt(nArray[0], 0);
            this.getState().getShareState().setSelectTestResult(string);
            this.loadConfusionMatrix();
            this.loadTuneMatrix();
            this.enableControls(true);
        }
    }

    @Override
    protected final TuneState getState() {
        return (TuneState)super.getState();
    }

    @Override
    public void tabSelected() {
        if (this.getState().getProfitState().getProfitTableModel() == null) {
            return;
        }
        String string = this.getState().getShareState().getSelectTestResult();
        int n = 0;
        for (int i = 0; i < this.jResultTable.getRowCount(); ++i) {
            Object object = this.getState().getProfitState().getProfitTableModel().getValueAt(i, 0);
            if (!string.equals(object)) continue;
            n = i;
            break;
        }
        this.jResultTable.setRowSelectionInterval(n, n);
        this.loadTuneMatrix();
        this.enableControls(true);
    }

    @Override
    public void processInput() {
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jGraphSelection = new JPanel();
        this.jTargetLbl = new JLabel();
        this.jTargetComb = new JComboBox();
        this.jSettingsBtn = new JButton();
        this.jGraphPanel = new JPanel();
        this.jGraphControl = new JPanel();
        this.jQuantileSlider = new JSlider();
        this.jScrollPane1 = new JScrollPane();
        this.jCostMatrixPanel = new JPanel();
        this.jMatrixLbl = new JLabel();
        this.jScrollPane = new JScrollPane();
        this.jMatrixTable = new BaseCostMatrixTable();
        this.jLabel1 = new JLabel();
        this.jClearButton = new JButton();
        this.jTuneBtn = new JButton();
        this.jTuneSettingsLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jTuneMethodLabel = new JLabel();
        this.jTuneMethodValue = new JLabel();
        this.jTuneTargetLabel = new JLabel();
        this.jTuneTargetValue = new JLabel();
        this.jTuneCriteriaLabel = new JLabel();
        this.jTuneCriteriaValue = new JLabel();
        this.jTuneThresholdLabel = new JLabel();
        this.jTuneThresholdValue = new JLabel();
        this.jMatrixLbl1 = new JLabel();
        this.jCostMatrixBtn = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTuneMatrixTable = new BaseCostMatrixTable();
        this.jLabel7 = new JLabel();
        this.jProfitTablePanel = new TransparentPanel();
        this.jProfitToolbar = new ComponentWithTitlebar();
        this.setMinimumSize(new Dimension(750, 490));
        this.setPreferredSize(new Dimension(750, 490));
        this.jSplitPane1.setDividerLocation(360);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setName("jSplitPane1");
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane2.setDividerLocation(450);
        this.jSplitPane2.setName("jSplitPane2");
        this.jSplitPane2.setOneTouchExpandable(true);
        this.jPanel1.setName("jPanel1");
        this.jGraphSelection.setName("jGraphSelection");
        this.jTargetLbl.setText("Target Value:");
        this.jTargetLbl.setName("jTargetLbl");
        this.jTargetComb.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jTargetComb.setName("jTargetComb");
        this.jTargetComb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfitTabPanel.this.jTargetCombActionPerformed(actionEvent);
            }
        });
        this.jSettingsBtn.setText("Profit Settings...");
        this.jSettingsBtn.setName("jSettingsBtn");
        this.jSettingsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfitTabPanel.this.jSettingsBtnActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jGraphSelection);
        this.jGraphSelection.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 449, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTargetLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetComb, -2, 144, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 103, Short.MAX_VALUE).addComponent(this.jSettingsBtn).addContainerGap())));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 37, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(8, 8, 8).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLbl).addComponent(this.jSettingsBtn).addComponent(this.jTargetComb, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE))));
        this.jGraphPanel.setName("jGraphPanel");
        this.jGraphPanel.setLayout(new BorderLayout());
        this.jGraphControl.setName("jGraphControl");
        this.jGraphControl.setLayout(new GridBagLayout());
        this.jQuantileSlider.setName("jQuantileSlider");
        this.jQuantileSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ProfitTabPanel.this.jQuantileSliderStateChanged(changeEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        this.jGraphControl.add((Component)this.jQuantileSlider, gridBagConstraints);
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jGraphControl, -1, 449, Short.MAX_VALUE).addComponent(this.jGraphSelection, -1, -1, Short.MAX_VALUE).addComponent(this.jGraphPanel, -1, 449, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jGraphSelection, -2, 37, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jGraphPanel, -1, 285, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jGraphControl, -2, -1, -2)));
        this.jSplitPane2.setLeftComponent(this.jPanel1);
        this.jScrollPane1.setName("jScrollPane1");
        this.jCostMatrixPanel.setName("jCostMatrixPanel");
        this.jMatrixLbl.setText("Performance Matrix:");
        this.jMatrixLbl.setName("jMatrixLbl");
        this.jScrollPane.setName("jScrollPane");
        this.jScrollPane.setPreferredSize(new Dimension(450, 200));
        this.jMatrixTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jMatrixTable.setName("jMatrixTable");
        this.jMatrixTable.setRowSelectionAllowed(false);
        this.jScrollPane.setViewportView((Component)this.jMatrixTable);
        this.jLabel1.setText("Rows: Actual; Columns: Predicted");
        this.jLabel1.setName("jLabel1");
        this.jClearButton.setText("Clear");
        this.jClearButton.setName("jClearButton");
        this.jClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfitTabPanel.this.jClearButtonActionPerformed(actionEvent);
            }
        });
        this.jTuneBtn.setText("Tune");
        this.jTuneBtn.setName("jTuneBtn");
        this.jTuneBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfitTabPanel.this.jTuneBtnActionPerformed(actionEvent);
            }
        });
        this.jTuneSettingsLabel.setText("Tune Settings");
        this.jTuneSettingsLabel.setName("jTuneSettingsLabel");
        this.jSeparator1.setName("jSeparator1");
        this.jTuneMethodLabel.setText("Method:");
        this.jTuneMethodLabel.setName("jTuneMethodLabel");
        this.jTuneMethodValue.setText("Profit");
        this.jTuneMethodValue.setName("jTuneMethodValue");
        this.jTuneTargetLabel.setText("Target Value:");
        this.jTuneTargetLabel.setName("jTuneTargetLabel");
        this.jTuneTargetValue.setText("1");
        this.jTuneTargetValue.setName("jTuneTargetValue");
        this.jTuneCriteriaLabel.setText("Criteria:");
        this.jTuneCriteriaLabel.setName("jTuneCriteriaLabel");
        this.jTuneCriteriaValue.setText("Average Accuracy");
        this.jTuneCriteriaValue.setName("jTuneCriteriaValue");
        this.jTuneThresholdLabel.setText("Threshold:");
        this.jTuneThresholdLabel.setName("jTuneThresholdLabel");
        this.jTuneThresholdValue.setText("0.56789");
        this.jTuneThresholdValue.setName("jTuneThresholdValue");
        this.jMatrixLbl1.setText("Derived Cost Matrix:");
        this.jMatrixLbl1.setName("jMatrixLbl1");
        this.jCostMatrixBtn.setText("View...");
        this.jCostMatrixBtn.setName("jCostMatrixBtn");
        this.jCostMatrixBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfitTabPanel.this.jCostMatrixBtnActionPerformed(actionEvent);
            }
        });
        this.jScrollPane2.setName("jScrollPane2");
        this.jTuneMatrixTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTuneMatrixTable.setName("jTuneMatrixTable");
        this.jTuneMatrixTable.setRowSelectionAllowed(false);
        this.jScrollPane2.setViewportView((Component)this.jTuneMatrixTable);
        this.jLabel7.setText("Rows: Actual; Columns: Predicted");
        this.jLabel7.setName("jLabel7");
        GroupLayout groupLayout3 = new GroupLayout(this.jCostMatrixPanel);
        this.jCostMatrixPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(this.jMatrixLbl, GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(this.jTuneSettingsLabel, GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING, -1, 235, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jClearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTuneBtn)).addGroup(GroupLayout.Alignment.LEADING, groupLayout3.createSequentialGroup().addGap(71, 71, 71).addComponent(this.jTuneMethodValue).addGap(66, 66, 66)).addComponent(this.jTuneMethodLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTuneThresholdLabel).addComponent(this.jTuneTargetLabel).addComponent(this.jTuneCriteriaLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTuneTargetValue).addComponent(this.jTuneCriteriaValue).addComponent(this.jTuneThresholdValue))).addComponent(this.jLabel7, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout3.createSequentialGroup().addComponent(this.jMatrixLbl1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCostMatrixBtn))).addContainerGap(28, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jMatrixLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGap(43, 43, 43).addComponent(this.jTuneSettingsLabel)).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneBtn).addComponent(this.jClearButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneMethodLabel).addComponent(this.jTuneMethodValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneTargetLabel).addComponent(this.jTuneTargetValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneCriteriaLabel).addComponent(this.jTuneCriteriaValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneThresholdLabel).addComponent(this.jTuneThresholdValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMatrixLbl1).addComponent(this.jCostMatrixBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addContainerGap(-1, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.jCostMatrixPanel);
        this.jSplitPane2.setRightComponent(this.jScrollPane1);
        this.jSplitPane1.setTopComponent(this.jSplitPane2);
        this.jProfitTablePanel.setName("jProfitTablePanel");
        this.jProfitToolbar.setName("jProfitToolbar");
        GroupLayout groupLayout4 = new GroupLayout((Container)this.jProfitTablePanel);
        this.jProfitTablePanel.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jProfitToolbar, -1, 748, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jProfitToolbar, -1, 124, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent((Component)this.jProfitTablePanel);
        GroupLayout groupLayout5 = new GroupLayout(this);
        this.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 750, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 490, Short.MAX_VALUE));
    }

    private void jTargetCombActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        this.getState().getProfitState().setSelectedTargetValue((String)this.jTargetComb.getSelectedItem());
        this._loading = true;
        this.jGraphPanel.removeAll();
        this.jGraphPanel.add((Component)new JTextArea("Loading..."), "Center");
        this.jResultTable.setModel((TableModel)((Object)this.getState().getProfitState().getLoadingProfitTableModel()));
        this.enableControls(false);
        LoadUI loadUI = new LoadUI(UPDATE_GRAPH);
        loadUI.start();
    }

    private void jSettingsBtnActionPerformed(ActionEvent actionEvent) {
        ProfitInputDialog profitInputDialog = new ProfitInputDialog(this.getState().getProfitState());
        if (profitInputDialog.invoke()) {
            this._loading = true;
            this.enableControls(false);
            LoadUI loadUI = new LoadUI(UPDATE_GRAPH);
            loadUI.start();
        }
    }

    private void jClearButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.getState().getShareState().getSelectTestResult();
        this.getState().setTuningNone(string);
        int n = this.jResultTable.getSelectedRow();
        this.jResultTable.tableChanged(new TableModelEvent(this.jResultTable.getModel()));
        this.jResultTable.setRowSelectionInterval(n, n);
        this.loadTuneMatrix();
        this.enableControls(true);
    }

    private void jQuantileSliderStateChanged(ChangeEvent changeEvent) {
        if (this._loading) {
            return;
        }
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (jSlider.getValueIsAdjusting()) {
            return;
        }
        BoundedRangeModel boundedRangeModel = this.jQuantileSlider.getModel();
        Integer n = boundedRangeModel.getValue();
        n = Math.max(1, n);
        this.getState().getProfitState().setSelectedQuantileValue(n);
        this._loading = true;
        this.enableControls(false);
        LoadUI loadUI = new LoadUI(UPDATE_THRESHOLD);
        loadUI.start();
    }

    private void jCostMatrixBtnActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        String string = this.getState().getShareState().getSelectTestResult();
        boolean bl2 = this.getState().getBenefitState().getTuneBenefitWeight(string) != null;
        boolean bl3 = bl = this.getState().getCostState().getTuneCostMatrix(string) != null;
        if (bl2) {
            WeightsType weightsType = this.getState().getBenefitState().getTuneBenefitWeight(string);
            CostBenefitDetailDialog costBenefitDetailDialog = new CostBenefitDetailDialog(weightsType);
            costBenefitDetailDialog.invoke();
        } else if (bl) {
            CostMatrixInfo costMatrixInfo = this.getState().getCostState().getTuneCostMatrixInfo(string);
            CostMatrixDetailDialog costMatrixDetailDialog = new CostMatrixDetailDialog(costMatrixInfo);
            costMatrixDetailDialog.invoke();
        }
    }

    private void jTuneBtnActionPerformed(ActionEvent actionEvent) {
        int n = this.getState().getProfitState().getSelectedQuantileValue();
        String string = this.getState().getShareState().getSelectTestResult();
        ProfitTabState.ProfitData profitData = this.getState().getProfitState().getProfitData().get(string).get(n);
        double d = profitData._threshold;
        this.getState().getProfitState().setCustomThresholdValue(d);
        double d2 = 1.0E-6f;
        double d3 = d - d2 < 0.0 ? d : d - d2;
        double d4 = (1.0 - d3) / d3;
        String string2 = null;
        Object var14_10 = null;
        string2 = this.getState().getProfitState().getSelectedTargetValue();
        List<ProfitTabState.ProfitData> list = this.getState().getProfitState().getProfitData().get(string);
        int n2 = list.size();
        double d5 = list.get((int)(n2 - 1))._targetCum + list.get((int)(n2 - 1))._nonTargetCum;
        double d6 = list.get((int)n)._targetCum;
        double d7 = list.get((int)n)._nonTargetCum;
        double d8 = this.getState().getProfitState().getInc_revenue() * d6;
        double d9 = this.getState().getProfitState().getInc_cost() * (d6 + d7);
        double d10 = -1.0 * this.getState().getProfitState().getStartup_cost() + (d8 - d9) * this.getState().getProfitState().getPopulation() / d5;
        d8 = this.getState().getProfitState().getInc_revenue() * d6;
        d9 = this.getState().getProfitState().getInc_cost() * (d6 + d7);
        double d11 = (d8 - d9) / d9 * 100.0;
        CostMatrixType costMatrixType = new CostMatrixType();
        TuningType.Custom.Settings.Profit profit = new TuningType.Custom.Settings.Profit();
        profit.setPopulation(BigInteger.valueOf(n));
        profit.setProfit(d10);
        profit.setROI(d11);
        Vector<Object> vector = this.getState().getModelTargetValues();
        for (Object object : vector) {
            for (Object object2 : vector) {
                CostMatrixType.Item item = new CostMatrixType.Item();
                item.setActual(object.toString());
                item.setPredict(object2.toString());
                if (object.toString().compareTo(object2.toString()) == 0) {
                    item.setCost(0.0);
                } else if (object.toString().compareTo(string2) == 0 && object2.toString().compareTo(string2) != 0) {
                    item.setCost(d4);
                } else {
                    item.setCost(1.0);
                }
                costMatrixType.getItem().add(item);
            }
        }
        this.getState().setTuningCustom(string, string2, profit, costMatrixType);
        int n3 = this.jResultTable.getSelectedRow();
        this.jResultTable.tableChanged(new TableModelEvent(this.jResultTable.getModel()));
        this.jResultTable.setRowSelectionInterval(n3, n3);
        this.loadTuneMatrix();
        this.enableControls(true);
    }

    private void installProfitResultsActions(ControlBar controlBar) {
        _detailBtnIconEna = OracleIcons.getIcon((String)"lov.png");
        _detailBtnIconDis = OracleIcons.getIcon((String)"lov.png");
        this.jDetailBtn = new JButton(_detailBtnIconEna);
        this.jDetailBtn.setDisabledIcon(_detailBtnIconDis);
        this.jDetailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfitTabPanel.this.jDetailBtnActionPerformed(actionEvent);
            }
        });
        controlBar.add((Component)this.jDetailBtn);
    }

    private void jDetailBtnActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.jResultTable.getSelectedRowsInModel();
        String string = (String)this.getState().getProfitState().getProfitTableModel().getValueAt(nArray[0], 0);
        ProfitDetailDialog profitDetailDialog = new ProfitDetailDialog(string, this.getState().getProfitState(), this.getState().getProfitState().getProfitData().get(string));
        if (profitDetailDialog.invoke()) {
            // empty if block
        }
    }

    private void loadConfusionMatrix() {
        String string = this.getState().getShareState().getSelectTestResult();
        ProfitTabState.ProfitData profitData = null;
        String string2 = null;
        String string3 = null;
        if (string != null) {
            profitData = this.getState().getProfitState().getProfitData().get(string).get(this.getState().getProfitState().getSelectedQuantileValue());
            string2 = this.getState().getProfitState().getSelectedTargetValue();
            Vector<Object> vector = this.getState().getModelTargetValues();
            string3 = vector.size() == 2 ? (string2.compareTo(vector.firstElement().toString()) == 0 ? vector.lastElement().toString() : vector.firstElement().toString()) : TestViewerLrb.get("OTHER_TARGETS");
        }
        ((BaseCostMatrixTable)this.jMatrixTable).setModel(new TuneState.MatrixModel(new PerformanceMatrixDataProvider(string2, string3, profitData, this._percentageFormat)));
    }

    private void loadTuneMatrix() {
        String string = this.getState().getShareState().getSelectTestResult();
        if (this.getState().isTuningNone(string)) {
            this.jTuneMethodValue.setText(TuneState.TUNE_OPTION_NONE);
        } else if (this.getState().isTuningBenefit(string)) {
            this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_BENEFIT);
        } else if (this.getState().isTuningCost(string)) {
            this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_COST);
        } else if (this.getState().isTuningCustom(string)) {
            String string2 = null;
            TuneState.TuningCustomData tuningCustomData = this.getState().getTuningCustomData(string);
            String string3 = tuningCustomData.getTargetValue();
            Vector<Object> vector = this.getState().getModelTargetValues();
            this.jTuneTargetValue.setText(string3);
            Object object = tuningCustomData.getTuneType();
            CostMatrixType costMatrixType = tuningCustomData.getCostMatrix();
            if (object instanceof TuningType.Custom.Settings.ROC) {
                TuningType.Custom.Settings.ROC rOC = (TuningType.Custom.Settings.ROC)object;
                this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_ROC);
                ROCAccuracyType rOCAccuracyType = rOC.getAccuracy();
                if (rOCAccuracyType == ROCAccuracyType.CUSTOM_ACCURACY) {
                    TuningType.Custom.Settings.ROC.CustomThreshold customThreshold = rOC.getCustomThreshold();
                    String string4 = customThreshold.getType().value();
                    this.jTuneCriteriaValue.setText(rOCAccuracyType.value() + ", " + string4 + ": " + this._percentageFormat.format(customThreshold.getValue()));
                } else {
                    this.jTuneCriteriaValue.setText(rOCAccuracyType.value());
                }
                this.jTuneThresholdValue.setText(this._percentageFormat.format(rOC.getThreshold()));
            } else if (object instanceof TuningType.Custom.Settings.Lift) {
                TuningType.Custom.Settings.Lift lift = (TuningType.Custom.Settings.Lift)object;
                this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_LIFT);
                String string5 = lift.getType().value();
                this.jTuneCriteriaValue.setText("Quantile: " + lift.getQuantile() + " (" + string5 + ")");
                this.jTuneThresholdValue.setText(this._percentageFormat.format(lift.getThreshold()));
            } else if (object instanceof TuningType.Custom.Settings.Profit) {
                TuningType.Custom.Settings.Profit profit = (TuningType.Custom.Settings.Profit)object;
                this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_PROFIT);
                this.jTuneCriteriaValue.setText("Population: " + this._percentageFormat.format(profit.getPopulation()) + "%, ROI: " + this._percentageFormat.format(profit.getROI()) + "%");
                this.jTuneThresholdValue.setText(this._percentageFormat.format(profit.getProfit()));
            }
            string2 = vector.size() == 2 ? (string3.compareTo(vector.firstElement().toString()) == 0 ? vector.lastElement().toString() : vector.firstElement().toString()) : TestViewerLrb.get("OTHER_TARGETS");
            ((BaseCostMatrixTable)this.jTuneMatrixTable).setModel(new TuneState.MatrixModel(new TuneState.TuneMatrixDataProvider(string3, string2, costMatrixType, this._percentageFormat)));
        }
    }

    class CustomGenericTable
    extends GenericTableFixedColumns {
        private DateFormat _df = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        private Preferences _p = Preferences.getPreferences();
        private ModelViewerPreferenceSettings _prefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)this._p);
        private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._prefenceSettings.getPercentagePrecisionLevel(), 0, 0);
        private NumberFormat _numericalFormat = NumericFormat.getInstance(true, this._prefenceSettings.getNumericalPrecisionLevel(), 0, 0);

        CustomGenericTable() {
            this._percentageFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
            this._percentageFormat.setMinimumIntegerDigits(1);
            this._numericalFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
            this._numericalFormat.setMinimumIntegerDigits(1);
        }

        @Override
        public void addDynamicCellRenderers() {
            NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
            this.addCellRenderer(ProfitTabPanel.this.getState().getProfitState().getProfitTableModel().getColumnName(0), new CustomCellRenderer());
            this.addCellRenderer(ProfitTabPanel.this.getState().getProfitState().getProfitTableModel().getColumnName(2), numberCellRenderer);
            this.addCellRenderer(ProfitTabPanel.this.getState().getProfitState().getProfitTableModel().getColumnName(3), numberCellRenderer);
            this.addCellRenderer(ProfitTabPanel.this.getState().getProfitState().getProfitTableModel().getColumnName(4), numberCellRenderer);
            this.addCellRenderer(ProfitTabPanel.this.getState().getProfitState().getProfitTableModel().getColumnName(5), numberCellRenderer);
            this.addCellRenderer(ProfitTabPanel.this.getState().getProfitState().getProfitTableModel().getColumnName(6), numberCellRenderer);
            this.addCellRenderer(ProfitTabPanel.this.getState().getProfitState().getProfitTableModel().getColumnName(9), new DateCellRenderer2());
        }

        private String formatCellValue(Object object) {
            String string = null;
            if (object != null) {
                string = object instanceof Double ? this._percentageFormat.format((Double)object) : (object instanceof Integer ? this._numericalFormat.format(((Integer)object).intValue()) : (object instanceof BigDecimal ? this._numericalFormat.format(((BigDecimal)object).doubleValue()) : (object instanceof Date ? this._df.format(object) : object.toString())));
            }
            return string;
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = "";
            string = this.formatCellValue(object);
            return string;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string = "";
            Object object = null;
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            if (n == -1 || n2 == -1) {
                return null;
            }
            object = this.getValueAt(n, n2);
            string = this.formatCellValue(object);
            return string;
        }
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!(object instanceof String)) assert (false);
            String string = (String)object;
            Color color = ProfitTabPanel.this.getState().getProfitState().getParentTestViewerState().getTestResultGraphColor(string);
            this.setIcon((Icon)new ColorIcon(color));
            return component;
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        String _updatemode;

        public LoadUI(String string) {
            this._updatemode = string;
        }

        public LoadUI() {
            this._updatemode = ProfitTabPanel.UPDATE_ALL;
        }

        public Object construct() {
            try {
                if (this._updatemode.equals(ProfitTabPanel.UPDATE_THRESHOLD)) {
                    ProfitTabPanel.this.getState().getProfitState().refreshCustomThresholdData();
                    ProfitTabPanel.this._graphPanel.refreshGraph();
                } else if (this._updatemode.equals(ProfitTabPanel.UPDATE_GRAPH)) {
                    ProfitTabPanel.this.getState().getProfitState().refreshProfitData();
                    ProfitTabPanel.this._graphPanel.initGraph(ProfitTabPanel.this.getState().getProfitState().getProfitGraphModel());
                } else {
                    ProfitTabPanel.this.getState().getProfitState().load();
                    ProfitTabPanel.this._graphPanel.initGraph(ProfitTabPanel.this.getState().getProfitState().getProfitGraphModel());
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return ProfitTabPanel.this.getState().getProfitState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            int n = 1;
            try {
                if (this._success && this._ex == null) {
                    Object object;
                    ProfitTabPanel.this.jGraphPanel.removeAll();
                    ProfitTabPanel.this.jGraphPanel.add((Component)ProfitTabPanel.this._graphPanel, "Center");
                    ProfitTabPanel.this.jGraphPanel.updateUI();
                    String string = ProfitTabPanel.this.getState().getShareState().getSelectTestResult();
                    ProfitTabPanel.this.jResultTable.setFixedColumnCount(n);
                    ProfitTabPanel.this.jResultTable.setModel((TableModel)((Object)ProfitTabPanel.this.getState().getProfitState().getProfitTableModel()));
                    String string2 = ProfitTabPanel.this.getState().getProfitState().getProfitTableModel().getColumnName(0);
                    ProfitTabPanel.this.jResultTable.setFixedColumnPreferredWidth(string2, 175);
                    ProfitTabPanel.this.jResultTable.findOrCreateTableRowHeader(ProfitTabPanel.this.tscroller);
                    ProfitTabPanel.this.jResultTable.setSorted(true);
                    ProfitTabPanel.this.jResultTable.setAutoResizeMode(0);
                    ProfitTabPanel.this.jResultTable.addDynamicCellRenderers();
                    TableColumnModel tableColumnModel = ProfitTabPanel.this.jResultTable.getColumnModel();
                    tableColumnModel.getColumn(1 - n).setPreferredWidth(90);
                    tableColumnModel.getColumn(2 - n).setPreferredWidth(100);
                    tableColumnModel.getColumn(3 - n).setPreferredWidth(100);
                    tableColumnModel.getColumn(4 - n).setPreferredWidth(180);
                    tableColumnModel.getColumn(5 - n).setPreferredWidth(150);
                    tableColumnModel.getColumn(6 - n).setPreferredWidth(100);
                    tableColumnModel.getColumn(7 - n).setPreferredWidth(180);
                    tableColumnModel.getColumn(8 - n).setPreferredWidth(150);
                    tableColumnModel.getColumn(9 - n).setPreferredWidth(150);
                    ProfitTabPanel.this.jResultTable.setSelectionMode(0);
                    ProfitTabPanel.this.jResultTable.setColumnSelectorAvailable(true);
                    ProfitTabPanel.this.jResultTable.setShowToolTips(true);
                    ProfitTabPanel.this.jResultTable.setSortRetainsSelection(true);
                    ProfitTabPanel.this.jResultTable.setRowSelectionAllowed(true);
                    ProfitTabPanel.this.jResultTable.setCellRenderers();
                    ProfitTabPanel.this.jResultTable.setRowHeaderCellRenderers();
                    int n2 = 0;
                    if (string == null) {
                        double d = 0.0;
                        double d2 = 0.0;
                        for (int i = 0; i < ProfitTabPanel.this.jResultTable.getRowCount(); ++i) {
                            d = (Double)ProfitTabPanel.this.getState().getProfitState().getProfitTableModel().getValueAt(i, 5);
                            if (!(d2 < d)) continue;
                            d2 = d;
                            n2 = i;
                        }
                    } else {
                        for (int i = 0; i < ProfitTabPanel.this.jResultTable.getRowCount(); ++i) {
                            object = ProfitTabPanel.this.getState().getProfitState().getProfitTableModel().getValueAt(i, 0);
                            if (!string.equals(object)) continue;
                            n2 = i;
                        }
                    }
                    ProfitTabPanel.this.jResultTable.setRowSelectionInterval(n2, n2);
                    if (this._updatemode.equals(ProfitTabPanel.UPDATE_ALL)) {
                        ProfitTabPanel.this.jTargetComb.setModel(new DefaultComboBoxModel<String>(ProfitTabPanel.this.getState().getProfitState().getTargetValues()));
                        ProfitTabPanel.this.jTargetComb.setSelectedItem(ProfitTabPanel.this.getState().getProfitState().getSelectedTargetValue());
                        Integer n3 = new Integer(ProfitTabPanel.this.getState().getProfitState().getSelectedQuantileValue());
                        object = new Integer(0);
                        Integer n4 = new Integer(ProfitTabPanel.this.getState().getProfitState().getMaxQuantileCnt() - 1);
                        ProfitTabPanel.this.jQuantileSlider.setMajorTickSpacing(10);
                        ProfitTabPanel.this.jQuantileSlider.setMinorTickSpacing(1);
                        ProfitTabPanel.this.jQuantileSlider.setPaintTicks(true);
                        ProfitTabPanel.this.jQuantileSlider.setPaintLabels(true);
                        ProfitTabPanel.this.jQuantileSlider.setSnapToTicks(true);
                        ProfitTabPanel.this.jQuantileSlider.setModel(new DefaultBoundedRangeModel(n3, 0, (Integer)object, n4));
                    }
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), null, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
                }
                ProfitTabPanel.this.loadConfusionMatrix();
                ProfitTabPanel.this.enableControls(true);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                ProfitTabPanel.this._loading = false;
            }
        }
    }

    private class PerformanceMatrixDataProvider
    implements BaseCostMatrixDataProvider {
        private String _positiveTarget;
        private String _otherTarget;
        private ProfitTabState.ProfitData _data;
        private NumberFormat _percentageFormat;

        PerformanceMatrixDataProvider(String string, String string2, ProfitTabState.ProfitData profitData, NumberFormat numberFormat) {
            this._positiveTarget = string;
            this._otherTarget = string2;
            this._data = profitData;
            this._percentageFormat = numberFormat;
        }

        @Override
        public Object[] getTargetValues() {
            return new Object[]{this._positiveTarget, this._otherTarget};
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this._data == null) {
                return null;
            }
            if (n == 0 && n2 == 0) {
                return this._percentageFormat.format(this._data._targetCum);
            }
            if (n == 0 && n2 == 1) {
                return this._percentageFormat.format(this._data._nonTargetCum);
            }
            if (n == 1 && n2 == 0) {
                return this._percentageFormat.format(0.0);
            }
            if (n == 1 && n2 == 1) {
                return this._percentageFormat.format(0.0);
            }
            return "Undefined";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }
}

