/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.sample;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.GraphicalPreferencesSettings;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.sample.CustomDialog;
import oracle.dmt.dataminer.workflow.dialog.sample.DialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.sample.WorkflowSampleNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.SampleNode;
import oracle.dmt.dataminer.workflow.preferences.CacheSettingsPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SamplingSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.StratifiedType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Element;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class SettingsPanel
extends AbstractDialogPanel {
    private JEWTDialog _parentDlg;
    private WorkflowSampleNodePropertyProxyModel _propertyModel;
    private SamplingSettingsType _samplingSettings;
    private boolean _isAdjusting;
    private boolean _dirty;
    private GraphPanel _graphPanel;
    private GraphPanel _graphPanel2;
    private int _totalRows;
    private static String _num_rows = PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLE_SIZE_NUMROWS");
    private static String _percent = PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLE_SIZE_PERCENT");
    private static String[] _sampling_size = new String[]{_num_rows, _percent};
    private static String _random = PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLING_TYPE_RANDOM");
    private static String _stratified = PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLING_TYPE_STRATIFIED");
    private static String _topN = PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLING_TYPE_TOPN");
    private static String[] _sampling_type = new String[]{_random, _stratified, _topN};
    private static String[] _stratified_type = new String[]{ServerConstants.StratifiedTypeOption.toHuman(StratifiedType.ORIGINAL.value()), ServerConstants.StratifiedTypeOption.toHuman(StratifiedType.BALANCED.value()), ServerConstants.StratifiedTypeOption.toHuman(StratifiedType.CUSTOM.value())};
    private AttributeItem SELECT_A_CASEID;
    private AttributeItem SELECT_A_COLUMN;
    private static Preferences _p = Preferences.getPreferences();
    private CacheSettingsPanelSettings _cachePreffrences = CacheSettingsPanelSettings.getInstance((PropertyStorage)_p);
    private GraphicalPreferencesSettings graphPanelSettings = GraphicalPreferencesSettings.getInstance((PropertyStorage)_p);
    private String styleSelection = DefaultGraphDataModel.DEFAULT_GRAPH_STYLE;
    private int depthRadius = _DEPTH_RADIUS;
    private static int _DEPTH_RADIUS = 50;
    private static Icon _invalid_icon;
    private JComboBox jCaseIDComboBox;
    private JLabel jCaseIDLabel;
    private JSplitPane jChartSplitPane;
    private JComboBox jColumnComboBox;
    private JLabel jColumnLabel;
    private JComboBox jDistributionComboBox;
    private JLabel jDistributionLabel;
    private JLabel jHintLabel;
    private JPanel jOutputPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel jPercentLabel;
    private JSlider jPercentSlider;
    private JLabel jRowLabel;
    private JSpinner jRowSpinner;
    private JLabel jRunNodeViewStatsLabel;
    private JComboBox jSampleSizeComboBox;
    private JLabel jSampleSizeLabel;
    private JComboBox jSampleTypeComboBox;
    private JLabel jSampleTypeLabel;
    private JLabel jSeedLabel;
    private JTextField jSeedTextField;
    private JPanel jSourcePanel;
    private JSplitPane jSplitPane;
    private JButton jViewButton;

    public SettingsPanel(JEWTDialog jEWTDialog, Context context, SampleNode sampleNode) {
        super(context, sampleNode);
        this._parentDlg = jEWTDialog;
        this.init((SampleNode)this._data, null);
    }

    public SettingsPanel(PropertyModel propertyModel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for ColumnFilter node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.setMinimumSize(new Dimension(200, 400));
        this.init((SampleNode)this._data, propertyModel);
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("SAMPLE_SETTING_SAMPLE_SIZE"), this.jSampleSizeLabel);
        hashMap.put(DialogsLrb.get("SAMPLE_SETTING_PERCENT"), this.jPercentLabel);
        hashMap.put(DialogsLrb.get("SAMPLE_SETTING_ROWS"), this.jRowLabel);
        hashMap.put(DialogsLrb.get("SAMPLE_SETTING_SAMPLE_TYPE"), this.jSampleTypeLabel);
        hashMap.put(DialogsLrb.get("SAMPLE_SETTING_SEED"), this.jSeedLabel);
        hashMap.put(DialogsLrb.get("SAMPLE_SETTING_COLUMN"), this.jColumnLabel);
        hashMap.put(DialogsLrb.get("SAMPLE_SETTING_CASEID"), this.jCaseIDLabel);
        hashMap.put(DialogsLrb.get("SAMPLE_SETTING_DISTRIBUTION"), this.jDistributionLabel);
        hashMap.put(DialogsLrb.get("SAMPLE_SETTING_REPRODUCIBILITY_HINT"), this.jHintLabel);
        hashMap.put(DialogsLrb.get("SAMPLE_SETTING_VIEW_BTN"), this.jViewButton);
        hashMap.put(DialogsLrb.get("SAMPLE_SETTING_VIEW_STATS_HINT"), this.jRunNodeViewStatsLabel);
        UIResourceHelper.setComponentText(hashMap);
        Class<WorkflowEditor> clazz = WorkflowEditor.class;
        _invalid_icon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("USAGE_ATTRIBUTE_INVALID"));
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"sample_settings");
        this.jPercentSlider.setPaintTicks(true);
        this.jPercentSlider.setPaintLabels(true);
        this.jPercentSlider.setMajorTickSpacing(10);
        this.jPercentSlider.setMinorTickSpacing(1);
        this.jPercentSlider.setMinimum(0);
        this.jPercentSlider.setMaximum(100);
        this.jPercentSlider.setOpaque(false);
        this.jRowSpinner.setModel(new SpinnerNumberModel((Number)this._cachePreffrences.getNumberOfRows(), Integer.valueOf(1), null, (Number)1000));
        NumberTextField numberTextField = (NumberTextField)this.jSeedTextField;
        numberTextField.setDataType(Integer.class);
        numberTextField.setSigned(false);
        numberTextField.setLocale(this.getLocale());
        this.jSampleSizeComboBox.setModel(new DefaultComboBoxModel<String>(_sampling_size));
        this.jSampleTypeComboBox.setModel(new DefaultComboBoxModel<String>(_sampling_type));
        this.jDistributionComboBox.setModel(new DefaultComboBoxModel<String>(_stratified_type));
        AttributeType attributeType = new AttributeType();
        attributeType.setName(DialogsLrb.get("SAMPLE_SETTING_SELECT_A_CASEID"));
        attributeType.setDataType("String");
        this.SELECT_A_CASEID = new AttributeItem(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(DialogsLrb.get("SAMPLE_SETTING_SELECT_A_COLUMN"));
        attributeType.setDataType("String");
        this.SELECT_A_COLUMN = new AttributeItem(attributeType);
        this.refreshUI();
    }

    private boolean isPIMode() {
        return this._propertyModel != null;
    }

    private void init(SampleNode sampleNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowSampleNodePropertyProxyModel)propertyModel;
        this._dirty = false;
        SampleNodeType sampleNodeType = (SampleNodeType)sampleNode.getData();
        this._samplingSettings = (SamplingSettingsType)MetaDataHelper.copyMetadataObject(sampleNodeType.getSamplingSettings());
        this.styleSelection = this.graphPanelSettings.getGraphStyle();
        this.depthRadius = this.graphPanelSettings.getRadiusDepthValue();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowSampleNodePropertyProxyModel workflowSampleNodePropertyProxyModel = (WorkflowSampleNodePropertyProxyModel)propertyModel;
        Context context = workflowSampleNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        SampleNode sampleNode = (SampleNode)workflowNodeInspectorElement.getNode();
        if (sampleNode == null) {
            return;
        }
        this._propertyModel = (WorkflowSampleNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = sampleNode;
        this._dirty = false;
        SampleNodeType sampleNodeType = (SampleNodeType)sampleNode.getData();
        this._samplingSettings = (SamplingSettingsType)MetaDataHelper.copyMetadataObject(sampleNodeType.getSamplingSettings());
        this.refreshUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowSampleNodePropertyProxyModel)) {
            return null;
        }
        WorkflowSampleNodePropertyProxyModel workflowSampleNodePropertyProxyModel = (WorkflowSampleNodePropertyProxyModel)propertyModel;
        Context context = workflowSampleNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private SampleNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowSampleNodePropertyProxyModel)) {
            return null;
        }
        WorkflowSampleNodePropertyProxyModel workflowSampleNodePropertyProxyModel = (WorkflowSampleNodePropertyProxyModel)propertyModel;
        Context context = workflowSampleNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof SampleNodeType) {
            return (SampleNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    public Long getNumberOfRows() {
        Long l = null;
        if (this.jSampleSizeComboBox.getSelectedItem().equals(_num_rows)) {
            Integer n = (Integer)this.jRowSpinner.getValue();
            l = (long)n;
        }
        return l;
    }

    public Double getPercentOfTotal() {
        Double d = null;
        if (this.jSampleSizeComboBox.getSelectedItem().equals(_percent)) {
            d = this.jPercentSlider.getValue();
        }
        return d;
    }

    public StratifiedType getStratifiedType() {
        String string = null;
        if (this.jSampleTypeComboBox.getSelectedItem().equals(_stratified)) {
            string = (String)this.jDistributionComboBox.getSelectedItem();
        }
        return StratifiedType.fromValue((String)ServerConstants.StratifiedTypeOption.toSchema(string));
    }

    private void copySettings() {
        Object object;
        Number number;
        this._samplingSettings.setNumberOfRows(null);
        this._samplingSettings.setPercentOfTotal(null);
        if (this.jSampleSizeComboBox.getSelectedItem().equals(_num_rows)) {
            number = (Integer)this.jRowSpinner.getValue();
            object = (long)number.intValue();
            this._samplingSettings.setNumberOfRows((Long)object);
        } else {
            number = this.jPercentSlider.getValue();
            this._samplingSettings.setPercentOfTotal((Double)number);
        }
        number = new SamplingSettingsType.Method();
        if (this.jSampleTypeComboBox.getSelectedItem().equals(_random)) {
            object = new SamplingSettingsType.Method.Random();
            object.setSeed(BigInteger.valueOf(((NumberTextField)this.jSeedTextField).getNumber().longValue()));
            number.setRandom((SamplingSettingsType.Method.Random)object);
        } else if (this.jSampleTypeComboBox.getSelectedItem().equals(_stratified)) {
            object = this._samplingSettings.getMethod().getStratified();
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            AttributeStatus attributeStatus = AttributeStatus.INVALID;
            SamplingSettingsType.Method.Stratified.Distributions distributions = null;
            if (object != null) {
                string = object.getTargetAttr();
                string2 = object.getDataType();
                distributions = object.getDistributions();
            }
            SamplingSettingsType.Method.Stratified stratified = new SamplingSettingsType.Method.Stratified();
            stratified.setSeed(BigInteger.valueOf(((NumberTextField)this.jSeedTextField).getNumber().longValue()));
            AttributeItem attributeItem = (AttributeItem)this.jColumnComboBox.getSelectedItem();
            if (!attributeItem.equals(this.SELECT_A_COLUMN)) {
                string3 = attributeItem.getAttribute().getName();
                string4 = attributeItem.getAttribute().getDataType();
                attributeStatus = attributeItem.getAttribute().getStatus();
            }
            stratified.setTargetAttr(string3);
            stratified.setDataType(string4);
            stratified.setStatus(attributeStatus);
            String string5 = (String)this.jDistributionComboBox.getSelectedItem();
            stratified.setType(StratifiedType.fromValue((String)ServerConstants.StratifiedTypeOption.toSchema(string5)));
            if (ServerConstants.StratifiedTypeOption.isCustom(ServerConstants.StratifiedTypeOption.toSchema(string5)) && string != null && string3 != null && string.equals(string3) && string2 != null && string4 != null && string2.equals(string4)) {
                stratified.setDistributions(distributions);
            }
            if (stratified.getDistributions() == null) {
                stratified.setDistributions(new SamplingSettingsType.Method.Stratified.Distributions());
            }
            number.setStratified(stratified);
        } else {
            object = new SamplingSettingsType.Method.TopN();
            number.setTopN((SamplingSettingsType.Method.TopN)object);
        }
        this._samplingSettings.setMethod((SamplingSettingsType.Method)number);
        object = (AttributeItem)this.jCaseIDComboBox.getSelectedItem();
        if (((AttributeItem)object).equals(this.SELECT_A_CASEID)) {
            this._samplingSettings.setCaseAttribute(null);
        } else {
            this._samplingSettings.setCaseAttribute(((AttributeItem)object).getAttribute());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNode() {
        try {
            CommandProcessor.getInstance().beginTrans(DialogsLrb.get("SAMPLE_NODE_EDIT_TRANSACTION_NAME"));
            SampleNode sampleNode = (SampleNode)this.getData();
            SampleNodeType sampleNodeType = (SampleNodeType)sampleNode.getData();
            ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
            ComplexProperty complexProperty = new ComplexProperty("SamplingSettings", this._samplingSettings);
            complexProperty.setOldData(sampleNodeType.getSamplingSettings());
            arrayList.add(complexProperty);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
            odmrSDMUndoFilter.prepareUndoComplexPropertyList(sampleNode, this.getContext(), arrayList);
            sampleNode.validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("SAMPLE_NODE_EDIT_ERROR_MESG"), null);
            CommandProcessor.getInstance().abortTrans();
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    private void enableControls() {
        AttributeItem attributeItem;
        Object object;
        boolean bl = false;
        if (this.jSampleSizeComboBox.getSelectedItem().equals(_num_rows)) {
            this.jRowLabel.setVisible(true);
            this.jRowSpinner.setVisible(true);
            this.jPercentLabel.setVisible(false);
            this.jPercentSlider.setVisible(false);
        } else {
            this.jRowLabel.setVisible(false);
            this.jRowSpinner.setVisible(false);
            this.jPercentLabel.setVisible(true);
            this.jPercentSlider.setVisible(true);
        }
        if (this.jSampleTypeComboBox.getSelectedItem().equals(_random) || this.jSampleTypeComboBox.getSelectedItem().equals(_stratified)) {
            object = (AttributeItem)this.jCaseIDComboBox.getSelectedItem();
            if (!((AttributeItem)object).equals(this.SELECT_A_CASEID) && !((AttributeItem)object).getAttribute().getStatus().equals((Object)AttributeStatus.VALID)) {
                this.jCaseIDLabel.setIcon(_invalid_icon);
            } else {
                this.jCaseIDLabel.setIcon(null);
            }
            if (this.jSampleTypeComboBox.getSelectedItem().equals(_stratified)) {
                attributeItem = (AttributeItem)this.jColumnComboBox.getSelectedItem();
                if (attributeItem.equals(this.SELECT_A_COLUMN) || !attributeItem.getAttribute().getStatus().equals((Object)AttributeStatus.VALID)) {
                    this.jColumnLabel.setIcon(_invalid_icon);
                } else {
                    this.jColumnLabel.setIcon(null);
                }
            }
        }
        if (this.jSampleTypeComboBox.getSelectedItem().equals(_random)) {
            this.jSeedLabel.setVisible(true);
            this.jSeedTextField.setVisible(true);
            this.jCaseIDLabel.setVisible(true);
            this.jCaseIDComboBox.setVisible(true);
            this.jColumnLabel.setVisible(false);
            this.jColumnComboBox.setVisible(false);
            this.jDistributionLabel.setVisible(false);
            this.jDistributionComboBox.setVisible(false);
            this.jHintLabel.setVisible(true);
            this.jViewButton.setVisible(false);
            this.jSplitPane.setRightComponent(null);
            if (this._parentDlg != null) {
                this._parentDlg.setSize(475, 300);
            }
        } else if (this.jSampleTypeComboBox.getSelectedItem().equals(_stratified)) {
            this.jSeedLabel.setVisible(true);
            this.jSeedTextField.setVisible(true);
            this.jCaseIDLabel.setVisible(true);
            this.jCaseIDComboBox.setVisible(true);
            this.jColumnLabel.setVisible(true);
            this.jColumnComboBox.setVisible(true);
            this.jDistributionLabel.setVisible(true);
            this.jDistributionComboBox.setVisible(true);
            this.jHintLabel.setVisible(true);
            this.jViewButton.setVisible(true);
            object = (SampleNode)this.getData();
            attributeItem = (SampleNodeType)((AbstractNode)object).getData();
            String string = null;
            if (attributeItem.getStatisticTable() != null) {
                string = attributeItem.getStatisticTable().getColumn();
            }
            AttributeItem attributeItem2 = (AttributeItem)this.jColumnComboBox.getSelectedItem();
            String string2 = attributeItem2.toString();
            bl = string != null && string.equals(string2);
            this.jViewButton.setEnabled(bl);
            String string3 = (String)this.jDistributionComboBox.getSelectedItem();
            if (StratifiedType.fromValue((String)ServerConstants.StratifiedTypeOption.toSchema(string3)) == StratifiedType.CUSTOM) {
                this.jViewButton.setText(DialogsLrb.get("SAMPLE_SETTING_EDIT_BTN"));
            } else {
                this.jViewButton.setText(DialogsLrb.get("SAMPLE_SETTING_VIEW_BTN"));
            }
            this.jSplitPane.setRightComponent(null);
            if (this._parentDlg != null) {
                this.jSplitPane.setDividerLocation(250);
                this.jSplitPane.setRightComponent(this.jPanel2);
                this._parentDlg.setSize(475, 500);
            }
        } else if (this.jSampleTypeComboBox.getSelectedItem().equals(_topN)) {
            this.jSeedLabel.setVisible(false);
            this.jSeedTextField.setVisible(false);
            this.jCaseIDLabel.setVisible(false);
            this.jCaseIDComboBox.setVisible(false);
            this.jColumnLabel.setVisible(false);
            this.jColumnComboBox.setVisible(false);
            this.jDistributionLabel.setVisible(false);
            this.jDistributionComboBox.setVisible(false);
            this.jHintLabel.setVisible(false);
            this.jViewButton.setVisible(false);
            this.jSplitPane.setRightComponent(null);
            if (this._parentDlg != null) {
                this._parentDlg.setSize(475, 250);
            }
        }
        boolean bl2 = this.isWritable();
        this.jCaseIDComboBox.setEnabled(bl2);
        this.jColumnComboBox.setEnabled(bl2);
        this.jDistributionComboBox.setEnabled(bl2);
        this.jPercentSlider.setEnabled(bl2);
        this.jRowSpinner.setEnabled(bl2);
        this.jSampleSizeComboBox.setEnabled(bl2);
        this.jSampleTypeComboBox.setEnabled(bl2);
        this.jSeedTextField.setEnabled(bl2);
        this.jViewButton.setEnabled(bl && bl2);
    }

    public boolean doWork() {
        boolean bl = true;
        if (!this.isPIMode()) {
            this.copySettings();
            this.updateNode();
        }
        return bl;
    }

    public void refreshUI() {
        BigInteger bigInteger;
        Object object;
        this._isAdjusting = true;
        SampleNode sampleNode = (SampleNode)this.getData();
        List<AttributeType> list = sampleNode.getCaseAttributes();
        Collections.sort(list, new AttributeTypeComparator());
        this.jCaseIDComboBox.removeAllItems();
        this.jCaseIDComboBox.addItem(this.SELECT_A_CASEID);
        this.jColumnComboBox.removeAllItems();
        this.jColumnComboBox.addItem(this.SELECT_A_COLUMN);
        for (AttributeType object22 : list) {
            this.jCaseIDComboBox.addItem(new AttributeItem(object22));
            this.jColumnComboBox.addItem(new AttributeItem(object22));
        }
        Long l = this._samplingSettings.getNumberOfRows();
        Double d = this._samplingSettings.getPercentOfTotal();
        if (l == null) {
            this.jSampleSizeComboBox.setSelectedItem(_percent);
            this.jPercentSlider.setValue(d.intValue());
            object = MessageFormat.format(DialogsLrb.get("SAMPLE_SETTING_PERCENT"), d.intValue());
            this.jPercentLabel.setText((String)object);
        } else {
            this.jSampleSizeComboBox.setSelectedItem(_num_rows);
            this.jRowSpinner.setValue(l.intValue());
        }
        object = this._samplingSettings.getMethod();
        if (null != object.getRandom()) {
            this.jSampleTypeComboBox.setSelectedItem(_random);
            bigInteger = object.getRandom().getSeed();
            ((NumberTextField)this.jSeedTextField).setNumber((Number)bigInteger.intValue());
        } else if (null != object.getStratified()) {
            this.jSampleTypeComboBox.setSelectedItem(_stratified);
            bigInteger = object.getStratified().getSeed();
            ((NumberTextField)this.jSeedTextField).setNumber((Number)bigInteger.intValue());
        } else {
            this.jSampleTypeComboBox.setSelectedItem(_topN);
        }
        if (null != object.getRandom() || null != object.getStratified()) {
            AttributeItem attributeItem;
            bigInteger = this._samplingSettings.getCaseAttribute();
            if (bigInteger != null) {
                boolean string = false;
                for (int attributeItem2 = 0; attributeItem2 < this.jCaseIDComboBox.getItemCount(); ++attributeItem2) {
                    attributeItem = (AttributeItem)this.jCaseIDComboBox.getItemAt(attributeItem2);
                    if (!bigInteger.getName().equals(attributeItem.getAttribute().getName())) continue;
                    this.jCaseIDComboBox.setSelectedItem(attributeItem);
                    string = true;
                    break;
                }
                if (!string) {
                    AttributeItem string2 = new AttributeItem((AttributeType)bigInteger);
                    this.jCaseIDComboBox.addItem(string2);
                    this.jCaseIDComboBox.setSelectedItem(string2);
                }
            }
            if (null != object.getStratified()) {
                String string = this._samplingSettings.getMethod().getStratified().getTargetAttr();
                String string2 = this._samplingSettings.getMethod().getStratified().getDataType();
                attributeItem = this._samplingSettings.getMethod().getStratified().getStatus();
                if (string != null) {
                    AttributeItem attributeItem2;
                    boolean bl = false;
                    for (int attributeType = 0; attributeType < this.jColumnComboBox.getItemCount(); ++attributeType) {
                        attributeItem2 = (AttributeItem)this.jColumnComboBox.getItemAt(attributeType);
                        if (!string.equals(attributeItem2.getAttribute().getName())) continue;
                        this.jColumnComboBox.setSelectedItem(attributeItem2);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        AttributeType attributeType = new AttributeType();
                        attributeType.setName(string);
                        attributeType.setDataType(string2);
                        attributeType.setStatus((AttributeStatus)attributeItem);
                        attributeItem2 = new AttributeItem(attributeType);
                        this.jColumnComboBox.addItem(attributeItem2);
                        this.jColumnComboBox.setSelectedItem(attributeItem2);
                    }
                }
                this.jDistributionComboBox.setSelectedItem(ServerConstants.StratifiedTypeOption.toHuman(this._samplingSettings.getMethod().getStratified().getType().value()));
            }
        }
        this._isAdjusting = false;
        this.refreshGraphs();
        this.enableControls();
    }

    void refreshGraphs() {
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(DialogsLrb.get("SAMPLE_SETTING_VIEW_STATS_HINT")));
        this.jSourcePanel.add((Component)jPanel, "Center");
        if (this.jSampleTypeComboBox.getSelectedItem().equals(_stratified) && !this.isPIMode()) {
            boolean bl;
            this.jSourcePanel.removeAll();
            this.jSourcePanel.setLayout(new BorderLayout(0, 0));
            SampleNode sampleNode = (SampleNode)this.getData();
            SampleNodeType sampleNodeType = (SampleNodeType)sampleNode.getData();
            String string = null;
            if (sampleNodeType.getStatisticTable() != null) {
                string = sampleNodeType.getStatisticTable().getColumn();
            }
            AttributeItem attributeItem = (AttributeItem)this.jColumnComboBox.getSelectedItem();
            String string2 = attributeItem.toString();
            boolean bl2 = bl = string != null && string.equals(string2);
            if (bl) {
                Object object;
                TreeMap<String, Integer> treeMap = sampleNode.getStatisticLookupMap();
                DefaultGraphDataModel defaultGraphDataModel = new DefaultGraphDataModel(null, 17, null, null, null);
                defaultGraphDataModel.setDepthRadius(this.depthRadius);
                defaultGraphDataModel.setStyleSelection(this.styleSelection);
                Set<String> set = treeMap.keySet();
                Iterator<String> iterator = set.iterator();
                Object[] objectArray = new Object[treeMap.size()];
                Object[] objectArray2 = null;
                Object[][] objectArray3 = null;
                defaultGraphDataModel.clear();
                defaultGraphDataModel.setGraphType(17);
                objectArray3 = new Object[treeMap.size()][1];
                objectArray2 = new Object[1];
                this._totalRows = 0;
                int n = 0;
                double d = 0.0;
                while (iterator.hasNext()) {
                    objectArray[n] = object = iterator.next();
                    Integer n2 = treeMap.get(object);
                    if (n2.doubleValue() > d) {
                        d = n2.doubleValue();
                    }
                    objectArray2[0] = DialogsLrb.get("SAMPLE_SETTING_GRAPH_COLUMN_VALUES");
                    objectArray3[n][0] = n2;
                    defaultGraphDataModel.setTitle(DialogsLrb.get("SAMPLE_SETTING_GRAPH_SOURCE"));
                    ++n;
                    this._totalRows += n2.intValue();
                }
                defaultGraphDataModel.addRowLabels(objectArray2);
                defaultGraphDataModel.addColumnLabels(objectArray);
                defaultGraphDataModel.addGraphData(objectArray3);
                defaultGraphDataModel.setY1(DialogsLrb.get("SAMPLE_SETTING_GRAPH_COUNT"), d);
                this._graphPanel = new GraphPanel(defaultGraphDataModel);
                this._graphPanel.initGraph();
                this.jSourcePanel.add((Component)this._graphPanel, "Center");
                object = new JPanel();
                ((Container)object).add(new JLabel(DialogsLrb.get("SAMPLE_TOTAL_ROWS") + this._totalRows));
                this.jSourcePanel.add((Component)object, "South");
                this.jSourcePanel.updateUI();
            } else {
                this.jSourcePanel.add((Component)jPanel, "Center");
            }
        }
        this.refreshOutputGraph();
    }

    void refreshOutputGraph() {
        JPanel jPanel = new JPanel();
        this.jOutputPanel.add((Component)jPanel, "Center");
        if (this.jSampleTypeComboBox.getSelectedItem().equals(_stratified) && !this.isPIMode()) {
            boolean bl;
            this.jOutputPanel.removeAll();
            this.jOutputPanel.setLayout(new BorderLayout(0, 0));
            SampleNode sampleNode = (SampleNode)this.getData();
            SampleNodeType sampleNodeType = (SampleNodeType)sampleNode.getData();
            String string = null;
            if (sampleNodeType.getStatisticTable() != null) {
                string = sampleNodeType.getStatisticTable().getColumn();
            }
            AttributeItem attributeItem = (AttributeItem)this.jColumnComboBox.getSelectedItem();
            String string2 = attributeItem.toString();
            boolean bl2 = bl = string != null && string.equals(string2);
            if (bl) {
                Object object;
                Object object2;
                Long l = null;
                Double d = null;
                if (this.jSampleSizeComboBox.getSelectedItem().equals(_num_rows)) {
                    object2 = (Integer)this.jRowSpinner.getValue();
                    l = (Integer)object2;
                } else {
                    d = this.jPercentSlider.getValue();
                }
                object2 = (String)this.jDistributionComboBox.getSelectedItem();
                boolean bl3 = StratifiedType.fromValue((String)ServerConstants.StratifiedTypeOption.toSchema((String)object2)) == StratifiedType.BALANCED;
                SamplingSettingsType.Method.Stratified.Distributions distributions = null;
                object2 = (String)this.jDistributionComboBox.getSelectedItem();
                if (StratifiedType.fromValue((String)ServerConstants.StratifiedTypeOption.toSchema((String)object2)) == StratifiedType.CUSTOM) {
                    distributions = this._samplingSettings.getMethod().getStratified().getDistributions();
                }
                TreeMap<String, Integer> treeMap = sampleNode.getStratifiedSampledDistribution(l, d, bl3, distributions);
                this.jOutputPanel.removeAll();
                this.jOutputPanel.setLayout(new BorderLayout());
                DefaultGraphDataModel defaultGraphDataModel = new DefaultGraphDataModel(null, 17, null, null, null);
                defaultGraphDataModel.setDepthRadius(this.depthRadius);
                defaultGraphDataModel.setStyleSelection(this.styleSelection);
                Set<String> set = treeMap.keySet();
                Iterator<String> iterator = set.iterator();
                Object[] objectArray = new Object[treeMap.size()];
                Object[] objectArray2 = null;
                Object[][] objectArray3 = null;
                defaultGraphDataModel.clear();
                defaultGraphDataModel.setGraphType(17);
                objectArray3 = new Object[treeMap.size()][1];
                objectArray2 = new Object[1];
                int n = 0;
                int n2 = 0;
                double d2 = 0.0;
                while (iterator.hasNext()) {
                    objectArray[n] = object = iterator.next();
                    Integer n3 = treeMap.get(object);
                    if (n3.doubleValue() > d2) {
                        d2 = n3.doubleValue();
                    }
                    objectArray2[0] = DialogsLrb.get("SAMPLE_SETTING_GRAPH_COLUMN_VALUES");
                    objectArray3[n][0] = n3;
                    defaultGraphDataModel.setTitle(DialogsLrb.get("SAMPLE_SETTING_GRAPH_OUTPUT"));
                    ++n;
                    n2 += n3.intValue();
                }
                defaultGraphDataModel.addRowLabels(objectArray2);
                defaultGraphDataModel.addColumnLabels(objectArray);
                defaultGraphDataModel.addGraphData(objectArray3);
                defaultGraphDataModel.setY1(DialogsLrb.get("SAMPLE_SETTING_GRAPH_COUNT"), d2);
                this._graphPanel2 = new GraphPanel(defaultGraphDataModel);
                this._graphPanel2.initGraph();
                this.jOutputPanel.add((Component)this._graphPanel2, "Center");
                object = new JPanel();
                double d3 = 0.0;
                if (this._totalRows > 0) {
                    d3 = (double)n2 / (double)this._totalRows;
                }
                ((Container)object).add(new JLabel(DialogsLrb.get("SAMPLE_TOTAL_SAMPLE") + n2 + " (" + NumericFormat.format(d3 * 100.0, true, 2) + DialogsLrb.get("SAMPLE_PERCENT_OF_ORIGINAL") + ")"));
                this.jOutputPanel.add((Component)object, "South");
                this.jOutputPanel.updateUI();
            }
        }
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jSampleSizeLabel = new JLabel();
        this.jPercentLabel = new JLabel();
        this.jRowLabel = new JLabel();
        this.jSampleTypeLabel = new JLabel();
        this.jSeedLabel = new JLabel();
        this.jColumnLabel = new JLabel();
        this.jCaseIDLabel = new JLabel();
        this.jDistributionLabel = new JLabel();
        this.jDistributionComboBox = new JComboBox();
        this.jHintLabel = new JLabel();
        this.jColumnComboBox = new JComboBox();
        this.jSampleTypeComboBox = new JComboBox();
        this.jSampleSizeComboBox = new JComboBox();
        this.jPercentSlider = new JSlider();
        this.jRowSpinner = new JSpinner();
        this.jSeedTextField = new NumberTextField();
        this.jCaseIDComboBox = new JComboBox();
        this.jViewButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jChartSplitPane = new JSplitPane();
        this.jSourcePanel = new JPanel();
        this.jRunNodeViewStatsLabel = new JLabel();
        this.jOutputPanel = new JPanel();
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(450, 250));
        this.jSplitPane.setBorder(null);
        this.jSplitPane.setDividerLocation(250);
        this.jSplitPane.setDividerSize(0);
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setName("jSplitPane");
        this.jSplitPane.setOpaque(false);
        this.jSplitPane.setPreferredSize(new Dimension(450, 375));
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setOpaque(false);
        this.jPanel1.setPreferredSize(new Dimension(450, 275));
        this.jSampleSizeLabel.setText("Sample Size:");
        this.jSampleSizeLabel.setName("jSampleSizeLabel");
        this.jPercentLabel.setText("Percent (100%):");
        this.jPercentLabel.setName("jPercentLabel");
        this.jRowLabel.setText("Rows:");
        this.jRowLabel.setMaximumSize(new Dimension(82, 14));
        this.jRowLabel.setMinimumSize(new Dimension(82, 14));
        this.jRowLabel.setName("jRowLabel");
        this.jRowLabel.setPreferredSize(new Dimension(82, 14));
        this.jSampleTypeLabel.setText("Sample Type:");
        this.jSampleTypeLabel.setMaximumSize(new Dimension(82, 14));
        this.jSampleTypeLabel.setMinimumSize(new Dimension(82, 14));
        this.jSampleTypeLabel.setName("jSampleTypeLabel");
        this.jSampleTypeLabel.setPreferredSize(new Dimension(82, 14));
        this.jSeedLabel.setText("Seed:");
        this.jSeedLabel.setMaximumSize(new Dimension(82, 14));
        this.jSeedLabel.setMinimumSize(new Dimension(82, 14));
        this.jSeedLabel.setName("jSeedLabel");
        this.jSeedLabel.setPreferredSize(new Dimension(82, 14));
        this.jColumnLabel.setText("Column:");
        this.jColumnLabel.setMaximumSize(new Dimension(82, 14));
        this.jColumnLabel.setMinimumSize(new Dimension(82, 14));
        this.jColumnLabel.setName("jColumnLabel");
        this.jColumnLabel.setPreferredSize(new Dimension(82, 14));
        this.jCaseIDLabel.setText("Case ID:");
        this.jCaseIDLabel.setMaximumSize(new Dimension(82, 14));
        this.jCaseIDLabel.setMinimumSize(new Dimension(82, 14));
        this.jCaseIDLabel.setName("jCaseIDLabel");
        this.jCaseIDLabel.setPreferredSize(new Dimension(82, 14));
        this.jDistributionLabel.setText("Distribution:");
        this.jDistributionLabel.setMaximumSize(new Dimension(82, 14));
        this.jDistributionLabel.setMinimumSize(new Dimension(82, 14));
        this.jDistributionLabel.setName("jDistributionLabel");
        this.jDistributionLabel.setPreferredSize(new Dimension(82, 14));
        this.jDistributionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Original", "Equal", "Custom"}));
        this.jDistributionComboBox.setName("jDistributionComboBox");
        this.jDistributionComboBox.setPreferredSize(new Dimension(215, 20));
        this.jDistributionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jDistributionComboBoxActionPerformed(actionEvent);
            }
        });
        this.jHintLabel.setText("(Supply Seed and Case ID for Reproducibility)");
        this.jHintLabel.setName("jHintLabel");
        this.jColumnComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"01234567890123456789012345678901"}));
        this.jColumnComboBox.setName("jColumnComboBox");
        this.jColumnComboBox.setPreferredSize(new Dimension(215, 20));
        this.jColumnComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jColumnComboBoxActionPerformed(actionEvent);
            }
        });
        this.jSampleTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Random", "Top N", "Stratified"}));
        this.jSampleTypeComboBox.setName("jSampleTypeComboBox");
        this.jSampleTypeComboBox.setPreferredSize(new Dimension(215, 20));
        this.jSampleTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jSampleTypeComboBoxActionPerformed(actionEvent);
            }
        });
        this.jSampleSizeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Number of Rows", "Percent"}));
        this.jSampleSizeComboBox.setName("jSampleSizeComboBox");
        this.jSampleSizeComboBox.setPreferredSize(new Dimension(215, 20));
        this.jSampleSizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jSampleSizeComboBoxActionPerformed(actionEvent);
            }
        });
        this.jPercentSlider.setPaintTicks(true);
        this.jPercentSlider.setName("jPercentSlider");
        this.jPercentSlider.setOpaque(false);
        this.jPercentSlider.setPreferredSize(new Dimension(215, 31));
        this.jPercentSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanel.this.jPercentSliderStateChanged(changeEvent);
            }
        });
        this.jPercentSlider.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SettingsPanel.this.jPercentSliderFocusLost(focusEvent);
            }
        });
        this.jRowSpinner.setName("jRowSpinner");
        this.jRowSpinner.setPreferredSize(new Dimension(100, 20));
        this.jRowSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanel.this.jRowSpinnerStateChanged(changeEvent);
            }
        });
        this.jRowSpinner.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SettingsPanel.this.jRowSpinnerFocusLost(focusEvent);
            }
        });
        this.jSeedTextField.setName("jSeedTextField");
        this.jSeedTextField.setPreferredSize(new Dimension(100, 20));
        this.jSeedTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SettingsPanel.this.jSeedTextFieldFocusLost(focusEvent);
            }
        });
        this.jCaseIDComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCaseIDComboBox.setName("jCaseIDComboBox");
        this.jCaseIDComboBox.setPreferredSize(new Dimension(215, 20));
        this.jCaseIDComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jCaseIDComboBoxActionPerformed(actionEvent);
            }
        });
        this.jViewButton.setText("View");
        this.jViewButton.setHorizontalAlignment(2);
        this.jViewButton.setName("jViewButton");
        this.jViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jViewButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSeedLabel, -2, -1, -2).addComponent(this.jDistributionLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jCaseIDLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jColumnLabel, -2, -1, -2)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPercentLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jSampleTypeLabel, GroupLayout.Alignment.LEADING, -2, -1, -2)).addComponent(this.jRowLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPercentSlider, -2, -1, -2).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addComponent(this.jSampleSizeLabel, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSampleSizeComboBox, -2, -1, -2).addComponent(this.jRowSpinner, -2, 115, -2).addComponent(this.jSampleTypeComboBox, -2, -1, -2).addComponent(this.jColumnComboBox, -2, -1, -2).addComponent(this.jSeedTextField, -2, -1, -2).addComponent(this.jCaseIDComboBox, -2, -1, -2).addComponent(this.jHintLabel, -1, 276, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jDistributionComboBox, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jViewButton))).addGap(52, 52, 52)))));
        groupLayout.linkSize(0, this.jCaseIDComboBox, this.jColumnComboBox, this.jDistributionComboBox, this.jSampleSizeComboBox, this.jSampleTypeComboBox);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSampleSizeLabel).addComponent(this.jSampleSizeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRowLabel, -2, -1, -2).addComponent(this.jRowSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPercentSlider, -2, 43, -2).addComponent(this.jPercentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSampleTypeLabel, -2, -1, -2).addComponent(this.jSampleTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jColumnLabel, -2, -1, -2).addComponent(this.jColumnComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSeedLabel, -2, -1, -2).addComponent(this.jSeedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCaseIDLabel, -2, -1, -2).addComponent(this.jCaseIDComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jHintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jDistributionLabel, -2, -1, -2).addComponent(this.jDistributionComboBox, -2, -1, -2).addComponent(this.jViewButton)).addGap(41, 41, 41)));
        this.jSplitPane.setTopComponent(this.jPanel1);
        this.jPanel2.setName("jPanel2");
        this.jPanel2.setOpaque(false);
        this.jPanel2.setPreferredSize(new Dimension(450, 97));
        this.jChartSplitPane.setBorder(null);
        this.jChartSplitPane.setDividerLocation(225);
        this.jChartSplitPane.setDividerSize(0);
        this.jChartSplitPane.setResizeWeight(0.5);
        this.jChartSplitPane.setLastDividerLocation(225);
        this.jChartSplitPane.setName("jChartSplitPane");
        this.jChartSplitPane.setOpaque(false);
        this.jChartSplitPane.setPreferredSize(new Dimension(450, 36));
        this.jSourcePanel.setName("jSourcePanel");
        this.jSourcePanel.setOpaque(false);
        this.jSourcePanel.setPreferredSize(new Dimension(225, 36));
        this.jRunNodeViewStatsLabel.setText("Run Node to View Statistics");
        this.jRunNodeViewStatsLabel.setName("jRunNodeViewStatsLabel");
        GroupLayout groupLayout2 = new GroupLayout(this.jSourcePanel);
        this.jSourcePanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jRunNodeViewStatsLabel).addContainerGap(84, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jRunNodeViewStatsLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.jChartSplitPane.setLeftComponent(this.jSourcePanel);
        this.jOutputPanel.setName("jOutputPanel");
        this.jOutputPanel.setOpaque(false);
        this.jOutputPanel.setPreferredSize(new Dimension(225, 36));
        GroupLayout groupLayout3 = new GroupLayout(this.jOutputPanel);
        this.jOutputPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 224, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 36, Short.MAX_VALUE));
        this.jChartSplitPane.setRightComponent(this.jOutputPanel);
        GroupLayout groupLayout4 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jChartSplitPane, -1, 449, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jChartSplitPane, -1, 36, Short.MAX_VALUE));
        this.jSplitPane.setRightComponent(this.jPanel2);
        GroupLayout groupLayout5 = new GroupLayout(this);
        this.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, -1, 449, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, -1, 306, Short.MAX_VALUE));
    }

    private void jColumnComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._isAdjusting) {
            return;
        }
        if (this.isPIMode()) {
            this.copySettings();
            this.updateNode();
        }
        this.refreshGraphs();
        this.enableControls();
    }

    private void jSampleSizeComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._isAdjusting) {
            return;
        }
        if (this.jSampleSizeComboBox.getSelectedItem().equals(_num_rows)) {
            Long l = this._samplingSettings.getNumberOfRows();
            if (l == null) {
                l = this._cachePreffrences.getNumberOfRows();
            }
            this.jRowSpinner.setValue(l.intValue());
        } else {
            Double d = this._samplingSettings.getPercentOfTotal();
            if (d == null) {
                d = this._cachePreffrences.getPercentValue();
            }
            this.jPercentSlider.setValue(d.intValue());
        }
        if (this.isPIMode()) {
            this.copySettings();
            this.updateNode();
        }
        this.refreshOutputGraph();
        this.enableControls();
    }

    private void jSampleTypeComboBoxActionPerformed(ActionEvent actionEvent) {
        String string;
        if (this._isAdjusting) {
            return;
        }
        SamplingSettingsType.Method method = this._samplingSettings.getMethod();
        BigInteger bigInteger = null;
        if (this.jSampleTypeComboBox.getSelectedItem().equals(_random)) {
            if (method.getRandom() != null) {
                bigInteger = method.getRandom().getSeed();
            }
        } else if (null != method.getStratified() && method.getStratified() != null) {
            bigInteger = method.getStratified().getSeed();
        }
        int n = bigInteger == null ? this._cachePreffrences.getSeed() : bigInteger.intValue();
        ((NumberTextField)this.jSeedTextField).setNumber((Number)n);
        if (null != method.getStratified() && (string = this._samplingSettings.getMethod().getStratified().getType().value()) == null) {
            this.jDistributionComboBox.setSelectedItem(ServerConstants.StratifiedTypeOption.toHuman(StratifiedType.ORIGINAL.value()));
        }
        if (this.isPIMode()) {
            this.copySettings();
            this.updateNode();
        }
        this.refreshOutputGraph();
        this.enableControls();
    }

    private void jCaseIDComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._isAdjusting) {
            return;
        }
        if (this.isPIMode()) {
            this.copySettings();
            this.updateNode();
        }
        this.enableControls();
    }

    private void jDistributionComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._isAdjusting) {
            return;
        }
        String string = (String)this.jDistributionComboBox.getSelectedItem();
        if (StratifiedType.fromValue((String)ServerConstants.StratifiedTypeOption.toSchema(string)) == StratifiedType.CUSTOM) {
            SampleNode sampleNode = (SampleNode)this.getData();
            if (!sampleNode.getStatisticLookupMap().isEmpty()) {
                SamplingSettingsType.Method.Stratified.Distributions distributions = this._samplingSettings.getMethod().getStratified().getDistributions();
                if (distributions == null || distributions.getDistribution().size() == 0) {
                    SampleNode sampleNode2 = (SampleNode)this.getData();
                    CustomDialog customDialog = new CustomDialog();
                    boolean bl = false;
                    bl = this.isPIMode() ? customDialog.invoke((PropertyModel)this._propertyModel, this) : customDialog.invoke(this.getContext(), sampleNode2, this);
                    if (!bl) {
                        this.jDistributionComboBox.setSelectedItem(ServerConstants.StratifiedTypeOption.toHuman(this._samplingSettings.getMethod().getStratified().getType().value()));
                    }
                }
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("SAMPLE_SETTING_CUSTOM_ERR_MSG"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                this.jDistributionComboBox.setSelectedItem(ServerConstants.StratifiedTypeOption.toHuman(StratifiedType.ORIGINAL.value()));
            }
        } else if (this.isPIMode()) {
            this.copySettings();
            this.updateNode();
        }
        this.refreshOutputGraph();
        this.enableControls();
    }

    private void jSeedTextFieldFocusLost(FocusEvent focusEvent) {
        if (this._isAdjusting) {
            return;
        }
        if (this.isPIMode()) {
            this.copySettings();
            this.updateNode();
        }
    }

    private void jPercentSliderFocusLost(FocusEvent focusEvent) {
        if (this._isAdjusting) {
            return;
        }
        if (this.isPIMode()) {
            this.copySettings();
            this.updateNode();
        }
        this.refreshOutputGraph();
    }

    private void jRowSpinnerFocusLost(FocusEvent focusEvent) {
        if (this._isAdjusting) {
            return;
        }
        if (this.isPIMode()) {
            this.copySettings();
            this.updateNode();
        }
        this.refreshOutputGraph();
    }

    private void jViewButtonActionPerformed(ActionEvent actionEvent) {
        SampleNode sampleNode = (SampleNode)this.getData();
        CustomDialog customDialog = new CustomDialog();
        if (this.isPIMode()) {
            customDialog.invoke((PropertyModel)this._propertyModel, this);
        } else {
            customDialog.invoke(this.getContext(), sampleNode, this);
        }
        this.refreshOutputGraph();
    }

    private void jRowSpinnerStateChanged(ChangeEvent changeEvent) {
        if (this._isAdjusting) {
            return;
        }
        if (this.isPIMode()) {
            this.copySettings();
            this.updateNode();
        }
        this.refreshOutputGraph();
    }

    private void jPercentSliderStateChanged(ChangeEvent changeEvent) {
        if (this._isAdjusting) {
            return;
        }
        if (this.isPIMode()) {
            this.copySettings();
            this.updateNode();
        }
        this.refreshOutputGraph();
        Double d = this.jPercentSlider.getValue();
        String string = MessageFormat.format(DialogsLrb.get("SAMPLE_SETTING_PERCENT"), d.intValue());
        this.jPercentLabel.setText(string);
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public SamplingSettingsType getSamplingSettings() {
        return this._samplingSettings;
    }

    public void setSamplingSettings(SamplingSettingsType samplingSettingsType) {
        this._samplingSettings = samplingSettingsType;
    }

    private class AttributeItem {
        AttributeType _attribute;

        public AttributeItem(AttributeType attributeType) {
            this._attribute = attributeType;
        }

        public String toString() {
            return this._attribute.getAlias() == null ? this._attribute.getName() : this._attribute.getAlias();
        }

        public boolean equals(AttributeItem attributeItem) {
            return this._attribute.getName().equals(attributeItem.getAttribute().getName()) && this._attribute.getDataType().equals(attributeItem.getAttribute().getDataType());
        }

        public AttributeType getAttribute() {
            return this._attribute;
        }
    }

    private class AttributeTypeComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object != null && object instanceof AttributeType && object2 != null && object2 instanceof AttributeType) {
                return ((AttributeType)object).getName().compareTo(((AttributeType)object2).getName());
            }
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return object != null && object instanceof AttributeTypeComparator;
        }
    }
}

