/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.rowFilter;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.JTextComponent;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.expressionbuilder.ExpressionBuilderDialog;
import oracle.dmt.dataminer.expressionbuilder.Filter2DContext;
import oracle.dmt.dataminer.teditor.sql.SQLEditorLrb;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.rowFilter.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.rowFilter.RowFilterEditorPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.rowFilter.RowFilterNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.rowFilter.RowFilterPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.rowFilter.WorkflowRowFilterNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.RowFilterNode;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RowFilterNodeType;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.TextComponentSearchSupport;

public class FilterPanel
extends AbstractDialogPanel {
    private WorkflowRowFilterNodePropertyProxyModel _propertyModel;
    private RowFilterEditorPanel _parent;
    protected String _filter;
    protected JButton _removeBtn;
    protected JButton _addBtn;
    protected boolean _dirty = false;
    protected SearchField _jFilterCtl = new SearchField();
    protected Component _findPane;
    protected TextComponentSearchSupport _textSearchComponent;
    private ComponentWithTitlebar<JComponent> filterComponentWithTitlebar;
    private TransparentPanel filterTransparentPanel;
    protected JTextPane _filterTextArea = new JTextPane();

    public FilterPanel(Context context, AbstractNode abstractNode) {
        super(context, abstractNode);
    }

    public FilterPanel(PropertyModel propertyModel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for join node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.setMinimumSize(new Dimension(200, 400));
        this.init((RowFilterNode)this._data, propertyModel);
    }

    public FilterPanel(Context context, RowFilterNode rowFilterNode, RowFilterEditorPanel rowFilterEditorPanel) {
        super(context, rowFilterNode);
        assert (context != null) : "Context must not be null.";
        assert (rowFilterNode != null) : "Join node must not be null.";
        assert (rowFilterNode instanceof RowFilterNode) : "Must be an instance of join node.";
        this._parent = rowFilterEditorPanel;
        this.init(rowFilterNode, this._parent.getModel());
    }

    private void init(RowFilterNode rowFilterNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowRowFilterNodePropertyProxyModel)propertyModel;
        this._dirty = false;
        RowFilterNodeType rowFilterNodeType = (RowFilterNodeType)rowFilterNode.getData();
        this._filter = this._propertyModel != null ? rowFilterNodeType.getFilter() : this._parent.getFilter();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void updateNode() {
        RowFilterNode rowFilterNode = (RowFilterNode)this.getData();
        RowFilterNodeType rowFilterNodeType = (RowFilterNodeType)rowFilterNode.getData();
        ComplexProperty complexProperty = new ComplexProperty("rowFilter", this._filter);
        complexProperty.setOldData(rowFilterNodeType.getFilter());
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property(String.valueOf(RowFilterNodePropertyModel.RowIndex.ROWFILTER_FILTER), null, complexProperty, null, null));
        this._propertyModel.setValueAt(RowFilterPIPropertyLrb.get("PI_ROW_FILTER_GROUP_SETTING_FILTER_CHANGED"), this.getData(), arrayList);
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        this._textSearchComponent = new TextComponentSearchSupport((JTextComponent)this._filterTextArea);
        ControlBar controlBar = new ControlBar();
        this._addBtn = new JButton(InspectorArb.getIcon((int)24));
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setEnabled(false);
        controlBar.add((Component)this._addBtn);
        controlBar.add((Component)this._removeBtn);
        this._findPane = this.createFindPane();
        controlBar.add(this._findPane);
        this._jFilterCtl.setStyle(SearchField.Style.FIND);
        this._jFilterCtl.setPrompt(SQLEditorLrb.get("SQL_VIEWER_FIND"));
        this._jFilterCtl.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                SearchEvent.Direction direction = searchEvent.getDirection();
                String string = searchEvent.getSearchText();
                FilterPanel.this._textSearchComponent.search(direction, string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
        this._filterTextArea.setText(this._filter);
        this._filterTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this._filterTextArea);
        this.filterComponentWithTitlebar.setComponent((JComponent)jScrollPane);
        this.filterComponentWithTitlebar.setControlBar(controlBar);
        if (this._propertyModel != null) {
            this.filterComponentWithTitlebar.setLabel(new JLabel(DialogsLrb.get("ROWFILTER_FILTER_DEFINITION_PI")));
        } else {
            this.filterComponentWithTitlebar.setLabel(new JLabel(DialogsLrb.get("ROWFILTER_FILTER_DEFINITION")));
        }
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilterPanel.this.processAdd();
            }
        });
        this._addBtn.setToolTipText(DialogsLrb.get("ROWFILTER_FILTER_EXPRESSION_BUILDER"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilterPanel.this.processRemove();
            }
        });
        this._removeBtn.setToolTipText(DialogsLrb.get("ROWFILTER_FILTER_REMOVE_EXPRESSION"));
        this.enableControls();
    }

    protected void updateContent() {
        String string = this._filterTextArea.getText();
        if (this._filter == null && string != null) {
            this._dirty = true;
        } else if (this._filter != null && string == null) {
            this._dirty = true;
        } else if (this._filter.compareTo(string) != 0) {
            this._dirty = true;
        }
        if (this._dirty) {
            this._filter = string;
        }
    }

    private void enableControls() {
        this._addBtn.setEnabled(this.isWritable());
        this._removeBtn.setEnabled(this.isWritable() && this._filterTextArea.getText() != null && this._filterTextArea.getText().length() > 0);
    }

    protected void enableRemove() {
        this._removeBtn.setEnabled(this._filterTextArea.getText() != null && this._filterTextArea.getText().length() > 0);
    }

    protected void processAdd() {
        RowFilterNode rowFilterNode = (RowFilterNode)this.getData();
        Filter2DContext filter2DContext = new Filter2DContext(rowFilterNode.getInputSQL(false), rowFilterNode.findParentNode(), rowFilterNode, this._filter);
        ExpressionBuilderDialog expressionBuilderDialog = new ExpressionBuilderDialog();
        if (expressionBuilderDialog.invoke(this.getContext(), filter2DContext)) {
            this._filter = expressionBuilderDialog.getExpression();
            this._filterTextArea.setText(this._filter);
            this._dirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
        this.enableControls();
    }

    private void processRemove() {
        this._filter = null;
        this._filterTextArea.setText(this._filter);
        this._dirty = true;
        if (this._propertyModel != null) {
            this.updateNode();
        }
        this.enableControls();
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowRowFilterNodePropertyProxyModel workflowRowFilterNodePropertyProxyModel = (WorkflowRowFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowRowFilterNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        RowFilterNode rowFilterNode = (RowFilterNode)workflowNodeInspectorElement.getNode();
        if (rowFilterNode == null) {
            return;
        }
        this._propertyModel = (WorkflowRowFilterNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = rowFilterNode;
        this._dirty = false;
        RowFilterNodeType rowFilterNodeType = (RowFilterNodeType)rowFilterNode.getData();
        this._filter = rowFilterNodeType.getFilter();
        this.initUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowRowFilterNodePropertyProxyModel)) {
            return null;
        }
        WorkflowRowFilterNodePropertyProxyModel workflowRowFilterNodePropertyProxyModel = (WorkflowRowFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowRowFilterNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private RowFilterNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowRowFilterNodePropertyProxyModel)) {
            return null;
        }
        WorkflowRowFilterNodePropertyProxyModel workflowRowFilterNodePropertyProxyModel = (WorkflowRowFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowRowFilterNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof RowFilterNodeType) {
            return (RowFilterNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void initComponents() {
        this.filterTransparentPanel = new TransparentPanel();
        this.filterComponentWithTitlebar = new ComponentWithTitlebar();
        this.filterTransparentPanel.setName("filterTransparentPanel");
        this.filterComponentWithTitlebar.setName("filterComponentWithTitlebar");
        GroupLayout groupLayout = new GroupLayout((Container)this.filterTransparentPanel);
        this.filterTransparentPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.filterComponentWithTitlebar, -1, 795, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.filterComponentWithTitlebar, GroupLayout.Alignment.TRAILING, -1, 354, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 815, Short.MAX_VALUE).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.filterTransparentPanel, -1, -1, Short.MAX_VALUE).addContainerGap())));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 376, Short.MAX_VALUE).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.filterTransparentPanel, -1, -1, Short.MAX_VALUE).addContainerGap())));
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public String getFilter() {
        return this._filter;
    }

    protected void loadComponents() {
        this.initComponents();
    }

    protected Component createFindPane() {
        Box box = new Box(2);
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._jFilterCtl);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 150);
        Dimension dimension3 = this.derive(dimension, 100);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    protected void setTitle(String string) {
        this.filterComponentWithTitlebar.setLabel(new JLabel(string));
    }
}

