/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.modeldetails;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.OutputAttributeType;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.MiningAlgorithmOptions;
import oracle.dmt.dataminer.server.model.MiningDetailsOutputType;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.server.model.ModelDetailsExtract;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.AvailableRefModelType;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.EditModelDetailsDialog;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelDetailsLrb;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelOutputColumnsListPanel;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelsTableModel;
import oracle.dmt.dataminer.workflow.inspect.ModelDetailsPIComponentModelsPanel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractModelNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ModelDetailsDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsOutputType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.nulls.NullIcon;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class EditModelDetailsAutoPanel
extends AbstractDialogPanel {
    private ModelDetailsDataNode _node;
    private Connection _dbConn;
    private String _ownerName;
    private boolean _dirty = false;
    private boolean _automaticSetting = false;
    private final String UNDEFINED = ModelDetailsLrb.get("UNDEFINED_SELECTION");
    private ModelDetailsOutputType _modelOutputType;
    private List<RefModelType> _models;
    private ModelsTableModel _selectedModelsTableModel;
    private GenericTable _selectedModelsGenericTable = new GenericTable();
    private MiningFunctions _currentMiningFunction;
    private MiningAlgorithmOptions _currentAlgorithmOption;
    private MiningDetailsOutputType _currentMiningDetailOutputType;
    private List<OutputAttributeType> _currentOutputColumns;
    private ModelDetailType _modelDetailType;
    private static Icon _invalid_icon;
    private static Icon _built_icon;
    private static NullIcon _nullIcon;
    private JButton _removeBtn;
    private JButton _addBtn;
    private boolean _ignoreAlgoComboEvent = false;
    private boolean _ignoreOutputTypeComboEvent = false;
    private JCheckBox _jAutoSpecificationCheckBox;
    private JButton _jDisplayColumnsButton;
    private JLabel _jMiningFunctionLabel;
    private JLabel _jMiningFunctionValue;
    private JComboBox _jModelAlgorithmCombo;
    private JLabel _jModelAlgorithmLabel;
    private JComboBox _jOutputTypeCombo;
    private JLabel _jOutputTypeLabel;
    private ComponentWithTitlebar<JComponent> _modelComponent;

    public EditModelDetailsAutoPanel(JEWTDialog jEWTDialog, Context context, ModelDetailsDataNode modelDetailsDataNode) {
        super(context, modelDetailsDataNode);
        assert (context != null) : "Context must not be null.";
        assert (modelDetailsDataNode != null) : "Model details data node must not be null.";
        assert (modelDetailsDataNode instanceof ModelDetailsDataNode) : "Must be an instance of model details data node.";
        this._context = context;
        this._node = modelDetailsDataNode;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jMiningFunctionLabel = new JLabel();
        this._jMiningFunctionValue = new JLabel();
        this._jModelAlgorithmLabel = new JLabel();
        this._jModelAlgorithmCombo = new JComboBox();
        this._jOutputTypeLabel = new JLabel();
        this._jOutputTypeCombo = new JComboBox();
        this._jDisplayColumnsButton = new JButton();
        this._jAutoSpecificationCheckBox = new JCheckBox();
        this._modelComponent = new ComponentWithTitlebar();
        this._jMiningFunctionLabel.setText("Model Function:");
        this._jMiningFunctionValue.setText("Classification");
        this._jModelAlgorithmLabel.setText("Model Type:");
        this._jModelAlgorithmCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Decision Tree", "Clustering", "Scoring Model", "Associatin Rules"}));
        this._jOutputTypeLabel.setText("Output Type:");
        this._jOutputTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Full Tree", "Item 2", "Item 3", "Item 4"}));
        this._jDisplayColumnsButton.setText("Columns...");
        this._jAutoSpecificationCheckBox.setText("Automatic Specification");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._modelComponent, -1, 495, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this._jAutoSpecificationCheckBox, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this._jMiningFunctionLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this._jOutputTypeLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this._jModelAlgorithmLabel, GroupLayout.Alignment.LEADING, -2, 81, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jMiningFunctionValue, -1, -1, Short.MAX_VALUE).addComponent(this._jModelAlgorithmCombo, 0, 164, Short.MAX_VALUE).addComponent(this._jOutputTypeCombo, -2, 279, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jDisplayColumnsButton, -2, 101, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._jAutoSpecificationCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jMiningFunctionLabel).addComponent(this._jMiningFunctionValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jModelAlgorithmLabel).addComponent(this._jModelAlgorithmCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jOutputTypeCombo, -2, -1, -2).addComponent(this._jDisplayColumnsButton)).addComponent(this._jOutputTypeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this._modelComponent, -1, 259, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initUI() {
        ModelDetailsDataNode modelDetailsDataNode = this._node;
        if (modelDetailsDataNode == null) {
            return;
        }
        HelpUtils.setHelpID((JComponent)this, (String)"edit_model_details_auto");
        ResourceUtils.resButton((AbstractButton)this._jAutoSpecificationCheckBox, (String)PropertyLrb.get("PI_MODEL_DETAILS_AUTO_SETTING"));
        try {
            this._dbConn = Connections.getSharedConnection(this._context);
            this._ownerName = Connections.getUserAccountName(this._context);
            this._ownerName = StringUtils.isDoubleQuotedString(this._ownerName) ? StringUtils.trimDoubleQuotes(this._ownerName) : this._ownerName.toUpperCase();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_PI_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_PI_CONNECTION_ERROR_MESG"), null);
            return;
        }
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)modelDetailsDataNode.getData();
        this._modelOutputType = modelDetailsDataNodeType.getModelDetailsOutput();
        this.loadData();
        this.loadTables();
        JScrollPane jScrollPane = new JScrollPane((Component)this._selectedModelsGenericTable);
        this._modelComponent.setComponent((JComponent)jScrollPane);
        this._modelComponent.setLabel(new JLabel(ModelDetailsLrb.get("SELECTED_MODELS")));
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setEnabled(false);
        this._removeBtn.setToolTipText(ModelDetailsLrb.get("REMOVE_MODELS"));
        this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setToolTipText(ModelDetailsLrb.get("ADD_MODELS"));
        ControlBar controlBar = new ControlBar();
        controlBar.add((Component)this._addBtn);
        controlBar.add((Component)this._removeBtn);
        this._modelComponent.setControlBar(controlBar);
        this.initComboBoxes();
        this.initOutputColumns();
        this.addListeners();
    }

    private void addListeners() {
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsAutoPanel.this._dirty = true;
                EditModelDetailsAutoPanel.this.removeButtonProcessing();
            }
        });
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelDetailsOutputType modelDetailsOutputType = EditModelDetailsAutoPanel.this.generateModelOutputType();
                EditModelDetailsDialog editModelDetailsDialog = new EditModelDetailsDialog();
                if (editModelDetailsDialog.invoke(EditModelDetailsAutoPanel.this._context, EditModelDetailsAutoPanel.this._node, modelDetailsOutputType) && editModelDetailsDialog.getUpdatedModelOutputType() != null) {
                    EditModelDetailsAutoPanel.this.reloadUI(editModelDetailsDialog.getUpdatedModelOutputType());
                }
            }
        });
        this._jDisplayColumnsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelOutputColumnsListPanel modelOutputColumnsListPanel = new ModelOutputColumnsListPanel(EditModelDetailsAutoPanel.this.getContext(), EditModelDetailsAutoPanel.this._currentOutputColumns, (ModelDetailsDataNode)EditModelDetailsAutoPanel.this.getData());
                modelOutputColumnsListPanel.invokeDialog(null);
            }
        });
        this._jModelAlgorithmCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsAutoPanel.this._dirty = true;
                if (!EditModelDetailsAutoPanel.this._ignoreAlgoComboEvent) {
                    EditModelDetailsAutoPanel.this.processAlgorithmComboAction();
                }
            }
        });
        this._jOutputTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsAutoPanel.this._dirty = true;
                if (!EditModelDetailsAutoPanel.this._ignoreOutputTypeComboEvent) {
                    EditModelDetailsAutoPanel.this.processOutputTypeComboAction();
                }
            }
        });
        this._jAutoSpecificationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsAutoPanel.this.handleAutomaticSettingChange();
            }
        });
        this._selectedModelsGenericTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                EditModelDetailsAutoPanel.this._dirty = true;
                EditModelDetailsAutoPanel.this.handleModelSelectionChanged();
            }
        });
    }

    private void ignoreComboEvents(boolean bl) {
        this._ignoreAlgoComboEvent = bl;
        this._ignoreOutputTypeComboEvent = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadUI(ModelDetailsOutputType modelDetailsOutputType) {
        try {
            this.ignoreComboEvents(true);
            this._modelOutputType = modelDetailsOutputType;
            this.loadData();
            this.updateComboBoxes();
            this.initOutputColumns();
            this._selectedModelsTableModel.reload(modelDetailsOutputType.getModels().getModel());
            this.validateModelsAreCompatible();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_TITLE"), (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_MODEL_COMPATIBILITY_CHECK_FAILED"), null);
        }
        finally {
            this.ignoreComboEvents(false);
        }
    }

    private void updateComboBoxes() {
        this._jMiningFunctionValue.setText(this._currentMiningFunction.toString());
        this._jModelAlgorithmCombo.setModel(new DefaultComboBoxModel<MiningAlgorithmOptions>(MiningAlgorithmOptions.getMiningAlgorithmOptions(this._currentMiningFunction)));
        this._jModelAlgorithmCombo.setEnabled(true);
        this._jModelAlgorithmCombo.setSelectedItem((Object)this._currentAlgorithmOption);
        this._jOutputTypeCombo.setModel(new DefaultComboBoxModel<MiningDetailsOutputType>(MiningDetailsOutputType.getMiningDetailsOutputType(this._currentMiningFunction, this._currentAlgorithmOption)));
        this._jOutputTypeCombo.setEnabled(true);
        this._jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
    }

    private void handleAutomaticSettingChange() {
        boolean bl = this._jAutoSpecificationCheckBox.isSelected();
        if (bl) {
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)ModelDetailsLrb.get("MODEL_DETAILS_AUTO_SETTING_ON"), (String)ModelDetailsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                this._jAutoSpecificationCheckBox.setSelected(false);
                return;
            }
            this._dirty = true;
            try {
                this.loadCompatibleModels();
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_TITLE"), (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_MODEL_COMPATIBILITY"), null);
            }
            this._automaticSetting = true;
        } else {
            this._dirty = true;
            this._automaticSetting = false;
        }
        this.enableControls(!this._automaticSetting);
    }

    private void loadCompatibleModels() throws Exception {
        ModelDetailsOutputType modelDetailsOutputType = this.generateModelOutputType();
        ModelDetailsOutputType modelDetailsOutputType2 = this._node.addCompatibleModels(modelDetailsOutputType);
        this._selectedModelsTableModel.reload(modelDetailsOutputType2.getModels().getModel());
    }

    private ModelDetailsOutputType generateModelOutputType() {
        ModelDetailsOutputType modelDetailsOutputType = new ModelDetailsOutputType();
        Attributes attributes = new Attributes();
        ModelDetailsOutputType.Models models = this._selectedModelsTableModel.getRowCount() == 0 ? new ModelDetailsOutputType.Models() : this._selectedModelsTableModel.generateModelsCollection();
        modelDetailsOutputType.setModels(models);
        modelDetailsOutputType.setAttributes(attributes);
        MiningDetailsOutputType miningDetailsOutputType = MiningDetailsOutputType.fromString(this._currentMiningDetailOutputType.toString());
        MiningAlgorithmOptions miningAlgorithmOptions = MiningAlgorithmOptions.fromString(this._currentAlgorithmOption.toString());
        MiningFunctions miningFunctions = MiningFunctions.fromString(this._currentMiningFunction.toString());
        modelDetailsOutputType.setMiningAlgorithm(MiningAlgorithmOptions.getMiningAlgorithmType(miningAlgorithmOptions));
        modelDetailsOutputType.setMiningFunction(MiningFunctions.getMiningFunctionType(miningFunctions));
        modelDetailsOutputType.setMiningFunction(MiningFunctions.getMiningFunctionType(miningFunctions));
        modelDetailsOutputType.setMiningAlgorithm(MiningAlgorithmOptions.getMiningAlgorithmType(miningAlgorithmOptions));
        modelDetailsOutputType.setType(MiningDetailsOutputType.getMiningDetailType(miningDetailsOutputType, miningAlgorithmOptions, miningFunctions));
        modelDetailsOutputType.setAutoSpec(this._automaticSetting ? AutoSpecType.fromValue((String)"Yes") : AutoSpecType.fromValue((String)"No"));
        modelDetailsOutputType.setAttributes(OutputAttributeType.convertAttributes(this._currentOutputColumns));
        return modelDetailsOutputType;
    }

    private void handleModelSelectionChanged() {
        int n = this._selectedModelsGenericTable.getSelectedRowCount();
        if (n == 1) {
            ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this._selectedModelsGenericTable.getModel());
        }
        this._removeBtn.setEnabled(n != 0 && !this._automaticSetting);
    }

    private void enableControls(boolean bl) {
        this._addBtn.setEnabled(bl);
        int n = this._selectedModelsGenericTable.getSelectedRowCount();
        this._removeBtn.setEnabled(bl && n > 0);
        this._jModelAlgorithmCombo.setEnabled(bl);
        this._jOutputTypeCombo.setEnabled(bl);
    }

    private void removeButtonProcessing() {
        int[] nArray = this._selectedModelsGenericTable.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this._selectedModelsGenericTable.getModel());
        modelsTableModel.removeSelectedRows(nArray);
    }

    private void processOutputTypeComboAction() {
        MiningDetailsOutputType miningDetailsOutputType = (MiningDetailsOutputType)((Object)this._jOutputTypeCombo.getSelectedItem());
        if (this._currentMiningDetailOutputType != miningDetailsOutputType) {
            this._currentMiningDetailOutputType = miningDetailsOutputType;
            this._jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
            this.initOutputColumns();
            if (this._automaticSetting) {
                try {
                    this.loadCompatibleModels();
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_TITLE"), (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_MODEL_COMPATIBILITY"), null);
                }
            } else {
                try {
                    this.validateModelsAreCompatible();
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_TITLE"), (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_MODEL_COMPATIBILITY_CHECK_FAILED"), null);
                }
            }
        }
    }

    private void processAlgorithmComboAction() {
        MiningAlgorithmOptions miningAlgorithmOptions = (MiningAlgorithmOptions)((Object)this._jModelAlgorithmCombo.getSelectedItem());
        if (this._currentAlgorithmOption != miningAlgorithmOptions) {
            this._currentAlgorithmOption = miningAlgorithmOptions;
            this.setupOutputTypeCombo(this._currentMiningFunction, this._currentAlgorithmOption);
            if (this._automaticSetting) {
                try {
                    this.loadCompatibleModels();
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_TITLE"), (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_MODEL_COMPATIBILITY"), null);
                }
            } else {
                try {
                    this.validateModelsAreCompatible();
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_TITLE"), (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_MODEL_COMPATIBILITY_CHECK_FAILED"), null);
                }
            }
        }
    }

    private void validateModelsAreCompatible() throws Exception {
        ModelDetailsOutputType modelDetailsOutputType = this.generateModelOutputType();
        ModelDetailsOutputType modelDetailsOutputType2 = this._node.validateModelCompatibilityNotAuto(modelDetailsOutputType);
        this._selectedModelsTableModel.reload(modelDetailsOutputType2.getModels().getModel());
    }

    private void setupOutputTypeCombo(MiningFunctions miningFunctions, MiningAlgorithmOptions miningAlgorithmOptions) {
        this._jOutputTypeCombo.setModel(new DefaultComboBoxModel<MiningDetailsOutputType>(MiningDetailsOutputType.getMiningDetailsOutputType(miningFunctions, miningAlgorithmOptions)));
        this._currentMiningDetailOutputType = MiningDetailsOutputType.getPreferredOutputTypeForModelDetailsNode(miningFunctions, miningAlgorithmOptions);
        this._jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
        this.initOutputColumns();
    }

    @Override
    public void initRes() {
        this.initIcons();
        this._jMiningFunctionLabel.setText(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_FUNCTION"));
        this._jMiningFunctionLabel.setText(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_FUNCTION"));
        this._jMiningFunctionLabel.setLabelFor(this._jMiningFunctionValue);
        ResourceUtils.resLabel((JLabel)this._jModelAlgorithmLabel, (Component)this._jModelAlgorithmCombo, (String)PropertyLrb.get("PI_MODEL_DETAILS_GROUP_MODEL_TYPE"));
        this._jModelAlgorithmCombo.getAccessibleContext().setAccessibleDescription(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_MODEL_TYPE_ADA"));
        this._jModelAlgorithmCombo.setToolTipText(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_MODEL_TYPE_ADA"));
        ResourceUtils.resLabel((JLabel)this._jOutputTypeLabel, (Component)this._jOutputTypeCombo, (String)PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE"));
        this._jOutputTypeCombo.getAccessibleContext().setAccessibleDescription(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE_ADA"));
        this._jOutputTypeCombo.setToolTipText(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE_ADA"));
        ResourceUtils.resButton((AbstractButton)this._jDisplayColumnsButton, (String)ModelDetailsLrb.get("COLUMNS_DISPLAY_BUTTON"));
        this._jDisplayColumnsButton.getAccessibleContext().setAccessibleDescription(ModelDetailsLrb.get("COLUMNS_DISPLAY_BUTTON_ADA"));
        this._jDisplayColumnsButton.setToolTipText(ModelDetailsLrb.get("COLUMNS_DISPLAY_BUTTON_ADA"));
    }

    private void initIcons() {
        Class<ModelDetailsPIComponentModelsPanel> clazz = ModelDetailsPIComponentModelsPanel.class;
        if (_invalid_icon == null) {
            _invalid_icon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_BUILD_GROUP_MODEL_INVALID_ICON"));
        }
        if (_built_icon == null) {
            _built_icon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_BUILD_GROUP_MODEL_BUILT_ICON"));
        }
        if (_nullIcon == null) {
            _nullIcon = new NullIcon(_built_icon.getIconWidth(), _built_icon.getIconHeight());
        }
    }

    private void loadData() {
        if (this._modelOutputType != null) {
            this._models = this._modelOutputType.getModels().getModel();
            this._modelDetailType = this._modelOutputType.getType();
            this._currentMiningDetailOutputType = MiningDetailsOutputType.getMiningDetailsOutputType(this._modelDetailType);
            this._currentMiningFunction = MiningFunctions.getMiningFunctionsFromType(this._modelOutputType.getMiningFunction());
            this._currentAlgorithmOption = MiningAlgorithmOptions.getMiningAlgorithmType(this._modelOutputType.getMiningAlgorithm());
            this._currentOutputColumns = OutputAttributeType.convertAttributes(this._modelOutputType.getAttributes());
            if (this._modelOutputType.getAutoSpec() != null) {
                this._automaticSetting = this._modelOutputType.getAutoSpec().value().compareTo("Yes") == 0;
            }
        } else {
            this._models = null;
            this._currentMiningDetailOutputType = null;
            this._currentMiningFunction = null;
            this._currentAlgorithmOption = null;
            this._currentOutputColumns = null;
            this._automaticSetting = false;
        }
    }

    private void loadTables() {
        try {
            this._selectedModelsTableModel = new ModelsTableModel(this._models, this._ownerName, this._node);
            this.setupModelsTable(this._selectedModelsGenericTable, this._selectedModelsTableModel);
            this.setupModelsTable(this._selectedModelsGenericTable, this._selectedModelsTableModel);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("ERROR_TITLE"), (String)ModelDetailsLrb.get("ERROR_MODEL_LOADING_UNEXPECTED"), null);
            exception.printStackTrace();
        }
    }

    private void setupModelsTable(GenericTable genericTable, ModelsTableModel modelsTableModel) {
        genericTable.setModel((TableModel)((Object)modelsTableModel));
        genericTable.setSorted(true);
        genericTable.setSortColumn(0, true);
        genericTable.setUpdateSelectionOnSort(true);
        genericTable.getTableHeader().setReorderingAllowed(false);
        TableColumn tableColumn = genericTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new CustomCellRenderer());
    }

    private void initComboBoxes() {
        this._jAutoSpecificationCheckBox.setSelected(this._automaticSetting);
        List<AbstractNode> list = this._node.findParentNodes();
        if (list.size() == 0 && this._modelDetailType == null) {
            this._currentMiningFunction = MiningFunctions.CLASSIFICATION;
            this._jMiningFunctionValue.setText(this.UNDEFINED);
            this._jModelAlgorithmCombo.setModel(new DefaultComboBoxModel());
            this._jModelAlgorithmCombo.setEnabled(false);
            this._jOutputTypeCombo.setModel(new DefaultComboBoxModel());
            this._jOutputTypeCombo.setEnabled(false);
            this._jAutoSpecificationCheckBox.setEnabled(false);
        } else if (list.size() > 0 && this._modelDetailType == null) {
            this._currentMiningFunction = this.getParentNodeMiningFunction(list);
            if (this._currentMiningFunction == null) {
                this._currentMiningFunction = MiningFunctions.CLASSIFICATION;
                this._jMiningFunctionValue.setText(this.UNDEFINED);
            } else {
                this._jMiningFunctionValue.setText(this._currentMiningFunction.toString());
            }
            this._jModelAlgorithmCombo.setModel(new DefaultComboBoxModel<MiningAlgorithmOptions>(MiningAlgorithmOptions.getMiningAlgorithmOptions(this._currentMiningFunction)));
            this._jModelAlgorithmCombo.setEnabled(true);
            this._currentAlgorithmOption = MiningAlgorithmOptions.getPreferredAlgorithmOptionForModelDetailsNode(this._currentMiningFunction);
            this._jModelAlgorithmCombo.setSelectedItem((Object)this._currentAlgorithmOption);
            this._jOutputTypeCombo.setModel(new DefaultComboBoxModel<MiningDetailsOutputType>(MiningDetailsOutputType.getMiningDetailsOutputType(this._currentMiningFunction, this._currentAlgorithmOption)));
            this._jOutputTypeCombo.setEnabled(true);
            this._currentMiningDetailOutputType = MiningDetailsOutputType.getPreferredOutputTypeForModelDetailsNode(this._currentMiningFunction, this._currentAlgorithmOption);
            this._jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
        } else if (this._modelDetailType != null) {
            this._jMiningFunctionValue.setText(this._currentMiningFunction.toString());
            this._jModelAlgorithmCombo.setModel(new DefaultComboBoxModel<MiningAlgorithmOptions>(MiningAlgorithmOptions.getMiningAlgorithmOptions(this._currentMiningFunction)));
            this._jModelAlgorithmCombo.setEnabled(true);
            this._jModelAlgorithmCombo.setSelectedItem((Object)this._currentAlgorithmOption);
            this._jOutputTypeCombo.setModel(new DefaultComboBoxModel<MiningDetailsOutputType>(MiningDetailsOutputType.getMiningDetailsOutputType(this._currentMiningFunction, this._currentAlgorithmOption)));
            this._jOutputTypeCombo.setEnabled(true);
            this._jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
        }
        this.enableControls(!this._jAutoSpecificationCheckBox.isSelected());
    }

    private MiningFunctions getParentNodeMiningFunction(List<AbstractNode> list) {
        MiningFunctionType miningFunctionType = null;
        AbstractNode abstractNode = list.get(0);
        if (abstractNode instanceof AbstractBuildNode) {
            AbstractBuildNode abstractBuildNode = (AbstractBuildNode)abstractNode;
            miningFunctionType = abstractBuildNode.getMiningFunctionType();
        } else if (abstractNode instanceof AbstractModelNode) {
            AbstractModelNode abstractModelNode = (AbstractModelNode)abstractNode;
            miningFunctionType = abstractModelNode.getMiningFunctionTypeSupported();
        }
        return MiningFunctions.getMiningFunctionsFromType(miningFunctionType);
    }

    private void initOutputColumns() {
        if (this._currentMiningDetailOutputType != null && this._currentAlgorithmOption != null && this._currentMiningFunction != null) {
            this._currentOutputColumns = ModelDetailsExtract.getOutputColumnList(MiningDetailsOutputType.getMiningDetailType(this._currentMiningDetailOutputType, this._currentAlgorithmOption, this._currentMiningFunction));
            this._jDisplayColumnsButton.setEnabled(true);
        } else {
            this._jDisplayColumnsButton.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWork() {
        boolean bl;
        block8: {
            bl = true;
            if (!this._dirty) {
                return true;
            }
            try {
                ModelDetailsOutputType modelDetailsOutputType = this.generateModelOutputType();
                if (!bl) break block8;
                CommandProcessor.getInstance().beginTrans(ModelDetailsLrb.get("MODEL_NODE_EDIT_TRANSACTION_NAME"));
                try {
                    OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
                    odmrSDMUndoFilter.prepareUndo(this.getData(), this.getContext(), "modelDetailsModels", modelDetailsOutputType);
                    this.getData().validate(true);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_MESG"), null);
                }
                finally {
                    CommandProcessor.getInstance().endTrans();
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_MESG"), null);
            }
        }
        return bl;
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            GenericTable genericTable = (GenericTable)jTable;
            int n3 = genericTable.convertRowIndexToModel(n);
            ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)genericTable.getModel());
            AvailableRefModelType availableRefModelType = modelsTableModel.getDataVector().get(n3);
            if (availableRefModelType.getStatus() == RefModelStatusType.VALID && modelsTableModel.isModelBuilt(n3)) {
                this.setIcon(_built_icon);
            } else if (availableRefModelType.getStatus() == RefModelStatusType.VALID && !modelsTableModel.isModelBuilt(n3)) {
                this.setIcon((Icon)_nullIcon);
            } else {
                this.setIcon(_invalid_icon);
            }
            return component;
        }
    }
}

