/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.model;

import java.awt.Component;
import java.awt.Dimension;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.TargetValues;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;

public class TargetValuesPanel
extends JPanel
implements DataminerGUIPanel {
    boolean _targetsAreStrings = true;
    private GenericTable jtargetValuesGenericTable = new GenericTable();
    private JComponent _findPane;
    private SearchField _searchField;
    private String _targetName;
    private String _targetDataType;
    private String[] _colNames = new String[]{DialogsLrb.get("TARGET_VALUES_DIALOG_TARGET_VALUES")};
    private TargetValueTableModel _targetTableModel = null;
    private TargetValueTableModel _currentTargetTableModel = null;
    private JLabel _jTargetDataTypeLabel;
    private JLabel _jTargetDataTypeValue;
    private JLabel _jTargetNameLabel;
    private JLabel _jTargetNameValue;
    private ComponentWithTitlebar<JComponent> _jTargetValueComponent;

    public TargetValuesPanel(String string, String string2, TargetValues targetValues) {
        this._targetName = string;
        this._targetDataType = string2;
        if (targetValues.getTargetValueNumber() != null && targetValues.getTargetValueNumber().size() > 0) {
            this._targetsAreStrings = false;
            this._targetTableModel = new TargetValueTableModel(targetValues, false);
        } else if (targetValues.getTargetValueString() != null && targetValues.getTargetValueString().size() > 0) {
            this._targetsAreStrings = true;
            this._targetTableModel = new TargetValueTableModel(targetValues, true);
        } else {
            this._targetTableModel = new TargetValueTableModel(new TargetValues(), true);
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jTargetValueComponent = new ComponentWithTitlebar();
        this._jTargetNameLabel = new JLabel();
        this._jTargetNameValue = new JLabel();
        this._jTargetDataTypeLabel = new JLabel();
        this._jTargetDataTypeValue = new JLabel();
        this._jTargetNameLabel.setText("Target:");
        this._jTargetNameValue.setText("Churn");
        this._jTargetDataTypeLabel.setText("Data Type:");
        this._jTargetDataTypeValue.setText("VARCHAR2");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jTargetValueComponent, -1, 380, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this._jTargetNameLabel, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jTargetNameValue, -2, 134, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this._jTargetDataTypeLabel, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jTargetDataTypeValue, -2, 80, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jTargetNameLabel).addComponent(this._jTargetNameValue).addComponent(this._jTargetDataTypeLabel).addComponent(this._jTargetDataTypeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this._jTargetValueComponent, -1, 253, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initUI() {
        JScrollPane jScrollPane = new JScrollPane((Component)this.jtargetValuesGenericTable);
        this.jtargetValuesGenericTable.setFillsViewportHeight(true);
        this._jTargetValueComponent.setComponent((JComponent)jScrollPane);
        this._jTargetValueComponent.setLabel(new JLabel(DialogsLrb.get("TARGET_VALUES_DIALOG_TARGET_VALUES_TABLE")));
        ControlBar controlBar = new ControlBar();
        this.installItemFilterActions(controlBar);
        this._jTargetValueComponent.setControlBar(controlBar);
        this.setupTable(this._targetTableModel);
        this._jTargetNameValue.setText(this._targetName);
        this._jTargetDataTypeValue.setText(this._targetDataType);
        if (this._targetName.length() == 0) {
            this._jTargetNameValue.setVisible(false);
            this._jTargetNameLabel.setVisible(false);
            this._jTargetDataTypeLabel.setVisible(false);
            this._jTargetDataTypeValue.setVisible(false);
        }
    }

    private void installItemFilterActions(ControlBar controlBar) {
        this._findPane = new Box(2);
        this._searchField = this.searchField();
        this._findPane.setName("Find");
        this._findPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this._findPane.add((Component)this._searchField);
        Dimension dimension = this._findPane.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 145);
        Dimension dimension3 = this.derive(dimension, 80);
        this._findPane.setPreferredSize(dimension2);
        this._findPane.setMaximumSize(dimension2);
        this._findPane.setMinimumSize(dimension3);
        controlBar.add((Component)this._findPane);
    }

    private SearchField searchField() {
        SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                TargetValuesPanel.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                TargetValuesPanel.this.processFilter(string);
            }
        });
        return searchField;
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jTargetNameLabel, (Component)this._jTargetNameValue, (String)(DialogsLrb.get("TARGET_VALUES_DIALOG_TARGET") + ":"));
        ResourceUtils.resLabel((JLabel)this._jTargetDataTypeLabel, (Component)this._jTargetDataTypeValue, (String)(DialogsLrb.get("TARGET_VALUES_DIALOG_TARGET_DATA_TYPE") + ":"));
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private void processFilter(String string) {
        try {
            this._currentTargetTableModel = this._targetTableModel.getfilteredCopy(string);
            this.setupTable(this._currentTargetTableModel);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("TARGET_VALUES_DIALOG_FILTER_ERROR_TITLE"), (String)DialogsLrb.get("TARGET_VALUES_DIALOG_FILTER_ERROR_MESG"), null);
        }
    }

    private void setupTable(TargetValueTableModel targetValueTableModel) {
        this.jtargetValuesGenericTable.setModel((TableModel)((Object)targetValueTableModel));
        this.jtargetValuesGenericTable.setSorted(true);
        this.jtargetValuesGenericTable.setSortColumn(0, true);
        this.jtargetValuesGenericTable.setSelectionMode(2);
    }

    class TargetValueTableModel
    extends GenericBaseTableModel {
        private List<String> _stringData;
        private List<Double> _numberData;
        private boolean _isStringTargetValues = true;
        private NumberFormat _labelNumericalFormat = NumericFormat.getInstance(true, 8, 0, 0);
        public static final int VALUE = 0;
        private final int COLUMN_COUNT = 1;

        public TargetValueTableModel(TargetValues targetValues, boolean bl) {
            this._isStringTargetValues = bl;
            if (this._isStringTargetValues) {
                this._stringData = targetValues.getTargetValueString();
                this.setRowCount(this._stringData.size());
            } else {
                this._numberData = targetValues.getTargetValueNumber();
                this.setRowCount(this._numberData.size());
            }
            this.setColumnIdentifiers(TargetValuesPanel.this._colNames);
            this.setColumnCount(1);
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            String string = null;
            if (0 == n2) {
                string = this._isStringTargetValues ? this._stringData.get(n) : this._labelNumericalFormat.format(this._numberData.get(n)) + "";
            }
            return string;
        }

        private TargetValueTableModel getFilteredStringCopy(SearchMatcher searchMatcher) {
            ArrayList<String> arrayList = new ArrayList<String>();
            List<String> list = this.getStringData();
            for (String string : list) {
                if (!searchMatcher.matches((CharSequence)string)) continue;
                arrayList.add(string);
            }
            TargetValues targetValues = new TargetValues();
            targetValues.getTargetValueString().addAll(arrayList);
            return new TargetValueTableModel(targetValues, true);
        }

        private TargetValueTableModel getFilteredNumberCopy(SearchMatcher searchMatcher) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            List<Double> list = this.getNumberData();
            for (Double d : list) {
                String string = this._labelNumericalFormat.format(d);
                if (!searchMatcher.matches((CharSequence)string)) continue;
                arrayList.add(d);
            }
            TargetValues targetValues = new TargetValues();
            targetValues.getTargetValueNumber().addAll(arrayList);
            return new TargetValueTableModel(targetValues, false);
        }

        public TargetValueTableModel getfilteredCopy(String string) throws Exception {
            assert (string != null) : "value filter must be non null";
            SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
            if (this._isStringTargetValues) {
                return this.getFilteredStringCopy(searchMatcher);
            }
            return this.getFilteredNumberCopy(searchMatcher);
        }

        public List<String> getStringData() {
            return this._stringData;
        }

        public List<Double> getNumberData() {
            return this._numberData;
        }
    }
}

