/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.model;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.model.ModelPropertiesState;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.TraversableContext;

public class ModelSVCBuildSettingsPanel
extends AbstractPropertiesDialogPanel {
    private JCheckBox jCheckBoxActiveLearning;
    private JCheckBox jCheckBoxComplexityFactors;
    private JCheckBox jCheckBoxStdDev;
    private JComboBox jComboBoxKernerFunction;
    private JLabel jLabelCacheSize;
    private JLabel jLabelKernelFunction;
    private JLabel jLabelToleranceValue;
    private JScrollPane jScrollPaneTitle;
    private JTextField jTextFieldCacheSize;
    private JTextField jTextFieldComplexityFactors;
    private JTextField jTextFieldStdDev;
    private JTextField jTextFieldToleranceValue;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();
    private DefaultComboBoxModel _kernelFunctionsModel;
    private String _currentKernelFunctionName;

    public ModelSVCBuildSettingsPanel(TraversableContext traversableContext) {
        super(traversableContext);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLabelKernelFunction = new JLabel();
        this.jComboBoxKernerFunction = new JComboBox();
        this.jLabelToleranceValue = new JLabel();
        this.jTextFieldToleranceValue = new NumberTextField();
        this.jCheckBoxComplexityFactors = new JCheckBox();
        this.jTextFieldComplexityFactors = new NumberTextField();
        this.jCheckBoxActiveLearning = new JCheckBox();
        this.jCheckBoxStdDev = new JCheckBox();
        this.jTextFieldStdDev = new NumberTextField();
        this.jLabelCacheSize = new JLabel();
        this.jTextFieldCacheSize = new NumberTextField();
        this.jScrollPaneTitle = new JScrollPane();
        this.jLabelKernelFunction.setText("Kernel Function");
        this.jComboBoxKernerFunction.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxKernerFunction.setInheritsPopupMenu(true);
        this.jComboBoxKernerFunction.setMinimumSize(new Dimension(58, 18));
        this.jComboBoxKernerFunction.setOpaque(false);
        this.jComboBoxKernerFunction.setPreferredSize(new Dimension(62, 22));
        this.jLabelToleranceValue.setText("Tolerance Value:");
        this.jTextFieldToleranceValue.setToolTipText("Range: > 0 and <= 0.01");
        this.jCheckBoxComplexityFactors.setText("Specify the complexity factors");
        this.jCheckBoxComplexityFactors.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxComplexityFactors.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldComplexityFactors.setToolTipText("Range: > 0");
        this.jCheckBoxActiveLearning.setText("Active Learning");
        this.jCheckBoxActiveLearning.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxActiveLearning.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxStdDev.setText("Specify the standard deviation for gaussian kernel");
        this.jCheckBoxStdDev.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxStdDev.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldStdDev.setToolTipText("Range: > 0");
        this.jLabelCacheSize.setText("Cache Size:");
        this.jTextFieldCacheSize.setToolTipText("Range: > 0");
        this.jScrollPaneTitle.setBorder(null);
        this.jScrollPaneTitle.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneTitle.setVerticalScrollBarPolicy(21);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(19, 19, 19).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelKernelFunction, -2, 98, -2).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxComplexityFactors, -2, 181, -2).addComponent(this.jCheckBoxActiveLearning).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jTextFieldComplexityFactors, -2, 83, -2)).addComponent(this.jLabelCacheSize, -2, 78, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelToleranceValue, -2, 106, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldToleranceValue, -2, 80, -2).addComponent(this.jComboBoxKernerFunction, -2, 160, -2))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldCacheSize, -2, 80, -2).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jTextFieldStdDev, -2, 74, -2))).addComponent(this.jCheckBoxStdDev))))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -1, 403, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.linkSize(0, this.jTextFieldCacheSize, this.jTextFieldComplexityFactors, this.jTextFieldStdDev, this.jTextFieldToleranceValue);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelKernelFunction).addComponent(this.jComboBoxKernerFunction, -2, -1, -2)).addGap(13, 13, 13).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelToleranceValue).addComponent(this.jTextFieldToleranceValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxComplexityFactors).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldComplexityFactors, -2, -1, -2).addGap(15, 15, 15).addComponent(this.jCheckBoxActiveLearning).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxStdDev).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldStdDev, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelCacheSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldCacheSize, -2, -1, -2).addContainerGap(40, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jTextFieldCacheSize, this.jTextFieldComplexityFactors, this.jTextFieldStdDev, this.jTextFieldToleranceValue);
    }

    private static String convertToServerKernelFunctionName(String string) {
        assert (string != null);
        if (0 == string.compareTo(ModelPropertiesState.CLIENT_SVM_GAUSSIAN)) {
            return "SVMS_GAUSSIAN";
        }
        if (0 == string.compareTo(ModelPropertiesState.CLIENT_SVM_LINEAR)) {
            return "SVMS_LINEAR";
        }
        return "SVMS_SYSTEM_DETERMINED";
    }

    private void initRes() {
        this.jLabelKernelFunction.setText(AlgSettingsLrb.get("MODEL_SETTINGS_KERNEL_FUNCTION"));
        this.jLabelToleranceValue.setText(AlgSettingsLrb.get("MODEL_SETTINGS_TOLERANCE_VALUE"));
        this.jCheckBoxComplexityFactors.setText(AlgSettingsLrb.get("MODEL_SETTINGS_COMPLEXITY_FACTOR"));
        this.jCheckBoxActiveLearning.setText(AlgSettingsLrb.get("MODEL_SETTINGS_ACTIVE_LEARNING"));
        this.jCheckBoxStdDev.setText(AlgSettingsLrb.get("MODEL_SETTINGS_CHK_BOX_STDEV"));
        this.jLabelCacheSize.setText(AlgSettingsLrb.get("MODEL_SETTINGS_CACHE_SIZE"));
    }

    private void initUI() {
        ModelPropertiesState modelPropertiesState = this.getState();
        this.loadDescription(this._jDescription, this.jScrollPaneTitle);
        this.setDataType(this.jTextFieldToleranceValue, Double.class);
        this.setDataType(this.jTextFieldComplexityFactors, Double.class);
        this.setDataType(this.jTextFieldStdDev, Double.class);
        this.setDataType(this.jTextFieldCacheSize, Long.class);
        this.setSigned(this.jTextFieldToleranceValue, false);
        this.setSigned(this.jTextFieldComplexityFactors, false);
        this.setSigned(this.jTextFieldStdDev, false);
        this.setSigned(this.jTextFieldCacheSize, false);
        this.setLocale(this.jTextFieldToleranceValue, modelPropertiesState.getLocale());
        this.setLocale(this.jTextFieldComplexityFactors, modelPropertiesState.getLocale());
        this.setLocale(this.jTextFieldStdDev, modelPropertiesState.getLocale());
        this.setLocale(this.jTextFieldCacheSize, modelPropertiesState.getLocale());
        this._kernelFunctionsModel = new DefaultComboBoxModel<String>(new String[]{ModelPropertiesState.CLIENT_SVMS_SYSTEM_DEFAULT, ModelPropertiesState.CLIENT_SVM_GAUSSIAN, ModelPropertiesState.CLIENT_SVM_LINEAR});
        this.jComboBoxKernerFunction.setModel(this._kernelFunctionsModel);
        String string = modelPropertiesState.getModelSettingStringValue("SVMS_KERNEL_FUNCTION");
        if (string == null) {
            string = "SVMS_SYSTEM_DETERMINED";
        }
        modelPropertiesState.setBackupValue("SVMS_KERNEL_FUNCTION", string);
        this._currentKernelFunctionName = this.convertToClientKernelFunctionName(string);
        this.jComboBoxKernerFunction.setSelectedItem(this._currentKernelFunctionName);
        this.jComboBoxKernerFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)ModelSVCBuildSettingsPanel.this.jComboBoxKernerFunction.getSelectedItem();
                if (string.equals(ModelSVCBuildSettingsPanel.this._currentKernelFunctionName)) {
                    return;
                }
                ModelSVCBuildSettingsPanel.this._currentKernelFunctionName = string;
                ModelSVCBuildSettingsPanel.this.updatePanel();
            }
        });
        BigDecimal bigDecimal = modelPropertiesState.getModelSettingNumValue("SVMS_CONV_TOLERANCE");
        modelPropertiesState.setBackupValue("SVMS_CONV_TOLERANCE", bigDecimal.doubleValue());
        this.setNumber(this.jTextFieldToleranceValue, bigDecimal);
        this.jTextFieldToleranceValue.setToolTipText(DialogsLrb.get("SVMS_CONV_TOLERANCE_TOOLTIP"));
        BigDecimal bigDecimal2 = modelPropertiesState.getModelSettingNumValue("SVMS_COMPLEXITY_FACTOR");
        if (bigDecimal2 == null || 0 == bigDecimal2.compareTo(BigDecimal.ZERO)) {
            this.jCheckBoxComplexityFactors.setSelected(false);
            this.jTextFieldComplexityFactors.setEnabled(false);
            modelPropertiesState.setBackupNullValue("SVMS_COMPLEXITY_FACTOR");
        } else {
            modelPropertiesState.setBackupValue("SVMS_COMPLEXITY_FACTOR", bigDecimal2);
            this.jCheckBoxComplexityFactors.setSelected(true);
            this.setNumber(this.jTextFieldComplexityFactors, bigDecimal2);
            this.jTextFieldComplexityFactors.setToolTipText(DialogsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
        }
        this.jCheckBoxComplexityFactors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JCheckBox) {
                    JCheckBox jCheckBox = (JCheckBox)object;
                    ModelSVCBuildSettingsPanel.this.jTextFieldComplexityFactors.setEnabled(jCheckBox.isSelected());
                }
            }
        });
        String string2 = modelPropertiesState.getModelSettingStringValue("SVMS_ACTIVE_LEARNING");
        string2 = string2 != null ? string2 : "SVMS_AL_DISABLE";
        modelPropertiesState.setBackupValue("SVMS_ACTIVE_LEARNING", string2);
        this.jCheckBoxActiveLearning.setSelected(string2.equals("SVMS_AL_ENABLE"));
        BigDecimal bigDecimal3 = modelPropertiesState.getModelSettingNumValue("SVMS_STD_DEV");
        if (bigDecimal3 == null || 0 == bigDecimal3.compareTo(BigDecimal.ZERO)) {
            modelPropertiesState.setBackupNullValue("SVMS_STD_DEV");
            this.jCheckBoxStdDev.setSelected(false);
            this.jTextFieldStdDev.setEnabled(false);
        } else {
            modelPropertiesState.setBackupValue("SVMS_STD_DEV", bigDecimal3);
            this.jCheckBoxStdDev.setSelected(true);
            this.setNumber(this.jTextFieldStdDev, bigDecimal3);
            this.jTextFieldStdDev.setToolTipText(DialogsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
        }
        this.jCheckBoxStdDev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JCheckBox) {
                    JCheckBox jCheckBox = (JCheckBox)object;
                    ModelSVCBuildSettingsPanel.this.jTextFieldStdDev.setEnabled(jCheckBox.isSelected());
                }
            }
        });
        Number number = modelPropertiesState.getModelSettingNumValue("SVMS_KERNEL_CACHE_SIZE");
        if (null == number) {
            number = ServerConstants.SVMSettings.SVMS_KERNEL_CACHE_SIZE_DEFAULT;
        }
        modelPropertiesState.setBackupValue("SVMS_KERNEL_CACHE_SIZE", number);
        this.setNumber(this.jTextFieldCacheSize, number);
        this.jTextFieldCacheSize.setToolTipText(DialogsLrb.get("SVMS_CONV_POSITIVE_VALUE_TOOLTIP"));
        this.updatePanel();
    }

    private String convertToClientKernelFunctionName(String string) {
        if (string != null) {
            if (0 == string.compareTo("SVMS_GAUSSIAN")) {
                return ModelPropertiesState.CLIENT_SVM_GAUSSIAN;
            }
            if (0 == string.compareTo("SVMS_LINEAR")) {
                return ModelPropertiesState.CLIENT_SVM_LINEAR;
            }
        }
        return ModelPropertiesState.CLIENT_SVMS_SYSTEM_DEFAULT;
    }

    private void updatePanel() {
        boolean bl = this.isGaussian();
        this.jCheckBoxStdDev.setVisible(bl);
        this.jTextFieldStdDev.setVisible(bl);
        this.jLabelCacheSize.setVisible(bl);
        this.jTextFieldCacheSize.setVisible(bl);
        this.repaint();
    }

    private boolean isGaussian() {
        boolean bl = false;
        if (this._currentKernelFunctionName != null) {
            bl = this._currentKernelFunctionName.equals(ModelPropertiesState.CLIENT_SVM_GAUSSIAN);
        }
        return bl;
    }

    @Override
    public void processInput() {
        Number number;
        ModelPropertiesState modelPropertiesState = this.getState();
        modelPropertiesState.setValue("SVMS_KERNEL_FUNCTION", ModelSVCBuildSettingsPanel.convertToServerKernelFunctionName(this._currentKernelFunctionName));
        Number number2 = this.getNumber(this.jTextFieldToleranceValue);
        if (null == number2 || number2.doubleValue() <= 0.0 || number2.doubleValue() > 0.01) {
            modelPropertiesState.setValidationError(DialogsLrb.get("SVMS_CONV_TOLERANCE_OUT_OF_RANGE"));
            return;
        }
        modelPropertiesState.setValue("SVMS_CONV_TOLERANCE", new Double(number2.toString()));
        if (this.jCheckBoxComplexityFactors.isSelected()) {
            Number number3 = this.getNumber(this.jTextFieldComplexityFactors);
            if (null == number3 || number3.doubleValue() <= 0.0) {
                modelPropertiesState.setValidationError(DialogsLrb.get("SVMS_COMPLEXITY_FACTOR_NULL"));
                return;
            }
            modelPropertiesState.setValue("SVMS_COMPLEXITY_FACTOR", number3);
        } else {
            modelPropertiesState.setNullValue("SVMS_COMPLEXITY_FACTOR");
        }
        modelPropertiesState.setValue("SVMS_ACTIVE_LEARNING", this.jCheckBoxActiveLearning.isSelected() ? "SVMS_AL_ENABLE" : "SVMS_AL_DISABLE");
        boolean bl = this.isGaussian();
        if (!bl) {
            modelPropertiesState.setNullValue("SVMS_STD_DEV");
            modelPropertiesState.setNullValue("SVMS_KERNEL_CACHE_SIZE");
            return;
        }
        if (this.jCheckBoxStdDev.isSelected()) {
            number = this.getNumber(this.jTextFieldStdDev);
            if (null == number || number.doubleValue() <= 0.0) {
                modelPropertiesState.setValidationError(DialogsLrb.get("SVMS_COMPLEXITY_STD_DEV_NULL"));
                return;
            }
            modelPropertiesState.setValue("SVMS_STD_DEV", number);
        } else {
            modelPropertiesState.setNullValue("SVMS_STD_DEV");
        }
        number = this.getNumber(this.jTextFieldCacheSize);
        if (null == number || number.doubleValue() <= 0.0) {
            modelPropertiesState.setValidationError(DialogsLrb.get("SVMS_COMPLEXITY_CACHE_SIZE_NULL"));
            return;
        }
        modelPropertiesState.setValue("SVMS_KERNEL_CACHE_SIZE", number);
    }

    @Override
    public void getIgnoredSettingsList() {
    }

    @Override
    protected final ModelPropertiesState getState() {
        return (ModelPropertiesState)super.getState();
    }

    @Override
    public boolean isNewDataInput(boolean bl) throws ValidationException {
        String string;
        Number number = this.getNumber(this.jTextFieldToleranceValue);
        if (null == number || number.doubleValue() < 0.0 || number.doubleValue() > 0.01) {
            throw new ValidationException(DialogsLrb.get("SVMS_CONV_TOLERANCE_OUT_OF_RANGE"));
        }
        Number number2 = null;
        if (this.jCheckBoxComplexityFactors.isSelected() && null == (number2 = this.getNumber(this.jTextFieldComplexityFactors))) {
            throw new ValidationException(DialogsLrb.get("SVMS_COMPLEXITY_FACTOR_NULL"));
        }
        Number number3 = null;
        Number number4 = null;
        String string2 = null;
        if (this.jCheckBoxActiveLearning.isSelected()) {
            if (this.jCheckBoxStdDev.isSelected() && null == (number3 = this.getNumber(this.jTextFieldStdDev))) {
                throw new ValidationException(DialogsLrb.get("SVMS_COMPLEXITY_STD_DEV_NULL"));
            }
            number4 = this.getNumber(this.jTextFieldCacheSize);
            if (null == number4) {
                throw new ValidationException(DialogsLrb.get("SVMS_COMPLEXITY_CACHE_SIZE_NULL"));
            }
            string2 = "SVMS_AL_ENABLE";
        } else {
            string2 = "SVMS_AL_DISABLE";
        }
        if (!bl) {
            return bl;
        }
        ModelPropertiesState modelPropertiesState = this.getState();
        String string3 = (String)modelPropertiesState.getBackupValue("SVMS_KERNEL_FUNCTION");
        if (0 != string3.compareTo(string = ModelSVCBuildSettingsPanel.convertToServerKernelFunctionName(this._currentKernelFunctionName))) {
            return true;
        }
        Double d = (Double)modelPropertiesState.getBackupValue("SVMS_CONV_TOLERANCE");
        if (!NameValuePair.areEqual(number.doubleValue(), d)) {
            return true;
        }
        Object object = modelPropertiesState.getBackupValue("SVMS_COMPLEXITY_FACTOR");
        if (!this.areEqual(object, number2)) {
            return true;
        }
        String string4 = (String)modelPropertiesState.getBackupValue("SVMS_ACTIVE_LEARNING");
        if (0 != string2.compareTo(string4)) {
            return true;
        }
        Object object2 = null;
        Object object3 = null;
        if (string4.equals("SVMS_AL_ENABLE")) {
            object2 = modelPropertiesState.getBackupValue("SVMS_STD_DEV");
            if (!this.areEqual(object2, number3)) {
                return true;
            }
            object3 = modelPropertiesState.getBackupValue("SVMS_KERNEL_CACHE_SIZE");
            if (!this.areEqual(object3, number4)) {
                return true;
            }
        }
        return false;
    }

    private boolean areEqual(Object object, Number number) {
        return !(object instanceof BigDecimal ? !NameValuePair.areEqual(number.doubleValue(), ((BigDecimal)object).doubleValue()) : object instanceof String && number != null);
    }
}

