/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.model;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.model.ModelPropertiesState;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.TraversableContext;

public class ModelDTBuildSettingsPanel
extends AbstractPropertiesDialogPanel {
    private JComboBox jComboBoxHomogenity;
    private JLabel jLabelHomogenity;
    private JLabel jLabelMaxDepth;
    private JLabel jLabelMinPcntRecsNode;
    private JLabel jLabelMinPcntRecsSplit;
    private JLabel jLabelMinRecsNode;
    private JLabel jLabelMinRecsSplit;
    private JScrollPane jScrollPaneTitle;
    private JTextField jTxtMaxDepth;
    private JTextField jTxtMinPercentRecordsInNode;
    private JTextField jTxtMinPercentRecordsSplit;
    private JTextField jTxtMinRecordsInNode;
    private JTextField jTxtMinRecordsSplit;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();
    private DefaultComboBoxModel _hommogenityMetrix;
    private String _currentHommogenityMetrixValue;

    public ModelDTBuildSettingsPanel(TraversableContext traversableContext) {
        super(traversableContext);
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.jLabelHomogenity = new JLabel();
        this.jLabelMaxDepth = new JLabel();
        this.jComboBoxHomogenity = new JComboBox();
        this.jLabelMinRecsNode = new JLabel();
        this.jLabelMinPcntRecsNode = new JLabel();
        this.jLabelMinRecsSplit = new JLabel();
        this.jLabelMinPcntRecsSplit = new JLabel();
        this.jTxtMaxDepth = new NumberTextField();
        this.jTxtMinRecordsInNode = new NumberTextField();
        this.jTxtMinPercentRecordsInNode = new NumberTextField();
        this.jTxtMinRecordsSplit = new NumberTextField();
        this.jTxtMinPercentRecordsSplit = new NumberTextField();
        this.jScrollPaneTitle = new JScrollPane();
        this.jLabelHomogenity.setText("Homogenity Metric:");
        this.jLabelMaxDepth.setText("Maximum Depth:");
        this.jComboBoxHomogenity.setModel(new DefaultComboBoxModel<String>(new String[]{"Gini", "Entropy"}));
        this.jLabelMinRecsNode.setText("Minimum Records in a Node:");
        this.jLabelMinPcntRecsNode.setText("Minimum Percent of Records in a Node:");
        this.jLabelMinRecsSplit.setText("Minimum Records for a Split:");
        this.jLabelMinPcntRecsSplit.setText("Minimum Percent of Records for a Split:");
        this.jTxtMaxDepth.setText("7");
        this.jTxtMinRecordsInNode.setText("10");
        this.jTxtMinPercentRecordsInNode.setText("0.05");
        this.jTxtMinRecordsSplit.setText("20");
        this.jTxtMinPercentRecordsSplit.setText("0.1");
        this.jScrollPaneTitle.setBorder(null);
        this.jScrollPaneTitle.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneTitle.setVerticalScrollBarPolicy(21);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jScrollPaneTitle, -2, 403, -2).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelMinRecsNode, -2, 151, -2).addComponent(this.jLabelMaxDepth, -2, 106, -2).addComponent(this.jLabelMinPcntRecsNode).addComponent(this.jLabelMinRecsSplit, -2, 152, -2).addComponent(this.jLabelMinPcntRecsSplit, -2, 202, -2).addComponent(this.jLabelHomogenity)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxHomogenity, -2, 136, -2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTxtMinPercentRecordsSplit, GroupLayout.Alignment.LEADING).addComponent(this.jTxtMinRecordsSplit, GroupLayout.Alignment.LEADING).addComponent(this.jTxtMinPercentRecordsInNode, GroupLayout.Alignment.LEADING).addComponent(this.jTxtMinRecordsInNode, GroupLayout.Alignment.LEADING).addComponent(this.jTxtMaxDepth, GroupLayout.Alignment.LEADING, -2, 106, -2))).addContainerGap(61, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -2, 43, -2).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxHomogenity, -2, -1, -2).addComponent(this.jLabelHomogenity)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMaxDepth).addComponent(this.jTxtMaxDepth, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMinRecsNode).addComponent(this.jTxtMinRecordsInNode, -2, -1, -2)).addGap(6, 6, 6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMinPcntRecsNode).addComponent(this.jTxtMinPercentRecordsInNode, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMinRecsSplit).addComponent(this.jTxtMinRecordsSplit, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMinPcntRecsSplit).addComponent(this.jTxtMinPercentRecordsSplit, -2, -1, -2)).addContainerGap(108, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jLabelHomogenity, this.jLabelMaxDepth, this.jLabelMinPcntRecsNode, this.jLabelMinPcntRecsSplit, this.jLabelMinRecsNode, this.jLabelMinRecsSplit);
        groupLayout.linkSize(1, this.jTxtMaxDepth, this.jTxtMinPercentRecordsInNode, this.jTxtMinPercentRecordsSplit, this.jTxtMinRecordsInNode, this.jTxtMinRecordsSplit);
    }

    private void initUI() {
        ModelPropertiesState modelPropertiesState = this.getState();
        this.loadDescription(this._jDescription, this.jScrollPaneTitle);
        this.jLabelHomogenity.setText(DialogsLrb.get("DT_HOMOGENITY_METRIC"));
        this.jLabelHomogenity.setLabelFor(this.jComboBoxHomogenity);
        this._hommogenityMetrix = new DefaultComboBoxModel<String>(new String[]{DialogsLrb.get("DT_TREE_IMPURITY_GINI"), DialogsLrb.get("DT_TREE_IMPURITY_ENTROPY")});
        this.jComboBoxHomogenity.setModel(this._hommogenityMetrix);
        this._currentHommogenityMetrixValue = modelPropertiesState.getModelSettingStringValue("TREE_IMPURITY_METRIC");
        this.jComboBoxHomogenity.setSelectedItem(this._currentHommogenityMetrixValue);
        modelPropertiesState.setBackupValue("TREE_IMPURITY_METRIC", this._currentHommogenityMetrixValue);
        this.jComboBoxHomogenity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelDTBuildSettingsPanel.this._currentHommogenityMetrixValue = (String)ModelDTBuildSettingsPanel.this.jComboBoxHomogenity.getSelectedItem();
            }
        });
        this.jLabelMaxDepth.setText(DialogsLrb.get("DT_TREE_TERM_MAX_DEPTH"));
        this.jTxtMaxDepth.setToolTipText(DialogsLrb.get("DT_TREE_TERM_MAX_DEPTH_TOOLTIP"));
        this.jLabelMaxDepth.setLabelFor(this.jTxtMaxDepth);
        this.setDataType(this.jTxtMaxDepth, Integer.class);
        this.setSigned(this.jTxtMaxDepth, false);
        this.setLocale(this.jTxtMaxDepth, modelPropertiesState.getLocale());
        BigDecimal bigDecimal = modelPropertiesState.getModelSettingNumValue("TREE_TERM_MAX_DEPTH");
        modelPropertiesState.setBackupValue("TREE_TERM_MAX_DEPTH", bigDecimal);
        this.setNumber(this.jTxtMaxDepth, bigDecimal);
        this.jLabelMinRecsNode.setText(DialogsLrb.get("DT_TREE_TERM_MINREC_NODE"));
        this.jTxtMinRecordsInNode.setToolTipText(DialogsLrb.get("DT_TREE_TERM_MINREC_NODE_TOOLTIP"));
        this.jLabelMinRecsNode.setLabelFor(this.jTxtMinRecordsInNode);
        this.setDataType(this.jTxtMinRecordsInNode, Integer.class);
        this.setSigned(this.jTxtMinRecordsInNode, false);
        this.setLocale(this.jTxtMinRecordsInNode, modelPropertiesState.getLocale());
        bigDecimal = modelPropertiesState.getModelSettingNumValue("TREE_TERM_MINREC_NODE");
        modelPropertiesState.setBackupValue("TREE_TERM_MINREC_NODE", bigDecimal);
        this.setNumber(this.jTxtMinRecordsInNode, bigDecimal);
        this.jLabelMinPcntRecsNode.setText(DialogsLrb.get("DT_TREE_TERM_MINPCT_NODE"));
        this.jTxtMinPercentRecordsInNode.setToolTipText(DialogsLrb.get("DT_TREE_TERM_MINPCT_NODE_TOOLTIP"));
        this.jLabelMinPcntRecsNode.setLabelFor(this.jTxtMinPercentRecordsInNode);
        this.setDataType(this.jTxtMinPercentRecordsInNode, Double.class);
        this.setSigned(this.jTxtMinPercentRecordsInNode, false);
        this.setLocale(this.jTxtMinPercentRecordsInNode, modelPropertiesState.getLocale());
        bigDecimal = modelPropertiesState.getModelSettingNumValue("TREE_TERM_MINPCT_NODE");
        modelPropertiesState.setBackupValue("TREE_TERM_MINPCT_NODE", bigDecimal);
        this.setNumber(this.jTxtMinPercentRecordsInNode, bigDecimal);
        this.jLabelMinRecsSplit.setText(DialogsLrb.get("DT_TREE_TERM_MINREC_SPLIT"));
        this.jTxtMinRecordsSplit.setToolTipText(DialogsLrb.get("DT_TREE_TERM_MINREC_SPLIT_TOOLTIP"));
        this.jLabelMinRecsSplit.setLabelFor(this.jTxtMinRecordsSplit);
        this.setDataType(this.jTxtMinRecordsSplit, Integer.class);
        this.setSigned(this.jTxtMinRecordsSplit, false);
        this.setLocale(this.jTxtMinRecordsSplit, modelPropertiesState.getLocale());
        bigDecimal = modelPropertiesState.getModelSettingNumValue("TREE_TERM_MINREC_SPLIT");
        modelPropertiesState.setBackupValue("TREE_TERM_MINREC_SPLIT", bigDecimal);
        this.setNumber(this.jTxtMinRecordsSplit, bigDecimal);
        this.jLabelMinPcntRecsSplit.setText(DialogsLrb.get("DT_TREE_TERM_MINPCT_SPLIT"));
        this.jTxtMinPercentRecordsSplit.setToolTipText(DialogsLrb.get("DT_TREE_TERM_MINPCT_SPLIT_TOOLTIP"));
        this.jLabelMinPcntRecsSplit.setLabelFor(this.jTxtMinPercentRecordsSplit);
        this.setDataType(this.jTxtMinPercentRecordsSplit, Double.class);
        this.setSigned(this.jTxtMinPercentRecordsSplit, false);
        this.setLocale(this.jTxtMinPercentRecordsSplit, modelPropertiesState.getLocale());
        bigDecimal = modelPropertiesState.getModelSettingNumValue("TREE_TERM_MINPCT_SPLIT");
        modelPropertiesState.setBackupValue("TREE_TERM_MINPCT_SPLIT", bigDecimal);
        this.setNumber(this.jTxtMinPercentRecordsSplit, bigDecimal);
    }

    @Override
    public void processInput() {
        ModelPropertiesState modelPropertiesState = this.getState();
        modelPropertiesState.setValue("TREE_IMPURITY_METRIC", this._currentHommogenityMetrixValue);
        Number number = this.getNumber(this.jTxtMaxDepth);
        if (null == number || number.intValue() < 2 || number.intValue() > 20) {
            modelPropertiesState.setValidationError(DialogsLrb.get("DT_TREE_TERM_MAX_DEPTH_INVALID"));
            return;
        }
        modelPropertiesState.setValue("TREE_TERM_MAX_DEPTH", number);
        number = this.getNumber(this.jTxtMinRecordsInNode);
        if (null == number || number.intValue() < 0) {
            modelPropertiesState.setValidationError(DialogsLrb.get("DT_TREE_TERM_MINREC_NODE_INVALID"));
            return;
        }
        modelPropertiesState.setValue("TREE_TERM_MINREC_NODE", number);
        number = this.getNumber(this.jTxtMinPercentRecordsInNode);
        if (null == number || number.intValue() < 0 || number.intValue() > 10) {
            modelPropertiesState.setValidationError(DialogsLrb.get("DT_TREE_TERM_MINPCT_NODE_INVALID"));
            return;
        }
        modelPropertiesState.setValue("TREE_TERM_MINPCT_NODE", number);
        number = this.getNumber(this.jTxtMinRecordsSplit);
        if (null == number || number.intValue() < 0) {
            modelPropertiesState.setValidationError(DialogsLrb.get("DT_TREE_TERM_MINREC_SPLIT_INVALID"));
            return;
        }
        modelPropertiesState.setValue("TREE_TERM_MINREC_SPLIT", number);
        number = this.getNumber(this.jTxtMinPercentRecordsSplit);
        if (null == number || number.intValue() < 0 || number.intValue() > 20) {
            modelPropertiesState.setValidationError(DialogsLrb.get("DT_TREE_TERM_MINPCT_SPLIT_INVALID"));
            return;
        }
        modelPropertiesState.setValue("TREE_TERM_MINPCT_SPLIT", number);
    }

    @Override
    protected final ModelPropertiesState getState() {
        return (ModelPropertiesState)super.getState();
    }
}

