/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.model;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.BaseTreeTableNode;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogState;
import oracle.dmt.dataminer.workflow.dialog.model.ModelDTBuildSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.model.ModelGLMBuildSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.model.ModelNBBuildSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.model.ModelPropertiesState;
import oracle.dmt.dataminer.workflow.dialog.model.ModelSVCBuildSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.model.PerformancePriorsPanel;
import oracle.ide.Ide;
import oracle.ide.controls.JTabbedPane2;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.dialogs.MessageDialog;

public class MainModelPropertiesPanel
extends AbstractPropertiesDialogPanel {
    private JPanel jBuildSettingsPanel;
    private JTabbedPane2 jMainTabbedPane;
    private JPanel jPerformancePanel;
    private static String[] _TABS = new String[]{DialogsLrb.get("MODEL_PROPERTY_TAB_ALGORITHM"), DialogsLrb.get("MODEL_PROPERTY_TAB_PERFORMANCE")};
    private String _cardLoading = "Loading";
    private String _cardReady = "Ready";
    private CardLayout _algSettingslayout = new CardLayout();
    private CardLayout _performanceLayout = new CardLayout();
    private Hashtable<JPanel, AbstractPropertiesDialogPanel> _childPanels = new Hashtable();
    private static String _UNDER_CONSTRUCTION = "Not implemented yet";
    protected static final String _GENERAL = DialogsLrb.get("PROPERTIES_DLG_GENERAL");

    public MainModelPropertiesPanel(TraversableContext traversableContext) {
        super(traversableContext);
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.jMainTabbedPane = new JTabbedPane2();
        this.jBuildSettingsPanel = new JPanel();
        this.jPerformancePanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout(this.jBuildSettingsPanel);
        this.jBuildSettingsPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 514, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 358, Short.MAX_VALUE));
        this.jMainTabbedPane.addTab("Tab 1", (Component)this.jBuildSettingsPanel);
        GroupLayout groupLayout2 = new GroupLayout(this.jPerformancePanel);
        this.jPerformancePanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 514, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 358, Short.MAX_VALUE));
        this.jMainTabbedPane.addTab("Tab 2", (Component)this.jPerformancePanel);
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jMainTabbedPane, -1, 519, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jMainTabbedPane, -1, 386, Short.MAX_VALUE));
    }

    private void initUI() {
        for (int i = 0; i < _TABS.length; ++i) {
            this.jMainTabbedPane.setTitleAt(i, _TABS[i]);
        }
        this.showLoadingPanel(this.jBuildSettingsPanel, this._algSettingslayout);
        this.showLoadingPanel(this.jPerformancePanel, this._performanceLayout);
        AbstractPropertiesDialogPanel.LoadUI loadUI = new AbstractPropertiesDialogPanel.LoadUI(SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_TITLE"), SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_MESG"));
        loadUI.start();
    }

    private void showLoadingPanel(JPanel jPanel, CardLayout cardLayout) {
        AbstractPropertiesDialogPanel.LoadingStatusPanel loadingStatusPanel = this.createLoadingStatusPanel();
        jPanel.setLayout(cardLayout);
        jPanel.add((Component)loadingStatusPanel, this._cardLoading);
        cardLayout.show(jPanel, this._cardLoading);
    }

    private void addPanel(JPanel jPanel, AbstractPropertiesDialogPanel abstractPropertiesDialogPanel) {
        this._childPanels.put(jPanel, abstractPropertiesDialogPanel);
    }

    @Override
    public void processInput() {
        Vector<AbstractPropertiesDialogPanel> vector = new Vector<AbstractPropertiesDialogPanel>(this._childPanels.values());
        for (int i = 0; i < vector.size(); ++i) {
            vector.elementAt(i).processInput();
        }
    }

    @Override
    public void getIgnoredSettingsList() {
        Vector<AbstractPropertiesDialogPanel> vector = new Vector<AbstractPropertiesDialogPanel>(this._childPanels.values());
        for (int i = 0; i < vector.size(); ++i) {
            vector.elementAt(i).getIgnoredSettingsList();
        }
    }

    @Override
    public void initializeFromState(AbstractPropertiesDialogState abstractPropertiesDialogState) {
        ModelPropertiesState modelPropertiesState = (ModelPropertiesState)abstractPropertiesDialogState;
        String string = modelPropertiesState.getAlgorithmType();
        String string2 = modelPropertiesState.getFunction().value();
        AbstractPropertiesDialogPanel abstractPropertiesDialogPanel = null;
        boolean bl = ServerConstants.MiningFunction.isClassification(string2);
        if (bl) {
            if (ServerConstants.Algorithm.isSVM(string)) {
                abstractPropertiesDialogPanel = new ModelSVCBuildSettingsPanel(this.getTraversableContext());
            } else if (ServerConstants.Algorithm.isNB(string)) {
                abstractPropertiesDialogPanel = new ModelNBBuildSettingsPanel(this.getTraversableContext());
            } else if (ServerConstants.Algorithm.isDT(string)) {
                abstractPropertiesDialogPanel = new ModelDTBuildSettingsPanel(this.getTraversableContext());
            } else if (ServerConstants.Algorithm.isGLM(string)) {
                abstractPropertiesDialogPanel = new ModelGLMBuildSettingsPanel(this.getTraversableContext());
            }
        }
        if (null == abstractPropertiesDialogPanel) {
            abstractPropertiesDialogPanel = this.createModelUnderConstructionPanel();
        }
        this.jBuildSettingsPanel.setLayout(this._algSettingslayout);
        this.jBuildSettingsPanel.add((Component)abstractPropertiesDialogPanel, this._cardReady);
        this._algSettingslayout.show(this.jBuildSettingsPanel, this._cardReady);
        this.addPanel(this.jBuildSettingsPanel, abstractPropertiesDialogPanel);
        PerformancePriorsPanel performancePriorsPanel = null;
        if (bl) {
            performancePriorsPanel = new PerformancePriorsPanel(this.getTraversableContext());
            this.jPerformancePanel.add((Component)performancePriorsPanel, this._cardReady);
            this._performanceLayout.show(this.jPerformancePanel, this._cardReady);
            this.addPanel(this.jPerformancePanel, performancePriorsPanel);
        } else {
            this.jMainTabbedPane.remove((Component)this.jPerformancePanel);
        }
        this.jMainTabbedPane.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                Object object = propertyChangeEvent.getOldValue();
                System.out.println(object.toString());
            }
        });
        this.jMainTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Component component;
                if (changeEvent.getSource() instanceof JTabbedPane && (component = MainModelPropertiesPanel.this.jMainTabbedPane.getSelectedComponent()) instanceof JPanel) {
                    JPanel jPanel = (JPanel)component;
                    AbstractPropertiesDialogPanel abstractPropertiesDialogPanel = (AbstractPropertiesDialogPanel)MainModelPropertiesPanel.this._childPanels.get(jPanel);
                    if (abstractPropertiesDialogPanel != null) {
                        abstractPropertiesDialogPanel.tabSelected();
                    }
                }
            }
        });
    }

    private AbstractPropertiesDialogPanel createModelUnderConstructionPanel() {
        AbstractPropertiesDialogPanel abstractPropertiesDialogPanel = new AbstractPropertiesDialogPanel(this.getTraversableContext()){

            @Override
            public void processInput() {
            }

            @Override
            public void getIgnoredSettingsList() {
            }

            @Override
            protected final AbstractPropertiesDialogState getState() {
                return (AbstractPropertiesDialogState)this.getTraversableContext().get("dialogBoxState");
            }

            @Override
            public void initializeFromState(AbstractPropertiesDialogState abstractPropertiesDialogState) {
            }
        };
        abstractPropertiesDialogPanel.setLayout(new BorderLayout());
        abstractPropertiesDialogPanel.add((Component)new JLabel(_UNDER_CONSTRUCTION), "Center");
        return abstractPropertiesDialogPanel;
    }

    class TabSelectionCancelException
    extends Exception {
        TabSelectionCancelException() {
        }
    }

    class CustomTab
    extends JTabbedPane2 {
        private boolean _modified = false;

        CustomTab() {
        }

        public void setSelectedIndex(int n) {
            int n2 = this.getSelectedIndex();
            if (n2 == -1) {
                super.setSelectedIndex(n);
                return;
            }
            ValidationException validationException = null;
            TabSelectionCancelException tabSelectionCancelException = null;
            try {
                this.validateCurrentTab(n2);
            }
            catch (ValidationException validationException2) {
                validationException = validationException2;
            }
            catch (TabSelectionCancelException tabSelectionCancelException2) {
                tabSelectionCancelException = tabSelectionCancelException2;
            }
            if (validationException != null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)validationException.getLocalizedMessage(), (String)validationException.getDialogTitle(), null);
            } else {
                if (tabSelectionCancelException != null) {
                    return;
                }
                super.setSelectedIndex(n);
            }
        }

        private void validateCurrentTab(int n) throws ValidationException, TabSelectionCancelException {
            Component component = MainModelPropertiesPanel.this.jMainTabbedPane.getComponentAt(n);
            if (component instanceof JPanel) {
                JPanel jPanel = (JPanel)component;
                AbstractPropertiesDialogPanel abstractPropertiesDialogPanel = (AbstractPropertiesDialogPanel)MainModelPropertiesPanel.this._childPanels.get(jPanel);
                if (abstractPropertiesDialogPanel != null) {
                    if (!this._modified) {
                        this._modified = abstractPropertiesDialogPanel.isNewDataInput(true);
                        if (this._modified) {
                            this._modified = MessageDialog.confirm((Component)((Object)this), (Object)DialogsLrb.get("BUILD_MODEL_IMMUTABLE_MSG"), (String)DialogsLrb.get("BUILD_MODEL_IMMUTABLE_TITLE"), null);
                            if (!this._modified) {
                                throw new TabSelectionCancelException();
                            }
                        }
                    } else {
                        Boolean.valueOf(abstractPropertiesDialogPanel.isNewDataInput(false));
                    }
                }
            }
        }
    }

    class ModelPropertiesPropertiesNode
    extends BaseTreeTableNode {
        private String _propName;
        private String _propValue;

        ModelPropertiesPropertiesNode() {
            this._propName = "-";
            this._propValue = "";
        }

        ModelPropertiesPropertiesNode(String string) {
            this._propName = string;
            this._propValue = "";
        }

        ModelPropertiesPropertiesNode(String string, String string2) {
            this._propName = string;
            this._propValue = string2;
        }

        ModelPropertiesPropertiesNode(String string, Timestamp timestamp) {
            this._propName = string;
            DateFormat dateFormat = SimpleDateFormat.getDateTimeInstance(1, 1, Locale.getDefault());
            this._propValue = dateFormat.format(timestamp);
        }

        @Override
        public String toString() {
            return this._propName;
        }

        public Object getValue(int n) {
            return this._propValue;
        }
    }
}

