/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.model;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.controls.BaseCostMatrixTable;
import oracle.dmt.dataminer.controls.CostMatrixDataProvider;
import oracle.dmt.dataminer.controls.CostMatrixInfo;
import oracle.dmt.dataminer.controls.CostMatrixModel;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogState;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.model.ModelPropertiesState;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.TraversableContext;

public class CostMatrixPanel
extends AbstractPropertiesDialogPanel
implements ActionListener {
    private ButtonGroup buttonGroup;
    private JButton jBtnApply;
    private JComboBox jCmbBoxTarget;
    private JLabel jLabelFootNote;
    private JLabel jLabelTitle;
    private JLabel jLblTable;
    private JLabel jLblTarget;
    private JLabel jLblWeight;
    private JRadioButton jRdBtnFalsPositive;
    private JRadioButton jRdBtnFalseNegative;
    private JScrollPane jScrollPaneDescription;
    private JScrollPane jScrollPaneTable;
    private JTextField jTxtFldWeight;
    private GenericTable niceTableCosts;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();

    public CostMatrixPanel(TraversableContext traversableContext) {
        super(traversableContext);
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jLblTarget = new JLabel();
        this.jCmbBoxTarget = new JComboBox();
        this.jScrollPaneDescription = new JScrollPane();
        this.jRdBtnFalsPositive = new JRadioButton();
        this.jRdBtnFalseNegative = new JRadioButton();
        this.jLblWeight = new JLabel();
        this.jTxtFldWeight = new NumberTextField();
        this.jLblTable = new JLabel();
        this.jScrollPaneTable = new JScrollPane();
        this.niceTableCosts = new BaseCostMatrixTable();
        this.jLabelFootNote = new JLabel();
        this.jLabelTitle = new JLabel();
        this.jBtnApply = new JButton();
        this.buttonGroup.add(this.jRdBtnFalsPositive);
        this.buttonGroup.add(this.jRdBtnFalseNegative);
        this.jLblTarget.setText("Target:");
        this.jScrollPaneDescription.setBorder(null);
        this.jScrollPaneDescription.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneDescription.setVerticalScrollBarPolicy(21);
        this.jRdBtnFalsPositive.setText("False Positive");
        this.jRdBtnFalsPositive.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRdBtnFalsPositive.setMargin(new Insets(0, 0, 0, 0));
        this.jRdBtnFalseNegative.setText("False Negative");
        this.jRdBtnFalseNegative.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRdBtnFalseNegative.setMargin(new Insets(0, 0, 0, 0));
        this.jLblWeight.setText("Weight:");
        this.jTxtFldWeight.setToolTipText("Range > 0");
        this.jLblTable.setText("Cost matrix Weights:");
        this.niceTableCosts.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPaneTable.setViewportView((Component)this.niceTableCosts);
        this.jLabelFootNote.setText("Cost Matrix: Rows = Actual; Columns = Predicted");
        this.jLabelTitle.setText("Use this screen to define costs for your target values for scoring purposes.");
        this.jBtnApply.setText("Apply");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPaneTable, GroupLayout.Alignment.LEADING, -1, 442, Short.MAX_VALUE).addComponent(this.jLabelFootNote, GroupLayout.Alignment.LEADING, -2, 336, -2).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(22, 22, 22).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRdBtnFalseNegative, -2, 324, -2).addComponent(this.jRdBtnFalsPositive, -2, 332, -2))).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jScrollPaneDescription, -1, 423, Short.MAX_VALUE).addGap(19, 19, 19)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLblWeight, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTxtFldWeight, -2, 82, -2).addGap(60, 60, 60).addComponent(this.jBtnApply).addGap(148, 148, 148)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLblTarget, -2, 65, -2).addGap(19, 19, 19).addComponent(this.jCmbBoxTarget, 0, 358, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLabelTitle, -2, 397, -2).addGap(40, 40, 40)).addComponent(this.jLblTable, GroupLayout.Alignment.LEADING, -2, 123, -2)).addGap(18, 18, 18)));
        groupLayout.linkSize(0, this.jRdBtnFalsPositive, this.jRdBtnFalseNegative);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCmbBoxTarget, -2, -1, -2).addComponent(this.jLblTarget)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneDescription, -2, 39, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRdBtnFalsPositive).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRdBtnFalseNegative).addGap(15, 15, 15).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblWeight).addComponent(this.jTxtFldWeight, -2, -1, -2).addComponent(this.jBtnApply)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLblTable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneTable, -1, 307, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelFootNote).addContainerGap()));
    }

    private void loadDescription() {
        this._jDescription.setText(DialogsLrb.get("COST_MATRIX_WEIGHTING_DESCRIPTION"));
        this.jScrollPaneDescription.getViewport().add((Component)this._jDescription);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            JButton jButton = (JButton)object;
            if (jButton.equals(this.jBtnApply) && null != this.getState().getResultCostMatrixInfo()) {
                Object object2 = this.getState().getSelectedTargetValue();
                if (this.getState().isFalsePositive()) {
                    this.getState().getResultCostMatrixInfo().updateColumn(object2, new BigDecimal(this.getNumber(this.jTxtFldWeight).toString()));
                } else {
                    this.getState().getResultCostMatrixInfo().updateRow(object2, new BigDecimal(this.getNumber(this.jTxtFldWeight).toString()));
                }
                ((BaseCostMatrixTable)this.niceTableCosts).setModel(new CostMatrixModel(new CostMatrixDataProvider(this.getState().getResultCostMatrixInfo())));
                ((DefaultTableModel)this.niceTableCosts.getModel()).fireTableDataChanged();
            }
        } else if (object instanceof JRadioButton) {
            this.getState().setFalsePositive(this.jRdBtnFalsPositive.isSelected());
        } else if (object instanceof JComboBox) {
            Object object3 = this.jCmbBoxTarget.getSelectedItem();
            this.getState().setSelectedTargetValue(object3);
        }
    }

    @Override
    public void processInput() {
        CostMatrixInfo costMatrixInfo = this.getState().getResultCostMatrixInfo();
        if (costMatrixInfo != null && costMatrixInfo.isCostMatrixTrue() && costMatrixInfo.isEmpty()) {
            this.getState().setValidationError(DialogsLrb.get("COST_MATRIX_SETTINGS_EMPTY"));
            return;
        }
        this.getState().setValue("BUILD_SETTING_COST_MATRIX_OPTION", costMatrixInfo.getOptionValue());
    }

    @Override
    protected final ModelPropertiesState getState() {
        return (ModelPropertiesState)super.getState();
    }

    private void initUI() {
        this.jLabelTitle.setText(DialogsLrb.get("COST_MATRIX_SETTINGS_DIALOG_DETAILED_DESCRIPTION"));
        this.loadDescription();
        this.jRdBtnFalsPositive.setText(DialogsLrb.get("COST_MATRIX_FP_DEFINITION"));
        this.jRdBtnFalsPositive.addActionListener(this);
        this.jRdBtnFalseNegative.setText(DialogsLrb.get("COST_MATRIX_FN_DEFINITION"));
        this.jRdBtnFalseNegative.addActionListener(this);
        this.jLblTarget.setText(DialogsLrb.get("COST_MATRIX_MATRIX_TARGET"));
        this.jLblTable.setText(DialogsLrb.get("COST_MATRIX_MATRIX_TARGET_TABLE_TITLE"));
        this.jLabelFootNote.setText(DialogsLrb.get("COST_MATRIX_MATRIX_NOTE"));
        this.jCmbBoxTarget.addActionListener(this);
        this.jRdBtnFalsPositive.setSelected(this.getState().isFalsePositive());
        this.jRdBtnFalseNegative.setSelected(!this.getState().isFalsePositive());
        this.setDataType(this.jTxtFldWeight, Double.class);
        this.setSigned(this.jTxtFldWeight, false);
        this.setLocale(this.jTxtFldWeight, this.getState().getLocale());
        this.setNumber(this.jTxtFldWeight, ModelPropertiesState.DEFAULT_WEIGHT);
        this.jTxtFldWeight.setToolTipText(DialogsLrb.get("COST_MATRIX_MATRIX_TARGET_TOOLTIP"));
        this.jBtnApply.setText(DialogsLrb.get("COST_MATRIX_WEIGHT_APPLY"));
        this.jBtnApply.addActionListener(this);
        this.setComponentsEnabled(false);
        AbstractPropertiesDialogPanel.LoadUI loadUI = new AbstractPropertiesDialogPanel.LoadUI(SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_TITLE"), SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_MESG"));
        loadUI.start();
    }

    @Override
    public void initializeFromState(AbstractPropertiesDialogState abstractPropertiesDialogState) {
        Object[] objectArray;
        String string;
        CostMatrixInfo costMatrixInfo = this.getState().getResultCostMatrixInfo();
        if (costMatrixInfo == null) {
            return;
        }
        boolean bl = costMatrixInfo != null && costMatrixInfo.isCostMatrixTrue();
        Object[] objectArray2 = this.getState().getTargetValues();
        String string2 = string = objectArray2 != null && objectArray2.length > 0 ? objectArray2[0] : "";
        if (objectArray2 != null && objectArray2.length > 0) {
            objectArray = objectArray2;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = string;
        }
        this.jCmbBoxTarget.setModel(new DefaultListComboBoxModel(objectArray));
        this.jCmbBoxTarget.setSelectedItem(string);
        this.getState().setSelectedTargetValue(string);
        ((BaseCostMatrixTable)this.niceTableCosts).setModel(new CostMatrixModel(new CostMatrixDataProvider(costMatrixInfo)));
        this.setComponentsEnabled(bl);
        this.getState().setBackupValue("BUILD_SETTING_COST_MATRIX_OPTION", this.getState().getOriginalCostMatrixInfo().getOptionValue());
    }

    private void setComponentsEnabled(boolean bl) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl);
        }
        this.niceTableCosts.setEnabled(bl);
        this._jDescription.setEnabled(bl);
    }
}

