/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.join;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.join.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.JoinNode;
import oracle.dmt.dataminer.workflow.xmlschema.JoinNodeType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;

public class ResolverPanel
extends AbstractDialogPanel {
    private GenericTable _nodeTable = new GenericTable();
    private NodeTableModel _nodeTblModel;
    private JoinNodeType _metadataCopy;
    private boolean _dirty;
    private boolean _resolveAll;
    private static final String SELECT_MAPPING_NODE = DialogsLrb.get("JOIN_RESOLVER_SELECT_NEW_NODE");
    private final String UNRESOLVE_SKIPPED_INFORMATION = "UNRESOLVE_SKIPPED_INFORMATION:" + this.getClass().getName();
    private ButtonGroup buttonGroup;
    private ComponentWithTitlebar<JComponent> componentWithTitlebar;
    private JRadioButton jRemoveButton;
    private JRadioButton jResolveButton;
    private TransparentPanel transparentPanel;
    static int MISSING_NODE_COLUMN = 0;
    static int NEW_NODE_COLUMN = 1;

    public ResolverPanel(Context context, JoinNode joinNode, JoinNodeType joinNodeType) {
        super(context, joinNode);
        this._metadataCopy = joinNodeType;
        this._resolveAll = false;
        this._dirty = false;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("JOIN_RESOLVER_REMOVE_BTN"), this.jRemoveButton);
        hashMap.put(DialogsLrb.get("JOIN_RESOLVER_RESOLVE_BTN"), this.jResolveButton);
        UIResourceHelper.setComponentText(hashMap);
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"join_resolve_dialog");
        this.jResolveButton.setSelected(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this._nodeTable);
        this.componentWithTitlebar.setComponent((JComponent)jScrollPane);
        this.componentWithTitlebar.setLabel(new JLabel(DialogsLrb.get("JOIN_RESOLVER_TABLE_TITLE")));
        ControlBar controlBar = new ControlBar();
        this.componentWithTitlebar.setControlBar(controlBar);
        JoinNode joinNode = (JoinNode)this.getData();
        this._nodeTblModel = new NodeTableModel(joinNode.getUnResolveNodes(), joinNode.findAvailableJoinDataNode());
        this._nodeTable.setModel((TableModel)((Object)this._nodeTblModel));
        TableColumn tableColumn = this._nodeTable.getColumnModel().getColumn(NEW_NODE_COLUMN);
        tableColumn.setCellEditor(new NewNodeEditor());
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        tableColumn.setCellRenderer(defaultTableCellRenderer);
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jRemoveButton = new JRadioButton();
        this.jResolveButton = new JRadioButton();
        this.transparentPanel = new TransparentPanel();
        this.componentWithTitlebar = new ComponentWithTitlebar();
        this.buttonGroup.add(this.jRemoveButton);
        this.jRemoveButton.setText("Remove");
        this.jRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResolverPanel.this.jRemoveButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup.add(this.jResolveButton);
        this.jResolveButton.setText("Resolve");
        this.jResolveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResolverPanel.this.jResolveButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.transparentPanel);
        this.transparentPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.componentWithTitlebar, -1, 380, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.componentWithTitlebar, -1, 150, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.transparentPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveButton, -2, 186, -2).addComponent(this.jResolveButton, -2, 186, -2)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jRemoveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jResolveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.transparentPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void jRemoveButtonActionPerformed(ActionEvent actionEvent) {
    }

    private void jResolveButtonActionPerformed(ActionEvent actionEvent) {
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public boolean doWork() {
        boolean bl = true;
        JoinNode joinNode = (JoinNode)this.getData();
        if (this.jResolveButton.isSelected()) {
            if (this.isDirty()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<AbstractNode> arrayList2 = new ArrayList<AbstractNode>();
                this._nodeTblModel.getMappingNodes(arrayList, arrayList2);
                if (this.jResolveButton.isSelected()) {
                    this._resolveAll = joinNode.resolveNodes(this._metadataCopy, arrayList, arrayList2);
                }
                if (!this._resolveAll) {
                    MessageDialog.optionalInformation((String)this.UNRESOLVE_SKIPPED_INFORMATION, (Component)Ide.getMainWindow(), (String)DialogsLrb.get("JOIN_RESOLVER_MISSING_WARN"), (String)DialogsLrb.get("JOIN_RESOLVER_DIALOG_TITLE"), null);
                }
            }
        } else {
            joinNode.removeInvalidNodes(this._metadataCopy);
        }
        return bl;
    }

    class NodeTableModel
    extends GenericBaseTableModel {
        private List<String> _missingNodes = new ArrayList<String>();
        private List<NewNode> _newNodes = new ArrayList<NewNode>();
        private List<NewNode> _availNodes = new ArrayList<NewNode>();

        public NodeTableModel(List<String> list, List<AbstractNode> list2) {
            Collections.sort(list);
            for (String object : list) {
                this._missingNodes.add(object);
                this._newNodes.add(new NewNode(null));
            }
            Collections.sort(list2, new AbstractNodeComparator());
            for (AbstractNode abstractNode : list2) {
                this._availNodes.add(new NewNode(abstractNode));
            }
            Vector vector = new Vector();
            vector.add(DialogsLrb.get("JOIN_RESOLVER_MISSING_COLUMN"));
            vector.add(DialogsLrb.get("JOIN_RESOLVER_NEW_COLUMN"));
            this.setColumnIdentifiers(vector);
            if (list == null) {
                this.setRowCount(0);
            } else {
                this.setRowCount(list.size());
            }
            this.setColumnCount(vector.size());
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == NEW_NODE_COLUMN;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != NEW_NODE_COLUMN) {
                return;
            }
            NewNode newNode = (NewNode)object;
            this._newNodes.set(n, newNode);
            ResolverPanel.this._dirty = true;
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (NEW_NODE_COLUMN == n2) {
                object = this._newNodes.get(n);
            } else if (MISSING_NODE_COLUMN == n2) {
                object = this._missingNodes.get(n);
            }
            return object;
        }

        public List<NewNode> getAvailNodes() {
            return this._availNodes;
        }

        public void getMappingNodes(List<String> list, List<AbstractNode> list2) {
            if (list != null && list2 != null) {
                list.clear();
                list2.clear();
                for (int i = 0; i < this.getRowCount(); ++i) {
                    String string = (String)this.getValueAt(i, MISSING_NODE_COLUMN);
                    NewNode newNode = (NewNode)this.getValueAt(i, NEW_NODE_COLUMN);
                    list.add(string);
                    list2.add(newNode.getAbstractNode());
                }
            }
        }
    }

    class NewNode {
        private AbstractNode _newNode;

        public NewNode(AbstractNode abstractNode) {
            this._newNode = abstractNode;
        }

        public AbstractNode getAbstractNode() {
            return this._newNode;
        }

        public String toString() {
            return this._newNode == null ? SELECT_MAPPING_NODE : this._newNode.getData().getName();
        }
    }

    class AbstractNodeComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object object, Object object2) {
            if (object != null && object instanceof AbstractNode && object2 != null && object2 instanceof AbstractNode) {
                return ((AbstractNode)object).getData().getName().compareTo(((AbstractNode)object2).getData().getName());
            }
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return object != null && object instanceof AbstractNodeComparator;
        }
    }

    class NewNodeEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        NewNode currentValue;
        JComboBox comboComponent = new JComboBox();
        protected static final String EDIT = "edit";

        public NewNodeEditor() {
            this.comboComponent.setActionCommand(EDIT);
            this.comboComponent.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentValue;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                this.currentValue = (NewNode)this.comboComponent.getSelectedItem();
                this.fireEditingStopped();
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            NodeTableModel nodeTableModel = (NodeTableModel)((Object)jTable.getModel());
            List<NewNode> list = nodeTableModel.getAvailNodes();
            this.comboComponent.removeAllItems();
            for (NewNode newNode : list) {
                this.comboComponent.addItem(newNode);
            }
            return this.comboComponent;
        }
    }
}

