/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.join;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DBObjectNameEditor;
import oracle.dmt.dataminer.controls.NiceTableWithToolbar;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.join.AttrsDialog;
import oracle.dmt.dataminer.workflow.dialog.join.AttrsPanel;
import oracle.dmt.dataminer.workflow.dialog.join.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.join.JoinEditorPanel;
import oracle.dmt.dataminer.workflow.inspect.JoinNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowJoinNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowPIComponent;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.JoinNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinOutputColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefDBColumnType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;

public class OutputColumnPanel
extends AbstractDialogPanel {
    private WorkflowJoinNodePropertyProxyModel _propertyModel;
    private JoinEditorPanel _parent;
    private JoinOutputColumnsType _outputColumns;
    private AttrsTableModel _models;
    private NiceTableWithToolbar _tableWithToolbar;
    private static Icon _error_icon;
    private static Icon _validAttrIcon;
    private static Icon _invalidAttrIcon;
    private JButton _removeBtn;
    private JButton _addBtn;
    private boolean _dirty;
    private JoinNode.JoinOutputColumnNameGenerator _outputColumnNameGenerator;
    private JCheckBox jAutoCheckBox;
    private JLabel jColumnSpecifiedLabel;
    private ComponentWithTitlebar<JComponent> joinKeyComponentWithTitlebar;
    private TransparentPanel joinKeyTransparentPanel;

    public OutputColumnPanel(PropertyModel propertyModel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for join node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.setMinimumSize(new Dimension(200, 400));
        this.init((JoinNode)this._data, propertyModel);
    }

    public OutputColumnPanel(Context context, JoinNode joinNode, JoinEditorPanel joinEditorPanel) {
        super(context, joinNode);
        assert (context != null) : "Context must not be null.";
        assert (joinNode != null) : "Join node must not be null.";
        assert (joinNode instanceof JoinNode) : "Must be an instance of join node.";
        this._parent = joinEditorPanel;
        this.init(joinNode, this._parent.getModel());
    }

    private void init(JoinNode joinNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        this._dirty = false;
        if (this._propertyModel != null) {
            this._outputColumns = (JoinOutputColumnsType)MetaDataHelper.copyMetadataObject(((JoinNodeType)joinNode.getData()).getOutputColumns());
            this._outputColumnNameGenerator = new JoinNode.JoinOutputColumnNameGenerator(this._outputColumns);
        } else {
            this._outputColumns = this._parent.getOutputColumns();
            this._outputColumnNameGenerator = this._parent.getOutputColumnNameGenerator();
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void updateNode() {
        JoinNode joinNode = (JoinNode)this.getData();
        JoinNodeType joinNodeType = (JoinNodeType)joinNode.getData();
        ArrayList<Property> arrayList = new ArrayList<Property>();
        ComplexProperty complexProperty = new ComplexProperty("joinOutputColumns", this._outputColumns);
        complexProperty.setOldData(joinNodeType.getOutputColumns());
        arrayList.add(new Property(String.valueOf(JoinNodePropertyModel.RowIndex.JOIN_OUTPUT_COLUMNS), null, complexProperty, null, null));
        this._propertyModel.setValueAt(PropertyLrb.get("PI_JOIN_GROUP_COLUMNS_ATTRIBUTE_OUTPUT_COLUMN_CHANGED"), this.getData(), arrayList);
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("JOIN_DATA_AUTO_SETTING"), this.jAutoCheckBox);
        UIResourceHelper.setComponentText(hashMap);
        Class<WorkflowPIComponent> clazz = WorkflowPIComponent.class;
        if (_error_icon == null) {
            _error_icon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_BUILD_GROUP_MODEL_ERROR_ICON"));
        }
        Class<WorkflowEditor> clazz2 = WorkflowEditor.class;
        _invalidAttrIcon = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("USAGE_ATTRIBUTE_INVALID"));
        _validAttrIcon = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("USAGE_ATTRIBUTE"));
    }

    @Override
    public void initUI() {
        this._models = new AttrsTableModel(this, this._outputColumns, this._context);
        ControlBar controlBar = new ControlBar();
        this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setToolTipText(DialogsLrb.get("JOIN_ADD_BTN_TOOLTIP"));
        this._addBtn.setEnabled(true);
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(DialogsLrb.get("JOIN_REMOVE_BTN_TOOLTIP"));
        this._removeBtn.setEnabled(false);
        controlBar.add((Component)this._addBtn);
        controlBar.add((Component)this._removeBtn);
        this._tableWithToolbar = new NiceTableWithToolbar(this.joinKeyComponentWithTitlebar, controlBar, AttrsTableModel._columnNames, this._models);
        this._tableWithToolbar.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("JOIN_DATA_TABLE_TITLE")));
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputColumnPanel.this.processAdd();
            }
        });
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_DATA_REMOVE_ATTRIBUTE"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                    return;
                }
                OutputColumnPanel.this.processRemove();
            }
        });
        this._tableWithToolbar.getNiceTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                OutputColumnPanel.this.handleModelSelectionChanged();
            }
        });
        TableColumn tableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new CustomCellRenderer());
        tableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(2);
        DBObjectNameEditor dBObjectNameEditor = new DBObjectNameEditor();
        tableColumn.setCellEditor(dBObjectNameEditor);
        this.enableControls();
    }

    private void enableControls() {
        boolean bl = this._outputColumns.getAutoSpec().equals((Object)AutoSpecType.YES);
        this.jAutoCheckBox.setSelected(bl);
        this.jAutoCheckBox.setEnabled(this.isWritable());
        int n = this._outputColumns.getRefDBColumn().size();
        String string = MessageFormat.format(DialogsLrb.get("JOIN_DATA_COLUMN_SPECIFIED"), Integer.toString(n));
        this.jColumnSpecifiedLabel.setIcon(n > 1000 ? _invalidAttrIcon : null);
        this.jColumnSpecifiedLabel.setText(string);
        int n2 = this._tableWithToolbar.getNiceTable().getSelectedRowCount();
        this._addBtn.setEnabled(this.isWritable() && !bl);
        this._removeBtn.setEnabled(this.isWritable() && !bl && n2 > 0);
    }

    private void processAdd() {
        AttrsPanel attrsPanel;
        AttrsDialog attrsDialog = new AttrsDialog();
        JoinNode joinNode = (JoinNode)this.getData();
        List<AbstractNode> list = null;
        list = this._propertyModel != null ? (((JoinNodeType)joinNode.getData()).isUseCartesian().booleanValue() ? JoinNode.findDataNodesUsedInJoins(joinNode, ((JoinNodeType)joinNode.getData()).getSourceNodes()) : JoinNode.findDataNodesUsedInJoins(joinNode, ((JoinNodeType)joinNode.getData()).getKeyColumns())) : (this._parent.getKeyPanel().isCartesianJoin() ? JoinNode.findDataNodesUsedInJoins(joinNode, this._parent.getKeyPanel().getKeyNodes()) : JoinNode.findDataNodesUsedInJoins(joinNode, this._parent.getKeyPanel().getKeyColumns()));
        if (attrsDialog.invoke(this.getContext(), this, list, this._outputColumns) && (attrsPanel = attrsDialog.getPanel()).isDirty()) {
            List<RefDBColumnType> list2 = attrsPanel.getSelectedAttrsCache();
            JoinNode.removeOutputAttrs(this._outputColumns, this._outputColumns.getRefDBColumn(), this._outputColumnNameGenerator);
            JoinNode.addOutputAttrs(this._outputColumns, list2, this._outputColumnNameGenerator);
            this._dirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            } else {
                this._models = new AttrsTableModel(this, this._outputColumns, this._context);
                this._tableWithToolbar.resetNiceTableModel(this._models);
            }
        }
    }

    private void processRemove() {
        int[] nArray = this._tableWithToolbar.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        ArrayList<RefDBColumnType> arrayList = new ArrayList<RefDBColumnType>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            RefDBColumnType refDBColumnType = (RefDBColumnType)this._outputColumns.getRefDBColumn().get(n);
            arrayList.add(refDBColumnType);
        }
        JoinNode.removeOutputAttrs(this._outputColumns, arrayList, this._outputColumnNameGenerator);
        this._dirty = true;
        if (this._propertyModel != null) {
            this.updateNode();
        } else {
            this._models = new AttrsTableModel(this, this._outputColumns, this._context);
            this._tableWithToolbar.resetNiceTableModel(this._models);
        }
    }

    private void processRemoveAll() {
        JoinNode.removeOutputAttrs(this._outputColumns, this._outputColumns.getRefDBColumn(), this._outputColumnNameGenerator);
        this._dirty = true;
        if (this._propertyModel != null) {
            this.updateNode();
        } else {
            this._models = new AttrsTableModel(this, this._outputColumns, this._context);
            this._tableWithToolbar.resetNiceTableModel(this._models);
        }
    }

    private void handleModelSelectionChanged() {
        this.enableControls();
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowJoinNodePropertyProxyModel workflowJoinNodePropertyProxyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        Context context = workflowJoinNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        JoinNode joinNode = (JoinNode)workflowNodeInspectorElement.getNode();
        if (joinNode == null) {
            return;
        }
        this._propertyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = joinNode;
        this._dirty = false;
        JoinNodeType joinNodeType = (JoinNodeType)joinNode.getData();
        this._outputColumns = (JoinOutputColumnsType)MetaDataHelper.copyMetadataObject(joinNodeType.getOutputColumns());
        this._outputColumnNameGenerator = new JoinNode.JoinOutputColumnNameGenerator(this._outputColumns);
        this.initUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowJoinNodePropertyProxyModel)) {
            return null;
        }
        WorkflowJoinNodePropertyProxyModel workflowJoinNodePropertyProxyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        Context context = workflowJoinNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private JoinNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowJoinNodePropertyProxyModel)) {
            return null;
        }
        WorkflowJoinNodePropertyProxyModel workflowJoinNodePropertyProxyModel = (WorkflowJoinNodePropertyProxyModel)propertyModel;
        Context context = workflowJoinNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof JoinNodeType) {
            return (JoinNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void initComponents() {
        this.jAutoCheckBox = new JCheckBox();
        this.joinKeyTransparentPanel = new TransparentPanel();
        this.joinKeyComponentWithTitlebar = new ComponentWithTitlebar();
        this.jColumnSpecifiedLabel = new JLabel();
        this.jAutoCheckBox.setText("Automatic Settings");
        this.jAutoCheckBox.setName("jAutoCheckBox");
        this.jAutoCheckBox.setOpaque(false);
        this.jAutoCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputColumnPanel.this.jAutoCheckBoxActionPerformed(actionEvent);
            }
        });
        this.joinKeyTransparentPanel.setName("joinKeyTransparentPanel");
        this.joinKeyComponentWithTitlebar.setAutoscrolls(true);
        this.joinKeyComponentWithTitlebar.setMinimumSize(new Dimension(500, 1000));
        this.joinKeyComponentWithTitlebar.setName("joinKeyComponentWithTitlebar");
        GroupLayout groupLayout = new GroupLayout((Container)this.joinKeyTransparentPanel);
        this.joinKeyTransparentPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.joinKeyComponentWithTitlebar, -1, 788, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.joinKeyComponentWithTitlebar, -2, 329, Short.MAX_VALUE));
        this.jColumnSpecifiedLabel.setHorizontalAlignment(4);
        this.jColumnSpecifiedLabel.setText("X columns specified and only 1000 allowed");
        this.jColumnSpecifiedLabel.setName("jColumnSpecifiedLabel");
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.jAutoCheckBox, -2, 203, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 310, Short.MAX_VALUE).addComponent(this.jColumnSpecifiedLabel, -2, 275, -2)).addComponent((Component)this.joinKeyTransparentPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jAutoCheckBox).addComponent(this.jColumnSpecifiedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.joinKeyTransparentPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jAutoCheckBox.getAccessibleContext().setAccessibleDescription("Automatic Settings");
    }

    private void jAutoCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jAutoCheckBox.isSelected();
        if (bl) {
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_DATA_AUTO_SETTING_ON"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                this.jAutoCheckBox.setSelected(false);
                return;
            }
            if (this._propertyModel != null) {
                this._outputColumns.setAutoSpec(AutoSpecType.YES);
                this._dirty = true;
                if (this._propertyModel != null) {
                    this.updateNode();
                }
            } else {
                this.processRemoveAll();
                this._outputColumns.setAutoSpec(AutoSpecType.YES);
                JoinNode.addOutputAttrs(this._outputColumns, (JoinNode)this.getData());
                this._models = new AttrsTableModel(this, this._outputColumns, this._context);
                this._tableWithToolbar.resetNiceTableModel(this._models);
            }
        } else {
            this._outputColumns.setAutoSpec(AutoSpecType.NO);
            this._dirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
        this.enableControls();
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public JoinOutputColumnsType getOutputColumns() {
        return this._outputColumns;
    }

    public WorkflowJoinNodePropertyProxyModel getPropertyModel() {
        return this._propertyModel;
    }

    public void setOutputColumns(JoinOutputColumnsType joinOutputColumnsType) {
        this._outputColumns = joinOutputColumnsType;
    }

    private class CustomCellEditor
    extends DefaultCellEditor {
        private String _alias;

        public CustomCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object != null) {
                this._alias = object.toString();
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        @Override
        public boolean stopCellEditing() {
            String string = (String)this.getCellEditorValue();
            if (string.length() > 30) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_DATA_ALIAS_TOO_LONG"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            if (string.length() > 0) {
                if (this._alias != null) {
                    OutputColumnPanel.this._outputColumnNameGenerator.removeUniqueName(this._alias);
                }
                if (OutputColumnPanel.this._outputColumnNameGenerator.doesNameExist(string)) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JOIN_DATA_ALIAS_DUPLICATE"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                    return false;
                }
                OutputColumnPanel.this._outputColumnNameGenerator.addUniqueName(string);
            }
            return super.stopCellEditing();
        }
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = OutputColumnPanel.this._tableWithToolbar.convertRowToModelIndex(n);
            RefDBColumnType refDBColumnType = (RefDBColumnType)OutputColumnPanel.this._outputColumns.getRefDBColumn().get(n3);
            AttributeStatus attributeStatus = refDBColumnType.getStatus();
            if (attributeStatus == AttributeStatus.VALID) {
                this.setIcon(_validAttrIcon);
            } else {
                this.setIcon(_invalidAttrIcon);
            }
            return component;
        }
    }

    private static class AttrsTableModel
    extends GenericBaseTableModel {
        public static String[] _columnNames = new String[]{DialogsLrb.get("JOIN_ATTR_NAME"), DialogsLrb.get("JOIN_ATTR_NODE"), DialogsLrb.get("JOIN_ATTR_ALIAS"), DialogsLrb.get("JOIN_DATA_TYPE")};
        public static final int ATTR_NAME = 0;
        public static final int ATTR_NODE = 1;
        public static final int ATTR_ALIAS = 2;
        public static final int DATA_TYPE = 3;
        public static final int COLUMN_COUNT = 4;
        private OutputColumnPanel _parent;
        private JoinOutputColumnsType _srcData;
        private Context _context;

        public AttrsTableModel(OutputColumnPanel outputColumnPanel, JoinOutputColumnsType joinOutputColumnsType, Context context) {
            this._parent = outputColumnPanel;
            this._srcData = joinOutputColumnsType;
            this._context = context;
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(4);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.getRefDBColumn().size() : 0;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 2 ? this._parent.isWritable() && this._parent._outputColumns.getAutoSpec() == AutoSpecType.NO : false;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            RefDBColumnType refDBColumnType = (RefDBColumnType)this._srcData.getRefDBColumn().get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = refDBColumnType.getName();
                    break;
                }
                case 1: {
                    string = ((JoinNode)this._parent.getData()).getDataNodeName(refDBColumnType.getNodeId());
                    break;
                }
                case 2: {
                    string = refDBColumnType.getAlias();
                    break;
                }
                case 3: {
                    string = refDBColumnType.getDataType();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 2) {
                return;
            }
            RefDBColumnType refDBColumnType = (RefDBColumnType)this._srcData.getRefDBColumn().get(n);
            Vector vector = new Vector();
            vector.addAll(this._srcData.getRefDBColumn());
            vector.remove(refDBColumnType);
            String string = null;
            String string2 = refDBColumnType.getAlias();
            String string3 = refDBColumnType.getName();
            if (object != null) {
                string = ((String)object).trim();
            }
            if (string2 != null && StringUtils.isDoubleQuotedString(string)) {
                string2 = StringUtils.addDoubleQuotes(string2);
            }
            if (string.length() != 0) {
                if (!StringUtils.isDoubleQuotedString(string)) {
                    string = string.toUpperCase();
                }
                if (string2 != null && string2.compareTo(string) == 0) {
                    return;
                }
                if (!AttributeNameValidator.validateAttributeName(string, vector, this._context, true)) {
                    return;
                }
            } else if (string2 != null && string2.length() != 0 && !AttributeNameValidator.validateAttributeName(string3, vector, this._context, true)) {
                return;
            }
            if (string2 != null && string2.compareTo(string) == 0) {
                return;
            }
            string = string != null && string.length() == 0 ? null : StringUtils.trimDoubleQuotes(string);
            refDBColumnType.setAlias(string);
            this._parent.setDirty(true);
            if (this._parent.getPropertyModel() != null) {
                this._parent.updateNode();
            }
        }

        public void setSrcData(JoinOutputColumnsType joinOutputColumnsType) {
            this._srcData = joinOutputColumnsType;
            this.setRowCount(this._srcData != null ? this._srcData.getRefDBColumn().size() : 0);
        }
    }
}

