/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.join;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.join.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.join.FilterPanel;
import oracle.dmt.dataminer.workflow.dialog.join.JoinColumnPanel;
import oracle.dmt.dataminer.workflow.dialog.join.OutputColumnPanel;
import oracle.dmt.dataminer.workflow.model.JoinNode;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinKeyColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinOutputColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinSourceNodesType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.javatools.dialogs.ExceptionDialog;

public class JoinEditorPanel
extends AbstractDialogPanel {
    private PropertyModel _model;
    private JoinNode _node;
    private JoinColumnPanel _keyPanel;
    private OutputColumnPanel _dataPanel;
    private FilterPanel _filterPanel;
    private boolean _isCartesianJoin;
    private JoinSourceNodesType _sourceNodes;
    private JoinKeyColumnsType _keyColumns;
    private JoinOutputColumnsType _outputColumns;
    private String _filter;
    private JoinNode.JoinOutputColumnNameGenerator _outputColumnNameGenerator;
    private JTabbedPane jTabbedPane;
    private static String JOIN_KEY_TAB = DialogsLrb.get("JOIN_KEY_TAB");
    private static String JOIN_DATA_TAB = DialogsLrb.get("JOIN_DATA_TAB");
    private static String JOIN_FILTER_TAB = DialogsLrb.get("JOIN_FILTER_TAB");

    public JoinEditorPanel(JEWTDialog jEWTDialog, Context context, JoinNode joinNode, PropertyModel propertyModel) {
        super(context, joinNode);
        assert (context != null) : "Context must not be null.";
        assert (joinNode != null) : "Join node must not be null.";
        assert (joinNode instanceof JoinNode) : "Must be an instance of join node.";
        this._context = context;
        this._model = propertyModel;
        this._node = joinNode;
        JoinNodeType joinNodeType = (JoinNodeType)joinNode.getData();
        this._isCartesianJoin = joinNodeType.isUseCartesian();
        this._sourceNodes = (JoinSourceNodesType)MetaDataHelper.copyMetadataObject(joinNodeType.getSourceNodes());
        this._keyColumns = (JoinKeyColumnsType)MetaDataHelper.copyMetadataObject(joinNodeType.getKeyColumns());
        this._outputColumns = (JoinOutputColumnsType)MetaDataHelper.copyMetadataObject(joinNodeType.getOutputColumns());
        this._filter = joinNodeType.getFilter();
        this._outputColumnNameGenerator = new JoinNode.JoinOutputColumnNameGenerator(joinNodeType.getOutputColumns());
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"join_editor");
        this._keyPanel = new JoinColumnPanel(this._context, this._node, this);
        this.jTabbedPane.add(JOIN_KEY_TAB, this._keyPanel);
        this._dataPanel = new OutputColumnPanel(this._context, this._node, this);
        this.jTabbedPane.add(JOIN_DATA_TAB, this._dataPanel);
        this._filterPanel = new FilterPanel(this._context, this._node, this);
        this.jTabbedPane.add(JOIN_FILTER_TAB, this._filterPanel);
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.jTabbedPane.setName("jTabbedPane");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 785, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 499, Short.MAX_VALUE).addContainerGap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWork() {
        boolean bl = true;
        if (this._keyPanel.isDirty() || this._dataPanel.isDirty() || this._filterPanel.isDirty()) {
            CommandProcessor.getInstance().beginTrans(DialogsLrb.get("JOIN_NODE_EDIT_TRANSACTION_NAME"));
            try {
                Object object;
                boolean bl2 = false;
                JoinNodeType joinNodeType = (JoinNodeType)this._data.getData();
                ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
                if (this._keyPanel.isDirty() && this._model == null) {
                    object = new ComplexProperty("joinKeyColumns", this._keyPanel.getKeyColumns());
                    ((ComplexProperty)object).setOldData(joinNodeType.getKeyColumns());
                    arrayList.add((ComplexProperty)object);
                    object = new ComplexProperty("joinKeyNodes", this._keyPanel.getKeyNodes());
                    ((ComplexProperty)object).setOldData(joinNodeType.getSourceNodes());
                    arrayList.add((ComplexProperty)object);
                    bl2 = true;
                }
                if (this._dataPanel.isDirty() && this._model == null) {
                    object = new ComplexProperty("joinOutputColumns", this._dataPanel.getOutputColumns());
                    ((ComplexProperty)object).setOldData(joinNodeType.getOutputColumns());
                    arrayList.add((ComplexProperty)object);
                    bl2 = true;
                }
                if (this._filterPanel.isDirty() && this._model == null && (bl2 = true)) {
                    object = new ComplexProperty("joinFilter", this._filterPanel.getFilter());
                    ((ComplexProperty)object).setOldData(joinNodeType.getFilter());
                    arrayList.add((ComplexProperty)object);
                }
                if (bl2) {
                    object = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
                    ((OdmrSDMUndoFilter)((Object)object)).prepareUndoComplexPropertyList(this._data, this.getContext(), arrayList);
                    this._node.validate(true);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("JOIN_NODE_EDIT_ERROR_MESG"), null);
                CommandProcessor.getInstance().abortTrans();
            }
            finally {
                CommandProcessor.getInstance().endTrans();
            }
        }
        return bl;
    }

    public JoinKeyColumnsType getKeyColumns() {
        return this._keyColumns;
    }

    public JoinOutputColumnsType getOutputColumns() {
        return this._outputColumns;
    }

    public void setKeyColumns(JoinKeyColumnsType joinKeyColumnsType) {
        this._keyColumns = joinKeyColumnsType;
    }

    public void setOutputColumns(JoinOutputColumnsType joinOutputColumnsType) {
        this._outputColumns = joinOutputColumnsType;
    }

    public String getFilter() {
        return this._filter;
    }

    public PropertyModel getModel() {
        return this._model;
    }

    public JoinNode.JoinOutputColumnNameGenerator getOutputColumnNameGenerator() {
        return this._outputColumnNameGenerator;
    }

    public JoinColumnPanel getKeyPanel() {
        return this._keyPanel;
    }

    public OutputColumnPanel getDataPanel() {
        return this._dataPanel;
    }

    public FilterPanel getFilterPanel() {
        return this._filterPanel;
    }

    public void setCartesianJoin(boolean bl) {
        this._isCartesianJoin = bl;
    }

    public boolean isCartesianJoin() {
        return this._isCartesianJoin;
    }

    public boolean isAutoOuputColumns() {
        return this._outputColumns.getAutoSpec() == AutoSpecType.YES;
    }

    public void setSourceNodes(JoinSourceNodesType joinSourceNodesType) {
        this._sourceNodes = joinSourceNodesType;
    }

    public JoinSourceNodesType getSourceNodes() {
        return this._sourceNodes;
    }
}

