/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.dmt.dataminer.controls.TableChooserModel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.wizard.WizardModel;
import oracle.dmt.dataminer.workflow.dialog.data.TableChooserAndViewerPane;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.ide.Context;

public class DataSourceWizardModel
extends WizardModel {
    private volatile boolean _wizardIsCancelled;
    private Context _context;
    private Component _parent;
    protected ArrayList<AttributeType> _availableColumns = new ArrayList();
    protected ArrayList<AttributeType> _selectedColumns = new ArrayList();
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private AbstractDataNode _node;
    protected TableChooserModel.TableRow _selectedTable = null;
    private TableChooserAndViewerPane _tableSelectionStep = null;
    protected boolean tableExists = true;

    public DataSourceWizardModel(Component component, Context context, AbstractDataNode abstractDataNode) {
        this._context = context;
        this._parent = component;
        this._node = abstractDataNode;
    }

    public void setWizardCancelled(boolean bl) {
        boolean bl2 = this._wizardIsCancelled;
        this._wizardIsCancelled = bl;
        this._changeSupport.firePropertyChange("wizardCancelled", bl2, bl);
    }

    public void setTableSelectionStep(TableChooserAndViewerPane tableChooserAndViewerPane) {
        this._tableSelectionStep = tableChooserAndViewerPane;
    }

    @Override
    public Context getContext() {
        return this._context;
    }

    public AbstractDataNode getNode() {
        return this._node;
    }

    public Component getParent() {
        return this._parent;
    }

    public void setSelectedTable(TableChooserModel.TableRow tableRow) {
        this._selectedTable = tableRow;
    }

    public TableChooserModel.TableRow getSelectedTable() {
        return this._selectedTable;
    }

    public List<AttributeType> getSelectedColumns() {
        return this._selectedColumns;
    }

    public void close() {
        if (this._tableSelectionStep != null) {
            try {
                this._tableSelectionStep.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setSelectedColumns(ArrayList<AttributeType> arrayList) {
        this._selectedColumns = arrayList;
    }

    public List<AttributeType> getAvailableColumns() {
        return this._availableColumns;
    }

    public void setAvailableColumns(ArrayList<AttributeType> arrayList) {
        this._availableColumns = arrayList;
    }

    public void loadDefaultSelectedColumns() {
        this._selectedColumns.clear();
        for (AttributeType attributeType : this._availableColumns) {
            if (DatabaseMetadataUtils.isDataTypeSupported(attributeType.getDataType())) {
                this._selectedColumns.add(attributeType);
                continue;
            }
            attributeType.setStatus(AttributeStatus.INVALID);
        }
        this.removeSelectedAttrs(this._availableColumns, this._selectedColumns);
    }

    protected void removeSelectedAttrs(List<AttributeType> list, List<AttributeType> list2) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : list2) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        Iterator<AttributeType> iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeType attributeType;
            attributeType = iterator.next();
            AttributeType attributeType2 = (AttributeType)hashMap.get(attributeType.getName());
            if (attributeType2 == null || !attributeType2.getName().equals(attributeType.getName()) || !attributeType2.getDataType().equals(attributeType.getDataType())) continue;
            iterator.remove();
        }
    }

    public HashMap<String, AttributeType> getSelectedColumnsHash() {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : this._selectedColumns) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        return hashMap;
    }

    public boolean isTableExists() {
        return this.tableExists;
    }

    public void setTableExists(boolean bl) {
        this.tableExists = bl;
    }
}

