/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AttributeNameCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizardModel;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizardPage;
import oracle.dmt.dataminer.workflow.inspect.AttributeTypeComparator;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.panels.TraversableContext;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;

public class DataSourceAttributesPanel
extends DataSourceWizardPage
implements DataminerGUIPanel,
DataConsumerPanel {
    protected List<AttributeType> availAttrsTotal;
    protected List<AttributeType> availAttrsCache;
    protected Map<String, AttributeType> availAttrsCacheMap;
    protected List<AttributeType> selectedAttrsCache;
    private Context _context;
    private AbstractNode _node;
    private boolean _wizardMode = false;
    private String[] _colNames = new String[]{DataDialogsLrb.get("NAME_COLUMN"), DataDialogsLrb.get("DATATYPE_COLUMN")};
    private static AttributeTypeHelper.AttributeTypeComparator _comparator = new AttributeTypeHelper.AttributeTypeComparator();
    private ComponentWithTitlebar<JComponent> jAvailAttrComponentWithTitlebar;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private ComponentWithTitlebar<JComponent> jSelAttrComponentWithTitlebar;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private static Icon _invalidAttrIcon;
    private static Icon _select;
    private static Icon _selectAll;
    private static Icon _remove;
    private static Icon _removeAll;
    private GenericTable jSelectedAttrs = new GenericTable();
    private GenericTable jAvailAttrs = new GenericTable();
    private SearchField _searchField;
    private JComponent _findPane;
    public static final int FILTER_ATTRIBUTE_NAME = 0;
    public static final int FILTER_ATTRIBUTE_TYPE = 1;
    private int _currentSearchCategory = 0;
    private SearchCategory _defaultSearchCategory = new SearchCategory(DataDialogsLrb.get("NAME_COLUMN"));

    public DataSourceAttributesPanel(Context context, AbstractNode abstractNode, List<AttributeType> list, boolean bl) {
        assert (list != null) : "Available attribute collection must not be null";
        this.availAttrsCache = new ArrayList<AttributeType>();
        this.availAttrsCacheMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
            this.availAttrsCache.add(attributeType2);
            this.availAttrsCacheMap.put(attributeType2.getName(), attributeType2);
        }
        this.availAttrsTotal = new ArrayList<AttributeType>();
        this.availAttrsTotal.addAll(list);
        this.selectedAttrsCache = new ArrayList<AttributeType>();
        this._context = context;
        this._node = abstractNode;
        this.initComponents();
        this.initRes();
        if (!bl) {
            this.initUI();
        }
    }

    public DataSourceAttributesPanel(Context context, AbstractNode abstractNode, List<AttributeType> list) {
        assert (list != null) : "Available attribute collection must not be null";
        this.availAttrsCache = new ArrayList<AttributeType>();
        this.availAttrsCacheMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
            this.availAttrsCache.add(attributeType2);
            this.availAttrsCacheMap.put(attributeType2.getName(), attributeType2);
        }
        this.availAttrsTotal = new ArrayList<AttributeType>();
        this.availAttrsTotal.addAll(list);
        this.selectedAttrsCache = new ArrayList<AttributeType>();
        this._context = context;
        this._node = abstractNode;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public DataSourceAttributesPanel() {
        this.availAttrsCache = new ArrayList<AttributeType>();
        this.availAttrsCacheMap = new HashMap<String, AttributeType>();
        this.availAttrsTotal = new ArrayList<AttributeType>();
        this.selectedAttrsCache = new ArrayList<AttributeType>();
        this._context = null;
        this._node = null;
        this._wizardMode = true;
        this.initComponents();
        this.initRes();
    }

    private void initComponents() {
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.jAvailAttrComponentWithTitlebar = new ComponentWithTitlebar();
        this.jSelAttrComponentWithTitlebar = new ComponentWithTitlebar();
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jAvailAttrComponentWithTitlebar, -1, 281, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -1, 49, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jSelAttrComponentWithTitlebar, -1, 281, Short.MAX_VALUE).addGap(10, 10, 10)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jSelAttrComponentWithTitlebar, -1, 224, Short.MAX_VALUE).addComponent((Component)this.jAvailAttrComponentWithTitlebar, -1, 224, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(55, 55, 55).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn))).addContainerGap()));
    }

    @Override
    public void initRes() {
        this.initIcons();
    }

    private void initIcons() {
        if (_invalidAttrIcon == null) {
            Class<WorkflowEditor> clazz = WorkflowEditor.class;
            _invalidAttrIcon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("USAGE_ATTRIBUTE_INVALID"));
            _select = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_RIGHT"));
            _selectAll = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_RIGHTALL"));
            _remove = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_LEFT"));
            _removeAll = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_LEFTALL"));
        }
        this.jSelectBtn.setIcon(_select);
        this.jSelectAllBtn.setIcon(_selectAll);
        this.jRemoveBtn.setIcon(_remove);
        this.jRemoveAllBtn.setIcon(_removeAll);
    }

    protected List<AttributeType> getSelectedAttributes() {
        AbstractDataNode abstractDataNode = (AbstractDataNode)this.getData();
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)abstractDataNode.getData();
        List list = dataSourceNodeType.getAttributes().getAttribute();
        return list;
    }

    public void initUINonWizard() {
        List<AttributeType> list = this.getSelectedAttributes();
        Collections.sort(list, new AttributeTypeComparator());
        boolean bl = this.availAttrsCache.isEmpty();
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
            if (bl) {
                attributeType2.setStatus(AttributeStatus.MISSING);
            }
            if (null == this.availAttrsCacheMap.get(attributeType2.getName())) {
                attributeType2.setStatus(AttributeStatus.MISSING);
            } else if (attributeType2.getStatus().equals((Object)AttributeStatus.MISSING)) {
                attributeType2.setStatus(AttributeStatus.VALID);
            }
            this.selectedAttrsCache.add(attributeType2);
        }
        this.addInvalidAttributes();
        this.removeSelectedAttrs(this.availAttrsCache, this.selectedAttrsCache);
    }

    public void initUIWizard() {
        DataSourceWizardModel dataSourceWizardModel = this.getModel(this.getTraversableContext());
        this.availAttrsCache = dataSourceWizardModel.getAvailableColumns();
        for (AttributeType attributeType : this.availAttrsTotal) {
            this.availAttrsCacheMap.put(attributeType.getName(), attributeType);
        }
        this.availAttrsTotal.clear();
        this.availAttrsTotal.addAll(this.availAttrsCache);
        this.selectedAttrsCache = dataSourceWizardModel.getSelectedColumns();
        this.addInvalidAttributes();
    }

    private void addInvalidAttributes() {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>(this.availAttrsTotal.size());
        for (AttributeType attributeType : this.availAttrsTotal) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        for (AttributeType attributeType : this.selectedAttrsCache) {
            if (null != hashMap.get(attributeType.getName())) continue;
            this.availAttrsTotal.add(attributeType);
            hashMap.put(attributeType.getName(), attributeType);
        }
    }

    protected void enableButtons(boolean bl) {
        this.jSelectBtn.setEnabled(bl);
        this.jSelectAllBtn.setEnabled(bl);
        this.jRemoveBtn.setEnabled(bl);
        this.jRemoveAllBtn.setEnabled(bl);
    }

    @Override
    public void initUI() {
        if (this._wizardMode) {
            this.initUIWizard();
        } else {
            this.initUINonWizard();
        }
        if (!this.isUiInitialized()) {
            this.jSelectBtn.setText("");
            this.jSelectAllBtn.setText("");
            this.jRemoveBtn.setText("");
            this.jRemoveAllBtn.setText("");
            JScrollPane jScrollPane = new JScrollPane((Component)this.jAvailAttrs);
            this.jAvailAttrs.setFillsViewportHeight(true);
            this.jAvailAttrComponentWithTitlebar.setComponent((JComponent)jScrollPane);
            this.jAvailAttrComponentWithTitlebar.setLabel(new JLabel(DataDialogsLrb.get("AVAILABLE_LABEL")));
            ControlBar controlBar = new ControlBar();
            this.installItemFilterActions(controlBar);
            this.jAvailAttrComponentWithTitlebar.setControlBar(controlBar);
            JScrollPane jScrollPane2 = new JScrollPane((Component)this.jSelectedAttrs);
            this.jSelectedAttrs.setFillsViewportHeight(true);
            this.jSelAttrComponentWithTitlebar.setComponent((JComponent)jScrollPane2);
            this.jSelAttrComponentWithTitlebar.setLabel(new JLabel(DataDialogsLrb.get("SELECTED_LABEL")));
            ControlBar controlBar2 = new ControlBar();
            this.jSelAttrComponentWithTitlebar.setControlBar(controlBar2);
            this.jSelectBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourceAttributesPanel.this.moveItems(DataSourceAttributesPanel.this.jAvailAttrs, DataSourceAttributesPanel.this.jSelectedAttrs, false);
                }
            });
            this.jSelectAllBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourceAttributesPanel.this.moveItems(DataSourceAttributesPanel.this.jAvailAttrs, DataSourceAttributesPanel.this.jSelectedAttrs, true);
                }
            });
            this.jRemoveBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourceAttributesPanel.this.moveItems(DataSourceAttributesPanel.this.jSelectedAttrs, DataSourceAttributesPanel.this.jAvailAttrs, false);
                    String string = DataSourceAttributesPanel.this._searchField.getText();
                    DataSourceAttributesPanel.this.translateSearchCategoryToConstant(DataSourceAttributesPanel.this._searchField.getSelectedCategory());
                    DataSourceAttributesPanel.this.processFilter(string);
                }
            });
            this.jRemoveAllBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourceAttributesPanel.this.moveItems(DataSourceAttributesPanel.this.jSelectedAttrs, DataSourceAttributesPanel.this.jAvailAttrs, true);
                    String string = DataSourceAttributesPanel.this._searchField.getText();
                    DataSourceAttributesPanel.this.translateSearchCategoryToConstant(DataSourceAttributesPanel.this._searchField.getSelectedCategory());
                    DataSourceAttributesPanel.this.processFilter(string);
                }
            });
            this.initializeTables();
            this.jSelectBtn.setEnabled(false);
            this.jRemoveBtn.setEnabled(false);
            this.jAvailAttrs.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    DataSourceAttributesPanel.this.jSelectBtn.setEnabled(!listSelectionModel.isSelectionEmpty() && !DataSourceAttributesPanel.this.isAutoSpec());
                }
            });
            this.jSelectedAttrs.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    DataSourceAttributesPanel.this.jRemoveBtn.setEnabled(!listSelectionModel.isSelectionEmpty() && !DataSourceAttributesPanel.this.isAutoSpec());
                }
            });
        } else {
            this.initializeTables();
        }
    }

    protected boolean isAutoSpec() {
        return false;
    }

    private void installItemFilterActions(ControlBar controlBar) {
        this._findPane = new Box(2);
        this._searchField = this.searchField();
        this.setupFilterCtl();
        this._findPane.setName("Find");
        this._findPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this._findPane.add((Component)this._searchField);
        Dimension dimension = this._findPane.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 105);
        Dimension dimension3 = this.derive(dimension, 60);
        this._findPane.setPreferredSize(dimension2);
        this._findPane.setMaximumSize(dimension2);
        this._findPane.setMinimumSize(dimension3);
        controlBar.add((Component)this._findPane);
    }

    private SearchField searchField() {
        final SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                DataSourceAttributesPanel.this.translateSearchCategoryToConstant(searchField.getSelectedCategory());
                DataSourceAttributesPanel.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                DataSourceAttributesPanel.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                DataSourceAttributesPanel.this.processFilter(string);
            }
        });
        return searchField;
    }

    private void processFilter(String string) {
        try {
            List<AttributeType> list = this.getCurrentlyAvailable();
            if (list != null && !list.isEmpty()) {
                AttrTableModel attrTableModel = this.getFilteredAttributesTableModel(list, string, this._currentSearchCategory);
                this.setupAvialableTable(attrTableModel);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataDialogsLrb.get("DATA_SOURCE_QUERY_FAILURE_TITLE"), (String)DataDialogsLrb.get("DATA_SOURCE_QUERY_FAILURE_MSG"), null);
        }
    }

    public AttrTableModel getFilteredAttributesTableModel(List<AttributeType> list, String string, int n) throws Exception {
        Vector<AttributeType> vector = new Vector<AttributeType>();
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        Iterator<AttributeType> iterator = list.iterator();
        AttributeType attributeType = null;
        boolean bl = string.length() <= 0;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            attributeType = iterator.next();
            if (bl) {
                bl2 = true;
            } else {
                String string2 = "";
                switch (n) {
                    case 0: {
                        string2 = attributeType.getName();
                        break;
                    }
                    case 1: {
                        string2 = attributeType.getDataType();
                        break;
                    }
                    default: {
                        assert (false) : "Invalid item filter category.";
                        string2 = null;
                    }
                }
                bl2 = string2 == null ? false : searchMatcher.matches((CharSequence)string2);
            }
            if (!bl2) continue;
            vector.add(attributeType);
        }
        return new AttrTableModel(vector);
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private void setupFilterCtl() {
        this._currentSearchCategory = 0;
        this._searchField.addCategory(this._defaultSearchCategory);
        this._searchField.addCategory(new SearchCategory(DataDialogsLrb.get("DATATYPE_COLUMN")));
        this._searchField.setSelectedCategory(this._defaultSearchCategory);
    }

    private synchronized void translateSearchCategoryToConstant(SearchCategory searchCategory) {
        if (searchCategory.getLabel().equals(DataDialogsLrb.get("NAME_COLUMN"))) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(DataDialogsLrb.get("DATATYPE_COLUMN"))) {
            this._currentSearchCategory = 1;
        } else assert (false) : "Invalid Search Category Code";
    }

    private void removeInvalidDataTypes(List<AttributeType> list) {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        for (AttributeType attributeType : list) {
            if (DatabaseMetadataUtils.isDataTypeSupported(attributeType.getDataType())) continue;
            arrayList.add(attributeType);
        }
        list.removeAll(arrayList);
    }

    private void initializeTables() {
        this.removeInvalidDataTypes(this.availAttrsCache);
        AttrTableModel attrTableModel = new AttrTableModel(this.availAttrsCache);
        this.setupAvialableTable(attrTableModel);
        AttrTableModel attrTableModel2 = new AttrTableModel(this.selectedAttrsCache);
        this.setupSelectedTable(attrTableModel2);
    }

    private void setupSelectedTable(AttrTableModel attrTableModel) {
        this.jSelectedAttrs.setModel((TableModel)((Object)attrTableModel));
        this.jSelectedAttrs.setSorted(true);
        TableColumn tableColumn = this.jSelectedAttrs.getColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(null, _invalidAttrIcon);
        tableColumn.setCellRenderer(attributeNameCellRenderer);
    }

    private void setupAvialableTable(AttrTableModel attrTableModel) {
        this.jAvailAttrs.setModel((TableModel)((Object)attrTableModel));
        this.jAvailAttrs.setSorted(true);
        TableColumn tableColumn = this.jAvailAttrs.getColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(null, _invalidAttrIcon);
        tableColumn.setCellRenderer(attributeNameCellRenderer);
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        int n;
        Object object2;
        int n2;
        int[] nArray = genericTable.getSelectedRowsInModel();
        List<AttributeType> list = ((AttrTableModel)((Object)genericTable.getModel())).getDataList();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        if (!bl) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                object2 = list.get(nArray[n2]);
                arrayList.add((AttributeType)object2);
            }
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                arrayList.add(list.get(n2));
            }
        }
        for (Object object2 : arrayList) {
            n = list.indexOf(object2);
            if (n == -1) continue;
            list.remove(n);
        }
        List<AttributeType> list2 = ((AttrTableModel)((Object)genericTable2.getModel())).getDataList();
        list2.addAll(arrayList);
        ((AttrTableModel)((Object)genericTable2.getModel())).setRowCount(list2.size());
        ((AttrTableModel)((Object)genericTable.getModel())).setRowCount(list.size());
        ((AbstractTableModel)genericTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)genericTable2.getModel()).fireTableDataChanged();
        object2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            int n3 = list2.indexOf(arrayList.get(n));
            assert (n3 != -1) : "Unexpected state - added item should be present and must have an index";
            object2[n] = (AttributeType)n3;
        }
        genericTable2.setSelectedRowsInModel((int[])object2);
    }

    private List<AttributeType> getCurrentlyAvailable() {
        AttrTableModel attrTableModel = (AttrTableModel)((Object)this.jSelectedAttrs.getModel());
        List<AttributeType> list = attrTableModel.getDataList();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        arrayList.addAll(this.availAttrsTotal);
        this.removeSelectedAttrs(arrayList, list);
        return arrayList;
    }

    private void removeSelectedAttrs(List<AttributeType> list, List<AttributeType> list2) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : list2) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        Iterator<AttributeType> iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeType attributeType;
            attributeType = iterator.next();
            AttributeType attributeType2 = (AttributeType)hashMap.get(attributeType.getName());
            if (attributeType2 == null || !attributeType2.getName().equals(attributeType.getName()) || !attributeType2.getDataType().equals(attributeType.getDataType())) continue;
            iterator.remove();
        }
    }

    @Override
    public String getPageDirtyKey() {
        return "columnsDirty";
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        boolean bl = true;
        if (traversableContext.getDirection() == 2) {
            this.selectedAttrsCache.clear();
            this.availAttrsCache.clear();
            this.availAttrsCacheMap.clear();
            return true;
        }
        if (this.selectedAttrsCache.size() == 0) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("COLUMN_CHOOSER_ERROR_MSG_NO_COLUMNS"), (String)DataDialogsLrb.get("COLUMN_CHOOSER_FAILURE_TITLE"), null);
            bl = false;
            return bl;
        }
        for (AttributeType attributeType : this.selectedAttrsCache) {
            if (!attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("COLUMN_CHOOSER_ERROR_MSG_INVALID_COLUMNS"), (String)DataDialogsLrb.get("COLUMN_CHOOSER_FAILURE_TITLE"), null);
            bl = false;
            return bl;
        }
        return bl;
    }

    public AbstractNode getData() {
        return this._node;
    }

    public Context getContext() {
        return this._context;
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        DataSourceNode dataSourceNode = (DataSourceNode)this.getData();
        Attributes attributes = new Attributes();
        List list = attributes.getAttribute();
        list.addAll(this.selectedAttrsCache);
        try {
            CommandProcessor.getInstance().beginTrans(NodeMessagesLrb.get("DATASRC_INPUT"));
            ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
            ComplexProperty complexProperty = new ComplexProperty("dataSourceAttributes", attributes);
            complexProperty.setOldData(dataSourceNode.getAttributes());
            arrayList.add(complexProperty);
            ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
            complexProperty2.setOldData(dataSourceNode.getSQLExpression());
            arrayList.add(complexProperty2);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
            odmrSDMUndoFilter.prepareUndoComplexPropertyList(dataSourceNode, this.getContext(), arrayList);
            dataSourceNode.validate(true);
            CommandProcessor.getInstance().endTrans();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            CommandProcessor.getInstance().abortTrans();
            bl = false;
        }
        return bl;
    }

    class AttrTableModel
    extends GenericBaseTableModel {
        private List<AttributeType> _data;
        private final int NAME = 0;
        private final int DATA_TYPE = 1;
        private final int COLUMN_COUNT = 2;

        public AttrTableModel(List<AttributeType> list) {
            this._data = list;
            this.setColumnIdentifiers(DataSourceAttributesPanel.this._colNames);
            this.setRowCount(this._data.size());
            this.setColumnCount(2);
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            AttributeType attributeType = this._data.get(n);
            if (0 == n2) {
                object = attributeType;
            } else if (1 == n2) {
                assert (n2 > 0 && n2 < this.getColumnCount()) : "Column out of bounds";
                object = attributeType.getDataType();
            }
            return object;
        }

        public List<AttributeType> getDataList() {
            return this._data;
        }

        public Comparator getColumnSortComparator(int n) {
            if (0 == n) {
                return _comparator;
            }
            return super.getColumnSortComparator(n);
        }
    }
}

