/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.columnFilterDetails;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.controls.OutputAttributeType;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.DataExtractBase;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelDetailsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.FilterDetailType;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;

public class ColumnDetailsExtract
extends DataExtractBase {
    static final String VARCHAR2 = "VARCHAR2";
    static final String NUMBER = "NUMBER";
    static final String ATTRIBUTE_NAME = "ATTRIBUTE_NAME";
    static final String IMPORTANCE_VALUE = "IMPORTANCE_VALUE";
    static final String TABLE_NAME = "TABLE_NAME";
    static final String ATTRIBUTE_LIST = "ATTRIBUTE_LIST";
    static final String RANK = "RANK";
    private static final String[][] ATTRIBUTE_IMPORTANCE_COLUMNS = new String[][]{{"ATTRIBUTE_NAME", "VARCHAR2"}, {"RANK", "NUMBER"}, {"IMPORTANCE_VALUE", "NUMBER"}};
    private static final String ATTRIBUTE_IMPORTANCE_QUERY = "SELECT attribute_name as \"<ATTRIBUTE_NAME>\",\n  rank as \"<RANK>\",\n  importance_value as \"<IMPORTANCE_VALUE>\"\nfrom (<TABLE_NAME>)";

    public static List<OutputAttributeType> getOutputColumnList(FilterDetailType filterDetailType) {
        String[][] stringArray = null;
        ArrayList<OutputAttributeType> arrayList = new ArrayList<OutputAttributeType>();
        if (filterDetailType != null && filterDetailType.equals((Object)FilterDetailType.ATTRIBUTE_IMPORTANCE)) {
            stringArray = ATTRIBUTE_IMPORTANCE_COLUMNS;
        }
        if (stringArray != null) {
            arrayList = ColumnDetailsExtract.generateCollection(stringArray, arrayList);
        }
        return arrayList;
    }

    public static String generateSQL(FilterDetailType filterDetailType, List<AttributeType> list, String string) {
        String string2 = "";
        try {
            List<OutputAttributeType> list2 = ColumnDetailsExtract.getOutputColumnList(filterDetailType);
            if (!ColumnDetailsExtract.validateOutputColumns(list2, list)) {
                throw new Exception("Output columns specified for filter details extract do not match the query specifications.");
            }
            string2 = ColumnDetailsExtract.getSQLTemplate(filterDetailType);
            string2 = ColumnDetailsExtract.addColumnAlias(string2, list, list2);
            string2 = StringUtils.getReplacedString(string2, "<TABLE_NAME>", string);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("ERROR_TITLE"), (String)ModelDetailsLrb.get("ERROR_MODEL_UPDATE_UNEXPECTED"), null);
        }
        return string2;
    }

    private static String getSQLTemplate(FilterDetailType filterDetailType) {
        String string = "";
        if (filterDetailType.equals((Object)FilterDetailType.ATTRIBUTE_IMPORTANCE)) {
            string = ATTRIBUTE_IMPORTANCE_QUERY;
        }
        return string;
    }
}

