/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingThemePanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingTokenPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.applyText.WorkflowApplyTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.buildText.BuildTextNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.buildText.BuildTextPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.buildText.WorkflowBuildTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.text.WorkflowTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.MessageDialog;

public class TextTransColumnSettingPanel
extends AbstractDialogPanel {
    private TextNodeType _textNodeType;
    private TransformationSourceAttributes _sourceAttributes;
    private List<TransformationSourceAttribute> _selectedAttributes;
    private TransformedAttributesType _transformedAttributes;
    private String _sourceAttributeName = null;
    private TextNodeType.Stoplists _existStoplists = null;
    private PropertyModel _propertyModel;
    private TextTransColumnSettingTokenPanel _tokenPanel;
    private TextTransColumnSettingThemePanel _themePanel;
    private boolean _isReadOnly;
    private boolean _isEdit;
    private boolean _dirty;
    private boolean _isAdjusting;
    private static String TRANSFORM_TOKEN = DialogsLrb.get("BUILDTEXT_TRANSFORM_TYPE_TOKEN");
    private static String TRANSFORM_THEME = DialogsLrb.get("BUILDTEXT_TRANSFORM_TYPE_THEME");
    private static String TRANSFORM_OUTPUT_TOKEN = "TOK";
    private static String TRANSFORM_OUTPUT_THEME = "THM";
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup4;
    private JCheckBox jAutoOutputColumnNameCheckBox;
    private JLabel jOutputColumnLabel;
    private JTextField jOutputColumnTextField;
    private JSeparator jSeparator;
    private JPanel jSettingPanel;
    private JComboBox jSourceColumnComboBox;
    private JLabel jSourceColumnLabel;
    private JComboBox jTransformTypeComboBox;
    private JLabel jTransformTypeLabel;

    public TextTransColumnSettingPanel(PropertyModel propertyModel, TransformationSourceAttributes transformationSourceAttributes, TransformedAttributesType transformedAttributesType, List<TransformationSourceAttribute> list) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for BuildTextNode node is null.";
        this._isReadOnly = !(propertyModel instanceof WorkflowBuildTextNodePropertyProxyModel);
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this._sourceAttributes = transformationSourceAttributes;
        this._selectedAttributes = list;
        AbstractTextNode abstractTextNode = (AbstractTextNode)this.getData();
        TextNodeType textNodeType = (TextNodeType)abstractTextNode.getData();
        this.init(transformedAttributesType, textNodeType, propertyModel);
    }

    public TextTransColumnSettingPanel(Context context, AbstractTextNode abstractTextNode, TransformationSourceAttributes transformationSourceAttributes, TransformedAttributesType transformedAttributesType, List<TransformationSourceAttribute> list) {
        super(context, abstractTextNode);
        assert (context != null) : "Context must not be null.";
        assert (abstractTextNode != null) : "BuildTextNode node must not be null.";
        assert (abstractTextNode instanceof AbstractTextNode) : "Must be an instance of BuildTextNode node.";
        this._isReadOnly = !(abstractTextNode instanceof BuildTextNode);
        this._sourceAttributes = transformationSourceAttributes;
        this._selectedAttributes = list;
        AbstractTextNode abstractTextNode2 = (AbstractTextNode)this.getData();
        TextNodeType textNodeType = (TextNodeType)abstractTextNode2.getData();
        this.init(transformedAttributesType, textNodeType, null);
    }

    public TextTransColumnSettingPanel(Context context, AbstractTextNode abstractTextNode, TextNodeType textNodeType, TransformationSourceAttributes transformationSourceAttributes, TransformedAttributesType transformedAttributesType, List<TransformationSourceAttribute> list) {
        super(context, abstractTextNode);
        assert (context != null) : "Context must not be null.";
        assert (abstractTextNode != null) : "BuildTextNode node must not be null.";
        assert (abstractTextNode instanceof AbstractTextNode) : "Must be an instance of BuildTextNode node.";
        this._isReadOnly = !(abstractTextNode instanceof BuildTextNode);
        this._sourceAttributes = transformationSourceAttributes;
        this._selectedAttributes = list;
        this.init(transformedAttributesType, textNodeType, null);
    }

    private void init(TransformedAttributesType transformedAttributesType, TextNodeType textNodeType, PropertyModel propertyModel) {
        this._propertyModel = propertyModel;
        this._textNodeType = textNodeType;
        this._dirty = false;
        this._transformedAttributes = (TransformedAttributesType)MetaDataHelper.copyMetadataObject(transformedAttributesType);
        this._existStoplists = new TextNodeType.Stoplists();
        for (StoplistType stoplistType : textNodeType.getStoplists().getStoplist()) {
            this._existStoplists.getStoplist().add((StoplistType)MetaDataHelper.copyMetadataObject(stoplistType));
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("BUILDTEXT_SOURCE_COLUMN"), this.jSourceColumnLabel);
        hashMap.put(DialogsLrb.get("TRANSFORM_WIZ_TRANSFORM_TYPE"), this.jTransformTypeLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_OUTPUT_COLUMN"), this.jOutputColumnLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_AUTO"), this.jAutoOutputColumnNameCheckBox);
        UIResourceHelper.setComponentText(hashMap);
    }

    @Override
    public void initUI() {
        String string;
        TransformationSourceAttribute transformationSourceAttribute2;
        HelpUtils.setHelpID((JComponent)this, (String)"add_text_transform");
        this._isAdjusting = true;
        TransformationSourceAttributes transformationSourceAttributes = this._sourceAttributes;
        List list = transformationSourceAttributes.getTransformationSourceAttributeType();
        this.jSourceColumnComboBox.removeAllItems();
        for (TransformationSourceAttribute transformationSourceAttribute2 : list) {
            string = transformationSourceAttribute2.getDataType();
            if (!DatabaseMetadataUtils.isACharacterOracleDataType(string)) continue;
            this.jSourceColumnComboBox.addItem(transformationSourceAttribute2.getName());
        }
        this.jTransformTypeComboBox.removeAllItems();
        this.jTransformTypeComboBox.addItem(TRANSFORM_TOKEN);
        this.jTransformTypeComboBox.addItem(TRANSFORM_THEME);
        List<TransformationSourceAttribute> list2 = this._selectedAttributes;
        transformationSourceAttribute2 = (TransformationSourceAttribute)list2.get(0);
        string = null;
        boolean bl = true;
        String string2 = null;
        if (transformationSourceAttribute2 instanceof TextTransformationOutputAttributeType) {
            string = (TextTransformationOutputAttributeType)transformationSourceAttribute2;
            this._sourceAttributeName = string.getSource();
            bl = string.getTransformationElement().getTheme() == null;
            string2 = string.getName();
            this._isEdit = true;
        } else {
            this._sourceAttributeName = transformationSourceAttribute2.getName();
            string2 = this.generateOutputName(this._sourceAttributeName);
            this._isEdit = false;
        }
        this.jSourceColumnComboBox.setSelectedItem(this._sourceAttributeName);
        if (bl) {
            this.jTransformTypeComboBox.setSelectedItem(TRANSFORM_TOKEN);
        } else {
            this.jTransformTypeComboBox.setSelectedItem(TRANSFORM_THEME);
        }
        this.jOutputColumnTextField.setText(string2);
        this.jAutoOutputColumnNameCheckBox.setSelected(true);
        this._tokenPanel = new TextTransColumnSettingTokenPanel(this._propertyModel, this._context, this, (AbstractTextNode)this._data, this._sourceAttributeName, string != null ? string.getTransformationElement() : null);
        this._themePanel = new TextTransColumnSettingThemePanel(this._propertyModel, this._context, this, (AbstractTextNode)this._data, this._sourceAttributeName, string != null ? string.getTransformationElement() : null);
        this.jSettingPanel.removeAll();
        if (bl) {
            this.jSettingPanel.add(this._tokenPanel);
        } else {
            this.jSettingPanel.add(this._themePanel);
        }
        this._isAdjusting = false;
        this.enableControls();
    }

    private void enableControls() {
        for (Component component : this.getComponents()) {
            component.setEnabled(!this._isReadOnly);
        }
        if (!this._isReadOnly) {
            this.jSourceColumnComboBox.setEnabled(!this._isEdit);
            this.jOutputColumnTextField.setEnabled(!this.jAutoOutputColumnNameCheckBox.isSelected());
        }
    }

    private boolean isPIMode() {
        return this._propertyModel != null;
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        Context context = null;
        if (propertyModel instanceof WorkflowTextNodePropertyProxyModel) {
            WorkflowTextNodePropertyProxyModel workflowTextNodePropertyProxyModel = (WorkflowTextNodePropertyProxyModel)propertyModel;
            context = workflowTextNodePropertyProxyModel.getSelectionContext();
        } else if (propertyModel instanceof WorkflowBuildTextNodePropertyProxyModel) {
            WorkflowBuildTextNodePropertyProxyModel workflowBuildTextNodePropertyProxyModel = (WorkflowBuildTextNodePropertyProxyModel)propertyModel;
            context = workflowBuildTextNodePropertyProxyModel.getSelectionContext();
        } else if (propertyModel instanceof WorkflowApplyTextNodePropertyProxyModel) {
            WorkflowApplyTextNodePropertyProxyModel workflowApplyTextNodePropertyProxyModel = (WorkflowApplyTextNodePropertyProxyModel)propertyModel;
            context = workflowApplyTextNodePropertyProxyModel.getSelectionContext();
        }
        return context;
    }

    private AbstractTextNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        Context context = this.getContext(propertyModel);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        return (AbstractTextNode)workflowNodeInspectorElement.getNode();
    }

    private void updateNode() {
        BuildTextNode buildTextNode = (BuildTextNode)this.getData();
        BuildTextNodeType buildTextNodeType = (BuildTextNodeType)buildTextNode.getData();
        if (this.isPIMode()) {
            Object object;
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ComplexProperty complexProperty = new ComplexProperty("editColumns", this._transformedAttributes);
            complexProperty.setOldData(buildTextNodeType.getTransformedAttributes());
            arrayList.add(new Property(String.valueOf(BuildTextNodePropertyModel.RowIndex.EDIT_COLUMNS), null, complexProperty, null, null));
            if (this._existStoplists.getStoplist().size() > 0) {
                object = new ComplexProperty("editStoplists", this._existStoplists);
                ((ComplexProperty)object).setOldData(buildTextNodeType.getStoplists());
                arrayList.add(new Property(String.valueOf(BuildTextNodePropertyModel.RowIndex.EDIT_STOPLISTS), null, object, null, null));
            }
            if (!this._isEdit) {
                Object object2;
                object = new HashMap();
                HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                TransformedAttributesType transformedAttributesType = this._transformedAttributes;
                if (transformedAttributesType != null && (object2 = transformedAttributesType.getMapTextTransformedSource()) != null && !object2.isEmpty()) {
                    Iterator iterator = object2.iterator();
                    block0: while (iterator.hasNext()) {
                        MapTextTransformedSourceType mapTextTransformedSourceType = (MapTextTransformedSourceType)iterator.next();
                        String string = mapTextTransformedSourceType.getKey().getSource();
                        for (TransformationSourceAttribute transformationSourceAttribute : buildTextNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType()) {
                            if (string.compareTo(transformationSourceAttribute.getName()) != 0) continue;
                            object.put(transformationSourceAttribute.getName(), transformationSourceAttribute.isIsOutput());
                            hashMap.put(transformationSourceAttribute.getName(), false);
                            continue block0;
                        }
                    }
                }
                object2 = new ComplexProperty("outputState", hashMap);
                ((ComplexProperty)object2).setOldData(object);
                arrayList.add(new Property(String.valueOf(BuildTextNodePropertyModel.RowIndex.OUTPUT_STATE), null, object2, null, null));
            }
            ((WorkflowBuildTextNodePropertyProxyModel)this._propertyModel).setValueAt(BuildTextPIPropertyLrb.get("PI_BUILDTEXT_NODE_EDIT_TRANSFORMATION_ELEMENT"), buildTextNode, arrayList);
        } else {
            Object object;
            MapTextTransformedSourceType mapTextTransformedSourceType;
            Iterator iterator;
            Object object32;
            this._textNodeType.setStoplists(this._existStoplists);
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (Object object32 : this._existStoplists.getStoplist()) {
                hashMap.put(object32.getId(), Boolean.TRUE);
            }
            TransformedAttributesType transformedAttributesType = this._textNodeType.getTransformedAttributes();
            if (transformedAttributesType != null && (object32 = transformedAttributesType.getMapTextTransformedSource()) != null && !object32.isEmpty()) {
                iterator = object32.iterator();
                while (iterator.hasNext()) {
                    Object object4;
                    mapTextTransformedSourceType = (MapTextTransformedSourceType)iterator.next();
                    object = mapTextTransformedSourceType.getKey().getTransformationElement().getToken();
                    if (object == null) {
                        object = mapTextTransformedSourceType.getKey().getTransformationElement().getTheme();
                    }
                    if ((object4 = object.getToken().getStoplistId()) == null || hashMap.containsKey(object4)) continue;
                    object.getToken().setStoplistId(null);
                }
            }
            this._textNodeType.setTransformedAttributes(this._transformedAttributes);
            if (this._transformedAttributes != null && (object32 = this._transformedAttributes.getMapTextTransformedSource()) != null && !object32.isEmpty()) {
                iterator = object32.iterator();
                while (iterator.hasNext()) {
                    mapTextTransformedSourceType = (MapTextTransformedSourceType)iterator.next();
                    object = mapTextTransformedSourceType.getKey().getSource();
                    for (TransformationSourceAttribute transformationSourceAttribute : this._sourceAttributes.getTransformationSourceAttributeType()) {
                        if (((String)object).compareTo(transformationSourceAttribute.getName()) != 0) continue;
                        transformationSourceAttribute.setIsOutput(false);
                    }
                }
            }
        }
    }

    private String generateOutputName(String string) {
        String string2 = (String)this.jTransformTypeComboBox.getSelectedItem();
        String string3 = string2.equals(TRANSFORM_TOKEN) ? TRANSFORM_OUTPUT_TOKEN : TRANSFORM_OUTPUT_THEME;
        String string4 = AttributeTypeHelper.createUniqueTextTransformationOutputName(string, string3, this._sourceAttributes.getTransformationSourceAttributeType(), this._transformedAttributes.getMapTextTransformedSource());
        return string4;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public TextTransformationOutputAttributeType getSelectedOutputAttribute() {
        TextTransformationOutputAttributeType textTransformationOutputAttributeType = null;
        if (this._isEdit) {
            List<TransformationSourceAttribute> list = this._selectedAttributes;
            textTransformationOutputAttributeType = (TextTransformationOutputAttributeType)list.get(0);
        }
        return textTransformationOutputAttributeType;
    }

    private boolean doesNameExist(String string) {
        Object object;
        boolean bl = false;
        TextTransformationOutputAttributeType textTransformationOutputAttributeType = this.getSelectedOutputAttribute();
        List list = this._transformedAttributes.getMapTextTransformedSource();
        for (MapTextTransformedSourceType mapTextTransformedSourceType : list) {
            object = mapTextTransformedSourceType.getKey();
            if (textTransformationOutputAttributeType != null && object.getName().equals(textTransformationOutputAttributeType.getName()) || !object.getName().equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (MapTextTransformedSourceType mapTextTransformedSourceType : this._sourceAttributes.getTransformationSourceAttributeType()) {
                object = mapTextTransformedSourceType.getAlias() == null ? mapTextTransformedSourceType.getName() : mapTextTransformedSourceType.getAlias();
                if (!((String)object).equals(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean doWork() {
        boolean bl = true;
        try {
            if (!this._isReadOnly) {
                Object object;
                String string = (String)this.jSourceColumnComboBox.getSelectedItem();
                String string2 = this.jOutputColumnTextField.getText();
                if (!AttributeNameValidator.isNameLengthValidInDB(this._context, string2 = StringUtils.trimDoubleQuotes(string2), false)) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("ADD_BUILDTEXT_DIALOG_ERROR_NAME_LONG"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                    return false;
                }
                if (this.doesNameExist(string2)) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("ADD_BUILDTEXT_DIALOG_ERROR_DUPLICATE_NAME"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                    return false;
                }
                TextTransformationType textTransformationType = null;
                JPanel jPanel = (JPanel)this.jSettingPanel.getComponent(0);
                boolean bl2 = jPanel instanceof TextTransColumnSettingTokenPanel;
                if (this._isEdit) {
                    object = this.getSelectedOutputAttribute();
                    String string3 = object.getName();
                    List list = this._transformedAttributes.getMapTextTransformedSource();
                    for (MapTextTransformedSourceType mapTextTransformedSourceType : list) {
                        TextTransformationOutputAttributeType textTransformationOutputAttributeType = mapTextTransformedSourceType.getKey();
                        if (!textTransformationOutputAttributeType.getName().equals(string3)) continue;
                        textTransformationType = textTransformationOutputAttributeType.getTransformationElement();
                        if (string3.equals(string2)) continue;
                        textTransformationOutputAttributeType.setName(string2);
                        this._dirty = true;
                    }
                } else {
                    object = this._transformedAttributes.getMapTextTransformedSource();
                    MapTextTransformedSourceType mapTextTransformedSourceType = new MapTextTransformedSourceType();
                    TextTransformationOutputAttributeType textTransformationOutputAttributeType = new TextTransformationOutputAttributeType();
                    textTransformationType = new TextTransformationType();
                    textTransformationOutputAttributeType.setSource(string);
                    textTransformationOutputAttributeType.setName(string2);
                    textTransformationOutputAttributeType.setDataType("DM_NESTED_NUMERICALS");
                    textTransformationOutputAttributeType.setIsOutput(true);
                    textTransformationOutputAttributeType.setModified(true);
                    textTransformationOutputAttributeType.setStatus(AttributeStatus.VALID);
                    textTransformationOutputAttributeType.setTransformationElement(textTransformationType);
                    mapTextTransformedSourceType.setKey(textTransformationOutputAttributeType);
                    object.add(mapTextTransformedSourceType);
                    textTransformationType = textTransformationOutputAttributeType.getTransformationElement();
                    this._dirty = true;
                }
                boolean bl3 = false;
                bl3 = bl2 ? this._tokenPanel.copySettings(textTransformationType, this._existStoplists) : this._themePanel.copySettings(textTransformationType, this._existStoplists);
                if (!this._dirty) {
                    this._dirty = bl3;
                }
                if (this._dirty) {
                    this.updateNode();
                }
            }
        }
        catch (ValidationException validationException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)validationException.getLocalizedMessage(), (String)DialogsLrb.get("ERROR_TITLE"), null);
            bl = false;
        }
        return bl;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup4 = new ButtonGroup();
        this.jSourceColumnLabel = new JLabel();
        this.jSourceColumnComboBox = new JComboBox();
        this.jTransformTypeLabel = new JLabel();
        this.jTransformTypeComboBox = new JComboBox();
        this.jOutputColumnLabel = new JLabel();
        this.jOutputColumnTextField = new JTextField();
        this.jAutoOutputColumnNameCheckBox = new JCheckBox();
        this.jSeparator = new JSeparator();
        this.jSettingPanel = new JPanel();
        this.jSourceColumnLabel.setLabelFor(this.jSourceColumnComboBox);
        this.jSourceColumnLabel.setText("Source Column:");
        this.jSourceColumnComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"012345678901234567890123456789"}));
        this.jSourceColumnComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingPanel.this.jSourceColumnComboBoxActionPerformed(actionEvent);
            }
        });
        this.jTransformTypeLabel.setLabelFor(this.jTransformTypeComboBox);
        this.jTransformTypeLabel.setText("Transform Type:");
        this.jTransformTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Token", "Theme"}));
        this.jTransformTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingPanel.this.jTransformTypeComboBoxActionPerformed(actionEvent);
            }
        });
        this.jOutputColumnLabel.setLabelFor(this.jOutputColumnTextField);
        this.jOutputColumnLabel.setText("Output Column:");
        this.jOutputColumnTextField.setText("jTextField1");
        this.jAutoOutputColumnNameCheckBox.setText("Automatic");
        this.jAutoOutputColumnNameCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingPanel.this.jAutoOutputColumnNameCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jSeparator.setMaximumSize(new Dimension(400, Short.MAX_VALUE));
        this.jSettingPanel.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.jSettingPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSettingPanel, GroupLayout.Alignment.LEADING, -1, 374, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jOutputColumnLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jSourceColumnLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jTransformTypeLabel, -1, 86, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSourceColumnComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jOutputColumnTextField).addComponent(this.jTransformTypeComboBox, 0, 112, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jAutoOutputColumnNameCheckBox)).addComponent(this.jSeparator, GroupLayout.Alignment.LEADING, -1, 374, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSourceColumnLabel).addComponent(this.jSourceColumnComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTransformTypeLabel).addComponent(this.jTransformTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jOutputColumnLabel).addComponent(this.jOutputColumnTextField, -2, -1, -2).addComponent(this.jAutoOutputColumnNameCheckBox)).addGap(11, 11, 11).addComponent(this.jSeparator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSettingPanel, -1, 384, Short.MAX_VALUE).addContainerGap()));
    }

    private void jTransformTypeComboBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        Object object;
        if (this._isAdjusting) {
            return;
        }
        this._isAdjusting = true;
        String string = (String)this.jTransformTypeComboBox.getSelectedItem();
        TextTransformationType textTransformationType = null;
        if (this._isEdit) {
            List<TransformationSourceAttribute> list = this._selectedAttributes;
            object = (TextTransformationOutputAttributeType)list.get(0);
            textTransformationType = object.getTransformationElement();
        }
        if (bl = this.jAutoOutputColumnNameCheckBox.isSelected()) {
            object = (String)this.jSourceColumnComboBox.getSelectedItem();
            String string2 = this.generateOutputName((String)object);
            this.jOutputColumnTextField.setText(string2);
        }
        this.jSettingPanel.removeAll();
        if (string.equals(TRANSFORM_TOKEN)) {
            this._tokenPanel.refreshUI(textTransformationType);
            this.jSettingPanel.add(this._tokenPanel);
        } else {
            this._themePanel.refreshUI(textTransformationType);
            this.jSettingPanel.add(this._themePanel);
        }
        this.jSettingPanel.updateUI();
        this._isAdjusting = false;
    }

    private void jAutoOutputColumnNameCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this._isAdjusting) {
            return;
        }
        this._isAdjusting = true;
        boolean bl = this.jAutoOutputColumnNameCheckBox.isSelected();
        if (bl) {
            String string = (String)this.jSourceColumnComboBox.getSelectedItem();
            String string2 = this.generateOutputName(string);
            this.jOutputColumnTextField.setText(string2);
        }
        this.jOutputColumnTextField.setEnabled(!bl);
        this._isAdjusting = false;
    }

    private void jSourceColumnComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._isAdjusting) {
            return;
        }
        this._isAdjusting = true;
        String string = null;
        String string2 = null;
        if (this._isEdit) {
            List<TransformationSourceAttribute> list = this._selectedAttributes;
            TextTransformationOutputAttributeType textTransformationOutputAttributeType = (TextTransformationOutputAttributeType)list.get(0);
            if (textTransformationOutputAttributeType.getTransformationElement().getTheme() != null) {
                this.jTransformTypeComboBox.setSelectedItem(TRANSFORM_THEME);
            } else {
                this.jTransformTypeComboBox.setSelectedItem(TRANSFORM_TOKEN);
            }
            string2 = textTransformationOutputAttributeType.getSource();
            string = textTransformationOutputAttributeType.getName();
        } else {
            this.jTransformTypeComboBox.setSelectedItem(TRANSFORM_TOKEN);
            string2 = (String)this.jSourceColumnComboBox.getSelectedItem();
            string = this.generateOutputName(string2);
        }
        this.jOutputColumnTextField.setText(string);
        this._tokenPanel.setSourceAttributeName(string2);
        this._themePanel.setSourceAttributeName(string2);
        this._isAdjusting = false;
    }

    public TransformedAttributesType getTransformedAttributes() {
        return this._transformedAttributes;
    }

    public String getSourceAttributeName() {
        return this._sourceAttributeName;
    }

    public TextNodeType.Stoplists getStoplists() {
        return this._existStoplists;
    }

    public void setExistStoplists(TextNodeType.Stoplists stoplists) {
        this._existStoplists = stoplists;
    }

    public TextNodeType.Stoplists getExistStoplists() {
        return this._existStoplists;
    }
}

