/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.NiceTableWithToolbar;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.AddStopwordsDialog;
import oracle.dmt.dataminer.workflow.dialog.buildText.AddStopwordsPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingThemePanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingTokenPanel;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.applyText.WorkflowApplyTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.buildText.WorkflowBuildTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.text.WorkflowTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class StoplistDetailsPanel
extends AbstractDialogPanel {
    private JPanel _parent;
    private StoplistType _stoplist;
    private ArrayList<String> _stoplists = null;
    private PropertyModel _propertyModel;
    private boolean _isEdit;
    private boolean _dirty;
    private boolean _isAdjusting;
    private StopwordTableModel _stopwordModels;
    private NiceTableWithToolbar _stopwordTableWithToolbar;
    private JButton _stopwordRemoveBtn;
    private JButton _stopwordAddBtn;
    private static Icon _removeIcon;
    private static Icon _addIcon;
    private ComponentWithTitlebar<JComponent> StopwordComponentWithTitlebar;
    private JLabel jLanguageLabel;
    private JLabel jLanguageValueLabel;
    private JLabel jStoplistLabel;
    private JTextField jStoplistTextField;
    private String[] _stopwordColumnNames = new String[]{DialogsLrb.get("STOPLIST_COLUMN_NAME"), DialogsLrb.get("STOPLIST_COLUMN_TYPE"), DialogsLrb.get("STOPLIST_COLUMN_LANGUAGE")};
    private int[] _stopwordColumnWidths = new int[]{180, 100, 100};
    private static final int STOPWORD_NAME = 0;
    private static final int STOPWORD_TYPE = 1;
    private static final int STOPWORD_LANGUAGE = 2;
    private static final int STOPWORD_COLUMN_COUNT = 3;

    public StoplistDetailsPanel(PropertyModel propertyModel, JPanel jPanel, StoplistType stoplistType, boolean bl) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for TextNode node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.init((AbstractTextNode)this._data, propertyModel, jPanel, stoplistType, bl);
    }

    public StoplistDetailsPanel(Context context, AbstractTextNode abstractTextNode, JPanel jPanel, StoplistType stoplistType, boolean bl) {
        super(context, abstractTextNode);
        assert (context != null) : "Context must not be null.";
        assert (abstractTextNode != null) : "TextNode node must not be null.";
        assert (abstractTextNode instanceof AbstractTextNode) : "Must be an instance of TextNode node.";
        this.init(abstractTextNode, null, jPanel, stoplistType, bl);
    }

    private void init(AbstractTextNode abstractTextNode, PropertyModel propertyModel, JPanel jPanel, StoplistType stoplistType, boolean bl) {
        this._propertyModel = propertyModel;
        this._parent = jPanel;
        if (jPanel instanceof TextTransColumnSettingTokenPanel) {
            this._stoplists = ((TextTransColumnSettingTokenPanel)jPanel).getAvailableStoplists();
        } else if (jPanel instanceof TextTransColumnSettingThemePanel) {
            this._stoplists = ((TextTransColumnSettingThemePanel)jPanel).getAvailableStoplists();
        }
        this._stoplist = (StoplistType)MetaDataHelper.copyMetadataObject(stoplistType);
        this._isEdit = bl;
        this._dirty = false;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("BUILDTEXT_STOPLIST"), this.jStoplistLabel);
        hashMap.put(DialogsLrb.get("ADD_STOPWORD_LANGUAGE"), this.jLanguageLabel);
        UIResourceHelper.setComponentText(hashMap);
        Class<PIComponentPanel> clazz = PIComponentPanel.class;
        _removeIcon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_REMOVE_ICON"));
        _addIcon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_ATTRIBUTES_GROUP_VALUE_ADD_ICON"));
    }

    @Override
    public void initUI() {
        this._isAdjusting = true;
        HelpUtils.setHelpID((JComponent)this, (String)"stoplist_details");
        this.jStoplistTextField.setText(this._stoplist.getName());
        this.jStoplistTextField.setEditable(this._isEdit);
        String string = null;
        string = this._stoplist.getType().equals("Basic") ? ServerConstants.StoplistLanguage.toHuman(this._stoplist.getLanguage()) : ServerConstants.StoplistLanguage.toHuman("Multi");
        this.jLanguageValueLabel.setText(string);
        this._stopwordModels = new StopwordTableModel(this._stoplist.getStopTokens(), !this._isEdit);
        ControlBar controlBar = new ControlBar();
        this.installStopwordItemFilterActions(controlBar);
        this._stopwordTableWithToolbar = new NiceTableWithToolbar(this.StopwordComponentWithTitlebar, controlBar, this._stopwordColumnNames, this._stopwordModels);
        this._stopwordTableWithToolbar.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("STOPLIST_STOPWORD_TABLE_TITLE")));
        this._stopwordTableWithToolbar.getNiceTable().setAutoResizeMode(0);
        this._stopwordTableWithToolbar.getNiceTable().setSelectionMode(2);
        this._stopwordTableWithToolbar.getNiceTable().setColumnSelectorAvailable(true);
        this._stopwordTableWithToolbar.getNiceTable().setShowToolTips(true);
        this._stopwordTableWithToolbar.getNiceTable().setUpdateSelectionOnSort(true);
        this._stopwordTableWithToolbar.getNiceTable().setRowSelectionAllowed(true);
        this._stopwordTableWithToolbar.getNiceTable().setSortColumn(0, true);
        if (this._isEdit) {
            TableColumn tableColumn = this._stopwordTableWithToolbar.getNiceTable().getColumnModel().getColumn(0);
            Object object = new StopwordEditor();
            ((StopwordEditor)object).setDocument(new TextFieldLimit(4000));
            tableColumn.setCellEditor((TableCellEditor)object);
        }
        int n = 0;
        for (int n2 : this._stopwordColumnWidths) {
            this._stopwordTableWithToolbar.getNiceTable().getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        this._stopwordTableWithToolbar.getNiceTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                StoplistDetailsPanel.this.enableControls();
            }
        });
        this._isAdjusting = false;
        this.enableControls();
    }

    private void installStopwordItemFilterActions(ControlBar controlBar) {
        this._stopwordRemoveBtn = new JButton(_removeIcon);
        this._stopwordRemoveBtn.setToolTipText(DialogsLrb.get("STOPLIST_DELETE_STOPWORD_TOOLTIP"));
        this._stopwordRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = StoplistDetailsPanel.this._stopwordTableWithToolbar.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    StoplistDetailsPanel.this._stopwordModels.removeSelectedRows(nArray);
                    StoplistDetailsPanel.this._stopwordTableWithToolbar.resetNiceTableModel(StoplistDetailsPanel.this._stopwordModels);
                }
            }
        });
        controlBar.add((Component)this._stopwordRemoveBtn);
        this._stopwordAddBtn = new JButton(_addIcon);
        this._stopwordAddBtn.setToolTipText(DialogsLrb.get("STOPLIST_ADD_STOPWORD_TOOLTIP"));
        this._stopwordAddBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StoplistDetailsPanel.this.processAdd();
            }
        });
        controlBar.add((Component)this._stopwordAddBtn);
    }

    private void processAdd() {
        AddStopwordsPanel addStopwordsPanel;
        AddStopwordsDialog addStopwordsDialog = new AddStopwordsDialog();
        if (addStopwordsDialog.invoke(this.getContext(), null, this, this._stoplist) && (addStopwordsPanel = addStopwordsDialog.getPanel()).isDirty()) {
            this._dirty = true;
            this._stoplist = addStopwordsPanel.getStoplist();
            this._stopwordModels = new StopwordTableModel(this._stoplist.getStopTokens(), !this._isEdit);
            this._stopwordTableWithToolbar.resetNiceTableModel(this._stopwordModels);
            this.enableControls();
        }
    }

    private void enableControls() {
        this._stopwordAddBtn.setEnabled(this._isEdit);
        int[] nArray = this._stopwordTableWithToolbar.getNiceTable().getSelectedRowsInModel();
        this._stopwordRemoveBtn.setEnabled(this._isEdit && nArray.length > 0);
    }

    private boolean isPIMode() {
        return this._propertyModel != null;
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        Context context = null;
        if (propertyModel instanceof WorkflowTextNodePropertyProxyModel) {
            WorkflowTextNodePropertyProxyModel workflowTextNodePropertyProxyModel = (WorkflowTextNodePropertyProxyModel)propertyModel;
            context = workflowTextNodePropertyProxyModel.getSelectionContext();
        } else if (propertyModel instanceof WorkflowBuildTextNodePropertyProxyModel) {
            WorkflowBuildTextNodePropertyProxyModel workflowBuildTextNodePropertyProxyModel = (WorkflowBuildTextNodePropertyProxyModel)propertyModel;
            context = workflowBuildTextNodePropertyProxyModel.getSelectionContext();
        } else if (propertyModel instanceof WorkflowApplyTextNodePropertyProxyModel) {
            WorkflowApplyTextNodePropertyProxyModel workflowApplyTextNodePropertyProxyModel = (WorkflowApplyTextNodePropertyProxyModel)propertyModel;
            context = workflowApplyTextNodePropertyProxyModel.getSelectionContext();
        }
        return context;
    }

    private AbstractTextNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        Context context = this.getContext(propertyModel);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        return (AbstractTextNode)workflowNodeInspectorElement.getNode();
    }

    private void updateNode() {
        String string = this.jStoplistTextField.getText();
        this._stoplist.setName(string);
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    private boolean isNameUnique(String string, String string2, List<String> list) {
        if (list == null) {
            return true;
        }
        for (String string3 : list) {
            if (string.equals(string3) || !string3.equals(string2)) continue;
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_ERROR_DUPLICATE_STOPLIST"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            return false;
        }
        return true;
    }

    public boolean doWork() {
        boolean bl = true;
        if (this._isEdit) {
            String string = this.jStoplistTextField.getText().trim();
            if (string == null || string.length() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_WIZ_NAME_EMPTY"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                bl = false;
            } else {
                if (!this.isNameUnique(this._stoplist.getName(), string, this._stoplists)) {
                    return false;
                }
                if (!AttributeNameValidator.isNameLengthValidInDB(this._context, string, false)) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_WIZ_NAME_TOO_LONG"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                    bl = false;
                }
            }
            if (bl) {
                if (!this._stoplist.getName().equals(string)) {
                    this._dirty = true;
                }
                if (this._dirty) {
                    this.updateNode();
                }
            }
        }
        return bl;
    }

    private void initComponents() {
        this.jStoplistLabel = new JLabel();
        this.jStoplistTextField = new JTextField();
        this.jLanguageLabel = new JLabel();
        this.jLanguageValueLabel = new JLabel();
        this.StopwordComponentWithTitlebar = new ComponentWithTitlebar();
        this.jStoplistLabel.setText("Stoplist:");
        this.jStoplistTextField.setText("jTextField1");
        this.jLanguageLabel.setText("Language:");
        this.jLanguageValueLabel.setText("jLabel3");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.StopwordComponentWithTitlebar, -1, 458, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLanguageLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jStoplistLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLanguageValueLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jStoplistTextField, -1, 213, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jStoplistLabel).addComponent(this.jStoplistTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLanguageLabel).addComponent(this.jLanguageValueLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.StopwordComponentWithTitlebar, -1, 301, Short.MAX_VALUE).addContainerGap()));
    }

    public StoplistType getStoplist() {
        return this._stoplist;
    }

    private class StopwordEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JTextField _textField = new JTextField();

        public StopwordEditor() {
            this._textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StopwordEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof String) {
                String string = (String)object;
                this._textField.setText(string);
            } else if (object == null) {
                this._textField.setText("");
            }
            return this._textField;
        }

        @Override
        public Object getCellEditorValue() {
            return this._textField.getText();
        }

        public void setDocument(Document document) {
            this._textField.setDocument(document);
        }
    }

    private class StopwordTableModel
    extends GenericBaseTableModel {
        private StoplistType.StopTokens _tokens;
        private boolean _readOnly = false;

        public StopwordTableModel(StoplistType.StopTokens stopTokens, boolean bl) {
            this._tokens = stopTokens;
            this.setColumnIdentifiers(StoplistDetailsPanel.this._stopwordColumnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(3);
            this._readOnly = bl;
        }

        public int getRowCount() {
            return this._tokens == null ? 0 : this._tokens.getToken().size();
        }

        public boolean isCellEditable(int n, int n2) {
            if (this._readOnly) {
                return false;
            }
            return n2 == 0;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            if (this._tokens == null || this._tokens.getToken().size() == 0) {
                return null;
            }
            StoplistType.StopTokens.Token token = (StoplistType.StopTokens.Token)this._tokens.getToken().get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = token.getItem();
                    break;
                }
                case 1: {
                    string = ServerConstants.StopTokenType.toHuman(token.getType());
                    break;
                }
                case 2: {
                    string = ServerConstants.StoplistLanguage.toHuman(token.getLanguage());
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            StoplistType.StopTokens.Token token = (StoplistType.StopTokens.Token)this._tokens.getToken().get(n);
            switch (n2) {
                case 0: {
                    String string = null;
                    if (object != null) {
                        string = ((String)object).trim();
                    }
                    if (!this.validateStopwords(n, string, token.getLanguage(), this._tokens.getToken())) {
                        return;
                    }
                    StoplistDetailsPanel.this._dirty = true;
                    token.setItem((String)object);
                    token.setType(ServerConstants.StopTokenType.toSchema(this.getType((String)object)));
                }
            }
        }

        public void removeSelectedRows(int[] nArray) {
            Vector<StoplistType.StopTokens.Token> vector = new Vector<StoplistType.StopTokens.Token>();
            StoplistType.StopTokens.Token token = null;
            for (int i = 0; i < nArray.length; ++i) {
                token = (StoplistType.StopTokens.Token)this._tokens.getToken().get(nArray[i]);
                vector.add(token);
            }
            this._tokens.getToken().removeAll(vector);
            this.setRowCount(this._tokens.getToken().size());
            StoplistDetailsPanel.this._dirty = true;
        }

        private String getType(String string) {
            return string.indexOf(32) == -1 ? "Word" : "Theme";
        }

        private boolean validateStopwords(int n, String string, String string2, List<StoplistType.StopTokens.Token> list) {
            boolean bl = true;
            int n2 = 0;
            if (string == null || string.length() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_ERROR_STOPWORD_EMPTY"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            for (StoplistType.StopTokens.Token token : list) {
                String string3 = string + this.getType(string) + string2;
                String string4 = token.getItem() + token.getType() + token.getLanguage();
                if (n != n2 && string3.compareTo(string4) == 0) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_ERROR_DUPLICATE_STOPWORD"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            }
            return bl;
        }

        public StoplistType.StopTokens getTokens() {
            return this._tokens;
        }
    }
}

