/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import oracle.dmt.dataminer.controls.NiceTableWithToolbar;
import oracle.dmt.dataminer.teditor.sql.SQLEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.applyText.ApplyTextPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.BuildTextPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.text.TextPanel;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.SwingWorker;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.TextComponentSearchSupport;

public class BuildTextTokenPanel
extends JPanel {
    private Context _context;
    private AbstractDialogPanel _parent;
    private AbstractTextNode _node;
    private TextTransformationOutputAttributeType _outputAttribute = null;
    private OutputTableModel _rowModels;
    private TransformTableModel _xformModels;
    private NiceTableWithToolbar _rowTableWithToolbar;
    private NiceTableWithToolbar _xformTableWithToolbar;
    private ComponentWithTitlebar<JComponent> ColumnComponentWithTitlebar;
    private ComponentWithTitlebar<JComponent> RowComponentWithTitlebar;
    private ComponentWithTitlebar<JComponent> TransColumnComponentWithTitlebar;
    private JPanel jColumnPanel;
    private JPanel jPanel;
    private JSplitPane jSplitPane;
    private JSplitPane jSplitPane2;
    private JPanel jTransColumnPanel;
    private SearchField _jFilterCtl = new SearchField();
    private JTextPane _jTextArea = new JTextPane();
    private Component _findPane;
    TextComponentSearchSupport _textSearchComponent;
    private static final int OUTPUT_CASEID = 0;
    private static final int OUTPUT_COLUMN_COUNT = 1;
    private static final int OUTPUT_FEATURES = 99;
    private static final int OUTPUT_COLUMN = 100;
    private String[] _outputColumnNames = new String[]{DialogsLrb.get("BUILDTEXT_COLUMN_CASEID")};
    private int[] _outputColumnWidths = new int[]{150};
    private static final int TRANSFORM_ATTRIBUTE = 0;
    private static final int TRANSFORM_FREQUENCY = 1;
    private static final int TRANSFORM_COLUMN_COUNT = 2;
    private String[] _transformColumnNames = new String[]{DialogsLrb.get("BUILDTEXT_COLUMN_ATTRIBUTE"), DialogsLrb.get("BUILDTEXT_COLUMN_FREQUENCY")};
    private int[] _transformColumnWidths = new int[]{150, 100};

    public BuildTextTokenPanel(Context context, AbstractTextNode abstractTextNode) {
        this._context = context;
        this._node = abstractTextNode;
        this.initComponents();
        this.initUI();
    }

    public void initUI() {
        ControlBar controlBar = new ControlBar();
        CaseAttributes caseAttributes = ((TextNodeType)this._node.getData()).getCaseAttributes();
        if (caseAttributes != null && !caseAttributes.getAttribute().isEmpty()) {
            this._outputColumnNames[0] = ((AttributeType)caseAttributes.getAttribute().get(0)).getName();
        }
        this._rowModels = new OutputTableModel(null);
        this._rowTableWithToolbar = new NiceTableWithToolbar(this.RowComponentWithTitlebar, controlBar, this._outputColumnNames, this._rowModels);
        this._rowTableWithToolbar.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("BUILDTEXT_TABLE_OUTPUT_SAMPLE")));
        this._rowTableWithToolbar.getNiceTable().setAutoResizeMode(4);
        this._rowTableWithToolbar.getNiceTable().setSelectionMode(0);
        this._rowTableWithToolbar.getNiceTable().setColumnSelectorAvailable(true);
        this._rowTableWithToolbar.getNiceTable().setShowToolTips(true);
        this._rowTableWithToolbar.getNiceTable().setUpdateSelectionOnSort(true);
        this._rowTableWithToolbar.getNiceTable().setRowSelectionAllowed(true);
        this._rowTableWithToolbar.getNiceTable().setSortColumn(0, true);
        this._rowTableWithToolbar.getNiceTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                int[] nArray = BuildTextTokenPanel.this._rowTableWithToolbar.getNiceTable().getSelectedRowsInModel();
                if (nArray != null && nArray.length > 0) {
                    String string = (String)BuildTextTokenPanel.this._rowModels.getValueAt(nArray[0], 100);
                    BuildTextTokenPanel.this._jTextArea.setEditable(false);
                    BuildTextTokenPanel.this._jTextArea.setText(string);
                    BuildTextTokenPanel.this._jTextArea.setCaretPosition(BuildTextTokenPanel.this._jTextArea.getDocument().getLength());
                    BuildTextTokenPanel.this._jTextArea.moveCaretPosition(0);
                    BuildTextTokenPanel.this._jTextArea.select(0, 0);
                    List list = (List)BuildTextTokenPanel.this._rowModels.getValueAt(nArray[0], 99);
                    BuildTextTokenPanel.this._xformModels = new TransformTableModel(list);
                    BuildTextTokenPanel.this._xformTableWithToolbar.resetNiceTableModel(BuildTextTokenPanel.this._xformModels);
                    BuildTextTokenPanel.this.enableControls();
                }
            }
        });
        controlBar = new ControlBar();
        this._xformModels = new TransformTableModel(null);
        this._xformTableWithToolbar = new NiceTableWithToolbar(this.TransColumnComponentWithTitlebar, controlBar, this._transformColumnNames, this._xformModels);
        this._xformTableWithToolbar.getNiceTable().setAutoResizeMode(4);
        this._xformTableWithToolbar.getNiceTable().setColumnSelectorAvailable(true);
        this._xformTableWithToolbar.getNiceTable().setShowToolTips(true);
        this._xformTableWithToolbar.getNiceTable().setRowSelectionAllowed(false);
        this._xformTableWithToolbar.getNiceTable().setSortColumn(0, true);
        this._textSearchComponent = new TextComponentSearchSupport((JTextComponent)this._jTextArea);
        JScrollPane jScrollPane = new JScrollPane(this._jTextArea);
        this.ColumnComponentWithTitlebar.setComponent((JComponent)jScrollPane);
        controlBar = new ControlBar();
        this._findPane = this.createFindPane();
        controlBar.add(this._findPane);
        this.ColumnComponentWithTitlebar.setControlBar(controlBar);
        this._jFilterCtl.setStyle(SearchField.Style.FIND);
        this._jFilterCtl.setPrompt(SQLEditorLrb.get("SQL_VIEWER_FIND"));
        this._jFilterCtl.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                SearchEvent.Direction direction = searchEvent.getDirection();
                String string = searchEvent.getSearchText();
                BuildTextTokenPanel.this._textSearchComponent.search(direction, string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
        LoadUI loadUI = new LoadUI(this._outputAttribute);
        loadUI.start();
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private Component createFindPane() {
        Box box = new Box(2);
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._jFilterCtl);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 180);
        Dimension dimension3 = this.derive(dimension, 100);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    public synchronized void refreshUI(AbstractDialogPanel abstractDialogPanel, TextTransformationOutputAttributeType textTransformationOutputAttributeType) {
        this._parent = abstractDialogPanel;
        if (this._outputAttribute != null && this._outputAttribute.equals(textTransformationOutputAttributeType)) {
            return;
        }
        this._outputAttribute = textTransformationOutputAttributeType;
        LoadUI loadUI = new LoadUI(this._outputAttribute);
        loadUI.start();
    }

    private void enableControls() {
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jPanel = new JPanel();
        this.RowComponentWithTitlebar = new ComponentWithTitlebar();
        this.jSplitPane2 = new JSplitPane();
        this.jColumnPanel = new JPanel();
        this.ColumnComponentWithTitlebar = new ComponentWithTitlebar();
        this.jTransColumnPanel = new JPanel();
        this.TransColumnComponentWithTitlebar = new ComponentWithTitlebar();
        this.jSplitPane.setDividerLocation(150);
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setResizeWeight(0.5);
        this.jSplitPane.setOneTouchExpandable(true);
        GroupLayout groupLayout = new GroupLayout(this.jPanel);
        this.jPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.RowComponentWithTitlebar, -1, 598, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.RowComponentWithTitlebar, -1, 127, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane.setTopComponent(this.jPanel);
        this.jSplitPane2.setDividerLocation(350);
        this.jSplitPane2.setResizeWeight(0.5);
        GroupLayout groupLayout2 = new GroupLayout(this.jColumnPanel);
        this.jColumnPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.ColumnComponentWithTitlebar, -1, 329, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.ColumnComponentWithTitlebar, -1, 120, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane2.setLeftComponent(this.jColumnPanel);
        GroupLayout groupLayout3 = new GroupLayout(this.jTransColumnPanel);
        this.jTransColumnPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent((Component)this.TransColumnComponentWithTitlebar, -1, 242, Short.MAX_VALUE).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent((Component)this.TransColumnComponentWithTitlebar, -1, 120, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane2.setRightComponent(this.jTransColumnPanel);
        this.jSplitPane.setRightComponent(this.jSplitPane2);
        GroupLayout groupLayout4 = new GroupLayout(this);
        this.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, -1, 620, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, -1, 300, Short.MAX_VALUE));
    }

    private class TransformTableModel
    extends GenericBaseTableModel {
        private List<AbstractTextNode.Statistics> _data = null;

        public TransformTableModel(List<AbstractTextNode.Statistics> list) {
            this._data = list;
            this.setColumnIdentifiers(BuildTextTokenPanel.this._transformColumnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(2);
        }

        public int getRowCount() {
            return this._data == null ? 0 : this._data.size();
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return String.class;
            }
            if (n == 1) {
                return Integer.class;
            }
            return null;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            if (this._data == null || this._data.size() == 0) {
                return null;
            }
            AbstractTextNode.Statistics statistics = this._data.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = statistics.getToken();
                    break;
                }
                case 1: {
                    object = statistics.getValue();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }
    }

    private class OutputTableModel
    extends GenericBaseTableModel {
        private List<BuildTextNode.Features> _data = null;

        public OutputTableModel(List<BuildTextNode.Features> list) {
            this._data = list;
            this.setColumnIdentifiers(BuildTextTokenPanel.this._outputColumnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(1);
        }

        public int getRowCount() {
            return this._data == null ? 0 : this._data.size();
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object == null) {
                return String.class;
            }
            return object.getClass();
        }

        public Object getValueAt(int n, int n2) {
            if (this._data == null || this._data.size() == 0) {
                return null;
            }
            BuildTextNode.Features features = this._data.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = features.getCaseId();
                    break;
                }
                case 99: {
                    object = features.getFeatures();
                    break;
                }
                case 100: {
                    object = features.getColumn();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }
    }

    private class LoadUI
    extends SwingWorker {
        private TextTransformationOutputAttributeType _outputAttribute;
        private String _sourceColumnName;
        private String _xformColumnName;
        private Exception _ex = null;
        private boolean _success = false;

        public LoadUI(TextTransformationOutputAttributeType textTransformationOutputAttributeType) {
            this._outputAttribute = textTransformationOutputAttributeType;
            this._sourceColumnName = null;
            this._xformColumnName = null;
        }

        public Object construct() {
            List<BuildTextNode.Features> list = new ArrayList<BuildTextNode.Features>();
            try {
                if (this._outputAttribute != null) {
                    BuildTextTokenPanel.this.ColumnComponentWithTitlebar.setLabel(null);
                    BuildTextTokenPanel.this.ColumnComponentWithTitlebar.repaint();
                    BuildTextTokenPanel.this._jTextArea.setText("");
                    BuildTextTokenPanel.this._xformTableWithToolbar.getCompToolbar().setLabel(null);
                    BuildTextTokenPanel.this._xformTableWithToolbar.getCompToolbar().repaint();
                    BuildTextTokenPanel.this._xformTableWithToolbar.resetNiceTableModel(new TransformTableModel(null));
                    TransformationTokenType transformationTokenType = this._outputAttribute.getTransformationElement().getToken();
                    TextTransformationType.Theme theme = this._outputAttribute.getTransformationElement().getTheme();
                    boolean bl = false;
                    if (transformationTokenType != null) {
                        bl = transformationTokenType.getToken().getFeatureTable() != null;
                    } else if (theme != null) {
                        boolean bl2 = bl = theme.getToken().getFeatureTable() != null;
                    }
                    if (bl) {
                        list.add(new BuildTextNode.Features(DialogsLrb.get("BUILDTEXT_LOADING"), null, null));
                        BuildTextTokenPanel.this._rowModels = new OutputTableModel(list);
                        BuildTextTokenPanel.this._rowTableWithToolbar.resetNiceTableModel(BuildTextTokenPanel.this._rowModels);
                        list = BuildTextNode.loadFeatures(BuildTextTokenPanel.this._context, this._outputAttribute);
                        if (list.isEmpty()) {
                            if (theme != null) {
                                list.add(new BuildTextNode.Features(DialogsLrb.get("BUILDTEXT_NODE_NO_THEME_GENERATED"), null, null));
                            } else {
                                list.add(new BuildTextNode.Features(DialogsLrb.get("BUILDTEXT_NODE_NO_TOKEN_GENERATED"), null, null));
                            }
                        }
                    } else {
                        list.add(new BuildTextNode.Features(DialogsLrb.get("BUILDTEXT_OUTPUT_NOT_AVAILABLE"), null, null));
                    }
                    this._sourceColumnName = this._outputAttribute.getSource();
                    this._xformColumnName = this._outputAttribute.getName();
                } else {
                    list.add(new BuildTextNode.Features(DialogsLrb.get("BUILDTEXT_NOT_XFORMED_COLUMN"), null, null));
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            block9: {
                Object object;
                if (BuildTextTokenPanel.this._parent != null) {
                    TextTransformationOutputAttributeType textTransformationOutputAttributeType;
                    if (BuildTextTokenPanel.this._parent instanceof BuildTextPanel && (textTransformationOutputAttributeType = ((BuildTextPanel)(object = (BuildTextPanel)BuildTextTokenPanel.this._parent)).getSelectedTextTransformationOutputAttribute()) != null && !textTransformationOutputAttributeType.getName().equals(this._outputAttribute.getName())) {
                        return;
                    }
                    if (BuildTextTokenPanel.this._parent instanceof ApplyTextPanel && (textTransformationOutputAttributeType = ((ApplyTextPanel)(object = (ApplyTextPanel)BuildTextTokenPanel.this._parent)).getSelectedTextTransformationOutputAttribute()) != null && !textTransformationOutputAttributeType.getName().equals(this._outputAttribute.getName())) {
                        return;
                    }
                    if (BuildTextTokenPanel.this._parent instanceof TextPanel && (textTransformationOutputAttributeType = ((TextPanel)(object = (TextPanel)BuildTextTokenPanel.this._parent)).getSelectedTextTransformationOutputAttribute()) != null && !textTransformationOutputAttributeType.getName().equals(this._outputAttribute.getName())) {
                        return;
                    }
                }
                try {
                    if (this._success && this._ex == null) {
                        object = (List)this.getValue();
                        BuildTextTokenPanel.this._rowModels = new OutputTableModel((List<BuildTextNode.Features>)object);
                        BuildTextTokenPanel.this._rowTableWithToolbar.resetNiceTableModel(BuildTextTokenPanel.this._rowModels);
                        BuildTextTokenPanel.this._xformTableWithToolbar.resetNiceTableModel(new TransformTableModel(null));
                        BuildTextTokenPanel.this._jTextArea.setText("");
                        BuildTextTokenPanel.this._rowTableWithToolbar.getNiceTable().setSortColumn(0, true);
                        BuildTextTokenPanel.this.ColumnComponentWithTitlebar.setLabel(this._sourceColumnName != null ? new JLabel(this._sourceColumnName) : null);
                        BuildTextTokenPanel.this.ColumnComponentWithTitlebar.repaint();
                        BuildTextTokenPanel.this._xformTableWithToolbar.getCompToolbar().setLabel(this._xformColumnName != null ? new JLabel(this._xformColumnName) : null);
                        BuildTextTokenPanel.this._xformTableWithToolbar.getCompToolbar().repaint();
                        break block9;
                    }
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("BUILDTEXT_NODE_EDIT_ERROR_MESG"), null);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("BUILDTEXT_NODE_EDIT_ERROR_MESG"), null);
                }
            }
            BuildTextTokenPanel.this.enableControls();
        }
    }
}

