/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.OutputCellEditor;
import oracle.dmt.dataminer.controls.OutputCellRenderer;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.BuildTextOutputPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.BuildTextTokenPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.StoplistDialog;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingDialog;
import oracle.dmt.dataminer.workflow.dialog.buildText.TransformWizard;
import oracle.dmt.dataminer.workflow.inspect.AttributeTypeComparator;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.buildText.BuildTextNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.buildText.BuildTextPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.buildText.WorkflowBuildTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Element;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class BuildTextPanel
extends AbstractDialogPanel
implements SearchListener {
    private JEWTDialog _parentDlg;
    private WorkflowBuildTextNodePropertyProxyModel _propertyModel;
    private TextNodeType _textNodeType;
    private AttributeType _caseAttribute;
    private TextTransformationOutputAttributeType _selectedTextTransformationOutputAttribute = null;
    private List<TransformationSourceAttribute> _combinedAttrList = new ArrayList<TransformationSourceAttribute>();
    private AttrsTableModel _models;
    private GenericTable _attributeTable = new GenericTable();
    private SearchField _searchField;
    private String _searchText;
    private transient SearchCategory _searchCategory;
    private transient RowFilter<AttrsTableModel, Integer> _nodeFilter;
    private boolean _bShowAllRows;
    private boolean _isAdjusting;
    private boolean _dirty;
    private JButton _removeBtn;
    private JButton _editBtn;
    private JButton _addBtn;
    private JButton _outputTrueBtn;
    private JButton _outputFalseBtn;
    private static Icon _valid_attribue_icon;
    private static Icon _invalid_attribue_icon;
    private static Icon _removeIcon;
    private static Icon _editIcon;
    private static Icon _addIcon;
    private static Icon _outputTrueIcon;
    private static Icon _outputFalseIcon;
    private AttributeItem SELECT_CASEID_NONE;
    private BuildTextTokenPanel _tokensPanel;
    private BuildTextOutputPanel _outputPanel;
    private static String TOKENS_TAB;
    private static String THEMES_TAB;
    private static String OUTPUT_TAB;
    private String[] _columnNames = new String[]{DialogsLrb.get("BUILDTEXT_COLUMN_ATTRIBUTE"), DialogsLrb.get("BUILDTEXT_COLUMN_DATA_TYPE"), DialogsLrb.get("BUILDTEXT_COLUMN_SOURCE"), DialogsLrb.get("BUILDTEXT_COLUMN_TRANSFORM"), DialogsLrb.get("BUILDTEXT_COLUMN_OUTPUT")};
    private int[] _columnWidths = new int[]{220, 140, 220, 83, 60};
    private int[] _columnWidthsForPI = new int[]{170, 140, 160, 65, 50};
    private static final int ATTRIBUTE = 0;
    private static final int DATA_TYPE = 1;
    private static final int SOURCE = 2;
    private static final int TRANSFORM = 3;
    private static final int OUTPUT = 4;
    private static final int COLUMN_COUNT = 5;
    private static final int ATTR_STATUS = 99;
    private ComponentWithTitlebar columnComponentWithTitlebar;
    private JPanel jBottomPanel;
    private JComboBox jCaseIdComboBox;
    private JLabel jCaseIdLabel;
    private JButton jEditStoplistsButton;
    private JSplitPane jSplitPane;
    private JTabbedPane jTabbedPane;
    private JPanel jTopPanel;
    private JComboBox jColumnTypeComboBox;

    public BuildTextPanel(JEWTDialog jEWTDialog, Context context, BuildTextNode buildTextNode) {
        super(context, buildTextNode);
        this._parentDlg = jEWTDialog;
        this.init((BuildTextNode)this._data, null);
    }

    public BuildTextPanel(PropertyModel propertyModel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for BuildText node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.setMinimumSize(new Dimension(200, 400));
        this.init((BuildTextNode)this._data, propertyModel);
    }

    private void init(BuildTextNode buildTextNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowBuildTextNodePropertyProxyModel)propertyModel;
        this._dirty = false;
        this.initSettings(buildTextNode);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("BUILDTEXT_CASEID"), this.jCaseIdLabel);
        hashMap.put(DialogsLrb.get("BUILDTEXT_EDIT_STOPLIST"), this.jEditStoplistsButton);
        UIResourceHelper.setComponentText(hashMap);
        if (_valid_attribue_icon == null) {
            Class<PIComponentPanel> clazz = PIComponentPanel.class;
            _valid_attribue_icon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_ATTRIBUTES_GROUP_VALID_ATTRIBUTE_ICON"));
            Class<WorkflowEditor> clazz2 = WorkflowEditor.class;
            _invalid_attribue_icon = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("USAGE_ATTRIBUTE_INVALID"));
            _removeIcon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_REMOVE_ICON"));
            _editIcon = InspectorArb.getIcon((int)24);
            _addIcon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_ATTRIBUTES_GROUP_VALUE_ADD_ICON"));
            _outputTrueIcon = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("FILTER_ATTR_OUTPUT_ICON"));
            _outputFalseIcon = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("FILTER_ATTR_IGNORE_ICON"));
        }
    }

    @Override
    public void initUI() {
        this._isAdjusting = true;
        HelpUtils.setHelpID((JComponent)this, (String)"buildtext");
        this.initCaseAttribute();
        this.buildAttrList();
        Collections.sort(this._combinedAttrList, new AttributeTypeComparator());
        this._models = new AttrsTableModel();
        JScrollPane jScrollPane = new JScrollPane((Component)this._attributeTable);
        this.columnComponentWithTitlebar.setComponent((JComponent)jScrollPane);
        ControlBar controlBar = new ControlBar();
        this.columnComponentWithTitlebar.setControlBar(controlBar);
        this.installItemFilterActions(controlBar);
        this._attributeTable.setModel((TableModel)((Object)this._models));
        this._attributeTable.setResizeColumnOnDoubleClick(true);
        this._attributeTable.getSelectionModel().setSelectionMode(2);
        this._attributeTable.setAutoResizeMode(0);
        this._attributeTable.setSelectionMode(2);
        this._attributeTable.setColumnSelectorAvailable(true);
        this._attributeTable.setShowToolTips(true);
        this._attributeTable.setUpdateSelectionOnSort(true);
        this._attributeTable.setRowSelectionAllowed(true);
        TableColumn tableColumn = this._attributeTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new NameCellRenderer());
        tableColumn = this._attributeTable.getColumnModel().getColumn(4);
        tableColumn.setCellEditor(new OutputCellEditor());
        tableColumn.setCellRenderer(new OutputCellRenderer());
        this._nodeFilter = new RowFilter<AttrsTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends AttrsTableModel, ? extends Integer> entry) {
                String string;
                String string2;
                boolean bl = false;
                boolean bl2 = true;
                boolean bl3 = BuildTextPanel.this._searchText != null && BuildTextPanel.this._searchCategory != null;
                Integer n = entry.getIdentifier();
                AttrsTableModel attrsTableModel = entry.getModel();
                if (!BuildTextPanel.this._bShowAllRows) {
                    bl2 = false;
                    string2 = (String)attrsTableModel.getValueAt(n, 1);
                    if (DatabaseMetadataUtils.isACharacterOracleDataType(string2)) {
                        bl2 = true;
                    }
                    if (!bl2 && (string = (String)attrsTableModel.getValueAt(n, 2)) != null) {
                        bl2 = true;
                    }
                }
                String string3 = string2 = BuildTextPanel.this._searchText != null ? BuildTextPanel.this._searchText.toLowerCase() : null;
                if (bl2 && bl3 && BuildTextPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("BUILDTEXT_COLUMN_ATTRIBUTE"))) {
                    string = (String)attrsTableModel.getValueAt(n, 0);
                    if (string.toLowerCase().startsWith(string2)) {
                        bl = true;
                    }
                } else if (bl2 && bl3 && BuildTextPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("BUILDTEXT_COLUMN_DATA_TYPE"))) {
                    string = (String)attrsTableModel.getValueAt(n, 1);
                    if (string.toLowerCase().startsWith(string2)) {
                        bl = true;
                    }
                } else if (bl2 && bl3 && BuildTextPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("BUILDTEXT_COLUMN_SOURCE"))) {
                    String string4 = string = (String)attrsTableModel.getValueAt(n, 2) != null ? ((String)attrsTableModel.getValueAt(n, 2)).toLowerCase() : "";
                    if (string.startsWith(string2)) {
                        bl = true;
                    }
                } else if (bl2 && bl3 && BuildTextPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("BUILDTEXT_COLUMN_TRANSFORM"))) {
                    string = (String)attrsTableModel.getValueAt(n, 3);
                    if (string.toLowerCase().startsWith(string2)) {
                        bl = true;
                    }
                } else if (bl2) {
                    bl = true;
                }
                return bl;
            }
        };
        this.configureSorting();
        int n = 0;
        int[] nArray = this.isPIMode() ? this._columnWidthsForPI : this._columnWidths;
        for (int n2 : nArray) {
            this._attributeTable.getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        this._attributeTable.getSelectionModel().addListSelectionListener(new SelectedItemSelectionHandler(this));
        if (this.isPIMode()) {
            this.jSplitPane.setRightComponent(null);
            this.jSplitPane.setDividerSize(0);
        } else {
            BuildTextNodeType buildTextNodeType = (BuildTextNodeType)this.getData().getData();
            this._outputPanel = new BuildTextOutputPanel(this._context, (AbstractTextNode)this._data, this._textNodeType);
            int n3 = 0;
            if (!buildTextNodeType.getTransformedAttributes().getMapTextTransformedSource().isEmpty()) {
                n3 = ((MapTextTransformedSourceType)buildTextNodeType.getTransformedAttributes().getMapTextTransformedSource().get(0)).getKey().getTransformationElement().getTheme() != null ? 1 : 0;
            }
            this.jTabbedPane.add(n3 != 0 ? THEMES_TAB : TOKENS_TAB, this._outputPanel);
            this._tokensPanel = new BuildTextTokenPanel(this._context, (AbstractTextNode)this._data);
            this.jTabbedPane.add(OUTPUT_TAB, this._tokensPanel);
        }
        this._isAdjusting = false;
        this.enableControls();
    }

    private void installItemFilterActions(ControlBar controlBar) {
        SearchCategory[] searchCategoryArray;
        this.jColumnTypeComboBox = new JComboBox();
        this.jColumnTypeComboBox.removeAllItems();
        this.jColumnTypeComboBox.addItem(DialogsLrb.get("BUILDTEXT_TABLE_ALL"));
        this.jColumnTypeComboBox.addItem(DialogsLrb.get("BUILDTEXT_TABLE_TEXT_AND_TRANSFORMED"));
        this.jColumnTypeComboBox.setSelectedItem(DialogsLrb.get("BUILDTEXT_TABLE_ALL"));
        this._bShowAllRows = true;
        this.jColumnTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)BuildTextPanel.this.jColumnTypeComboBox.getSelectedItem();
                BuildTextPanel.this._bShowAllRows = string.equals(DialogsLrb.get("BUILDTEXT_TABLE_ALL"));
                BuildTextPanel.this.configureSorting();
            }
        });
        controlBar.add((Component)this.jColumnTypeComboBox);
        this._editBtn = new JButton(_editIcon);
        this._editBtn.setToolTipText(DialogsLrb.get("BUILDTEXT_EDIT_TEXT_XFORM_TOOLTIP"));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildTextPanel.this.processAddOrEdit();
            }
        });
        controlBar.add((Component)this._editBtn);
        this._removeBtn = new JButton(_removeIcon);
        this._removeBtn.setToolTipText(DialogsLrb.get("BUILDTEXT_DELETE_TEXT_XFORM_TOOLTIP"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = BuildTextPanel.this._attributeTable.getSelectedRowsInModel();
                BuildTextPanel.this._models.removeSelectedRows(nArray);
                BuildTextPanel.this.resetNiceTableModel(BuildTextPanel.this._models);
                if (BuildTextPanel.this.isPIMode()) {
                    ArrayList<Property> arrayList = new ArrayList<Property>();
                    ComplexProperty complexProperty = new ComplexProperty("allXfomNodeColumns", AttributeTypeHelper.getAllColumns(BuildTextPanel.this._textNodeType.getTransformedAttributes(), BuildTextPanel.this._textNodeType.getTransformationSourceAttributes()));
                    BuildTextNodeType buildTextNodeType = (BuildTextNodeType)BuildTextPanel.this.getData().getData();
                    complexProperty.setOldData(AttributeTypeHelper.getAllColumns(buildTextNodeType.getTransformedAttributes(), buildTextNodeType.getTransformationSourceAttributes()));
                    arrayList.add(new Property(String.valueOf(BuildTextNodePropertyModel.RowIndex.ALL_TRANSFORMATION_NODE_COLUMNS), null, complexProperty, null, null));
                    BuildTextPanel.this._propertyModel.setValueAt(BuildTextPIPropertyLrb.get("PI_BUILDTEXT_NODE_REMOVE_COLUMNS"), BuildTextPanel.this.getData(), arrayList);
                }
            }
        });
        controlBar.add((Component)this._removeBtn);
        this._addBtn = new JButton(_addIcon);
        this._addBtn.setToolTipText(DialogsLrb.get("BUILDTEXT_ADD_TEXT_XFORM_TOOLTIP"));
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildTextPanel.this.processAddOrEdit();
            }
        });
        controlBar.add((Component)this._addBtn);
        this._outputTrueBtn = new JButton(_outputTrueIcon);
        this._outputTrueBtn.setToolTipText(DialogsLrb.get("BUILDTEXT_INCLUDE_COLUMN_TOOLTIP"));
        this._outputTrueBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildTextPanel.this.setOutputState(true);
            }
        });
        controlBar.add((Component)this._outputTrueBtn);
        this._outputFalseBtn = new JButton(_outputFalseIcon);
        this._outputFalseBtn.setToolTipText(DialogsLrb.get("BUILDTEXT_EXCLUDE_COLUMN_TOOLTIP"));
        this._outputFalseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildTextPanel.this.setOutputState(false);
            }
        });
        controlBar.add((Component)this._outputFalseBtn);
        this._searchField = new SearchField(SearchField.Style.FILTER);
        this._searchField.setPreferredSize(new Dimension(200, 10));
        for (SearchCategory searchCategory : searchCategoryArray = new SearchCategory[]{new SearchCategory(DialogsLrb.get("BUILDTEXT_COLUMN_ATTRIBUTE")), new SearchCategory(DialogsLrb.get("BUILDTEXT_COLUMN_DATA_TYPE")), new SearchCategory(DialogsLrb.get("BUILDTEXT_COLUMN_SOURCE")), new SearchCategory(DialogsLrb.get("BUILDTEXT_COLUMN_TRANSFORM"))}) {
            this._searchField.addCategory(searchCategory);
        }
        controlBar.add((Component)this._searchField);
        this._searchField.addSearchListener((SearchListener)this);
    }

    private void resetNiceTableModel(AttrsTableModel attrsTableModel) {
        attrsTableModel.fireTableDataChanged();
        this._attributeTable.clearSelection();
        this._attributeTable.updateUI();
        this.configureSorting();
    }

    public void configureSorting() {
        TableRowSorter<AttrsTableModel> tableRowSorter = (TableRowSorter<AttrsTableModel>)this._attributeTable.getRowSorter();
        if (tableRowSorter == null) {
            tableRowSorter = new TableRowSorter<AttrsTableModel>(this._models);
            ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
            arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            tableRowSorter.setSortKeys(arrayList);
            tableRowSorter.setSortsOnUpdates(true);
        }
        tableRowSorter.setRowFilter(this._nodeFilter);
        this._attributeTable.setRowSorter(tableRowSorter);
    }

    public void searchPerformed(SearchEvent searchEvent) {
        this._searchCategory = searchEvent.getSearchCategory();
        this._searchText = searchEvent.getSearchText();
        this.configureSorting();
        this._attributeTable.scrollToSelection();
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
        this._searchCategory = searchEvent.getSearchCategory();
        this._searchText = searchEvent.getSearchText();
        this.configureSorting();
        this._attributeTable.scrollToSelection();
    }

    private boolean isPIMode() {
        return this._propertyModel != null;
    }

    private void initSettings(BuildTextNode buildTextNode) {
        BuildTextNodeType buildTextNodeType = (BuildTextNodeType)buildTextNode.getData();
        this._textNodeType = (TextNodeType)MetaDataHelper.copyMetadataObject(buildTextNodeType);
        this._caseAttribute = !this._textNodeType.getCaseAttributes().getAttribute().isEmpty() ? (AttributeType)this._textNodeType.getCaseAttributes().getAttribute().get(0) : null;
    }

    private void buildAttrList() {
        List list;
        this._combinedAttrList.clear();
        List list2 = this._textNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType();
        if (list2 != null && !list2.isEmpty()) {
            this._combinedAttrList.addAll(list2);
        }
        if (this._textNodeType.getTransformedAttributes() != null && (list = this._textNodeType.getTransformedAttributes().getMapTextTransformedSource()) != null && !list.isEmpty()) {
            for (MapTextTransformedSourceType mapTextTransformedSourceType : list) {
                this._combinedAttrList.add((TransformationSourceAttribute)mapTextTransformedSourceType.getKey());
            }
        }
    }

    private void processAddOrEdit() {
        int[] nArray = this._attributeTable.getSelectedRowsInModel();
        if (nArray.length == 1) {
            BuildTextNode buildTextNode = (BuildTextNode)this.getData();
            TextTransColumnSettingDialog textTransColumnSettingDialog = new TextTransColumnSettingDialog();
            if (this.isPIMode()) {
                textTransColumnSettingDialog.invoke((PropertyModel)this._propertyModel, this._textNodeType.getTransformationSourceAttributes(), this._textNodeType.getTransformedAttributes(), this.getSelectedAttributes());
            } else if (textTransColumnSettingDialog.invoke(this.getContext(), buildTextNode, this._textNodeType, this._textNodeType.getTransformationSourceAttributes(), this._textNodeType.getTransformedAttributes(), this.getSelectedAttributes()) && textTransColumnSettingDialog.getPanel().isDirty()) {
                this.refreshUI();
                this._dirty = true;
            }
        } else {
            TransformWizard transformWizard = new TransformWizard();
            BuildTextNode buildTextNode = (BuildTextNode)this._data;
            if (transformWizard.runWizard(this, (PropertyModel)this._propertyModel, this._context, buildTextNode, this._textNodeType, this.getSelectedAttributes())) {
                this.refreshUI();
                this._dirty = true;
            }
        }
    }

    private void enableControls() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = this._attributeTable.getSelectedRowCount();
        AttributeItem attributeItem = (AttributeItem)this.jCaseIdComboBox.getSelectedItem();
        this.jCaseIdComboBox.setEnabled(this.isWritable());
        if (!attributeItem.equals(this.SELECT_CASEID_NONE) && !attributeItem.getAttribute().getStatus().equals((Object)AttributeStatus.VALID)) {
            this.jCaseIdLabel.setIcon(_invalid_attribue_icon);
        } else {
            this.jCaseIdLabel.setIcon(null);
        }
        bl2 = false;
        bl3 = false;
        bl = false;
        if (n > 0) {
            int[] nArray;
            bl2 = true;
            bl3 = true;
            bl = true;
            for (int n2 : nArray = this._attributeTable.getSelectedRowsInModel()) {
                TransformationSourceAttribute transformationSourceAttribute = this._models.getAttribute(n2);
                String string = transformationSourceAttribute.getDataType();
                if (transformationSourceAttribute.getStatus() != AttributeStatus.VALID || !(transformationSourceAttribute instanceof TextTransformationOutputAttributeType)) {
                    bl2 = false;
                }
                if (transformationSourceAttribute.getStatus() != AttributeStatus.VALID || !(transformationSourceAttribute instanceof TransformationSourceAttribute) || !DatabaseMetadataUtils.isACharacterOracleDataType(string)) {
                    bl3 = false;
                }
                if (transformationSourceAttribute.getStatus() == AttributeStatus.INVALID || transformationSourceAttribute instanceof TextTransformationOutputAttributeType) continue;
                bl = false;
            }
        }
        this._outputTrueBtn.setEnabled(this.isWritable());
        this._outputFalseBtn.setEnabled(this.isWritable());
        this.jEditStoplistsButton.setEnabled(this.isWritable());
        this.jCaseIdComboBox.setEnabled(this.isWritable());
        this.jColumnTypeComboBox.setEnabled(this.isWritable());
        this._removeBtn.setEnabled(this.isWritable() && bl);
        this._editBtn.setEnabled(this.isWritable() && bl2);
        this._addBtn.setEnabled(this.isWritable() && bl3);
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowBuildTextNodePropertyProxyModel workflowBuildTextNodePropertyProxyModel = (WorkflowBuildTextNodePropertyProxyModel)propertyModel;
        Context context = workflowBuildTextNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        BuildTextNode buildTextNode = (BuildTextNode)workflowNodeInspectorElement.getNode();
        if (buildTextNode == null) {
            return;
        }
        this._propertyModel = (WorkflowBuildTextNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = buildTextNode;
        this._dirty = false;
        this.initSettings(buildTextNode);
        this.refreshUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowBuildTextNodePropertyProxyModel)) {
            return null;
        }
        WorkflowBuildTextNodePropertyProxyModel workflowBuildTextNodePropertyProxyModel = (WorkflowBuildTextNodePropertyProxyModel)propertyModel;
        Context context = workflowBuildTextNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private BuildTextNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowBuildTextNodePropertyProxyModel)) {
            return null;
        }
        WorkflowBuildTextNodePropertyProxyModel workflowBuildTextNodePropertyProxyModel = (WorkflowBuildTextNodePropertyProxyModel)propertyModel;
        Context context = workflowBuildTextNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof BuildTextNodeType) {
            return (BuildTextNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void initCaseAttribute() {
        Object object;
        if (this.SELECT_CASEID_NONE == null) {
            object = new AttributeType();
            object.setName(DialogsLrb.get("BUILDTEXT_SELECT_CASEID_NONE"));
            object.setDataType("String");
            this.SELECT_CASEID_NONE = new AttributeItem((AttributeType)object);
        }
        object = (BuildTextNode)this.getData();
        List<AttributeType> list = ((BuildTextNode)object).getCaseAttributes();
        Collections.sort(list, new AttributeTypeComparator());
        this.jCaseIdComboBox.removeAllItems();
        this.jCaseIdComboBox.addItem(this.SELECT_CASEID_NONE);
        for (AttributeType attributeType : list) {
            this.jCaseIdComboBox.addItem(new AttributeItem(attributeType));
        }
        this.jCaseIdComboBox.setSelectedItem(this.SELECT_CASEID_NONE);
        if (this._caseAttribute != null) {
            boolean bl = false;
            for (int i = 0; i < this.jCaseIdComboBox.getItemCount(); ++i) {
                AttributeItem attributeItem = (AttributeItem)this.jCaseIdComboBox.getItemAt(i);
                if (!this._caseAttribute.getName().equals(attributeItem.getAttribute().getName())) continue;
                this.jCaseIdComboBox.setSelectedItem(attributeItem);
                bl = true;
                break;
            }
            if (!bl) {
                AttributeItem attributeItem = new AttributeItem(this._caseAttribute);
                this.jCaseIdComboBox.addItem(attributeItem);
                this.jCaseIdComboBox.setSelectedItem(attributeItem);
            }
        }
    }

    public void refreshUI() {
        this._isAdjusting = true;
        this.initCaseAttribute();
        this.buildAttrList();
        Collections.sort(this._combinedAttrList, new AttributeTypeComparator());
        this._models = new AttrsTableModel();
        this._attributeTable.clearSelection();
        this.configureSorting();
        this._isAdjusting = false;
        this.enableControls();
    }

    public boolean doWork() {
        boolean bl = true;
        if (!this.isPIMode()) {
            if (this._dirty) {
                this.updateNode();
            } else if (this._outputPanel != null && this._outputPanel.isDirty()) {
                this.updateNode();
            }
        }
        return bl;
    }

    private void setOutputState(boolean bl) {
        int[] nArray = this._attributeTable.getSelectedRowsInModel();
        if (nArray != null && nArray.length > 0) {
            Object object;
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
            boolean bl2 = true;
            for (int i = 0; i < nArray.length; ++i) {
                object = this._models.getAttribute(nArray[i]);
                if (bl2 && object.isIsOutput() != bl) {
                    bl2 = false;
                }
                if (bl2) continue;
                if (this.isPIMode()) {
                    hashMap.put(object.getName(), object.isIsOutput());
                    hashMap2.put(object.getName(), bl);
                    continue;
                }
                object.setIsOutput(bl);
                this._dirty = true;
            }
            if (bl2) {
                return;
            }
            if (this.isPIMode()) {
                ComplexProperty complexProperty = new ComplexProperty("outputState", hashMap2);
                complexProperty.setOldData(hashMap);
                object = new ArrayList();
                object.add(new Property(String.valueOf(BuildTextNodePropertyModel.RowIndex.OUTPUT_STATE), null, complexProperty, null, null));
                this._propertyModel.setValueAt(BuildTextPIPropertyLrb.get("PI_BUILDTEXT_NODE_OUTPUT_TRANSFORMATION_ELEMENT"), this.getData(), (List<Property>)object);
            } else {
                this._models.fireTableDataChanged();
            }
            this._attributeTable.setSelectedRowsInModel(nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNode() {
        BuildTextNode buildTextNode = (BuildTextNode)this.getData();
        CommandProcessor.getInstance().beginTrans(DialogsLrb.get("BUILDTEXT_NODE_EDIT_TRANSACTION_NAME"));
        try {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            CaseAttributes caseAttributes = new CaseAttributes();
            if (this._caseAttribute != null) {
                caseAttributes.getAttribute().add(this._caseAttribute);
            }
            arrayList.add(new Property("caseAttribute", null, caseAttributes, null, null));
            arrayList.add(new Property("editStoplists", null, this._textNodeType.getStoplists(), null, null));
            arrayList.add(new Property("allXfomNodeColumns", null, AttributeTypeHelper.getAllColumns(this._textNodeType.getTransformedAttributes(), this._textNodeType.getTransformationSourceAttributes()), null, null));
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)buildTextNode.getUndoFilter();
            odmrSDMUndoFilter.prepareUndoPropertyList(buildTextNode, this._context, arrayList);
            buildTextNode.validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("BUILDTEXT_NODE_EDIT_ERROR_MESG"), null);
            CommandProcessor.getInstance().abortTrans();
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jTopPanel = new JPanel();
        this.jCaseIdLabel = new JLabel();
        this.jCaseIdComboBox = new JComboBox();
        this.jEditStoplistsButton = new JButton();
        this.columnComponentWithTitlebar = new ComponentWithTitlebar();
        this.jBottomPanel = new JPanel();
        this.jTabbedPane = new JTabbedPane();
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(642, 550));
        this.jSplitPane.setBorder(null);
        this.jSplitPane.setDividerLocation(240);
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setResizeWeight(0.5);
        this.jSplitPane.setOneTouchExpandable(true);
        this.jSplitPane.setOpaque(false);
        this.jTopPanel.setOpaque(false);
        this.jCaseIdLabel.setText("CaseId:");
        this.jCaseIdComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"012345678901234567890123456789", "Item 2", "Item 3", "Item 4"}));
        this.jCaseIdComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildTextPanel.this.jCaseIdComboBoxActionPerformed(actionEvent);
            }
        });
        this.jEditStoplistsButton.setText("Edit Stoplist...");
        this.jEditStoplistsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildTextPanel.this.jEditStoplistsButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jTopPanel);
        this.jTopPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.columnComponentWithTitlebar, GroupLayout.Alignment.LEADING, -1, 622, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCaseIdLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCaseIdComboBox, -2, 222, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 257, Short.MAX_VALUE).addComponent(this.jEditStoplistsButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCaseIdLabel).addComponent(this.jCaseIdComboBox, -2, -1, -2).addComponent(this.jEditStoplistsButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.columnComponentWithTitlebar, -1, 189, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane.setTopComponent(this.jTopPanel);
        this.jBottomPanel.setOpaque(false);
        GroupLayout groupLayout2 = new GroupLayout(this.jBottomPanel);
        this.jBottomPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 622, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 283, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane.setRightComponent(this.jBottomPanel);
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, -1, 642, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, -1, 550, Short.MAX_VALUE));
    }

    private void jCaseIdComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._isAdjusting) {
            return;
        }
        AttributeType attributeType = this._caseAttribute;
        AttributeItem attributeItem = (AttributeItem)this.jCaseIdComboBox.getSelectedItem();
        this._caseAttribute = attributeItem.equals(this.SELECT_CASEID_NONE) ? null : attributeItem.getAttribute();
        if (attributeType != null || this._caseAttribute != null) {
            if (attributeType == null && this._caseAttribute != null) {
                this._dirty = true;
            } else if (attributeType != null && this._caseAttribute == null) {
                this._dirty = true;
            } else if (!attributeType.getName().equals(this._caseAttribute.getName())) {
                this._dirty = true;
            }
        }
        if (this.isPIMode() && this._dirty) {
            CaseAttributes caseAttributes = new CaseAttributes();
            if (this._caseAttribute != null) {
                caseAttributes.getAttribute().add(this._caseAttribute);
            }
            CaseAttributes caseAttributes2 = new CaseAttributes();
            if (attributeType != null) {
                caseAttributes2.getAttribute().add(attributeType);
            }
            ComplexProperty complexProperty = new ComplexProperty("caseAttribute", caseAttributes);
            complexProperty.setOldData(caseAttributes2);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(BuildTextNodePropertyModel.RowIndex.CASE_ATTRIBUTES), null, complexProperty, null, null));
            this._propertyModel.setValueAt(BuildTextPIPropertyLrb.get("PI_BUILDTEXT_NODE_EDIT_CASEID"), this.getData(), arrayList);
        }
    }

    private void jEditStoplistsButtonActionPerformed(ActionEvent actionEvent) {
        AbstractTextNode abstractTextNode = (AbstractTextNode)this.getData();
        StoplistDialog stoplistDialog = new StoplistDialog();
        if (this.isPIMode()) {
            stoplistDialog.invoke((PropertyModel)this._propertyModel, this);
        } else if (stoplistDialog.invoke(this.getContext(), abstractTextNode, this._textNodeType, this) && stoplistDialog.isDirty()) {
            this.refreshUI();
            this._dirty = true;
        }
    }

    private List<TransformationSourceAttribute> getSelectedAttributes() {
        int[] nArray = this._attributeTable.getSelectedRowsInModel();
        ArrayList<TransformationSourceAttribute> arrayList = new ArrayList<TransformationSourceAttribute>();
        for (int i = 0; i < nArray.length; ++i) {
            TransformationSourceAttribute transformationSourceAttribute = this._models.getAttribute(nArray[i]);
            arrayList.add(transformationSourceAttribute);
        }
        return arrayList;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public TextTransformationOutputAttributeType getSelectedTextTransformationOutputAttribute() {
        return this._selectedTextTransformationOutputAttribute;
    }

    static {
        TOKENS_TAB = DialogsLrb.get("BUILDTEXT_TOKENS_TAB");
        THEMES_TAB = DialogsLrb.get("BUILDTEXT_THEMES_TAB");
        OUTPUT_TAB = DialogsLrb.get("BUILDTEXT_OUTPUT_TAB");
    }

    private class AttributeItem {
        AttributeType _attribute;

        public AttributeItem(AttributeType attributeType) {
            this._attribute = attributeType;
        }

        public String toString() {
            return this._attribute.getAlias() == null ? this._attribute.getName() : this._attribute.getAlias();
        }

        public boolean equals(AttributeItem attributeItem) {
            return this._attribute.getName().equals(attributeItem.getAttribute().getName()) && this._attribute.getDataType().equals(attributeItem.getAttribute().getDataType());
        }

        public AttributeType getAttribute() {
            return this._attribute;
        }
    }

    private class NameCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = BuildTextPanel.this._attributeTable.convertRowIndexToModel(n);
            GenericBaseTableModel genericBaseTableModel = (GenericBaseTableModel)BuildTextPanel.this._attributeTable.getModel();
            AttributeStatus attributeStatus = AttributeStatus.VALID;
            if (genericBaseTableModel instanceof AttrsTableModel && (object2 = genericBaseTableModel.getValueAt(n3, 99)) instanceof AttributeStatus) {
                attributeStatus = (AttributeStatus)object2;
            }
            if (attributeStatus.equals((Object)AttributeStatus.VALID)) {
                this.setIcon(_valid_attribue_icon);
            } else {
                this.setIcon(_invalid_attribue_icon);
            }
            return component;
        }
    }

    private class AttrsTableModel
    extends GenericBaseTableModel {
        public AttrsTableModel() {
            this.setColumnIdentifiers(BuildTextPanel.this._columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(5);
        }

        public int getRowCount() {
            return BuildTextPanel.this._combinedAttrList.size();
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                if (n == 4) {
                    return ImageIcon.class;
                }
                return object.getClass();
            }
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 4) {
                return BuildTextPanel.this.isWritable();
            }
            return false;
        }

        public Object getValueAt(int n, int n2) {
            if (BuildTextPanel.this._combinedAttrList.size() == 0) {
                return "Loading...";
            }
            TransformationSourceAttribute transformationSourceAttribute = (TransformationSourceAttribute)BuildTextPanel.this._combinedAttrList.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = transformationSourceAttribute.getName();
                    break;
                }
                case 1: {
                    object = transformationSourceAttribute.getDataType();
                    break;
                }
                case 2: {
                    String string = null;
                    if (transformationSourceAttribute instanceof TextTransformationOutputAttributeType) {
                        TextTransformationOutputAttributeType textTransformationOutputAttributeType = (TextTransformationOutputAttributeType)transformationSourceAttribute;
                        string = textTransformationOutputAttributeType.getSource();
                    }
                    object = string;
                    break;
                }
                case 3: {
                    String string = null;
                    if (transformationSourceAttribute instanceof TextTransformationOutputAttributeType) {
                        TextTransformationOutputAttributeType textTransformationOutputAttributeType = (TextTransformationOutputAttributeType)transformationSourceAttribute;
                        string = textTransformationOutputAttributeType.getTransformationElement().getToken() != null ? DialogsLrb.get("BUILDTEXT_TRANSFORM_TYPE_TOKEN") : DialogsLrb.get("BUILDTEXT_TRANSFORM_TYPE_THEME");
                    }
                    object = string;
                    break;
                }
                case 4: {
                    object = transformationSourceAttribute.isIsOutput();
                    break;
                }
                case 99: {
                    object = transformationSourceAttribute.getStatus();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public void setValueAt(Object object, int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            TransformationSourceAttribute transformationSourceAttribute = (TransformationSourceAttribute)BuildTextPanel.this._combinedAttrList.get(n);
            switch (n2) {
                case 4: {
                    BuildTextPanel.this._dirty = true;
                    if (BuildTextPanel.this.isPIMode()) {
                        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                        hashMap.put(transformationSourceAttribute.getName(), transformationSourceAttribute.isIsOutput());
                        ArrayList<Property> arrayList = new ArrayList<Property>();
                        HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
                        hashMap2.put(transformationSourceAttribute.getName(), (Boolean)object);
                        ComplexProperty complexProperty = new ComplexProperty("outputState", hashMap2);
                        complexProperty.setOldData(hashMap);
                        arrayList.add(new Property(String.valueOf(BuildTextNodePropertyModel.RowIndex.OUTPUT_STATE), null, complexProperty, null, null));
                        BuildTextPanel.this._propertyModel.setValueAt(BuildTextPIPropertyLrb.get("PI_BUILDTEXT_NODE_OUTPUT_TRANSFORMATION_ELEMENT"), BuildTextPanel.this.getData(), arrayList);
                        break;
                    }
                    transformationSourceAttribute.setIsOutput(((Boolean)object).booleanValue());
                }
            }
        }

        public void removeSelectedRows(int[] nArray) {
            Vector<Object> vector = new Vector<Object>();
            Vector<MapTextTransformedSourceType> vector2 = new Vector<MapTextTransformedSourceType>();
            Vector<TransformationSourceAttribute> vector3 = new Vector<TransformationSourceAttribute>();
            for (int i = 0; i < nArray.length; ++i) {
                TransformationSourceAttribute transformationSourceAttribute = this.getAttribute(nArray[i]);
                vector.add(transformationSourceAttribute);
                if (transformationSourceAttribute instanceof TextTransformationOutputAttributeType) {
                    for (MapTextTransformedSourceType mapTextTransformedSourceType : BuildTextPanel.this._textNodeType.getTransformedAttributes().getMapTextTransformedSource()) {
                        if (!mapTextTransformedSourceType.getKey().getName().equals(transformationSourceAttribute.getName())) continue;
                        vector2.add(mapTextTransformedSourceType);
                    }
                    continue;
                }
                vector3.add(transformationSourceAttribute);
                for (MapTextTransformedSourceType mapTextTransformedSourceType : BuildTextPanel.this._textNodeType.getTransformedAttributes().getMapTextTransformedSource()) {
                    if (!mapTextTransformedSourceType.getKey().getSource().equals(transformationSourceAttribute.getName())) continue;
                    vector2.add(mapTextTransformedSourceType);
                    vector.add(mapTextTransformedSourceType.getKey());
                }
            }
            BuildTextPanel.this._combinedAttrList.removeAll(vector);
            BuildTextPanel.this._textNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType().removeAll(vector3);
            BuildTextPanel.this._textNodeType.getTransformedAttributes().getMapTextTransformedSource().removeAll(vector2);
            this.setRowCount(BuildTextPanel.this._combinedAttrList.size());
            BuildTextPanel.this._dirty = true;
        }

        public TransformationSourceAttribute getAttribute(int n) {
            return (TransformationSourceAttribute)BuildTextPanel.this._combinedAttrList.get(n);
        }
    }

    private class SelectedItemSelectionHandler
    implements ListSelectionListener {
        AbstractDialogPanel _parent;

        public SelectedItemSelectionHandler(AbstractDialogPanel abstractDialogPanel) {
            this._parent = abstractDialogPanel;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            TransformationSourceAttribute transformationSourceAttribute;
            DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
            if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                return;
            }
            BuildTextPanel.this.enableControls();
            int[] nArray = BuildTextPanel.this._attributeTable.getSelectedRowsInModel();
            TextTransformationOutputAttributeType textTransformationOutputAttributeType = null;
            if (nArray.length == 1 && (transformationSourceAttribute = BuildTextPanel.this._models.getAttribute(nArray[0])) instanceof TextTransformationOutputAttributeType) {
                textTransformationOutputAttributeType = (TextTransformationOutputAttributeType)transformationSourceAttribute;
            }
            if (BuildTextPanel.this._selectedTextTransformationOutputAttribute != null && textTransformationOutputAttributeType != null && textTransformationOutputAttributeType.getName().compareTo(BuildTextPanel.this._selectedTextTransformationOutputAttribute.getName()) == 0) {
                return;
            }
            BuildTextPanel.this._selectedTextTransformationOutputAttribute = textTransformationOutputAttributeType;
            if (BuildTextPanel.this._outputPanel != null) {
                boolean bl = false;
                if (textTransformationOutputAttributeType != null) {
                    bl = textTransformationOutputAttributeType.getTransformationElement().getTheme() != null;
                }
                BuildTextPanel.this.jTabbedPane.setTitleAt(0, bl ? THEMES_TAB : TOKENS_TAB);
                BuildTextPanel.this._outputPanel.refreshUI(this._parent, textTransformationOutputAttributeType);
            }
            if (BuildTextPanel.this._tokensPanel != null) {
                BuildTextPanel.this._tokensPanel.refreshUI(this._parent, textTransformationOutputAttributeType);
            }
        }
    }
}

