/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.javatools.dialogs.MessageDialog;

public class AddStopwordsPanel
extends AbstractDialogPanel {
    private JPanel _parent;
    private StoplistType _stoplist;
    private boolean _dirty;
    private boolean _isAdjusting;
    private JScrollPane jDescScrollPane;
    private JComboBox jLanguageComboBox;
    private JLabel jLanguageLabel;
    private JScrollPane jStopwordScrollPane;
    private JTextArea jStopwordTextArea;

    public AddStopwordsPanel(Context context, BuildTextNode buildTextNode, JPanel jPanel, StoplistType stoplistType) {
        super(context, buildTextNode);
        assert (context != null) : "Context must not be null.";
        this.init(buildTextNode, jPanel, stoplistType);
    }

    private void init(BuildTextNode buildTextNode, JPanel jPanel, StoplistType stoplistType) {
        this._parent = jPanel;
        this._dirty = false;
        this._stoplist = (StoplistType)MetaDataHelper.copyMetadataObject(stoplistType);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("ADD_STOPWORD_LANGUAGE"), this.jLanguageLabel);
        UIResourceHelper.setComponentText(hashMap);
    }

    @Override
    public void initUI() {
        this._isAdjusting = true;
        HelpUtils.setHelpID((JComponent)this, (String)"stopword");
        JMultiLineLabel jMultiLineLabel = new JMultiLineLabel();
        jMultiLineLabel.setText(DialogsLrb.get("ADD_STOPWORD_DESC"));
        this.jDescScrollPane.getViewport().add((Component)jMultiLineLabel);
        this.jLanguageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ServerConstants.StoplistLanguage.toHuman("All"), ServerConstants.StoplistLanguage.toHuman("SIMPLIFIED CHINESE"), ServerConstants.StoplistLanguage.toHuman("TRADITIONAL CHINESE"), ServerConstants.StoplistLanguage.toHuman("DANISH"), ServerConstants.StoplistLanguage.toHuman("DUTCH"), ServerConstants.StoplistLanguage.toHuman("ENGLISH"), ServerConstants.StoplistLanguage.toHuman("FINNISH"), ServerConstants.StoplistLanguage.toHuman("FRENCH"), ServerConstants.StoplistLanguage.toHuman("GERMAN"), ServerConstants.StoplistLanguage.toHuman("ITALIAN"), ServerConstants.StoplistLanguage.toHuman("PORTUGUESE"), ServerConstants.StoplistLanguage.toHuman("SPANISH"), ServerConstants.StoplistLanguage.toHuman("SWEDISH")}));
        String string = null;
        if (this._stoplist.getType().equals("Basic")) {
            string = this._stoplist.getLanguage();
            this.jLanguageComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman(string));
            this.jLanguageComboBox.setEnabled(false);
        } else {
            string = "All";
            this.jLanguageComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman(string));
            this.jLanguageComboBox.setEnabled(true);
        }
        this._isAdjusting = false;
        this.enableControls();
    }

    private void enableControls() {
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public boolean doWork() {
        Object object;
        Object object2;
        Object object32;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        TreeMap<Object, Boolean> treeMap = new TreeMap<Object, Boolean>();
        for (Object object32 : this._stoplist.getStopTokens().getToken()) {
            object2 = object32.getItem();
            object = object32.getLanguage();
            object2 = (String)object + ":" + (String)object2;
            treeMap.put(object2, true);
        }
        Object object4 = (String)this.jLanguageComboBox.getSelectedItem();
        object4 = ServerConstants.StoplistLanguage.toSchema((String)object4);
        object32 = this.jStopwordTextArea.getText();
        object2 = new WStringTokenizer((String)object32, ",");
        while (((WStringTokenizer)object2).hasMoreTokens()) {
            object = ((WStringTokenizer)object2).nextToken();
            if (((String)(object = ((String)object).trim())).length() == 0) {
                bl3 = true;
                continue;
            }
            object = (String)object4 + ":" + (String)object;
            if (treeMap.containsKey(object)) {
                bl2 = true;
                continue;
            }
            treeMap.put(object, true);
            this._dirty = true;
        }
        this._stoplist.getStopTokens().getToken().clear();
        for (String string : treeMap.keySet()) {
            int n = string.indexOf(":");
            object4 = string.substring(0, n);
            String string2 = string.substring(n + 1);
            StoplistType.StopTokens.Token token = new StoplistType.StopTokens.Token();
            token.setItem(string2);
            token.setLanguage((String)object4);
            token.setType(string2.indexOf(32) == -1 ? "Word" : "Theme");
            this._stoplist.getStopTokens().getToken().add(token);
        }
        if (bl2) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("ADD_STOPWORD_DUPLICATED_REMOVED"), (String)DialogsLrb.get("WARNING_TITLE"), null);
        }
        if (bl3) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("ADD_STOPWORD_EMPTY_REMOVED"), (String)DialogsLrb.get("WARNING_TITLE"), null);
        }
        return bl;
    }

    private void initComponents() {
        this.jDescScrollPane = new JScrollPane();
        this.jLanguageLabel = new JLabel();
        this.jLanguageComboBox = new JComboBox();
        this.jStopwordScrollPane = new JScrollPane();
        this.jStopwordTextArea = new JTextArea();
        this.setPreferredSize(new Dimension(500, 341));
        this.jDescScrollPane.setBorder(null);
        this.jDescScrollPane.setOpaque(false);
        this.jLanguageLabel.setLabelFor(this.jLanguageComboBox);
        this.jLanguageLabel.setText("Language:");
        this.jLanguageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Traditional Chinese"}));
        this.jStopwordTextArea.setColumns(20);
        this.jStopwordTextArea.setRows(5);
        this.jStopwordScrollPane.setViewportView(this.jStopwordTextArea);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jDescScrollPane, GroupLayout.Alignment.TRAILING, -1, 480, Short.MAX_VALUE).addComponent(this.jStopwordScrollPane, -1, 480, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLanguageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLanguageComboBox, -2, 124, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jDescScrollPane, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLanguageLabel).addComponent(this.jLanguageComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jStopwordScrollPane, -1, 215, Short.MAX_VALUE).addContainerGap()));
    }

    public StoplistType getStoplist() {
        return this._stoplist;
    }

    public class WStringTokenizer
    extends StringTokenizer {
        private String tbt;
        private String d;
        private int startpos;

        public WStringTokenizer(String string, String string2) {
            super(string, string2);
            this.startpos = 0;
            this.tbt = new String(string);
            this.d = new String(string2);
        }

        @Override
        public int countTokens() {
            int n = 0;
            int n2 = this.startpos;
            try {
                while (true) {
                    this.nextToken();
                    ++n;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.startpos = n2;
                return n;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasMoreTokens();
        }

        @Override
        public boolean hasMoreTokens() {
            return this.countTokens() > 0;
        }

        @Override
        public Object nextElement() {
            return this.d;
        }

        @Override
        public String nextToken() throws NoSuchElementException {
            int n = 0;
            if (this.startpos > this.tbt.length()) {
                throw new NoSuchElementException();
            }
            n = this.tbt.indexOf(this.d, this.startpos);
            if (n < 0) {
                n = this.tbt.length();
            }
            String string = new String(this.tbt.substring(this.startpos, n));
            this.startpos = n + this.d.length();
            return string;
        }

        @Override
        public String nextToken(String string) throws NoSuchElementException {
            this.d = string;
            return this.nextToken();
        }
    }
}

