/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.GLMTargetValuesPanel;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.dialogs.ExceptionDialog;

public class ModelGLMBuildSettingsPanel
extends AbstractPropertiesPanel {
    private ButtonGroup buttonGroup1;
    private JButton jBtnEdit;
    private JCheckBox jChkDiagnosticTable;
    private JCheckBox jChkEnableRidgeRegr;
    private JCheckBox jChkProduceVIF;
    private JCheckBox jChkRowWeights;
    private JComboBox jCmbMissValueTreatment;
    private JComboBox jCmbRowWeights;
    private JLabel jLabel1;
    private JLabel jLabelRidgeValue;
    private JLabel jLblConfLevel;
    private JLabel jLblMissigValueTreat;
    private JLabel jLblRefClassName;
    private JRadioButton jRadioButtonSystem;
    private JRadioButton jRadioButtonUser;
    private JScrollPane jScrollPaneTitle;
    private JTextField jTxtConfidenceLevel;
    private JTextField jTxtRidgeValue;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();
    private static String _empty = AlgSettingsLrb.get("GLM_ROW_WEIGHT_COLUMN_NAME_EMPTY");
    private static String _meanMode = DialogsLrb.get("GLM_MISSING_VALUES_COLUMN_MEAN_MODE");
    private static String _deleteRow = DialogsLrb.get("GLM_MISSING_VALUES_COLUMN_DELETE_ROW");
    private static HashMap<String, String> _missingValTreatmentDef = new HashMap();
    private static HashMap<String, String> _missingValTreatmentHumanReadeable = new HashMap();
    private String _generatedRowDiagnosticTableName = null;

    public ModelGLMBuildSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLblConfLevel = new JLabel();
        this.jTxtConfidenceLevel = new NumberTextField();
        this.jLblRefClassName = new JLabel();
        this.jChkEnableRidgeRegr = new JCheckBox();
        this.jLabelRidgeValue = new JLabel();
        this.jTxtRidgeValue = new NumberTextField();
        this.jChkProduceVIF = new JCheckBox();
        this.jScrollPaneTitle = new JScrollPane();
        this.jBtnEdit = new JButton();
        this.jLabel1 = new JLabel();
        this.jLblMissigValueTreat = new JLabel();
        this.jCmbMissValueTreatment = new JComboBox();
        this.jCmbRowWeights = new JComboBox();
        this.jChkRowWeights = new JCheckBox();
        this.jChkDiagnosticTable = new JCheckBox();
        this.jRadioButtonSystem = new JRadioButton();
        this.jRadioButtonUser = new JRadioButton();
        this.jLblConfLevel.setText("Confidence Level:");
        this.jLblRefClassName.setText("Reference Class name:");
        this.jChkEnableRidgeRegr.setText("Enable Ridge Regression");
        this.jChkEnableRidgeRegr.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jChkEnableRidgeRegr.setMargin(new Insets(0, 0, 0, 0));
        this.jLabelRidgeValue.setText("Ridge Value:");
        this.jChkProduceVIF.setText("Produce Variance Inflation Factor");
        this.jChkProduceVIF.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jChkProduceVIF.setMargin(new Insets(0, 0, 0, 0));
        this.jScrollPaneTitle.setBorder(null);
        this.jScrollPaneTitle.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneTitle.setVerticalScrollBarPolicy(21);
        this.jBtnEdit.setText("Edit");
        this.jLabel1.setText("<System defined>");
        this.jLblMissigValueTreat.setText("Missing Value Treatment:");
        this.jCmbMissValueTreatment.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCmbRowWeights.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jChkRowWeights.setText("Specify Row Weight");
        this.jChkRowWeights.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jChkDiagnosticTable.setText("Row Diagnostics Table");
        this.jRadioButtonSystem.setText("Systen Determined");
        this.jRadioButtonUser.setText("User Specified");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneTitle, -1, 489, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonUser).addComponent(this.jRadioButtonSystem).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLabelRidgeValue, -2, 163, -2))).addGap(282, 282, 282)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLblConfLevel, GroupLayout.Alignment.LEADING, -1, 141, Short.MAX_VALUE).addComponent(this.jLblRefClassName, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGap(39, 39, 39).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTxtConfidenceLevel, -2, 129, -2).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(33, 33, 33).addComponent(this.jTxtRidgeValue, -2, 149, -2)).addComponent(this.jLabel1, -2, 198, -2)).addGap(18, 18, 18).addComponent(this.jBtnEdit))).addGap(40, 40, 40)).addComponent(this.jChkDiagnosticTable, -2, 272, -2).addComponent(this.jChkProduceVIF, -2, 273, -2).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jChkEnableRidgeRegr, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLblMissigValueTreat, -1, -1, Short.MAX_VALUE).addComponent(this.jChkRowWeights, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.jCmbRowWeights, -2, 209, -2))).addGap(16, 16, 16).addComponent(this.jCmbMissValueTreatment, -2, -1, -2))).addContainerGap()));
        groupLayout.linkSize(0, this.jLblConfLevel, this.jLblRefClassName);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jChkDiagnosticTable).addGap(9, 9, 9).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblConfLevel).addComponent(this.jTxtConfidenceLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblRefClassName).addComponent(this.jLabel1).addComponent(this.jBtnEdit)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblMissigValueTreat).addComponent(this.jCmbMissValueTreatment, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jChkRowWeights).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCmbRowWeights, -2, -1, -2).addGap(16, 16, 16).addComponent(this.jChkEnableRidgeRegr).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonSystem).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonUser).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelRidgeValue).addComponent(this.jTxtRidgeValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jChkProduceVIF).addContainerGap(14, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jChkDiagnosticTable, this.jChkRowWeights, this.jLblConfLevel, this.jLblMissigValueTreat, this.jLblRefClassName);
    }

    private void initUI() {
        Object object;
        Serializable serializable;
        final CommonSettingDataObject commonSettingDataObject = this.getState();
        this.loadDescription(this._jDescription, this.jScrollPaneTitle);
        this.jChkDiagnosticTable.setText(AlgSettingsLrb.get("GLM_DIAGNOSTIC_TABLE_NAME"));
        this.jLblConfLevel.setText(AlgSettingsLrb.get("GLM_CONFIDENCE_LEVEL"));
        this.jLabelRidgeValue.setText(AlgSettingsLrb.get("GLM_RIDGE_VALUE"));
        this.jChkEnableRidgeRegr.setText(AlgSettingsLrb.get("GLM_ENABLE_RIDGE_REGRESSION"));
        if (this.getModelType() instanceof RGeneralizedLinearModelType) {
            this.jChkProduceVIF.setText(AlgSettingsLrb.get("GLM_PRODUCE_VIF"));
            this.jLabel1.setVisible(false);
            this.jBtnEdit.setVisible(false);
            this.jLblRefClassName.setVisible(false);
        } else {
            this.jChkProduceVIF.setVisible(false);
            this.jLblRefClassName.setText(AlgSettingsLrb.get("GLM_REFERENCE_CLASS_NAME"));
            this.jBtnEdit.setText(AlgSettingsLrb.get("GLM_REFERENCE_CLASS_NAME_EDIT"));
            this.jBtnEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ReferenceClassDialog referenceClassDialog = new ReferenceClassDialog();
                    if (referenceClassDialog.invoke()) {
                        ModelGLMBuildSettingsPanel.this.jLabel1.setText(commonSettingDataObject.getCurClassRefValue());
                    }
                }
            });
        }
        this.jLblMissigValueTreat.setText(AlgSettingsLrb.get("GLM_MISSING_VALUES_COLUMN_LABEL"));
        this.jCmbMissValueTreatment.setModel(new DefaultComboBoxModel<String>(new String[]{_meanMode, _deleteRow}));
        String string = commonSettingDataObject.getModelSettingStringValue("ODMS_MISSING_VALUE_TREATMENT");
        this.jCmbMissValueTreatment.setSelectedItem(_missingValTreatmentHumanReadeable.get(string));
        commonSettingDataObject.setBackupValue("ODMS_MISSING_VALUE_TREATMENT", string);
        this.jLblMissigValueTreat.setLabelFor(this.jCmbMissValueTreatment);
        this.jCmbMissValueTreatment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.jChkRowWeights.setText(AlgSettingsLrb.get("GLM_ROW_WIGHTS_COLUMN_LABEL"));
        List<AttributeType> list = commonSettingDataObject.getAttributes();
        if (list != null && list.size() > 0) {
            boolean bl;
            serializable = new Vector<String>();
            for (int i = 0; i < list.size(); ++i) {
                AttributeType attributeType = list.get(i);
                try {
                    if (!DatabaseMetadataUtils.isNumericTypeSupported(this.getState().getContext(), attributeType.getDataType())) continue;
                    ((Vector)serializable).add(attributeType.getName());
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.jCmbRowWeights.setModel(new DefaultComboBoxModel(serializable));
            object = commonSettingDataObject.getModelSettingStringValue("ODMS_ROW_WEIGHT_COLUMN_NAME");
            boolean bl2 = bl = object == null || ((String)object).isEmpty() || CommonSettingDataObject.isValueNull(object);
            if (bl) {
                commonSettingDataObject.setBackupNullValue("ODMS_ROW_WEIGHT_COLUMN_NAME");
            } else {
                commonSettingDataObject.setBackupValue("ODMS_ROW_WEIGHT_COLUMN_NAME", object);
                this.jCmbRowWeights.setSelectedItem(object);
            }
            this.jCmbRowWeights.setEnabled(!bl);
            this.jChkRowWeights.setSelected(!bl);
            this.jChkRowWeights.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ModelGLMBuildSettingsPanel.this.jCmbRowWeights.setEnabled(ModelGLMBuildSettingsPanel.this.jChkRowWeights.isSelected());
                }
            });
        } else {
            this.jChkRowWeights.setEnabled(false);
            this.jCmbRowWeights.setModel(new DefaultComboBoxModel<String>(new String[]{_empty}));
            this.jCmbRowWeights.setEnabled(false);
            commonSettingDataObject.setBackupNullValue("ODMS_ROW_WEIGHT_COLUMN_NAME");
        }
        this.jLblConfLevel.setLabelFor(this.jTxtConfidenceLevel);
        this.jTxtConfidenceLevel.setToolTipText(AlgSettingsLrb.get("GLM_CONFIDENCE_LEVEL_TOOLTIP"));
        this.setDataType(this.jTxtConfidenceLevel, Double.class);
        this.setSigned(this.jTxtConfidenceLevel, true);
        this.setLocale(this.jTxtConfidenceLevel, Locale.getDefault());
        serializable = commonSettingDataObject.getModelSettingNumValue("GLMS_CONF_LEVEL");
        if (serializable == null) {
            serializable = new BigDecimal(0.95);
        }
        object = new Double(((BigDecimal)serializable).doubleValue());
        commonSettingDataObject.setBackupValue("GLMS_CONF_LEVEL", object);
        this.setNumber(this.jTxtConfidenceLevel, (Number)object);
        String string2 = commonSettingDataObject.getModelSettingStringValue("GLMS_DIAGNOSTICS_TABLE_NAME");
        if (CommonSettingDataObject.isValueNull(string2) || string2.length() == 0) {
            commonSettingDataObject.setBackupNullValue("GLMS_DIAGNOSTICS_TABLE_NAME");
            this.jChkDiagnosticTable.setSelected(false);
            this._generatedRowDiagnosticTableName = null;
        } else {
            this.jChkDiagnosticTable.setSelected(true);
            commonSettingDataObject.setBackupValue("GLMS_DIAGNOSTICS_TABLE_NAME", string2);
            this._generatedRowDiagnosticTableName = string2;
        }
        if (commonSettingDataObject.isCaseIdSelected()) {
            this.jChkDiagnosticTable.setEnabled(true);
        } else {
            this.jChkDiagnosticTable.setEnabled(false);
        }
        this.jChkDiagnosticTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ModelGLMBuildSettingsPanel.this.jChkDiagnosticTable.isSelected()) {
                    RowDiagnosticTableNameGen rowDiagnosticTableNameGen = new RowDiagnosticTableNameGen();
                    rowDiagnosticTableNameGen.setTitle(AlgSettingsLrb.get("GLMS_ROW_DIAGNOSTIC_TABLE_GEN_TITLE"));
                    rowDiagnosticTableNameGen.setMessage(AlgSettingsLrb.get("GLMS_ROW_DIAGNOSTIC_TABLE_GEN_DESC"));
                    rowDiagnosticTableNameGen.setCancelable(true);
                    try {
                        rowDiagnosticTableNameGen.start(true);
                        if (!rowDiagnosticTableNameGen.isCanceled()) {
                            ModelGLMBuildSettingsPanel.this._generatedRowDiagnosticTableName = rowDiagnosticTableNameGen.getTableName();
                        }
                    }
                    catch (ProgressException progressException) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)progressException, (String)AlgSettingsLrb.get("GLMS_ROW_DIAGNOSTIC_TABLE_UNEXPECTED_ERROR_TITLE"), (String)AlgSettingsLrb.get("GLMS_ROW_DIAGNOSTIC_TABLE_UNEXPECTED_ERROR_MSG"), null);
                    }
                } else {
                    ModelGLMBuildSettingsPanel.this._generatedRowDiagnosticTableName = null;
                }
            }
        });
        String string3 = commonSettingDataObject.getModelSettingStringValue("GLMS_REFERENCE_CLASS_NAME");
        if (string3 != null && !string3.isEmpty()) {
            commonSettingDataObject.setBackupValue("GLMS_REFERENCE_CLASS_NAME", string3);
            this.jLabel1.setText(string3);
        } else {
            commonSettingDataObject.setBackupNullValue("GLMS_REFERENCE_CLASS_NAME");
            this.jLabel1.setText(CommonSettingDataObject.SYSTEM_DETERMINED);
        }
        string2 = commonSettingDataObject.getModelSettingStringValue("GLMS_RIDGE_REGRESSION");
        commonSettingDataObject.setBackupValue("GLMS_RIDGE_REGRESSION", string2);
        this.jTxtRidgeValue.setToolTipText(AlgSettingsLrb.get("GLM_RIDGE_VALUE_TOOLTIP"));
        this.jLabelRidgeValue.setLabelFor(this.jTxtRidgeValue);
        this.setDataType(this.jTxtRidgeValue, Double.class);
        this.setSigned(this.jTxtRidgeValue, true);
        this.setLocale(this.jTxtRidgeValue, Locale.getDefault());
        boolean bl = string2.equals("GLMS_RIDGE_REG_ENABLE");
        this.jChkEnableRidgeRegr.setSelected(bl);
        this.jChkProduceVIF.setEnabled(bl);
        this.jChkEnableRidgeRegr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ModelGLMBuildSettingsPanel.this.jChkEnableRidgeRegr.isSelected()) {
                    ModelGLMBuildSettingsPanel.this.jRadioButtonUser.setEnabled(true);
                    ModelGLMBuildSettingsPanel.this.jRadioButtonSystem.setEnabled(true);
                    if (ModelGLMBuildSettingsPanel.this.jRadioButtonUser.isSelected()) {
                        ModelGLMBuildSettingsPanel.this.jTxtRidgeValue.setEnabled(true);
                        ModelGLMBuildSettingsPanel.this.jLabelRidgeValue.setEnabled(true);
                    } else {
                        ModelGLMBuildSettingsPanel.this.jTxtRidgeValue.setEnabled(false);
                        ModelGLMBuildSettingsPanel.this.jLabelRidgeValue.setEnabled(false);
                    }
                    ModelGLMBuildSettingsPanel.this.jChkProduceVIF.setEnabled(true);
                } else {
                    ModelGLMBuildSettingsPanel.this.jRadioButtonUser.setEnabled(false);
                    ModelGLMBuildSettingsPanel.this.jRadioButtonSystem.setEnabled(false);
                    ModelGLMBuildSettingsPanel.this.jTxtRidgeValue.setEnabled(false);
                    ModelGLMBuildSettingsPanel.this.jLabelRidgeValue.setEnabled(false);
                    ModelGLMBuildSettingsPanel.this.jChkProduceVIF.setEnabled(false);
                    ModelGLMBuildSettingsPanel.this.jChkProduceVIF.setSelected(false);
                }
            }
        });
        this.jRadioButtonSystem.setText(AlgSettingsLrb.get("GLM_RIDGE_VALUE_SYSTEM"));
        this.jRadioButtonUser.setText(AlgSettingsLrb.get("GLM_RIDGE_VALUE_USER"));
        this.buttonGroup1.add(this.jRadioButtonSystem);
        this.buttonGroup1.add(this.jRadioButtonUser);
        this.jRadioButtonSystem.setEnabled(bl);
        this.jRadioButtonUser.setEnabled(bl);
        this.jRadioButtonSystem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ModelGLMBuildSettingsPanel.this.jRadioButtonSystem.isSelected()) {
                    ModelGLMBuildSettingsPanel.this.jTxtRidgeValue.setEnabled(false);
                    ModelGLMBuildSettingsPanel.this.jLabelRidgeValue.setEnabled(false);
                } else {
                    ModelGLMBuildSettingsPanel.this.jTxtRidgeValue.setEnabled(true);
                    ModelGLMBuildSettingsPanel.this.jLabelRidgeValue.setEnabled(true);
                }
            }
        });
        this.jRadioButtonUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ModelGLMBuildSettingsPanel.this.jRadioButtonUser.isSelected()) {
                    ModelGLMBuildSettingsPanel.this.jTxtRidgeValue.setEnabled(true);
                    ModelGLMBuildSettingsPanel.this.jLabelRidgeValue.setEnabled(true);
                } else {
                    ModelGLMBuildSettingsPanel.this.jTxtRidgeValue.setEnabled(false);
                    ModelGLMBuildSettingsPanel.this.jLabelRidgeValue.setEnabled(false);
                }
            }
        });
        BigDecimal bigDecimal = null;
        bigDecimal = commonSettingDataObject.getModelSettingNumValue("GLMS_RIDGE_VALUE");
        if (bigDecimal != null) {
            this.setNumber(this.jTxtRidgeValue, bigDecimal);
            commonSettingDataObject.setBackupValue("GLMS_RIDGE_VALUE", bigDecimal);
            this.jRadioButtonUser.setSelected(true);
        } else {
            commonSettingDataObject.setBackupNullValue("GLMS_RIDGE_VALUE");
            this.jRadioButtonSystem.setSelected(true);
        }
        boolean bl3 = bigDecimal != null;
        this.jTxtRidgeValue.setEnabled(bl && bl3);
        this.jLabelRidgeValue.setEnabled(bl && bl3);
        string2 = commonSettingDataObject.getModelSettingStringValue("GLMS_VIF_FOR_RIDGE");
        commonSettingDataObject.setBackupValue("GLMS_VIF_FOR_RIDGE", string2);
        boolean bl4 = string2.equals("GLMS_VIF_RIDGE_ENABLE");
        this.jChkProduceVIF.setSelected(bl4);
    }

    @Override
    public void processInput() {
        CommonSettingDataObject commonSettingDataObject = this.getState();
        commonSettingDataObject.setCommonPerformanceOption();
        if (this.jChkDiagnosticTable.isSelected()) {
            commonSettingDataObject.setValue("GLMS_DIAGNOSTICS_TABLE_NAME", this._generatedRowDiagnosticTableName);
        } else {
            commonSettingDataObject.setNullValue("GLMS_DIAGNOSTICS_TABLE_NAME");
        }
        Number number = this.getNumber(this.jTxtConfidenceLevel);
        if (null == number || number.doubleValue() <= 0.0 || number.doubleValue() > 1.0) {
            commonSettingDataObject.setValidationError(AlgSettingsLrb.get("GLM_CONFIDENCE_LEVEL_INVALID"));
            return;
        }
        commonSettingDataObject.setValue("GLMS_CONF_LEVEL", number);
        String string = this.jLabel1.getText();
        if (string.equals(CommonSettingDataObject.SYSTEM_DETERMINED)) {
            commonSettingDataObject.setNullValue("GLMS_REFERENCE_CLASS_NAME");
        } else {
            commonSettingDataObject.setValue("GLMS_REFERENCE_CLASS_NAME", string);
        }
        boolean bl = this.jChkEnableRidgeRegr.isSelected();
        if (bl && this.jRadioButtonUser.isSelected()) {
            number = this.getNumber(this.jTxtRidgeValue);
            if (number == null || number.doubleValue() < 0.0) {
                commonSettingDataObject.setValidationError(AlgSettingsLrb.get("GLM_RIDGE_VALUE_INVALID"));
                return;
            }
            commonSettingDataObject.setValue("GLMS_RIDGE_VALUE", number);
            commonSettingDataObject.setValue("GLMS_RIDGE_REGRESSION", "GLMS_RIDGE_REG_ENABLE");
        } else if (bl && !this.jRadioButtonUser.isSelected()) {
            commonSettingDataObject.setNullValue("GLMS_RIDGE_REGRESSION");
            commonSettingDataObject.setNullValue("GLMS_RIDGE_VALUE");
        } else {
            commonSettingDataObject.setValue("GLMS_RIDGE_REGRESSION", "GLMS_RIDGE_REG_DISABLE");
            commonSettingDataObject.setNullValue("GLMS_RIDGE_VALUE");
        }
        String string2 = this.jChkProduceVIF.isSelected() ? "GLMS_VIF_RIDGE_ENABLE" : "GLMS_VIF_RIDGE_DISABLE";
        commonSettingDataObject.setValue("GLMS_VIF_FOR_RIDGE", string2);
        string2 = (String)this.jCmbMissValueTreatment.getSelectedItem();
        commonSettingDataObject.setValue("ODMS_MISSING_VALUE_TREATMENT", _missingValTreatmentDef.get(string2));
        if (this.jChkRowWeights.isSelected()) {
            string2 = (String)this.jCmbRowWeights.getSelectedItem();
            commonSettingDataObject.setValue("ODMS_ROW_WEIGHT_COLUMN_NAME", string2);
        } else {
            commonSettingDataObject.setNullValue("ODMS_ROW_WEIGHT_COLUMN_NAME");
        }
    }

    static {
        _missingValTreatmentDef.put(_meanMode, "ODMS_MISSING_VALUE_MEAN_MODE");
        _missingValTreatmentDef.put(_deleteRow, "ODMS_MISSING_VALUE_DELETE_ROW");
        _missingValTreatmentHumanReadeable.put("ODMS_MISSING_VALUE_MEAN_MODE", _meanMode);
        _missingValTreatmentHumanReadeable.put("ODMS_MISSING_VALUE_DELETE_ROW", _deleteRow);
    }

    class RowDiagnosticTableNameGen
    extends ProgressRunnable {
        private boolean _canceled;
        private String _tableName;
        private String ROW_DIAG_SUFFIX = "_RD";

        RowDiagnosticTableNameGen() {
        }

        public String getTableName() {
            return this._tableName;
        }

        protected Object doWork() throws Exception {
            this._tableName = WorkflowUtils.getNewTableName(ModelGLMBuildSettingsPanel.this.getState().getContext(), "ODMR$" + ModelGLMBuildSettingsPanel.this.getModelType().getName() + this.ROW_DIAG_SUFFIX);
            return this._tableName;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }

    class ReferenceClassDialog {
        protected String wizName = "Reference value in a logistic regression model";

        protected JEWTDialog buildDialog() {
            GLMTargetValuesPanel gLMTargetValuesPanel = new GLMTargetValuesPanel(ModelGLMBuildSettingsPanel.this.getState());
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            int n = 7;
            JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
            jEWTDialog.setContent((Component)gLMTargetValuesPanel);
            jEWTDialog.setTitle(this.getDialogTitle());
            return jEWTDialog;
        }

        private String getDialogTitle() {
            return AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_NAME_DIALOG_TITLE");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invoke() {
            boolean bl = false;
            try {
                JEWTDialog jEWTDialog = this.buildDialog();
                jEWTDialog.setResizable(true);
                final GLMTargetValuesPanel gLMTargetValuesPanel = (GLMTargetValuesPanel)jEWTDialog.getContent();
                jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                        String string = propertyChangeEvent.getPropertyName();
                        Object object = propertyChangeEvent.getNewValue();
                        if (string.equals("closed") && Boolean.TRUE.equals(object) && !gLMTargetValuesPanel.doWork()) {
                            throw new PropertyVetoException("panel", propertyChangeEvent);
                        }
                    }
                });
                if (jEWTDialog != null) {
                    bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_NAME_DIALOG_FAIL_TITLE"), (String)AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_NAME_DIALOG_FAIL_MSG"), null);
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
            return bl;
        }

        protected void cancel() {
        }
    }
}

