/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.RepositoryLrb;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AttributeNameCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.ModelEditRecord;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningDataType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TriStateCellEditor;
import oracle.javatools.ui.TriStateCheckBox;
import oracle.javatools.ui.TriStateTableRenderer;
import oracle.javatools.util.Version;

public class DataUsagePanel
extends AbstractSettingsPanel {
    private static final String AUTOMATIC_USAGE = "...";
    private static final String MULTI_SELECT_MTYPE = "?";
    private GenericTable _jDataUsageTable = new GenericTable();
    private UsageTableModel _usagesTblModel;
    private ComponentWithTitlebar<JComponent> _jDataUsageToolbar;
    private JButton _inputBtn;
    private JButton _ignoreBtn;
    private static Icon _inputIcon;
    private static Icon _ignoreIcon;
    private Version dbVersion = null;
    static int USAGE_ATTRIBUTE_NAME;
    static int USAGE_DATA_TYPE;
    static int USAGE_INPUT;
    static int USAGE_MINING_TYPE;
    static int USAGE_ADP;
    static int USAGE_COLUMN_COUNT;

    public DataUsagePanel(AdvancedSettingsPanel advancedSettingsPanel, Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, HashMap<String, ModelEditRecord> hashMap) {
        super(advancedSettingsPanel, context, abstractBuildNode, buildNodeType, hashMap);
        try {
            this.dbVersion = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initRes();
        this.initUI();
    }

    protected void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        UIResourceHelper.setComponentText(hashMap);
    }

    protected void initIconResources() {
        if (_inputIcon == null) {
            Class<WorkflowEditor> clazz = WorkflowEditor.class;
            _inputIcon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("INPUT_USAGE_ICON"));
            _ignoreIcon = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("IGNORE_USAGE_ICON"));
        }
    }

    protected void initUI() {
        this.initIconResources();
        JScrollPane jScrollPane = new JScrollPane((Component)this._jDataUsageTable);
        this._jDataUsageToolbar = new ComponentWithTitlebar();
        this._jDataUsageToolbar.setComponent((JComponent)jScrollPane);
        this._jDataUsageToolbar.setLabel(new JLabel(BuildEditorLrb.get("BUILD_DATA_USAGE_LBL")));
        this.installDataUsageActions();
        this._jDataUsageTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                DataUsagePanel.this.handleUsageSelectionChanged(listSelectionModel);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this._jDataUsageToolbar);
    }

    private void installDataUsageActions() {
        ControlBar controlBar = new ControlBar();
        this._inputBtn = new JButton(BuildEditorLrb.get("BUILD_DATA_USAGE_INPUT"), _inputIcon);
        this._inputBtn.setToolTipText(BuildEditorLrb.get("BUILD_DATA_USAGE_SET_TO_INPUT"));
        this._inputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataUsagePanel.this.setInputs(true);
            }
        });
        controlBar.add((Component)this._inputBtn);
        this._ignoreBtn = new JButton(BuildEditorLrb.get("BUILD_DATA_USAGE_IGNORE"), _ignoreIcon);
        this._ignoreBtn.setToolTipText(BuildEditorLrb.get("BUILD_DATA_USAGE_SET_TO_IGNORE"));
        this._ignoreBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataUsagePanel.this.setInputs(false);
            }
        });
        controlBar.add((Component)this._ignoreBtn);
        ListSelectionModel listSelectionModel = this._jDataUsageTable.getSelectionModel();
        this._inputBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this._ignoreBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this._jDataUsageToolbar.setControlBar(controlBar);
    }

    private void setInputs(boolean bl) {
        String string = bl ? "Yes" : "No";
        UsageTableModel usageTableModel = (UsageTableModel)((Object)this._jDataUsageTable.getModel());
        int[] nArray = this._jDataUsageTable.getSelectedRowsInModel();
        List<ModelType> list = usageTableModel.getDataList();
        List list2 = this.getMetadataCopy().getMiningAttributes().getMiningAttribute();
        ArrayList<MiningAttributeType> arrayList = new ArrayList<MiningAttributeType>();
        for (int i = 0; i < nArray.length; ++i) {
            ModelType modelType = this.findAttribute(list2, ((MiningAttributeType)this._jDataUsageTable.getValueAt(nArray[i], 0)).getName());
            arrayList.add((MiningAttributeType)modelType);
        }
        for (ModelType modelType : list) {
            ModelType modelType2 = this.findEditedModel(modelType);
            if (modelType2 == null) {
                modelType2 = this.addEditedModelRecord(modelType, ModelEditRecord.CHANGE).getModel();
            }
            usageTableModel.updateAttributesInModel(arrayList, modelType2, USAGE_INPUT, string);
        }
        usageTableModel.fireTableRowsUpdated(nArray[0], nArray[nArray.length - 1]);
    }

    private MiningAttributeType findAttribute(List<MiningAttributeType> list, String string) {
        MiningAttributeType miningAttributeType = null;
        for (MiningAttributeType miningAttributeType2 : list) {
            if (!miningAttributeType2.getName().equals(string)) continue;
            miningAttributeType = miningAttributeType2;
            break;
        }
        return miningAttributeType;
    }

    @Override
    protected void handleModelMetadataChanged() {
        this._usagesTblModel.fireTableDataChanged();
        this.handleUsageSelectionChanged(this._jDataUsageTable.getSelectionModel());
    }

    @Override
    protected boolean handleModelSelectionChanged(ListSelectionModel listSelectionModel) {
        List list;
        CaseAttributes caseAttributes;
        if (!super.handleModelSelectionChanged(listSelectionModel)) {
            return false;
        }
        this._usagesTblModel = new UsageTableModel(this.getContext(), this.getWorkflowNode(), this.getSelectedModels());
        this._jDataUsageTable.setModel((TableModel)((Object)this._usagesTblModel));
        TableColumn tableColumn = this._jDataUsageTable.getColumnModel().getColumn(USAGE_INPUT);
        TableColumn tableColumn2 = this._jDataUsageTable.getColumnModel().getColumn(USAGE_ADP);
        TableColumn tableColumn3 = this._jDataUsageTable.getColumnModel().getColumn(USAGE_MINING_TYPE);
        TriStateCheckBox triStateCheckBox = new TriStateCheckBox();
        tableColumn.setCellEditor((TableCellEditor)((Object)new TriStateCheckCellEditor(triStateCheckBox)));
        tableColumn.setCellRenderer((TableCellRenderer)((Object)new TriStateCheckCellRenderer()));
        tableColumn2.setCellEditor((TableCellEditor)((Object)new TriStateCheckCellEditor(triStateCheckBox)));
        tableColumn2.setCellRenderer((TableCellRenderer)new TriStateTableRenderer());
        tableColumn3.setCellEditor(new MiningTypeEditor());
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(2);
        tableColumn3.setCellRenderer(defaultTableCellRenderer);
        TableColumn tableColumn4 = this._jDataUsageTable.getColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        tableColumn4.setCellRenderer(attributeNameCellRenderer);
        BuildNodeType buildNodeType = this.getMetadataCopy();
        if (buildNodeType instanceof SuperviseBuildNodeType && (caseAttributes = ((SuperviseBuildNodeType)buildNodeType).getTargetAttribute()) != null) {
            attributeNameCellRenderer.setTargetName(caseAttributes.getName());
        }
        if ((list = (caseAttributes = buildNodeType.getCaseAttributes()).getAttribute()).size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (AttributeType attributeType : list) {
                arrayList.add(attributeType.getName());
            }
            attributeNameCellRenderer.setKeyNames(arrayList);
        }
        return true;
    }

    private void handleUsageSelectionChanged(ListSelectionModel listSelectionModel) {
        boolean bl = true;
        if (listSelectionModel.isSelectionEmpty()) {
            bl = false;
        } else if (listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
            int[] nArray = this.getSelectedModelRowsInModel();
            ModelType modelType = this.getModelsDataList().get(nArray[0]);
            ModelType modelType2 = this.findEditedModel(modelType);
            if (modelType2 == null) {
                modelType2 = modelType;
            }
            if (modelType2.getInputMiningData().getDataUsage() == InputMiningDataType.AUTO) {
                bl = false;
            }
        }
        this._inputBtn.setEnabled(bl);
        this._ignoreBtn.setEnabled(bl);
    }

    @Override
    protected void loadEmptySelectionUI() {
        String string = BuildEditorLrb.get("BUILD_USAGE_DEF_TABLE_TXT");
        String string2 = AUTOMATIC_USAGE;
        this._jDataUsageTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{string}}, new String[]{string2}));
    }

    static {
        USAGE_ATTRIBUTE_NAME = 0;
        USAGE_DATA_TYPE = 1;
        USAGE_INPUT = 2;
        USAGE_MINING_TYPE = 3;
        USAGE_ADP = 4;
        USAGE_COLUMN_COUNT = 5;
    }

    class UsageTableModel
    extends GenericBaseTableModel {
        private List<ModelType> _models;
        private Map<String, ModelType> _cachedModels;
        AbstractBuildNode _buildNode;
        Map<String, Boolean> _allowedAdpPartial = new HashMap<String, Boolean>();
        Map<String, Boolean> _allowedInputPartial = new HashMap<String, Boolean>();
        private Context _context = null;

        public UsageTableModel(Context context, AbstractBuildNode abstractBuildNode, List<ModelType> list) {
            this._models = list;
            this._cachedModels = new HashMap<String, ModelType>();
            this._buildNode = abstractBuildNode;
            this._context = context;
            Vector<String> vector = new Vector<String>();
            vector.add(BuildEditorLrb.get("BUILD_DATA_USAGE_ATTRS"));
            vector.add(BuildEditorLrb.get("BUILD_DATA_USAGE_DATA_TYPE"));
            vector.add(BuildEditorLrb.get("BUILD_DATA_USAGE_INPUT"));
            vector.add(BuildEditorLrb.get("BUILD_DATA_USAGE_MINING_TYPE"));
            vector.add(BuildEditorLrb.get("BUILD_DATA_USAGE_ADP"));
            this.setColumnIdentifiers(vector);
            BuildNodeType buildNodeType = (BuildNodeType)abstractBuildNode.getData();
            MiningAttributes miningAttributes = buildNodeType.getMiningAttributes();
            List list2 = miningAttributes.getMiningAttribute();
            for (ModelType modelType : this._models) {
                ModelType modelType2 = DataUsagePanel.this.findEditedModel(modelType);
                if (modelType2 == null) {
                    modelType2 = modelType;
                }
                ModelType modelType3 = (ModelType)MetaDataHelper.copyMetadataObject(modelType2);
                this._cachedModels.put(modelType.getId(), modelType3);
            }
            if (this._models.size() > 1) {
                for (ModelType modelType : list2) {
                    if (this.getCommonAttrValue(USAGE_ADP, (MiningAttributeType)modelType, this._cachedModels.values()) == null) {
                        this._allowedAdpPartial.put(modelType.getName(), Boolean.TRUE);
                    }
                    if (this.getCommonAttrValue(USAGE_INPUT, (MiningAttributeType)modelType, this._cachedModels.values()) != null) continue;
                    this._allowedInputPartial.put(modelType.getName(), Boolean.TRUE);
                }
            }
            if (list2 == null) {
                this.setRowCount(0);
            } else {
                this.setRowCount(list2.size());
            }
            this.setColumnCount(vector.size());
        }

        public boolean isAllowedAdpPartial(String string) {
            return this._allowedAdpPartial.containsKey(string);
        }

        public boolean isAllowedInputPartial(String string) {
            return this._allowedInputPartial.containsKey(string);
        }

        public boolean isCellEditable(int n, int n2) {
            AttributeType attributeType;
            MiningAttributeType miningAttributeType = (MiningAttributeType)this.getValueAt(n, 0);
            BuildNodeType buildNodeType = DataUsagePanel.this.getMetadataCopy();
            boolean bl = false;
            boolean bl2 = false;
            if (buildNodeType instanceof SuperviseBuildNodeType && (attributeType = ((SuperviseBuildNodeType)buildNodeType).getTargetAttribute()) != null && attributeType.getName().equals(miningAttributeType.getName())) {
                bl = true;
            }
            attributeType = null;
            if (buildNodeType.getCaseAttributes().getAttribute().size() > 0) {
                attributeType = (AttributeType)buildNodeType.getCaseAttributes().getAttribute().get(0);
            }
            if (attributeType != null && attributeType.getName().equals(miningAttributeType.getName())) {
                bl2 = true;
            }
            if (n2 == USAGE_ADP) {
                return !bl2;
            }
            if (n2 == USAGE_INPUT || n2 == USAGE_MINING_TYPE) {
                if (n2 == USAGE_MINING_TYPE) {
                    String string = (String)this.getValueAt(n, n2);
                    if (string.equals(RepositoryLrb.get("NOT_APPLICABLE"))) {
                        return false;
                    }
                    if (AttributeTypeHelper.isNestedType((AttributeType)miningAttributeType)) {
                        return false;
                    }
                }
                if (bl || bl2) {
                    return false;
                }
                for (ModelType modelType : this._models) {
                    ModelType modelType2 = DataUsagePanel.this.findEditedModel(modelType);
                    if (modelType2 == null) {
                        modelType2 = modelType;
                    }
                    if (n2 == USAGE_INPUT) {
                        if (!modelType2.getInputMiningData().getDataUsage().equals((Object)InputMiningDataType.MANUAL) || !AbstractBuildNode.isInputAllowed(miningAttributeType, modelType2, DataUsagePanel.this.dbVersion).booleanValue()) continue;
                        return true;
                    }
                    if (n2 != USAGE_MINING_TYPE) continue;
                    try {
                        if (!modelType2.getInputMiningData().getMiningUsage().equals((Object)InputMiningDataType.MANUAL) || DatabaseMetadataUtils.isACustomDataType(this._context, miningAttributeType.getDataType()) || !AbstractBuildNode.isInputAllowed(miningAttributeType, modelType2, DataUsagePanel.this.dbVersion).booleanValue()) continue;
                        return true;
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                        return false;
                    }
                }
            }
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != USAGE_INPUT && n2 != USAGE_ADP && n2 != USAGE_MINING_TYPE) {
                return;
            }
            BuildNodeType buildNodeType = (BuildNodeType)this._buildNode.getData();
            List list = buildNodeType.getMiningAttributes().getMiningAttribute();
            MiningAttributeType miningAttributeType = (MiningAttributeType)list.get(DataUsagePanel.this._jDataUsageTable.convertRowIndexToModel(n));
            ModelType modelType = null;
            for (ModelType modelType2 : this._models) {
                MiningAttributeType miningAttributeType2;
                ModelType modelType3;
                Object object2;
                modelType = DataUsagePanel.this.findEditedModel(modelType2);
                if (modelType == null) {
                    modelType = DataUsagePanel.this.addEditedModelRecord(modelType2, ModelEditRecord.CHANGE).getModel();
                }
                MiningAttributeType miningAttributeType3 = MetaDataHelper.findModelAttribute(miningAttributeType, modelType);
                if (n2 == USAGE_ADP) {
                    object2 = (TriStateCheckBox.State)object;
                    if (object2 == TriStateCheckBox.State.TRUE) {
                        miningAttributeType3.setAutoPrep("Yes");
                        continue;
                    }
                    if (object2 == TriStateCheckBox.State.FALSE) {
                        miningAttributeType3.setAutoPrep("No");
                        continue;
                    }
                    if (object2 != TriStateCheckBox.State.PARTIAL) continue;
                    modelType3 = this._cachedModels.get(modelType2.getId());
                    miningAttributeType2 = MetaDataHelper.findModelAttribute(miningAttributeType, modelType3);
                    miningAttributeType3.setAutoPrep(miningAttributeType2.getAutoPrep());
                    continue;
                }
                if (n2 == USAGE_INPUT) {
                    if (MetaDataHelper.isAutomatic(modelType)) continue;
                    object2 = (TriStateCheckBox.State)object;
                    if (object2 == TriStateCheckBox.State.TRUE) {
                        miningAttributeType3.setInput("Yes");
                        continue;
                    }
                    if (object2 == TriStateCheckBox.State.FALSE) {
                        miningAttributeType3.setInput("No");
                        continue;
                    }
                    if (object2 != TriStateCheckBox.State.PARTIAL) continue;
                    modelType3 = this._cachedModels.get(modelType2.getId());
                    miningAttributeType2 = MetaDataHelper.findModelAttribute(miningAttributeType, modelType3);
                    miningAttributeType3.setInput(miningAttributeType2.getInput());
                    continue;
                }
                if (n2 != USAGE_MINING_TYPE || ((String)(object2 = (String)object)).equals(DataUsagePanel.MULTI_SELECT_MTYPE)) continue;
                miningAttributeType3.setMiningType((String)object2);
            }
            this.fireTableCellUpdated(n, n2);
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            BuildNodeType buildNodeType = (BuildNodeType)this._buildNode.getData();
            List list = buildNodeType.getMiningAttributes().getMiningAttribute();
            MiningAttributeType miningAttributeType = (MiningAttributeType)list.get(DataUsagePanel.this._jDataUsageTable.convertRowIndexToModel(n));
            ModelType modelType = this._models.get(0);
            ModelType modelType2 = DataUsagePanel.this.findEditedModel(modelType);
            if (modelType2 == null) {
                modelType2 = modelType;
            }
            if (USAGE_ATTRIBUTE_NAME == n2) {
                object = miningAttributeType;
            } else if (USAGE_INPUT == n2) {
                Object object2;
                ModelType modelType3;
                if (this._models.size() == 1 && MetaDataHelper.isAutomatic(modelType2)) {
                    return DataUsagePanel.AUTOMATIC_USAGE;
                }
                Iterator<ModelType> iterator = this._models.iterator();
                if (iterator.hasNext()) {
                    modelType3 = iterator.next();
                    object2 = DataUsagePanel.this.findEditedModel(modelType3);
                    if (object2 == null) {
                        object2 = modelType3;
                    }
                    if (MetaDataHelper.isAutomatic((ModelType)object2)) {
                        return DataUsagePanel.AUTOMATIC_USAGE;
                    }
                }
                iterator = this.getCommonAttrValue(USAGE_INPUT, miningAttributeType, this._cachedModels.values());
                object = this._models.size() > 1 && iterator == null ? TriStateCheckBox.State.PARTIAL : (((String)(object2 = (modelType3 = MetaDataHelper.findModelAttribute(miningAttributeType, modelType2)).getInput())).equals("Yes") ? TriStateCheckBox.State.TRUE : TriStateCheckBox.State.FALSE);
            } else if (USAGE_ADP == n2) {
                MiningAttributeType miningAttributeType2;
                String string;
                String string2 = this.getCommonAttrValue(USAGE_ADP, miningAttributeType, this._cachedModels.values());
                object = this._models.size() > 1 && string2 == null ? TriStateCheckBox.State.PARTIAL : ((string = (miningAttributeType2 = MetaDataHelper.findModelAttribute(miningAttributeType, modelType2)).getAutoPrep()).equals("Yes") ? TriStateCheckBox.State.TRUE : TriStateCheckBox.State.FALSE);
            } else if (USAGE_DATA_TYPE == n2) {
                object = miningAttributeType.getDataType();
            } else if (USAGE_MINING_TYPE == n2) {
                ModelType modelType4;
                if (this._models.size() == 1 && MetaDataHelper.isAutomaticMiningType(modelType2)) {
                    return DataUsagePanel.AUTOMATIC_USAGE;
                }
                Iterator<ModelType> iterator = this._models.iterator();
                if (iterator.hasNext()) {
                    modelType4 = iterator.next();
                    ModelType modelType5 = DataUsagePanel.this.findEditedModel(modelType4);
                    if (modelType5 == null) {
                        modelType5 = modelType4;
                    }
                    if (MetaDataHelper.isAutomaticMiningType(modelType5)) {
                        return DataUsagePanel.AUTOMATIC_USAGE;
                    }
                }
                iterator = this.getCommonAttrValue(USAGE_MINING_TYPE, miningAttributeType, this._cachedModels.values());
                if (this._models.size() > 1 && iterator == null) {
                    object = DataUsagePanel.MULTI_SELECT_MTYPE;
                } else {
                    modelType4 = MetaDataHelper.findModelAttribute(miningAttributeType, modelType2);
                    object = modelType4.getMiningType();
                }
            }
            return object;
        }

        public void updateAttributesInModel(List<MiningAttributeType> list, ModelType modelType, int n, String string) {
            for (MiningAttributeType miningAttributeType : list) {
                MiningAttributeType miningAttributeType2 = MetaDataHelper.findModelAttribute(miningAttributeType, modelType);
                if (n == USAGE_INPUT) {
                    miningAttributeType2.setInput(string);
                }
                if (n != USAGE_ADP) continue;
                miningAttributeType2.setAutoPrep(string);
            }
        }

        public List<ModelType> getDataList() {
            return this._models;
        }

        private String getCommonAttrValue(int n, MiningAttributeType miningAttributeType, Collection<ModelType> collection) {
            String string = null;
            boolean bl = true;
            for (ModelType modelType : collection) {
                MiningAttributeType miningAttributeType2;
                ModelType modelType2 = DataUsagePanel.this.findEditedModel(modelType);
                if (modelType2 == null) {
                    modelType2 = modelType;
                }
                if ((miningAttributeType2 = MetaDataHelper.findModelAttribute(miningAttributeType, modelType2)) == null) {
                    return null;
                }
                if (n == USAGE_INPUT) {
                    if (MetaDataHelper.isAutomatic(modelType2)) continue;
                    if (null == string) {
                        string = miningAttributeType2.getInput();
                    }
                    if (!miningAttributeType2.getInput().equals(string)) {
                        bl = false;
                        break;
                    }
                } else if (n == USAGE_ADP) {
                    if (null == string) {
                        string = miningAttributeType2.getAutoPrep();
                    }
                    if (!miningAttributeType2.getAutoPrep().equals(string)) {
                        bl = false;
                        break;
                    }
                }
                if (n != USAGE_MINING_TYPE || MetaDataHelper.isAutomaticMiningType(modelType2)) continue;
                if (null == string) {
                    string = miningAttributeType2.getMiningType();
                }
                if (miningAttributeType2.getMiningType().equals(string)) continue;
                bl = false;
                break;
            }
            if (bl) {
                return string;
            }
            return null;
        }
    }

    class TriStateCheckCellRenderer
    extends TriStateTableRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof TriStateCheckBox.State) {
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            JLabel jLabel = new JLabel((String)object);
            jLabel.setOpaque(true);
            jLabel.setHorizontalAlignment(0);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(jTable.getSelectionForeground());
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(jTable.getForeground());
            }
            return jLabel;
        }
    }

    class TriStateCheckCellEditor
    extends TriStateCellEditor {
        public TriStateCheckCellEditor() {
            this(new TriStateCheckBox());
        }

        public TriStateCheckCellEditor(TriStateCheckBox triStateCheckBox) {
            super(triStateCheckBox);
            triStateCheckBox.setOpaque(true);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            List list = DataUsagePanel.this.getMetadataCopy().getMiningAttributes().getMiningAttribute();
            MiningAttributeType miningAttributeType = (MiningAttributeType)list.get(DataUsagePanel.this._jDataUsageTable.convertRowIndexToModel(n));
            UsageTableModel usageTableModel = (UsageTableModel)((Object)jTable.getModel());
            if (n2 == USAGE_ADP) {
                boolean bl2 = usageTableModel.isAllowedAdpPartial(miningAttributeType.getName());
                ((TriStateCheckBox)this.editorComponent).setCanUserSetPartial(bl2);
            } else if (n2 == USAGE_INPUT) {
                boolean bl3 = usageTableModel.isAllowedInputPartial(miningAttributeType.getName());
                ((TriStateCheckBox)this.editorComponent).setCanUserSetPartial(bl3);
            }
            this.editorComponent.setBackground(jTable.getSelectionBackground());
            this.editorComponent.setForeground(jTable.getSelectionForeground());
            return this.editorComponent;
        }
    }

    class MiningTypeEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        String currentValue;
        JComboBox comboComponent = new JComboBox();
        protected static final String EDIT = "edit";

        public MiningTypeEditor() {
            this.comboComponent.setActionCommand(EDIT);
            this.comboComponent.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentValue;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                this.currentValue = (String)this.comboComponent.getSelectedItem();
                this.fireEditingStopped();
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.currentValue = (String)object;
            boolean bl2 = this.currentValue.equals(DataUsagePanel.MULTI_SELECT_MTYPE);
            TableModel tableModel = jTable.getModel();
            MiningAttributeType miningAttributeType = (MiningAttributeType)tableModel.getValueAt(n, 0);
            this.comboComponent.removeAllItems();
            if (DatabaseMetadataUtils.getDefaultMiningType(miningAttributeType.getDataType()).equals("Numerical")) {
                this.comboComponent.addItem("Numerical");
                this.comboComponent.addItem("Categorical");
            } else {
                this.comboComponent.addItem("Categorical");
            }
            if (bl2) {
                this.comboComponent.addItem(DataUsagePanel.MULTI_SELECT_MTYPE);
            }
            return this.comboComponent;
        }
    }
}

