/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsDialog;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildNodeTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.CaseEditRecord;
import oracle.dmt.dataminer.workflow.dialog.build.ModelNameCellEditor;
import oracle.dmt.dataminer.workflow.dialog.build.NewModelPanel;
import oracle.dmt.dataminer.workflow.inspect.AttributeTypeComparator;
import oracle.dmt.dataminer.workflow.inspect.EditCaseAttributesDialog;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AnomalyDetectionBuildNode;
import oracle.dmt.dataminer.workflow.model.AssociationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClusteringBuildNode;
import oracle.dmt.dataminer.workflow.model.FeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningData;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningDataType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;

public class BuildEditPanel
extends AbstractDialogPanel {
    private List<String> selectedModels;
    private AbstractBuildNode diagramNode = (AbstractBuildNode)this.getData();
    private BuildNodeType nodeData = (BuildNodeType)this.diagramNode.getData();
    private BuildNodeType nodeDataCopy = (BuildNodeType)MetaDataHelper.copyMetadataObject(this.nodeData);
    private boolean _dirty = false;
    private JButton _jBtnCaseIds;
    private JLabel _jLblCaseIds;
    private JLabel _jLblItemID;
    private JLabel _jLblItemValue;
    private TransparentPanel _jModelsTablePanel;
    private ComponentWithTitlebar<JComponent> _jModelsToolbar;
    private JTextField _jTextCaseIds;
    private JButton jAdvancedBtn;
    private JComboBox jCaseCombo;
    private JLabel jCaseLabel;
    private JComboBox jItemIDCombo;
    private JComboBox jItemValueCombo;
    private JComboBox jTargetChoice;
    private JLabel jTargetLabel;
    private JLabel statusIconCase;
    private JLabel statusIconTarget;
    private JLabel statusItemId;
    private JLabel statusItemValue;
    private GenericTable _jModelsTable = new GenericTable();
    private ModelsTableModel _modelsTblModel;
    private JButton _removeBtn;
    private JButton _addBtn;
    private JButton _duplicateBtn;
    private static String[] columns = new String[]{BuildEditorLrb.get("BUILD_MODEL_NAME"), BuildEditorLrb.get("BUILD_MODEL_ALGORITHM"), BuildEditorLrb.get("BUILD_MODEL_LAST_BUILT"), BuildEditorLrb.get("BUILD_MODEL_AUTO")};

    public BuildEditPanel(Context context, AbstractBuildNode abstractBuildNode, List<String> list) {
        super(context, abstractBuildNode);
        this.selectedModels = list;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jModelsTablePanel = new TransparentPanel();
        this._jModelsToolbar = new ComponentWithTitlebar();
        this.jTargetLabel = new JLabel();
        this.jTargetChoice = new JComboBox();
        this.jCaseLabel = new JLabel();
        this.jCaseCombo = new JComboBox();
        this._jLblCaseIds = new JLabel();
        this._jTextCaseIds = new JTextField();
        this._jBtnCaseIds = new JButton();
        this.jItemIDCombo = new JComboBox();
        this._jLblItemID = new JLabel();
        this._jLblItemValue = new JLabel();
        this.jItemValueCombo = new JComboBox();
        this.statusIconTarget = new JLabel();
        this.statusIconCase = new JLabel();
        this.statusItemId = new JLabel();
        this.statusItemValue = new JLabel();
        this.jAdvancedBtn = new JButton();
        this._jModelsToolbar.setPreferredSize(new Dimension(0, 0));
        this.jTargetLabel.setText("Target:");
        this.jTargetLabel.setHorizontalTextPosition(2);
        this.jTargetChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCaseLabel.setText("Case ID:");
        this.jCaseLabel.setHorizontalTextPosition(2);
        this.jCaseCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._jLblCaseIds.setText("Case IDs:");
        this._jTextCaseIds.setEditable(false);
        this._jTextCaseIds.setMargin(new Insets(2, 2, 2, 0));
        this._jBtnCaseIds.setText("Edit");
        this.jItemIDCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._jLblItemID.setText("Item ID:");
        this._jLblItemValue.setText("Item Value:");
        this.jItemValueCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.statusIconTarget.setText("warnIcon");
        this.statusIconTarget.setHorizontalTextPosition(4);
        this.statusIconCase.setText("warnIcon");
        this.statusIconCase.setHorizontalTextPosition(2);
        this.statusItemId.setText("warnIcon");
        this.statusItemValue.setText("warnIcon");
        GroupLayout groupLayout = new GroupLayout((Container)this._jModelsTablePanel);
        this._jModelsTablePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jCaseLabel).addComponent(this._jLblItemValue, -2, 55, -2).addComponent(this._jLblCaseIds, -1, 72, Short.MAX_VALUE).addComponent(this.jTargetLabel, -1, -1, Short.MAX_VALUE).addComponent(this._jLblItemID, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jTextCaseIds, -2, 215, -2).addComponent(this.jCaseCombo, -2, -1, -2).addComponent(this.jTargetChoice, -2, 212, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusIconTarget).addComponent(this.statusIconCase).addComponent(this._jBtnCaseIds, -1, -1, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addComponent(this.jItemValueCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusItemValue)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jItemIDCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusItemId))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 385, Short.MAX_VALUE)).addComponent((Component)this._jModelsToolbar, -1, 733, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.linkSize(0, this._jTextCaseIds, this.jCaseCombo, this.jItemIDCombo, this.jItemValueCombo, this.jTargetChoice);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLabel).addComponent(this.jTargetChoice, -2, -1, -2).addComponent(this.statusIconTarget)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCaseLabel).addComponent(this.jCaseCombo, -2, -1, -2).addComponent(this.statusIconCase)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLblCaseIds).addComponent(this._jTextCaseIds, -2, -1, -2).addComponent(this._jBtnCaseIds)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLblItemID, -2, 14, -2).addComponent(this.jItemIDCombo, -2, -1, -2).addComponent(this.statusItemId)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLblItemValue, -2, 14, -2).addComponent(this.jItemValueCombo, -2, -1, -2).addComponent(this.statusItemValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this._jModelsToolbar, -2, 232, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this._jLblCaseIds, this._jTextCaseIds);
        groupLayout.linkSize(1, this.jTargetChoice, this.jTargetLabel);
        groupLayout.linkSize(1, this._jLblItemID, this.jItemIDCombo);
        this.jAdvancedBtn.setText("Advanced...");
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jModelsTablePanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap(630, Short.MAX_VALUE).addComponent(this.jAdvancedBtn).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent((Component)this._jModelsTablePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAdvancedBtn).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(BuildEditorLrb.get("BUILD_NODE_TARGET"), this.jTargetLabel);
        hashMap.put(BuildEditorLrb.get("BUILD_NODE_CASEID"), this.jCaseLabel);
        hashMap.put(BuildEditorLrb.get("BUILD_NODE_TXN_ID"), this._jLblCaseIds);
        hashMap.put(BuildEditorLrb.get("BUILD_NODE_ITEM_ID"), this._jLblItemID);
        hashMap.put(BuildEditorLrb.get("BUILD_NODE_ITEM_VALUE"), this._jLblItemValue);
        hashMap.put(BuildEditorLrb.get("BUILD_NODE_SELECT_CASE_ID"), this._jBtnCaseIds);
        hashMap.put(BuildEditorLrb.get("BUILD_NODE_ADVANCED_SETTING"), this.jAdvancedBtn);
        UIResourceHelper.setComponentText(hashMap);
        this.statusIconTarget.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusIconTarget.setToolTipText(BuildEditorLrb.get("BUILD_NODE_TARGET_INVALID_TIP"));
        this.statusIconTarget.setText("");
        this.statusIconCase.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusIconCase.setToolTipText(BuildEditorLrb.get("BUILD_NODE_CASEID_INVALID_TIP"));
        this.statusIconCase.setText("");
        this.statusItemId.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusItemId.setText("");
        this.statusItemValue.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusItemValue.setText("");
        this.initHelp();
    }

    private void initHelp() {
        if (this.getData() instanceof AssociationBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"association_node_edit");
        } else if (this.getData() instanceof ClassificationBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"classification_node_edit");
        } else if (this.getData() instanceof ClusteringBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"clustering_node_edit");
        } else if (this.getData() instanceof RegressionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"regression_node_edit");
        } else if (this.getData() instanceof AnomalyDetectionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"anomaly_node_edit");
        } else if (this.getData() instanceof FeatureExtractionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"feature_node_edit");
        }
    }

    @Override
    public void initUI() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        List list = this.nodeData.getMiningAttributes().getMiningAttribute();
        Collections.sort(list, new AttributeTypeComparator());
        if (this.nodeData instanceof AssociationBuildNodeType) {
            this.jTargetLabel.setVisible(false);
            this.remove(this.jTargetLabel);
            this.jTargetChoice.setVisible(false);
            this.remove(this.jTargetChoice);
            this.statusIconTarget.setVisible(false);
            this.remove(this.statusIconTarget);
            this.jCaseLabel.setVisible(false);
            this.remove(this.jCaseLabel);
            this.jCaseCombo.setVisible(false);
            this.remove(this.jCaseCombo);
            this.statusIconCase.setVisible(false);
            this.remove(this.statusIconCase);
            this.initMultiCaseIdUI();
            object4 = null;
            try {
                object4 = WorkflowUtils.getWorkflowModel((WorkflowNode)this.getContext().getNode());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object3 = this.diagramNode.findBuildDataNode((WorkflowModel)((Object)object4));
            object2 = object3;
            object = new ArrayList();
            if (object2 != null) {
                object = object2.getAttributes().getAttribute();
            }
            this.initItemIDUI((AssociationBuildNodeType)this.nodeData, (List<AttributeType>)object);
            this.initItemValueUI((AssociationBuildNodeType)this.nodeData, (List<AttributeType>)object);
        } else {
            this._jLblCaseIds.setVisible(false);
            this.remove(this._jLblCaseIds);
            this._jTextCaseIds.setVisible(false);
            this.remove(this._jTextCaseIds);
            this._jBtnCaseIds.setVisible(false);
            this.remove(this._jBtnCaseIds);
            this._jLblItemID.setVisible(false);
            this.remove(this._jLblItemID);
            this.statusItemId.setVisible(false);
            this.remove(this.statusItemId);
            this.jItemIDCombo.setVisible(false);
            this.remove(this.jItemIDCombo);
            this._jLblItemValue.setVisible(false);
            this.remove(this._jLblItemValue);
            this.statusItemValue.setVisible(false);
            this.remove(this.statusItemValue);
            this.jItemValueCombo.setVisible(false);
            this.remove(this.jItemValueCombo);
            if (this.nodeData instanceof SuperviseBuildNodeType) {
                this.initTargetAttrUI((SuperviseBuildNodeType)this.nodeData, list);
            } else {
                this.jTargetLabel.setVisible(false);
                this.jTargetChoice.setVisible(false);
                this.remove(this.jTargetChoice);
                this.remove(this.jTargetLabel);
                this.statusIconTarget.setVisible(false);
                this.remove(this.statusIconTarget);
            }
            this.initCaseIdUI(list);
        }
        object4 = new JScrollPane((Component)this._jModelsTable);
        this._jModelsToolbar.setComponent((JComponent)object4);
        this._jModelsToolbar.setLabel(new JLabel(BuildEditorLrb.get("BUILD_MODEL_SETTINGS_LBL")));
        this.installModelActions();
        object3 = MetaDataHelper.getModelsCollection((BuildNodeType)this.diagramNode.getData());
        this._modelsTblModel = new ModelsTableModel((List<ModelType>)object3, columns);
        this._jModelsTable.setModel((TableModel)((Object)this._modelsTblModel));
        this._jModelsTable.setSorted(true);
        this._jModelsTable.setUpdateSelectionOnSort(true);
        this._jModelsTable.getTableHeader().setReorderingAllowed(false);
        object2 = null;
        try {
            object2 = WorkflowUtils.getWorkflowModel((WorkflowNode)this.getContext().getNode());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._jModelsTable.getColumnModel().getColumn(0).setCellEditor(new ModelNameCellEditor(this._context, (WorkflowModel)((Object)object2), this.nodeDataCopy));
        if (this.nodeData instanceof AssociationBuildNodeType) {
            this._jModelsTable.removeColumn(this._jModelsTable.getColumnModel().getColumn(3));
        }
        this._jModelsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                BuildEditPanel.this.handleModelSelectionChanged(listSelectionModel);
            }
        });
        this._jModelsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    BuildEditPanel.this.launchAdvancedDialog();
                }
            }
        });
        if (object3.size() > 0 && this.selectedModels != null && ((Object)(object = (Object)this._modelsTblModel.getIndexesOf(this.selectedModels))).length != 0) {
            this._jModelsTable.setSelectedRowsInModel((int[])object);
        }
        this.jAdvancedBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildEditPanel.this.launchAdvancedDialog();
            }
        });
        this.jCaseCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox;
                Object object;
                AttributeType attributeType = MetaDataHelper.getCaseId(BuildEditPanel.this.nodeDataCopy);
                if (attributeType != null) {
                    MetaDataHelper.setMiningAttributeOptions(BuildEditPanel.this.nodeDataCopy, attributeType, true, true);
                }
                if ((object = (jComboBox = (JComboBox)actionEvent.getSource()).getSelectedItem()) instanceof CaseIdItem) {
                    CaseIdItem caseIdItem = (CaseIdItem)object;
                    AttributeType attributeType2 = caseIdItem.item;
                    if (attributeType2.getStatus().equals((Object)AttributeStatus.INVALID)) {
                        BuildEditPanel.this.statusIconCase.setVisible(true);
                    } else {
                        BuildEditPanel.this.statusIconCase.setVisible(false);
                    }
                    CaseAttributes caseAttributes = new CaseAttributes();
                    caseAttributes.getAttribute().add(attributeType2);
                    BuildEditPanel.this.nodeDataCopy.setCaseAttributes(caseAttributes);
                    BuildEditPanel.this.setIsDirty(true);
                    MetaDataHelper.setMiningAttributeOptions(BuildEditPanel.this.nodeDataCopy, attributeType2, false, false);
                } else {
                    CaseAttributes caseAttributes = new CaseAttributes();
                    caseAttributes.getAttribute().clear();
                    BuildEditPanel.this.nodeDataCopy.setCaseAttributes(caseAttributes);
                    BuildEditPanel.this.statusIconCase.setVisible(false);
                    BuildEditPanel.this.setIsDirty(true);
                }
            }
        });
        this.jTargetChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)BuildEditPanel.this.nodeDataCopy;
                AttributeType attributeType = superviseBuildNodeType.getTargetAttribute();
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object instanceof TargetItem) {
                    TargetItem targetItem = (TargetItem)object;
                    AttributeType attributeType2 = targetItem.item;
                    AttributeType attributeType3 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType2);
                    if (attributeType != null) {
                        MetaDataHelper.setMiningAttributeOptions((BuildNodeType)superviseBuildNodeType, attributeType, true, true);
                    }
                    MetaDataHelper.setMiningTargetOptionsUsingDefaults((BuildNodeType)superviseBuildNodeType, attributeType3);
                    superviseBuildNodeType.setTargetAttribute(attributeType3);
                    BuildEditPanel.this.setIsDirty(true);
                    if (attributeType2.getStatus().equals((Object)AttributeStatus.INVALID)) {
                        BuildEditPanel.this.statusIconTarget.setVisible(true);
                    } else {
                        BuildEditPanel.this.statusIconTarget.setVisible(false);
                    }
                    if (jComboBox.getItemAt(0) instanceof String) {
                        jComboBox.removeItemAt(0);
                    }
                }
            }
        });
        this.jItemIDCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object instanceof CaseIdItem) {
                    CaseIdItem caseIdItem = (CaseIdItem)object;
                    AttributeType attributeType = caseIdItem.item;
                    AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)BuildEditPanel.this.nodeDataCopy;
                    associationBuildNodeType.setItemID((AttributeType)MetaDataHelper.copyMetadataObject(attributeType));
                    BuildEditPanel.this.setIsDirty(true);
                    if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
                        BuildEditPanel.this.statusItemId.setVisible(true);
                    } else {
                        BuildEditPanel.this.statusItemId.setVisible(false);
                    }
                    if (jComboBox.getItemAt(0) instanceof String) {
                        jComboBox.removeItemAt(0);
                    }
                }
            }
        });
        this.jItemValueCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object instanceof CaseIdItem) {
                    CaseIdItem caseIdItem = (CaseIdItem)object;
                    AttributeType attributeType = caseIdItem.item;
                    AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)BuildEditPanel.this.nodeDataCopy;
                    associationBuildNodeType.setItemValue((AttributeType)MetaDataHelper.copyMetadataObject(attributeType));
                    BuildEditPanel.this.setIsDirty(true);
                    if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
                        BuildEditPanel.this.statusItemValue.setVisible(true);
                    } else {
                        BuildEditPanel.this.statusItemValue.setVisible(false);
                    }
                } else {
                    AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)BuildEditPanel.this.nodeDataCopy;
                    associationBuildNodeType.setItemValue(null);
                    BuildEditPanel.this.setIsDirty(true);
                    BuildEditPanel.this.statusItemValue.setVisible(false);
                }
            }
        });
        this._jBtnCaseIds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                CaseEditRecord caseEditRecord = new CaseEditRecord(new CaseAttributes());
                List list = BuildEditPanel.this.nodeDataCopy.getCaseAttributes().getAttribute();
                for (Object object2 : list) {
                    object = (AttributeType)MetaDataHelper.copyMetadataObject(object2);
                    caseEditRecord.getCaseAttributes().getAttribute().add(object);
                }
                WorkflowNode workflowNode = (WorkflowNode)BuildEditPanel.this.getContext().getNode();
                try {
                    Object object2;
                    object2 = WorkflowUtils.getWorkflowModel(workflowNode);
                    object = new EditCaseAttributesDialog(caseEditRecord);
                    boolean bl = ((EditCaseAttributesDialog)object).invoke(BuildEditPanel.this.getContext(), BuildEditPanel.this.diagramNode.findBuildDataNode((WorkflowModel)((Object)object2)));
                    if (bl) {
                        CaseAttributes caseAttributes = caseEditRecord.getCaseAttributes();
                        BuildEditPanel.this.nodeDataCopy.setCaseAttributes(caseAttributes);
                        BuildEditPanel.this.initMultiCaseIdUI();
                        BuildEditPanel.this.setIsDirty(true);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    private void launchAdvancedDialog() {
        Object object;
        int[] nArray = this._jModelsTable.getSelectedRows();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = this._jModelsTable.convertRowIndexToModel(nArray[i]);
            object = this._modelsTblModel.getDataList().get(n);
            arrayList.add(object.getId());
        }
        AdvancedSettingsDialog advancedSettingsDialog = new AdvancedSettingsDialog();
        if (advancedSettingsDialog.invoke(this.getContext(), this.diagramNode, this.nodeDataCopy, arrayList)) {
            ModelType modelType;
            boolean bl;
            if (!advancedSettingsDialog.isDirty()) {
                return;
            }
            this.setIsDirty(true);
            List<ModelType> list = MetaDataHelper.getModelsCollection(this.nodeDataCopy);
            object = this._modelsTblModel.getDataList();
            boolean bl2 = bl = list.size() != object.size();
            if (!bl) {
                for (int i = 0; i < list.size(); ++i) {
                    modelType = list.get(i);
                    ModelType modelType2 = (ModelType)object.get(i);
                    if (modelType.getId().equals(modelType2.getId())) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                ModelType modelType3;
                int n;
                int[] nArray2 = this._jModelsTable.getSelectedRows();
                modelType = new ArrayList();
                for (int i = 0; i < nArray2.length; ++i) {
                    n = this._jModelsTable.convertRowIndexToModel(nArray2[i]);
                    modelType3 = this._modelsTblModel.getDataList().get(n);
                    modelType.add(modelType3.getId());
                }
                this._modelsTblModel = new ModelsTableModel(list, columns);
                this._jModelsTable.setModel((TableModel)((Object)this._modelsTblModel));
                this._jModelsTable.setSorted(true);
                this._jModelsTable.setUpdateSelectionOnSort(true);
                if (this.nodeData instanceof AssociationBuildNodeType) {
                    this._jModelsTable.removeColumn(this._jModelsTable.getColumnModel().getColumn(3));
                }
                if (modelType.size() > 0) {
                    Vector<Integer> vector = new Vector<Integer>();
                    for (n = 0; n < this._modelsTblModel.getDataList().size(); ++n) {
                        modelType3 = this._modelsTblModel.getDataList().get(n);
                        if (!modelType.contains(modelType3.getId())) continue;
                        vector.add(n);
                    }
                    if (vector.size() > 0) {
                        int[] nArray3 = new int[vector.size()];
                        for (int i = 0; i < vector.size(); ++i) {
                            nArray3[i] = (Integer)vector.get(i);
                        }
                        this._jModelsTable.setSelectedRowsInModel(nArray3);
                    }
                }
            } else {
                this._jModelsTable.repaint();
            }
        }
    }

    private void installModelActions() {
        ControlBar controlBar = new ControlBar();
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(BuildEditorLrb.get("MODELS_DELETE_TOOLTIP"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                int n;
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)BuildEditorLrb.get("REMOVE_MODELS_MSG"), (String)BuildEditorLrb.get("REMOVE_MODELS_TITLE"), null, (boolean)true)) {
                    return;
                }
                int[] nArray = BuildEditPanel.this._jModelsTable.getSelectedRows();
                int[] nArray2 = new int[nArray.length];
                for (n = 0; n < nArray.length; ++n) {
                    nArray2[n] = BuildEditPanel.this._jModelsTable.convertRowIndexToModel(nArray[n]);
                    object = BuildEditPanel.this._modelsTblModel.getDataList().get(nArray2[n]);
                    MetaDataHelper.removeModel(BuildEditPanel.this.nodeDataCopy, object);
                }
                BuildEditPanel.this._modelsTblModel.removeRows(nArray2);
                if (BuildEditPanel.this._modelsTblModel.getDataList().size() != 0) {
                    n = nArray[0] - 1 < 0 ? 0 : nArray[0] - 1;
                    n = BuildEditPanel.this._jModelsTable.convertRowIndexToModel(n);
                    object = new int[]{n};
                    BuildEditPanel.this._jModelsTable.setSelectedRowsInModel((int[])object);
                }
                BuildEditPanel.this.setIsDirty(true);
            }
        });
        controlBar.add((Component)this._removeBtn);
        this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setToolTipText(BuildEditorLrb.get("MODELS_ADD_TOOLTIP"));
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewModelDialog newModelDialog = new NewModelDialog();
                if (newModelDialog.invoke(BuildEditPanel.this.getContext(), BuildEditPanel.this.diagramNode)) {
                    ModelType modelType = newModelDialog.getNewModel();
                    MetaDataHelper.addModel(BuildEditPanel.this.nodeDataCopy, modelType);
                    int[] nArray = new int[]{BuildEditPanel.this._modelsTblModel.addModel(modelType)};
                    BuildEditPanel.this._jModelsTable.setSelectedRowsInModel(nArray);
                }
                BuildEditPanel.this.setIsDirty(true);
            }
        });
        controlBar.add((Component)this._addBtn);
        this._duplicateBtn = new JButton(OracleIcons.getIcon((String)"duplicate.png"));
        this._duplicateBtn.setToolTipText(BuildEditorLrb.get("MODELS_DUPLICATE_TOOLTIP"));
        this._duplicateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel((WorkflowNode)BuildEditPanel.this._context.getNode());
                    int[] nArray = BuildEditPanel.this._jModelsTable.getSelectedRows();
                    ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
                    for (int i = 0; i < nArray.length; ++i) {
                        object3 = BuildEditPanel.this._modelsTblModel.getDataList().get(BuildEditPanel.this._jModelsTable.convertRowIndexToModel(nArray[i]));
                        object2 = MetaDataHelper.findModelById(BuildEditPanel.this.nodeDataCopy, object3.getId());
                        object = (ModelType)MetaDataHelper.copyMetadataObject(object2);
                        object.setUseForOutput(true);
                        arrayList.add((ModelType)object);
                    }
                    List<RefModelType> list = MetaDataHelper.getModelsCollection(BuildEditPanel.this.nodeDataCopy, arrayList, BuildEditPanel.this._context);
                    object3 = MetaDataHelper.getModelsCollection(BuildEditPanel.this.nodeDataCopy);
                    object2 = WorkflowUtils.refactorModels(BuildEditPanel.this._context, list, (List<ModelType>)object3, workflowModel, false);
                    AbstractBuildNode.applyRefactoredModels((Map<String, RefModelType>)object2, arrayList);
                    for (ModelType modelType : arrayList) {
                        MetaDataHelper.addModel(BuildEditPanel.this.nodeDataCopy, modelType);
                    }
                    object = new int[arrayList.size()];
                    int n = 0;
                    for (ModelType modelType : arrayList) {
                        object[n++] = (ModelType)BuildEditPanel.this._modelsTblModel.addModel(modelType);
                    }
                    BuildEditPanel.this._jModelsTable.setSelectedRowsInModel((int[])object);
                    BuildEditPanel.this.setIsDirty(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        controlBar.add((Component)this._duplicateBtn);
        ListSelectionModel listSelectionModel = this._jModelsTable.getSelectionModel();
        this._removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this._duplicateBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this._jModelsToolbar.setControlBar(controlBar);
    }

    private void initCaseIdUI(List<MiningAttributeType> list) {
        List list2 = null;
        list2 = this.nodeDataCopy.getCaseAttributes().getAttribute();
        AttributeType attributeType = null;
        if (list2.size() != 0) {
            attributeType = (AttributeType)list2.get(0);
        }
        boolean bl = false;
        this.jCaseCombo.removeAllItems();
        this.jCaseCombo.addItem(BuildEditorLrb.get("BUILD_NODE_CASEID_HINT"));
        for (Object object : list) {
            if (!DatabaseMetadataUtils.isCaseIdDataTypeSupported(this.getContext(), object.getDataType())) continue;
            this.jCaseCombo.addItem(new CaseIdItem((AttributeType)object));
            if (attributeType == null || !object.getName().equals(attributeType.getName()) || !object.getDataType().equals(attributeType.getDataType())) continue;
            bl = true;
        }
        if (attributeType != null && !bl) {
            this.jCaseCombo.setEditable(true);
            this.jCaseCombo.setSelectedItem(new CaseIdItem(attributeType));
            this.jCaseCombo.setEditable(false);
        }
        if (list2.size() == 0) {
            this.jCaseCombo.setSelectedIndex(0);
        }
        if (attributeType != null && bl) {
            for (int i = 0; i < this.jCaseCombo.getItemCount(); ++i) {
                Object object;
                if (!(this.jCaseCombo.getItemAt(i) instanceof CaseIdItem)) continue;
                object = (CaseIdItem)this.jCaseCombo.getItemAt(i);
                if (!attributeType.getName().equals(object.item.getName()) || !attributeType.getDataType().equals(object.item.getDataType())) continue;
                this.jCaseCombo.setSelectedIndex(i);
            }
        }
        if (attributeType != null && attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
            this.statusIconCase.setVisible(false);
        } else if (attributeType != null && attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
            this.statusIconCase.setVisible(true);
        } else if (attributeType == null) {
            this.statusIconCase.setVisible(false);
        }
    }

    private void initMultiCaseIdUI() {
        List list = null;
        boolean bl = false;
        list = this.nodeDataCopy.getCaseAttributes().getAttribute();
        if (list.size() != 0) {
            String string = "";
            for (AttributeType attributeType : list) {
                string = string + attributeType.getName() + ", ";
                if (!attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
                bl = true;
            }
            string = string.substring(0, string.length() - 2);
            this._jTextCaseIds.setText(string);
        } else {
            this._jTextCaseIds.setText(BuildEditorLrb.get("BUILD_NODE_MULTICASEID_HINT"));
            bl = true;
        }
        if (bl) {
            this._jBtnCaseIds.setIcon(OracleIcons.getIcon((String)"warning.png"));
        } else {
            this._jBtnCaseIds.setIcon(null);
        }
    }

    private void initTargetAttrUI(SuperviseBuildNodeType superviseBuildNodeType, List<MiningAttributeType> list) {
        this.jTargetChoice.removeAllItems();
        for (MiningAttributeType miningAttributeType : list) {
            try {
                if (this.diagramNode instanceof ClassificationBuildNode && DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this._context, miningAttributeType.getDataType())) {
                    this.jTargetChoice.addItem(new TargetItem(miningAttributeType));
                    continue;
                }
                if (!(this.diagramNode instanceof RegressionBuildNode) || !DatabaseMetadataUtils.isTargetNumericalDataTypeSupported(this._context, miningAttributeType.getDataType())) continue;
                this.jTargetChoice.addItem(new TargetItem(miningAttributeType));
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                return;
            }
        }
        AttributeType attributeType = superviseBuildNodeType.getTargetAttribute();
        if (attributeType == null) {
            this.jTargetChoice.insertItemAt(BuildEditorLrb.get("BUILD_NODE_TARGET_HINT"), 0);
            this.jTargetChoice.setSelectedIndex(0);
        }
        if (attributeType != null && attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
            boolean bl = false;
            for (int i = 0; i < this.jTargetChoice.getItemCount(); ++i) {
                if (!(this.jTargetChoice.getItemAt(i) instanceof TargetItem)) continue;
                TargetItem targetItem = (TargetItem)this.jTargetChoice.getItemAt(i);
                if (!attributeType.getName().equals(targetItem.item.getName()) || !attributeType.getDataType().equals(targetItem.item.getDataType())) continue;
                this.jTargetChoice.setSelectedIndex(i);
                bl = true;
            }
            if (!bl) {
                new Exception("Could not find the target value even though it is valid").printStackTrace();
            } else {
                this.statusIconTarget.setVisible(false);
            }
        } else if (attributeType != null && attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
            MiningAttributeType miningAttributeType;
            miningAttributeType = MetaDataHelper.createMiningAttributeFrom(attributeType);
            TargetItem targetItem = new TargetItem(miningAttributeType);
            this.jTargetChoice.setEditable(true);
            this.jTargetChoice.setSelectedItem(targetItem);
            this.jTargetChoice.setEditable(false);
            this.statusIconTarget.setVisible(true);
        } else if (attributeType == null) {
            this.statusIconTarget.setVisible(true);
        }
    }

    private void initItemIDUI(AssociationBuildNodeType associationBuildNodeType, List<AttributeType> list) {
        AttributeType attributeType = associationBuildNodeType.getItemID();
        this.jItemIDCombo.removeAllItems();
        this.jItemIDCombo.addItem(BuildEditorLrb.get("BUILD_NODE_ITEMID_HINT"));
        try {
            for (AttributeType attributeType2 : list) {
                if (!DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this._context, attributeType2.getDataType())) continue;
                this.jItemIDCombo.addItem(new CaseIdItem(attributeType2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (attributeType == null) {
            this.jItemIDCombo.setSelectedIndex(0);
            this.statusItemId.setVisible(true);
        } else {
            CaseIdItem caseIdItem;
            boolean bl = false;
            for (int i = 0; i < this.jItemIDCombo.getItemCount(); ++i) {
                if (!(this.jItemIDCombo.getItemAt(i) instanceof CaseIdItem)) continue;
                caseIdItem = (CaseIdItem)this.jItemIDCombo.getItemAt(i);
                if (!attributeType.getName().equals(caseIdItem.item.getName()) || !attributeType.getDataType().equals(caseIdItem.item.getDataType())) continue;
                this.jItemIDCombo.setSelectedIndex(i);
                bl = true;
            }
            if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
                if (!bl) {
                    new Exception("Could not find the item id even though it is valid").printStackTrace();
                } else {
                    this.statusItemId.setVisible(false);
                }
            } else {
                this.statusItemId.setVisible(true);
                if (!bl) {
                    MiningAttributeType miningAttributeType = MetaDataHelper.createMiningAttributeFrom(attributeType);
                    caseIdItem = new CaseIdItem((AttributeType)miningAttributeType);
                    this.jItemIDCombo.setEditable(true);
                    this.jItemIDCombo.setSelectedItem(caseIdItem);
                    this.jItemIDCombo.setEditable(false);
                }
            }
        }
    }

    private void initItemValueUI(AssociationBuildNodeType associationBuildNodeType, List<AttributeType> list) {
        AttributeType attributeType = associationBuildNodeType.getItemValue();
        this.jItemValueCombo.removeAllItems();
        this.jItemValueCombo.addItem(BuildEditorLrb.get("BUILD_NODE_ITEMVALUE_EXISTENCE"));
        for (AttributeType attributeType2 : list) {
            try {
                if (!DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this._context, attributeType2.getDataType())) continue;
                this.jItemValueCombo.addItem(new CaseIdItem(attributeType2));
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                return;
            }
        }
        if (attributeType == null) {
            this.jItemValueCombo.setSelectedIndex(0);
            this.statusItemValue.setVisible(false);
        } else {
            CaseIdItem caseIdItem;
            boolean bl = false;
            for (int i = 0; i < this.jItemValueCombo.getItemCount(); ++i) {
                if (!(this.jItemValueCombo.getItemAt(i) instanceof CaseIdItem)) continue;
                caseIdItem = (CaseIdItem)this.jItemValueCombo.getItemAt(i);
                if (!attributeType.getName().equals(caseIdItem.item.getName()) || !attributeType.getDataType().equals(caseIdItem.item.getDataType())) continue;
                this.jItemValueCombo.setSelectedIndex(i);
                bl = true;
            }
            if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
                if (!bl) {
                    new Exception("Could not find the item value even though it is valid").printStackTrace();
                } else {
                    this.statusItemValue.setVisible(false);
                }
            } else {
                this.statusItemValue.setVisible(true);
                if (!bl) {
                    MiningAttributeType miningAttributeType = MetaDataHelper.createMiningAttributeFrom(attributeType);
                    caseIdItem = new CaseIdItem((AttributeType)miningAttributeType);
                    this.jItemValueCombo.setEditable(true);
                    this.jItemValueCombo.setSelectedItem(caseIdItem);
                    this.jItemValueCombo.setEditable(false);
                }
            }
        }
    }

    public boolean doWork() {
        Object object;
        Object object2;
        if (this._jModelsTable.isEditing() && !(object2 = this._jModelsTable.getCellEditor()).stopCellEditing()) {
            return false;
        }
        if (!this.isDirty()) {
            return true;
        }
        object2 = (AbstractBuildNode)this.getData();
        boolean bl = true;
        HashMap<String, ModelType> hashMap = new HashMap<String, ModelType>();
        List<ModelType> list = MetaDataHelper.getModelsCollection(this.nodeData);
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        for (ModelType object3 : list) {
            object = MetaDataHelper.findModelById(this.nodeDataCopy, object3.getId());
            if (object == null || object.getName().equals(object3.getName())) continue;
            hashMap.put(object.getName(), object3);
            arrayList.add((ModelType)object);
        }
        if (!MetaDataHelper.isEqualTargetAndCaseID(this.nodeData, this.nodeDataCopy)) {
            MetaDataHelper.setModelsStatus(this.nodeDataCopy, ModelStatusType.READY);
        } else if (this.nodeData instanceof AssociationBuildNodeType) {
            if (!MetaDataHelper.isEqualAssociationSettings(this.nodeData, this.nodeDataCopy)) {
                MetaDataHelper.setModelsStatus(this.nodeDataCopy, ModelStatusType.READY);
            }
        } else if (!hashMap.isEmpty()) {
            MetaDataHelper.setModelsStatus(this.nodeDataCopy, arrayList, ModelStatusType.READY);
        }
        try {
            CommandProcessor.getInstance().beginTrans(BuildEditorLrb.get("EDIT_NODE"));
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(object2, this.getContext(), "nodetype", this.nodeDataCopy);
            if (hashMap.size() > 0) {
                List<RefModelType> list2 = MetaDataHelper.getModelsCollection(this.nodeDataCopy, this._context);
                object = new HashMap();
                for (RefModelType refModelType : list2) {
                    if (!hashMap.containsKey(refModelType.getName())) continue;
                    object.put(((ModelType)hashMap.get(refModelType.getName())).getName(), refModelType);
                }
                this.diagramNode.refactorChildModelReferences((Map<String, RefModelType>)object, false);
            }
            ((AbstractBuildNode)object2).validateAfterEdit();
            CommandProcessor.getInstance().endTrans();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
            CommandProcessor.getInstance().abortTrans();
        }
        return bl;
    }

    private void handleModelSelectionChanged(ListSelectionModel listSelectionModel) {
        this._removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this._duplicateBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
    }

    public void setIsDirty(boolean bl) {
        this._dirty = bl;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    class NewModelDialog {
        protected JEWTDialog _dlg;
        protected String wizName = "addModel";
        private ModelType newModel;

        public ModelType getNewModel() {
            return this.newModel;
        }

        protected JEWTDialog buildDialog(Context context, AbstractBuildNode abstractBuildNode) {
            WorkflowModel workflowModel = null;
            try {
                workflowModel = WorkflowUtils.getWorkflowModel((WorkflowNode)BuildEditPanel.this.getContext().getNode());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Collection<String> collection = WorkflowUtils.getInMemoryModelNames(workflowModel, BuildEditPanel.this.nodeDataCopy);
            NewModelPanel newModelPanel = new NewModelPanel(context, abstractBuildNode, collection);
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            int n = 7;
            JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
            jEWTDialog.setContent((Component)newModelPanel);
            jEWTDialog.setTitle(BuildEditorLrb.get("NEW_MODEL_DIALOG_TITLE"));
            return jEWTDialog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invoke(Context context, AbstractBuildNode abstractBuildNode) {
            boolean bl = false;
            try {
                JEWTDialog jEWTDialog = this.buildDialog(context, abstractBuildNode);
                jEWTDialog.setResizable(true);
                final NewModelPanel newModelPanel = (NewModelPanel)jEWTDialog.getContent();
                jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                        String string = propertyChangeEvent.getPropertyName();
                        Object object = propertyChangeEvent.getNewValue();
                        if (string.equals("closed") && Boolean.TRUE.equals(object)) {
                            if (!newModelPanel.doWork()) {
                                throw new PropertyVetoException("panel", propertyChangeEvent);
                            }
                            NewModelDialog.this.newModel = newModelPanel.getNewModel();
                        }
                    }
                });
                this._dlg = jEWTDialog;
                if (jEWTDialog != null) {
                    bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_TITLE"), (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_MSG"), null);
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
            return bl;
        }

        protected void cancel() {
        }
    }

    class CaseIdItem {
        AttributeType item = new AttributeType();

        CaseIdItem(AttributeType attributeType) {
            this.item.setAlias(attributeType.getAlias());
            this.item.setDataType(attributeType.getDataType());
            this.item.setName(attributeType.getName());
            this.item.setStatus(AttributeStatus.fromValue((String)attributeType.getStatus().value()));
        }

        public String toString() {
            return this.item.getName();
        }
    }

    class TargetItem {
        AttributeType item = new AttributeType();

        TargetItem(MiningAttributeType miningAttributeType) {
            this.item.setAlias(miningAttributeType.getAlias());
            this.item.setDataType(miningAttributeType.getDataType());
            this.item.setName(miningAttributeType.getName());
            this.item.setStatus(AttributeStatus.fromValue((String)miningAttributeType.getStatus().value()));
        }

        public String toString() {
            return this.item.getName();
        }
    }

    class ModelsTableModel
    extends GenericBaseTableModel
    implements BuildNodeTableModel {
        private List<ModelType> _data;
        public static final int NAME = 0;
        public static final int ALGORITHM = 1;
        public static final int MODEL_CREATED_ON = 2;
        public static final int AUTO = 3;
        public static final int COLUMN_COUNT = 4;

        public ModelsTableModel(List<ModelType> list, String[] stringArray) {
            this._data = list;
            this.setColumnIdentifiers(stringArray);
            this.setRowCount(this._data.size());
            this.setColumnCount(4);
        }

        public int[] getIndexesOf(List<String> list) {
            Vector<Integer> vector = new Vector<Integer>();
            for (String string : list) {
                for (int i = 0; i < this._data.size(); ++i) {
                    ModelType modelType = this._data.get(i);
                    if (!modelType.getName().equals(string)) continue;
                    vector.add(i);
                }
            }
            if (vector.size() == 0) {
                return new int[0];
            }
            Object object = new int[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                object[i] = (Integer)vector.get(i);
            }
            return object;
        }

        public Class<?> getColumnClass(int n) {
            if (n == 3) {
                return Boolean.class;
            }
            if (n == 2) {
                return XMLGregorianCalendar.class;
            }
            return String.class;
        }

        public void reload(List<ModelType> list) {
            this._data = list;
            this.setRowCount(this._data.size());
            this.fireTableDataChanged();
        }

        public int addModel(ModelType modelType) {
            this._data.add(modelType);
            int n = this._data.size() - 1;
            this.setRowCount(this._data.size());
            this.fireTableRowsInserted(n, n);
            return this._data.size() - 1;
        }

        public void removeRows(int[] nArray) {
            ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(this._data.get(nArray[i]));
            }
            for (ModelType modelType : arrayList) {
                int n = this._data.indexOf(modelType);
                this.fireTableRowsDeleted(n, n);
                this.removeModel(n);
            }
        }

        public void removeModel(int n) {
            this._data.remove(n);
            this.setRowCount(this._data.size());
        }

        @Override
        public String getOriginalModelName(int n) {
            String string = null;
            ModelType modelType = this._data.get(n);
            ModelType modelType2 = MetaDataHelper.findModelById(BuildEditPanel.this.nodeData, modelType.getId());
            if (modelType2 != null) {
                string = modelType2.getName();
            }
            return string;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ModelType modelType = this._data.get(n);
            Object object = null;
            ModelType modelType2 = MetaDataHelper.findModelById(BuildEditPanel.this.nodeDataCopy, modelType.getId());
            if (modelType2 == null) {
                modelType2 = modelType;
            }
            switch (n2) {
                case 0: {
                    object = modelType2.getName();
                    break;
                }
                case 1: {
                    object = MetaDataHelper.getAlgorithmName(modelType2);
                    break;
                }
                case 2: {
                    XMLGregorianCalendar xMLGregorianCalendar = modelType2.getCreationDate();
                    if (xMLGregorianCalendar != null) {
                        object = TimeUtils.formatDate(xMLGregorianCalendar);
                        break;
                    }
                    object = null;
                    break;
                }
                case 3: {
                    if (modelType2.getInputMiningData().getDataUsage().equals((Object)InputMiningDataType.AUTO)) {
                        object = Boolean.TRUE;
                        break;
                    }
                    object = Boolean.FALSE;
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0 || n2 == 3;
        }

        public void setValueAt(Object object, int n, int n2) {
            ModelType modelType = this._data.get(n);
            ModelType modelType2 = MetaDataHelper.findModelById(BuildEditPanel.this.nodeDataCopy, modelType.getId());
            if (modelType2 == null) {
                throw new RuntimeException("Model not found in edit cache");
            }
            if (n2 == 3) {
                InputMiningData inputMiningData = modelType2.getInputMiningData();
                Boolean bl = (Boolean)object;
                if (bl.equals(Boolean.TRUE)) {
                    inputMiningData.setDataUsage(InputMiningDataType.AUTO);
                    inputMiningData.setMiningUsage(InputMiningDataType.AUTO);
                } else {
                    inputMiningData.setDataUsage(InputMiningDataType.MANUAL);
                    inputMiningData.setMiningUsage(InputMiningDataType.MANUAL);
                }
            } else if (n2 == 0) {
                modelType2.setName((String)object);
            }
            BuildEditPanel.this.setIsDirty(true);
        }

        public List<ModelType> getDataList() {
            return this._data;
        }
    }
}

