/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AlgorithmSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildNodeTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.DataUsagePanel;
import oracle.dmt.dataminer.workflow.dialog.build.ModelEditRecord;
import oracle.dmt.dataminer.workflow.dialog.build.ModelNameCellEditor;
import oracle.dmt.dataminer.workflow.dialog.build.NewModelPanel;
import oracle.dmt.dataminer.workflow.dialog.build.PerformanceSettingsPanel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AnomalyDetectionBuildNode;
import oracle.dmt.dataminer.workflow.model.AssociationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClusteringBuildNode;
import oracle.dmt.dataminer.workflow.model.FeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningData;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningDataType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controls.JTabbedPane2;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;

public class AdvancedSettingsPanel
extends JPanel {
    protected Context context;
    protected BuildNodeType metadataCopy;
    private boolean isStandalone = false;
    protected AbstractBuildNode workflowNode;
    private Map<String, AbstractSettingsPanel> panels;
    private HashMap<String, ModelEditRecord> modelEdits = new HashMap();
    private Map<String, Object> auxMetadata = new HashMap<String, Object>();
    private TransparentPanel _jDetailPanel;
    private TransparentPanel _jModelsTablePanel;
    private ComponentWithTitlebar<JComponent> _jModelsToolbar;
    private JSplitPane _jSplitter;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private GenericTable _jModelsTable = new ControlledSelectionGenericTable();
    private ModelsTableModel _modelsTblModel;
    private JTabbedPane _tabs = new CustomTab();
    private JButton _removeBtn;
    private JButton _addBtn;

    public AdvancedSettingsPanel(Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, List<String> list) {
        this.panels = new LinkedHashMap<String, AbstractSettingsPanel>();
        this.context = context;
        this.workflowNode = abstractBuildNode;
        this.metadataCopy = buildNodeType;
        if (buildNodeType != null) {
            this.metadataCopy = buildNodeType;
        } else {
            this.metadataCopy = (BuildNodeType)MetaDataHelper.copyMetadataObject(abstractBuildNode.getData());
            this.isStandalone = true;
        }
        this.initComponents();
        this.initRes();
        this.initUI(list);
    }

    public boolean isDirty() {
        return this.modelEdits.size() != 0;
    }

    private void initComponents() {
        this._jSplitter = new JSplitPane();
        this.jPanel1 = new JPanel();
        this._jModelsTablePanel = new TransparentPanel();
        this._jModelsToolbar = new ComponentWithTitlebar();
        this.jPanel2 = new JPanel();
        this._jDetailPanel = new TransparentPanel();
        this._jSplitter.setBorder(null);
        this._jSplitter.setDividerLocation(160);
        this._jSplitter.setDividerSize(3);
        this._jSplitter.setOrientation(0);
        this._jModelsToolbar.setPreferredSize(new Dimension(0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this._jModelsTablePanel);
        this._jModelsTablePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jModelsToolbar, -1, 617, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jModelsToolbar, -1, 160, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jModelsTablePanel, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jModelsTablePanel, -1, -1, Short.MAX_VALUE));
        this._jSplitter.setTopComponent(this.jPanel1);
        GroupLayout groupLayout3 = new GroupLayout((Container)this._jDetailPanel);
        this._jDetailPanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 617, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 370, Short.MAX_VALUE));
        GroupLayout groupLayout4 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jDetailPanel, -1, -1, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jDetailPanel, -1, -1, Short.MAX_VALUE));
        this._jSplitter.setBottomComponent(this.jPanel2);
        GroupLayout groupLayout5 = new GroupLayout(this);
        this.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jSplitter, GroupLayout.Alignment.TRAILING, -1, 617, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jSplitter, -1, 533, Short.MAX_VALUE));
    }

    protected void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        UIResourceHelper.setComponentText(hashMap);
        this.initHelp();
        this._jSplitter.setDividerLocation(120);
    }

    protected void initHelp() {
        if (this.workflowNode instanceof AssociationBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"association_node_edit_adv");
        } else if (this.workflowNode instanceof ClassificationBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"classification_node_edit_adv");
        } else if (this.workflowNode instanceof ClusteringBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"clustering_node_edit_adv");
        } else if (this.workflowNode instanceof RegressionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"regression_node_edit_adv");
        } else if (this.workflowNode instanceof AnomalyDetectionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"anomaly_node_edit_adv");
        } else if (this.workflowNode instanceof FeatureExtractionBuildNode) {
            HelpUtils.setHelpID((JComponent)this, (String)"feature_node_edit_adv");
        }
    }

    protected void initIconResources() {
    }

    protected void initUI(List<String> list) {
        DefaultTableModel defaultTableModel;
        this.initIconResources();
        JScrollPane jScrollPane = new JScrollPane((Component)this._jModelsTable);
        this._jModelsToolbar.setComponent((JComponent)jScrollPane);
        this._jModelsToolbar.setLabel(new JLabel(BuildEditorLrb.get("BUILD_MODEL_SETTINGS_LBL")));
        this.installModelActions();
        List<ModelType> list2 = MetaDataHelper.getModelsCollection(this.metadataCopy);
        String[] stringArray = new String[]{BuildEditorLrb.get("BUILD_MODEL_NAME"), BuildEditorLrb.get("BUILD_MODEL_ALGORITHM"), BuildEditorLrb.get("BUILD_MODEL_LAST_BUILT"), BuildEditorLrb.get("BUILD_MODEL_AUTO")};
        this._modelsTblModel = new ModelsTableModel(list2, stringArray);
        this._jModelsTable.setModel((TableModel)((Object)this._modelsTblModel));
        this._jModelsTable.setSorted(true);
        this._jModelsTable.setUpdateSelectionOnSort(true);
        this._jModelsTable.getTableHeader().setReorderingAllowed(false);
        this._jModelsTable.getColumnModel().getColumn(0).setCellEditor(new ModelNameCellEditor(this.context, this.getWorkflowModel(), this.metadataCopy));
        this._jModelsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                AdvancedSettingsPanel.this.handleModelSelectionChanged(listSelectionModel);
            }
        });
        this._jDetailPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        if (this.metadataCopy instanceof AssociationBuildNodeType) {
            this._jModelsTable.removeColumn(this._jModelsTable.getColumnModel().getColumn(3));
        } else {
            this.panels.put(BuildEditorLrb.get("DATA_USAGE"), new DataUsagePanel(this, this.context, this.workflowNode, this.metadataCopy, this.modelEdits));
        }
        this.panels.put(BuildEditorLrb.get("ALGO_SETTINGS"), new AlgorithmSettingsPanel(this, this.context, this.workflowNode, this.metadataCopy, this.modelEdits));
        if (this.metadataCopy instanceof ClassificationBuildNodeType) {
            this.panels.put(BuildEditorLrb.get("PERF_SETTINGS"), new PerformanceSettingsPanel(this, this.context, this.workflowNode, this.metadataCopy, this.modelEdits));
        }
        for (String string : this.panels.keySet()) {
            this._tabs.addTab(string, this.panels.get(string));
        }
        this._jDetailPanel.add((Component)this._tabs);
        Object object = new int[]{0};
        if (list != null && list.size() > 0) {
            object = new int[list.size()];
            int n = 0;
            for (int i = 0; i < this._modelsTblModel.getDataList().size(); ++i) {
                ModelType modelType = this._modelsTblModel.getDataList().get(i);
                if (!list.contains(modelType.getId())) continue;
                object[n++] = i;
            }
        }
        if (!(defaultTableModel = (DefaultTableModel)this._jModelsTable.getModel()).getDataVector().isEmpty()) {
            this._jModelsTable.setSelectedRowsInModel((int[])object);
        }
    }

    private WorkflowModel getWorkflowModel() {
        WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
        WorkflowModel workflowModel = null;
        try {
            workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return workflowModel;
    }

    public void handleModelMetadataChanged() {
        for (String string : this.panels.keySet()) {
            this.panels.get(string).handleModelMetadataChanged();
        }
    }

    public boolean canProceed() {
        boolean bl = true;
        ListSelectionModel listSelectionModel = this._jModelsTable.getSelectionModel();
        String string = BuildEditorLrb.get("PERF_SETTINGS");
        AbstractSettingsPanel abstractSettingsPanel = this.panels.get(string);
        if (abstractSettingsPanel != null && !abstractSettingsPanel.canProceed(listSelectionModel)) {
            return false;
        }
        for (String string2 : this.panels.keySet()) {
            AbstractSettingsPanel abstractSettingsPanel2 = this.panels.get(string2);
            if (abstractSettingsPanel != null && string2.equals(string) || abstractSettingsPanel2.canProceed(listSelectionModel)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void installModelActions() {
        ControlBar controlBar = new ControlBar();
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(BuildEditorLrb.get("MODELS_DELETE_TOOLTIP"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                int n;
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)BuildEditorLrb.get("REMOVE_MODELS_MSG"), (String)BuildEditorLrb.get("REMOVE_MODELS_TITLE"), null, (boolean)true)) {
                    return;
                }
                int[] nArray = AdvancedSettingsPanel.this._jModelsTable.getSelectedRows();
                int[] nArray2 = new int[nArray.length];
                for (n = 0; n < nArray.length; ++n) {
                    nArray2[n] = AdvancedSettingsPanel.this._jModelsTable.convertRowIndexToModel(nArray[n]);
                    object = AdvancedSettingsPanel.this._modelsTblModel.getDataList().get(nArray2[n]);
                    AdvancedSettingsPanel.this.addEditedModelRecord((ModelType)object, ModelEditRecord.DELETE);
                }
                AdvancedSettingsPanel.this._modelsTblModel.removeRows(nArray2);
                if (AdvancedSettingsPanel.this._modelsTblModel.getDataList().size() != 0) {
                    n = nArray[0] - 1 < 0 ? 0 : nArray[0] - 1;
                    n = AdvancedSettingsPanel.this._jModelsTable.convertRowIndexToModel(n);
                    object = new int[]{n};
                    AdvancedSettingsPanel.this._jModelsTable.setSelectedRowsInModel((int[])object);
                }
            }
        });
        controlBar.add((Component)this._removeBtn);
        this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setToolTipText(BuildEditorLrb.get("MODELS_ADD_TOOLTIP"));
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewModelDialog newModelDialog;
                if ((AdvancedSettingsPanel.this.metadataCopy instanceof ClassificationBuildNodeType || AdvancedSettingsPanel.this.metadataCopy instanceof RegressionBuildNodeType || AdvancedSettingsPanel.this.metadataCopy instanceof ClusteringBuildNodeType || AdvancedSettingsPanel.this.metadataCopy instanceof AnomalyDetectionBuildNodeType || AdvancedSettingsPanel.this.metadataCopy instanceof AssociationBuildNodeType || AdvancedSettingsPanel.this.metadataCopy instanceof FeatureExtractionBuildNodeType) && (newModelDialog = new NewModelDialog(WorkflowUtils.getInMemoryModelNames(AdvancedSettingsPanel.this.getWorkflowModel(), AdvancedSettingsPanel.this.metadataCopy))).invoke(AdvancedSettingsPanel.this.getContext(), AdvancedSettingsPanel.this.workflowNode)) {
                    ModelType modelType = newModelDialog.getNewModel();
                    AdvancedSettingsPanel.this.addEditedModelRecord(modelType, ModelEditRecord.NEW);
                    int[] nArray = new int[]{AdvancedSettingsPanel.this._modelsTblModel.addModel(modelType)};
                    AdvancedSettingsPanel.this._jModelsTable.setSelectedRowsInModel(nArray);
                }
            }
        });
        controlBar.add((Component)this._addBtn);
        ListSelectionModel listSelectionModel = this._jModelsTable.getSelectionModel();
        this._removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this._jModelsToolbar.setControlBar(controlBar);
    }

    protected List<ModelType> getSelectedModels() {
        ModelsTableModel modelsTableModel = this.getTableModel();
        List<ModelType> list = modelsTableModel.getDataList();
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        ModelsTableModel modelsTableModel2 = this.getTableModel();
        if (!modelsTableModel2.getDataVector().isEmpty()) {
            int[] nArray;
            for (int n : nArray = this._jModelsTable.getSelectedRowsInModel()) {
                ModelType modelType = list.get(n);
                arrayList.add(modelType);
            }
        }
        return arrayList;
    }

    public boolean isMultpleSelection() {
        return this._jModelsTable.getSelectedRowCount() > 1;
    }

    public boolean doWork() {
        TableCellEditor tableCellEditor;
        if (this._jModelsTable.isEditing() && !(tableCellEditor = this._jModelsTable.getCellEditor()).stopCellEditing()) {
            return false;
        }
        boolean bl = this.canProceed();
        if (!bl) {
            return bl;
        }
        if (!this.isDirty()) {
            return true;
        }
        HashMap<String, ModelType> hashMap = new HashMap<String, ModelType>();
        List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)this.workflowNode.getData());
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        for (ModelType modelType : list) {
            ModelType modelType2 = MetaDataHelper.findModelById(this.metadataCopy, modelType.getId());
            if (modelType2 == null || modelType2.getName().equals(modelType.getName())) continue;
            hashMap.put(modelType2.getName(), modelType);
            arrayList.add(modelType2);
        }
        if (bl && this.modelEdits.size() != 0) {
            Object object;
            Object object2;
            Iterator<Object> iterator = this.modelEdits.entrySet().iterator();
            boolean bl2 = false;
            boolean bl3 = false;
            while (iterator.hasNext()) {
                object2 = (Map.Entry)iterator.next();
                object = (ModelEditRecord)object2.getValue();
                if (((ModelEditRecord)object).isNew()) {
                    bl = MetaDataHelper.addModel(this.metadataCopy, ((ModelEditRecord)object).getModel());
                    bl3 = true;
                } else if (((ModelEditRecord)object).getEditType() == ModelEditRecord.CHANGE) {
                    bl = MetaDataHelper.replaceModel(this.metadataCopy, ((ModelEditRecord)object).getModel(), ((ModelEditRecord)object).getOrigName());
                    bl2 = true;
                } else if (((ModelEditRecord)object).getEditType() == ModelEditRecord.DELETE) {
                    bl = MetaDataHelper.removeModel(this.metadataCopy, ((ModelEditRecord)object).getModel());
                }
                if (bl) continue;
                break;
            }
            if (bl && this.isStandalone) {
                try {
                    CommandProcessor.getInstance().beginTrans("Edit Data Usage");
                    object2 = (OdmrSDMUndoFilter)this.workflowNode.getUndoFilter();
                    ((OdmrSDMUndoFilter)((Object)object2)).prepareUndo(this.workflowNode, this.context, "nodetype", this.metadataCopy);
                    if (hashMap.size() > 0) {
                        object = MetaDataHelper.getModelsCollection(this.metadataCopy, this.context);
                        HashMap<String, RefModelType> hashMap2 = new HashMap<String, RefModelType>();
                        Iterator iterator2 = object.iterator();
                        while (iterator2.hasNext()) {
                            RefModelType refModelType = (RefModelType)iterator2.next();
                            if (!hashMap.containsKey(refModelType.getName())) continue;
                            hashMap2.put(((ModelType)hashMap.get(refModelType.getName())).getName(), refModelType);
                        }
                        this.workflowNode.refactorChildModelReferences(hashMap2, false);
                    }
                    this.workflowNode.validateAfterEdit();
                    CommandProcessor.getInstance().endTrans();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    bl = false;
                    CommandProcessor.getInstance().abortTrans();
                }
            }
        }
        return bl;
    }

    public ModelType findEditedModel(ModelType modelType) {
        ModelEditRecord modelEditRecord = this.modelEdits.get(modelType.getName());
        ModelType modelType2 = null;
        if (modelEditRecord != null) {
            modelType2 = modelEditRecord.getModel();
        }
        return modelType2;
    }

    protected ModelEditRecord addEditedModelRecord(ModelType modelType, int n) {
        ModelEditRecord modelEditRecord = this.modelEdits.get(modelType.getName());
        if (modelEditRecord != null && modelEditRecord.isNew() && ModelEditRecord.DELETE == n) {
            return this.modelEdits.remove(modelType.getName());
        }
        if (modelEditRecord != null && modelEditRecord.getEditType() == ModelEditRecord.DELETE) {
            return modelEditRecord;
        }
        if (modelEditRecord != null) {
            throw new RuntimeException("Contract violation.  ModelEditRecord being added more than once.  Use findEditedModel()");
        }
        ModelEditRecord modelEditRecord2 = new ModelEditRecord(n, modelType);
        if (ModelEditRecord.NEW == n || modelEditRecord != null && modelEditRecord.isNew()) {
            modelEditRecord2.setIsNew();
        }
        this.modelEdits.put(modelType.getName(), modelEditRecord2);
        return modelEditRecord2;
    }

    protected boolean canHandleModelSelectionChange() {
        boolean bl;
        block1: {
            String string;
            bl = true;
            ListSelectionModel listSelectionModel = this._jModelsTable.getSelectionModel();
            if (listSelectionModel.isSelectionEmpty()) break block1;
            Iterator<String> iterator = this.panels.keySet().iterator();
            while (iterator.hasNext() && (bl = this.panels.get(string = iterator.next()).canHandleModelSelectionChange(this._jModelsTable.getSelectionModel()))) {
            }
        }
        return bl;
    }

    protected boolean handleModelSelectionChanged(ListSelectionModel listSelectionModel) {
        if (listSelectionModel.getValueIsAdjusting()) {
            return false;
        }
        this._removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        if (listSelectionModel.isSelectionEmpty()) {
            for (String string : this.panels.keySet()) {
                this.panels.get(string).loadEmptySelectionUI();
            }
        } else {
            for (String string : this.panels.keySet()) {
                this.panels.get(string).handleModelSelectionChanged(this._jModelsTable.getSelectionModel());
            }
        }
        return true;
    }

    protected ModelsTableModel getTableModel() {
        return (ModelsTableModel)((Object)this._jModelsTable.getModel());
    }

    protected GenericTable getModelsTable() {
        return this._jModelsTable;
    }

    private void issueModelMetadataChanged() {
        this.handleModelMetadataChanged();
    }

    public AbstractBuildNode getWorkflowNode() {
        return this.workflowNode;
    }

    public Context getContext() {
        return this.context;
    }

    public BuildNodeType getMetadataCopy() {
        return this.metadataCopy;
    }

    public Object getAuxMetadata(String string) {
        return this.auxMetadata.get(string);
    }

    public void putAuxMetadata(String string, Object object) {
        this.auxMetadata.put(string, object);
    }

    protected class NewModelDialog {
        protected JEWTDialog _dlg;
        protected String wizName = "addModel";
        private ModelType newModel;
        private Collection<String> wfInMemoryModelNames;

        public ModelType getNewModel() {
            return this.newModel;
        }

        public NewModelDialog(Collection<String> collection) {
            this.wfInMemoryModelNames = collection;
        }

        protected JEWTDialog buildDialog(Context context, AbstractBuildNode abstractBuildNode) {
            NewModelPanel newModelPanel = new NewModelPanel(context, abstractBuildNode, this.wfInMemoryModelNames);
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            int n = 7;
            JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
            jEWTDialog.setContent((Component)newModelPanel);
            jEWTDialog.setTitle(BuildEditorLrb.get("NEW_MODEL_DIALOG_TITLE"));
            return jEWTDialog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invoke(Context context, AbstractBuildNode abstractBuildNode) {
            boolean bl = false;
            try {
                JEWTDialog jEWTDialog = this.buildDialog(context, abstractBuildNode);
                jEWTDialog.setResizable(true);
                final NewModelPanel newModelPanel = (NewModelPanel)jEWTDialog.getContent();
                jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                        String string = propertyChangeEvent.getPropertyName();
                        Object object = propertyChangeEvent.getNewValue();
                        if (string.equals("closed") && Boolean.TRUE.equals(object)) {
                            if (!newModelPanel.doWork()) {
                                throw new PropertyVetoException("panel", propertyChangeEvent);
                            }
                            NewModelDialog.this.newModel = newModelPanel.getNewModel();
                        }
                    }
                });
                this._dlg = jEWTDialog;
                if (jEWTDialog != null) {
                    bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_TITLE"), (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_MSG"), null);
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
            return bl;
        }

        protected void cancel() {
        }
    }

    class ModelsTableModel
    extends GenericBaseTableModel
    implements BuildNodeTableModel {
        private List<ModelType> _data;
        public static final int NAME = 0;
        public static final int ALGORITHM = 1;
        public static final int MODEL_CREATED_ON = 2;
        public static final int AUTO = 3;
        public static final int COLUMN_COUNT = 4;

        public ModelsTableModel(List<ModelType> list, String[] stringArray) {
            this._data = list;
            this.setColumnIdentifiers(stringArray);
            this.setRowCount(this._data.size());
            this.setColumnCount(4);
        }

        public int[] getIndexesOf(List<String> list) {
            Vector<Integer> vector = new Vector<Integer>();
            for (String string : list) {
                for (int i = 0; i < this._data.size(); ++i) {
                    ModelType modelType = this._data.get(i);
                    if (!modelType.getName().equals(string)) continue;
                    vector.add(i);
                }
            }
            if (vector.size() == 0) {
                return new int[0];
            }
            Object object = new int[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                object[i] = (Integer)vector.get(i);
            }
            return object;
        }

        public Class<?> getColumnClass(int n) {
            if (n == 3) {
                return Boolean.class;
            }
            if (n == 2) {
                return XMLGregorianCalendar.class;
            }
            return String.class;
        }

        public void reload(List<ModelType> list) {
            this._data = list;
            this.setRowCount(this._data.size());
            this.fireTableDataChanged();
        }

        public int addModel(ModelType modelType) {
            this._data.add(modelType);
            int n = this._data.size() - 1;
            this.setRowCount(this._data.size());
            this.fireTableRowsInserted(n, n);
            return this._data.size() - 1;
        }

        public void removeRows(int[] nArray) {
            ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(this._data.get(nArray[i]));
            }
            for (ModelType modelType : arrayList) {
                int n = this._data.indexOf(modelType);
                this.fireTableRowsDeleted(n, n);
                this.removeModel(n);
            }
        }

        public void removeModel(int n) {
            this._data.remove(n);
            this.setRowCount(this._data.size());
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ModelType modelType = this._data.get(n);
            Object object = null;
            ModelType modelType2 = AdvancedSettingsPanel.this.findEditedModel(modelType);
            if (modelType2 == null) {
                modelType2 = modelType;
            }
            switch (n2) {
                case 0: {
                    object = modelType2.getName();
                    break;
                }
                case 1: {
                    object = MetaDataHelper.getAlgorithmName(modelType2);
                    break;
                }
                case 2: {
                    XMLGregorianCalendar xMLGregorianCalendar = modelType2.getCreationDate();
                    if (xMLGregorianCalendar != null) {
                        object = TimeUtils.formatDate(xMLGregorianCalendar);
                        break;
                    }
                    object = null;
                    break;
                }
                case 3: {
                    if (modelType2.getInputMiningData().getDataUsage().equals((Object)InputMiningDataType.AUTO)) {
                        object = Boolean.TRUE;
                        break;
                    }
                    object = Boolean.FALSE;
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0 || n2 == 3;
        }

        public void setValueAt(Object object, int n, int n2) {
            ModelType modelType = this._data.get(n);
            ModelType modelType2 = AdvancedSettingsPanel.this.findEditedModel(modelType);
            if (modelType2 == null) {
                modelType2 = AdvancedSettingsPanel.this.addEditedModelRecord(modelType, ModelEditRecord.CHANGE).getModel();
            }
            if (n2 == 3) {
                InputMiningData inputMiningData = modelType2.getInputMiningData();
                Boolean bl = (Boolean)object;
                if (bl.equals(Boolean.TRUE)) {
                    inputMiningData.setDataUsage(InputMiningDataType.AUTO);
                    inputMiningData.setMiningUsage(InputMiningDataType.AUTO);
                } else {
                    inputMiningData.setDataUsage(InputMiningDataType.MANUAL);
                    inputMiningData.setMiningUsage(InputMiningDataType.MANUAL);
                }
                AdvancedSettingsPanel.this.issueModelMetadataChanged();
            } else if (n2 == 0) {
                modelType2.setName((String)object);
            }
        }

        @Override
        public String getOriginalModelName(int n) {
            String string = null;
            ModelType modelType = this._data.get(n);
            ModelType modelType2 = MetaDataHelper.findModelById((BuildNodeType)AdvancedSettingsPanel.this.workflowNode.getData(), modelType.getId());
            if (modelType2 != null) {
                string = modelType2.getName();
            }
            return string;
        }

        public List<ModelType> getDataList() {
            return this._data;
        }
    }

    public class MenuAction
    extends AbstractAction {
        public MenuAction(String string, String string2) {
            super(string);
            this.putValue("ActionCommandKey", string2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class CustomTab
    extends JTabbedPane2 {
        CustomTab() {
        }

        public void setSelectedIndex(int n) {
            if (AdvancedSettingsPanel.this.canHandleModelSelectionChange()) {
                super.setSelectedIndex(n);
                return;
            }
        }
    }

    class ControlledSelectionGenericTable
    extends GenericTable {
        ControlledSelectionGenericTable() {
        }

        public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
            if (AdvancedSettingsPanel.this.canHandleModelSelectionChange()) {
                super.changeSelection(n, n2, bl, bl2);
            }
        }
    }
}

