/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.apply;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyModelsPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyOutputColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class ApplyOutputPanel
extends AbstractDialogPanel {
    private ApplyOutputColumnsType _applyOutputColumns;
    private ApplyModelsPanel _parent;
    private boolean _editMode;
    private boolean _dirty = false;
    private ApplyOutputColumnsType.OutputColumn _output;
    private List<AbstractNode> _modelNodes;
    private AbstractNode _selectModelNode;
    private RefModelType _selectModel;
    private String _selectPredictionFunc;
    private ApplyNode.Parameters _selectFuncParameters;
    private boolean _loading = false;
    private static final String SELECT_A_NODE = DialogsLrb.get("APPLY_SELECT_NODE");
    private static final String SELECT_A_MODEL = DialogsLrb.get("APPLY_SELECT_MODEL");
    private static final String SELECT_A_FUNCTION = DialogsLrb.get("APPLY_SELECT_FUNCTION");
    private static final String MOST_LIKELY = DialogsLrb.get("APPLY_OPTION_MOST_LIKELY");
    private JCheckBox jAutoGenCheckBox;
    private JLabel jColumnLabel;
    private JTextField jColumnTextField;
    private JLabel jFillerLabel1;
    private JComboBox jFunctionComboBox;
    private JLabel jFunctionLabel;
    private JComboBox jModelComboBox;
    private JLabel jModelLabel;
    private JComboBox jNodeComboBox;
    private JLabel jNodeLabel;
    private JPanel jParamsPanel;
    private NumberTextField jConfidenceField;
    private JComboBox jTargetComboBox;
    private JCheckBox jBestNCheckBox;
    private JComboBox jNValueComboBox;
    private JCheckBox jCutOffCheckBox;
    private NumberTextField jCutOffTextField;
    private JComboBox jClusterComboBox;
    private JComboBox jFeatureComboBox;

    public ApplyOutputPanel(Context context, ApplyModelsPanel applyModelsPanel, ApplyOutputColumnsType applyOutputColumnsType, boolean bl) {
        super(context, applyModelsPanel.getData());
        Object object;
        assert (context != null) : "Context must not be null.";
        this._applyOutputColumns = applyOutputColumnsType;
        this._parent = applyModelsPanel;
        this._editMode = bl;
        if (this._editMode) {
            object = applyModelsPanel.getTableWithToolbar().getSelectedRowsInModel();
            int n = applyModelsPanel.getTableWithToolbar().convertRowToModelIndex(object[0]);
            this._output = (ApplyOutputColumnsType.OutputColumn)this._applyOutputColumns.getOutputColumn().get(n);
        } else {
            this._output = new ApplyOutputColumnsType.OutputColumn();
        }
        object = (ApplyNode)applyModelsPanel.getData();
        this._modelNodes = ((ApplyNode)object).findApplyModelNodes();
        this._selectModelNode = null;
        this._selectModel = null;
        this._selectPredictionFunc = null;
        this._selectFuncParameters = null;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("APPLY_OUTPUT_AUTO"), this.jAutoGenCheckBox);
        hashMap.put(DialogsLrb.get("APPLY_OUTPUT_COLUMN"), this.jColumnLabel);
        hashMap.put(DialogsLrb.get("APPLY_OUTPUT_NODE"), this.jNodeLabel);
        hashMap.put(DialogsLrb.get("APPLY_OUTPUT_MODEL"), this.jModelLabel);
        hashMap.put(DialogsLrb.get("APPLY_OUTPUT_FUNCTION"), this.jFunctionLabel);
        UIResourceHelper.setComponentText(hashMap);
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"apply_output");
        this._loading = true;
        this.jAutoGenCheckBox.setSelected(true);
        this.jColumnTextField.setEnabled(!this.jAutoGenCheckBox.isSelected());
        this.jNodeComboBox.setEnabled(!this._editMode);
        this.jModelComboBox.setEnabled(!this._editMode);
        if (this._editMode) {
            Object object;
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            Iterator<AbstractNode> iterator = this._modelNodes.iterator();
            this._selectModelNode = null;
            while (iterator.hasNext()) {
                AbstractNode object2 = iterator.next();
                if (this._output.getModel().getNodeId().compareTo(object2.getData().getId()) != 0) continue;
                defaultComboBoxModel.addElement(object2.getData().getName());
                this._selectModelNode = object2;
                break;
            }
            this.jNodeComboBox.setModel(defaultComboBoxModel);
            this.jNodeComboBox.setSelectedItem(this._selectModelNode.getData().getName());
            List<RefModelType> object2 = this.getRefModels(this._selectModelNode);
            Iterator<RefModelType> iterator2 = object2.iterator();
            this._selectModel = null;
            defaultComboBoxModel = new DefaultComboBoxModel();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                if (this._output.getModel().getName().compareTo(object.getName()) != 0) continue;
                if (this._parent.isShowSchema()) {
                    defaultComboBoxModel.addElement(object.getSchema() + "." + object.getName());
                } else {
                    defaultComboBoxModel.addElement(object.getName());
                }
                this._selectModel = object;
                break;
            }
            this.jModelComboBox.setModel(defaultComboBoxModel);
            object = null;
            object = this._parent.isShowSchema() ? this._selectModel.getSchema() + "." + this._selectModel.getName() : this._selectModel.getName();
            this.jModelComboBox.setSelectedItem(object);
            String[] stringArray = this.getPredictionFunctions(this._selectModel);
            defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
            this.jFunctionComboBox.setModel(defaultComboBoxModel);
            this._selectPredictionFunc = ApplyNode.getPredictionFunction(this._output);
            this.jFunctionComboBox.setSelectedItem(this._selectPredictionFunc);
            this._selectFuncParameters = ApplyNode.getPredictionFunctionParameters(this.getContext(), this._output);
            this.jColumnTextField.setText(this._selectFuncParameters.getColumn());
            this.populateParamUI(this._selectFuncParameters);
        } else {
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            if (this._modelNodes.size() > 1) {
                defaultComboBoxModel.addElement(SELECT_A_NODE);
            }
            for (AbstractNode abstractNode : this._modelNodes) {
                defaultComboBoxModel.addElement(abstractNode.getData().getName());
            }
            this.jNodeComboBox.setModel(defaultComboBoxModel);
            if (this._modelNodes.size() > 1) {
                this.jNodeComboBox.setSelectedItem(SELECT_A_NODE);
                defaultComboBoxModel = new DefaultComboBoxModel();
                defaultComboBoxModel.addElement(SELECT_A_MODEL);
                this.jModelComboBox.setModel(defaultComboBoxModel);
                this.jModelComboBox.setSelectedItem(SELECT_A_MODEL);
                defaultComboBoxModel = new DefaultComboBoxModel();
                defaultComboBoxModel.addElement(SELECT_A_FUNCTION);
                this.jFunctionComboBox.setModel(defaultComboBoxModel);
                this.jFunctionComboBox.setSelectedItem(SELECT_A_FUNCTION);
            } else {
                String[] stringArray;
                this._selectModelNode = this._modelNodes.get(0);
                List<RefModelType> list = this.getRefModels(this._selectModelNode);
                Iterator<RefModelType> iterator = list.iterator();
                defaultComboBoxModel = new DefaultComboBoxModel();
                if (list.size() > 1) {
                    defaultComboBoxModel.addElement(SELECT_A_MODEL);
                }
                while (iterator.hasNext()) {
                    stringArray = iterator.next();
                    if (this._parent.isShowSchema()) {
                        defaultComboBoxModel.addElement(stringArray.getSchema() + "." + stringArray.getName());
                        continue;
                    }
                    defaultComboBoxModel.addElement(stringArray.getName());
                }
                this.jModelComboBox.setModel(defaultComboBoxModel);
                if (list.size() > 1) {
                    this.jModelComboBox.setSelectedItem(SELECT_A_MODEL);
                    defaultComboBoxModel = new DefaultComboBoxModel();
                    defaultComboBoxModel.addElement(SELECT_A_FUNCTION);
                    this.jFunctionComboBox.setModel(defaultComboBoxModel);
                    this.jFunctionComboBox.setSelectedItem(SELECT_A_FUNCTION);
                } else {
                    this._selectModel = list.get(0);
                    stringArray = this.getPredictionFunctions(this._selectModel);
                    DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>(stringArray);
                    if (stringArray.length > 1) {
                        defaultComboBoxModel2.insertElementAt(SELECT_A_FUNCTION, 0);
                    }
                    this.jFunctionComboBox.setModel(defaultComboBoxModel2);
                    if (stringArray.length > 1) {
                        this.jFunctionComboBox.setSelectedItem(SELECT_A_FUNCTION);
                    } else {
                        this._selectPredictionFunc = stringArray[0];
                        this._selectFuncParameters = this.getFunctionParameters(this._selectModel, this._selectPredictionFunc);
                        if (this.jAutoGenCheckBox.isSelected()) {
                            String string = this.generateUniqueColumnName(this._selectPredictionFunc, this._selectModel.getName(), null);
                            this.jColumnTextField.setText(string);
                        }
                        this.populateParamUI(this._selectFuncParameters);
                    }
                }
            }
            this.jParamsPanel.setVisible(false);
            this.revalidate();
        }
        this._loading = false;
    }

    private List<RefModelType> getRefModels(AbstractNode abstractNode) {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        ModelProvider modelProvider = (ModelProvider)((Object)abstractNode);
        List<RefModelType> list = modelProvider.getOutputModels();
        for (RefModelType refModelType : list) {
            if (!refModelType.isUseForOutput()) continue;
            arrayList.add(refModelType);
        }
        return arrayList;
    }

    private String[] getPredictionFunctions(RefModelType refModelType) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (refModelType.getMiningFunction() == MiningFunctionType.ANOMALY_DETECTION) {
            arrayList.add(ServerConstants.ApplyPredictionFunctions.PREDICTION);
            arrayList.add(ServerConstants.ApplyPredictionFunctions.PREDICTION_PROBABILITY);
            arrayList.add(ServerConstants.ApplyPredictionFunctions.PREDICTION_SET);
        } else if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
            arrayList.add(ServerConstants.ApplyPredictionFunctions.PREDICTION);
            arrayList.add(ServerConstants.ApplyPredictionFunctions.PREDICTION_PROBABILITY);
            if (ApplyNode.doesModelCostExist((ApplyNode)this._parent.getData(), refModelType)) {
                arrayList.add(ServerConstants.ApplyPredictionFunctions.PREDICTION_COST);
            }
            arrayList.add(ServerConstants.ApplyPredictionFunctions.PREDICTION_SET);
            if (refModelType.getMiningAlgorithm() == MiningAlgorithmType.DECISION_TREE) {
                arrayList.add(ServerConstants.ApplyPredictionFunctions.PREDICTION_DETAILS);
            }
            if (refModelType.getMiningAlgorithm() == MiningAlgorithmType.GENERALIZED_LINEAR_MODEL) {
                arrayList.add(ServerConstants.ApplyPredictionFunctions.PREDICTION_BOUNDS_LOWER);
                arrayList.add(ServerConstants.ApplyPredictionFunctions.PREDICTION_BOUNDS_UPPER);
            }
        } else if (refModelType.getMiningFunction() == MiningFunctionType.CLUSTERING) {
            arrayList.add(ServerConstants.ApplyPredictionFunctions.CLUSTER_ID);
            arrayList.add(ServerConstants.ApplyPredictionFunctions.CLUSTER_PROBABILITY);
            arrayList.add(ServerConstants.ApplyPredictionFunctions.CLUSTER_SET);
        } else if (refModelType.getMiningFunction() == MiningFunctionType.FEATURE_EXTRACTION) {
            arrayList.add(ServerConstants.ApplyPredictionFunctions.FEATURE_ID);
            arrayList.add(ServerConstants.ApplyPredictionFunctions.FEATURE_VALUE);
            arrayList.add(ServerConstants.ApplyPredictionFunctions.FEATURE_SET);
        } else if (refModelType.getMiningFunction() == MiningFunctionType.REGRESSION) {
            arrayList.add(ServerConstants.ApplyPredictionFunctions.PREDICTION);
            if (refModelType.getMiningAlgorithm() == MiningAlgorithmType.GENERALIZED_LINEAR_MODEL) {
                arrayList.add(ServerConstants.ApplyPredictionFunctions.PREDICTION_BOUNDS_LOWER);
                arrayList.add(ServerConstants.ApplyPredictionFunctions.PREDICTION_BOUNDS_UPPER);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    private ApplyNode.Parameters getFunctionParameters(RefModelType refModelType, String string) {
        ApplyNode.Parameters parameters = null;
        if (string == ServerConstants.ApplyPredictionFunctions.PREDICTION) {
            if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
                boolean bl = ApplyNode.doesModelCostExist((ApplyNode)this._parent.getData(), refModelType);
                parameters = new ApplyNode.Prediction(null, bl ? "Model" : "None", null);
            } else if (refModelType.getMiningFunction() == MiningFunctionType.ANOMALY_DETECTION || refModelType.getMiningFunction() == MiningFunctionType.CLUSTERING || refModelType.getMiningFunction() == MiningFunctionType.FEATURE_EXTRACTION || refModelType.getMiningFunction() == MiningFunctionType.REGRESSION) {
                parameters = new ApplyNode.Prediction(null, "None", null);
            }
        } else if (string == ServerConstants.ApplyPredictionFunctions.PREDICTION_DETAILS) {
            parameters = new ApplyNode.PredictionDetails(null);
        } else if (string == ServerConstants.ApplyPredictionFunctions.CLUSTER_ID) {
            parameters = new ApplyNode.ClusterId(null);
        } else if (string == ServerConstants.ApplyPredictionFunctions.FEATURE_ID) {
            parameters = new ApplyNode.FeatureId(null);
        } else if (string == ServerConstants.ApplyPredictionFunctions.PREDICTION_BOUNDS_LOWER) {
            if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
                Vector<Object> vector = null;
                if (refModelType.isIsModelBuilt()) {
                    vector = ApplyNode.getPredictionValues(this.getContext(), refModelType.getSchema(), refModelType.getName());
                }
                parameters = new ApplyNode.ClassPredictionLowerBounds(null, null, vector, null);
            } else {
                parameters = new ApplyNode.RegressPredictionLowerBounds(null, null);
            }
        } else if (string == ServerConstants.ApplyPredictionFunctions.PREDICTION_BOUNDS_UPPER) {
            if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
                Vector<Object> vector = null;
                if (refModelType.isIsModelBuilt()) {
                    vector = ApplyNode.getPredictionValues(this.getContext(), refModelType.getSchema(), refModelType.getName());
                }
                parameters = new ApplyNode.ClassPredictionUpperBounds(null, null, vector, null);
            } else {
                parameters = new ApplyNode.RegressPredictionUpperBounds(null, null);
            }
        } else if (string == ServerConstants.ApplyPredictionFunctions.PREDICTION_COST) {
            Vector<Object> vector = null;
            if (refModelType.isIsModelBuilt()) {
                vector = ApplyNode.getPredictionValues(this.getContext(), refModelType.getSchema(), refModelType.getName());
            }
            parameters = new ApplyNode.PredictionCost(null, vector, null, "Model", null);
        } else if (string == ServerConstants.ApplyPredictionFunctions.PREDICTION_PROBABILITY) {
            Vector<Object> vector = null;
            if (refModelType.isIsModelBuilt()) {
                vector = ApplyNode.getPredictionValues(this.getContext(), refModelType.getSchema(), refModelType.getName());
            }
            parameters = new ApplyNode.PredictionProbability(null, vector, null);
        } else if (string == ServerConstants.ApplyPredictionFunctions.PREDICTION_SET) {
            boolean bl;
            BigInteger bigInteger = BigInteger.ONE;
            int n = 1;
            if (refModelType.isIsModelBuilt()) {
                Vector<Object> vector = ApplyNode.getPredictionValues(this.getContext(), refModelType.getSchema(), refModelType.getName());
                n = vector.size();
                bigInteger = new BigInteger(vector.size() + "");
            }
            parameters = new ApplyNode.PredictionSet(true, bigInteger, n, false, null, false, null, null, (bl = ApplyNode.doesModelCostExist((ApplyNode)this._parent.getData(), refModelType)) ? "Model" : "None", null);
        } else if (string == ServerConstants.ApplyPredictionFunctions.CLUSTER_PROBABILITY) {
            Vector<Object> vector = null;
            if (refModelType.isIsModelBuilt()) {
                vector = ApplyNode.getClusterIds(this.getContext(), refModelType.getSchema(), refModelType.getName());
            }
            parameters = new ApplyNode.ClusterProbability(null, vector, null);
        } else if (string == ServerConstants.ApplyPredictionFunctions.CLUSTER_SET) {
            BigInteger bigInteger = BigInteger.ONE;
            int n = 1;
            if (refModelType.isIsModelBuilt()) {
                Vector<Object> vector = ApplyNode.getClusterIds(this.getContext(), refModelType.getSchema(), refModelType.getName());
                n = vector.size();
                bigInteger = new BigInteger(vector.size() + "");
            }
            parameters = new ApplyNode.ClusterSet(true, bigInteger, n, false, null, null);
        } else if (string == ServerConstants.ApplyPredictionFunctions.FEATURE_VALUE) {
            Vector<Object> vector = null;
            if (refModelType.isIsModelBuilt()) {
                vector = ApplyNode.getFeatureIds(this.getContext(), refModelType.getSchema(), refModelType.getName());
            }
            parameters = new ApplyNode.FeatureValue(null, vector, null);
        } else if (string == ServerConstants.ApplyPredictionFunctions.FEATURE_SET) {
            BigInteger bigInteger = BigInteger.ONE;
            int n = 1;
            if (refModelType.isIsModelBuilt()) {
                Vector<Object> vector = ApplyNode.getFeatureIds(this.getContext(), refModelType.getSchema(), refModelType.getName());
                n = vector.size();
                bigInteger = new BigInteger(vector.size() + "");
            }
            parameters = new ApplyNode.FeatureSet(true, bigInteger, n, false, null, null);
        }
        return parameters;
    }

    private String generateUniqueColumnName(String string, String string2, String string3) {
        String string4 = null;
        if (string == ServerConstants.ApplyPredictionFunctions.PREDICTION) {
            string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("PRED", string2, string3, false);
        } else if (string == ServerConstants.ApplyPredictionFunctions.PREDICTION_BOUNDS_LOWER) {
            string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("PBLW", string2, string3, false);
        } else if (string == ServerConstants.ApplyPredictionFunctions.PREDICTION_BOUNDS_UPPER) {
            string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("PBUP", string2, string3, false);
        } else if (string == ServerConstants.ApplyPredictionFunctions.PREDICTION_PROBABILITY) {
            string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("PROB", string2, string3, false);
        } else if (string == ServerConstants.ApplyPredictionFunctions.PREDICTION_COST) {
            string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("PCST", string2, string3, false);
        } else if (string == ServerConstants.ApplyPredictionFunctions.PREDICTION_SET) {
            string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("PSET", string2, string3, false);
        } else if (string == ServerConstants.ApplyPredictionFunctions.PREDICTION_DETAILS) {
            string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("PDET", string2, string3, false);
        } else if (string == ServerConstants.ApplyPredictionFunctions.CLUSTER_ID) {
            string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("CLID", string2, string3, false);
        } else if (string == ServerConstants.ApplyPredictionFunctions.CLUSTER_PROBABILITY) {
            string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("PROB", string2, string3, false);
        } else if (string == ServerConstants.ApplyPredictionFunctions.CLUSTER_SET) {
            string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("CSET", string2, string3, false);
        } else if (string == ServerConstants.ApplyPredictionFunctions.FEATURE_ID) {
            string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("FEID", string2, string3, false);
        } else if (string == ServerConstants.ApplyPredictionFunctions.FEATURE_VALUE) {
            string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("FVAL", string2, string3, false);
        } else if (string == ServerConstants.ApplyPredictionFunctions.FEATURE_SET) {
            string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("FSET", string2, string3, false);
        }
        return string4;
    }

    private void populateParamUI(ApplyNode.Parameters parameters) {
        boolean bl = true;
        this.jParamsPanel.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (parameters instanceof ApplyNode.ClassPredictionLowerBounds || parameters instanceof ApplyNode.ClassPredictionUpperBounds || parameters instanceof ApplyNode.RegressPredictionLowerBounds || parameters instanceof ApplyNode.RegressPredictionUpperBounds) {
            JLabel jLabel;
            JLabel jLabel2 = new JLabel();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(8, 10, 6, 0);
            this.jParamsPanel.add((Component)jLabel2, gridBagConstraints);
            ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.jConfidenceField, (String)DialogsLrb.get("APPLY_OUTPUT_CONFIDENCE"));
            jLabel2.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_CONFIDENCE");
            Double d = ((ApplyNode.DefaultPredictionBounds)parameters).getConfidence();
            this.jConfidenceField = new NumberTextField();
            this.jConfidenceField.setSigned(false);
            this.jConfidenceField.setDataType(Double.class);
            this.jConfidenceField.setNumber((Number)(d * 100.0));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(8, 8, 6, 10);
            this.jParamsPanel.add((Component)this.jConfidenceField, gridBagConstraints);
            this.jConfidenceField.setToolTipText(DialogsLrb.get("PAGE_OUTPUT_MOST_LIKELY_BOUNDS_CONFIDENCE_TIP"));
            if (parameters instanceof ApplyNode.ClassPredictionLowerBounds || parameters instanceof ApplyNode.ClassPredictionUpperBounds) {
                jLabel = new JLabel();
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(0, 10, 6, 0);
                this.jParamsPanel.add((Component)jLabel, gridBagConstraints);
                ResourceUtils.resLabel((JLabel)jLabel, (Component)this.jTargetComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_TARGET"));
                jLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_TARGET");
                DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<String>();
                Vector<Object> vector = ((ApplyNode.ClassPredictionBounds)parameters).getTargetValues();
                if (vector != null) {
                    defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
                }
                defaultComboBoxModel.insertElementAt(MOST_LIKELY, 0);
                this.jTargetComboBox = new JComboBox(defaultComboBoxModel);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 0.5;
                gridBagConstraints.insets = new Insets(0, 8, 6, 10);
                this.jParamsPanel.add((Component)this.jTargetComboBox, gridBagConstraints);
                this.jTargetComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (ApplyOutputPanel.this._loading) {
                            return;
                        }
                        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                        Object object = jComboBox.getSelectedItem();
                        if (object == MOST_LIKELY) {
                            object = null;
                        }
                        if (ApplyOutputPanel.this.jAutoGenCheckBox.isSelected()) {
                            String string = ApplyOutputPanel.this.generateUniqueColumnName(ApplyOutputPanel.this._selectPredictionFunc, ApplyOutputPanel.this._selectModel.getName(), object != null ? object.toString() : null);
                            ApplyOutputPanel.this.jColumnTextField.setText(string);
                        }
                    }
                });
                Object object = ((ApplyNode.ClassPredictionBounds)parameters).getSelectedTarget();
                if (object == null) {
                    this.jTargetComboBox.setSelectedItem(MOST_LIKELY);
                } else {
                    this.jTargetComboBox.setSelectedItem(object);
                }
            }
            jLabel = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.5;
            this.jParamsPanel.add((Component)jLabel, gridBagConstraints);
        } else if (parameters instanceof ApplyNode.PredictionCost) {
            JLabel jLabel = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(8, 10, 6, 0);
            this.jParamsPanel.add((Component)jLabel, gridBagConstraints);
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.jTargetComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_TARGET"));
            jLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_TARGET");
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(((ApplyNode.PredictionCost)parameters).getTargetValues());
            this.jTargetComboBox = new JComboBox<Object>(defaultComboBoxModel);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.insets = new Insets(8, 8, 6, 10);
            this.jParamsPanel.add((Component)this.jTargetComboBox, gridBagConstraints);
            this.jTargetComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ApplyOutputPanel.this._loading) {
                        return;
                    }
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Object object = jComboBox.getSelectedItem();
                    if (object == MOST_LIKELY) {
                        object = null;
                    }
                    if (ApplyOutputPanel.this.jAutoGenCheckBox.isSelected()) {
                        String string = ApplyOutputPanel.this.generateUniqueColumnName(ApplyOutputPanel.this._selectPredictionFunc, ApplyOutputPanel.this._selectModel.getName(), object != null ? object.toString() : null);
                        ApplyOutputPanel.this.jColumnTextField.setText(string);
                    }
                }
            });
            Object object = ((ApplyNode.PredictionCost)parameters).getSelectedTarget();
            defaultComboBoxModel.insertElementAt(MOST_LIKELY, 0);
            if (object == null) {
                this.jTargetComboBox.setSelectedItem(MOST_LIKELY);
            } else {
                this.jTargetComboBox.setSelectedItem(object);
            }
            JLabel jLabel3 = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.5;
            this.jParamsPanel.add((Component)jLabel3, gridBagConstraints);
        } else if (parameters instanceof ApplyNode.PredictionProbability) {
            JLabel jLabel = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(8, 10, 6, 0);
            this.jParamsPanel.add((Component)jLabel, gridBagConstraints);
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.jTargetComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_TARGET"));
            jLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_TARGET");
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            Vector<Object> vector = ((ApplyNode.PredictionProbability)parameters).getTargetValues();
            if (vector != null) {
                defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
            }
            defaultComboBoxModel.insertElementAt(MOST_LIKELY, 0);
            this.jTargetComboBox = new JComboBox(defaultComboBoxModel);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.insets = new Insets(8, 8, 6, 10);
            this.jParamsPanel.add((Component)this.jTargetComboBox, gridBagConstraints);
            this.jTargetComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ApplyOutputPanel.this._loading) {
                        return;
                    }
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Object object = jComboBox.getSelectedItem();
                    if (object == MOST_LIKELY) {
                        object = null;
                    }
                    if (ApplyOutputPanel.this.jAutoGenCheckBox.isSelected()) {
                        String string = ApplyOutputPanel.this.generateUniqueColumnName(ApplyOutputPanel.this._selectPredictionFunc, ApplyOutputPanel.this._selectModel.getName(), object != null ? object.toString() : null);
                        ApplyOutputPanel.this.jColumnTextField.setText(string);
                    }
                }
            });
            Object object = ((ApplyNode.PredictionProbability)parameters).getSelectedTarget();
            if (object == null) {
                this.jTargetComboBox.setSelectedItem(MOST_LIKELY);
            } else {
                this.jTargetComboBox.setSelectedItem(object);
            }
            JLabel jLabel4 = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.5;
            this.jParamsPanel.add((Component)jLabel4, gridBagConstraints);
        } else if (parameters instanceof ApplyNode.PredictionSet) {
            BigInteger bigInteger = ((ApplyNode.PredictionSet)parameters).getTopN();
            this.jBestNCheckBox = new JCheckBox();
            this.jBestNCheckBox.setSelected(bigInteger != null && bigInteger.intValue() > 0);
            this.jBestNCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ApplyOutputPanel.this.jNValueComboBox.setEnabled(ApplyOutputPanel.this.jBestNCheckBox.isSelected());
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(8, 10, 6, 0);
            this.jParamsPanel.add((Component)this.jBestNCheckBox, gridBagConstraints);
            ResourceUtils.resButton((AbstractButton)this.jBestNCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_BEST_N"));
            this.jBestNCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_USE_BEST_N");
            JLabel jLabel = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 20, 6, 0);
            this.jParamsPanel.add((Component)jLabel, gridBagConstraints);
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.jNValueComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_N_VALUE"));
            jLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_N_VALUE");
            int n = ((ApplyNode.PredictionSet)parameters).getMaxN();
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            for (int i = 1; i <= n; ++i) {
                defaultComboBoxModel.addElement(i + "");
            }
            this.jNValueComboBox = new JComboBox(defaultComboBoxModel);
            this.jNValueComboBox.setEnabled(this.jBestNCheckBox.isSelected());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 8, 6, 10);
            this.jParamsPanel.add((Component)this.jNValueComboBox, gridBagConstraints);
            this.jNValueComboBox.setSelectedItem(bigInteger.toString());
            Double d = null;
            String string = null;
            String string2 = null;
            if (((ApplyNode.PredictionSet)parameters).getUseCostType().compareTo("Model") == 0) {
                d = ((ApplyNode.PredictionSet)parameters).getCostCutOff();
                string = DialogsLrb.get("APPLY_OUTPUT_COST_VALUE");
                string2 = DialogsLrb.get("APPLY_OUTPUT_COST_VALUE_TIP");
            } else {
                d = ((ApplyNode.PredictionSet)parameters).getCutOff();
                string = DialogsLrb.get("APPLY_OUTPUT_PROB_VALUE");
                string2 = DialogsLrb.get("APPLY_OUTPUT_PROB_VALUE_TIP");
            }
            this.jCutOffCheckBox = new JCheckBox();
            boolean bl2 = d != null && d > 0.0;
            this.jCutOffCheckBox.setSelected(bl2);
            this.jCutOffCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ApplyOutputPanel.this.jCutOffTextField.setEnabled(ApplyOutputPanel.this.jCutOffCheckBox.isSelected());
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 10, 6, 0);
            this.jParamsPanel.add((Component)this.jCutOffCheckBox, gridBagConstraints);
            ResourceUtils.resButton((AbstractButton)this.jCutOffCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_CUTOFF"));
            this.jCutOffCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_USE_CUTOFF");
            JLabel jLabel5 = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 20, 6, 0);
            this.jParamsPanel.add((Component)jLabel5, gridBagConstraints);
            ResourceUtils.resLabel((JLabel)jLabel5, (Component)this.jCutOffTextField, (String)string);
            jLabel5.getAccessibleContext().setAccessibleName(string);
            this.jCutOffTextField = new NumberTextField();
            this.jCutOffTextField.setDataType(Double.class);
            this.jCutOffTextField.setSigned(false);
            this.jCutOffTextField.setNumber((Number)d);
            this.jCutOffTextField.setEnabled(this.jCutOffCheckBox.isSelected());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 8, 6, 10);
            this.jParamsPanel.add((Component)this.jCutOffTextField, gridBagConstraints);
            this.jCutOffTextField.setToolTipText(string2);
            JLabel jLabel6 = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.5;
            this.jParamsPanel.add((Component)jLabel6, gridBagConstraints);
        } else if (parameters instanceof ApplyNode.ClusterProbability) {
            JLabel jLabel = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(8, 10, 6, 0);
            this.jParamsPanel.add((Component)jLabel, gridBagConstraints);
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.jClusterComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_CLUSTER"));
            jLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_CLUSTER");
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            Vector<Object> vector = ((ApplyNode.ClusterProbability)parameters).getClusterIds();
            if (vector != null) {
                defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
            }
            defaultComboBoxModel.insertElementAt(MOST_LIKELY, 0);
            this.jClusterComboBox = new JComboBox(defaultComboBoxModel);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.insets = new Insets(8, 8, 6, 10);
            this.jParamsPanel.add((Component)this.jClusterComboBox, gridBagConstraints);
            this.jClusterComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ApplyOutputPanel.this._loading) {
                        return;
                    }
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Object object = jComboBox.getSelectedItem();
                    if (object == MOST_LIKELY) {
                        object = null;
                    }
                    if (ApplyOutputPanel.this.jAutoGenCheckBox.isSelected()) {
                        String string = ApplyOutputPanel.this.generateUniqueColumnName(ApplyOutputPanel.this._selectPredictionFunc, ApplyOutputPanel.this._selectModel.getName(), object != null ? object.toString() : null);
                        ApplyOutputPanel.this.jColumnTextField.setText(string);
                    }
                }
            });
            Object object = ((ApplyNode.ClusterProbability)parameters).getClusterId();
            if (object == null) {
                this.jClusterComboBox.setSelectedItem(MOST_LIKELY);
            } else {
                this.jClusterComboBox.setSelectedItem(object);
            }
            JLabel jLabel7 = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.5;
            this.jParamsPanel.add((Component)jLabel7, gridBagConstraints);
        } else if (parameters instanceof ApplyNode.ClusterSet) {
            BigInteger bigInteger = ((ApplyNode.ClusterSet)parameters).getTopN();
            this.jBestNCheckBox = new JCheckBox();
            this.jBestNCheckBox.setSelected(bigInteger != null && bigInteger.intValue() > 0);
            this.jBestNCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ApplyOutputPanel.this.jNValueComboBox.setEnabled(ApplyOutputPanel.this.jBestNCheckBox.isSelected());
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(8, 10, 6, 0);
            this.jParamsPanel.add((Component)this.jBestNCheckBox, gridBagConstraints);
            ResourceUtils.resButton((AbstractButton)this.jBestNCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_BEST_N"));
            this.jBestNCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_USE_BEST_N");
            JLabel jLabel = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 20, 6, 0);
            this.jParamsPanel.add((Component)jLabel, gridBagConstraints);
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.jNValueComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_N_VALUE"));
            jLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_N_VALUE");
            int n = ((ApplyNode.ClusterSet)parameters).getMaxN();
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            for (int i = 1; i <= n; ++i) {
                defaultComboBoxModel.addElement(i + "");
            }
            this.jNValueComboBox = new JComboBox(defaultComboBoxModel);
            this.jNValueComboBox.setEnabled(this.jBestNCheckBox.isSelected());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 8, 6, 10);
            this.jParamsPanel.add((Component)this.jNValueComboBox, gridBagConstraints);
            this.jNValueComboBox.setSelectedItem(bigInteger.toString());
            Double d = ((ApplyNode.ClusterSet)parameters).getCutOff();
            this.jCutOffCheckBox = new JCheckBox();
            this.jCutOffCheckBox.setSelected(d != null && d > 0.0);
            this.jCutOffCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ApplyOutputPanel.this.jCutOffTextField.setEnabled(ApplyOutputPanel.this.jCutOffCheckBox.isSelected());
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 10, 6, 0);
            this.jParamsPanel.add((Component)this.jCutOffCheckBox, gridBagConstraints);
            ResourceUtils.resButton((AbstractButton)this.jCutOffCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_CUTOFF"));
            this.jCutOffCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_USE_CUTOFF");
            JLabel jLabel8 = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 20, 6, 0);
            this.jParamsPanel.add((Component)jLabel8, gridBagConstraints);
            ResourceUtils.resLabel((JLabel)jLabel8, (Component)this.jCutOffTextField, (String)DialogsLrb.get("APPLY_OUTPUT_PROB_VALUE"));
            jLabel8.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_PROB_VALUE");
            this.jCutOffTextField = new NumberTextField((Number)d);
            this.jCutOffTextField.setDataType(Double.class);
            this.jCutOffTextField.setSigned(false);
            this.jCutOffTextField.setNumber((Number)d);
            this.jCutOffTextField.setEnabled(this.jCutOffCheckBox.isSelected());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 8, 6, 10);
            this.jParamsPanel.add((Component)this.jCutOffTextField, gridBagConstraints);
            this.jCutOffTextField.setToolTipText(DialogsLrb.get("PAGE_OUTPUT_TOPN_CUTOFF_VALUE_TIP"));
            JLabel jLabel9 = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.5;
            this.jParamsPanel.add((Component)jLabel9, gridBagConstraints);
        } else if (parameters instanceof ApplyNode.FeatureValue) {
            JLabel jLabel = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(8, 10, 6, 0);
            this.jParamsPanel.add((Component)jLabel, gridBagConstraints);
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.jFeatureComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_FEATURE"));
            jLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_FEATURE");
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            Vector<Object> vector = ((ApplyNode.FeatureValue)parameters).getFeatureIds();
            if (vector != null) {
                defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
            }
            defaultComboBoxModel.insertElementAt(MOST_LIKELY, 0);
            this.jFeatureComboBox = new JComboBox(defaultComboBoxModel);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.insets = new Insets(8, 8, 6, 10);
            this.jParamsPanel.add((Component)this.jFeatureComboBox, gridBagConstraints);
            this.jFeatureComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ApplyOutputPanel.this._loading) {
                        return;
                    }
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Object object = jComboBox.getSelectedItem();
                    if (object == MOST_LIKELY) {
                        object = null;
                    }
                    if (ApplyOutputPanel.this.jAutoGenCheckBox.isSelected()) {
                        String string = ApplyOutputPanel.this.generateUniqueColumnName(ApplyOutputPanel.this._selectPredictionFunc, ApplyOutputPanel.this._selectModel.getName(), object != null ? object.toString() : null);
                        ApplyOutputPanel.this.jColumnTextField.setText(string);
                    }
                }
            });
            Object object = ((ApplyNode.FeatureValue)parameters).getFeatureId();
            if (object == null) {
                this.jFeatureComboBox.setSelectedItem(MOST_LIKELY);
            } else {
                this.jFeatureComboBox.setSelectedItem(object);
            }
            JLabel jLabel10 = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.5;
            this.jParamsPanel.add((Component)jLabel10, gridBagConstraints);
        } else if (parameters instanceof ApplyNode.FeatureSet) {
            BigInteger bigInteger = ((ApplyNode.FeatureSet)parameters).getTopN();
            this.jBestNCheckBox = new JCheckBox();
            this.jBestNCheckBox.setSelected(bigInteger != null && bigInteger.intValue() > 0);
            this.jBestNCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ApplyOutputPanel.this.jNValueComboBox.setEnabled(ApplyOutputPanel.this.jBestNCheckBox.isSelected());
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(8, 10, 6, 0);
            this.jParamsPanel.add((Component)this.jBestNCheckBox, gridBagConstraints);
            ResourceUtils.resButton((AbstractButton)this.jBestNCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_BEST_N"));
            this.jBestNCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_USE_BEST_N");
            JLabel jLabel = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 20, 6, 0);
            this.jParamsPanel.add((Component)jLabel, gridBagConstraints);
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.jNValueComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_N_VALUE"));
            jLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_N_VALUE");
            int n = ((ApplyNode.FeatureSet)parameters).getMaxN();
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            for (int i = 1; i <= n; ++i) {
                defaultComboBoxModel.addElement(i + "");
            }
            this.jNValueComboBox = new JComboBox(defaultComboBoxModel);
            this.jNValueComboBox.setEnabled(this.jBestNCheckBox.isSelected());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 8, 6, 10);
            this.jParamsPanel.add((Component)this.jNValueComboBox, gridBagConstraints);
            this.jNValueComboBox.setSelectedItem(bigInteger.toString());
            Double d = ((ApplyNode.FeatureSet)parameters).getCutOff();
            this.jCutOffCheckBox = new JCheckBox();
            this.jCutOffCheckBox.setSelected(d != null && d > 0.0);
            this.jCutOffCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ApplyOutputPanel.this.jCutOffTextField.setEnabled(ApplyOutputPanel.this.jCutOffCheckBox.isSelected());
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 10, 6, 0);
            this.jParamsPanel.add((Component)this.jCutOffCheckBox, gridBagConstraints);
            ResourceUtils.resButton((AbstractButton)this.jCutOffCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_CUTOFF"));
            this.jCutOffCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_USE_CUTOFF");
            JLabel jLabel11 = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 20, 6, 0);
            this.jParamsPanel.add((Component)jLabel11, gridBagConstraints);
            ResourceUtils.resLabel((JLabel)jLabel11, (Component)this.jCutOffTextField, (String)DialogsLrb.get("APPLY_OUTPUT_PROB_VALUE"));
            jLabel11.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_PROB_VALUE");
            this.jCutOffTextField = new NumberTextField((Number)d);
            this.jCutOffTextField.setDataType(Double.class);
            this.jCutOffTextField.setSigned(false);
            this.jCutOffTextField.setNumber((Number)d);
            this.jCutOffTextField.setEnabled(this.jCutOffCheckBox.isSelected());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 8, 6, 10);
            this.jParamsPanel.add((Component)this.jCutOffTextField, gridBagConstraints);
            this.jCutOffTextField.setToolTipText(DialogsLrb.get("PAGE_OUTPUT_TOPN_CUTOFF_VALUE_TIP"));
            JLabel jLabel12 = new JLabel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.5;
            this.jParamsPanel.add((Component)jLabel12, gridBagConstraints);
        } else {
            bl = false;
        }
        this.jParamsPanel.setVisible(bl);
        this.revalidate();
    }

    private ApplyNode.Parameters getUserParameters(ApplyNode.Parameters parameters) throws ValidationException {
        String string = this.jColumnTextField.getText();
        if (parameters instanceof ApplyNode.Prediction) {
            parameters.setColumn(string);
            return parameters;
        }
        if (parameters instanceof ApplyNode.PredictionDetails) {
            parameters.setColumn(string);
            return parameters;
        }
        if (parameters instanceof ApplyNode.ClassPredictionLowerBounds) {
            ApplyNode.ClassPredictionLowerBounds classPredictionLowerBounds = (ApplyNode.ClassPredictionLowerBounds)parameters;
            Double d = (Double)this.jConfidenceField.getNumber();
            Object object = this.jTargetComboBox.getSelectedItem();
            if (object == MOST_LIKELY) {
                object = null;
            }
            classPredictionLowerBounds.setLowerBound(string);
            classPredictionLowerBounds.setConfidence(new Double(d / 100.0));
            classPredictionLowerBounds.setSelectedTarget(object);
            classPredictionLowerBounds.validate();
            return classPredictionLowerBounds;
        }
        if (parameters instanceof ApplyNode.ClassPredictionUpperBounds) {
            ApplyNode.ClassPredictionUpperBounds classPredictionUpperBounds = (ApplyNode.ClassPredictionUpperBounds)parameters;
            Double d = (Double)this.jConfidenceField.getNumber();
            Object object = this.jTargetComboBox.getSelectedItem();
            if (object == MOST_LIKELY) {
                object = null;
            }
            classPredictionUpperBounds.setUpperBound(string);
            classPredictionUpperBounds.setConfidence(new Double(d / 100.0));
            classPredictionUpperBounds.setSelectedTarget(object);
            classPredictionUpperBounds.validate();
            return classPredictionUpperBounds;
        }
        if (parameters instanceof ApplyNode.RegressPredictionLowerBounds) {
            ApplyNode.RegressPredictionLowerBounds regressPredictionLowerBounds = (ApplyNode.RegressPredictionLowerBounds)parameters;
            Double d = (Double)this.jConfidenceField.getNumber();
            regressPredictionLowerBounds.setLowerBound(string);
            regressPredictionLowerBounds.setConfidence(new Double(d / 100.0));
            regressPredictionLowerBounds.validate();
            return regressPredictionLowerBounds;
        }
        if (parameters instanceof ApplyNode.RegressPredictionUpperBounds) {
            ApplyNode.RegressPredictionUpperBounds regressPredictionUpperBounds = (ApplyNode.RegressPredictionUpperBounds)parameters;
            Double d = (Double)this.jConfidenceField.getNumber();
            regressPredictionUpperBounds.setUpperBound(string);
            regressPredictionUpperBounds.setConfidence(new Double(d / 100.0));
            regressPredictionUpperBounds.validate();
            return regressPredictionUpperBounds;
        }
        if (parameters instanceof ApplyNode.PredictionCost) {
            ApplyNode.PredictionCost predictionCost = (ApplyNode.PredictionCost)parameters;
            Object object = this.jTargetComboBox.getSelectedItem();
            if (object == MOST_LIKELY) {
                object = null;
            }
            predictionCost.setColumn(string);
            predictionCost.setSelectedTarget(object);
            return predictionCost;
        }
        if (parameters instanceof ApplyNode.PredictionProbability) {
            ApplyNode.PredictionProbability predictionProbability = (ApplyNode.PredictionProbability)parameters;
            Object object = this.jTargetComboBox.getSelectedItem();
            if (object == MOST_LIKELY) {
                object = null;
            }
            predictionProbability.setColumn(string);
            predictionProbability.setSelectedTarget(object);
            return predictionProbability;
        }
        if (parameters instanceof ApplyNode.PredictionSet) {
            ApplyNode.PredictionSet predictionSet = (ApplyNode.PredictionSet)parameters;
            String string2 = null;
            boolean bl = this.jBestNCheckBox.isSelected();
            if (bl) {
                string2 = (String)this.jNValueComboBox.getSelectedItem();
            }
            Double d = null;
            boolean bl2 = this.jCutOffCheckBox.isSelected();
            if (bl2) {
                d = (Double)this.jCutOffTextField.getNumber();
            }
            predictionSet.setColumn(string);
            predictionSet.setUseTopN(bl);
            predictionSet.setTopN(bl ? new BigInteger(string2) : null);
            if (predictionSet.getUseCostType().compareTo("None") == 0) {
                predictionSet.setUseCutOff(bl2);
                predictionSet.setCutOff(bl2 ? d : null);
            } else {
                predictionSet.setUseCostCutOff(bl2);
                predictionSet.setCostCutOff(bl2 ? d : null);
            }
            predictionSet.validate();
            return predictionSet;
        }
        if (parameters instanceof ApplyNode.ClusterId) {
            ApplyNode.ClusterId clusterId = (ApplyNode.ClusterId)parameters;
            clusterId.setColumn(string);
            return clusterId;
        }
        if (parameters instanceof ApplyNode.ClusterProbability) {
            ApplyNode.ClusterProbability clusterProbability = (ApplyNode.ClusterProbability)parameters;
            Object object = this.jClusterComboBox.getSelectedItem();
            if (object == MOST_LIKELY) {
                object = null;
            }
            clusterProbability.setColumn(string);
            clusterProbability.setClusterId(object);
            return clusterProbability;
        }
        if (parameters instanceof ApplyNode.ClusterSet) {
            ApplyNode.ClusterSet clusterSet = (ApplyNode.ClusterSet)parameters;
            String string3 = null;
            boolean bl = this.jBestNCheckBox.isSelected();
            if (bl) {
                string3 = (String)this.jNValueComboBox.getSelectedItem();
            }
            Double d = null;
            boolean bl3 = this.jCutOffCheckBox.isSelected();
            if (bl3) {
                d = (Double)this.jCutOffTextField.getNumber();
            }
            clusterSet.setColumn(string);
            clusterSet.setUseTopN(bl);
            clusterSet.setTopN(bl ? new BigInteger(string3) : null);
            clusterSet.setUseCutOff(bl3);
            clusterSet.setCutOff(bl3 ? d : null);
            clusterSet.validate();
            return clusterSet;
        }
        if (parameters instanceof ApplyNode.FeatureId) {
            ApplyNode.FeatureId featureId = (ApplyNode.FeatureId)parameters;
            featureId.setColumn(string);
            return featureId;
        }
        if (parameters instanceof ApplyNode.FeatureValue) {
            ApplyNode.FeatureValue featureValue = (ApplyNode.FeatureValue)parameters;
            Object object = this.jFeatureComboBox.getSelectedItem();
            if (object == MOST_LIKELY) {
                object = null;
            }
            featureValue.setColumn(string);
            featureValue.setFeatureId(object);
            return featureValue;
        }
        if (parameters instanceof ApplyNode.FeatureSet) {
            ApplyNode.FeatureSet featureSet = (ApplyNode.FeatureSet)parameters;
            String string4 = null;
            boolean bl = this.jBestNCheckBox.isSelected();
            if (bl) {
                string4 = (String)this.jNValueComboBox.getSelectedItem();
            }
            Double d = null;
            boolean bl4 = this.jCutOffCheckBox.isSelected();
            if (bl4) {
                d = (Double)this.jCutOffTextField.getNumber();
            }
            featureSet.setColumn(string);
            featureSet.setUseTopN(bl);
            featureSet.setTopN(bl ? new BigInteger(string4) : null);
            featureSet.setUseCutOff(bl4);
            featureSet.setCutOff(bl4 ? d : null);
            featureSet.validate();
            return featureSet;
        }
        return null;
    }

    private void initComponents() {
        this.jColumnLabel = new JLabel();
        this.jColumnTextField = new JTextField();
        this.jAutoGenCheckBox = new JCheckBox();
        this.jNodeLabel = new JLabel();
        this.jNodeComboBox = new JComboBox();
        this.jModelLabel = new JLabel();
        this.jModelComboBox = new JComboBox();
        this.jFunctionLabel = new JLabel();
        this.jFunctionComboBox = new JComboBox();
        this.jParamsPanel = new JPanel();
        this.jFillerLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jColumnLabel.setLabelFor(this.jColumnTextField);
        this.jColumnLabel.setText("Column:");
        this.jColumnLabel.setName("jColumnLabel");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jColumnLabel, gridBagConstraints);
        this.jColumnTextField.setName("jColumnTextField");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(6, 8, 0, 0);
        this.add((Component)this.jColumnTextField, gridBagConstraints);
        this.jAutoGenCheckBox.setText("Auto");
        this.jAutoGenCheckBox.setName("jAutoGenCheckBox");
        this.jAutoGenCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyOutputPanel.this.jAutoGenCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 8, 0, 0);
        this.add((Component)this.jAutoGenCheckBox, gridBagConstraints);
        this.jNodeLabel.setLabelFor(this.jNodeComboBox);
        this.jNodeLabel.setText("Node:");
        this.jNodeLabel.setName("jNodeLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jNodeLabel, gridBagConstraints);
        this.jNodeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jNodeComboBox.setName("jNodeComboBox");
        this.jNodeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyOutputPanel.this.jNodeComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(6, 8, 0, 0);
        this.add((Component)this.jNodeComboBox, gridBagConstraints);
        this.jModelLabel.setLabelFor(this.jModelComboBox);
        this.jModelLabel.setText("Model:");
        this.jModelLabel.setName("jModelLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jModelLabel, gridBagConstraints);
        this.jModelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jModelComboBox.setName("jModelComboBox");
        this.jModelComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyOutputPanel.this.jModelComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(6, 8, 0, 0);
        this.add((Component)this.jModelComboBox, gridBagConstraints);
        this.jFunctionLabel.setLabelFor(this.jFunctionComboBox);
        this.jFunctionLabel.setText("Function:");
        this.jFunctionLabel.setName("jFunctionLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jFunctionLabel, gridBagConstraints);
        this.jFunctionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jFunctionComboBox.setName("jFunctionComboBox");
        this.jFunctionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyOutputPanel.this.jFunctionComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(6, 8, 0, 0);
        this.add((Component)this.jFunctionComboBox, gridBagConstraints);
        this.jParamsPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.jParamsPanel.setName("jParamsPanel");
        this.jParamsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.jParamsPanel, gridBagConstraints);
        this.jParamsPanel.getAccessibleContext().setAccessibleName("");
        this.jParamsPanel.getAccessibleContext().setAccessibleDescription("");
        this.jFillerLabel1.setName("jFillerLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.jFillerLabel1, gridBagConstraints);
    }

    private void jAutoGenCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.jAutoGenCheckBox.isSelected()) {
            Object object;
            String string = null;
            if ((this._selectPredictionFunc == ServerConstants.ApplyPredictionFunctions.PREDICTION_BOUNDS_LOWER || this._selectPredictionFunc == ServerConstants.ApplyPredictionFunctions.PREDICTION_BOUNDS_UPPER) && this._selectModel.getMiningFunction() == MiningFunctionType.CLASSIFICATION || this._selectPredictionFunc == ServerConstants.ApplyPredictionFunctions.PREDICTION_COST || this._selectPredictionFunc == ServerConstants.ApplyPredictionFunctions.PREDICTION_PROBABILITY) {
                object = this.jTargetComboBox.getSelectedItem();
                if (object == MOST_LIKELY) {
                    string = object == MOST_LIKELY ? null : object.toString();
                }
            } else if (this._selectPredictionFunc == ServerConstants.ApplyPredictionFunctions.FEATURE_VALUE) {
                object = this.jFeatureComboBox.getSelectedItem();
                if (object == MOST_LIKELY) {
                    object = null;
                }
                string = object == MOST_LIKELY ? null : object.toString();
            } else if (this._selectPredictionFunc == ServerConstants.ApplyPredictionFunctions.CLUSTER_PROBABILITY) {
                object = this.jClusterComboBox.getSelectedItem();
                if (object == MOST_LIKELY) {
                    object = null;
                }
                string = object == MOST_LIKELY ? null : object.toString();
            }
            object = this.generateUniqueColumnName(this._selectPredictionFunc, this._selectModel.getName(), string != null ? string.toString() : null);
            this.jColumnTextField.setText((String)object);
        }
        this.jColumnTextField.setEnabled(!this.jAutoGenCheckBox.isSelected());
    }

    private void jNodeComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        String string = (String)this.jNodeComboBox.getSelectedItem();
        if (string != SELECT_A_NODE) {
            this.jNodeComboBox.removeItem(SELECT_A_NODE);
            for (AbstractNode object2 : this._modelNodes) {
                if (string.compareTo(object2.getData().getName()) != 0) continue;
                this._selectModelNode = object2;
                break;
            }
            List<RefModelType> list = this.getRefModels(this._selectModelNode);
            Iterator<RefModelType> iterator = list.iterator();
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            if (list.size() > 1) {
                defaultComboBoxModel.addElement(SELECT_A_MODEL);
            }
            RefModelType refModelType = null;
            while (iterator.hasNext()) {
                refModelType = iterator.next();
                if (this._parent.isShowSchema()) {
                    defaultComboBoxModel.addElement(refModelType.getSchema() + "." + refModelType.getName());
                    continue;
                }
                defaultComboBoxModel.addElement(refModelType.getName());
            }
            this.jModelComboBox.setModel(defaultComboBoxModel);
            if (list.size() == 1) {
                this._selectModel = refModelType;
            } else {
                this.jModelComboBox.setSelectedItem(SELECT_A_MODEL);
                this._selectModel = null;
            }
            DefaultComboBoxModel<Object> defaultComboBoxModel2 = null;
            this._selectPredictionFunc = null;
            this._selectFuncParameters = null;
            if (this._selectModel != null) {
                String[] stringArray = this.getPredictionFunctions(this._selectModel);
                defaultComboBoxModel2 = new DefaultComboBoxModel<String>(stringArray);
                if (stringArray.length > 1) {
                    defaultComboBoxModel2.insertElementAt(SELECT_A_FUNCTION, 0);
                }
                this.jFunctionComboBox.setModel(defaultComboBoxModel2);
                if (stringArray.length > 1) {
                    this.jFunctionComboBox.setSelectedItem(SELECT_A_FUNCTION);
                } else {
                    this._selectPredictionFunc = stringArray[0];
                    this._selectFuncParameters = this.getFunctionParameters(this._selectModel, this._selectPredictionFunc);
                }
                if (this.jAutoGenCheckBox.isSelected()) {
                    String string2 = this.generateUniqueColumnName(this._selectPredictionFunc, this._selectModel.getName(), null);
                    this.jColumnTextField.setText(string2);
                }
            } else {
                defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
                defaultComboBoxModel2.addElement(SELECT_A_FUNCTION);
                this.jFunctionComboBox.setModel(defaultComboBoxModel2);
            }
            this.populateParamUI(this._selectFuncParameters);
        }
    }

    private void jModelComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        String string = (String)this.jModelComboBox.getSelectedItem();
        if (string != SELECT_A_MODEL) {
            String[] stringArray;
            this.jModelComboBox.removeItem(SELECT_A_MODEL);
            List<RefModelType> list = this.getRefModels(this._selectModelNode);
            Iterator<RefModelType> iterator = list.iterator();
            String string2 = null;
            while (iterator.hasNext()) {
                stringArray = iterator.next();
                string2 = this._parent.isShowSchema() ? stringArray.getSchema() + "." + stringArray.getName() : stringArray.getName();
                if (string.compareTo(string2) != 0) continue;
                this._selectModel = stringArray;
                break;
            }
            stringArray = this.getPredictionFunctions(this._selectModel);
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
            if (stringArray.length > 1) {
                defaultComboBoxModel.insertElementAt(SELECT_A_FUNCTION, 0);
            }
            this.jFunctionComboBox.setModel(defaultComboBoxModel);
            this._selectPredictionFunc = null;
            this._selectFuncParameters = null;
            if (stringArray.length > 1) {
                this.jFunctionComboBox.setSelectedItem(SELECT_A_FUNCTION);
            } else {
                this._selectPredictionFunc = stringArray[0];
                this._selectFuncParameters = this.getFunctionParameters(this._selectModel, this._selectPredictionFunc);
            }
            if (this.jAutoGenCheckBox.isSelected()) {
                String string3 = this.generateUniqueColumnName(this._selectPredictionFunc, this._selectModel.getName(), null);
                this.jColumnTextField.setText(string3);
            }
            this.populateParamUI(this._selectFuncParameters);
        }
    }

    private void jFunctionComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        String string = (String)this.jFunctionComboBox.getSelectedItem();
        if (string != SELECT_A_FUNCTION) {
            this.jFunctionComboBox.removeItem(SELECT_A_FUNCTION);
            this._selectPredictionFunc = string;
            this._selectFuncParameters = this.getFunctionParameters(this._selectModel, string);
            if (this.jAutoGenCheckBox.isSelected()) {
                String string2 = this.generateUniqueColumnName(this._selectPredictionFunc, this._selectModel.getName(), null);
                this.jColumnTextField.setText(string2);
            }
            this.populateParamUI(this._selectFuncParameters);
        }
    }

    public boolean doWork() {
        boolean bl = true;
        try {
            if (this._selectModel == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_OUTPUT_MODEL_NOT_SELECTED"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            if (this._selectFuncParameters == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_OUTPUT_FUNCTION_NOT_SELECTED"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            ApplyNode.Parameters parameters = this.getUserParameters(this._selectFuncParameters);
            String string = parameters.getColumn();
            if (string.length() > 30) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_OUTPUT_COLUMN_TOO_LONG"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            if (this._editMode) {
                String string2 = ApplyNode.getPredictionFunctionOutput(this._output);
                if (string2.compareTo(string) != 0) {
                    if (this._parent.getOutputColumnNameGenerator().doesNameExist(string)) {
                        throw new ValidationException(DialogsLrb.get("APPLY_OPTION_DUPLICATE_COLUMN_ERROR"));
                    }
                    this._parent.getOutputColumnNameGenerator().removeUniqueName(string2);
                    this._parent.getOutputColumnNameGenerator().addUniqueName(string);
                }
            } else {
                if (this._parent.getOutputColumnNameGenerator().doesNameExist(string)) {
                    throw new ValidationException(DialogsLrb.get("APPLY_OPTION_DUPLICATE_COLUMN_ERROR"));
                }
                this._output.setModel((RefModelType)MetaDataHelper.copyMetadataObject(this._selectModel));
                this._parent.getOutputColumnNameGenerator().addUniqueName(string);
            }
            ApplyNode.setPredictionFunctionParameters(this._output, parameters);
            this._dirty = true;
        }
        catch (ValidationException validationException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)validationException.getLocalizedMessage(), (String)DialogsLrb.get("ERROR_TITLE"), null);
            bl = false;
        }
        return bl;
    }

    public ApplyOutputColumnsType.OutputColumn getOutput() {
        return this._output;
    }

    public boolean isDirty() {
        return this._dirty;
    }
}

