/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.apply;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.NiceTableWithToolbar;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyOutputDialog;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyOutputPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyWizard;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.ApplyNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowApplyNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowPIComponent;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyOutputColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.nulls.NullIcon;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class ApplyModelsPanel
extends AbstractDialogPanel {
    private WorkflowApplyNodePropertyProxyModel _propertyModel;
    private ModelsTableModel _models;
    private NiceTableWithToolbar _tableWithToolbar;
    private static Icon _ready_icon;
    private static Icon _built_icon;
    private static NullIcon _nullIcon;
    private static Icon _error_icon;
    private static Icon _invalid_icon;
    private static Icon _wizIcon;
    private JButton _removeBtn;
    private JButton _addBtn;
    private JButton _editBtn;
    private JButton _wizBtn;
    private ApplyOutputColumnsType _applyOutputColumns;
    private String _ownerName = null;
    private boolean _dirty;
    private HashMap<String, String> _modelNodesLookupMap = new HashMap();
    private ApplyNode.ApplyOutputColumnNameGenerator _outputColumnNameGenerator;
    private ComponentWithTitlebar<JComponent> componentWithTitlebar;
    private JCheckBox jAutoSettingsCheckBox;

    public ApplyModelsPanel(PropertyModel propertyModel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for apply node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.setMinimumSize(new Dimension(200, 400));
        this.init((ApplyNode)this._data, propertyModel);
    }

    public ApplyModelsPanel(Context context, ApplyNode applyNode, PropertyModel propertyModel) {
        super(context, applyNode);
        assert (context != null) : "Context must not be null.";
        assert (applyNode != null) : "Apply node must not be null.";
        assert (applyNode instanceof ApplyNode) : "Must be an instance of apply node.";
        this.init(applyNode, propertyModel);
    }

    private void init(ApplyNode applyNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        this._dirty = false;
        ApplyNodeType applyNodeType = (ApplyNodeType)applyNode.getData();
        this._applyOutputColumns = (ApplyOutputColumnsType)MetaDataHelper.copyMetadataObject(applyNodeType.getOutputColumns());
        this._outputColumnNameGenerator = new ApplyNode.ApplyOutputColumnNameGenerator(this._applyOutputColumns);
        List<AbstractNode> list = applyNode.findApplyModelNodes();
        this._modelNodesLookupMap.clear();
        for (AbstractNode abstractNode : list) {
            this._modelNodesLookupMap.put(abstractNode.getData().getId(), abstractNode.getData().getName());
        }
        Object object = null;
        try {
            object = Connections.getSharedConnection(this._context);
            this._ownerName = Connections.getUserAccountName(this._context);
            this._ownerName = StringUtils.isDoubleQuotedString(this._ownerName) ? StringUtils.trimDoubleQuotes(this._ownerName) : this._ownerName.toUpperCase();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public boolean isShowSchema() {
        boolean bl = false;
        if (this._applyOutputColumns.getOutputColumn() != null) {
            for (ApplyOutputColumnsType.OutputColumn outputColumn : this._applyOutputColumns.getOutputColumn()) {
                String string = outputColumn.getModel().getSchema();
                if (string == null || string.compareTo(this._ownerName) == 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowApplyNodePropertyProxyModel workflowApplyNodePropertyProxyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        Context context = workflowApplyNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        ApplyNode applyNode = (ApplyNode)workflowNodeInspectorElement.getNode();
        if (applyNode == null) {
            return;
        }
        this._propertyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = applyNode;
        this._dirty = false;
        ApplyNodeType applyNodeType = (ApplyNodeType)applyNode.getData();
        this._applyOutputColumns = (ApplyOutputColumnsType)MetaDataHelper.copyMetadataObject(applyNodeType.getOutputColumns());
        this._outputColumnNameGenerator = new ApplyNode.ApplyOutputColumnNameGenerator(this._applyOutputColumns);
        List<AbstractNode> list = applyNode.findApplyModelNodes();
        this._modelNodesLookupMap.clear();
        for (AbstractNode abstractNode : list) {
            this._modelNodesLookupMap.put(abstractNode.getData().getId(), abstractNode.getData().getName());
        }
        this.initUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowApplyNodePropertyProxyModel)) {
            return null;
        }
        WorkflowApplyNodePropertyProxyModel workflowApplyNodePropertyProxyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        Context context = workflowApplyNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private ApplyNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowApplyNodePropertyProxyModel)) {
            return null;
        }
        WorkflowApplyNodePropertyProxyModel workflowApplyNodePropertyProxyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        Context context = workflowApplyNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ApplyNodeType) {
            return (ApplyNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void updateNode() {
        if (this._dirty && this._propertyModel != null) {
            ApplyNode applyNode = (ApplyNode)this.getData();
            ApplyNodeType applyNodeType = (ApplyNodeType)applyNode.getData();
            ComplexProperty complexProperty = new ComplexProperty("applyScoreOutputColumns", this._applyOutputColumns);
            ApplyOutputColumnsType applyOutputColumnsType = (ApplyOutputColumnsType)MetaDataHelper.copyMetadataObject(applyNodeType.getOutputColumns());
            complexProperty.setOldData(applyOutputColumnsType);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(ApplyNodePropertyModel.RowIndex.APPLY_SCORE_OUTPUT_COLUMNS), null, complexProperty, null, null));
            this._propertyModel.setValueAt(PropertyLrb.get("PI_APPLY_GROUP_APPLY_SCORE_OUTPUT_COLUMNS"), applyNode, arrayList);
        }
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("APPLY_AUTO_SETTING"), this.jAutoSettingsCheckBox);
        UIResourceHelper.setComponentText(hashMap);
        Class<WorkflowPIComponent> clazz = WorkflowPIComponent.class;
        if (_ready_icon == null) {
            _ready_icon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_BUILD_GROUP_MODEL_READY_ICON"));
        }
        if (_built_icon == null) {
            _built_icon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_BUILD_GROUP_MODEL_BUILT_ICON"));
        }
        if (_error_icon == null) {
            _error_icon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_BUILD_GROUP_MODEL_ERROR_ICON"));
        }
        Class<WorkflowEditor> clazz2 = WorkflowEditor.class;
        if (_invalid_icon == null) {
            _invalid_icon = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("USAGE_ATTRIBUTE_INVALID"));
        }
        if (_nullIcon == null) {
            _nullIcon = new NullIcon(_built_icon.getIconWidth(), _built_icon.getIconHeight());
        }
        Class<WorkflowUtils> clazz3 = WorkflowUtils.class;
        if (_wizIcon == null) {
            _wizIcon = UIResourceHelper.getImageIcon(clazz3, PropertyLrb.get("PI_APPLY_GROUP_COMMON_WIZARD_ICON"));
        }
    }

    @Override
    public void initUI() {
        this._models = new ModelsTableModel(this, this._applyOutputColumns.getOutputColumn(), this._modelNodesLookupMap);
        ControlBar controlBar = new ControlBar();
        this._wizBtn = new JButton(_wizIcon);
        this._wizBtn.setToolTipText(DialogsLrb.get("APPLY_MODEL_DEFINE_APPLY_COLUMNS_TOOLTIP"));
        this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setToolTipText(DialogsLrb.get("APPLY_MODEL_ADD_APPLY_COLUMN_TOOLTIP"));
        this._editBtn = new JButton(OracleIcons.getIcon((String)"edit.png"));
        this._editBtn.setToolTipText(DialogsLrb.get("APPLY_MODEL_EDIT_APPLY_COLUMN_TOOLTIP"));
        this._editBtn.setEnabled(false);
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(DialogsLrb.get("APPLY_MODEL_DELETE_APPLY_COLUMN_TOOLTIP"));
        this._removeBtn.setEnabled(false);
        controlBar.add((Component)this._wizBtn);
        controlBar.add((Component)this._addBtn);
        controlBar.add((Component)this._editBtn);
        controlBar.add((Component)this._removeBtn);
        this._tableWithToolbar = new NiceTableWithToolbar(this.componentWithTitlebar, controlBar, ModelsTableModel._columnNames, this._models);
        this._tableWithToolbar.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("APPLY_MODEL_TABLE_TITLE")));
        this._wizBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyModelsPanel.this.jWizardButtonActionPerformed(actionEvent);
            }
        });
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyModelsPanel.this.processAdd();
            }
        });
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyModelsPanel.this.processEdit();
            }
        });
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_OUTPUT_REMOVE_OUTPUT"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                    return;
                }
                ApplyModelsPanel.this.processRemove();
            }
        });
        this._tableWithToolbar.getNiceTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ApplyModelsPanel.this.handleModelSelectionChanged();
            }
        });
        TableColumn tableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new CustomCellRenderer());
        this._tableWithToolbar.getNiceTable().setAutoResizeMode(0);
        this._tableWithToolbar.getNiceTable().setSelectionMode(2);
        this._tableWithToolbar.getNiceTable().setColumnSelectorAvailable(true);
        this._tableWithToolbar.getNiceTable().setShowToolTips(true);
        this._tableWithToolbar.getNiceTable().setUpdateSelectionOnSort(true);
        this._tableWithToolbar.getNiceTable().setRowSelectionAllowed(true);
        int n = 0;
        for (int n2 : ModelsTableModel._columnWidths) {
            this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        this.enableControls();
    }

    private void enableControls() {
        boolean bl = this._applyOutputColumns.getAutoSpec().equals((Object)AutoSpecType.YES);
        this.jAutoSettingsCheckBox.setSelected(bl);
        this.jAutoSettingsCheckBox.setEnabled(this.isWritable());
        int n = this._tableWithToolbar.getNiceTable().getSelectedRowCount();
        List<AbstractNode> list = ((ApplyNode)this._data).findApplyModelNodes();
        this._addBtn.setEnabled(this.isWritable() && !bl && list.size() > 0);
        this._editBtn.setEnabled(this.isWritable() && !bl && n == 1);
        this._removeBtn.setEnabled(this.isWritable() && !bl && n > 0);
        this._wizBtn.setEnabled(this.isWritable() && !bl && list.size() > 0);
    }

    private void processAdd() {
        ApplyOutputPanel applyOutputPanel;
        ApplyOutputDialog applyOutputDialog = new ApplyOutputDialog();
        if (applyOutputDialog.invoke(this.getContext(), this, this._applyOutputColumns, false) && (applyOutputPanel = applyOutputDialog.getPanel()).isDirty()) {
            ApplyOutputColumnsType.OutputColumn outputColumn = applyOutputPanel.getOutput();
            this._applyOutputColumns.getOutputColumn().add(outputColumn);
            this._models = new ModelsTableModel(this, this._applyOutputColumns.getOutputColumn(), this._modelNodesLookupMap);
            this._tableWithToolbar.resetNiceTableModel(this._models);
            this._dirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
    }

    private void processEdit() {
        ApplyOutputPanel applyOutputPanel;
        int[] nArray = this._tableWithToolbar.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        ApplyOutputDialog applyOutputDialog = new ApplyOutputDialog();
        if (applyOutputDialog.invoke(this.getContext(), this, this._applyOutputColumns, true) && (applyOutputPanel = applyOutputDialog.getPanel()).isDirty()) {
            ApplyOutputColumnsType.OutputColumn outputColumn = applyOutputPanel.getOutput();
            this._applyOutputColumns.getOutputColumn().set(nArray[0], outputColumn);
            this._models = new ModelsTableModel(this, this._applyOutputColumns.getOutputColumn(), this._modelNodesLookupMap);
            this._tableWithToolbar.resetNiceTableModel(this._models);
            this._dirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
    }

    private void processRemove() {
        int[] nArray = this._tableWithToolbar.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        ArrayList<ApplyOutputColumnsType.OutputColumn> arrayList = new ArrayList<ApplyOutputColumnsType.OutputColumn>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            ApplyOutputColumnsType.OutputColumn outputColumn = (ApplyOutputColumnsType.OutputColumn)this._applyOutputColumns.getOutputColumn().get(n);
            arrayList.add(outputColumn);
        }
        for (ApplyOutputColumnsType.OutputColumn outputColumn : arrayList) {
            this._applyOutputColumns.getOutputColumn().remove(outputColumn);
            this._outputColumnNameGenerator.removeUniqueName(outputColumn);
        }
        this._models = new ModelsTableModel(this, this._applyOutputColumns.getOutputColumn(), this._modelNodesLookupMap);
        this._tableWithToolbar.resetNiceTableModel(this._models);
        this._dirty = true;
        if (this._propertyModel != null) {
            this.updateNode();
        }
    }

    private void processRemoveAll() {
        this._applyOutputColumns.getOutputColumn().clear();
        this._outputColumnNameGenerator.removeAllUniqueNames();
        this._models = new ModelsTableModel(this, this._applyOutputColumns.getOutputColumn(), this._modelNodesLookupMap);
        this._tableWithToolbar.resetNiceTableModel(this._models);
        this._dirty = true;
        if (this._propertyModel != null) {
            this.updateNode();
        }
    }

    private void handleModelSelectionChanged() {
        this.enableControls();
    }

    private void initComponents() {
        this.jAutoSettingsCheckBox = new JCheckBox();
        this.componentWithTitlebar = new ComponentWithTitlebar();
        this.setPreferredSize(new Dimension(950, 400));
        this.jAutoSettingsCheckBox.setText("Automatic Settings");
        this.jAutoSettingsCheckBox.setName("jAutoSettingsCheckBox");
        this.jAutoSettingsCheckBox.setOpaque(false);
        this.jAutoSettingsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyModelsPanel.this.jAutoSettingsCheckBoxActionPerformed(actionEvent);
            }
        });
        this.componentWithTitlebar.setAutoscrolls(true);
        this.componentWithTitlebar.setName("componentWithTitlebar");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAutoSettingsCheckBox).addComponent((Component)this.componentWithTitlebar, GroupLayout.Alignment.TRAILING, -1, 930, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jAutoSettingsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.componentWithTitlebar, -1, 357, Short.MAX_VALUE).addContainerGap()));
    }

    private void jAutoSettingsCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jAutoSettingsCheckBox.isSelected();
        if (bl) {
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_OUTPUT_AUTO_SETTING_ON"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                this.jAutoSettingsCheckBox.setSelected(false);
                return;
            }
            if (this._propertyModel != null) {
                this._applyOutputColumns.setAutoSpec(AutoSpecType.YES);
                this._applyOutputColumns.getOutputColumn().clear();
                this._outputColumnNameGenerator.removeAllUniqueNames();
                this._models = new ModelsTableModel(this, this._applyOutputColumns.getOutputColumn(), this._modelNodesLookupMap);
                this._tableWithToolbar.resetNiceTableModel(this._models);
                this._dirty = true;
                ApplyNode.addModels(this.getTargetNode((PropertyModel)this._propertyModel), this._applyOutputColumns, this._outputColumnNameGenerator);
                this.updateNode();
            } else {
                this.processRemoveAll();
                this._applyOutputColumns.setAutoSpec(AutoSpecType.YES);
                ApplyNode.addModels((ApplyNode)this.getData(), this._applyOutputColumns, this._outputColumnNameGenerator);
                this._models = new ModelsTableModel(this, this._applyOutputColumns.getOutputColumn(), this._modelNodesLookupMap);
                this._tableWithToolbar.resetNiceTableModel(this._models);
            }
        } else {
            this._applyOutputColumns.setAutoSpec(AutoSpecType.NO);
            this._dirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
        this.enableControls();
    }

    private void jWizardButtonActionPerformed(ActionEvent actionEvent) {
        ApplyWizard applyWizard = new ApplyWizard();
        if (applyWizard.runWizard(this, this.getContext(), this._applyOutputColumns)) {
            this._models = new ModelsTableModel(this, this._applyOutputColumns.getOutputColumn(), this._modelNodesLookupMap);
            this._tableWithToolbar.resetNiceTableModel(this._models);
            this._dirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
    }

    public ApplyOutputColumnsType getApplyOutputColumns() {
        return this._applyOutputColumns;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public NiceTableWithToolbar getTableWithToolbar() {
        return this._tableWithToolbar;
    }

    public ApplyNode.ApplyOutputColumnNameGenerator getOutputColumnNameGenerator() {
        return this._outputColumnNameGenerator;
    }

    static class ModelsTableModel
    extends GenericBaseTableModel {
        static String[] _columnNames = new String[]{DialogsLrb.get("APPLY_MODEL_COLUMN"), DialogsLrb.get("APPLY_MODEL_FUNCTION"), DialogsLrb.get("APPLY_MODEL_PARAMETER"), DialogsLrb.get("APPLY_MODEL_MODEL"), DialogsLrb.get("APPLY_MODEL_NODE")};
        static int[] _columnWidths = new int[]{150, 140, 240, 180, 90};
        public static final int MODEL_COLUMN = 0;
        public static final int MODEL_FUNCTION = 1;
        public static final int MODEL_PARAMETER = 2;
        public static final int MODEL_MODEL = 3;
        public static final int MODEL_NODE = 4;
        public static final int COLUMN_COUNT = 5;
        private ApplyModelsPanel _parent;
        private List<ApplyOutputColumnsType.OutputColumn> _srcData;
        private HashMap<String, String> _modelNodesLookupMap;

        public ModelsTableModel(ApplyModelsPanel applyModelsPanel, List<ApplyOutputColumnsType.OutputColumn> list, HashMap<String, String> hashMap) {
            this._parent = applyModelsPanel;
            this._srcData = list;
            this._modelNodesLookupMap = hashMap;
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(5);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            if (this._srcData == null) {
                return "Loading...";
            }
            ApplyOutputColumnsType.OutputColumn outputColumn = this._srcData.get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = ApplyNode.getPredictionFunctionOutput(outputColumn);
                    break;
                }
                case 1: {
                    string = ApplyNode.getPredictionFunction(outputColumn);
                    break;
                }
                case 2: {
                    string = ((Object)ApplyNode.getPredictionFunctionParameters(outputColumn)).toString();
                    break;
                }
                case 3: {
                    if (this._parent.isShowSchema()) {
                        string = outputColumn.getModel().getSchema() + "." + outputColumn.getModel().getName();
                        break;
                    }
                    string = outputColumn.getModel().getName();
                    break;
                }
                case 4: {
                    string = this._modelNodesLookupMap.get(outputColumn.getModel().getNodeId());
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = ApplyModelsPanel.this._tableWithToolbar.convertRowToModelIndex(n);
            RefModelType refModelType = ((ApplyOutputColumnsType.OutputColumn)ApplyModelsPanel.this._applyOutputColumns.getOutputColumn().get(n3)).getModel();
            RefModelStatusType refModelStatusType = refModelType.getStatus();
            if (refModelStatusType == RefModelStatusType.VALID) {
                this.setIcon((Icon)_nullIcon);
            } else {
                this.setIcon(_invalid_icon);
            }
            return component;
        }
    }
}

