/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.apply;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.NiceTableWithToolbar;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.wizard.group.GroupLrb;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyWizardModel;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyWizardPage;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;

public class ApplyModelPage
extends ApplyWizardPage
implements DataminerGUIPanel {
    private boolean _showSchema;
    private ModelsTableModel _models;
    private NiceTableWithToolbar _tableWithToolbar;
    private JLabel jTargetLabel;
    private JLabel jTargetValueLabel;
    private ComponentWithTitlebar<JComponent> modelsTable;
    private TransparentPanel transparentPanel;

    public ApplyModelPage() {
        this.initComponents();
        this.initRes();
    }

    @Override
    public void initUI() {
        Object object;
        ApplyWizardModel applyWizardModel = this.getModel(this.getTraversableContext());
        Connection connection = null;
        String string = null;
        try {
            connection = Connections.getSharedConnection(applyWizardModel.getContext());
            string = Connections.getUserAccountName(applyWizardModel.getContext());
            string = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string.toUpperCase();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._showSchema = false;
        for (RefModelType object22 : applyWizardModel.getAvailModels()) {
            object = object22.getSchema();
            if (object == null || ((String)object).compareTo(string) == 0) continue;
            this._showSchema = true;
            break;
        }
        this._models = new ModelsTableModel(this, applyWizardModel);
        ControlBar controlBar = new ControlBar();
        this._tableWithToolbar = new NiceTableWithToolbar(this.modelsTable, controlBar, ModelsTableModel._columnNames, this._models);
        this._tableWithToolbar.getCompToolbar().setLabel(new JLabel(DialogsLrb.get("PAGE_MODEL_TITLE")));
        TableColumn tableColumn = this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(15);
        tableColumn.setResizable(false);
        this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(1).setPreferredWidth(100);
        this._tableWithToolbar.getNiceTable().getColumnModel().getColumn(2).setPreferredWidth(100);
        this._tableWithToolbar.getNiceTable().setSortColumn(1, true);
        this._tableWithToolbar.getNiceTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ApplyModelPage.this.handleModelSelectionChanged();
            }
        });
        object = (ModelProvider)((Object)applyWizardModel.getSelectedModelNode());
        AttributeType attributeType = object.getTargetAttribute();
        this.jTargetLabel.setVisible(attributeType != null);
        this.jTargetValueLabel.setVisible(attributeType != null);
        if (attributeType != null) {
            this.jTargetValueLabel.setText(attributeType.getName());
        }
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("PAGE_MODEL_TARGET"), this.jTargetLabel);
        UIResourceHelper.setComponentText(hashMap);
    }

    private void initComponents() {
        this.jTargetLabel = new JLabel();
        this.jTargetValueLabel = new JLabel();
        this.transparentPanel = new TransparentPanel();
        this.modelsTable = new ComponentWithTitlebar();
        this.jTargetLabel.setLabelFor(this.jTargetValueLabel);
        this.jTargetLabel.setText("Target:");
        this.jTargetLabel.setName("jTargetLabel");
        this.jTargetValueLabel.setName("jTargetValueLabel");
        this.transparentPanel.setName("transparentPanel");
        this.modelsTable.setName("modelsTable");
        GroupLayout groupLayout = new GroupLayout((Container)this.transparentPanel);
        this.transparentPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.modelsTable, -1, 497, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.modelsTable, -1, 363, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.transparentPanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jTargetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetValueLabel, -1, 455, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTargetLabel).addComponent(this.jTargetValueLabel, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.transparentPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void handleModelSelectionChanged() {
    }

    @Override
    public String getPageDirtyKey() {
        return "modelDirty";
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        ApplyWizardModel applyWizardModel = this.getModel(traversableContext);
        if (traversableContext.getDirection() == 2) {
            return true;
        }
        List<Integer> list = this._models.getSelecteds();
        if (list.size() == 0) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("PAGE_MODEL_NO_SELECTION"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            return false;
        }
        if (this._models.isDirty()) {
            List<RefModelType> list2 = applyWizardModel.getAvailModels();
            ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(list2.get(list.get(i)));
            }
            applyWizardModel.setSelectedModels(arrayList);
            this.setDirty(true, "outputDirty");
        }
        return this.validateAndWriteToState(applyWizardModel);
    }

    public boolean validateAndWriteToState(ApplyWizardModel applyWizardModel) {
        boolean bl = true;
        ValidateWriteThread validateWriteThread = new ValidateWriteThread();
        validateWriteThread.setMessage(MessageFormat.format(GroupLrb.get("VALIDATING_GROUP_TABLES_DETAILS"), new Object[]{null}));
        validateWriteThread.setCancelable(false);
        try {
            validateWriteThread.start(true);
            bl = validateWriteThread.getValidation();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)GroupLrb.get("CREATE_GROUP_FAILURE_TITLE"), (String)GroupLrb.get("CREATE_GROUP_FAILURE_MESG"), null);
        }
        if (bl) {
            // empty if block
        }
        return bl;
    }

    static class ModelsTableModel
    extends GenericBaseTableModel {
        static String[] _columnNames = new String[]{"", DialogsLrb.get("PAGE_MODEL_NAME_COL"), DialogsLrb.get("PAGE_MODEL_ALGO_COL")};
        static final int SELECT_COLUMN = 0;
        static final int NAME_COLUMN = 1;
        static final int ALGO_COLUMN = 2;
        static final int COLUMN_COUNT = 3;
        private ApplyModelPage _parent;
        private List<Boolean> _selecteds = new ArrayList<Boolean>();
        private ApplyWizardModel _wizModel;
        private boolean dirty = false;

        public ModelsTableModel(ApplyModelPage applyModelPage, ApplyWizardModel applyWizardModel) {
            this._parent = applyModelPage;
            this._wizModel = applyWizardModel;
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(3);
            if (this.getRowCount() > 0) {
                List<RefModelType> list = this._wizModel.getSelectedModels();
                for (int i = 0; i < this.getRowCount(); ++i) {
                    boolean bl = Boolean.FALSE;
                    RefModelType refModelType = this._wizModel.getAvailModels().get(i);
                    for (int j = 0; list != null && j < list.size(); ++j) {
                        if (refModelType.getName().compareTo(list.get(j).getName()) != 0) continue;
                        bl = Boolean.TRUE;
                        break;
                    }
                    this._selecteds.add(bl);
                }
            }
        }

        public int getRowCount() {
            return this._wizModel != null ? this._wizModel.getAvailModels().size() : 0;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                Boolean bl;
                if (!this.dirty && (bl = this._selecteds.get(n)) != (Boolean)object) {
                    this.dirty = true;
                }
                this._selecteds.set(n, (Boolean)object);
            }
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            List<RefModelType> list = this._wizModel.getAvailModels();
            Object object = null;
            switch (n2) {
                case 0: {
                    object = this._selecteds.get(n);
                    break;
                }
                case 1: {
                    RefModelType refModelType = list.get(n);
                    if (this._parent._showSchema) {
                        object = refModelType.getSchema() + "." + refModelType.getName();
                        break;
                    }
                    object = refModelType.getName();
                    break;
                }
                case 2: {
                    object = list.get(n).getMiningAlgorithm();
                    object = ServerConstants.Algorithm.getUIAlgorithmName(object.toString());
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public List<Integer> getSelecteds() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < this._selecteds.size(); ++i) {
                if (this._selecteds.get(i) != Boolean.TRUE) continue;
                arrayList.add(i);
            }
            return arrayList;
        }

        public boolean isDirty() {
            return this.dirty;
        }
    }

    class ValidateWriteThread
    extends ProgressRunnable {
        boolean _validated = true;
        private boolean _canceled = false;
        private boolean _forceUpdate = false;

        ValidateWriteThread() {
        }

        public boolean getForceUpdate() {
            return this._forceUpdate;
        }

        public void setForceUpdate(boolean bl) {
            this._forceUpdate = bl;
        }

        public boolean getValidation() {
            return this._validated;
        }

        protected Object doWork() throws Exception {
            try {
                this._validated = true;
            }
            catch (Exception exception) {
                this._validated = false;
            }
            return null;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }
}

