/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.aggregate;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.GenericTableTooltip;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AddAggregationAttributeDialog;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AddAggregationExpressionDialog;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateEditMainDialog;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregationWizard;
import oracle.dmt.dataminer.workflow.dialog.aggregate.EditAggregationAttributeDialog;
import oracle.dmt.dataminer.workflow.dialog.aggregate.EditAggregationExpressionDialog;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AggregationNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementType;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElements;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class AggregationNodeAttributesPanel
extends AbstractDialogPanel
implements DataConsumerPanel {
    private String[] _columnNames = new String[]{AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_SOURCE_COLUMN"), AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_OUTPUT_COLUMN"), AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_FUNCTION_COLUMN"), AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_SUB_GROUP_BY_COLUMN")};
    private static Icon _wizIcon;
    private static Icon _editIcon;
    private static Icon _addElementIcon;
    private static Icon _addExpressionIcon;
    private static Icon _valid_attribue_icon;
    private static Icon _invalid_attribue_icon;
    private JButton _wizBtn;
    private JButton _editBtn;
    private JButton _removeBtn;
    private JButton _addElementBtn;
    private JButton _addExpressionBtn;
    private static final int COLUMN_COUNT = 4;
    private static final int SOURCE = 0;
    private static final int OUTPUT = 1;
    private static final int FUNCTION = 2;
    private static final int SUB_GROUP_BY = 3;
    private AggregationNodeType cachedAggregationNodeType;
    private GenericTable _jAttributesTable = new GenericTableTooltip();
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private JButton jBtnGroupBy;
    private JLabel jLabelGroupBy;
    private JTextField jTxtGroupBy;

    public AggregationNodeAttributesPanel(Context context, AbstractNode abstractNode) {
        super(context, abstractNode);
        this.cachedAggregationNodeType = new AggregationNodeType();
        this.cachedAggregationNodeType.setAggregationElements(new AggregationElements());
        this.cachedAggregationNodeType.setGroupingElement(new GroupingElementType());
        AggregationNode aggregationNode = (AggregationNode)this.getData();
        AggregationNodeType aggregationNodeType = (AggregationNodeType)aggregationNode.getData();
        if (aggregationNodeType.getAggregationElements() != null && aggregationNodeType.getAggregationElements().getAggregationElement() != null) {
            Map<String, AggregationElementType> map = null;
            AttributeTypeHelper.copyAttributes(this.cachedAggregationNodeType.getAggregationElements().getAggregationElement(), aggregationNodeType.getAggregationElements().getAggregationElement(), map);
            this.validateSourceColumn();
        }
        if (aggregationNodeType.getGroupingElement() != null) {
            AttributeTypeHelper.copyGroupingElementType(this.cachedAggregationNodeType.getGroupingElement(), aggregationNodeType.getGroupingElement());
        }
        this.cachedAggregationNodeType.setAutoSpec(aggregationNodeType.getAutoSpec());
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLabelGroupBy = new JLabel();
        this.jTxtGroupBy = new JTextField();
        this.jAttributesComponent = new ComponentWithTitlebar();
        this.jBtnGroupBy = new JButton();
        this.jLabelGroupBy.setText("Group By:");
        this.jBtnGroupBy.setText("Edit");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelGroupBy, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTxtGroupBy, -1, 329, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jBtnGroupBy).addContainerGap()).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jAttributesComponent, -1, 520, Short.MAX_VALUE).addContainerGap())));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelGroupBy).addComponent(this.jTxtGroupBy, -2, -1, -2).addComponent(this.jBtnGroupBy)).addContainerGap(265, Short.MAX_VALUE)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(44, 44, 44).addComponent((Component)this.jAttributesComponent, -1, 245, Short.MAX_VALUE).addContainerGap())));
    }

    @Override
    public void initRes() {
        if (_editIcon == null) {
            Class<PIComponentPanel> clazz = PIComponentPanel.class;
            _wizIcon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_ATTRIBUTES_GROUP_VALUE_CLEAR_ICON"));
            _editIcon = InspectorArb.getIcon((int)24);
            _addElementIcon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_ATTRIBUTES_GROUP_VALUE_ADD_ICON"));
            _addExpressionIcon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_ATTRIBUTES_GROUP_VALUE_ADD_EXPRESSION_ICON"));
            Class<WorkflowEditor> clazz2 = WorkflowEditor.class;
            _invalid_attribue_icon = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("USAGE_ATTRIBUTE_INVALID"));
            _valid_attribue_icon = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("USAGE_ATTRIBUTE"));
        }
        this.jLabelGroupBy.setHorizontalTextPosition(2);
        this.jLabelGroupBy.setText(AggregateDialogsLrb.get("AGGREGATE_EDITOR_GROUP_BY"));
        this.jBtnGroupBy.setText(AggregateDialogsLrb.get("AGGREGATE_EDITOR_EIT_BUTTON"));
    }

    private void installItemFilterActions(ControlBar controlBar) {
        this._wizBtn = new JButton(_wizIcon);
        this._wizBtn.setToolTipText(AggregateDialogsLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_CONFIGURE_TOOLTIP"));
        this._wizBtn.getAccessibleContext().setAccessibleName(AggregateDialogsLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_CONFIGURE"));
        this._wizBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregationNode aggregationNode = (AggregationNode)AggregationNodeAttributesPanel.this.getData();
                AbstractNode abstractNode = aggregationNode.findParentNode();
                assert (abstractNode instanceof AbstractDataNode);
                AggregationWizard aggregationWizard = new AggregationWizard();
                if (aggregationWizard.runWizard((Component)Ide.getMainWindow(), AggregationNodeAttributesPanel.this._context, aggregationNode, AggregationNodeAttributesPanel.this.cachedAggregationNodeType, (AbstractDataNode)abstractNode, false)) {
                    GeneralAttributesTableModel generalAttributesTableModel = new GeneralAttributesTableModel(AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement());
                    AggregationNodeAttributesPanel.this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
                    AggregationNodeAttributesPanel.this._jAttributesTable.setSorted(true);
                }
            }
        });
        controlBar.add((Component)this._wizBtn);
        this._editBtn = new JButton(_editIcon);
        this._editBtn.setToolTipText(InspectorArb.getString((int)25));
        this._editBtn.getAccessibleContext().setAccessibleName(InspectorArb.getString((int)23));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditAggregationAttributeDialog editAggregationAttributeDialog;
                int[] nArray = AggregationNodeAttributesPanel.this._jAttributesTable.getSelectedRowsInModel();
                assert (nArray.length == 1);
                GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)AggregationNodeAttributesPanel.this._jAttributesTable.getModel());
                AggregationElementType aggregationElementType = generalAttributesTableModel.getDataVector().get(nArray[0]);
                GroupingElementType groupingElementType = aggregationElementType.getSource();
                AggregationElementType aggregationElementType2 = null;
                AggregationNode aggregationNode = (AggregationNode)AggregationNodeAttributesPanel.this.getData();
                AbstractNode abstractNode = aggregationNode.findParentNode();
                assert (abstractNode instanceof AbstractDataNode);
                if (null != groupingElementType.getExpression()) {
                    EditAggregationExpressionDialog editAggregationExpressionDialog = new EditAggregationExpressionDialog(AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement(), AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getGroupingElement(), aggregationElementType);
                    if (editAggregationExpressionDialog.invoke(AggregationNodeAttributesPanel.this._context, (AggregationNode)AggregationNodeAttributesPanel.this.getData(), (AbstractDataNode)abstractNode)) {
                        aggregationElementType2 = editAggregationExpressionDialog.getNewAggregationElement();
                    }
                } else if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute() && (editAggregationAttributeDialog = new EditAggregationAttributeDialog(AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement(), AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getGroupingElement(), aggregationElementType)).invoke(AggregationNodeAttributesPanel.this._context, (AggregationNode)AggregationNodeAttributesPanel.this.getData(), (AbstractDataNode)abstractNode)) {
                    aggregationElementType2 = editAggregationAttributeDialog.getNewAggregationElement();
                }
                if (null != aggregationElementType2) {
                    AttributeTypeHelper.copyAggregationElementType(aggregationElementType, aggregationElementType2);
                    generalAttributesTableModel.fireTableDataChanged();
                    AggregationNodeAttributesPanel.this._jAttributesTable.setSelectedRowsInModel(nArray);
                }
            }
        });
        controlBar.add((Component)this._editBtn);
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(AggregateDialogsLrb.get("AGGREGRATION_COLUMNS_DELETE_TOOLTIP"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = AggregationNodeAttributesPanel.this._jAttributesTable.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)AggregationNodeAttributesPanel.this._jAttributesTable.getModel());
                    HashMap<String, AggregationElementType> hashMap = new HashMap<String, AggregationElementType>();
                    for (AggregationElementType aggregationElementType : AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement()) {
                        hashMap.put(aggregationElementType.getOutput().getName(), aggregationElementType);
                    }
                    ArrayList arrayList = new ArrayList();
                    for (int i = 0; i < nArray.length; ++i) {
                        AggregationElementType aggregationElementType = generalAttributesTableModel.getDataVector().get(nArray[i]);
                        if (null == hashMap.get(aggregationElementType.getOutput().getName())) continue;
                        arrayList.add(aggregationElementType);
                    }
                    if (!arrayList.isEmpty()) {
                        AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement().removeAll(arrayList);
                        generalAttributesTableModel = new GeneralAttributesTableModel(AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement());
                        AggregationNodeAttributesPanel.this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
                        AggregationNodeAttributesPanel.this._jAttributesTable.setSorted(true);
                    }
                }
            }
        });
        controlBar.add((Component)this._removeBtn);
        this._addElementBtn = new JButton(_addElementIcon);
        this._addElementBtn.setToolTipText(AggregateDialogsLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_ADD_ELEMENT"));
        this._addElementBtn.getAccessibleContext().setAccessibleName(AggregateDialogsLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_ADD_ELEMENT_TOOLTIP"));
        this._addElementBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddAggregationAttributeDialog addAggregationAttributeDialog = new AddAggregationAttributeDialog(AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement(), AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getGroupingElement());
                AggregationNode aggregationNode = (AggregationNode)AggregationNodeAttributesPanel.this.getData();
                AbstractNode abstractNode = aggregationNode.findParentNode();
                assert (abstractNode instanceof AbstractDataNode);
                if (addAggregationAttributeDialog.invoke(AggregationNodeAttributesPanel.this._context, (AggregationNode)AggregationNodeAttributesPanel.this.getData(), (AbstractDataNode)abstractNode)) {
                    AggregationElementType aggregationElementType = addAggregationAttributeDialog.getNewAggregationElement();
                    AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement().add(aggregationElementType);
                    GeneralAttributesTableModel generalAttributesTableModel = new GeneralAttributesTableModel(AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement());
                    AggregationNodeAttributesPanel.this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
                    AggregationNodeAttributesPanel.this._jAttributesTable.setSorted(true);
                }
            }
        });
        controlBar.add((Component)this._addElementBtn);
        this._addExpressionBtn = new JButton(_addExpressionIcon);
        this._addExpressionBtn.setToolTipText(AggregateDialogsLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_ADD_EXPRESSION"));
        this._addExpressionBtn.getAccessibleContext().setAccessibleName(AggregateDialogsLrb.get("PI_AGGREGATION_NODE_GROUP_COLUMNS_ADD_EXPRESSION_TOOLTIP"));
        this._addExpressionBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                GroupingElementType groupingElementType = AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getGroupingElement();
                boolean bl2 = bl = null == groupingElementType;
                if (!bl && null == groupingElementType.getExpression()) {
                    if (groupingElementType.getAttributes() == null) {
                        bl = true;
                    } else if (groupingElementType.getAttributes().getAttribute().isEmpty()) {
                        bl = true;
                    }
                }
                if (bl) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)AggregateDialogsLrb.get("AGGREGATION_NODE_GROUP_COLUMNS_ADD_EXPRESSION_DETAIL"), (String)AggregateDialogsLrb.get("AGGREGATION_NODE_GROUP_COLUMNS_ADD_EXPRESSION_TITLE"), null);
                    return;
                }
                AddAggregationExpressionDialog addAggregationExpressionDialog = new AddAggregationExpressionDialog(AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement(), AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getGroupingElement());
                AggregationNode aggregationNode = (AggregationNode)AggregationNodeAttributesPanel.this.getData();
                AbstractNode abstractNode = aggregationNode.findParentNode();
                assert (abstractNode instanceof AbstractDataNode);
                if (addAggregationExpressionDialog.invoke(AggregationNodeAttributesPanel.this._context, (AggregationNode)AggregationNodeAttributesPanel.this.getData(), (AbstractDataNode)abstractNode)) {
                    AggregationElementType aggregationElementType = addAggregationExpressionDialog.getNewAggregationElement();
                    AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement().add(aggregationElementType);
                    GeneralAttributesTableModel generalAttributesTableModel = new GeneralAttributesTableModel(AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement());
                    AggregationNodeAttributesPanel.this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
                    AggregationNodeAttributesPanel.this._jAttributesTable.setSorted(true);
                }
            }
        });
        controlBar.add((Component)this._addExpressionBtn);
    }

    @Override
    public void initUI() {
        Object object;
        AggregationNode aggregationNode = (AggregationNode)this.getData();
        AggregationNodeType aggregationNodeType = (AggregationNodeType)aggregationNode.getData();
        GroupingElementType groupingElementType = aggregationNodeType.getGroupingElement();
        GroupingElementType groupingElementType2 = aggregationNodeType.getGroupingElement();
        this.jTxtGroupBy.setEditable(false);
        this.jTxtGroupBy.setText(AttributeTypeHelper.convertGroupingElementTypetoString(groupingElementType));
        if (!this.isValidMainGroupBy(groupingElementType2)) {
            this.jLabelGroupBy.setIcon(_invalid_attribue_icon);
            this.jLabelGroupBy.setToolTipText(AggregateDialogsLrb.get("ADD_AGGREGATION_MAIN_GROUP_BY_INVALID"));
        } else {
            this.jLabelGroupBy.setIcon(null);
            this.jLabelGroupBy.setToolTipText(null);
        }
        List list = this.cachedAggregationNodeType.getAggregationElements().getAggregationElement();
        GeneralAttributesTableModel generalAttributesTableModel = new GeneralAttributesTableModel(list);
        this.setupItemsTable(generalAttributesTableModel);
        JScrollPane jScrollPane = new JScrollPane((Component)this._jAttributesTable);
        this.jAttributesComponent.setComponent((JComponent)jScrollPane);
        this.jAttributesComponent.setLabel(new JLabel(AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_GRID_TITLE")));
        ControlBar controlBar = new ControlBar();
        this.installItemFilterActions(controlBar);
        this.jAttributesComponent.setControlBar(controlBar);
        this._jAttributesTable.setFillsViewportHeight(true);
        this._jAttributesTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ListSelectionModel listSelectionModel;
                if (mouseEvent.getClickCount() == 2 && !(listSelectionModel = AggregationNodeAttributesPanel.this._jAttributesTable.getSelectionModel()).isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
                    EditAggregationAttributeDialog editAggregationAttributeDialog;
                    int[] nArray = AggregationNodeAttributesPanel.this._jAttributesTable.getSelectedRowsInModel();
                    GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)AggregationNodeAttributesPanel.this._jAttributesTable.getModel());
                    AggregationElementType aggregationElementType = generalAttributesTableModel.getDataVector().get(nArray[0]);
                    GroupingElementType groupingElementType = aggregationElementType.getSource();
                    AggregationElementType aggregationElementType2 = null;
                    AggregationNode aggregationNode = (AggregationNode)AggregationNodeAttributesPanel.this.getData();
                    AbstractNode abstractNode = aggregationNode.findParentNode();
                    assert (abstractNode instanceof AbstractDataNode);
                    if (null != groupingElementType.getExpression()) {
                        EditAggregationExpressionDialog editAggregationExpressionDialog = new EditAggregationExpressionDialog(AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement(), AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getGroupingElement(), aggregationElementType);
                        if (editAggregationExpressionDialog.invoke(AggregationNodeAttributesPanel.this._context, (AggregationNode)AggregationNodeAttributesPanel.this.getData(), (AbstractDataNode)abstractNode)) {
                            aggregationElementType2 = editAggregationExpressionDialog.getNewAggregationElement();
                        }
                    } else if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute() && (editAggregationAttributeDialog = new EditAggregationAttributeDialog(AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getAggregationElements().getAggregationElement(), AggregationNodeAttributesPanel.this.cachedAggregationNodeType.getGroupingElement(), aggregationElementType)).invoke(AggregationNodeAttributesPanel.this._context, (AggregationNode)AggregationNodeAttributesPanel.this.getData(), (AbstractDataNode)abstractNode)) {
                        aggregationElementType2 = editAggregationAttributeDialog.getNewAggregationElement();
                    }
                    if (null != aggregationElementType2) {
                        AttributeTypeHelper.copyAggregationElementType(aggregationElementType, aggregationElementType2);
                        generalAttributesTableModel.fireTableDataChanged();
                        AggregationNodeAttributesPanel.this._jAttributesTable.setSelectedRowsInModel(nArray);
                    }
                }
            }
        });
        boolean bl = false;
        AbstractNode abstractNode = aggregationNode.findParentNode();
        if (abstractNode != null && abstractNode instanceof DataProvider && null != (object = (DataProvider)((Object)abstractNode)).getAttributes()) {
            bl = null != object.getAttributes().getAttribute() && !object.getAttributes().getAttribute().isEmpty();
        }
        this._addElementBtn.setEnabled(bl);
        this._addExpressionBtn.setEnabled(bl);
        this._wizBtn.setEnabled(bl);
        object = this._jAttributesTable.getSelectionModel();
        this._removeBtn.setEnabled(!object.isSelectionEmpty());
        this._editBtn.setEnabled(!object.isSelectionEmpty() && object.getMinSelectionIndex() == object.getMaxSelectionIndex());
        object.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                AggregationNodeAttributesPanel.this._removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
                AggregationNodeAttributesPanel.this._editBtn.setEnabled(!listSelectionModel.isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex());
            }
        });
        AbstractDataNode abstractDataNode = (AbstractDataNode)aggregationNode.findParentNode();
        this.jBtnGroupBy.setEnabled(abstractDataNode != null && null != abstractDataNode.getAttributes() && null != abstractDataNode.getAttributes().getAttribute());
        this.jBtnGroupBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AggregationNode aggregationNode = (AggregationNode)AggregationNodeAttributesPanel.this.getData();
                    AbstractNode abstractNode = aggregationNode.findParentNode();
                    assert (abstractNode instanceof AbstractDataNode);
                    AggregateEditMainDialog aggregateEditMainDialog = new AggregateEditMainDialog(AggregationNodeAttributesPanel.this.cachedAggregationNodeType);
                    if (aggregateEditMainDialog.invoke(AggregationNodeAttributesPanel.this._context, aggregationNode, (AbstractDataNode)abstractNode)) {
                        GroupingElementType groupingElementType = aggregateEditMainDialog.getGroupByElement();
                        AggregationNodeAttributesPanel.this.cachedAggregationNodeType.setGroupingElement(groupingElementType);
                        AggregationNodeAttributesPanel.this.jTxtGroupBy.setText(AttributeTypeHelper.convertGroupingElementTypetoString(groupingElementType));
                        if (!AggregationNodeAttributesPanel.this.isValidMainGroupBy(groupingElementType)) {
                            AggregationNodeAttributesPanel.this.jLabelGroupBy.setIcon(_invalid_attribue_icon);
                            AggregationNodeAttributesPanel.this.jLabelGroupBy.setToolTipText(AggregateDialogsLrb.get("ADD_AGGREGATION_MAIN_GROUP_BY_INVALID"));
                        } else {
                            AggregationNodeAttributesPanel.this.jLabelGroupBy.setIcon(null);
                            AggregationNodeAttributesPanel.this.jLabelGroupBy.setToolTipText(null);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doWork() {
        boolean bl = true;
        if (null == this.cachedAggregationNodeType.getAggregationElements() || null == this.cachedAggregationNodeType.getAggregationElements().getAggregationElement()) {
            MessageDialog.error((Component)this, (Object)AggregateDialogsLrb.get("AGGREGATION_COLUMNS_MISSING"), (String)AggregateDialogsLrb.get("ERROR_CREATING_AGGREGATION"), null);
            return false;
        }
        AggregationNode aggregationNode = (AggregationNode)this.getData();
        CommandProcessor.getInstance().beginTrans(AggregateDialogsLrb.get("AGGREGATE_NODE_PROPERTIES_TRANSACTION_NAME"));
        try {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property("allAggregateNodeProperies", null, this.cachedAggregationNodeType, null, null));
            arrayList.add(new Property("SQL_EXPRESSION", null, "SQL_EXPRESSION_GENERATE", null, null));
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)aggregationNode.getUndoFilter();
            odmrSDMUndoFilter.prepareUndoPropertyList(aggregationNode, this._context, arrayList);
            aggregationNode.validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)AggregateDialogsLrb.get("EDIT_AGGREGATE_ELEMENTS_DIALOG_FAILURE_TITLE"), (String)AggregateDialogsLrb.get("EDIT_AGGREGATE_ELEMENTS_DIALOG_FAILURE_MSG"), null);
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
        return bl;
    }

    private void setupItemsTable(GeneralAttributesTableModel generalAttributesTableModel) {
        this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
        this._jAttributesTable.setSorted(true);
        this._jAttributesTable.setSortColumn(0, true);
        this._jAttributesTable.setAutoResizeMode(4);
        TableColumn tableColumn = this._jAttributesTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new CustomSourceCellRenderer());
    }

    private boolean isValidMainGroupBy(GroupingElementType groupingElementType) {
        AggregationNode aggregationNode = (AggregationNode)this.getData();
        AbstractNode abstractNode = aggregationNode.findParentNode();
        if (abstractNode != null && !(abstractNode instanceof DataProvider)) {
            return false;
        }
        DataProvider dataProvider = (DataProvider)((Object)abstractNode);
        if (null == dataProvider || null == dataProvider.getAttributes() || dataProvider.getAttributes().getAttribute().isEmpty()) {
            return false;
        }
        boolean bl = true;
        List list = dataProvider.getAttributes().getAttribute();
        Attributes attributes = groupingElementType.getAttributes();
        if (null != attributes) {
            List list2 = attributes.getAttribute();
            for (AttributeType attributeType : list2) {
                boolean bl2 = false;
                for (AttributeType attributeType2 : list) {
                    if (!attributeType.getName().equals(attributeType2.getName())) continue;
                    attributeType.setStatus(attributeType2.getStatus());
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    attributeType.setStatus(AttributeStatus.MISSING);
                }
                if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private void validateSourceColumn() {
        AggregationNode aggregationNode = (AggregationNode)this.getData();
        AbstractNode abstractNode = aggregationNode.findParentNode();
        if (abstractNode != null && !(abstractNode instanceof DataProvider)) {
            this.setStatusAllSourceColumns(this.cachedAggregationNodeType.getAggregationElements().getAggregationElement());
            return;
        }
        DataProvider dataProvider = (DataProvider)((Object)abstractNode);
        if (null == dataProvider || null == dataProvider.getAttributes() || dataProvider.getAttributes().getAttribute().isEmpty()) {
            this.setStatusAllSourceColumns(this.cachedAggregationNodeType.getAggregationElements().getAggregationElement());
            return;
        }
        List list = dataProvider.getAttributes().getAttribute();
        for (AggregationElementType aggregationElementType : this.cachedAggregationNodeType.getAggregationElements().getAggregationElement()) {
            this.validateSourceElement(list, aggregationElementType);
            this.validateSubGroupingBy(list, aggregationElementType);
        }
    }

    private void validateSourceElement(List<AttributeType> list, AggregationElementType aggregationElementType) {
        GroupingElementType groupingElementType = aggregationElementType.getSource();
        Attributes attributes = groupingElementType.getAttributes();
        if (null != attributes) {
            List list2 = attributes.getAttribute();
            for (AttributeType attributeType : list2) {
                boolean bl = false;
                for (AttributeType attributeType2 : list) {
                    if (!attributeType.getName().equals(attributeType2.getName())) continue;
                    attributeType.setStatus(attributeType2.getStatus());
                    aggregationElementType.getOutput().setStatus(attributeType2.getStatus());
                    bl = true;
                    break;
                }
                if (bl) continue;
                attributeType.setStatus(AttributeStatus.MISSING);
                aggregationElementType.getOutput().setStatus(AttributeStatus.MISSING);
            }
        }
    }

    private void validateSubGroupingBy(List<AttributeType> list, AggregationElementType aggregationElementType) {
        GroupingElementType groupingElementType = aggregationElementType.getSubGroupBy();
        Attributes attributes = groupingElementType.getAttributes();
        if (null != attributes) {
            List list2 = attributes.getAttribute();
            for (AttributeType attributeType : list2) {
                boolean bl = false;
                for (AttributeType attributeType2 : list) {
                    if (!attributeType.getName().equals(attributeType2.getName())) continue;
                    aggregationElementType.getOutput().setStatus(attributeType2.getStatus());
                    bl = true;
                    break;
                }
                if (!bl) {
                    aggregationElementType.getOutput().setStatus(AttributeStatus.MISSING);
                }
                if (!aggregationElementType.getOutput().getStatus().equals((Object)AttributeStatus.MISSING)) continue;
                break;
            }
        }
    }

    private void setStatusAllSourceColumns(List<AggregationElementType> list) {
        AttributeStatus attributeStatus = AttributeStatus.MISSING;
        for (AggregationElementType aggregationElementType : list) {
            Attributes attributes = aggregationElementType.getSource().getAttributes();
            if (null != attributes) {
                List list2 = attributes.getAttribute();
                for (AttributeType attributeType : list2) {
                    attributeType.setStatus(attributeStatus);
                }
            }
            aggregationElementType.getOutput().setStatus(attributeStatus);
        }
    }

    private class GeneralAttributesTableModel
    extends GenericBaseTableModel {
        private List<AggregationElementType> _srcData;

        GeneralAttributesTableModel(List<AggregationElementType> list) {
            this._srcData = new ArrayList<AggregationElementType>(list.size());
            this._srcData.addAll(list);
            this.setRowCount(this._srcData.size());
            this.setColumnIdentifiers(AggregationNodeAttributesPanel.this._columnNames);
            this.setColumnCount(4);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public Vector<AggregationElementType> getDataVector() {
            return new Vector<AggregationElementType>(this._srcData);
        }

        public void clearRows() {
            this._srcData.clear();
            this.setRowCount(0);
            this.fireTableDataChanged();
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            AggregationElementType aggregationElementType = this._srcData.get(n);
            String string = null;
            if (n2 == 0) {
                GroupingElementType groupingElementType = aggregationElementType.getSource();
                if (null == groupingElementType.getExpression()) {
                    List list = groupingElementType.getAttributes().getAttribute();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (AttributeType attributeType : list) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(attributeType.getName());
                    }
                    string = stringBuilder.toString();
                } else {
                    string = groupingElementType.getExpression();
                }
            } else if (n2 == 1) {
                AttributeType attributeType = aggregationElementType.getOutput();
                string = attributeType.getName();
            } else if (n2 == 2) {
                string = aggregationElementType.getAggregationFunction();
            } else if (n2 == 3) {
                GroupingElementType groupingElementType = aggregationElementType.getSubGroupBy();
                if (null == groupingElementType.getExpression()) {
                    if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute()) {
                        List list = groupingElementType.getAttributes().getAttribute();
                        StringBuilder stringBuilder = new StringBuilder();
                        for (AttributeType attributeType : list) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(attributeType.getName());
                        }
                        string = stringBuilder.toString();
                    }
                } else {
                    string = groupingElementType.getExpression();
                }
            } else assert (false) : "Out of bounds column when accessing items";
            return string != null ? string : "";
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public TableModel getModel() {
            return this;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    private class CustomSourceCellRenderer
    extends DefaultTableCellRenderer {
        private CustomSourceCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            AggregationNode aggregationNode;
            AbstractNode abstractNode;
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl3 = false;
            GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)AggregationNodeAttributesPanel.this._jAttributesTable.getModel());
            int n3 = AggregationNodeAttributesPanel.this._jAttributesTable.convertRowIndexToModel(n);
            AggregationElementType aggregationElementType = generalAttributesTableModel.getDataVector().get(n3);
            Attributes attributes = aggregationElementType.getSource().getAttributes();
            if (null != attributes && null != attributes.getAttribute()) {
                List list = attributes.getAttribute();
                if (!list.isEmpty()) {
                    for (AttributeType attributeType : list) {
                        if (!attributeType.getName().equals(object.toString()) || 0 != attributeType.getStatus().compareTo((Enum)AttributeStatus.VALID)) continue;
                        bl3 = true;
                        break;
                    }
                }
            } else if (null != aggregationElementType.getSource().getExpression() && (abstractNode = (aggregationNode = (AggregationNode)AggregationNodeAttributesPanel.this.getData()).findParentNode()) != null && abstractNode instanceof DataProvider) {
                DataProvider dataProvider = (DataProvider)((Object)abstractNode);
                bl3 = null != dataProvider && null != dataProvider.getAttributes() && !dataProvider.getAttributes().getAttribute().isEmpty();
            }
            this.setIcon(bl3 ? _valid_attribue_icon : _invalid_attribue_icon);
            return component;
        }
    }
}

