/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.aggregate;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateEditMainPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerAttributesDialog;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AggregationNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementType;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.ExceptionDialog;

public class AggregateEditMainDialog
extends DataConsumerAttributesDialog<AggregationNode> {
    private AggregateEditMainPanel content;
    private AggregationNodeType cachedAggregationNodeData;
    private AggregationElementType cachedAggregationElement;
    private GroupingElementType mainGroupBy;

    public AggregateEditMainDialog(AggregationNodeType aggregationNodeType) {
        this.cachedAggregationNodeData = aggregationNodeType;
    }

    public AggregateEditMainDialog(AggregationElementType aggregationElementType, GroupingElementType groupingElementType) {
        this.cachedAggregationElement = aggregationElementType;
        this.mainGroupBy = groupingElementType;
    }

    @Override
    protected void registerHelp(JEWTDialog jEWTDialog) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "aggregation_node_edit_group");
    }

    @Override
    protected JEWTDialog buildDialog(Context context, AggregationNode aggregationNode, AbstractDataNode abstractDataNode) {
        List<AttributeType> list = this.getAvailableAttributes(abstractDataNode);
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        for (AttributeType attributeType : list) {
            String string = attributeType.getDataType();
            try {
                if (!DatabaseMetadataUtils.isDataTypeSupported(string) || DatabaseMetadataUtils.isACustomDataType(context, string)) continue;
                arrayList.add(attributeType);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
            }
        }
        if (this.cachedAggregationNodeData != null) {
            this.content = new AggregateEditMainPanel(context, abstractDataNode, this.cachedAggregationNodeData, arrayList);
        } else if (this.cachedAggregationElement != null) {
            this.content = new AggregateEditMainPanel(context, abstractDataNode, this.cachedAggregationElement, this.mainGroupBy, arrayList);
        }
        return super.buildDialog(context, (JPanel)((Object)this.content));
    }

    public GroupingElementType getGroupByElement() {
        return this.content.getGroupByElement();
    }

    @Override
    protected String getDialogTitle() {
        return AggregateDialogsLrb.get("ADD_AGGREGATE_MAIN_GROUP_BY_DIALOG_TITLE");
    }
}

