/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.aggregate;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AddAggregationAttributePanel;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerAttributesDialog;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AggregationNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.ExceptionDialog;

public class AddAggregationAttributeDialog
extends DataConsumerAttributesDialog<AggregationNode> {
    protected List<AggregationElementType> allAggregationColumns;
    protected GroupingElementType mainGroupBy;
    protected AddAggregationAttributePanel content;

    public AddAggregationAttributeDialog(List<AggregationElementType> list, GroupingElementType groupingElementType) {
        this.allAggregationColumns = list;
        this.mainGroupBy = groupingElementType;
    }

    @Override
    protected JEWTDialog buildDialog(Context context, AggregationNode aggregationNode, AbstractDataNode abstractDataNode) {
        List<AttributeType> list = this.getAvailableAttributes(abstractDataNode);
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        for (AttributeType attributeType : list) {
            String string = attributeType.getDataType();
            try {
                if (!DatabaseMetadataUtils.isDataTypeSupported(string) || DatabaseMetadataUtils.isACustomDataType(context, string)) continue;
                arrayList.add(attributeType);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
            }
        }
        this.content = new AddAggregationAttributePanel(context, aggregationNode, this.mainGroupBy, this.allAggregationColumns, arrayList);
        return super.buildDialog(context, this.content);
    }

    @Override
    protected String getDialogTitle() {
        return AggregateDialogsLrb.get("ADD_AGGREGATE_ELEMENT_DIALOG_TITLE");
    }

    @Override
    protected void registerHelp(JEWTDialog jEWTDialog) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "aggregation_node_add_element");
    }

    public AggregationElementType getNewAggregationElement() {
        return this.content.getNewAggregationElement();
    }
}

