/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.dialog.WorkflowDialogLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;

public class AttributeNameCellRenderer
extends DefaultTableCellRenderer {
    private Icon validIcon;
    private Icon invalidIcon;
    private static Icon targetIcon = UIResourceHelper.getImageIcon(AttributeNameCellRenderer.class, WorkflowDialogLrb.get("TARGET_ICON"));
    private static Icon keyIdIcon = UIResourceHelper.getImageIcon(AttributeNameCellRenderer.class, WorkflowDialogLrb.get("KEY_ICON"));
    private String targetName;
    private List<String> keyNames;

    public AttributeNameCellRenderer(Icon icon, Icon icon2) {
        this.validIcon = icon;
        this.invalidIcon = icon2;
        this.keyNames = new ArrayList<String>();
    }

    public void setTargetName(String string) {
        this.targetName = string;
    }

    public void setKeyNames(List<String> list) {
        this.keyNames = list;
    }

    @Override
    public void setValue(Object object) {
        AttributeType attributeType = (AttributeType)object;
        this.setText(attributeType.getName());
        if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
            if (this.targetName != null && attributeType.getName().equals(this.targetName)) {
                this.setIcon(targetIcon);
            } else if (this.keyNames.contains(attributeType.getName())) {
                this.setIcon(keyIdIcon);
            } else {
                this.setIcon(this.validIcon);
            }
        } else {
            this.setIcon(this.invalidIcon);
        }
    }
}

