/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.codegen;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.Calendar;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.FileHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeGenPreferences;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class GenerateCode
implements ClipboardOwner {
    Context _context;
    WorkflowEditor _editor;
    Node _node;
    CODE_GENERATION_OPTION _option;
    Exception _exception = null;
    public final String CODE_GEN_SKIPPED_INFORMATION = "CODE_GEN_SKIPPED_INFORMATION:" + this.getClass().getName();
    private String WORKFLOW_HEADER = "SQL Deployed by " + Ide.getProgramName() + " " + Ide.getProductVersion() + " from Node \"<NODE_NAME>\", Workflow \"<WORKFLOW_NAME>\", Project \"<PROJECT_NAME>\", Connection \"<CONNECTION_NAME>\" on <DEPLOY_DATE>";

    public Exception getException() {
        return this._exception;
    }

    public GenerateCode(Context context, Node node, WorkflowEditor workflowEditor, CODE_GENERATION_OPTION cODE_GENERATION_OPTION) {
        this._context = context;
        this._node = node;
        this._editor = workflowEditor;
        this._option = cODE_GENERATION_OPTION;
    }

    public boolean run() {
        boolean bl = true;
        if (this._option == null) {
            return false;
        }
        MessageDialog.optionalInformation((String)this.CODE_GEN_SKIPPED_INFORMATION, (Component)Ide.getMainWindow(), (String)CodeGenLrb.get("GENERATE_CODE_DESCRIPTION_SQL"), (String)CodeGenLrb.get("GENERATE_CODE_TITLE"), null);
        try {
            if (this._option.equals((Object)CODE_GENERATION_OPTION.SQL_TO_CLIPBOARD)) {
                this.setClipboardContents(this.getSQLContents());
            } else if (this._option.equals((Object)CODE_GENERATION_OPTION.SQL_TO_FILE)) {
                bl = this.saveToFile(this.getSQLContents(), CodeGenLrb.get("FILE_EXTENSION_SQL_DESCRIPTION"), "sql");
            } else if (this._option.equals((Object)CODE_GENERATION_OPTION.SQL_SCRIPT_TO_CLIPBOARD)) {
                this.setClipboardContents(this.getSQLScriptContents());
            } else if (this._option.equals((Object)CODE_GENERATION_OPTION.SQL_SCRIPT_TO_FILE)) {
                bl = this.saveToFile(this.getSQLScriptContents(), CodeGenLrb.get("FILE_EXTENSION_SQL_SCRIPT_DESCRIPTION"), "sql");
            }
        }
        catch (Exception exception) {
            this._exception = exception;
            bl = false;
        }
        return bl;
    }

    private String getSQLScriptContents() throws Exception {
        return "/* " + this.generateHeader() + " */\n" + this.generateSQLFixes() + this.getLineageSQLScript();
    }

    private String getLineageSQLScript() throws Exception {
        NodeType nodeType = this._node.getData();
        WorkflowModel workflowModel = this._editor.getWorkflowNode().getWorkflowModel();
        if (workflowModel == null) {
            return "";
        }
        AbstractDataNode abstractDataNode = (AbstractDataNode)workflowModel.findNodeByMetadataId(nodeType.getId());
        if (abstractDataNode == null) {
            return "";
        }
        return abstractDataNode.getLineageSQLDefinition().generateSQLScript();
    }

    private String getSQLContents() {
        return "/* " + this.generateHeader() + " */\n" + this.generateSQLFixes() + this.getStackedSQL();
    }

    private String getStackedSQL() {
        NodeType nodeType = this._node.getData();
        WorkflowModel workflowModel = this._editor.getWorkflowNode().getWorkflowModel();
        if (workflowModel == null) {
            return "";
        }
        AbstractDataNode abstractDataNode = (AbstractDataNode)workflowModel.findNodeByMetadataId(nodeType.getId());
        if (abstractDataNode == null) {
            return "";
        }
        return abstractDataNode.getStackedSQL(workflowModel, true);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void setClipboardContents(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveToFile(String string, String string2, String string3) {
        boolean bl = false;
        FileOutputStream fileOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            int n;
            String string4;
            Preferences preferences = Preferences.getPreferences();
            CodeGenPreferences codeGenPreferences = CodeGenPreferences.getInstance((PropertyStorage)preferences);
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(string2, string3);
            String string5 = codeGenPreferences.getCodeLocation();
            JFileChooser jFileChooser = string5 != null ? new JFileChooser(string5) : new JFileChooser();
            jFileChooser.setDialogType(1);
            String string6 = string4 = this.generateDefaultFileName();
            File file = new File(string5 + "\\" + string6 + "." + string3);
            int n2 = 1;
            while (file.exists()) {
                string6 = string4 + n2;
                file = new File(string5 + "\\" + string6 + "." + string3);
                ++n2;
            }
            jFileChooser.setSelectedFile(new File(string6 + "." + string3));
            jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
            String string7 = "";
            boolean bl2 = false;
            boolean bl3 = true;
            while (bl3) {
                n = jFileChooser.showSaveDialog((Component)Ide.getMainWindow());
                if (!n) {
                    string7 = jFileChooser.getSelectedFile().getAbsolutePath();
                    if (string7.trim().length() == 0) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)CodeGenLrb.get("GENERATE_CODE_EMPTY_FILE_NAME"), (String)CodeGenLrb.get("GENERATE_CODE_TITLE"), null);
                        continue;
                    }
                    bl3 = false;
                    codeGenPreferences.setCodeLocation(string7);
                    continue;
                }
                bl3 = false;
                bl2 = true;
            }
            if (bl2) {
                n = 1;
                return n != 0;
            }
            File file2 = new File(string7);
            String string8 = file2.getName();
            if (!FileHelper.isFileNameWithSuffix(string8)) {
                String string9 = string7 + "." + string3;
                file2 = new File(string9);
            }
            if (file2 != null && file2.exists() && !MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)CodeGenLrb.get("GENERATE_CODE_FILE_OVERWRITE"), (String)CodeGenLrb.get("GENERATE_CODE_TITLE"), null, (boolean)true)) {
                boolean bl4 = true;
                return bl4;
            }
            fileOutputStream = new FileOutputStream(file2);
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
            outputStreamWriter.write(string);
            bl = true;
            return bl;
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            return bl;
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (Exception exception) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String generateDefaultFileName() {
        String string = this._editor.getWorkflow().getName() + "-" + this._node.getData().getName();
        string = StringUtils.getReplacedString(string, " ", "_");
        return string;
    }

    public static String cleanUpNodeNameForSQLComments(String string) {
        string = StringUtils.getReplacedString(string, "&", "_");
        string = StringUtils.getReplacedString(string, "--", "_");
        return string;
    }

    private String generateHeader() {
        String string = "";
        String string2 = GenerateCode.cleanUpNodeNameForSQLComments(this._node.getData().getName());
        string = StringUtils.getReplacedString(this.WORKFLOW_HEADER, "<NODE_NAME>", string2);
        String string3 = GenerateCode.cleanUpNodeNameForSQLComments(this._editor.getWorkflow().getName());
        string = StringUtils.getReplacedString(string, "<WORKFLOW_NAME>", string3);
        String string4 = GenerateCode.cleanUpNodeNameForSQLComments(ProjectFolder.getProjectFolder(this._context).getLabel());
        string = StringUtils.getReplacedString(string, "<PROJECT_NAME>", string4);
        String string5 = GenerateCode.cleanUpNodeNameForSQLComments(ConnectionFolder.getConnectionFolder(this._context).getConnectionName());
        string = StringUtils.getReplacedString(string, "<CONNECTION_NAME>", string5);
        string = StringUtils.getReplacedString(string, "<DEPLOY_DATE>", DateFormat.getDateInstance().format(Calendar.getInstance().getTime()));
        return string;
    }

    public static String replaceSourceNamesWithParms(String string) {
        return "";
    }

    public String generateSQLFixes() {
        String string = "";
        String[] stringArray = ConnectionFolder.getConnectionAlterSessionFixes();
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i] + ";\n";
        }
        if (string.length() > 0) {
            string = "--ALTER SESSION FOR OPTIMIZER\n" + string;
        }
        return string;
    }

    public static enum CODE_GENERATION_OPTION {
        SQL_TO_CLIPBOARD,
        SQL_TO_FILE,
        SQL_SCRIPT_TO_CLIPBOARD,
        SQL_SCRIPT_TO_FILE;

    }
}

