/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow;

import ilog.views.IlvGraphic;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.undo.SDMUndoFilter;
import oracle.dmt.dataminer.generated.server.OdmrObjectNames;
import oracle.dmt.dataminer.generated.server.OdmrWorkflow;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.net.DMURLFormatHelper;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.Model;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ModelNode;
import oracle.dmt.dataminer.workflow.model.UpdateTableNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageType;
import oracle.dmt.dataminer.workflow.xmlschema.Messages;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TableType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.WorkflowProcess;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class WorkflowUtils {
    private static String _table_name_prefix = "OUTPUT_";
    private static String _text_table_name_prefix = "TEXT_FEAT_";
    protected static final String ODMR_USER_WORKFLOW_MODELS = "ODMR_USER_WORKFLOW_MODELS";
    protected static final String MODEL_NAME = "NAME";

    public static WorkflowModel getWorkflowModel(WorkflowNode workflowNode) throws Exception {
        IlvSDMEngine ilvSDMEngine = workflowNode.getEngine();
        SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
        WorkflowModel workflowModel = WorkflowUtils.getFilteredModel(sDMUndoFilter);
        return workflowModel;
    }

    public static WorkflowModel getWorkflowModel(IlvSDMEngine ilvSDMEngine) {
        SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
        WorkflowModel workflowModel = WorkflowUtils.getFilteredModel(sDMUndoFilter);
        return workflowModel;
    }

    public static IlvPoint getViewPoint(AbstractNode abstractNode, IlvManagerView ilvManagerView) {
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        IlvGraphic ilvGraphic = ilvSDMEngine.getGraphic((Object)abstractNode, true);
        IlvTransformer ilvTransformer = ilvManagerView.getTransformer();
        IlvPoint ilvPoint = ilvGraphic.getCenter(ilvTransformer);
        return ilvPoint;
    }

    public static List<Object> getSelectedObjects(Context context) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Node node = context.getNode();
        if (node instanceof WorkflowNode) {
            try {
                IlvSDMEngine ilvSDMEngine = ((WorkflowNode)node).getEngine();
                Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
                while (enumeration.hasMoreElements()) {
                    arrayList.add(enumeration.nextElement());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return arrayList;
    }

    public static WorkflowModel getFilteredModel(SDMUndoFilter sDMUndoFilter) {
        IlvSDMModel ilvSDMModel = sDMUndoFilter.getFilteredModel();
        WorkflowModel workflowModel = (WorkflowModel)ilvSDMModel;
        return workflowModel;
    }

    public static String getTranslatedNodeStatus(NodeStatusType nodeStatusType) {
        String string = "unknown";
        if (nodeStatusType == null) {
            return string;
        }
        if (nodeStatusType.equals((Object)NodeStatusType.READY)) {
            string = WorkflowEditorLrb.get("NODE_STATUS_READY");
        } else if (nodeStatusType.equals((Object)NodeStatusType.COMPLETE)) {
            string = WorkflowEditorLrb.get("NODE_STATUS_COMPLETE");
        } else if (nodeStatusType.equals((Object)NodeStatusType.FAILURE)) {
            string = WorkflowEditorLrb.get("NODE_STATUS_FAILURE");
        } else if (nodeStatusType.equals((Object)NodeStatusType.WARNING)) {
            string = WorkflowEditorLrb.get("NODE_STATUS_WARNING");
        } else if (nodeStatusType.equals((Object)NodeStatusType.INVALID)) {
            string = WorkflowEditorLrb.get("NODE_STATUS_INVALID");
        }
        return string;
    }

    private static ModelNameGeneratingInfo getModelPrefixInfo(WorkflowProcess.Nodes nodes, String string, String string2) {
        ModelNameGeneratingInfo modelNameGeneratingInfo = new ModelNameGeneratingInfo();
        List<ModelType> list = null;
        if (string.equals("CLASSIFICATION")) {
            list = WorkflowUtils.findAlgorithmSpecificClassificationModels(nodes, string2);
            if (ServerConstants.Algorithm.isDT(string2)) {
                modelNameGeneratingInfo.prefix = "CLAS_DT";
            } else if (ServerConstants.Algorithm.isSVM(string2)) {
                modelNameGeneratingInfo.prefix = "CLAS_SVM";
            } else if (ServerConstants.Algorithm.isGLM(string2)) {
                modelNameGeneratingInfo.prefix = "CLAS_GLM";
            } else if (ServerConstants.Algorithm.isNB(string2)) {
                modelNameGeneratingInfo.prefix = "CLAS_NB";
            }
        } else if (string.equals("REGRESSION")) {
            list = WorkflowUtils.findAlgorithmSpecificRegressionModels(nodes, string2);
            if (ServerConstants.Algorithm.isSVM(string2)) {
                modelNameGeneratingInfo.prefix = "REGR_SVM";
            } else if (ServerConstants.Algorithm.isGLM(string2)) {
                modelNameGeneratingInfo.prefix = "REGR_GLM";
            }
        } else if (string.equals("CLUSTERING")) {
            list = WorkflowUtils.findAlgorithmSpecificClusteringModels(nodes, string2);
            if (ServerConstants.Algorithm.isKM(string2)) {
                modelNameGeneratingInfo.prefix = "CLUS_KM";
            } else if (ServerConstants.Algorithm.isOC(string2)) {
                modelNameGeneratingInfo.prefix = "CLUS_OC";
            }
        } else if (string.equals("FEATURE_EXTRACTION")) {
            list = WorkflowUtils.findAlgorithmSpecificNMFModels(nodes, string2);
            modelNameGeneratingInfo.prefix = "FEAT_NMF";
        } else if (string.equals("ANOMALY_DETECTION")) {
            list = WorkflowUtils.findAlgorithmSpecificAnomalyModels(nodes, string2);
            modelNameGeneratingInfo.prefix = "ANOM_SVM";
        } else if (string.equals("ASSOCIATION")) {
            list = WorkflowUtils.findAlgorithmSpecificARModels(nodes, string2);
            modelNameGeneratingInfo.prefix = "ASSOC_AP";
        }
        modelNameGeneratingInfo.modelStartingIndex = 0;
        modelNameGeneratingInfo.modelStartingIndex = list == null || list.isEmpty() ? 1 : list.size() + 1;
        return modelNameGeneratingInfo;
    }

    public static String getNewModelNameWfid(Context context, Collection<String> collection, String string, String string2) throws Exception {
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        BigDecimal bigDecimal = ((Workflow)workflowNode.getRepositoryData()).getId();
        assert (bigDecimal != null);
        WorkflowProcess workflowProcess = ((Workflow)workflowNode.getRepositoryData()).getWorkflowProcess();
        WorkflowProcess.Nodes nodes = workflowProcess.getNodes();
        ModelNameGeneratingInfo modelNameGeneratingInfo = WorkflowUtils.getModelPrefixInfo(nodes, string, string2);
        String string3 = modelNameGeneratingInfo.prefix + "_" + modelNameGeneratingInfo.modelStartingIndex + "_" + bigDecimal.intValue();
        if (collection != null) {
            while (collection.contains(string3)) {
                string3 = modelNameGeneratingInfo.prefix + "_" + ++modelNameGeneratingInfo.modelStartingIndex + "_" + bigDecimal.intValue();
            }
        } else {
            Collection<String> collection2 = WorkflowUtils.getAllInMemoryModelNames(context);
            while (collection2.contains(string3)) {
                string3 = modelNameGeneratingInfo.prefix + "_" + ++modelNameGeneratingInfo.modelStartingIndex + "_" + bigDecimal.intValue();
            }
        }
        string3 = WorkflowUtils.checkCreatedModelName(context, modelNameGeneratingInfo.prefix, modelNameGeneratingInfo.modelStartingIndex, bigDecimal.intValue(), collection);
        return string3;
    }

    private static String getRenamedModelNamesWfid(Context context, String string, Collection<String> collection, Map<String, String> map) throws Exception {
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        BigDecimal bigDecimal = ((Workflow)workflowNode.getRepositoryData()).getId();
        assert (bigDecimal != null);
        int n = 0;
        String string2 = string;
        WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
        Set<String> set = workflowModel.getAllMiningModels().keySet();
        Collection<String> collection2 = WorkflowUtils.getAllInMemoryModelNames(context);
        if (!workflowModel.isDuplicateBuildModelName(string2)) {
            collection2.remove(string2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<String> set2 = map.keySet();
        arrayList.addAll(collection2);
        arrayList.addAll(set);
        arrayList.addAll(collection);
        arrayList.addAll(set2);
        boolean bl = false;
        if (string2.length() >= 22) {
            string = string.substring(0, string2.length() - 3);
        }
        while (!bl) {
            if (!arrayList.contains(string2)) {
                bl = true;
                continue;
            }
            string2 = WorkflowUtils.generateName(string, ++n, bigDecimal.intValue(), 25);
        }
        return string2;
    }

    private static String getNewModelNamesWfid(Context context, String string, String string2, Collection<String> collection, Map<String, String> map) throws Exception {
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        BigDecimal bigDecimal = ((Workflow)workflowNode.getRepositoryData()).getId();
        assert (bigDecimal != null);
        WorkflowProcess workflowProcess = ((Workflow)workflowNode.getRepositoryData()).getWorkflowProcess();
        WorkflowProcess.Nodes nodes = workflowProcess.getNodes();
        ModelNameGeneratingInfo modelNameGeneratingInfo = WorkflowUtils.getModelPrefixInfo(nodes, string, string2);
        Collection<String> collection2 = WorkflowUtils.getAllInMemoryModelNames(context);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(collection);
        arrayList.addAll(collection2);
        arrayList.addAll(map.keySet());
        String string3 = modelNameGeneratingInfo.prefix + "_" + modelNameGeneratingInfo.modelStartingIndex + "_" + bigDecimal.intValue();
        while (arrayList.contains(string3)) {
            string3 = modelNameGeneratingInfo.prefix + "_" + ++modelNameGeneratingInfo.modelStartingIndex + "_" + bigDecimal.intValue();
        }
        return string3;
    }

    public static String checkCreatedModelName(final Context context, final String string, int n, final int n2, final Collection<String> collection) {
        String string2 = null;
        class Worker
        extends ProgressRunnable {
            private boolean _canceled;
            private String _modelName;
            private int _modelIndex;

            Worker() {
            }

            public String getModelName() {
                return this._modelName;
            }

            protected Object doWork() throws Exception {
                Connection connection = null;
                try {
                    connection = Connections.getUniqueConnection(context);
                    Collection<String> collection2 = WorkflowUtils.getUserWorkflowModelNames(connection);
                    this._modelName = WorkflowUtils.composeModelName(string, this._modelIndex, n2);
                    while (collection2.contains(this._modelName)) {
                        this._modelName = WorkflowUtils.composeModelName(string, ++this._modelIndex, n2);
                    }
                    Map<String, String> map = Model.getAllModelNames(connection);
                    this._modelName = WorkflowUtils.composeModelName(string, this._modelIndex, n2);
                    while (null != map.get(this._modelName)) {
                        this._modelName = WorkflowUtils.composeModelName(string, ++this._modelIndex, n2);
                    }
                    this._modelName = WorkflowUtils.composeModelName(string, this._modelIndex, n2);
                    while (collection.contains(this._modelName)) {
                        this._modelName = WorkflowUtils.composeModelName(string, ++this._modelIndex, n2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                return this._modelName;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this._canceled = true;
            }

            public boolean isCanceled() {
                return this._canceled;
            }
        }
        Worker worker = new Worker();
        worker._modelIndex = n;
        worker.setTitle(BuildEditorLrb.get("CREATE_NODE"));
        worker.setMessage(BuildEditorLrb.get("CREATE_NODE_DESCR"));
        worker.setCancelable(false);
        try {
            worker.start(true);
            if (!worker.isCanceled()) {
                string2 = worker.getModelName();
            }
        }
        catch (ProgressException progressException) {
            progressException.printStackTrace();
        }
        return string2;
    }

    private static String composeModelName(String string, int n, int n2) {
        return string + "_" + n + "_" + n2;
    }

    public static String getNewTableName(Context context, String string) throws Exception {
        String string2 = null;
        String string3 = string == null ? "" : string;
        int n = string3.length();
        if (n > 30) {
            throw new Exception("Unable to create table/view name. Prefix length greater than 30");
        }
        if (n == 0) {
            throw new Exception("Unable to create table/view name. Prefix length equal 0");
        }
        Connection connection = null;
        try {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
            String string4 = connectionFolder.getUserAccountName();
            connection = Connections.getUniqueConnection(context);
            boolean bl = true;
            int n2 = 1;
            String string5 = string3;
            while (bl) {
                if (DatabaseMetadataUtils.datasourceExists(connection, string4, string5)) {
                    string5 = string3 + "_" + n2;
                    ++n2;
                    continue;
                }
                string2 = string5;
                bl = false;
            }
            if (string2.length() > 30) {
                throw new Exception("Unable to generate a name under 30 characters.");
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return string2;
    }

    private static List<ModelType> findAlgorithmSpecificARModels(WorkflowProcess.Nodes nodes, String string) {
        List list = nodes.getAssociationBuild();
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        for (AssociationBuildNodeType associationBuildNodeType : list) {
            AssociationBuildNodeType.Models models = associationBuildNodeType.getModels();
            arrayList.addAll(models.getAprioriModel());
        }
        return arrayList;
    }

    private static List<ModelType> findAlgorithmSpecificAnomalyModels(WorkflowProcess.Nodes nodes, String string) {
        List list = nodes.getAnomalyDetectionBuild();
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        for (AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType : list) {
            AnomalyDetectionBuildNodeType.Models models = anomalyDetectionBuildNodeType.getModels();
            arrayList.addAll(models.getAnomalyDetectionModel());
        }
        return arrayList;
    }

    private static List<ModelType> findAlgorithmSpecificNMFModels(WorkflowProcess.Nodes nodes, String string) {
        List list = nodes.getFeatureExtractionBuild();
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        for (FeatureExtractionBuildNodeType featureExtractionBuildNodeType : list) {
            FeatureExtractionBuildNodeType.Models models = featureExtractionBuildNodeType.getModels();
            arrayList.addAll(models.getNonNegativeMatrixFactorModel());
        }
        return arrayList;
    }

    private static List<ModelType> findAlgorithmSpecificClusteringModels(WorkflowProcess.Nodes nodes, String string) {
        List list = nodes.getClusteringBuild();
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        for (ClusteringBuildNodeType clusteringBuildNodeType : list) {
            ClusteringBuildNodeType.Models models = clusteringBuildNodeType.getModels();
            if (ServerConstants.Algorithm.isKM(string)) {
                arrayList.addAll(models.getKMeansModel());
                continue;
            }
            if (!ServerConstants.Algorithm.isOC(string)) continue;
            arrayList.addAll(models.getOClusterModel());
        }
        return arrayList;
    }

    private static List<ModelType> findAlgorithmSpecificRegressionModels(WorkflowProcess.Nodes nodes, String string) {
        List list = nodes.getRegressionBuild();
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        for (RegressionBuildNodeType regressionBuildNodeType : list) {
            RegressionBuildNodeType.Models models = regressionBuildNodeType.getModels();
            if (ServerConstants.Algorithm.isSVM(string)) {
                arrayList.addAll(models.getRSupportVectorMachineModel());
                continue;
            }
            if (!ServerConstants.Algorithm.isGLM(string)) continue;
            arrayList.addAll(models.getRGeneralizedLinearModel());
        }
        return arrayList;
    }

    private static List<ModelType> findAlgorithmSpecificClassificationModels(WorkflowProcess.Nodes nodes, String string) {
        List list = nodes.getClassificationBuild();
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        for (ClassificationBuildNodeType classificationBuildNodeType : list) {
            ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
            if (ServerConstants.Algorithm.isDT(string)) {
                arrayList.addAll(models.getDecisionTreeModel());
                continue;
            }
            if (ServerConstants.Algorithm.isSVM(string)) {
                arrayList.addAll(models.getCSupportVectorMachineModel());
                continue;
            }
            if (ServerConstants.Algorithm.isGLM(string)) {
                arrayList.addAll(models.getCGeneralizedLinearModel());
                continue;
            }
            if (!ServerConstants.Algorithm.isNB(string)) continue;
            arrayList.addAll(models.getNaiveBayesModel());
        }
        return arrayList;
    }

    public static Map<String, RefModelType> refactorModels(Context context, List<RefModelType> list, WorkflowModel workflowModel, boolean bl) {
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        return WorkflowUtils.refactorModels(context, list, arrayList, workflowModel, bl);
    }

    public static Map<String, RefModelType> refactorModels(final Context context, final List<RefModelType> list, final List<ModelType> list2, final WorkflowModel workflowModel, final boolean bl) {
        Map<String, RefModelType> map = null;
        class Worker
        extends ProgressRunnable {
            private boolean _canceled;
            private Map<String, RefModelType> _renamedModels = new HashMap<String, RefModelType>();

            Worker() {
            }

            public Map<String, RefModelType> getModels() {
                return this._renamedModels;
            }

            public Object doWork() throws Exception {
                Connection connection = null;
                ArrayList<String> arrayList = new ArrayList<String>();
                Map<String, String> map = null;
                try {
                    if (!bl) {
                        connection = Connections.getUniqueConnection(context);
                        arrayList.addAll(WorkflowUtils.getUserWorkflowModelNames(connection));
                        for (RefModelType refModelType : list2) {
                            arrayList.add(refModelType.getName());
                        }
                        map = Model.getAllModelNames(connection);
                    }
                    for (RefModelType refModelType : list) {
                        String string = null;
                        String string2 = refModelType.getName();
                        try {
                            string = workflowModel.getNextNewIdString();
                            refModelType.setModelId(string);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (!bl) {
                            String string3 = WorkflowUtils.getRenamedModelNamesWfid(context, string2, arrayList, map);
                            refModelType.setName(string3);
                            if (!string3.equals(string2) && workflowModel.isRefactoring()) {
                                workflowModel.addRefactoredModelName(string2, string3);
                                arrayList.add(string3);
                            }
                        }
                        this._renamedModels.put(string2, refModelType);
                    }
                }
                catch (Exception exception) {
                    throw exception;
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                return this._renamedModels;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this._canceled = true;
            }

            public boolean isCanceled() {
                return this._canceled;
            }
        }
        Worker worker = new Worker();
        worker.setTitle(BuildEditorLrb.get("CREATE_NODE"));
        worker.setMessage(BuildEditorLrb.get("CREATE_NODE_DESCR"));
        worker.setCancelable(false);
        try {
            worker.start(true);
            if (!worker.isCanceled()) {
                map = worker.getModels();
            }
        }
        catch (ProgressException progressException) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)progressException));
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
        }
        return map;
    }

    public static void refactorPostProcess(WorkflowModel workflowModel, Collection<Object> collection) {
        Map<String, String> map = workflowModel.getRefactoredTableNames();
        Map<String, String> map2 = workflowModel.getRefactoredModelNames();
        for (Object object : collection) {
            Object object2;
            Object object3;
            List list;
            String string;
            UpdateTableNodeType updateTableNodeType;
            AbstractNode abstractNode;
            if (object instanceof UpdateTableNode) {
                abstractNode = (UpdateTableNode)object;
                updateTableNodeType = (UpdateTableNodeType)abstractNode.getData();
                String string2 = updateTableNodeType.getUpdateTargetTable().getName();
                string = map.get(string2);
                if (string == null) continue;
                list = (TableType)MetaDataHelper.copyMetadataObject(updateTableNodeType.getUpdateTargetTable());
                list.setName(string);
                object3 = new HashMap();
                object3.put(list, workflowModel.generateNextDistinctName(string));
                Object object4 = new HashMap();
                object4.put("targetTable", object3);
                object2 = (OdmrSDMUndoFilter)abstractNode.getUndoFilter();
                ((OdmrSDMUndoFilter)((Object)object2)).prepareUndo(abstractNode, abstractNode.getContext(), UpdateTableNode.UPDATE_TABLE_PROPERTIES, object4);
                continue;
            }
            if (!(object instanceof ModelNode)) continue;
            abstractNode = (ModelNode)object;
            updateTableNodeType = (ModelNodeType)MetaDataHelper.copyMetadataObject(abstractNode.getData());
            boolean bl = false;
            string = updateTableNodeType.getModels();
            list = string.getModel();
            for (Object object4 : list) {
                object2 = object4.getName();
                String string3 = map2.get(object2);
                if (string3 == null) continue;
                object4.setName(string3);
                bl = true;
            }
            if (!bl) continue;
            object3 = (OdmrSDMUndoFilter)abstractNode.getUndoFilter();
            ((OdmrSDMUndoFilter)((Object)object3)).prepareUndo(abstractNode, abstractNode.getContext(), "modelsGroup", string);
        }
    }

    public static List<String> getNewModelNames(final Context context, final String string, final List<String> list) {
        List<String> list2 = new ArrayList<String>();
        class Worker
        extends ProgressRunnable {
            private boolean _canceled;
            private List<String> _modelNames = new ArrayList<String>();

            Worker() {
            }

            public List<String> getModelName() {
                return this._modelNames;
            }

            protected Object doWork() throws Exception {
                Connection connection = null;
                try {
                    connection = Connections.getUniqueConnection(context);
                    Collection<String> collection = WorkflowUtils.getUserWorkflowModelNames(connection);
                    Map<String, String> map = Model.getAllModelNames(connection);
                    for (String string3 : list) {
                        String string2 = WorkflowUtils.getNewModelNamesWfid(context, string, string3, collection, map);
                        this._modelNames.add(string2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                return this._modelNames;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this._canceled = true;
            }

            public boolean isCanceled() {
                return this._canceled;
            }
        }
        Worker worker = new Worker();
        worker.setTitle(BuildEditorLrb.get("CREATE_NODE"));
        worker.setMessage(BuildEditorLrb.get("CREATE_NODE_DESCR"));
        worker.setCancelable(false);
        try {
            worker.start(true);
            if (!worker.isCanceled()) {
                list2 = worker.getModelName();
            }
        }
        catch (ProgressException progressException) {
            progressException.printStackTrace();
        }
        return list2;
    }

    public static Collection<String> getUserWorkflowTableNames(Connection connection) throws SQLException {
        OdmrWorkflow odmrWorkflow = new OdmrWorkflow(connection);
        OdmrObjectNames[] odmrObjectNamesArray = new OdmrObjectNames[1];
        odmrWorkflow.wfGetAllTables(odmrObjectNamesArray);
        String[] stringArray = odmrObjectNamesArray[0].getArray();
        return Arrays.asList(stringArray);
    }

    public static Collection<String> getUserWorkflowModelNames(Connection connection) throws Exception {
        OdmrWorkflow odmrWorkflow = new OdmrWorkflow(connection);
        OdmrObjectNames[] odmrObjectNamesArray = new OdmrObjectNames[1];
        odmrWorkflow.wfGetAllModels(odmrObjectNamesArray);
        String[] stringArray = odmrObjectNamesArray[0].getArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(stringArray));
        return arrayList;
    }

    public static boolean validateUserModelName(final Context context, final String string, Component component, final Collection<String> collection, final Collection<String> collection2) {
        class Worker
        extends ProgressRunnable {
            private boolean _canceled;
            protected boolean isValid = true;
            protected String errorText;

            Worker() {
            }

            protected Object doWork() throws Exception {
                Connection connection = null;
                try {
                    if (collection.contains(string)) {
                        this.errorText = BuildEditorLrb.get("MODEL_NAME_IN_USE_WFCUR");
                        this.isValid = false;
                        Boolean bl = this.isValid;
                        return bl;
                    }
                    connection = Connections.getUniqueConnection(context);
                    ArrayList<String> arrayList = new ArrayList<String>(collection2);
                    arrayList.addAll(WorkflowUtils.getUserWorkflowModelNames(connection));
                    if (arrayList.contains(string)) {
                        this.errorText = BuildEditorLrb.get("MODEL_NAME_IN_USE_WFANY");
                        this.isValid = false;
                        Boolean bl = this.isValid;
                        return bl;
                    }
                    Map<String, String> map = Model.getAllModelNames(connection);
                    if (map.containsKey(string)) {
                        this.errorText = BuildEditorLrb.get("MODEL_NAME_IN_USE_PHYS");
                        this.isValid = false;
                        Boolean bl = this.isValid;
                        return bl;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                return this.isValid;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this._canceled = true;
            }

            public boolean isCanceled() {
                return this._canceled;
            }
        }
        Worker worker = new Worker();
        worker.setTitle(BuildEditorLrb.get("VALIDATE_MODEL_NAME"));
        worker.setMessage(BuildEditorLrb.get("VALIDATE_MODEL_NAME_DESCR"));
        worker.setCancelable(true);
        boolean bl = true;
        try {
            worker.start(true);
            if (!worker.isValid) {
                Component component2;
                Component component3 = component2 = component != null ? component : Ide.getMainWindow();
                if (worker.errorText.equals(BuildEditorLrb.get("MODEL_NAME_IN_USE_WFCUR"))) {
                    MessageDialog.error((Component)component2, (Object)worker.errorText, (String)BuildEditorLrb.get("MODEL_NAME_ERROR_TITLE"), null);
                    bl = false;
                } else {
                    bl = MessageDialog.confirm((Component)component2, (Object)worker.errorText, (String)BuildEditorLrb.get("MODEL_NAME_ERROR_TITLE"), null);
                }
            }
        }
        catch (ProgressException progressException) {
            progressException.printStackTrace();
        }
        return bl;
    }

    public static boolean validateNodeName(AbstractNode abstractNode, String string, WorkflowModel workflowModel) {
        boolean bl = true;
        Collection<Object> collection = workflowModel.getObjectsCollection();
        for (Object object : collection) {
            if (!(object instanceof AbstractNode) || !((AbstractNode)object).getData().getName().equals(string) || abstractNode == object) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static final boolean validateDBObjectName(String string) {
        if (string == null) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        if (StringUtils.isDoubleQuotedString(string)) {
            string = StringUtils.trimDoubleQuotes(string);
        }
        return string.length() > 0 && string.length() <= 30 && StringUtils.containsNoDoubleQuotes(string) && !StringUtils.isDBReservedWord(string);
    }

    public static boolean areEqual(Object object, Object object2) {
        if (object instanceof Messages && object2 instanceof Messages) {
            Messages messages = (Messages)object;
            Messages messages2 = (Messages)object2;
            List list = messages.getMessage();
            List list2 = messages2.getMessage();
            if (list == null && list2 == null) {
                return true;
            }
            if (list.size() == 0 && list2.size() == 0) {
                return true;
            }
            if (list.size() == list2.size()) {
                boolean bl = true;
                for (int i = 0; i < list.size(); ++i) {
                    MessageType messageType = (MessageType)list.get(i);
                    MessageType messageType2 = (MessageType)list2.get(i);
                    if (!WorkflowUtils.areEqual(messageType.getDisplayValue(), messageType2.getDisplayValue()) || !WorkflowUtils.areEqual(messageType.getErrorDetail(), messageType2.getErrorDetail()) || !WorkflowUtils.areEqual(messageType.getId(), messageType2.getId())) continue;
                    bl = false;
                    break;
                }
                return bl;
            }
        }
        return false;
    }

    public static boolean areEqual(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        return string != null && string2 != null && string.equals(string2);
    }

    public static String getNewOutputTableNameWfid(Context context) throws Exception {
        String string = null;
        class Worker
        extends ProgressRunnable {
            private boolean _canceled;
            String _tableName;
            final /* synthetic */ Context val$ctx;

            Worker(Context context) {
                this.val$ctx = context;
            }

            public String getTableName() {
                return this._tableName;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doWork() throws Exception {
                WorkflowNode workflowNode = (WorkflowNode)this.val$ctx.getNode();
                BigDecimal bigDecimal = ((Workflow)workflowNode.getRepositoryData()).getId();
                assert (bigDecimal != null);
                int n = 1;
                WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
                List<String> list = workflowModel.getAllOutputTableNames();
                this._tableName = _table_name_prefix + (n += list.size()) + "_" + bigDecimal.intValue();
                Connection connection = null;
                try {
                    connection = Connections.getUniqueConnection(this.val$ctx);
                    String string = Connections.getUserAccountName(this.val$ctx);
                    string = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string.toUpperCase();
                    boolean bl = false;
                    while (!bl) {
                        Collection<String> collection = WorkflowUtils.getAllKnownTableNames(connection, this.val$ctx);
                        while (collection.contains(this._tableName)) {
                            this._tableName = _table_name_prefix + ++n + "_" + bigDecimal.intValue();
                        }
                        if (this._tableName.length() > 30) {
                            throw new Exception("Unable to generate a name under 30 characters.");
                        }
                        if (DatabaseMetadataUtils.datasourceExists(connection, string, this._tableName)) continue;
                        bl = true;
                    }
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                return this._tableName;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this._canceled = true;
            }

            public boolean isCanceled() {
                return this._canceled;
            }
        }
        Worker worker = new Worker(context);
        worker.setTitle(BuildEditorLrb.get("CREATE_NODE"));
        worker.setMessage(BuildEditorLrb.get("CREATE_NODE_DESCR"));
        worker.setCancelable(false);
        try {
            worker.start(true);
            if (!worker.isCanceled()) {
                string = worker.getTableName();
            }
        }
        catch (ProgressException progressException) {
            throw new Exception(progressException.getCause());
        }
        return string;
    }

    public static String getNewOutputTableNameWfidRefactor(String string, Context context) throws Exception {
        String string2 = string;
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        BigDecimal bigDecimal = ((Workflow)workflowNode.getRepositoryData()).getId();
        assert (bigDecimal != null);
        int n = bigDecimal.intValue();
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(context);
            Collection<String> collection = WorkflowUtils.getAllKnownTableNames(connection, context);
            if (!collection.contains(string2)) {
                String string3 = string2;
                return string3;
            }
            WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
            List<String> list = workflowModel.getAllOutputTableNames();
            int n2 = 1;
            for (String string4 : list) {
                int n3 = WorkflowUtils.parseWFId(string4);
                if (n3 != n) continue;
                n2 = Math.max(n2, WorkflowUtils.parseTableIndex(string4));
            }
            Object object = connection.getMetaData().getUserName();
            object = StringUtils.isDoubleQuotedString((String)object) ? StringUtils.trimDoubleQuotes((String)object) : ((String)object).toUpperCase();
            boolean bl = false;
            while (!bl) {
                while (collection.contains(string2) || list.contains(string2)) {
                    string2 = WorkflowUtils.generateName(string2, n2++, n, 30);
                }
                assert (string2.length() <= 30);
                if (DatabaseMetadataUtils.datasourceExists(connection, (String)object, string2)) continue;
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return string2;
    }

    private static String generateName(String string, int n, int n2, int n3) throws Exception {
        int n4;
        String string2 = string;
        int n5 = string2.lastIndexOf("_");
        int n6 = string2.lastIndexOf("_", n5 - 1);
        boolean bl = false;
        if (n6 != -1 && n5 != -1 && n6 != n5 && n5 == (n4 = string2.indexOf("_", n6 + 1))) {
            int n7 = -1;
            int n8 = -1;
            String string3 = string2.substring(n6 + 1, n5);
            try {
                n7 = Integer.decode(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String string4 = string2.substring(n5 + 1);
            try {
                n8 = Integer.decode(string4);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n7 != -1 && n8 != -1) {
                bl = true;
            }
        }
        if (bl) {
            String string5 = string2.substring(0, n6);
            if ((string2 = string5 + "_" + n + "_" + n2).length() > n3) {
                String string6 = string5;
                while (string2.length() > n3) {
                    if ((string6 = string5.substring(0, string6.length() - 1)).length() == 0) {
                        throw new Exception("Unable to generate a name under 30 characters.");
                    }
                    string2 = string6 + "_" + n + "_" + n2;
                }
            }
        } else {
            n4 = WorkflowUtils.getLastNumberIndex(string2);
            if (n4 == -1) {
                string2 = string2 + n;
            } else {
                String string7 = string2.substring(0, n4);
                string2 = string7 + n;
            }
        }
        return string2;
    }

    private static int getLastNumberIndex(String string) {
        int n = string.length() - 1;
        if (n == -1) {
            return -1;
        }
        int n2 = -1;
        boolean bl = true;
        while (bl) {
            String string2 = "" + string.charAt(n);
            try {
                Integer.decode(string2);
                n2 = n--;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return n2;
    }

    private static int parseTableIndex(String string) {
        int n;
        int n2 = -1;
        if (string != null && -1 != string.indexOf(_table_name_prefix) && (n = string.lastIndexOf("_")) != -1) {
            String string2 = string.substring(_table_name_prefix.length(), n);
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2;
    }

    private static int parseWFId(String string) {
        int n;
        int n2 = -1;
        if (string != null && -1 != string.indexOf(_table_name_prefix) && (n = string.lastIndexOf("_")) != -1) {
            String string2 = string.substring(n + 1, string.length());
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2;
    }

    public static boolean doesTableExist(Context context, String string) throws Exception {
        String string2;
        Object object;
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        BigDecimal bigDecimal = ((Workflow)workflowNode.getRepositoryData()).getId();
        assert (bigDecimal != null);
        WorkflowProcess workflowProcess = ((Workflow)workflowNode.getRepositoryData()).getWorkflowProcess();
        WorkflowProcess.Nodes nodes = workflowProcess.getNodes();
        if (nodes != null && (object = nodes.getCreateTable()) != null && !object.isEmpty()) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                string2 = (CreateTableNodeType)iterator.next();
                if (null == string2.getTableName() || !string.equals(string2.getTableName())) continue;
                return true;
            }
        }
        object = null;
        boolean bl = false;
        try {
            Collection<String> collection;
            object = Connections.getUniqueConnection(context);
            string2 = Connections.getUserAccountName(context);
            string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
            bl = DatabaseMetadataUtils.datasourceExists((Connection)object, string2, string);
            if (!bl && (collection = WorkflowUtils.getUserWorkflowTableNames((Connection)object)).contains(string)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    public static Collection<String> getAllInMemoryModelNames(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection<WorkflowEditor> collection = WorkflowUtils.getOpenWorkflowEditors();
        for (WorkflowEditor workflowEditor : collection) {
            URL uRL;
            URL uRL2 = workflowEditor.getContext().getNode().getURL();
            if (!DMURLFormatHelper.isSameConnection(uRL2, uRL = context.getNode().getURL())) continue;
            arrayList.addAll(workflowEditor.getWorkflowNode().getWorkflowModel().getAllMiningModels().keySet());
        }
        return arrayList;
    }

    public static Collection<String> getAllInMemoryTableNames(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection<WorkflowEditor> collection = WorkflowUtils.getOpenWorkflowEditors();
        for (WorkflowEditor workflowEditor : collection) {
            URL uRL;
            URL uRL2 = workflowEditor.getContext().getNode().getURL();
            if (!DMURLFormatHelper.isSameConnection(uRL2, uRL = context.getNode().getURL())) continue;
            arrayList.addAll(workflowEditor.getWorkflowNode().getWorkflowModel().getAllOutputTableNames());
        }
        return arrayList;
    }

    private static Collection<WorkflowEditor> getOpenWorkflowEditors() {
        List list;
        EditorManager editorManager = EditorManager.getEditorManager();
        ArrayList<WorkflowEditor> arrayList = new ArrayList<WorkflowEditor>();
        if (!EventQueue.isDispatchThread()) {
            class GetEditors
            implements Runnable {
                private List openEditors;
                final /* synthetic */ EditorManager val$em;

                GetEditors(EditorManager editorManager) {
                    this.val$em = editorManager;
                }

                public List getOpenEditors() {
                    return this.openEditors;
                }

                @Override
                public void run() {
                    this.openEditors = this.val$em.getAllEditors();
                }
            }
            GetEditors getEditors = new GetEditors(editorManager);
            try {
                SwingUtilities.invokeAndWait(getEditors);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return new ArrayList<WorkflowEditor>();
            }
            list = getEditors.getOpenEditors();
        } else {
            list = editorManager.getAllEditors();
        }
        for (Object e : list) {
            if (!(e instanceof WorkflowEditor)) continue;
            arrayList.add((WorkflowEditor)e);
        }
        return arrayList;
    }

    public static Collection<String> getAllKnownTableNames(Connection connection, Context context) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(DatabaseMetadataUtils.getUserTablesAndViews(connection));
        arrayList.addAll(WorkflowUtils.getAllInMemoryTableNames(context));
        arrayList.addAll(WorkflowUtils.getUserWorkflowTableNames(connection));
        return arrayList;
    }

    public static Collection<String> getInMemoryModelNames(WorkflowModel workflowModel, BuildNodeType buildNodeType) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(workflowModel.getAllMiningModels().keySet());
        if (buildNodeType != null) {
            arrayList.addAll(MetaDataHelper.getModelNames(buildNodeType));
        }
        return arrayList;
    }

    public static Component compositeRequestFocus(Component component) {
        if (component instanceof Container) {
            Component component2;
            Object object;
            Object object2;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (object2 = ((FocusTraversalPolicy)(object = container.getFocusTraversalPolicy())).getDefaultComponent(container)) != null) {
                ((Component)object2).requestFocus();
                return object2;
            }
            object = container.getFocusCycleRootAncestor();
            if (object != null && (component2 = ((FocusTraversalPolicy)(object2 = ((Container)object).getFocusTraversalPolicy())).getComponentAfter((Container)object, container)) != null && SwingUtilities.isDescendingFrom(component2, container)) {
                component2.requestFocus();
                return component2;
            }
        }
        if (component.isFocusable()) {
            component.requestFocus();
            return component;
        }
        return null;
    }

    private static class ModelNameGeneratingInfo {
        String prefix;
        int modelStartingIndex;

        private ModelNameGeneratingInfo() {
        }
    }
}

