/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow;

import ilog.views.IlvGraphic;
import ilog.views.IlvManagerView;
import ilog.views.sdm.IlvSDMEngine;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.DiagramView;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.framework.copypaste.CopyPastePlugin;
import oracle.diagram.framework.palette.PalettePlugin;
import oracle.diagram.framework.palette.modular.ModularPalettePlugin;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.DataNode;
import oracle.dmt.dataminer.navigator.TestResultNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNodeUtils;
import oracle.dmt.dataminer.navigator.net.DMURLFileSystemHelper;
import oracle.dmt.dataminer.navigator.wflownodes.ColumnFilterNavNode;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.RegressTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.runner.RunManager;
import oracle.dmt.dataminer.server.model.MiningModelSettings;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowDiagram;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowPalettePageProvider;
import oracle.dmt.dataminer.workflow.WorkflowPalettePages;
import oracle.dmt.dataminer.workflow.codegen.GenerateCode;
import oracle.dmt.dataminer.workflow.dialog.PasteExtendedDialog;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregationNodeAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyEditorDialog;
import oracle.dmt.dataminer.workflow.dialog.applyText.ApplyTextDialog;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsDialog;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditDialog;
import oracle.dmt.dataminer.workflow.dialog.buildText.BuildTextDialog;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.OutputColumnDialog;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.OutputColumnPanel;
import oracle.dmt.dataminer.workflow.dialog.columnFilterDetails.OutputSettingDialog;
import oracle.dmt.dataminer.workflow.dialog.data.CreateTableNodeAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataProfileAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizard;
import oracle.dmt.dataminer.workflow.dialog.data.UpdateTableNodeAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.join.JoinEditorDialog;
import oracle.dmt.dataminer.workflow.dialog.model.EditModelNodeDialog;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.EditModelDetailsAutoDialog;
import oracle.dmt.dataminer.workflow.dialog.rowFilter.RowFilterEditorDialog;
import oracle.dmt.dataminer.workflow.dialog.sample.SettingsDialog;
import oracle.dmt.dataminer.workflow.dialog.tests.TestModelDialog;
import oracle.dmt.dataminer.workflow.dialog.text.TextDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformSettingsEditorDialog;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractModelNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.AggregationNode;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.dmt.dataminer.workflow.model.ApplyTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNodeRef;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.ColumnFilterNode;
import oracle.dmt.dataminer.workflow.model.CreateTableNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.model.FilterDetailsDataNode;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.JoinNode;
import oracle.dmt.dataminer.workflow.model.ModelDetailsDataNode;
import oracle.dmt.dataminer.workflow.model.ModelNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.model.RowFilterNode;
import oracle.dmt.dataminer.workflow.model.SampleNode;
import oracle.dmt.dataminer.workflow.model.SupervisedBuildNode;
import oracle.dmt.dataminer.workflow.model.TestNode;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.model.UpdateTableNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeRefType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FilterDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.dmt.dataminer.workflow.xmlschema.RowFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.editor.EditorUtil;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.util.SwingWorker;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessageDialogPersistence;

public class WorkflowContextMenu
implements ContextMenuListener,
Controller {
    private static WorkflowContextMenu _instance = null;
    public static int PRIMARY_EDIT_ACTION_ID = Ide.createCmdID((String)"EditNodeAction");
    public static int SECONDARY_EDIT_ACTION_ID = Ide.createCmdID((String)"EditNodeActionSecondary");
    public static int TERTIARY_EDIT_ACTION_ID = Ide.createCmdID((String)"EditNodeActionTertiary");
    public static int GENERATE_APPLY_CHAIN_ID = Ide.createCmdID((String)"GenerateApplyChain");
    public static int SWAP_BUILD_TEST_DATA_ID = Ide.createCmdID((String)"SwapDataAction");
    public static int RUN_ACTION_ID = Ide.createCmdID((String)"RunNodeAction");
    public static int RUN_FORCE_CHILDREN_ACTION_ID = Ide.createCmdID((String)"RunForceChildrenNodeAction");
    public static int RUN_FORCE_SELECTED_ACTION_ID = Ide.createCmdID((String)"RunForceSelectedNodeAction");
    public static int RUN_FORCE_SELECTED_AND_CHILDREN_ACTION_ID = Ide.createCmdID((String)"RunForceSelectedAndChildrenNodeAction");
    public static int RUN_FORCE_PARENTS_ACTION_ID = Ide.createCmdID((String)"RunForceParentsNodeAction");
    public static int VIEW_DATA_ACTION_ID = Ide.createCmdID((String)"ViewDataAction");
    public static int VIEW_ERROR_STATUS_ID = Ide.createCmdID((String)"ViewErrorStatus");
    public static int COMPARE_TEST_ID = Ide.createCmdID((String)"CompareTest");
    public static int COPY_SQL_TO_CLIPBOARD_ACTION_ID = Ide.createCmdID((String)"CopySQLToClipboardAction");
    public static int COPY_SQL_TO_FILE_ACTION_ID = Ide.createCmdID((String)"CopySQLToFileAction");
    public static int COPY_PLSQL_TO_CLIPBOARD_ACTION_ID = Ide.createCmdID((String)"CopyPLSQLToClipboardAction");
    public static int COPY_PLSQL_TO_FILE_ACTION_ID = Ide.createCmdID((String)"CopyPLSQLToFileAction");
    public static int CONNECT_ACTION_ID = Ide.createCmdID((String)"dataminer.ConnectAction");
    public static int GO_TO_PROPERTY_ID = Ide.createCmdID((String)"dataminer.GoToPropertyInspector");
    private static boolean inExtendedPaste = false;
    private static boolean keepModelNamesUnique = false;

    public static WorkflowContextMenu getInstance() {
        if (_instance == null) {
            _instance = new WorkflowContextMenu();
        }
        return _instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        View view = context.getView();
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        if (!(view instanceof WorkflowEditor)) return;
        Object object = ((DiagramView)view).getActiveManagerView();
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)object);
        if (ilvSDMEngine == null) return;
        Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof AbstractNode)) continue;
            arrayList.add((AbstractNode)e);
        }
        object = null;
        ilvSDMEngine = null;
        int n = arrayList.size();
        if (!arrayList.isEmpty()) {
            object = (AbstractNode)arrayList.get(0);
            ilvSDMEngine = ((AbstractNode)object).getData();
        }
        IdeAction ideAction = IdeAction.find((int)CONNECT_ACTION_ID);
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)ideAction, 1.0f);
        jMenuItem.setText(WorkflowEditorLrb.get("CONNECT_NODE"));
        ideAction.addController((Controller)this);
        IdeAction ideAction2 = IdeAction.get((int)VIEW_ERROR_STATUS_ID);
        JMenuItem jMenuItem2 = contextMenu.createMenuItem((ToggleAction)ideAction2, 1.0f);
        if (arrayList.size() == 1) {
            if (ilvSDMEngine.getStatus().equals((Object)NodeStatusType.FAILURE)) {
                jMenuItem2.setText(WorkflowEditorLrb.get("VIEW_ERROR_STATUS"));
            } else if (ilvSDMEngine.getStatus().equals((Object)NodeStatusType.INVALID)) {
                jMenuItem2.setText(WorkflowEditorLrb.get("VIEW_WARNING_STATUS"));
            } else {
                jMenuItem2.setText(WorkflowEditorLrb.get("SHOW_EVENT_LOG"));
            }
        }
        ideAction2.addController((Controller)this);
        IdeAction ideAction3 = IdeAction.get((int)GO_TO_PROPERTY_ID);
        JMenuItem jMenuItem3 = contextMenu.createMenuItem((ToggleAction)ideAction3, 1.0f);
        jMenuItem3.setText(WorkflowEditorLrb.get("GO_TO_PROPERTIES"));
        ideAction3.addController((Controller)this);
        IdeAction ideAction4 = IdeAction.get((int)GENERATE_APPLY_CHAIN_ID);
        JMenuItem jMenuItem4 = contextMenu.createMenuItem((ToggleAction)ideAction4, 1.0f);
        jMenuItem4.setText(WorkflowEditorLrb.get("GENERATE_APPLY_CHAIN"));
        ideAction4.addController((Controller)this);
        if (n > 0) {
            contextMenu.add((Component)jMenuItem4, MenuConstants.increment((float)MenuConstants.SECTION_DYNAMIC_CTXT_MENU), false);
        }
        if (n == 1) {
            contextMenu.add((Component)jMenuItem, MenuConstants.decrement((float)MenuConstants.SECTION_DYNAMIC_CTXT_MENU), true);
            contextMenu.add((Component)jMenuItem2);
            contextMenu.add((Component)jMenuItem3);
        }
        IdeAction ideAction5 = IdeAction.find((int)78);
        ideAction5.setEnabled(true);
        JMenuItem jMenuItem5 = contextMenu.createMenuItem((ToggleAction)ideAction5, MenuConstants.WEIGHT_EDIT_EXTENDED_PASTE);
        ideAction5.addController((Controller)this);
        contextMenu.add((Component)jMenuItem5, MenuConstants.SECTION_EDIT_SELECT_ALL);
        IdeAction ideAction6 = IdeAction.get((int)PRIMARY_EDIT_ACTION_ID);
        JMenuItem jMenuItem6 = contextMenu.createMenuItem((ToggleAction)ideAction6, 1.0f);
        ideAction6.addController((Controller)this);
        IdeAction ideAction7 = IdeAction.get((int)SECONDARY_EDIT_ACTION_ID);
        JMenuItem jMenuItem7 = contextMenu.createMenuItem((ToggleAction)ideAction7, 1.0f);
        ideAction7.addController((Controller)this);
        IdeAction ideAction8 = IdeAction.get((int)TERTIARY_EDIT_ACTION_ID);
        JMenuItem jMenuItem8 = contextMenu.createMenuItem((ToggleAction)ideAction8, 1.0f);
        ideAction8.addController((Controller)this);
        IdeAction ideAction9 = IdeAction.get((int)RUN_ACTION_ID);
        JMenuItem jMenuItem9 = contextMenu.createMenuItem((ToggleAction)ideAction9, 1.0f);
        jMenuItem9.setText(WorkflowEditorLrb.get("RUN"));
        ideAction9.addController((Controller)this);
        JMenu jMenu = contextMenu.createMenu(WorkflowEditorLrb.get("RUN_FORCE_RUN"), 1.0f);
        IdeAction ideAction10 = IdeAction.get((int)RUN_FORCE_SELECTED_AND_CHILDREN_ACTION_ID);
        JMenuItem jMenuItem10 = contextMenu.createMenuItem((ToggleAction)ideAction10, 1.0f);
        jMenuItem10.setText(WorkflowEditorLrb.get("RUN_FORCE_SELECTED_AND_CHILDREN"));
        ideAction10.addController((Controller)this);
        jMenu.add(jMenuItem10);
        IdeAction ideAction11 = IdeAction.get((int)RUN_FORCE_SELECTED_ACTION_ID);
        JMenuItem jMenuItem11 = contextMenu.createMenuItem((ToggleAction)ideAction11, 1.0f);
        jMenuItem11.setText(WorkflowEditorLrb.get("RUN_FORCE_RUN_SELECTED"));
        ideAction11.addController((Controller)this);
        jMenu.add(jMenuItem11);
        IdeAction ideAction12 = IdeAction.get((int)RUN_FORCE_CHILDREN_ACTION_ID);
        JMenuItem jMenuItem12 = contextMenu.createMenuItem((ToggleAction)ideAction12, 1.0f);
        jMenuItem12.setText(WorkflowEditorLrb.get("RUN_FORCE_CHILDREN"));
        ideAction12.addController((Controller)this);
        jMenu.add(jMenuItem12);
        IdeAction ideAction13 = IdeAction.get((int)RUN_FORCE_PARENTS_ACTION_ID);
        JMenuItem jMenuItem13 = contextMenu.createMenuItem((ToggleAction)ideAction13, 1.0f);
        jMenuItem13.setText(WorkflowEditorLrb.get("RUN_FORCE_PARENTS"));
        ideAction13.addController((Controller)this);
        jMenu.add(jMenuItem13);
        IdeAction ideAction14 = IdeAction.get((int)VIEW_DATA_ACTION_ID);
        JMenuItem jMenuItem14 = contextMenu.createMenuItem((ToggleAction)ideAction14, 1.0f);
        jMenuItem14.setText(WorkflowEditorLrb.get("VIEW_DATA"));
        ideAction14.addController((Controller)this);
        JMenu jMenu2 = contextMenu.createMenu(WorkflowEditorLrb.get("GENERATE_CODE"), null);
        IdeAction ideAction15 = IdeAction.get((int)COPY_SQL_TO_CLIPBOARD_ACTION_ID);
        JMenuItem jMenuItem15 = contextMenu.createMenuItem((ToggleAction)ideAction15, 1.0f);
        jMenuItem15.setText(WorkflowEditorLrb.get("GENERATE_SQL_TO_CLIPBOARD"));
        ideAction15.addController((Controller)this);
        jMenu2.add(jMenuItem15);
        IdeAction ideAction16 = IdeAction.get((int)COPY_SQL_TO_FILE_ACTION_ID);
        JMenuItem jMenuItem16 = contextMenu.createMenuItem((ToggleAction)ideAction16, 1.0f);
        jMenuItem16.setText(WorkflowEditorLrb.get("GENERATE_SQL_TO_FILE"));
        ideAction16.addController((Controller)this);
        jMenu2.add(jMenuItem16);
        IdeAction ideAction17 = IdeAction.get((int)COPY_PLSQL_TO_CLIPBOARD_ACTION_ID);
        JMenuItem jMenuItem17 = contextMenu.createMenuItem((ToggleAction)ideAction17, 1.0f);
        jMenuItem17.setText(WorkflowEditorLrb.get("GENERATE_SQL_SCRIPT_TO_CLIPBOARD"));
        ideAction17.addController((Controller)this);
        jMenu2.add(jMenuItem17);
        IdeAction ideAction18 = IdeAction.get((int)COPY_PLSQL_TO_FILE_ACTION_ID);
        JMenuItem jMenuItem18 = contextMenu.createMenuItem((ToggleAction)ideAction18, 1.0f);
        jMenuItem18.setText(WorkflowEditorLrb.get("GENERATE_SQL_SCRIPT_TO_FILE"));
        ideAction18.addController((Controller)this);
        jMenu2.add(jMenuItem18);
        IdeAction ideAction19 = IdeAction.get((int)SWAP_BUILD_TEST_DATA_ID);
        JMenuItem jMenuItem19 = contextMenu.createMenuItem((ToggleAction)ideAction19, 1.0f);
        jMenuItem19.setText(WorkflowEditorLrb.get("SWAP"));
        ideAction19.addController((Controller)this);
        if (n == 1) {
            if (this.isRequirePrimaryEditMenu((NodeType)ilvSDMEngine)) {
                jMenuItem6.setText(this.getPrimaryEditMenuText((NodeType)ilvSDMEngine));
                contextMenu.add((Component)jMenuItem6, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
            }
            if (this.isRequireSecondaryEditMenu((NodeType)ilvSDMEngine)) {
                jMenuItem7.setText(this.getSecondaryEditMenuText((NodeType)ilvSDMEngine));
                contextMenu.add((Component)jMenuItem7, MenuConstants.SECTION_DYNAMIC_CTXT_MENU);
            }
            if (this.isRequireTertiaryEditMenu((NodeType)ilvSDMEngine)) {
                jMenuItem8.setText(this.getTertiaryEditMenuText((NodeType)ilvSDMEngine));
                contextMenu.add((Component)jMenuItem8, MenuConstants.SECTION_DYNAMIC_CTXT_MENU);
            }
            contextMenu.add((Component)jMenuItem9, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
            if (((AbstractNode)object).hasParentNodes() || ((AbstractNode)object).hasChildrenNodes()) {
                contextMenu.add((Component)jMenu, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
                if (!((AbstractNode)object).hasChildrenNodes()) {
                    jMenu.remove(jMenuItem10);
                    jMenu.remove(jMenuItem12);
                }
                if (!((AbstractNode)object).hasParentNodes()) {
                    jMenu.remove(jMenuItem13);
                }
            }
            if (object instanceof DataSourceNode) {
                contextMenu.add((Component)jMenuItem14, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
            } else if (object instanceof DataProfileNode) {
                contextMenu.add((Component)jMenuItem14, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
            } else if (object instanceof CreateTableNode) {
                contextMenu.add((Component)jMenuItem14, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
            } else if (object instanceof UpdateTableNode) {
                contextMenu.add((Component)jMenuItem14, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
            } else if (object instanceof AbstractTransformNode && !(object instanceof BuildTextNodeRef)) {
                contextMenu.add((Component)jMenuItem14, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
            }
            if (ilvSDMEngine instanceof SuperviseBuildNodeType) {
                this.loadBuildNodeMenu(contextMenu, view, (Node)object, workflowNode);
            } else if (ilvSDMEngine instanceof ClusteringBuildNodeType || ilvSDMEngine instanceof AssociationBuildNodeType || ilvSDMEngine instanceof AnomalyDetectionBuildNodeType || ilvSDMEngine instanceof FeatureExtractionBuildNodeType) {
                this.loadUnsupervisedBuildNodeMenu(contextMenu, view, (Node)object, workflowNode);
            } else if (ilvSDMEngine instanceof ModelNodeType) {
                this.loadModelNodeMenu(contextMenu, view, (Node)object, workflowNode);
            } else if (ilvSDMEngine instanceof TestNodeType) {
                this.loadTestNodeMenu(contextMenu, view, (Node)object, workflowNode);
            }
        }
        if (n == 1 && object instanceof SupervisedBuildNode && this.isSwappableDataSources((AbstractNode)object)) {
            contextMenu.add((Component)jMenuItem19, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
        }
        if (n != 1 || !ilvSDMEngine.getStatus().equals((Object)NodeStatusType.COMPLETE) && !ilvSDMEngine.getStatus().equals((Object)NodeStatusType.READY) && !ilvSDMEngine.getStatus().equals((Object)NodeStatusType.WARNING) || !(object instanceof AbstractDataNode) || object instanceof BuildTextNodeRef) return;
        contextMenu.add((Component)jMenu2, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
    }

    private boolean isRequirePrimaryEditMenu(NodeType nodeType) {
        if (nodeType instanceof BuildNodeType) {
            return true;
        }
        if (nodeType instanceof DataSourceNodeType) {
            return true;
        }
        if (nodeType instanceof DataProfileNodeType) {
            return true;
        }
        if (nodeType instanceof CreateTableNodeType) {
            return true;
        }
        if (nodeType instanceof UpdateTableNodeType) {
            return true;
        }
        if (nodeType instanceof ModelDetailsDataNodeType) {
            return true;
        }
        if (nodeType instanceof ModelNodeType) {
            return true;
        }
        if (nodeType instanceof ApplyNodeType) {
            return true;
        }
        if (nodeType instanceof JoinNodeType) {
            return true;
        }
        if (nodeType instanceof TestNodeType) {
            return true;
        }
        if (nodeType instanceof ColumnFilterNodeType) {
            return true;
        }
        if (nodeType instanceof AggregationNodeType) {
            return true;
        }
        if (nodeType instanceof FilterDetailsDataNodeType) {
            return true;
        }
        if (nodeType instanceof SampleNodeType) {
            return true;
        }
        if (nodeType instanceof TransformationNodeType) {
            return true;
        }
        if (nodeType instanceof RowFilterNodeType) {
            return true;
        }
        if (nodeType instanceof BuildTextNodeType) {
            return true;
        }
        if (nodeType instanceof ApplyTextNodeType) {
            return true;
        }
        return nodeType instanceof BuildTextNodeRefType;
    }

    private boolean isRequireSecondaryEditMenu(NodeType nodeType) {
        if (nodeType instanceof BuildNodeType) {
            return true;
        }
        if (nodeType instanceof DataSourceNodeType) {
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)nodeType;
            boolean bl = false;
            if (dataSourceNodeType.getSourceTable() != null && dataSourceNodeType.getSourceTable().getName() != null && dataSourceNodeType.getSourceTable().getName().length() != 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    private boolean isRequireTertiaryEditMenu(NodeType nodeType) {
        if (nodeType instanceof DataSourceNodeType) {
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)nodeType;
            boolean bl = false;
            if (dataSourceNodeType.getSourceTable() != null && dataSourceNodeType.getSourceTable().getName() != null && dataSourceNodeType.getSourceTable().getName().length() != 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    private String getPrimaryEditMenuText(NodeType nodeType) {
        if (nodeType instanceof NodeType) {
            return WorkflowEditorLrb.get("EDIT_NODE");
        }
        if (nodeType != null) {
            new Exception("Node type: " + nodeType.getClass().getName() + " not handled in WorflowContextMenu.getPrimaryEditMenuText ()").printStackTrace();
        }
        return null;
    }

    private String getSecondaryEditMenuText(NodeType nodeType) {
        if (nodeType instanceof BuildNodeType) {
            return WorkflowEditorLrb.get("BUILD_NODE_SECONDARY");
        }
        if (nodeType instanceof DataSourceNodeType) {
            return WorkflowEditorLrb.get("DATA_SOURCE_NODE_SECONDARY");
        }
        if (nodeType != null) {
            new Exception("Node type: " + nodeType.getClass().getName() + " not handled in WorflowContextMenu.getSecondaryEditMenuText ()").printStackTrace();
        }
        return null;
    }

    private String getTertiaryEditMenuText(NodeType nodeType) {
        if (nodeType instanceof DataSourceNodeType) {
            return WorkflowEditorLrb.get("DATA_SOURCE_NODE_TERTIARY");
        }
        return null;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    private boolean isSwappableDataSources(AbstractNode abstractNode) {
        SuperviseBuildNodeType superviseBuildNodeType;
        boolean bl = false;
        if (abstractNode instanceof SupervisedBuildNode && (superviseBuildNodeType = (SuperviseBuildNodeType)abstractNode.getData()).getBuildDataSource() != null && superviseBuildNodeType.getTestDataSource().getTestData() != null) {
            bl = true;
        }
        return bl;
    }

    private void loadModelNodeMenu(ContextMenu contextMenu, View view, Node node, WorkflowNode workflowNode) {
        ModelNode modelNode = (ModelNode)node;
        List<ModelNodeType.Models.Model> list = MetaDataHelper.getModelsCollection((ModelNodeType)modelNode.getData());
        boolean bl = list.size() > 0;
        JMenu jMenu = contextMenu.createMenu(WorkflowEditorLrb.get("VIEW_MODELS"), null);
        this.loadViewModelsMenuForModelNode(view, jMenu, list);
        contextMenu.add((Component)jMenu, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
        jMenu.setEnabled(bl);
    }

    private void loadViewModelsMenuForModelNode(final View view, JMenu jMenu, List<ModelNodeType.Models.Model> list) {
        String string = null;
        try {
            Context context = view.getContext();
            Iterator<ModelNodeType.Models.Model> iterator = (WorkflowNode)context.getNode();
            string = ((WorkflowNode)((Object)iterator)).getConnectionFolder().getUserAccountName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        boolean bl = false;
        for (ModelNodeType.Models.Model model : list) {
            if (model.getSchema().compareTo(string) == 0) continue;
            bl = true;
            break;
        }
        jMenu.removeAll();
        for (ModelNodeType.Models.Model model : list) {
            String string2 = bl ? model.getSchema() + "." + model.getName() : model.getName();
            JMenuItem jMenuItem = new JMenuItem(string2);
            jMenuItem.getModel().setActionCommand(model.getModelId());
            if (model.getStatus().equals((Object)RefModelStatusType.VALID)) {
                jMenuItem.setEnabled(true);
            } else {
                jMenuItem.setEnabled(false);
            }
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    block7: {
                        try {
                            Object object;
                            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                            String string = actionEvent.getActionCommand();
                            AbstractNode abstractNode = WorkflowContextMenu.this.getSelectedDiagramNode(view);
                            if (abstractNode == null) {
                                return;
                            }
                            Context context = view.getContext();
                            WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                            ModelNodeType.Models.Model model = null;
                            if (abstractNode.getData() instanceof ModelNodeType) {
                                object = (ModelNode)abstractNode;
                                model = MetaDataHelper.getModelUsingId((ModelNode)object, string);
                            }
                            if (model == null) {
                                MessageDialog.error((Component)jMenuItem, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_MODEL_NOT_IN_WORKFLOW"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                                return;
                            }
                            object = model.getSchema();
                            if (model.getMiningAlgorithm().equals((Object)MiningAlgorithmType.SUPPORT_VECTOR_MACHINES)) {
                                LoadSVMModelViewer loadSVMModelViewer = new LoadSVMModelViewer(view, model, (String)object, context);
                                loadSVMModelViewer.start();
                                break block7;
                            }
                            BaseTreeNode baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, abstractNode.getData().getName(), model.getSchema(), model.getName());
                            if (baseTreeNode != null) {
                                EditorUtil.openDefaultEditorInFrame((oracle.ide.model.Node)baseTreeNode);
                                break block7;
                            }
                            MessageDialog.error((Component)jMenuItem, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_GENERATE_NODE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                            return;
                        }
                        catch (Exception exception) {
                            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_DISPLAY"), null);
                        }
                    }
                }
            });
            jMenu.add(jMenuItem);
        }
    }

    private void loadBuildNodeMenu(ContextMenu contextMenu, View view, Node node, WorkflowNode workflowNode) {
        AbstractBuildNode abstractBuildNode = (AbstractBuildNode)node;
        List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        boolean bl = list.size() > 0;
        List<ClassificationResultType> list2 = null;
        if (node instanceof ClassificationBuildNode) {
            list2 = MetaDataHelper.getClassResultsCollection(abstractBuildNode);
        } else if (node instanceof RegressionBuildNode) {
            list2 = MetaDataHelper.getRegressResultsCollection(abstractBuildNode);
        }
        JMenu jMenu = contextMenu.createMenu(WorkflowEditorLrb.get("VIEW_MODELS"), null);
        this.loadViewModelsMenu(view, jMenu, list);
        contextMenu.add((Component)jMenu, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
        jMenu.setEnabled(bl);
        JMenu jMenu2 = contextMenu.createMenu(WorkflowEditorLrb.get("VIEW_RESULTS"), null);
        this.loadViewResultsMenu(view, jMenu2, list, list2);
        contextMenu.add((Component)jMenu2, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
        jMenu2.setEnabled(bl);
        JMenuItem jMenuItem = new JMenuItem(WorkflowEditorLrb.get("VIEW_COMPARE"));
        this.loadViewClassCompareMenu(view, jMenuItem, list2);
        contextMenu.add((Component)jMenuItem, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
    }

    private void loadUnsupervisedBuildNodeMenu(ContextMenu contextMenu, View view, Node node, WorkflowNode workflowNode) {
        AbstractBuildNode abstractBuildNode = (AbstractBuildNode)node;
        List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        boolean bl = list.size() > 0;
        JMenu jMenu = contextMenu.createMenu(WorkflowEditorLrb.get("VIEW_MODELS"), null);
        this.loadViewModelsMenu(view, jMenu, list);
        contextMenu.add((Component)jMenu, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
        jMenu.setEnabled(bl);
    }

    private void loadViewModelsMenu(final View view, JMenu jMenu, List<ModelType> list) {
        jMenu.removeAll();
        for (ModelType modelType : list) {
            JMenuItem jMenuItem = new JMenuItem(modelType.getName());
            if (modelType.getCreationDate() != null) {
                jMenuItem.setEnabled(true);
            } else {
                jMenuItem.setEnabled(false);
            }
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    block7: {
                        try {
                            Object object;
                            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                            String string = jMenuItem.getText();
                            AbstractNode abstractNode = WorkflowContextMenu.this.getSelectedDiagramNode(view);
                            if (abstractNode == null) {
                                return;
                            }
                            Context context = view.getContext();
                            WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                            ModelType modelType = null;
                            if (abstractNode.getData() instanceof BuildNodeType) {
                                object = (AbstractBuildNode)abstractNode;
                                modelType = MetaDataHelper.getModelType((AbstractBuildNode)object, string);
                            }
                            if (modelType == null) {
                                MessageDialog.error((Component)jMenuItem, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_MODEL_NOT_IN_WORKFLOW"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                                return;
                            }
                            object = workflowNode.getConnectionFolder().getUserAccountName();
                            if (modelType instanceof CSupportVectorMachineModelType || modelType instanceof RSupportVectorMachineModelType) {
                                LoadSVMModelViewer loadSVMModelViewer = new LoadSVMModelViewer(view, modelType, (String)object, context);
                                loadSVMModelViewer.start();
                                break block7;
                            }
                            BaseTreeNode baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, abstractNode.getData().getName(), null, string);
                            if (baseTreeNode != null) {
                                EditorUtil.openDefaultEditorInFrame((oracle.ide.model.Node)baseTreeNode);
                                break block7;
                            }
                            MessageDialog.error((Component)jMenuItem, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_GENERATE_NODE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                            return;
                        }
                        catch (Exception exception) {
                            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_DISPLAY"), null);
                        }
                    }
                }
            });
            jMenu.add(jMenuItem);
        }
    }

    private void loadViewResultsMenu(final View view, JMenu jMenu, List<ModelType> list, List<? extends MiningResultType> list2) {
        jMenu.removeAll();
        HashMap<String, MiningResultType> hashMap = new HashMap<String, MiningResultType>();
        for (MiningResultType miningResultType : list2) {
            hashMap.put(miningResultType.getName(), miningResultType);
        }
        jMenu.setEnabled(hashMap.size() != 0);
        for (ModelType modelType : list) {
            JMenuItem jMenuItem = new JMenuItem(modelType.getName());
            MiningResultType miningResultType = (MiningResultType)hashMap.get(modelType.getName());
            if (miningResultType != null && modelType.getCreationDate() != null) {
                jMenuItem.setEnabled(true);
            } else {
                jMenuItem.setEnabled(false);
            }
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                        String string = jMenuItem.getText();
                        AbstractNode abstractNode = WorkflowContextMenu.this.getSelectedDiagramNode(view);
                        if (abstractNode == null) {
                            return;
                        }
                        AbstractBuildNode abstractBuildNode = (AbstractBuildNode)abstractNode;
                        TestResultNode testResultNode = null;
                        if (abstractBuildNode instanceof ClassificationBuildNode) {
                            List<ClassificationResultType> list = MetaDataHelper.getClassResultsCollection(abstractBuildNode);
                            Context context = view.getContext();
                            WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                            String string2 = workflowNode.getConnectionFolder().getUserAccountName();
                            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)abstractBuildNode.getData();
                            ClassificationResultType classificationResultType = null;
                            for (ClassificationResultType classificationResultType2 : list) {
                                if (!classificationResultType2.getName().equals(string)) continue;
                                classificationResultType = classificationResultType2;
                                break;
                            }
                            testResultNode = WorkflowContextMenu.createClassTestResultNode(context, workflowNode, string2, string, classificationBuildNodeType, classificationResultType);
                        } else if (abstractBuildNode instanceof RegressionBuildNode) {
                            List<RegressionResultType> list = MetaDataHelper.getRegressResultsCollection(abstractBuildNode);
                            Context context = view.getContext();
                            WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                            String string3 = workflowNode.getConnectionFolder().getUserAccountName();
                            RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)abstractBuildNode.getData();
                            RegressionResultType regressionResultType = null;
                            for (RegressionResultType regressionResultType2 : list) {
                                if (!regressionResultType2.getName().equals(string)) continue;
                                regressionResultType = regressionResultType2;
                                break;
                            }
                            testResultNode = WorkflowContextMenu.createRegressTestResultNode(context, workflowNode, string3, string, regressionBuildNodeType, regressionResultType);
                        }
                        if (testResultNode == null) {
                            MessageDialog.error((Component)jMenuItem, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_GENERATE_NODE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                            return;
                        }
                        EditorUtil.openDefaultEditorInFrame(testResultNode);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
    }

    private void loadViewClassCompareMenu(final View view, JMenuItem jMenuItem, List<? extends MiningResultType> list) {
        ArrayList<MiningResultType> arrayList = new ArrayList<MiningResultType>();
        for (MiningResultType miningResultType : list) {
            if (miningResultType.getCreationDate() == null) continue;
            arrayList.add(miningResultType);
        }
        jMenuItem.setEnabled(arrayList.size() > 1);
        if (arrayList.size() > 1) {
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                        AbstractNode abstractNode = WorkflowContextMenu.this.getSelectedDiagramNode(view);
                        if (abstractNode == null) {
                            return;
                        }
                        AbstractBuildNode abstractBuildNode = (AbstractBuildNode)abstractNode;
                        TestCompareNode testCompareNode = null;
                        if (abstractBuildNode instanceof ClassificationBuildNode) {
                            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)abstractBuildNode.getData();
                            Context context = view.getContext();
                            WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                            ArrayList<ClassificationResultType> arrayList = null;
                            if (classificationBuildNodeType.getResults() != null) {
                                arrayList = new ArrayList<ClassificationResultType>();
                                for (ClassificationResultType classificationResultType : classificationBuildNodeType.getResults().getClassificationResult()) {
                                    if (classificationResultType.getCreationDate() == null) continue;
                                    arrayList.add(classificationResultType);
                                }
                            }
                            testCompareNode = WorkflowContextMenu.createClassTestCompareNode(context, workflowNode, classificationBuildNodeType, arrayList);
                        } else if (abstractBuildNode instanceof RegressionBuildNode) {
                            RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)abstractBuildNode.getData();
                            Context context = view.getContext();
                            WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                            String string = workflowNode.getConnectionFolder().getUserAccountName();
                            ArrayList<RegressionResultType> arrayList = null;
                            if (regressionBuildNodeType.getResults() != null) {
                                arrayList = new ArrayList<RegressionResultType>();
                                for (RegressionResultType regressionResultType : regressionBuildNodeType.getResults().getRegressionResult()) {
                                    if (regressionResultType.getCreationDate() == null) continue;
                                    arrayList.add(regressionResultType);
                                }
                            }
                            testCompareNode = WorkflowContextMenu.createRegressTestCompareNode(context, workflowNode, string, regressionBuildNodeType, arrayList);
                        }
                        if (testCompareNode == null) {
                            MessageDialog.error((Component)jMenuItem, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_GENERATE_NODE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                            return;
                        }
                        EditorUtil.openDefaultEditorInFrame(testCompareNode);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
    }

    private void loadTestNodeMenu(ContextMenu contextMenu, View view, Node node, WorkflowNode workflowNode) {
        TestNode testNode = (TestNode)node;
        List<TestModelType.Model> list = MetaDataHelper.getModelsCollection((TestNodeType)testNode.getData());
        boolean bl = list.size() > 0;
        List<? extends MiningResultType> list2 = null;
        list2 = MetaDataHelper.getResultsCollection(testNode);
        JMenu jMenu = contextMenu.createMenu(WorkflowEditorLrb.get("VIEW_MODELS"), null);
        this.loadViewTestModelsMenu(view, jMenu, list);
        contextMenu.add((Component)jMenu, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
        jMenu.setEnabled(bl);
        JMenu jMenu2 = contextMenu.createMenu(WorkflowEditorLrb.get("VIEW_RESULTS"), null);
        this.loadViewTestResultsMenu(view, jMenu2, list, list2);
        contextMenu.add((Component)jMenu2, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
        jMenu2.setEnabled(bl);
        JMenuItem jMenuItem = new JMenuItem(WorkflowEditorLrb.get("VIEW_COMPARE"));
        this.loadViewTestCompareMenu(view, jMenuItem, list2);
        contextMenu.add((Component)jMenuItem, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
    }

    private void loadViewTestModelsMenu(final View view, JMenu jMenu, List<TestModelType.Model> list) {
        String string = null;
        try {
            Context context = view.getContext();
            Iterator<TestModelType.Model> iterator = (WorkflowNode)context.getNode();
            string = ((WorkflowNode)((Object)iterator)).getConnectionFolder().getUserAccountName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        boolean bl = false;
        for (TestModelType.Model model : list) {
            if (model.getSchema().compareTo(string) == 0) continue;
            bl = true;
            break;
        }
        jMenu.removeAll();
        for (TestModelType.Model model : list) {
            String string2 = bl ? model.getSchema() + "." + model.getName() : model.getName();
            JMenuItem jMenuItem = new JMenuItem(string2);
            jMenuItem.getModel().setActionCommand(model.getModelId());
            jMenuItem.setEnabled(true);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    block7: {
                        try {
                            Object object;
                            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                            String string = actionEvent.getActionCommand();
                            AbstractNode abstractNode = WorkflowContextMenu.this.getSelectedDiagramNode(view);
                            if (abstractNode == null) {
                                return;
                            }
                            Context context = view.getContext();
                            WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                            TestModelType.Model model = null;
                            if (abstractNode.getData() instanceof TestNodeType) {
                                object = (TestNode)abstractNode;
                                model = MetaDataHelper.getModelUsingId((TestNode)object, string);
                            }
                            if (model == null) {
                                MessageDialog.error((Component)jMenuItem, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_MODEL_NOT_IN_WORKFLOW"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                                return;
                            }
                            object = model.getSchema();
                            if (model.getMiningAlgorithm().equals((Object)MiningAlgorithmType.SUPPORT_VECTOR_MACHINES)) {
                                LoadSVMModelViewer loadSVMModelViewer = new LoadSVMModelViewer(view, model, (String)object, context);
                                loadSVMModelViewer.start();
                                break block7;
                            }
                            BaseTreeNode baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, abstractNode.getData().getName(), model.getSchema(), model.getName());
                            if (baseTreeNode != null) {
                                EditorUtil.openDefaultEditorInFrame((oracle.ide.model.Node)baseTreeNode);
                                break block7;
                            }
                            MessageDialog.error((Component)jMenuItem, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_GENERATE_NODE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                            return;
                        }
                        catch (Exception exception) {
                            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_DISPLAY"), null);
                        }
                    }
                }
            });
            jMenu.add(jMenuItem);
        }
    }

    private void loadViewTestResultsMenu(final View view, JMenu jMenu, List<TestModelType.Model> list, List<? extends MiningResultType> list2) {
        HashMap<String, MiningResultType> hashMap;
        String string = null;
        try {
            Context context = view.getContext();
            hashMap = (WorkflowNode)context.getNode();
            string = ((WorkflowNode)((Object)hashMap)).getConnectionFolder().getUserAccountName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        boolean bl = false;
        for (TestModelType.Model object : list) {
            if (object.getSchema().compareTo(string) == 0) continue;
            bl = true;
            break;
        }
        jMenu.removeAll();
        hashMap = new HashMap<String, MiningResultType>();
        for (MiningResultType miningResultType : list2) {
            hashMap.put(miningResultType.getModelId(), miningResultType);
        }
        jMenu.setEnabled(hashMap.size() != 0);
        for (TestModelType.Model model : list) {
            String string2 = bl ? model.getSchema() + "." + model.getName() : model.getName();
            JMenuItem jMenuItem = new JMenuItem(string2);
            jMenuItem.getModel().setActionCommand(model.getModelId());
            MiningResultType miningResultType = (MiningResultType)hashMap.get(model.getModelId());
            if (miningResultType != null) {
                jMenuItem.setEnabled(true);
            } else {
                jMenuItem.setEnabled(false);
            }
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                        String string = jMenuItem.getText();
                        AbstractNode abstractNode = WorkflowContextMenu.this.getSelectedDiagramNode(view);
                        if (abstractNode == null) {
                            return;
                        }
                        String string2 = actionEvent.getActionCommand();
                        TestNode testNode = (TestNode)abstractNode;
                        TestResultNode testResultNode = null;
                        TestNodeType testNodeType = (TestNodeType)testNode.getData();
                        if (testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.CLASSIFICATION)) {
                            List<ClassificationResultType> list = MetaDataHelper.getClassResultsCollection(testNode);
                            Context context = view.getContext();
                            WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                            String string3 = workflowNode.getConnectionFolder().getUserAccountName();
                            ClassificationResultType classificationResultType = null;
                            block2: for (ClassificationResultType classificationResultType2 : list) {
                                if (!classificationResultType2.getModelId().equals(string2)) continue;
                                classificationResultType = classificationResultType2;
                                for (TestModelType.Model model : testNodeType.getTestModels().getModel()) {
                                    if (!model.getModelId().equals(string2)) continue;
                                    string3 = model.getSchema();
                                    break block2;
                                }
                            }
                            testResultNode = WorkflowContextMenu.createClassTestResultNode(context, workflowNode, string3, string, testNodeType, classificationResultType);
                        } else if (testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.REGRESSION)) {
                            List<RegressionResultType> list = MetaDataHelper.getRegressResultsCollection(testNode);
                            Context context = view.getContext();
                            WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                            String string4 = workflowNode.getConnectionFolder().getUserAccountName();
                            RegressionResultType regressionResultType = null;
                            block4: for (RegressionResultType regressionResultType2 : list) {
                                if (!regressionResultType2.getName().equals(string)) continue;
                                regressionResultType = regressionResultType2;
                                for (TestModelType.Model model : testNodeType.getTestModels().getModel()) {
                                    if (!model.getModelId().equals(string2)) continue;
                                    string4 = model.getSchema();
                                    break block4;
                                }
                            }
                            testResultNode = WorkflowContextMenu.createRegressTestResultNode(context, workflowNode, string4, string, testNodeType, regressionResultType);
                        }
                        if (testResultNode == null) {
                            MessageDialog.error((Component)jMenuItem, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_GENERATE_NODE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                            return;
                        }
                        EditorUtil.openDefaultEditorInFrame(testResultNode);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
    }

    private void loadViewTestCompareMenu(final View view, JMenuItem jMenuItem, List<? extends MiningResultType> list) {
        ArrayList<MiningResultType> arrayList = new ArrayList<MiningResultType>();
        for (MiningResultType miningResultType : list) {
            if (miningResultType.getCreationDate() == null) continue;
            arrayList.add(miningResultType);
        }
        jMenuItem.setEnabled(arrayList.size() > 1);
        if (arrayList.size() > 1) {
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ArrayList<ClassificationResultType> arrayList;
                        String string;
                        WorkflowNode workflowNode;
                        Context context;
                        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                        AbstractNode abstractNode = WorkflowContextMenu.this.getSelectedDiagramNode(view);
                        if (abstractNode == null) {
                            return;
                        }
                        TestNode testNode = (TestNode)abstractNode;
                        TestCompareNode testCompareNode = null;
                        TestNodeType testNodeType = (TestNodeType)testNode.getData();
                        if (testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.CLASSIFICATION)) {
                            context = view.getContext();
                            workflowNode = (WorkflowNode)context.getNode();
                            string = workflowNode.getConnectionFolder().getUserAccountName();
                            arrayList = null;
                            if (testNodeType.getResults().getClassificationResult().size() > 0) {
                                arrayList = new ArrayList<ClassificationResultType>();
                                for (ClassificationResultType classificationResultType : testNodeType.getResults().getClassificationResult()) {
                                    if (classificationResultType.getCreationDate() == null) continue;
                                    arrayList.add(classificationResultType);
                                }
                            }
                            testCompareNode = WorkflowContextMenu.createClassTestCompareNode(context, workflowNode, string, testNodeType, arrayList);
                        }
                        if (testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.REGRESSION)) {
                            context = view.getContext();
                            workflowNode = (WorkflowNode)context.getNode();
                            string = workflowNode.getConnectionFolder().getUserAccountName();
                            arrayList = null;
                            if (testNodeType.getResults().getRegressionResult().size() > 0) {
                                arrayList = new ArrayList();
                                for (ClassificationResultType classificationResultType : testNodeType.getResults().getRegressionResult()) {
                                    if (classificationResultType.getCreationDate() == null) continue;
                                    arrayList.add(classificationResultType);
                                }
                            }
                            testCompareNode = WorkflowContextMenu.createRegressTestCompareNode(context, workflowNode, string, testNodeType, arrayList);
                        }
                        if (testCompareNode == null) {
                            MessageDialog.error((Component)jMenuItem, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_GENERATE_NODE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                            return;
                        }
                        EditorUtil.openDefaultEditorInFrame(testCompareNode);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
    }

    private AbstractNode getSelectedDiagramNode(View view) {
        Enumeration enumeration;
        Object e;
        IlvManagerView ilvManagerView;
        IlvSDMEngine ilvSDMEngine;
        AbstractNode abstractNode = null;
        if (view instanceof WorkflowEditor && (ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)(ilvManagerView = ((DiagramView)view).getActiveManagerView()))) != null && (e = (enumeration = ilvSDMEngine.getSelectedObjects()).nextElement()) instanceof AbstractNode) {
            abstractNode = (AbstractNode)e;
        }
        return abstractNode;
    }

    public static TestResultNode createClassTestResultNode(Context context, WorkflowNode workflowNode, String string, String string2, ClassificationBuildNodeType classificationBuildNodeType, ClassificationResultType classificationResultType) throws Exception {
        TestResultNode testResultNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Result" + "/" + string2));
        testResultNode = (TestResultNode)NodeFactory.findOrCreate(TestResultNode.class, (URL)uRL);
        if (testResultNode != null) {
            testResultNode.setRepositoryData(new ClassTestResult(context, (BuildNodeType)classificationBuildNodeType, (MiningResultType)classificationResultType));
            testResultNode.setURL(uRL);
            testResultNode.setResultName(string2);
            testResultNode.setUserName(string);
            testResultNode.setContext(context);
            testResultNode.setConnectionFolder(connectionFolder);
            testResultNode.setClassificationTest(true);
        }
        return testResultNode;
    }

    public static TestCompareNode createClassTestCompareNode(Context context, WorkflowNode workflowNode, ClassificationBuildNodeType classificationBuildNodeType, List<? extends MiningResultType> list) throws Exception {
        TestCompareNode testCompareNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Compare" + "/" + classificationBuildNodeType.getName()));
        testCompareNode = (TestCompareNode)NodeFactory.findOrCreate(TestCompareNode.class, (URL)uRL);
        if (testCompareNode != null) {
            ArrayList<TestResult> arrayList = new ArrayList<TestResult>();
            for (MiningResultType miningResultType : list) {
                arrayList.add(new ClassTestResult(context, (BuildNodeType)classificationBuildNodeType, miningResultType));
            }
            testCompareNode.setTestResults(arrayList);
            testCompareNode.setURL(uRL);
            testCompareNode.setContext(context);
            testCompareNode.setConnectionFolder(connectionFolder);
            testCompareNode.setClassificationTest(true);
        }
        return testCompareNode;
    }

    public static TestResultNode createRegressTestResultNode(Context context, WorkflowNode workflowNode, String string, String string2, RegressionBuildNodeType regressionBuildNodeType, RegressionResultType regressionResultType) throws Exception {
        TestResultNode testResultNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Result" + "/" + string2));
        testResultNode = (TestResultNode)NodeFactory.findOrCreate(TestResultNode.class, (URL)uRL);
        if (testResultNode != null) {
            testResultNode.setRepositoryData(new RegressTestResult(context, (BuildNodeType)regressionBuildNodeType, (MiningResultType)regressionResultType));
            testResultNode.setURL(uRL);
            testResultNode.setResultName(string2);
            testResultNode.setUserName(string);
            testResultNode.setContext(context);
            testResultNode.setConnectionFolder(connectionFolder);
            testResultNode.setClassificationTest(false);
        }
        return testResultNode;
    }

    public static TestCompareNode createRegressTestCompareNode(Context context, WorkflowNode workflowNode, String string, RegressionBuildNodeType regressionBuildNodeType, List<? extends MiningResultType> list) throws Exception {
        TestCompareNode testCompareNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Compare" + "/" + regressionBuildNodeType.getName()));
        testCompareNode = (TestCompareNode)NodeFactory.findOrCreate(TestCompareNode.class, (URL)uRL);
        if (testCompareNode != null) {
            ArrayList<TestResult> arrayList = new ArrayList<TestResult>();
            for (MiningResultType miningResultType : list) {
                arrayList.add(new RegressTestResult(context, (BuildNodeType)regressionBuildNodeType, miningResultType));
            }
            testCompareNode.setTestResults(arrayList);
            testCompareNode.setURL(uRL);
            testCompareNode.setContext(context);
            testCompareNode.setConnectionFolder(connectionFolder);
            testCompareNode.setClassificationTest(false);
        }
        return testCompareNode;
    }

    public static TestResultNode createClassTestResultNode(Context context, WorkflowNode workflowNode, String string, String string2, TestNodeType testNodeType, ClassificationResultType classificationResultType) throws Exception {
        TestResultNode testResultNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Result" + "/" + string + "/" + string2));
        testResultNode = (TestResultNode)NodeFactory.findOrCreate(TestResultNode.class, (URL)uRL);
        if (testResultNode != null) {
            testResultNode.setRepositoryData(new ClassTestResult(context, testNodeType, (MiningResultType)classificationResultType));
            testResultNode.setURL(uRL);
            testResultNode.setResultName(string2);
            testResultNode.setUserName(string);
            testResultNode.setContext(context);
            testResultNode.setConnectionFolder(connectionFolder);
            testResultNode.setClassificationTest(true);
        }
        return testResultNode;
    }

    public static TestCompareNode createClassTestCompareNode(Context context, WorkflowNode workflowNode, String string, TestNodeType testNodeType, List<? extends MiningResultType> list) throws Exception {
        TestCompareNode testCompareNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Compare" + "/" + testNodeType.getName()));
        testCompareNode = (TestCompareNode)NodeFactory.findOrCreate(TestCompareNode.class, (URL)uRL);
        if (testCompareNode != null) {
            ArrayList<TestResult> arrayList = new ArrayList<TestResult>();
            for (MiningResultType miningResultType : list) {
                arrayList.add(new ClassTestResult(context, testNodeType, miningResultType));
            }
            testCompareNode.setTestResults(arrayList);
            testCompareNode.setURL(uRL);
            testCompareNode.setContext(context);
            testCompareNode.setConnectionFolder(connectionFolder);
            testCompareNode.setClassificationTest(true);
        }
        return testCompareNode;
    }

    public static TestResultNode createRegressTestResultNode(Context context, WorkflowNode workflowNode, String string, String string2, TestNodeType testNodeType, RegressionResultType regressionResultType) throws Exception {
        TestResultNode testResultNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Result" + "/" + string + "/" + string2));
        testResultNode = (TestResultNode)NodeFactory.findOrCreate(TestResultNode.class, (URL)uRL);
        if (testResultNode != null) {
            testResultNode.setRepositoryData(new RegressTestResult(context, testNodeType, (MiningResultType)regressionResultType));
            testResultNode.setURL(uRL);
            testResultNode.setResultName(string2);
            testResultNode.setUserName(string);
            testResultNode.setContext(context);
            testResultNode.setConnectionFolder(connectionFolder);
            testResultNode.setClassificationTest(false);
        }
        return testResultNode;
    }

    public static TestCompareNode createRegressTestCompareNode(Context context, WorkflowNode workflowNode, String string, TestNodeType testNodeType, List<? extends MiningResultType> list) throws Exception {
        TestCompareNode testCompareNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Compare" + "/" + testNodeType.getName()));
        testCompareNode = (TestCompareNode)NodeFactory.findOrCreate(TestCompareNode.class, (URL)uRL);
        if (testCompareNode != null) {
            ArrayList<TestResult> arrayList = new ArrayList<TestResult>();
            for (MiningResultType miningResultType : list) {
                arrayList.add(new RegressTestResult(context, testNodeType, miningResultType));
            }
            testCompareNode.setTestResults(arrayList);
            testCompareNode.setURL(uRL);
            testCompareNode.setContext(context);
            testCompareNode.setConnectionFolder(connectionFolder);
            testCompareNode.setClassificationTest(false);
        }
        return testCompareNode;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void handlePrimaryEdit(Context context, WorkflowEditor workflowEditor) throws Exception {
        if (null == workflowEditor.getSelectedDiagramNode()) {
            return;
        }
        AbstractNode abstractNode = (AbstractNode)workflowEditor.getSelectedDiagramNode();
        if (abstractNode instanceof AbstractBuildNode) {
            AbstractBuildNode abstractBuildNode = (AbstractBuildNode)abstractNode;
            BuildEditDialog buildEditDialog = new BuildEditDialog();
            buildEditDialog.invoke(context, abstractBuildNode, new ArrayList<String>());
            return;
        } else if (abstractNode instanceof AbstractModelNode) {
            AbstractModelNode abstractModelNode = (AbstractModelNode)abstractNode;
            EditModelNodeDialog editModelNodeDialog = new EditModelNodeDialog();
            editModelNodeDialog.invoke(context, abstractModelNode, null);
            return;
        } else if (abstractNode instanceof ModelDetailsDataNode) {
            ModelDetailsDataNode modelDetailsDataNode = (ModelDetailsDataNode)abstractNode;
            EditModelDetailsAutoDialog editModelDetailsAutoDialog = new EditModelDetailsAutoDialog();
            editModelDetailsAutoDialog.invoke(context, modelDetailsDataNode);
            return;
        } else if (abstractNode instanceof ApplyNode) {
            ApplyNode applyNode = (ApplyNode)abstractNode;
            ApplyEditorDialog applyEditorDialog = new ApplyEditorDialog();
            applyEditorDialog.invoke(context, applyNode, null);
            return;
        } else if (abstractNode instanceof JoinNode) {
            JoinNode joinNode = (JoinNode)abstractNode;
            JoinEditorDialog joinEditorDialog = new JoinEditorDialog();
            joinEditorDialog.invoke(context, joinNode, null);
            return;
        } else if (abstractNode instanceof ColumnFilterNode) {
            ColumnFilterNode columnFilterNode = (ColumnFilterNode)abstractNode;
            OutputColumnDialog outputColumnDialog = new OutputColumnDialog();
            outputColumnDialog.invoke(context, columnFilterNode, (OutputColumnPanel)null);
            return;
        } else if (abstractNode instanceof FilterDetailsDataNode) {
            FilterDetailsDataNode filterDetailsDataNode = (FilterDetailsDataNode)abstractNode;
            OutputSettingDialog outputSettingDialog = new OutputSettingDialog();
            outputSettingDialog.invoke(context, filterDetailsDataNode);
            return;
        } else if (abstractNode instanceof TestNode) {
            TestNode testNode = (TestNode)abstractNode;
            TestModelDialog testModelDialog = new TestModelDialog();
            testModelDialog.invoke(context, testNode, null);
            return;
        } else if (abstractNode instanceof DataProfileNode) {
            DataProfileAttributesDialog dataProfileAttributesDialog = new DataProfileAttributesDialog();
            AbstractNode abstractNode2 = abstractNode.findParentNode();
            dataProfileAttributesDialog.invoke(context, (DataProfileNode)abstractNode, (AbstractDataNode)abstractNode2);
            return;
        } else if (abstractNode instanceof CreateTableNode) {
            CreateTableNodeAttributesDialog createTableNodeAttributesDialog = new CreateTableNodeAttributesDialog();
            AbstractNode abstractNode3 = abstractNode.findParentNode();
            createTableNodeAttributesDialog.invoke(context, (CreateTableNode)abstractNode, (AbstractDataNode)abstractNode3);
            return;
        } else if (abstractNode instanceof UpdateTableNode) {
            UpdateTableNodeAttributesDialog updateTableNodeAttributesDialog = new UpdateTableNodeAttributesDialog();
            AbstractNode abstractNode4 = abstractNode.findParentNode();
            updateTableNodeAttributesDialog.invoke(context, (UpdateTableNode)abstractNode, (AbstractDataNode)abstractNode4);
            return;
        } else if (abstractNode instanceof TransformationNode) {
            TransformSettingsEditorDialog transformSettingsEditorDialog = new TransformSettingsEditorDialog();
            AbstractNode abstractNode5 = abstractNode.findParentNode();
            transformSettingsEditorDialog.invoke(context, (TransformationNode)abstractNode, (AbstractDataNode)abstractNode5);
            return;
        } else if (abstractNode instanceof DataSourceNode) {
            DataSourceNode dataSourceNode = (DataSourceNode)abstractNode;
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)dataSourceNode.getData();
            boolean bl = false;
            if (dataSourceNodeType.getSourceTable() != null && dataSourceNodeType.getSourceTable().getName() != null && dataSourceNodeType.getSourceTable().getName().length() != 0) {
                bl = true;
            }
            if (bl) {
                DataSourceAttributesDialog dataSourceAttributesDialog = new DataSourceAttributesDialog();
                DataSourceNodeType dataSourceNodeType2 = (DataSourceNodeType)dataSourceNode.getData();
                if (dataSourceAttributesDialog.invoke(context, dataSourceNode) || null == dataSourceAttributesDialog.getErrorMessage()) return;
                if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)dataSourceAttributesDialog.getErrorMessage(), (String)DataDialogsLrb.get("TABLE_CHOOSER_FAILURE_TITLE"), null)) {
                    DataSourceWizard dataSourceWizard = new DataSourceWizard();
                    dataSourceWizard.setTableExists(false);
                    if (dataSourceWizard.runWizard((Component)Ide.getMainWindow(), context, dataSourceNode)) return;
                }
                dataSourceAttributesDialog = new DataSourceAttributesDialog();
                dataSourceAttributesDialog.setCheckForUnderlyingTable(false);
                dataSourceAttributesDialog.invoke(context, dataSourceNode);
                return;
            } else {
                DataSourceWizard dataSourceWizard = new DataSourceWizard();
                dataSourceWizard.runWizard((Component)Ide.getMainWindow(), context, dataSourceNode);
            }
            return;
        } else if (abstractNode instanceof AggregationNode) {
            AggregationNodeAttributesDialog aggregationNodeAttributesDialog = new AggregationNodeAttributesDialog();
            AbstractNode abstractNode6 = abstractNode.findParentNode();
            aggregationNodeAttributesDialog.invoke(context, (AggregationNode)abstractNode, (AbstractDataNode)abstractNode6);
            return;
        } else if (abstractNode instanceof SampleNode) {
            SampleNode sampleNode = (SampleNode)abstractNode;
            SettingsDialog settingsDialog = new SettingsDialog();
            settingsDialog.invoke(context, sampleNode);
            return;
        } else if (abstractNode instanceof RowFilterNode) {
            RowFilterNode rowFilterNode = (RowFilterNode)abstractNode;
            RowFilterEditorDialog rowFilterEditorDialog = new RowFilterEditorDialog();
            rowFilterEditorDialog.invoke(context, rowFilterNode);
            return;
        } else if (abstractNode instanceof BuildTextNode) {
            BuildTextNode buildTextNode = (BuildTextNode)abstractNode;
            BuildTextDialog buildTextDialog = new BuildTextDialog();
            buildTextDialog.invoke(context, buildTextNode);
            return;
        } else if (abstractNode instanceof ApplyTextNode) {
            ApplyTextNode applyTextNode = (ApplyTextNode)abstractNode;
            ApplyTextDialog applyTextDialog = new ApplyTextDialog();
            applyTextDialog.invoke(context, applyTextNode);
            return;
        } else if (abstractNode instanceof BuildTextNodeRef) {
            BuildTextNodeRef buildTextNodeRef = (BuildTextNodeRef)abstractNode;
            TextDialog textDialog = new TextDialog();
            textDialog.invoke(context, buildTextNodeRef);
            return;
        } else {
            new Exception("Node type: " + abstractNode.getClass().getName() + " not handled in WorflowContextMenu.handlePrimaryEdit ()").printStackTrace();
        }
    }

    private void handleSecondaryEdit(Context context, WorkflowEditor workflowEditor) throws Exception {
        if (null == workflowEditor.getSelectedDiagramNode()) {
            return;
        }
        AbstractNode abstractNode = (AbstractNode)workflowEditor.getSelectedDiagramNode();
        if (abstractNode instanceof AbstractBuildNode) {
            AbstractBuildNode abstractBuildNode = (AbstractBuildNode)abstractNode;
            AdvancedSettingsDialog advancedSettingsDialog = new AdvancedSettingsDialog();
            advancedSettingsDialog.invoke(context, abstractBuildNode, null, null);
        } else if (abstractNode instanceof DataSourceNode) {
            DataSourceNode dataSourceNode = (DataSourceNode)abstractNode;
            DataSourceAttributesDialog dataSourceAttributesDialog = new DataSourceAttributesDialog();
            dataSourceAttributesDialog.invoke(context, dataSourceNode);
        } else {
            new Exception("Node type: " + abstractNode.getClass().getName() + " not handled in WorflowContextMenu.handleSecondaryEdit ()").printStackTrace();
        }
    }

    private void handleTertiaryEdit(Context context, WorkflowEditor workflowEditor) throws Exception {
        if (null == workflowEditor.getSelectedDiagramNode()) {
            return;
        }
        AbstractNode abstractNode = (AbstractNode)workflowEditor.getSelectedDiagramNode();
        if (abstractNode instanceof DataSourceNode) {
            DataSourceNode dataSourceNode = (DataSourceNode)abstractNode;
            DataSourceWizard dataSourceWizard = new DataSourceWizard();
            dataSourceWizard.runWizard((Component)Ide.getMainWindow(), context, dataSourceNode);
        } else {
            new Exception("Node type: " + abstractNode.getClass().getName() + " not handled in WorflowContextMenu.handleSecondaryEdit ()").printStackTrace();
        }
    }

    private void handleSwapTestData(WorkflowEditor workflowEditor) throws Exception {
        GeneralLink generalLink = workflowEditor.getSelectedDiagramLink();
        AbstractNode abstractNode = (AbstractNode)workflowEditor.getSelectedDiagramNode();
        if (generalLink == null && abstractNode == null) {
            return;
        }
        if (generalLink != null) {
            abstractNode = (AbstractNode)generalLink.getTo();
        }
        if (abstractNode == null) {
            return;
        }
        if (!(abstractNode instanceof SupervisedBuildNode)) {
            return;
        }
        SupervisedBuildNode supervisedBuildNode = (SupervisedBuildNode)abstractNode;
        try {
            CommandProcessor.getInstance().beginTrans(WorkflowEditorLrb.get("SWAP"));
            supervisedBuildNode.swapDataSources();
            CommandProcessor.getInstance().endTrans();
        }
        catch (Exception exception) {
            CommandProcessor.getInstance().abortTrans();
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
        }
    }

    private void handleShowErrorStatus(Context context, Node node, WorkflowEditor workflowEditor) throws Exception {
        workflowEditor.displayEventLogForNode(context, node);
    }

    private void handleShowValidationErrors(Node node, WorkflowEditor workflowEditor) {
        try {
            workflowEditor.displayValidations(node);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
        }
    }

    private void handleForceRunParentsAction(final WorkflowEditor workflowEditor) throws Exception {
        Node node = null;
        try {
            node = workflowEditor.getSelectedDiagramNode();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            return;
        }
        if (!node.validateRunChain(true)) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("NODES_IN_RUN_CHAIN_INVALID"), (String)WorkflowEditorLrb.get("NODES_IN_RUN_ERROR_TITLE"), null);
            return;
        }
        class StartForceRunParentsWorkflow
        extends ProgressRunnable {
            StartForceRunParentsWorkflow() {
            }

            protected Object doWork() throws Exception {
                WorkflowContextMenu.startWorkflow(workflowEditor, this, workflowEditor.getSelectedDiagramNode(), true);
                return true;
            }
        }
        StartForceRunParentsWorkflow startForceRunParentsWorkflow = new StartForceRunParentsWorkflow();
        startForceRunParentsWorkflow.setTitle(WorkflowEditorLrb.get("START_WORKFLOW"));
        startForceRunParentsWorkflow.setMessage(WorkflowEditorLrb.get("START_WORKFLOW_DESCR"));
        startForceRunParentsWorkflow.setCancelable(false);
        startForceRunParentsWorkflow.start(true);
    }

    private void handleForceRunChildrenAction(final WorkflowEditor workflowEditor) throws Exception {
        Node node = null;
        try {
            node = workflowEditor.getSelectedDiagramNode();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            return;
        }
        if (!node.validateChildrenRunChain(true)) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("NODES_IN_RUN_CHAIN_INVALID"), (String)WorkflowEditorLrb.get("NODES_IN_RUN_ERROR_TITLE"), null);
            return;
        }
        class StartForceRunChildrenWorkflow
        extends ProgressRunnable {
            StartForceRunChildrenWorkflow() {
            }

            protected Object doWork() throws Exception {
                WorkflowContextMenu.startWorkflow(workflowEditor, this, workflowEditor.getSelectedDiagramNode(), false);
                return true;
            }
        }
        StartForceRunChildrenWorkflow startForceRunChildrenWorkflow = new StartForceRunChildrenWorkflow();
        startForceRunChildrenWorkflow.setTitle(WorkflowEditorLrb.get("START_WORKFLOW"));
        startForceRunChildrenWorkflow.setMessage(WorkflowEditorLrb.get("START_WORKFLOW_DESCR"));
        startForceRunChildrenWorkflow.setCancelable(false);
        startForceRunChildrenWorkflow.start(true);
    }

    private void handleForceRunSelectedAndChildrenAction(final WorkflowEditor workflowEditor) throws Exception {
        Node node = null;
        try {
            node = workflowEditor.getSelectedDiagramNode();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            return;
        }
        if (!node.validateChildrenRunChain(true)) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("NODES_IN_RUN_CHAIN_INVALID"), (String)WorkflowEditorLrb.get("NODES_IN_RUN_ERROR_TITLE"), null);
            return;
        }
        NodeType nodeType = node.getData();
        if (nodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) || nodeType.getStatus().equals((Object)NodeStatusType.WARNING)) {
            node.setNodeReady();
        }
        class StartForceSelectedAndRunChildrenWorkflow
        extends ProgressRunnable {
            StartForceSelectedAndRunChildrenWorkflow() {
            }

            protected Object doWork() throws Exception {
                WorkflowContextMenu.startWorkflow(workflowEditor, this, workflowEditor.getSelectedDiagramNode(), false);
                return true;
            }
        }
        StartForceSelectedAndRunChildrenWorkflow startForceSelectedAndRunChildrenWorkflow = new StartForceSelectedAndRunChildrenWorkflow();
        startForceSelectedAndRunChildrenWorkflow.setTitle(WorkflowEditorLrb.get("START_WORKFLOW"));
        startForceSelectedAndRunChildrenWorkflow.setMessage(WorkflowEditorLrb.get("START_WORKFLOW_DESCR"));
        startForceSelectedAndRunChildrenWorkflow.setCancelable(false);
        startForceSelectedAndRunChildrenWorkflow.start(true);
    }

    public static void handleRunAction(WorkflowEditor workflowEditor, boolean bl) throws Exception {
        Node node = null;
        try {
            node = workflowEditor.getSelectedDiagramNode();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            return;
        }
        if (!node.validateRunChain(false)) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("NODES_IN_RUN_CHAIN_INVALID"), (String)WorkflowEditorLrb.get("NODES_IN_RUN_ERROR_TITLE"), null);
            return;
        }
        NodeType nodeType = node.getData();
        if (nodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) || nodeType.getStatus().equals((Object)NodeStatusType.WARNING)) {
            if (bl || MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("NODE_IS_ALREADY_COMPLETE"), (String)WorkflowEditorLrb.get("RUN_NODE_WARNING_TITLE"), null)) {
                node.setNodeReady();
            } else {
                return;
            }
        }
        class StartWorkflow
        extends ProgressRunnable {
            final /* synthetic */ WorkflowEditor val$editor;

            StartWorkflow(WorkflowEditor workflowEditor) {
                this.val$editor = workflowEditor;
            }

            protected Object doWork() throws Exception {
                WorkflowContextMenu.startWorkflow(this.val$editor, this, this.val$editor.getSelectedDiagramNode(), true);
                return true;
            }
        }
        StartWorkflow startWorkflow = new StartWorkflow(workflowEditor);
        startWorkflow.setTitle(WorkflowEditorLrb.get("START_WORKFLOW"));
        startWorkflow.setMessage(WorkflowEditorLrb.get("START_WORKFLOW_DESCR"));
        startWorkflow.setCancelable(false);
        startWorkflow.start(true);
    }

    public static void handleGenerateCodeAction(Context context, WorkflowEditor workflowEditor, GenerateCode.CODE_GENERATION_OPTION cODE_GENERATION_OPTION) throws Exception {
        boolean bl = false;
        Node node = null;
        try {
            node = workflowEditor.getSelectedDiagramNode();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!node.validateLineageChain()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("NODES_IN_CODE_GEN_CHAIN_INVALID"), (String)WorkflowEditorLrb.get("NODES_IN_CODE_GEN_ERROR_TITLE"), null);
            return;
        }
        GenerateCode generateCode = new GenerateCode(context, workflowEditor.getSelectedDiagramNode(), workflowEditor, cODE_GENERATION_OPTION);
        if (cODE_GENERATION_OPTION.equals((Object)GenerateCode.CODE_GENERATION_OPTION.SQL_SCRIPT_TO_CLIPBOARD) || cODE_GENERATION_OPTION.equals((Object)GenerateCode.CODE_GENERATION_OPTION.SQL_TO_CLIPBOARD)) {
            class GenCodeProcess
            extends ProgressRunnable {
                GenerateCode _codeGen;
                Boolean _success = false;

                GenCodeProcess(GenerateCode generateCode) {
                    this._codeGen = generateCode;
                }

                protected Object doWork() throws Exception {
                    this._success = this._codeGen.run();
                    return this._success;
                }

                public boolean isSuccessful() {
                    return this._success;
                }

                public Exception getException() {
                    return this._codeGen.getException();
                }
            }
            GenCodeProcess genCodeProcess = new GenCodeProcess(generateCode);
            genCodeProcess.setTitle(WorkflowEditorLrb.get("GENERATING_CODE"));
            genCodeProcess.setMessage(WorkflowEditorLrb.get("GENERATING_CODE_DESCR"));
            genCodeProcess.setCancelable(false);
            genCodeProcess.start(true);
            bl = genCodeProcess.isSuccessful();
        } else {
            bl = generateCode.run();
        }
        if (!bl) {
            if (generateCode.getException() != null) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)generateCode.getException(), (String)WorkflowEditorLrb.get("NODES_IN_CODE_GEN_ERROR_TITLE"), (String)WorkflowEditorLrb.get("NODES_IN_CODE_GEN_CHAIN_UNEXPECTED"));
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("NODES_IN_CODE_GEN_CHAIN_UNEXPECTED"), (String)WorkflowEditorLrb.get("NODES_IN_CODE_GEN_ERROR_TITLE"), null);
            }
        }
    }

    private void handleViewDataAction(Context context, WorkflowEditor workflowEditor) throws Exception {
        Node node = workflowEditor.getSelectedDiagramNode();
        if (node == null) {
            return;
        }
        this.launchDataViewer((AbstractDataNode)node, context);
    }

    public static boolean isExtendedPaste() {
        return inExtendedPaste;
    }

    public static boolean getKeepModelNamesUnique() {
        return keepModelNamesUnique;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        Object object;
        inExtendedPaste = false;
        View view = context.getView();
        if (!(view instanceof WorkflowEditor)) {
            return false;
        }
        WorkflowEditor workflowEditor = (WorkflowEditor)view;
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        ArrayList<GeneralLink> arrayList2 = new ArrayList<GeneralLink>();
        IlvManagerView ilvManagerView = ((DiagramView)view).getActiveManagerView();
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine == null) {
            return true;
        }
        Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (object instanceof AbstractNode) {
                arrayList.add((AbstractNode)object);
                continue;
            }
            if (!(object instanceof GeneralLink)) continue;
            arrayList2.add((GeneralLink)object);
        }
        if (ideAction.getCommandId() == 78) {
            object = DiagramContext.getDiagramContext((IlvManagerView)((DiagramView)view).getActiveManagerView());
            inExtendedPaste = true;
            PasteExtendedDialog pasteExtendedDialog = new PasteExtendedDialog();
            if (!pasteExtendedDialog.invoke()) {
                return true;
            }
            keepModelNamesUnique = pasteExtendedDialog.getKeepModelNamesUnique();
            CopyPastePlugin copyPastePlugin = (CopyPastePlugin)object.getPlugin(CopyPastePlugin.class);
            if (copyPastePlugin != null) {
                copyPastePlugin.paste();
            }
            return true;
        }
        if (ideAction.getCommandId() == PRIMARY_EDIT_ACTION_ID || ideAction.equals(IdeAction.find((int)Actions.CMD_EDIT_PROPERTIES))) {
            try {
                WorkflowContextMenu.handlePrimaryEdit(context, workflowEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == SECONDARY_EDIT_ACTION_ID) {
            try {
                this.handleSecondaryEdit(context, workflowEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == TERTIARY_EDIT_ACTION_ID) {
            try {
                this.handleTertiaryEdit(context, workflowEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == SWAP_BUILD_TEST_DATA_ID) {
            try {
                this.handleSwapTestData(workflowEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == VIEW_ERROR_STATUS_ID) {
            if (arrayList.size() == 1) {
                object = (Node)arrayList.get(0);
                NodeType nodeType = object.getData();
                if (nodeType.getStatus().equals((Object)NodeStatusType.INVALID)) {
                    this.handleShowValidationErrors((Node)object, workflowEditor);
                } else {
                    try {
                        this.handleShowErrorStatus(context, (Node)object, workflowEditor);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
                    }
                }
            }
            return true;
        }
        if (ideAction.getCommandId() == GENERATE_APPLY_CHAIN_ID) {
            if (arrayList.size() > 0) {
                try {
                    workflowEditor.handleGenerateApplyChain();
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
                }
            }
            return true;
        }
        if (ideAction.getCommandId() == RUN_ACTION_ID) {
            try {
                WorkflowContextMenu.handleRunAction(workflowEditor, false);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == RUN_FORCE_SELECTED_ACTION_ID) {
            try {
                WorkflowContextMenu.handleRunAction(workflowEditor, true);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == RUN_FORCE_CHILDREN_ACTION_ID) {
            try {
                this.handleForceRunChildrenAction(workflowEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == RUN_FORCE_SELECTED_AND_CHILDREN_ACTION_ID) {
            try {
                this.handleForceRunSelectedAndChildrenAction(workflowEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == RUN_FORCE_PARENTS_ACTION_ID) {
            try {
                this.handleForceRunParentsAction(workflowEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == COPY_SQL_TO_CLIPBOARD_ACTION_ID) {
            try {
                WorkflowContextMenu.handleGenerateCodeAction(context, workflowEditor, GenerateCode.CODE_GENERATION_OPTION.SQL_TO_CLIPBOARD);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == COPY_SQL_TO_FILE_ACTION_ID) {
            try {
                WorkflowContextMenu.handleGenerateCodeAction(context, workflowEditor, GenerateCode.CODE_GENERATION_OPTION.SQL_TO_FILE);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == COPY_PLSQL_TO_CLIPBOARD_ACTION_ID) {
            try {
                WorkflowContextMenu.handleGenerateCodeAction(context, workflowEditor, GenerateCode.CODE_GENERATION_OPTION.SQL_SCRIPT_TO_CLIPBOARD);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == COPY_PLSQL_TO_FILE_ACTION_ID) {
            try {
                WorkflowContextMenu.handleGenerateCodeAction(context, workflowEditor, GenerateCode.CODE_GENERATION_OPTION.SQL_SCRIPT_TO_FILE);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == VIEW_DATA_ACTION_ID) {
            try {
                this.handleViewDataAction(context, workflowEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == CONNECT_ACTION_ID) {
            this.handleConnectAction(context, workflowEditor);
            return true;
        }
        if (ideAction.getCommandId() == 22) {
            this.handleSelectAll(ideAction, context);
            return true;
        }
        if (ideAction.getCommandId() == 20 || ideAction.getCommandId() == 17) {
            if (!this.confirmDelete(workflowEditor)) {
                return true;
            }
        } else if (ideAction.getCommandId() == GO_TO_PROPERTY_ID) {
            if (InspectorManager.getInspectorManager() != null) {
                InspectorManager.getInspectorManager().showLastView(null);
            }
            return true;
        }
        return false;
    }

    private boolean confirmDelete(WorkflowEditor workflowEditor) {
        IlvManagerView ilvManagerView = workflowEditor.getActiveManagerView();
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof AbstractBuildNode) && !(e instanceof CreateTableNode)) continue;
            bl = true;
        }
        boolean bl2 = true;
        MessageDialogPersistence messageDialogPersistence = MessageDialog.getPersistence();
        Boolean bl3 = messageDialogPersistence.getConfirmed("warnDeleteObjects");
        if (bl3 != null && bl3 == Boolean.FALSE) {
            messageDialogPersistence.setConfirmed("warnDeleteObjects", Boolean.valueOf(true));
        }
        if (bl) {
            bl2 = MessageDialog.optionalConfirm((String)"warnDeleteObjects", (Component)Ide.getMainWindow(), (String)WorkflowEditorLrb.get("DELETE_OBJECTS_WARNING_NODE"), (String)WorkflowEditorLrb.get("DELETE_OBJECTS_WARNING_TITLE"), null);
        }
        return bl2;
    }

    public void handleSelectAll(IdeAction ideAction, Context context) {
        View view = context.getView();
        if (!(view instanceof WorkflowEditor)) {
            return;
        }
        IlvManagerView ilvManagerView = ((DiagramView)view).getActiveManagerView();
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        ilvSDMEngine.selectAllObjects();
    }

    public boolean update(IdeAction ideAction, Context context) {
        AbstractNode abstractNode;
        View view = context.getView();
        if (!(view instanceof WorkflowEditor)) {
            ideAction.setEnabled(false);
            return false;
        }
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        ArrayList<GeneralLink> arrayList2 = new ArrayList<GeneralLink>();
        IlvManagerView ilvManagerView = ((DiagramView)view).getActiveManagerView();
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine == null) {
            return true;
        }
        Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
        while (enumeration.hasMoreElements()) {
            abstractNode = (AbstractNode)enumeration.nextElement();
            if (abstractNode instanceof AbstractNode) {
                arrayList.add(abstractNode);
                continue;
            }
            if (!(abstractNode instanceof GeneralLink)) continue;
            arrayList2.add((GeneralLink)((Object)abstractNode));
        }
        abstractNode = null;
        NodeType nodeType = null;
        if (!arrayList.isEmpty()) {
            abstractNode = (AbstractNode)arrayList.get(0);
            nodeType = abstractNode.getData();
        }
        int n = arrayList.size();
        boolean bl = !workflowNode.isReadOnly() && nodeType != null && !nodeType.getStatus().equals((Object)NodeStatusType.INVALID);
        boolean bl2 = false;
        boolean bl3 = workflowNode.isReadOnly();
        if (ideAction.getCommandId() == PRIMARY_EDIT_ACTION_ID || ideAction.equals(IdeAction.find((int)Actions.CMD_EDIT_PROPERTIES))) {
            if (this.isRequirePrimaryEditMenu(nodeType)) {
                bl2 = n == 1 && !bl3;
            }
            ideAction.setEnabled(bl2);
            return true;
        }
        if (ideAction.getCommandId() == SECONDARY_EDIT_ACTION_ID) {
            if (this.isRequireSecondaryEditMenu(nodeType)) {
                bl2 = n == 1 && !bl3;
            }
            ideAction.setEnabled(bl2);
            return true;
        }
        if (ideAction.getCommandId() == TERTIARY_EDIT_ACTION_ID) {
            if (this.isRequireTertiaryEditMenu(nodeType)) {
                bl2 = n == 1 && !bl3;
            }
            ideAction.setEnabled(bl2);
            return true;
        }
        if (ideAction.getCommandId() == 78 || ideAction.getCommandId() == 19) {
            DiagramContext diagramContext = DiagramContext.getDiagramContext((IlvManagerView)ilvManagerView);
            CopyPastePlugin copyPastePlugin = (CopyPastePlugin)diagramContext.getPlugin(CopyPastePlugin.class);
            if (copyPastePlugin != null) {
                ideAction.setEnabled(copyPastePlugin.canPaste() && !bl3);
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (ideAction.getCommandId() == RUN_ACTION_ID || ideAction.getCommandId() == RUN_FORCE_SELECTED_ACTION_ID || ideAction.getCommandId() == RUN_FORCE_CHILDREN_ACTION_ID || ideAction.getCommandId() == RUN_FORCE_SELECTED_AND_CHILDREN_ACTION_ID || ideAction.getCommandId() == RUN_FORCE_PARENTS_ACTION_ID) {
            ideAction.setEnabled(n == 1 && bl && !bl3);
            return true;
        }
        if (ideAction.getCommandId() == COPY_SQL_TO_CLIPBOARD_ACTION_ID) {
            ideAction.setEnabled(n == 1 && !bl3 && !nodeType.getStatus().equals((Object)NodeStatusType.INVALID));
            return true;
        }
        if (ideAction.getCommandId() == COPY_SQL_TO_FILE_ACTION_ID) {
            ideAction.setEnabled(n == 1 && !bl3 && !nodeType.getStatus().equals((Object)NodeStatusType.INVALID));
            return true;
        }
        if (ideAction.getCommandId() == COPY_PLSQL_TO_CLIPBOARD_ACTION_ID) {
            ideAction.setEnabled(n == 1 && !bl3 && !nodeType.getStatus().equals((Object)NodeStatusType.INVALID));
            return true;
        }
        if (ideAction.getCommandId() == COPY_PLSQL_TO_FILE_ACTION_ID) {
            ideAction.setEnabled(n == 1 && !bl3 && !nodeType.getStatus().equals((Object)NodeStatusType.INVALID));
            return true;
        }
        if (ideAction.getCommandId() == SWAP_BUILD_TEST_DATA_ID) {
            ideAction.setEnabled(n == 1 && !bl3);
            return true;
        }
        if (ideAction.getCommandId() == GENERATE_APPLY_CHAIN_ID) {
            ideAction.setEnabled(!bl3);
            return true;
        }
        if (ideAction.getCommandId() == VIEW_DATA_ACTION_ID) {
            if (bl3) {
                ideAction.setEnabled(false);
                return true;
            }
            if (n == 1) {
                if (abstractNode instanceof DataSourceNode) {
                    ideAction.setEnabled(nodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) || nodeType.getStatus().equals((Object)NodeStatusType.WARNING) || nodeType.getStatus().equals((Object)NodeStatusType.READY));
                } else if (abstractNode instanceof DataProfileNode) {
                    ideAction.setEnabled(nodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) || nodeType.getStatus().equals((Object)NodeStatusType.WARNING) || nodeType.getStatus().equals((Object)NodeStatusType.READY));
                } else if (abstractNode instanceof CreateTableNode) {
                    ideAction.setEnabled(nodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) || nodeType.getStatus().equals((Object)NodeStatusType.WARNING) || nodeType.getStatus().equals((Object)NodeStatusType.READY));
                } else if (abstractNode instanceof UpdateTableNode) {
                    ideAction.setEnabled(nodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) || nodeType.getStatus().equals((Object)NodeStatusType.WARNING) || nodeType.getStatus().equals((Object)NodeStatusType.READY));
                } else if (abstractNode instanceof AbstractTransformNode) {
                    ideAction.setEnabled(nodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) || nodeType.getStatus().equals((Object)NodeStatusType.WARNING) || nodeType.getStatus().equals((Object)NodeStatusType.READY));
                } else if (abstractNode instanceof AggregationNode) {
                    ideAction.setEnabled(nodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) || nodeType.getStatus().equals((Object)NodeStatusType.WARNING) || nodeType.getStatus().equals((Object)NodeStatusType.READY));
                }
            }
            return true;
        }
        if (ideAction.getCommandId() == CONNECT_ACTION_ID) {
            ideAction.setEnabled(arrayList.size() == 1 && !bl3);
            return true;
        }
        if (ideAction.getCommandId() == VIEW_ERROR_STATUS_ID) {
            ideAction.setEnabled(arrayList.size() == 1);
            return true;
        }
        if (ideAction.getCommandId() == 17 || ideAction.getCommandId() == 20) {
            ideAction.setEnabled((arrayList.size() >= 1 || arrayList2.size() >= 1) && !bl3);
            return true;
        }
        if (ideAction.getCommandId() == 22) {
            ideAction.setEnabled(true);
            return true;
        }
        if (ideAction.getCommandId() == GO_TO_PROPERTY_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }

    private void handleConnectAction(Context context, WorkflowEditor workflowEditor) {
        final IlvManagerView ilvManagerView = workflowEditor.getActiveManagerView();
        DiagramContext diagramContext = DiagramContext.getDiagramContext((IlvManagerView)ilvManagerView);
        ModularPalettePlugin modularPalettePlugin = (ModularPalettePlugin)diagramContext.getPlugin(PalettePlugin.class);
        PaletteItem paletteItem = WorkflowPalettePages.getInstance().getItem(WorkflowPalettePageProvider.class.getName(), "transition");
        final WorkflowDiagram.OdmrCreateLinkPaletteItemHandler odmrCreateLinkPaletteItemHandler = (WorkflowDiagram.OdmrCreateLinkPaletteItemHandler)modularPalettePlugin.getPaletteItemTypeHandler("WorkflowLink");
        try {
            IlvSDMEngine ilvSDMEngine = ((WorkflowNode)context.getNode()).getEngine();
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            Object e = enumeration.nextElement();
            final IlvGraphic ilvGraphic = ilvSDMEngine.getGraphic(e, false);
            modularPalettePlugin.paletteItemSelected(paletteItem);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    odmrCreateLinkPaletteItemHandler.getLastCreatedInteractor().startConnectionFrom(ilvManagerView, ilvGraphic);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean launchDataViewer(AbstractDataNode abstractDataNode, Context context) throws Exception {
        DataNode dataNode;
        boolean bl = false;
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        if (abstractDataNode instanceof AbstractDataNode) {
            dataNode = null;
            dataNode = DataNode.findDataNode(workflowNode, abstractDataNode.getData().getName());
            if (dataNode == null) {
                throw new RuntimeException("could not find the proper node to display");
            }
        } else {
            throw new Exception("Unable to display node.");
        }
        EditorUtil.openDefaultEditorInFrame((oracle.ide.model.Node)dataNode);
        bl = true;
        return bl;
    }

    private boolean launchAIViewer(ColumnFilterNode columnFilterNode, Context context) throws Exception {
        boolean bl = false;
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        ColumnFilterNavNode columnFilterNavNode = null;
        columnFilterNavNode = ColumnFilterNavNode.findColumnFilterNode(workflowNode, columnFilterNode.getData().getName());
        if (columnFilterNavNode == null) {
            throw new RuntimeException("could not find the proper node to display");
        }
        EditorUtil.openDefaultEditorInFrame((oracle.ide.model.Node)columnFilterNavNode);
        bl = true;
        return bl;
    }

    private static Object startWorkflow(WorkflowEditor workflowEditor, ProgressRunnable progressRunnable, Node node, boolean bl) throws Exception {
        try {
            WorkflowNode workflowNode = (WorkflowNode)workflowEditor.getContext().getNode();
            Workflow workflow = (Workflow)((WorkflowNode)workflowEditor.getContext().getNode()).getRepositoryData();
            if (workflowNode.isReadOnly()) {
                throw new Exception(WorkflowEditorLrb.get("WORKFLOW_READ_ONLY_RUN_NOT_ALLOWED"));
            }
            progressRunnable.setMessage(WorkflowEditorLrb.get("SAVING_WORKFLOW"));
            if (workflowNode.isDirty()) {
                workflowNode.save();
                workflowNode.markDirty(false);
            }
            workflowEditor.startJobMonitoring();
            AddinManager addinManager = AddinManager.getAddinManager();
            RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
            String string = ConnectionFolder.getConnectionFolder(workflowEditor.getContext()).getConnectionName();
            int n = 0;
            while (!workflowEditor.isJobsListenerInitialized()) {
                Thread.currentThread();
                Thread.sleep(500L);
                if (++n <= 60 || !runManager.isActive(string) || runManager.getListener(workflowEditor, string) == null) continue;
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("START_DELAY_DESCR"), (String)WorkflowEditorLrb.get("START_DELAY"), null)) {
                    throw new Exception("Jobs monitor timed out, aborting run request");
                }
                n = 0;
            }
            progressRunnable.setMessage(WorkflowEditorLrb.get("STARTING_WORKFLOW"));
            workflow.run(workflowNode.getSessionConnection(), node.getData().getId(), workflowNode.getLastSavedOn(), bl);
            workflowEditor.setLockOwner(true);
        }
        catch (Exception exception) {
            workflowEditor.stopJobMonitoring();
            throw exception;
        }
        return true;
    }

    private class LoadSVMModelViewer
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        ModelType _modelType;
        boolean _isLinear = false;
        Context _context = null;
        String _userName = "";
        View _view = null;
        ModelNodeType.Models.Model _model = null;
        TestModelType.Model _testModel = null;
        String _modelName = null;

        public LoadSVMModelViewer(View view, ModelType modelType, String string, Context context) {
            this._modelType = modelType;
            this._modelName = modelType.getName();
            this._context = context;
            this._userName = string;
            this._view = view;
        }

        public LoadSVMModelViewer(View view, ModelNodeType.Models.Model model, String string, Context context) {
            this._model = model;
            this._modelName = model.getName();
            this._context = context;
            this._userName = string;
            this._view = view;
        }

        public LoadSVMModelViewer(View view, TestModelType.Model model, String string, Context context) {
            this._testModel = model;
            this._modelName = model.getName();
            this._context = context;
            this._userName = string;
            this._view = view;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object construct() {
            Connection connection = null;
            try {
                connection = Connections.getUniqueConnection(this._context);
                Model model = new Model();
                Vector<MiningModelSettings> vector = model.getModelSetting(connection, this._userName, this._modelName);
                MiningModelSettings miningModelSettings = MiningModelSettings.findSetting("SVMS_KERNEL_FUNCTION", vector);
                this._isLinear = miningModelSettings != null ? miningModelSettings.getSettingValue().equals("SVMS_LINEAR") : false;
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                exception.printStackTrace();
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return this._isLinear;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void finished() {
            if (this._success && this._ex == null) {
                BaseTreeNode baseTreeNode = null;
                String string = this._modelName;
                try {
                    if (string == null) return;
                    String string2 = WorkflowContextMenu.this.getSelectedDiagramNode(this._view).getData().getName();
                    String string3 = null;
                    if (this._testModel != null) {
                        string3 = this._testModel.getSchema();
                    } else if (this._model != null) {
                        string3 = this._model.getSchema();
                    }
                    baseTreeNode = ModelNodeUtils.findModelNode((WorkflowNode)this._context.getNode(), string2, string3, string);
                    EditorUtil.openDefaultEditorInFrame((oracle.ide.model.Node)baseTreeNode);
                    return;
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_DISPLAY"), null);
                    exception.printStackTrace();
                }
                return;
            } else if (this._ex != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_DISPLAY"), null);
                return;
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), null, (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_DISPLAY"));
            }
        }
    }
}

