/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.dmt.dataminer.workflow.model.ModelNode;
import oracle.dmt.dataminer.workflow.model.TestNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyOutputColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AprioriAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.AprioriModelType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildDataSource;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeRefType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CacheSettings;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FilterDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningData;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningDataType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.KMeansAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.KMeansModelType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.dmt.dataminer.workflow.xmlschema.OClusterAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.OClusterModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RSupportVectorMachineAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.RSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.dmt.dataminer.workflow.xmlschema.RowFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestDataSource;
import oracle.dmt.dataminer.workflow.xmlschema.TestDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.WorkflowProcess;
import oracle.ide.Context;

public class MetaDataHelper {
    public static HashMap<String, List<? extends NodeType>> getNodeCollectionMap(WorkflowProcess workflowProcess) {
        HashMap<String, List<? extends NodeType>> hashMap = new HashMap<String, List<? extends NodeType>>();
        hashMap.put(AggregationNodeType.class.getName(), workflowProcess.getNodes().getAggregation());
        hashMap.put(AnomalyDetectionBuildNodeType.class.getName(), workflowProcess.getNodes().getAnomalyDetectionBuild());
        hashMap.put(ApplyNodeType.class.getName(), workflowProcess.getNodes().getApply());
        hashMap.put(ApplyTextNodeType.class.getName(), workflowProcess.getNodes().getApplyText());
        hashMap.put(AssociationBuildNodeType.class.getName(), workflowProcess.getNodes().getAssociationBuild());
        hashMap.put(ClassificationBuildNodeType.class.getName(), workflowProcess.getNodes().getClassificationBuild());
        hashMap.put(ClusteringBuildNodeType.class.getName(), workflowProcess.getNodes().getClusteringBuild());
        hashMap.put(ColumnFilterNodeType.class.getName(), workflowProcess.getNodes().getColumnFilter());
        hashMap.put(DataProfileNodeType.class.getName(), workflowProcess.getNodes().getDataProfile());
        hashMap.put(DataSourceNodeType.class.getName(), workflowProcess.getNodes().getDataSource());
        hashMap.put(FeatureExtractionBuildNodeType.class.getName(), workflowProcess.getNodes().getFeatureExtractionBuild());
        hashMap.put(FilterDetailsDataNodeType.class.getName(), workflowProcess.getNodes().getFilterDetails());
        hashMap.put(JoinNodeType.class.getName(), workflowProcess.getNodes().getJoin());
        hashMap.put(ModelNodeType.class.getName(), workflowProcess.getNodes().getModel());
        hashMap.put(ModelDetailsDataNodeType.class.getName(), workflowProcess.getNodes().getModelDetails());
        hashMap.put(RegressionBuildNodeType.class.getName(), workflowProcess.getNodes().getRegressionBuild());
        hashMap.put(RowFilterNodeType.class.getName(), workflowProcess.getNodes().getRowFilter());
        hashMap.put(SampleNodeType.class.getName(), workflowProcess.getNodes().getSample());
        hashMap.put(TestNodeType.class.getName(), workflowProcess.getNodes().getTest());
        hashMap.put(TestDetailsDataNodeType.class.getName(), workflowProcess.getNodes().getTestDetails());
        hashMap.put(BuildTextNodeRefType.class.getName(), workflowProcess.getNodes().getBuildTextRef());
        hashMap.put(CreateTableNodeType.class.getName(), workflowProcess.getNodes().getCreateTable());
        hashMap.put(UpdateTableNodeType.class.getName(), workflowProcess.getNodes().getUpdateTable());
        hashMap.put(TransformationNodeType.class.getName(), workflowProcess.getNodes().getTransformation());
        hashMap.put(FeatureExtractionBuildNodeType.class.getName(), workflowProcess.getNodes().getFeatureExtractionBuild());
        hashMap.put(BuildTextNodeType.class.getName(), workflowProcess.getNodes().getBuildText());
        return hashMap;
    }

    public static List<? extends NodeType> getNodeCollection(WorkflowProcess workflowProcess) {
        ArrayList<? extends NodeType> arrayList = new ArrayList<NodeType>();
        HashMap<String, List<? extends NodeType>> hashMap = MetaDataHelper.getNodeCollectionMap(workflowProcess);
        for (List<? extends NodeType> list : hashMap.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static List<StoplistType> getStoplistsCollection(BuildTextNodeType buildTextNodeType) {
        ArrayList<StoplistType> arrayList = new ArrayList<StoplistType>();
        TextNodeType.Stoplists stoplists = buildTextNodeType.getStoplists();
        arrayList.addAll(stoplists.getStoplist());
        return arrayList;
    }

    public static Map<String, StoplistType> getStoplistsCollection(WorkflowProcess workflowProcess) {
        HashMap<String, StoplistType> hashMap = new HashMap<String, StoplistType>();
        List list = workflowProcess.getNodes().getBuildText();
        for (BuildTextNodeType buildTextNodeType : list) {
            TextNodeType.Stoplists stoplists = buildTextNodeType.getStoplists();
            for (StoplistType stoplistType : stoplists.getStoplist()) {
                if (stoplistType.getName().equals("Default")) continue;
                hashMap.put(buildTextNodeType.getName(), stoplistType);
            }
        }
        return hashMap;
    }

    public static Collection<String> getModelNames(BuildNodeType buildNodeType) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ModelType> list = MetaDataHelper.getModelsCollection(buildNodeType);
        for (ModelType modelType : list) {
            arrayList.add(modelType.getName());
        }
        return arrayList;
    }

    public static List<ModelType> getModelsCollection(BuildNodeType buildNodeType) {
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType;
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        if (buildNodeType instanceof ClassificationBuildNodeType) {
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)buildNodeType;
            if (classificationBuildNodeType.getModels() != null) {
                arrayList.addAll(classificationBuildNodeType.getModels().getCGeneralizedLinearModel());
                arrayList.addAll(classificationBuildNodeType.getModels().getCSupportVectorMachineModel());
                arrayList.addAll(classificationBuildNodeType.getModels().getDecisionTreeModel());
                arrayList.addAll(classificationBuildNodeType.getModels().getNaiveBayesModel());
            }
        } else if (buildNodeType instanceof RegressionBuildNodeType) {
            RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)buildNodeType;
            if (regressionBuildNodeType.getModels() != null) {
                arrayList.addAll(regressionBuildNodeType.getModels().getRGeneralizedLinearModel());
                arrayList.addAll(regressionBuildNodeType.getModels().getRSupportVectorMachineModel());
            }
        } else if (buildNodeType instanceof ClusteringBuildNodeType) {
            ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)buildNodeType;
            if (clusteringBuildNodeType.getModels() != null) {
                arrayList.addAll(clusteringBuildNodeType.getModels().getKMeansModel());
                arrayList.addAll(clusteringBuildNodeType.getModels().getOClusterModel());
            }
        } else if (buildNodeType instanceof AssociationBuildNodeType) {
            AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)buildNodeType;
            if (associationBuildNodeType.getModels() != null) {
                arrayList.addAll(associationBuildNodeType.getModels().getAprioriModel());
            }
        } else if (buildNodeType instanceof AnomalyDetectionBuildNodeType) {
            AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)buildNodeType;
            if (anomalyDetectionBuildNodeType.getModels() != null) {
                arrayList.addAll(anomalyDetectionBuildNodeType.getModels().getAnomalyDetectionModel());
            }
        } else if (buildNodeType instanceof FeatureExtractionBuildNodeType && (featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)buildNodeType).getModels() != null) {
            arrayList.addAll(featureExtractionBuildNodeType.getModels().getNonNegativeMatrixFactorModel());
        }
        return arrayList;
    }

    public static List<RefModelType> createRefModelTypeCollection(MiningFunctionType miningFunctionType, List<? extends ModelType> list, String string, String string2) {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        for (ModelType modelType : list) {
            if (!modelType.isUseForOutput()) continue;
            RefModelType refModelType = MetaDataHelper.createRefModelType(modelType, miningFunctionType, string2, string);
            arrayList.add(refModelType);
        }
        return arrayList;
    }

    public static RefModelType createRefModelType(ModelType modelType, MiningFunctionType miningFunctionType, String string, String string2) {
        RefModelType refModelType = new RefModelType();
        refModelType.setName(modelType.getName());
        refModelType.setMiningAlgorithm(MetaDataHelper.getMiningAlgorithmType(miningFunctionType, modelType));
        refModelType.setMiningFunction(miningFunctionType);
        refModelType.setModelId(modelType.getId());
        refModelType.setSchema(string);
        refModelType.setUseForOutput(modelType.isUseForOutput());
        if (modelType.getStatus().equals((Object)ModelStatusType.COMPLETE)) {
            refModelType.setIsModelBuilt(true);
        } else {
            refModelType.setIsModelBuilt(false);
        }
        refModelType.setNodeId(string2);
        refModelType.setStatus(RefModelStatusType.VALID);
        return refModelType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MiningAlgorithmType getMiningAlgorithmType(MiningFunctionType miningFunctionType, ModelType modelType) {
        MiningAlgorithmType miningAlgorithmType = null;
        if (miningFunctionType == MiningFunctionType.CLASSIFICATION) {
            if (modelType instanceof CGeneralizedLinearModelType) {
                return MiningAlgorithmType.GENERALIZED_LINEAR_MODEL;
            }
            if (modelType instanceof CSupportVectorMachineModelType) {
                return MiningAlgorithmType.SUPPORT_VECTOR_MACHINES;
            }
            if (modelType instanceof DecisionTreeModelType) {
                return MiningAlgorithmType.DECISION_TREE;
            }
            if (!(modelType instanceof NaiveBayesModelType)) throw new RuntimeException("Unknown ModelType, please add.");
            return MiningAlgorithmType.NAIVE_BAYES;
        }
        if (miningFunctionType == MiningFunctionType.REGRESSION) {
            if (modelType instanceof RGeneralizedLinearModelType) {
                return MiningAlgorithmType.GENERALIZED_LINEAR_MODEL;
            }
            if (!(modelType instanceof RSupportVectorMachineModelType)) throw new RuntimeException("Unknown ModelType, please add.");
            return MiningAlgorithmType.SUPPORT_VECTOR_MACHINES;
        }
        if (miningFunctionType == MiningFunctionType.CLUSTERING) {
            if (modelType instanceof KMeansModelType) {
                return MiningAlgorithmType.KMEANS;
            }
            if (!(modelType instanceof OClusterModelType)) throw new RuntimeException("Unknown ModelType, please add.");
            return MiningAlgorithmType.O_CLUSTER;
        }
        if (miningFunctionType == MiningFunctionType.ASSOCIATION) {
            if (!(modelType instanceof AprioriModelType)) throw new RuntimeException("Unknown ModelType, please add.");
            return MiningAlgorithmType.APRIORI_ASSOCIATION_RULES;
        }
        if (miningFunctionType == MiningFunctionType.ANOMALY_DETECTION) {
            if (!(modelType instanceof AnomalyDetectionModelType)) throw new RuntimeException("Unknown ModelType, please add.");
            return MiningAlgorithmType.SUPPORT_VECTOR_MACHINES;
        }
        if (miningFunctionType != MiningFunctionType.FEATURE_EXTRACTION) throw new RuntimeException("Unknown MiningFunctionType, please add.");
        if (!(modelType instanceof NonNegativeMatrixFactorModelType)) throw new RuntimeException("Unknown ModelType, please add.");
        return MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR;
    }

    public static MiningFunctionType getMiningFunctionType(BuildNodeType buildNodeType) {
        MiningFunctionType miningFunctionType = null;
        if (buildNodeType instanceof ClassificationBuildNodeType) {
            miningFunctionType = MiningFunctionType.CLASSIFICATION;
        } else if (buildNodeType instanceof RegressionBuildNodeType) {
            miningFunctionType = MiningFunctionType.REGRESSION;
        } else if (buildNodeType instanceof ClusteringBuildNodeType) {
            miningFunctionType = MiningFunctionType.CLUSTERING;
        } else if (buildNodeType instanceof AssociationBuildNodeType) {
            miningFunctionType = MiningFunctionType.ASSOCIATION;
        } else if (buildNodeType instanceof AnomalyDetectionBuildNodeType) {
            miningFunctionType = MiningFunctionType.ANOMALY_DETECTION;
        } else if (buildNodeType instanceof FeatureExtractionBuildNodeType) {
            miningFunctionType = MiningFunctionType.FEATURE_EXTRACTION;
        } else {
            throw new RuntimeException("Unknown BuildNodeType, please add missing type");
        }
        return miningFunctionType;
    }

    public static List<RefModelType> getModelsCollection(BuildNodeType buildNodeType, Context context) throws Exception {
        List<ModelType> list = MetaDataHelper.getModelsCollection(buildNodeType);
        return MetaDataHelper.getModelsCollection(buildNodeType, list, context);
    }

    public static List<RefModelType> getModelsCollection(BuildNodeType buildNodeType, List<ModelType> list, Context context) throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList();
        arrayList = MetaDataHelper.createRefModelTypeCollection(MetaDataHelper.getMiningFunctionType(buildNodeType), list, buildNodeType.getId(), Connections.getUserAccountName(context));
        return arrayList;
    }

    public static List<TestModelType.Model> getModelsCollection(TestNodeType testNodeType) {
        ArrayList<TestModelType.Model> arrayList = new ArrayList<TestModelType.Model>();
        if (testNodeType.getTestModels().getModel().size() > 0) {
            arrayList.addAll(testNodeType.getTestModels().getModel());
        }
        return arrayList;
    }

    public static List<ApplyOutputColumnsType.OutputColumn> getModelsCollection(ApplyNode applyNode) {
        ApplyNodeType applyNodeType;
        NodeType nodeType = applyNode.getData();
        ArrayList<ApplyOutputColumnsType.OutputColumn> arrayList = new ArrayList<ApplyOutputColumnsType.OutputColumn>();
        if (nodeType instanceof ApplyNodeType && (applyNodeType = (ApplyNodeType)nodeType).getOutputColumns() != null) {
            arrayList.addAll(applyNodeType.getOutputColumns().getOutputColumn());
        }
        return arrayList;
    }

    public static List<AttributeType> getSuppAttrsCollection(ApplyNode applyNode) {
        ApplyNodeType applyNodeType;
        NodeType nodeType = applyNode.getData();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        if (nodeType instanceof ApplyNodeType && (applyNodeType = (ApplyNodeType)nodeType).getSupplementalAttributes() != null) {
            arrayList.addAll(applyNodeType.getSupplementalAttributes().getAttribute());
        }
        return arrayList;
    }

    public static List<ClassificationResultType> getClassResultsCollection(AbstractBuildNode abstractBuildNode) {
        ClassificationBuildNodeType classificationBuildNodeType;
        NodeType nodeType = abstractBuildNode.getData();
        ArrayList<ClassificationResultType> arrayList = new ArrayList<ClassificationResultType>();
        if (nodeType instanceof ClassificationBuildNodeType && (classificationBuildNodeType = (ClassificationBuildNodeType)nodeType).getResults() != null) {
            arrayList.addAll(classificationBuildNodeType.getResults().getClassificationResult());
        }
        return arrayList;
    }

    public static List<RegressionResultType> getRegressResultsCollection(AbstractBuildNode abstractBuildNode) {
        RegressionBuildNodeType regressionBuildNodeType;
        NodeType nodeType = abstractBuildNode.getData();
        ArrayList<RegressionResultType> arrayList = new ArrayList<RegressionResultType>();
        if (nodeType instanceof RegressionBuildNodeType && (regressionBuildNodeType = (RegressionBuildNodeType)nodeType).getResults() != null) {
            arrayList.addAll(regressionBuildNodeType.getResults().getRegressionResult());
        }
        return arrayList;
    }

    public static List<? extends MiningResultType> getResultsCollection(SuperviseBuildNodeType superviseBuildNodeType) {
        List list = new ArrayList();
        if (superviseBuildNodeType instanceof ClassificationBuildNodeType) {
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)superviseBuildNodeType;
            ClassificationBuildNodeType.Results results = classificationBuildNodeType.getResults();
            list = results.getClassificationResult();
        } else if (superviseBuildNodeType instanceof RegressionBuildNodeType) {
            RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)superviseBuildNodeType;
            RegressionBuildNodeType.Results results = regressionBuildNodeType.getResults();
            list = results.getRegressionResult();
        }
        return list;
    }

    public static List<? extends MiningResultType> getResultsCollection(SuperviseBuildNodeType superviseBuildNodeType, Collection<? extends ModelType> collection) {
        ArrayList<MiningResultType> arrayList = new ArrayList<MiningResultType>();
        HashMap<String, ModelType> hashMap = new HashMap<String, ModelType>();
        for (ModelType object2 : collection) {
            hashMap.put(object2.getId(), object2);
        }
        List<? extends MiningResultType> list = MetaDataHelper.getResultsCollection(superviseBuildNodeType);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MiningResultType miningResultType = (MiningResultType)iterator.next();
            if (!hashMap.containsKey(miningResultType.getModelId())) continue;
            arrayList.add(miningResultType);
        }
        return arrayList;
    }

    public static List<ClassificationResultType> getClassResultsCollection(TestNode testNode) {
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        ArrayList<ClassificationResultType> arrayList = new ArrayList<ClassificationResultType>();
        if (testNodeType.getResults().getClassificationResult().size() > 0) {
            arrayList.addAll(testNodeType.getResults().getClassificationResult());
        }
        return arrayList;
    }

    public static List<RegressionResultType> getRegressResultsCollection(TestNode testNode) {
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        ArrayList<RegressionResultType> arrayList = new ArrayList<RegressionResultType>();
        if (testNodeType.getResults().getRegressionResult().size() > 0) {
            arrayList.addAll(testNodeType.getResults().getRegressionResult());
        }
        return arrayList;
    }

    public static List<? extends MiningResultType> getResultsCollection(TestNode testNode) {
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        List<Object> list = new ArrayList();
        if (!testNodeType.getTestModels().getModel().isEmpty()) {
            if (testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.CLASSIFICATION)) {
                list = MetaDataHelper.getClassResultsCollection(testNode);
            } else if (testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.REGRESSION)) {
                list = MetaDataHelper.getRegressResultsCollection(testNode);
            }
        }
        return list;
    }

    public static ModelType getModelType(AbstractBuildNode abstractBuildNode, String string) {
        ModelType modelType = null;
        List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        for (ModelType modelType2 : list) {
            if (modelType2.getName().compareTo(string) != 0) continue;
            modelType = modelType2;
            break;
        }
        return modelType;
    }

    public static ModelNodeType.Models.Model getModel(ModelNode modelNode, String string) {
        ModelNodeType.Models.Model model = null;
        List<ModelNodeType.Models.Model> list = MetaDataHelper.getModelsCollection((ModelNodeType)modelNode.getData());
        for (ModelNodeType.Models.Model model2 : list) {
            if (model2.getName().compareTo(string) != 0) continue;
            model = model2;
            break;
        }
        return model;
    }

    public static ModelNodeType.Models.Model getModelUsingId(ModelNode modelNode, String string) {
        ModelNodeType.Models.Model model = null;
        List<ModelNodeType.Models.Model> list = MetaDataHelper.getModelsCollection((ModelNodeType)modelNode.getData());
        for (ModelNodeType.Models.Model model2 : list) {
            if (!model2.getModelId().equals(string)) continue;
            model = model2;
            break;
        }
        return model;
    }

    public static List<ModelNodeType.Models.Model> getModelsCollection(ModelNodeType modelNodeType) {
        ModelNodeType modelNodeType2;
        List list = null;
        if (modelNodeType instanceof ModelNodeType) {
            modelNodeType2 = modelNodeType;
            list = modelNodeType2.getModels().getModel();
        }
        assert (list != null) : "Unknown model node type!";
        modelNodeType2 = list;
        return modelNodeType2;
    }

    public static TestModelType.Model getModel(TestNode testNode, String string) {
        TestModelType.Model model = null;
        List<TestModelType.Model> list = MetaDataHelper.getModelsCollection((TestNodeType)testNode.getData());
        for (TestModelType.Model model2 : list) {
            if (model2.getName().compareTo(string) != 0) continue;
            model = model2;
            break;
        }
        return model;
    }

    public static TestModelType.Model getModelUsingId(TestNode testNode, String string) {
        TestModelType.Model model = null;
        List<TestModelType.Model> list = MetaDataHelper.getModelsCollection((TestNodeType)testNode.getData());
        for (TestModelType.Model model2 : list) {
            if (!model2.getModelId().equals(string)) continue;
            model = model2;
            break;
        }
        return model;
    }

    public static List<ModelType> getModelsCollectionForType(BuildNodeType buildNodeType, ModelType modelType) {
        Object object;
        List list = null;
        if (buildNodeType instanceof ClassificationBuildNodeType) {
            object = (ClassificationBuildNodeType)buildNodeType;
            if (modelType instanceof NaiveBayesModelType) {
                list = object.getModels().getNaiveBayesModel();
            } else if (modelType instanceof DecisionTreeModelType) {
                list = object.getModels().getDecisionTreeModel();
            } else if (modelType instanceof CSupportVectorMachineModelType) {
                list = object.getModels().getCSupportVectorMachineModel();
            } else if (modelType instanceof CGeneralizedLinearModelType) {
                list = object.getModels().getCGeneralizedLinearModel();
            }
        } else if (buildNodeType instanceof RegressionBuildNodeType) {
            object = (RegressionBuildNodeType)buildNodeType;
            if (modelType instanceof RSupportVectorMachineModelType) {
                list = object.getModels().getRSupportVectorMachineModel();
            } else if (modelType instanceof RGeneralizedLinearModelType) {
                list = object.getModels().getRGeneralizedLinearModel();
            }
        } else if (buildNodeType instanceof ClusteringBuildNodeType) {
            object = (ClusteringBuildNodeType)buildNodeType;
            if (modelType instanceof KMeansModelType) {
                list = object.getModels().getKMeansModel();
            } else if (modelType instanceof OClusterModelType) {
                list = object.getModels().getOClusterModel();
            }
        } else if (buildNodeType instanceof AssociationBuildNodeType) {
            object = (AssociationBuildNodeType)buildNodeType;
            list = object.getModels().getAprioriModel();
        } else if (buildNodeType instanceof AnomalyDetectionBuildNodeType) {
            object = (AnomalyDetectionBuildNodeType)buildNodeType;
            list = object.getModels().getAnomalyDetectionModel();
        } else if (buildNodeType instanceof FeatureExtractionBuildNodeType) {
            object = (FeatureExtractionBuildNodeType)buildNodeType;
            list = object.getModels().getNonNegativeMatrixFactorModel();
        }
        assert (list != null) : "Unknown model collection type!";
        object = list;
        return object;
    }

    public static boolean replaceModel(BuildNodeType buildNodeType, ModelType modelType, String string) {
        boolean bl = false;
        List<ModelType> list = MetaDataHelper.getModelsCollectionForType(buildNodeType, modelType);
        ModelType modelType2 = null;
        for (ModelType object : list) {
            if (!object.getName().equals(string)) continue;
            modelType2 = object;
            bl = true;
            break;
        }
        if (bl) {
            if (buildNodeType instanceof SuperviseBuildNodeType) {
                ArrayList arrayList = new ArrayList();
                arrayList.add(modelType2);
                List<? extends MiningResultType> list2 = MetaDataHelper.getResultsCollection((SuperviseBuildNodeType)buildNodeType, arrayList);
                for (MiningResultType miningResultType : list2) {
                    miningResultType.setStatus(ModelStatusType.READY);
                }
            }
            int n = list.indexOf(modelType2);
            list.remove(modelType2);
            modelType.setStatus(ModelStatusType.READY);
            list.add(n, modelType);
        }
        return bl;
    }

    public static boolean removeModel(BuildNodeType buildNodeType, ModelType modelType) {
        boolean bl = true;
        List<ModelType> list = null;
        list = MetaDataHelper.getModelsCollectionForType(buildNodeType, modelType);
        ModelType modelType2 = null;
        for (ModelType modelType3 : list) {
            if (!modelType3.getName().equals(modelType.getName())) continue;
            modelType2 = modelType3;
            break;
        }
        bl = list.remove(modelType2);
        return bl;
    }

    public static boolean removeModel(ModelNodeType modelNodeType, ModelNodeType.Models.Model model) {
        boolean bl = true;
        List<ModelNodeType.Models.Model> list = null;
        list = MetaDataHelper.getModelsCollection(modelNodeType);
        ModelNodeType.Models.Model model2 = null;
        for (ModelNodeType.Models.Model model3 : list) {
            if (!model3.getName().equals(model.getName())) continue;
            model2 = model3;
            break;
        }
        bl = list.remove(model2);
        return bl;
    }

    public static boolean addModel(ModelNodeType modelNodeType, ModelNodeType.Models.Model model) {
        boolean bl = true;
        List<ModelNodeType.Models.Model> list = null;
        list = MetaDataHelper.getModelsCollection(modelNodeType);
        bl = list.add(model);
        return bl;
    }

    public static boolean addModel(BuildNodeType buildNodeType, ModelType modelType) {
        boolean bl = true;
        List<ModelType> list = null;
        list = MetaDataHelper.getModelsCollectionForType(buildNodeType, modelType);
        bl = list.add(modelType);
        return bl;
    }

    public static CSupportVectorMachineModelType createSVMClassificationModel() {
        CSupportVectorMachineAlgoType cSupportVectorMachineAlgoType = new CSupportVectorMachineAlgoType();
        cSupportVectorMachineAlgoType.setSVMSACTIVELEARNING("SVMS_AL_ENABLE");
        cSupportVectorMachineAlgoType.setSVMSCONVTOLERANCE(0.001);
        cSupportVectorMachineAlgoType.setSVMSKERNELCACHESIZE(null);
        cSupportVectorMachineAlgoType.setSVMSKERNELFUNCTION(null);
        CSupportVectorMachineModelType cSupportVectorMachineModelType = new CSupportVectorMachineModelType();
        cSupportVectorMachineModelType.setCSupportVectorMachineAlgo(cSupportVectorMachineAlgoType);
        return cSupportVectorMachineModelType;
    }

    public static CGeneralizedLinearModelType createGLMClassificationModel() {
        CGeneralizedLinearAlgoType cGeneralizedLinearAlgoType = new CGeneralizedLinearAlgoType();
        cGeneralizedLinearAlgoType.setGLMSCONFLEVEL(0.95);
        CGeneralizedLinearModelType cGeneralizedLinearModelType = new CGeneralizedLinearModelType();
        cGeneralizedLinearModelType.setCGeneralizedLinearAlgo(cGeneralizedLinearAlgoType);
        return cGeneralizedLinearModelType;
    }

    public static DecisionTreeModelType createDecisionTreeModel() {
        DecisionTreeAlgoType decisionTreeAlgoType = new DecisionTreeAlgoType();
        decisionTreeAlgoType.setTREEIMPURITYMETRIC("TREE_IMPURITY_GINI");
        decisionTreeAlgoType.setTREETERMMAXDEPTH(7);
        decisionTreeAlgoType.setTREETERMMINPCTNODE(0.05);
        decisionTreeAlgoType.setTREETERMMINPCTSPLIT(0.1);
        decisionTreeAlgoType.setTREETERMMINRECNODE(BigInteger.valueOf(10L));
        decisionTreeAlgoType.setTREETERMMINRECSPLIT(BigInteger.valueOf(20L));
        DecisionTreeModelType decisionTreeModelType = new DecisionTreeModelType();
        decisionTreeModelType.setDecisionTreeAlgo(decisionTreeAlgoType);
        return decisionTreeModelType;
    }

    public static NaiveBayesModelType createNaiveBayesModel() {
        NaiveBayesAlgoType naiveBayesAlgoType = new NaiveBayesAlgoType();
        naiveBayesAlgoType.setNABSPAIRWISETHRESHOLD(0.0);
        naiveBayesAlgoType.setNABSSINGLETONTHRESHOLD(0.0);
        NaiveBayesModelType naiveBayesModelType = new NaiveBayesModelType();
        naiveBayesModelType.setNaiveBayesAlgo(naiveBayesAlgoType);
        return naiveBayesModelType;
    }

    public static RGeneralizedLinearModelType createGLMRegressionModel() {
        RGeneralizedLinearAlgoType rGeneralizedLinearAlgoType = new RGeneralizedLinearAlgoType();
        rGeneralizedLinearAlgoType.setGLMSCONFLEVEL(0.95);
        rGeneralizedLinearAlgoType.setGLMSRIDGEREGRESSION("GLMS_RIDGE_REG_ENABLE");
        RGeneralizedLinearModelType rGeneralizedLinearModelType = new RGeneralizedLinearModelType();
        rGeneralizedLinearModelType.setRGeneralizedLinearModelAlgo(rGeneralizedLinearAlgoType);
        return rGeneralizedLinearModelType;
    }

    public static RSupportVectorMachineModelType createSVMRegressionModel() {
        RSupportVectorMachineAlgoType rSupportVectorMachineAlgoType = new RSupportVectorMachineAlgoType();
        rSupportVectorMachineAlgoType.setSVMSACTIVELEARNING("SVMS_AL_ENABLE");
        rSupportVectorMachineAlgoType.setSVMSCONVTOLERANCE(0.001);
        rSupportVectorMachineAlgoType.setSVMSKERNELCACHESIZE(null);
        rSupportVectorMachineAlgoType.setSVMSKERNELFUNCTION(null);
        RSupportVectorMachineModelType rSupportVectorMachineModelType = new RSupportVectorMachineModelType();
        rSupportVectorMachineModelType.setRSupportVectorMachineAlgo(rSupportVectorMachineAlgoType);
        return rSupportVectorMachineModelType;
    }

    public static AnomalyDetectionModelType createSVMAnomalyModel() {
        AnomalyDetectionAlgoType anomalyDetectionAlgoType = new AnomalyDetectionAlgoType();
        anomalyDetectionAlgoType.setSVMSACTIVELEARNING("SVMS_AL_ENABLE");
        anomalyDetectionAlgoType.setSVMSCONVTOLERANCE(0.001);
        anomalyDetectionAlgoType.setSVMSKERNELCACHESIZE(null);
        anomalyDetectionAlgoType.setSVMSKERNELFUNCTION(null);
        anomalyDetectionAlgoType.setSVMSOUTLIERRATE(Double.valueOf(0.1));
        AnomalyDetectionModelType anomalyDetectionModelType = new AnomalyDetectionModelType();
        anomalyDetectionModelType.setAnomalyDetectionAlgo(anomalyDetectionAlgoType);
        return anomalyDetectionModelType;
    }

    public static KMeansModelType createKMeansModel() {
        KMeansAlgoType kMeansAlgoType = new KMeansAlgoType();
        kMeansAlgoType.setCLUSNUMCLUSTERS(BigInteger.valueOf(10L));
        kMeansAlgoType.setKMNSBLOCKGROWTH(2);
        kMeansAlgoType.setKMNSCONVTOLERANCE(0.01);
        kMeansAlgoType.setKMNSDISTANCE("KMNS_EUCLIDEAN");
        kMeansAlgoType.setKMNSITERATIONS(3);
        kMeansAlgoType.setKMNSMINPCTATTRSUPPORT(0.1);
        kMeansAlgoType.setKMNSNUMBINS(BigInteger.valueOf(10L));
        kMeansAlgoType.setKMNSSPLITCRITERION("KMNS_VARIANCE");
        KMeansModelType kMeansModelType = new KMeansModelType();
        kMeansModelType.setKMeansAlgo(kMeansAlgoType);
        return kMeansModelType;
    }

    public static OClusterModelType createOClusterModel() {
        OClusterAlgoType oClusterAlgoType = new OClusterAlgoType();
        oClusterAlgoType.setCLUSNUMCLUSTERS(BigInteger.valueOf(10L));
        oClusterAlgoType.setOCLTMAXBUFFER(50000.0);
        oClusterAlgoType.setOCLTSENSITIVITY(0.5);
        OClusterModelType oClusterModelType = new OClusterModelType();
        oClusterModelType.setOClusterAlgo(oClusterAlgoType);
        return oClusterModelType;
    }

    public static NonNegativeMatrixFactorModelType createNMFModel() {
        NonNegativeMatrixFactorAlgoType nonNegativeMatrixFactorAlgoType = new NonNegativeMatrixFactorAlgoType();
        nonNegativeMatrixFactorAlgoType.setNMFSCONVTOLERANCE(0.05);
        nonNegativeMatrixFactorAlgoType.setNMFSNUMITERATIONS(50);
        nonNegativeMatrixFactorAlgoType.setNMFSRANDOMSEED(BigInteger.valueOf(-1L));
        NonNegativeMatrixFactorModelType nonNegativeMatrixFactorModelType = new NonNegativeMatrixFactorModelType();
        nonNegativeMatrixFactorModelType.setNonNegativeMatrixFactorAlgo(nonNegativeMatrixFactorAlgoType);
        return nonNegativeMatrixFactorModelType;
    }

    public static AprioriModelType createAprioriModel() {
        AprioriAlgoType aprioriAlgoType = new AprioriAlgoType();
        aprioriAlgoType.setASSOMAXRULELENGTH(4);
        aprioriAlgoType.setASSOMINCONFIDENCE(0.1);
        aprioriAlgoType.setASSOMINSUPPORT(0.01);
        AprioriModelType aprioriModelType = new AprioriModelType();
        aprioriModelType.setAprioriAlgo(aprioriAlgoType);
        return aprioriModelType;
    }

    public static BigDecimal getObjectId(ModelType modelType) {
        return new BigDecimal(modelType.getId());
    }

    public static List<MiningAttributeType> getMiningAttributes(ModelType modelType) {
        InputMiningData inputMiningData = modelType.getInputMiningData();
        return inputMiningData.getMiningAttributes().getMiningAttribute();
    }

    public static MiningAttributeType findModelAttribute(MiningAttributeType miningAttributeType, ModelType modelType) {
        MiningAttributeType miningAttributeType2 = null;
        InputMiningData inputMiningData = modelType.getInputMiningData();
        List list = inputMiningData.getMiningAttributes().getMiningAttribute();
        for (MiningAttributeType miningAttributeType3 : list) {
            if (!miningAttributeType3.getName().equals(miningAttributeType.getName()) || !miningAttributeType3.getDataType().equals(miningAttributeType.getDataType())) continue;
            miningAttributeType2 = miningAttributeType3;
            break;
        }
        return miningAttributeType2;
    }

    public static MiningAttributeType findModelAttribute(AttributeType attributeType, ModelType modelType) {
        MiningAttributeType miningAttributeType = null;
        InputMiningData inputMiningData = modelType.getInputMiningData();
        List list = inputMiningData.getMiningAttributes().getMiningAttribute();
        for (MiningAttributeType miningAttributeType2 : list) {
            if (!miningAttributeType2.getName().equals(attributeType.getName()) || !miningAttributeType2.getDataType().equals(attributeType.getDataType())) continue;
            miningAttributeType = miningAttributeType2;
            break;
        }
        return miningAttributeType;
    }

    public static MiningAttributeType findModelAttribute(String string, ModelType modelType) {
        MiningAttributeType miningAttributeType = null;
        InputMiningData inputMiningData = modelType.getInputMiningData();
        List list = inputMiningData.getMiningAttributes().getMiningAttribute();
        for (MiningAttributeType miningAttributeType2 : list) {
            if (!miningAttributeType2.getName().equals(string)) continue;
            miningAttributeType = miningAttributeType2;
            break;
        }
        return miningAttributeType;
    }

    public static AttributeType getCaseId(BuildNodeType buildNodeType) {
        AttributeType attributeType = null;
        if (buildNodeType.getCaseAttributes().getAttribute().size() > 0) {
            attributeType = (AttributeType)buildNodeType.getCaseAttributes().getAttribute().get(0);
        }
        return attributeType;
    }

    public static void setMiningAttributeOptions(BuildNodeType buildNodeType, AttributeType attributeType, boolean bl, boolean bl2) {
        List<ModelType> list = MetaDataHelper.getModelsCollection(buildNodeType);
        for (ModelType modelType : list) {
            MiningAttributeType miningAttributeType = MetaDataHelper.findModelAttribute(attributeType, modelType);
            if (miningAttributeType == null) continue;
            miningAttributeType.setAutoPrep(bl2 ? "Yes" : "No");
            miningAttributeType.setInput(bl ? "Yes" : "No");
        }
    }

    public static void setMiningTargetOptionsUsingDefaults(BuildNodeType buildNodeType, AttributeType attributeType) {
        List<ModelType> list = MetaDataHelper.getModelsCollection(buildNodeType);
        for (ModelType modelType : list) {
            MiningAttributeType miningAttributeType;
            boolean bl = false;
            if (buildNodeType instanceof RegressionBuildNodeType && modelType instanceof RSupportVectorMachineModelType || buildNodeType instanceof ClassificationBuildNodeType) {
                bl = true;
            }
            if ((miningAttributeType = MetaDataHelper.findModelAttribute(attributeType, modelType)) == null) continue;
            miningAttributeType.setAutoPrep(bl ? "Yes" : "No");
            miningAttributeType.setInput("Yes");
        }
    }

    @Deprecated
    public static MiningAttributeType addAttributeToModel(ModelType modelType, MiningAttributeType miningAttributeType) {
        MiningAttributeType miningAttributeType2 = (MiningAttributeType)MetaDataHelper.copyMetadataObject(miningAttributeType);
        InputMiningData inputMiningData = modelType.getInputMiningData();
        List list = inputMiningData.getMiningAttributes().getMiningAttribute();
        list.add(miningAttributeType2);
        return miningAttributeType2;
    }

    @Deprecated
    public static boolean removeAttributeFromModel(ModelType modelType, MiningAttributeType miningAttributeType) {
        InputMiningData inputMiningData = modelType.getInputMiningData();
        List list = inputMiningData.getMiningAttributes().getMiningAttribute();
        return list.remove(miningAttributeType);
    }

    public static boolean isAutomatic(ModelType modelType) {
        InputMiningData inputMiningData = modelType.getInputMiningData();
        return inputMiningData.getDataUsage().equals((Object)InputMiningDataType.AUTO);
    }

    public static boolean isAutomaticMiningType(ModelType modelType) {
        InputMiningData inputMiningData = modelType.getInputMiningData();
        return inputMiningData.getMiningUsage().equals((Object)InputMiningDataType.AUTO);
    }

    public static boolean isEqual(AttributeType attributeType, AttributeType attributeType2) {
        if (attributeType == null && attributeType2 == null) {
            return true;
        }
        if (attributeType == null || attributeType2 == null) {
            return false;
        }
        if (!attributeType.getName().equals(attributeType2.getName())) {
            return false;
        }
        if (attributeType.getAlias() != null && attributeType2.getAlias() != null && !attributeType.getAlias().equals(attributeType2.getAlias())) {
            return false;
        }
        return attributeType.getDataType().equals(attributeType2.getDataType());
    }

    public static boolean isEqual(CaseAttributes caseAttributes, CaseAttributes caseAttributes2) {
        List list = caseAttributes.getAttribute();
        List list2 = caseAttributes2.getAttribute();
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (MetaDataHelper.isEqual((AttributeType)list.get(i), (AttributeType)list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualTargetAndCaseID(BuildNodeType buildNodeType, BuildNodeType buildNodeType2) {
        CaseAttributes caseAttributes;
        CaseAttributes caseAttributes2;
        if (buildNodeType instanceof SuperviseBuildNodeType && !MetaDataHelper.isEqual((AttributeType)(caseAttributes2 = ((SuperviseBuildNodeType)buildNodeType).getTargetAttribute()), (AttributeType)(caseAttributes = ((SuperviseBuildNodeType)buildNodeType2).getTargetAttribute()))) {
            return false;
        }
        caseAttributes2 = buildNodeType.getCaseAttributes();
        return MetaDataHelper.isEqual(caseAttributes2, caseAttributes = buildNodeType2.getCaseAttributes());
    }

    public static boolean isEqualAssociationSettings(BuildNodeType buildNodeType, BuildNodeType buildNodeType2) {
        assert (buildNodeType instanceof AssociationBuildNodeType);
        assert (buildNodeType2 instanceof AssociationBuildNodeType);
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)buildNodeType;
        AssociationBuildNodeType associationBuildNodeType2 = (AssociationBuildNodeType)buildNodeType2;
        if (!MetaDataHelper.isEqual(associationBuildNodeType.getItemValue(), associationBuildNodeType2.getItemValue())) {
            return false;
        }
        return MetaDataHelper.isEqual(associationBuildNodeType.getItemID(), associationBuildNodeType2.getItemID());
    }

    public static void setModelsStatus(BuildNodeType buildNodeType, Collection<ModelType> collection, ModelStatusType modelStatusType) {
        for (ModelType object : collection) {
            object.setStatus(modelStatusType);
        }
        if (buildNodeType instanceof SuperviseBuildNodeType) {
            List<? extends MiningResultType> list = MetaDataHelper.getResultsCollection((SuperviseBuildNodeType)buildNodeType, collection);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MiningResultType miningResultType = (MiningResultType)iterator.next();
                miningResultType.setStatus(modelStatusType);
            }
        }
    }

    public static void setModelsStatus(BuildNodeType buildNodeType, ModelStatusType modelStatusType) {
        List<ModelType> list = MetaDataHelper.getModelsCollection(buildNodeType);
        MetaDataHelper.setModelsStatus(buildNodeType, list, modelStatusType);
    }

    public static String getFunctionName(MiningFunctionType miningFunctionType) {
        if (miningFunctionType == MiningFunctionType.ASSOCIATION) {
            return ServerConstants.MiningFunction.getUIFunctionName("ASSOCIATION");
        }
        if (miningFunctionType == MiningFunctionType.CLASSIFICATION) {
            return ServerConstants.MiningFunction.getUIFunctionName("CLASSIFICATION");
        }
        if (miningFunctionType == MiningFunctionType.CLUSTERING) {
            return ServerConstants.MiningFunction.getUIFunctionName("CLUSTERING");
        }
        if (miningFunctionType == MiningFunctionType.FEATURE_EXTRACTION) {
            return ServerConstants.MiningFunction.getUIFunctionName("FEATURE_EXTRACTION");
        }
        if (miningFunctionType == MiningFunctionType.REGRESSION) {
            return ServerConstants.MiningFunction.getUIFunctionName("REGRESSION");
        }
        if (miningFunctionType == MiningFunctionType.ANOMALY_DETECTION) {
            return ServerConstants.MiningFunction.getUIFunctionName("ANOMALY_DETECTION");
        }
        return null;
    }

    public static String getAlgorithmName(MiningAlgorithmType miningAlgorithmType) {
        if (miningAlgorithmType == MiningAlgorithmType.NAIVE_BAYES) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_NAIVE_BAYES");
        }
        if (miningAlgorithmType == MiningAlgorithmType.DECISION_TREE) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_DECISION_TREE");
        }
        if (miningAlgorithmType == MiningAlgorithmType.SUPPORT_VECTOR_MACHINES) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_SUPPORT_VECTOR_MACHINES");
        }
        if (miningAlgorithmType == MiningAlgorithmType.GENERALIZED_LINEAR_MODEL) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_GENERALIZED_LINEAR_MODEL");
        }
        if (miningAlgorithmType == MiningAlgorithmType.APRIORI_ASSOCIATION_RULES) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_APRIORI_ASSOCIATION_RULES");
        }
        if (miningAlgorithmType == MiningAlgorithmType.KMEANS) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_KMEANS");
        }
        if (miningAlgorithmType == MiningAlgorithmType.O_CLUSTER) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_O_CLUSTER");
        }
        if (miningAlgorithmType == MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_NONNEGATIVE_MATRIX_FACTOR");
        }
        return null;
    }

    public static String getAlgorithmName(ModelType modelType) {
        if (modelType instanceof NaiveBayesModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_NAIVE_BAYES");
        }
        if (modelType instanceof DecisionTreeModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_DECISION_TREE");
        }
        if (modelType instanceof CSupportVectorMachineModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_SUPPORT_VECTOR_MACHINES");
        }
        if (modelType instanceof CGeneralizedLinearModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_GENERALIZED_LINEAR_MODEL");
        }
        if (modelType instanceof RGeneralizedLinearModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_GENERALIZED_LINEAR_MODEL");
        }
        if (modelType instanceof RSupportVectorMachineModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_SUPPORT_VECTOR_MACHINES");
        }
        if (modelType instanceof KMeansModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_KMEANS");
        }
        if (modelType instanceof OClusterModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_O_CLUSTER");
        }
        if (modelType instanceof AprioriModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_APRIORI_ASSOCIATION_RULES");
        }
        if (modelType instanceof AnomalyDetectionModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_SUPPORT_VECTOR_MACHINES");
        }
        if (modelType instanceof NonNegativeMatrixFactorModelType) {
            return ServerConstants.Algorithm.getUIAlgorithmName("ALGO_NONNEGATIVE_MATRIX_FACTOR");
        }
        return null;
    }

    public static String getAlgorithmType(ModelType modelType) {
        if (modelType instanceof NaiveBayesModelType) {
            return "ALGO_NAIVE_BAYES";
        }
        if (modelType instanceof DecisionTreeModelType) {
            return "ALGO_DECISION_TREE";
        }
        if (modelType instanceof CSupportVectorMachineModelType) {
            return "ALGO_SUPPORT_VECTOR_MACHINES";
        }
        if (modelType instanceof CGeneralizedLinearModelType) {
            return "ALGO_GENERALIZED_LINEAR_MODEL";
        }
        if (modelType instanceof RGeneralizedLinearModelType) {
            return "ALGO_GENERALIZED_LINEAR_MODEL";
        }
        if (modelType instanceof RSupportVectorMachineModelType) {
            return "ALGO_SUPPORT_VECTOR_MACHINES";
        }
        if (modelType instanceof KMeansModelType) {
            return "ALGO_KMEANS";
        }
        if (modelType instanceof OClusterModelType) {
            return "ALGO_O_CLUSTER";
        }
        if (modelType instanceof AprioriModelType) {
            return "ALGO_APRIORI_ASSOCIATION_RULES";
        }
        if (modelType instanceof AnomalyDetectionModelType) {
            return "ALGO_SUPPORT_VECTOR_MACHINES";
        }
        if (modelType instanceof NonNegativeMatrixFactorModelType) {
            return "ALGO_NONNEGATIVE_MATRIX_FACTOR";
        }
        return null;
    }

    public static MiningAttributes copyMiningAttributes(MiningAttributes miningAttributes) {
        MiningAttributes miningAttributes2 = new MiningAttributes();
        List list = miningAttributes.getMiningAttribute();
        List list2 = miningAttributes2.getMiningAttribute();
        for (MiningAttributeType miningAttributeType : list) {
            MiningAttributeType miningAttributeType2 = (MiningAttributeType)MetaDataHelper.copyMetadataObject(miningAttributeType);
            list2.add(miningAttributeType2);
        }
        return miningAttributes2;
    }

    public static BuildDataSource copyBuildDataSource(BuildDataSource buildDataSource) {
        BuildDataSource buildDataSource2 = new BuildDataSource();
        buildDataSource2.setSourceId(buildDataSource.getSourceId());
        return buildDataSource2;
    }

    public static CacheSettings copyCacheSettings(CacheSettings cacheSettings) {
        CacheSettings cacheSettings2 = new CacheSettings();
        cacheSettings2.setNumberOfRows(cacheSettings.getNumberOfRows());
        cacheSettings2.setPercentOfTotal(cacheSettings.getPercentOfTotal());
        CacheSettings.Method method = cacheSettings.getMethod();
        CacheSettings.Method method2 = new CacheSettings.Method();
        if (null != method.getRandom()) {
            CacheSettings.Method.Random random = new CacheSettings.Method.Random();
            random.setSeed(method.getRandom().getSeed());
            method2.setRandom(random);
        } else if (null != method.getStratified()) {
            CacheSettings.Method.Stratified stratified = new CacheSettings.Method.Stratified();
            stratified.setTargetAttr(method.getStratified().getTargetAttr());
            method2.setStratified(stratified);
        } else if (null != method.getTopN()) {
            CacheSettings.Method.TopN topN = new CacheSettings.Method.TopN();
            method2.setTopN(topN);
        }
        cacheSettings2.setMethod(method2);
        cacheSettings2.setGenerateCache(cacheSettings.isGenerateCache());
        cacheSettings2.setUseFullData(Boolean.valueOf(cacheSettings.isUseFullData()));
        cacheSettings2.setOutputTable(cacheSettings.getOutputTable());
        return cacheSettings2;
    }

    public static TestDataSource copyTestDataSource(TestDataSource testDataSource) {
        TestDataSource testDataSource2 = new TestDataSource();
        testDataSource2.setBuildData(testDataSource.getBuildData());
        testDataSource2.setNone(testDataSource.getNone());
        testDataSource2.setSplitData(MetaDataHelper.copySplitData(testDataSource.getSplitData()));
        testDataSource2.setTestData(MetaDataHelper.copyTestData(testDataSource.getTestData()));
        return testDataSource2;
    }

    private static TestDataSource.TestData copyTestData(TestDataSource.TestData testData) {
        if (testData == null) {
            return null;
        }
        TestDataSource.TestData testData2 = new TestDataSource.TestData();
        testData2.setSourceId(testData.getSourceId());
        return testData2;
    }

    private static TestDataSource.SplitData copySplitData(TestDataSource.SplitData splitData) {
        if (splitData == null) {
            return null;
        }
        TestDataSource.SplitData splitData2 = new TestDataSource.SplitData();
        splitData2.setTestPercent(splitData.getTestPercent());
        return splitData2;
    }

    public static MiningAttributeType createMiningAttributeFrom(AttributeType attributeType) {
        MiningAttributeType miningAttributeType = new MiningAttributeType();
        miningAttributeType.setName(attributeType.getName());
        miningAttributeType.setAlias(attributeType.getAlias());
        miningAttributeType.setAutoPrep(attributeType instanceof MiningAttributeType ? ((MiningAttributeType)attributeType).getAutoPrep() : "Yes");
        miningAttributeType.setInput(attributeType instanceof MiningAttributeType ? ((MiningAttributeType)attributeType).getInput() : "Yes");
        miningAttributeType.setDataType(attributeType.getDataType());
        miningAttributeType.setStatus(attributeType.getStatus());
        miningAttributeType.setMiningType(DatabaseMetadataUtils.getDefaultMiningType(attributeType.getDataType()));
        return miningAttributeType;
    }

    public static AttributeType createAttributeFrom(MiningAttributeType miningAttributeType) {
        AttributeType attributeType = new AttributeType();
        attributeType.setDataType(miningAttributeType.getDataType());
        attributeType.setName(miningAttributeType.getName());
        attributeType.setStatus(miningAttributeType.getStatus());
        return attributeType;
    }

    public static Object copyMetadataObject(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = Workflow.createMarshaller();
            marshaller.marshal((Object)new JAXBElement(new QName(" ", "local"), Object.class, object), (Writer)stringWriter);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            String string = stringBuffer.toString();
            StringReader stringReader = new StringReader(string);
            Unmarshaller unmarshaller = Workflow.createUnmarshaller();
            JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal((Source)new StreamSource(stringReader));
            object2 = jAXBElement.getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (object2 instanceof ModelType) {
            ((ModelType)object2).setStatus(ModelStatusType.READY);
        }
        return object2;
    }

    public static ModelNodeType.Models.Model findModelByName(ModelNodeType modelNodeType, String string) {
        List list = modelNodeType.getModels().getModel();
        ModelNodeType.Models.Model model = null;
        for (ModelNodeType.Models.Model model2 : list) {
            String string2 = model2.getSchema() + "." + model2.getName();
            if (!string2.equals(string)) continue;
            model = model2;
            break;
        }
        return model;
    }

    public static ModelType findModelById(BuildNodeType buildNodeType, String string) {
        List<ModelType> list = MetaDataHelper.getModelsCollection(buildNodeType);
        ModelType modelType = null;
        for (ModelType modelType2 : list) {
            if (!modelType2.getId().equals(string)) continue;
            modelType = modelType2;
            break;
        }
        return modelType;
    }

    public static RefModelType getModelRefFromId(BuildNodeType buildNodeType, String string, Context context) throws Exception {
        RefModelType refModelType = null;
        List<ModelType> list = MetaDataHelper.getModelsCollection(buildNodeType);
        for (ModelType modelType : list) {
            if (!modelType.getId().equals(string)) continue;
            refModelType = MetaDataHelper.createRefModelType(modelType, MetaDataHelper.getMiningFunctionType(buildNodeType), Connections.getUserAccountName(context), buildNodeType.getId());
            break;
        }
        return refModelType;
    }

    public static MiningResultType findResultById(SuperviseBuildNodeType superviseBuildNodeType, String string) {
        List<? extends MiningResultType> list = MetaDataHelper.getResultsCollection(superviseBuildNodeType);
        MiningResultType miningResultType = null;
        for (MiningResultType miningResultType2 : list) {
            if (!miningResultType2.getModelId().equals(string)) continue;
            miningResultType = miningResultType2;
            break;
        }
        return miningResultType;
    }
}

