/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.wizard.workflow;

import java.awt.Component;
import java.awt.Dimension;
import java.sql.Connection;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.navigator.BaseDeferredFilter;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.ProjectFolderFilter;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.wizard.workflow.WorkflowDialogState;
import oracle.dmt.dataminer.wizard.workflow.WorkflowLrb;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;

public class WorkflowPanel
extends JPanel
implements DataminerGUIPanel {
    private Context _context;
    private WorkflowDialogState _state;
    private boolean _editMode = false;
    private JTextField _jName;
    private JLabel _jNameLabel;

    public WorkflowPanel(Context context, WorkflowDialogState workflowDialogState) {
        this.initComponents();
        this._context = context;
        this._state = workflowDialogState;
        this._editMode = workflowDialogState.isWorkflowModelEditMode();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jNameLabel = new JLabel();
        this._jName = new JTextField();
        this.setMinimumSize(new Dimension(330, 50));
        this.setPreferredSize(new Dimension(330, 50));
        this._jNameLabel.setDisplayedMnemonic('N');
        this._jNameLabel.setLabelFor(this._jName);
        this._jNameLabel.setText("Name:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._jNameLabel, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jName, -1, 300, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jNameLabel).addComponent(this._jName, -2, -1, -2)).addContainerGap()));
        this._jName.getAccessibleContext().setAccessibleDescription("Project name");
    }

    @Override
    public void initUI() {
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jNameLabel, (Component)this._jName, (String)WorkflowLrb.get("CREATE_WORKFLOW_NAME"));
        this._jNameLabel.getAccessibleContext().setAccessibleDescription(WorkflowLrb.get("CREATE_WORKFLOW_NAME_ADA"));
        this._jNameLabel.getAccessibleContext().setAccessibleName(WorkflowLrb.get("CREATE_WORKFLOW_NAME"));
        this._jName.getAccessibleContext().setAccessibleDescription(WorkflowLrb.get("CREATE_WORKFLOW_NAME_ADA"));
        this._jName.getAccessibleContext().setAccessibleName(WorkflowLrb.get("CREATE_WORKFLOW_NAME"));
        this._jName.setDocument(new TextFieldLimit(30));
    }

    public boolean validateAndWriteToState(WorkflowDialogState workflowDialogState) {
        final WorkflowDialogState workflowDialogState2 = workflowDialogState;
        boolean bl = false;
        try {
            class ValidateWriteThread
            extends ProgressRunnable {
                boolean validated = true;
                private boolean _canceled = false;
                private Workflow _workflowObj = null;
                private String workflowName;

                ValidateWriteThread() {
                }

                public boolean getValidation() {
                    return this.validated;
                }

                public Workflow getWorkflowObj() {
                    return this._workflowObj;
                }

                protected Object doWork() throws Exception {
                    Connection connection = null;
                    boolean bl = false;
                    try {
                        connection = Connections.getSharedConnection(WorkflowPanel.this._context);
                        this.workflowName = WorkflowPanel.this._jName.getText();
                        this.workflowName = this.workflowName.trim();
                        if (WorkflowPanel.this._editMode && WorkflowPanel.this._state.getName().equals(this.workflowName)) {
                            bl = true;
                        }
                        if (!bl && !Workflow.validateWorkflowName(connection, this.workflowName, WorkflowPanel.this._context)) {
                            this.validated = false;
                        }
                        if (!this.validated) {
                            return this.validated;
                        }
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_TITLE"), (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_MESG"), null);
                    }
                    try {
                        if (this.validated) {
                            workflowDialogState2.setName(this.getProjectName());
                            this._workflowObj = workflowDialogState2.finish();
                        }
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_TITLE"), (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_MESG"), null);
                    }
                    return this.validated;
                }

                protected void finish(Object object) {
                }

                protected void doCancel() {
                    super.doCancel();
                    this._canceled = true;
                }

                public boolean isCanceled() {
                    return this._canceled;
                }

                public String getProjectName() {
                    return this.workflowName;
                }
            }
            ValidateWriteThread validateWriteThread = new ValidateWriteThread();
            if (this._editMode) {
                validateWriteThread.setTitle(WorkflowLrb.get("WIZARD_CREATING_WORKFLOW_TITLE"));
                validateWriteThread.setMessage(WorkflowLrb.get("WIZARD_CREATING_WORKFLOW_MESG"));
            } else {
                validateWriteThread.setTitle(WorkflowLrb.get("WIZARD_EDITING_WORKFLOW_TITLE"));
                validateWriteThread.setMessage(WorkflowLrb.get("WIZARD_EDITING_WORKFLOW_MESG"));
            }
            validateWriteThread.setCancelable(false);
            validateWriteThread.start(true);
            bl = validateWriteThread.getValidation();
            if (!bl) {
                return bl;
            }
            Workflow workflow = validateWriteThread.getWorkflowObj();
            if (!this._editMode) {
                if (workflow == null) {
                    return false;
                }
                BaseTreeNode baseTreeNode = (BaseTreeNode)this._context.getElement();
                TreeExplorer treeExplorer = ((NavigatorWindow)this._context.getView()).getTreeExplorer();
                TNode tNode = this.findProjectFolder(treeExplorer, baseTreeNode, this._context);
                WorkflowNode workflowNode = this.createWorkflowNode(tNode, workflow);
                this.addWorkflowNode(this._context, workflowNode);
            }
        }
        catch (Exception exception) {
            if (this._editMode) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowLrb.get("EDIT_WORKFLOW_FAILURE_TITLE"), (String)WorkflowLrb.get("EDIT_WORKFLOW_FAILURE_MESG"), null);
            }
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_TITLE"), (String)WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_MESG"), null);
        }
        return bl;
    }

    public void initializeFromState(WorkflowDialogState workflowDialogState) {
        this._jName.setText(workflowDialogState.getName());
    }

    private WorkflowNode createWorkflowNode(TNode tNode, Workflow workflow) {
        ProjectFolder projectFolder = (ProjectFolder)tNode.getData();
        WorkflowNode workflowNode = ProjectFolderFilter.getWorkflowNode(projectFolder.getURL().getPath() + "/" + workflow.getName(), true);
        workflowNode.setRepositoryData(workflow);
        workflowNode.setId(workflow.getId());
        workflowNode.setParent(tNode);
        return workflowNode;
    }

    private TNode findProjectFolder(TreeExplorer treeExplorer, BaseTreeNode baseTreeNode, Context context) {
        TNode tNode = null;
        TNode tNode2 = null;
        if (!(baseTreeNode instanceof ConnectionFolder)) {
            if (baseTreeNode instanceof ProjectFolder) {
                tNode = treeExplorer.searchTNode((Element)baseTreeNode, treeExplorer.getRoot(), context);
                tNode2 = tNode.getAncestorTNode(ProjectFolder.class, false);
                assert (tNode2 != null) : "Did not find TNode for ConnectionFolder!";
            } else {
                tNode2 = baseTreeNode.getParent();
            }
        } else {
            tNode2 = treeExplorer.searchTNode((Element)baseTreeNode, baseTreeNode.getParent(), context);
        }
        BaseDeferredFilter.getChildTreeNodes(tNode2);
        return tNode2;
    }

    private void addWorkflowNode(Context context, WorkflowNode workflowNode) {
        ProjectFolder projectFolder = ProjectFolder.getProjectFolder(this._context);
        projectFolder.add((Element)workflowNode, true);
        projectFolder.markDirty(false);
        workflowNode.selectAndOpen(context);
    }
}

