/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.wizard.project;

import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.WorkflowProject;
import oracle.dmt.dataminer.wizard.project.ProjectLrb;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.dialogs.MessageDialog;

public class ProjectModel {
    private Context _context;
    private String _name;
    private String _comment;
    private boolean _editMode = false;
    private WorkflowProject _projectState = null;

    public ProjectModel(Context context) {
        this._context = context;
        this._editMode = false;
        this.loadDefaults();
    }

    public ProjectModel(Context context, WorkflowProject workflowProject) throws Exception {
        this._context = context;
        this._editMode = true;
        this._projectState = workflowProject;
        this.loadProject();
    }

    private void loadProject() throws Exception {
        if (!this._projectState.isLoaded()) {
            this.loadProjectStateFromDB();
        }
        this._name = this._projectState.getName();
        this._comment = this._projectState.getComment();
    }

    private void loadProjectStateFromDB() throws Exception {
        final Connection connection = Connections.getSharedConnection(this._context);
        class Loader
        extends ProgressRunnable {
            private boolean _canceled;

            Loader() {
            }

            protected Object doWork() throws Exception {
                ProjectModel.this._projectState.load(connection);
                return ProjectModel.this._projectState;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this._canceled = true;
            }

            public boolean isCanceled() {
                return this._canceled;
            }
        }
        Loader loader = new Loader();
        loader.setTitle(ProjectLrb.get("RETRIEVING_PROJECT"));
        loader.setMessage(ProjectLrb.get("RETRIEVING_PROJECT_DETAILS"));
        loader.setCancelable(false);
        try {
            loader.start(true);
        }
        catch (ProgressException progressException) {
            progressException.printStackTrace();
            throw progressException;
        }
    }

    public boolean isProjectModelEditMode() {
        return this._editMode;
    }

    public static boolean validateProjectComment(Connection connection, String string) {
        boolean bl = true;
        String string2 = "";
        if (!WorkflowProject.validateCommentLength(string)) {
            bl = false;
            string2 = MessageFormat.format(ProjectLrb.get("COMMENT_TOO_LONG"), Integer.toString(4000));
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)ProjectLrb.get("CREATE_PROJECT_ERROR_COMMENT"), null);
        } else if (!WorkflowProject.validateCommentLengthAtDB(connection, string)) {
            bl = false;
            string2 = MessageFormat.format(ProjectLrb.get("COMMENT_TOO_LONG_BYTES"), Integer.toString(4000));
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)ProjectLrb.get("CREATE_PROJECT_ERROR_COMMENT"), null);
        }
        return bl;
    }

    public static boolean validateProjectName(Connection connection, String string) {
        boolean bl = true;
        String string2 = "";
        try {
            if (string.length() == 0) {
                bl = false;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)ProjectLrb.get("PROJECT_NAME_EMPTY"), (String)ProjectLrb.get("CREATE_PROJECT_ERROR_NAME"), null);
            } else if (!WorkflowProject.validateProjectNameLength(string)) {
                bl = false;
                string2 = MessageFormat.format(ProjectLrb.get("PROJECT_NAME_TOO_LONG"), Integer.toString(30));
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)ProjectLrb.get("CREATE_PROJECT_ERROR_NAME"), null);
            } else if (!WorkflowProject.validateProjectNameHasNoSlash(string)) {
                bl = false;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)ProjectLrb.get("PROJECT_NAME_CONTAINS_SLASH"), (String)ProjectLrb.get("CREATE_PROJECT_ERROR_NAME"), null);
            } else if (!WorkflowProject.validateProjectNameUnique(connection, string)) {
                bl = false;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)ProjectLrb.get("PROJECT_NAME_NOT_UNIQUE"), (String)ProjectLrb.get("CREATE_PROJECT_ERROR_NAME"), null);
            } else if (!WorkflowProject.validateProjectNameLengthAtDB(connection, string)) {
                bl = false;
                string2 = MessageFormat.format(ProjectLrb.get("PROJECT_NAME_TOO_LONG_BYTES"), Integer.toString(30));
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)ProjectLrb.get("CREATE_PROJECT_ERROR_NAME"), null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private WorkflowProject finishCreate() throws Exception {
        Connection connection = null;
        BigDecimal bigDecimal = null;
        WorkflowProject workflowProject = null;
        connection = Connections.getSharedConnection(this._context);
        bigDecimal = WorkflowProject.createProject(connection, this.getName(), this.getComment());
        if (bigDecimal != null) {
            workflowProject = new WorkflowProject(this.getName(), bigDecimal, null);
        }
        return workflowProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkflowProject finishEdit() throws Exception {
        Connection connection = null;
        try {
            connection = Connections.getSharedConnection(this._context);
            if (!this._projectState.getComment().equals(this._comment)) {
                this._projectState.setComment(connection, this._comment);
                this._projectState.setComment(this._comment);
            }
        }
        finally {
            try {
                if (this._projectState != null) {
                    this._projectState.unload();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this._projectState;
    }

    public WorkflowProject finish() throws Exception {
        if (!this._editMode) {
            return this.finishCreate();
        }
        return this.finishEdit();
    }

    private void loadDefaults() {
        this._name = this.loadDefaultName();
        this._comment = "";
    }

    private String loadDefaultName() {
        Connection connection = null;
        String string = ProjectLrb.get("PROJECT_DEFAULT_NAME");
        String string2 = "";
        try {
            connection = Connections.getSharedConnection(this._context);
            string2 = WorkflowProject.createUniqueProjectName(connection, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public String getName() {
        return this._name.toString();
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getComment() {
        return this._comment == null ? "" : this._comment.toString();
    }

    public void setComment(String string) {
        this._comment = string;
    }

    public Context getContext() {
        return this._context;
    }
}

