/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;

public class SQLHelper {
    public PreparedStatement pstmt;
    public OraclePreparedStatement opstmt;
    public CallableStatement cstmt;
    public Statement stmt;
    public ResultSet rs;
    public OracleResultSet ors;
    public String message;
    public boolean success;
    public static final String COMMA = ",";
    public static final String DOT = ".";
    public String owner;
    public static final String JOIN_LEFT_OUTER = " LEFT OUTER JOIN ";
    public static final String JOIN_RIGHT_OUTER = " RIGHT OUTER JOIN ";
    public static final String JOIN = " JOIN ";

    public void close() {
        if (null != this.rs) {
            try {
                this.rs.close();
                this.rs = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != this.ors) {
            try {
                this.ors.close();
                this.ors = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != this.stmt) {
            try {
                this.stmt.close();
                this.stmt = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != this.pstmt) {
            try {
                this.pstmt.close();
                this.pstmt = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != this.opstmt) {
            try {
                this.opstmt.close();
                this.opstmt = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != this.cstmt) {
            try {
                this.pstmt.close();
                this.pstmt = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String buildSimpleQuery(String[] stringArray, String[] stringArray2, String string) {
        assert (stringArray != null && stringArray.length >= 0) : "Columns array cannot be null";
        assert (stringArray2 != null && stringArray2.length >= 0) : "Tables array cannot be null";
        if (string != null) assert (string.length() > 0) : "Where clause cannot be empty";
        StringBuffer stringBuffer = SQLHelper.formatSelectClause(stringArray);
        stringBuffer.append(SQLHelper.formatFromClause(stringArray2));
        if (string != null) {
            stringBuffer.append("\nwhere " + string);
        }
        return stringBuffer.toString();
    }

    public static String buildSimpleAliasQuery(String[] stringArray, String[] stringArray2, String[] stringArray3, String string) {
        assert (stringArray != null && stringArray.length >= 0) : "Columns array cannot be null";
        assert (stringArray3 != null && stringArray3.length >= 0) : "Tables array cannot be null";
        if (string != null) assert (string.length() > 0) : "Where clause cannot be empty";
        StringBuffer stringBuffer = SQLHelper.formatSelectClauseAlias(stringArray, stringArray2);
        stringBuffer.append(SQLHelper.formatFromClause(stringArray3));
        if (string != null) {
            stringBuffer.append("\nwhere " + string);
        }
        return stringBuffer.toString();
    }

    public static StringBuffer formatSelectClauseAlias(String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer("select " + (AbstractDataNode.generateSQLInlineHint() ? "/*+ inline */ " : ""));
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (stringArray2[i] != null && stringArray2[i].trim().length() > 0) {
                stringBuffer.append(" AS ");
                stringBuffer.append(stringArray2[i]);
            }
            if (i == stringArray.length - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append(", ");
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer formatQuery(StringBuffer stringBuffer, StringBuffer stringBuffer2, String string) {
        stringBuffer.insert(0, "select " + (AbstractDataNode.generateSQLInlineHint() ? "/*+ inline */ " : ""));
        stringBuffer2.insert(0, "\n from ");
        return stringBuffer.append(stringBuffer2.append(string != null ? "\n where " + string.toString() : ""));
    }

    public static StringBuffer formatSelectClause(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("select " + (AbstractDataNode.generateSQLInlineHint() ? "/*+ inline */ " : ""));
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i == stringArray.length - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append(", ");
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer formatFromClause(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("\nfrom ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i == stringArray.length - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append(", ");
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer formatJoinFromClause(String string, String string2, String string3, String string4) {
        return new StringBuffer("\n from " + string + string3 + string2).append(" ON " + string4);
    }

    public static String buildSimpleQuery(String[] stringArray, String[] stringArray2) {
        return SQLHelper.buildSimpleQuery(stringArray, stringArray2, null);
    }

    public static String[] delimit(String[] stringArray, String string) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(SQLHelper.delimit(stringArray[i], string));
        }
        String[] stringArray2 = new String[]{};
        return vector.toArray(stringArray2);
    }

    public static String delimit(String string, String string2) {
        return "\"" + string2 + "\"" + DOT + "\"" + string + "\"";
    }

    public static String delimitTable(String string, String string2) {
        return "\"" + string + "\".\"" + string2 + "\"";
    }

    public static String[] combine(String[] stringArray, String[] stringArray2) {
        Vector<String> vector = new Vector<String>();
        for (String string : stringArray) {
            vector.add(string);
        }
        for (String string : stringArray2) {
            vector.add(string);
        }
        String[] stringArray3 = new String[]{};
        return vector.toArray(stringArray3);
    }
}

