/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;

public class NumericFormat {
    public static final int CONFIDENCE_MAX_FRACTION = 10;
    public static final int CONFIDENCE_MIN_FRACTION = 4;
    public static final int SUPPORT_MAX_FRACTION = 10;
    public static final int SUPPORT_MIN_FRACTION = 4;
    public static final int COEFICIENT_MAX_FRACTION = 8;
    public static final int COEFICIENT_MIN_FRACTION = 1;
    public static final int COEFICIENT_MIN_INTEGER = 0;
    public static final int BIAS_MAX_FRACTION = 8;
    public static final int BIAS_MIN_FRACTION = 8;
    public static final int RANK_MAX_FRACTION = 10;
    public static final int RANK_MIN_FRACTION = 10;
    public static final int HIGH_RES_MAX_FRACTION = 10;
    public static final int HIGH_RES_MIN_FRACTION = 10;
    public static final int MED_RES_MAX_FRACTION = 8;
    public static final int MED_RES_MIN_FRACTION = 8;
    public static final int LOW_RES_MAX_FRACTION = 4;
    public static final int LOW_RES_MIN_FRACTION = 4;
    public static final int VLOW_RES_MAX_FRACTION = 2;
    public static final int VLOW_RES_MIN_FRACTION = 2;
    public static final int COEFFICIENT_MAX_FRACTION = 10;
    public static final int COEFFICIENT_MIN_FRACTION = 10;
    public static final int PROBABILITY_MAX_FRACTION = 10;
    public static final int PROBABILITY_MIN_FRACTION = 10;
    public static final int OUTLIER_STDEV_MAX_FRACTION = 5;
    private static final NumberFormat _defaultFormatter = DecimalFormat.getNumberInstance();

    public static NumberFormat getInstance() {
        return _defaultFormatter;
    }

    public static NumberFormat getInstance(boolean bl, int n) {
        NumberFormat numberFormat = DecimalFormat.getNumberInstance();
        numberFormat.setGroupingUsed(bl);
        numberFormat.setMaximumFractionDigits(n);
        numberFormat.setMinimumFractionDigits(0);
        return numberFormat;
    }

    public static NumberFormat getInstance(boolean bl) {
        NumberFormat numberFormat = DecimalFormat.getNumberInstance();
        numberFormat.setGroupingUsed(bl);
        numberFormat.setMinimumFractionDigits(0);
        return numberFormat;
    }

    public static NumberFormat getInstance(boolean bl, int n, int n2) {
        NumberFormat numberFormat = NumericFormat.getInstance(bl, n);
        numberFormat.setMinimumFractionDigits(n2);
        return numberFormat;
    }

    public static NumberFormat getInstance(boolean bl, int n, int n2, int n3) {
        NumberFormat numberFormat = NumericFormat.getInstance(bl, n);
        numberFormat.setMinimumFractionDigits(n2);
        numberFormat.setMinimumIntegerDigits(n3);
        return numberFormat;
    }

    public static String format(double d) {
        return _defaultFormatter.format(d);
    }

    public static String format(double d, DecimalFormat decimalFormat) {
        return decimalFormat.format(d);
    }

    public static String format(Double d) {
        return NumericFormat.format((double)d);
    }

    public static String format(int n) {
        return _defaultFormatter.format(n);
    }

    public static String format(double d, boolean bl, int n) {
        NumberFormat numberFormat = NumericFormat.getInstance(bl, n);
        return numberFormat.format(d);
    }

    public static String format(double d, boolean bl, int n, int n2, int n3) {
        NumberFormat numberFormat = NumericFormat.getInstance(bl, n, n2, n3);
        return numberFormat.format(d);
    }

    public static String format(double d, boolean bl, int n, int n2) {
        NumberFormat numberFormat = NumericFormat.getInstance(bl, n, n2);
        return numberFormat.format(d);
    }

    public static String format(int n, boolean bl, int n2) {
        NumberFormat numberFormat = NumericFormat.getInstance(bl, n2);
        return numberFormat.format(n);
    }

    public static String format(int n, boolean bl, int n2, int n3) {
        NumberFormat numberFormat = NumericFormat.getInstance(bl, n2, n3);
        return numberFormat.format(n);
    }

    public static String SQLFormat(Double d) {
        return NumericFormat.SQLFormat((double)d);
    }

    public static synchronized String SQLFormat(double d) {
        DecimalFormat decimalFormat = (DecimalFormat)_defaultFormatter;
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        char c = decimalFormatSymbols.getDecimalSeparator();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        boolean bl = decimalFormat.isGroupingUsed();
        decimalFormat.setGroupingUsed(false);
        String string = decimalFormat.format(d);
        decimalFormat.setGroupingUsed(bl);
        decimalFormatSymbols.setDecimalSeparator(c);
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        return string;
    }

    public static synchronized void AdjustFormat(double d, double d2, DecimalFormat decimalFormat) {
        int n = decimalFormat.getMaximumFractionDigits();
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        char c = decimalFormatSymbols.getDecimalSeparator();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        boolean bl = decimalFormat.isGroupingUsed();
        decimalFormat.setGroupingUsed(false);
        String string = null;
        String string2 = null;
        boolean bl2 = false;
        do {
            string = decimalFormat.format(d);
            string2 = decimalFormat.format(d2);
            if (d != d2) {
                if (0 == string.compareTo(string2)) {
                    decimalFormat.setMinimumFractionDigits(++n);
                    bl2 = true;
                    continue;
                }
                bl2 = false;
                continue;
            }
            bl2 = false;
        } while (n < 20 && bl2);
        decimalFormat.setGroupingUsed(bl);
        decimalFormatSymbols.setDecimalSeparator(c);
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
    }

    public static synchronized String[] SQLFormat(double d, double d2, DecimalFormat decimalFormat) {
        int n = decimalFormat.getMaximumFractionDigits();
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        char c = decimalFormatSymbols.getDecimalSeparator();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        boolean bl = decimalFormat.isGroupingUsed();
        decimalFormat.setGroupingUsed(false);
        String string = null;
        String string2 = null;
        boolean bl2 = false;
        do {
            string = decimalFormat.format(d);
            string2 = decimalFormat.format(d2);
            if (d != d2) {
                if (0 == string.compareTo(string2)) {
                    decimalFormat.setMinimumFractionDigits(++n);
                    bl2 = true;
                    continue;
                }
                bl2 = false;
                continue;
            }
            bl2 = false;
        } while (bl2);
        decimalFormat.setGroupingUsed(bl);
        decimalFormatSymbols.setDecimalSeparator(c);
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        return new String[]{string, string2};
    }

    public static synchronized String SQLFormat(double d, DecimalFormat decimalFormat) {
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        char c = decimalFormatSymbols.getDecimalSeparator();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        boolean bl = decimalFormat.isGroupingUsed();
        decimalFormat.setGroupingUsed(false);
        String string = decimalFormat.format(d);
        decimalFormat.setGroupingUsed(bl);
        decimalFormatSymbols.setDecimalSeparator(c);
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        return string;
    }

    static {
        _defaultFormatter.setGroupingUsed(true);
        _defaultFormatter.setMaximumFractionDigits(2);
        _defaultFormatter.setMinimumFractionDigits(0);
    }
}

