/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.awt.Component;
import java.awt.Window;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.ide.extension.Extension;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.utils.ConfigurationSettingsDialog;
import oracle.dmt.dataminer.utils.ConfigurationWorkerDialog;
import oracle.dmt.dataminer.utils.ExceptionHelper;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UtilsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.util.Version;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public final class ConfigUtils {
    private static final Version CURRENT_WF_SCHEMA_IN_CLIENT = new Version("11.2.1.1.1");
    private static final Version KNOWN_RELEASE_COMPATIBLE = new Version("11.2.1.1.6");
    private static final Version[] KNOWN_RELEASES_REQUIRE_UPGRADE = new Version[]{new Version("11.2.0.1.9"), new Version("11.2.0.1.10"), new Version("11.2.0.1.11"), new Version("11.2.0.1.12"), new Version("11.2.0.1.13"), new Version("11.2.1.1.1"), new Version("11.2.1.1.2"), new Version("11.2.1.1.3"), new Version("11.2.1.1.4"), new Version("11.2.1.1.5")};
    private static final Version[] KNOWN_RELEASES_REQUIRE_MIGRATION = new Version[0];
    private static final Version[] KNOWN_ALPHA_RELEASES = new Version[]{new Version("11.2.0.1.0"), new Version("11.2.0.1.1"), new Version("11.2.0.1.2"), new Version("11.2.0.1.3"), new Version("11.2.0.1.4"), new Version("11.2.0.1.5"), new Version("11.2.0.1.6"), new Version("11.2.0.1.7"), new Version("11.2.0.1.8")};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getDatabaseVersion(Connection connection) throws Exception {
        Version version = null;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string = "SELECT VERSION FROM PRODUCT_COMPONENT_VERSION WHERE PRODUCT like 'Oracle Database 1%'";
            sQLHelper.stmt = connection.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string);
            if (sQLHelper.rs.next()) {
                String string2 = sQLHelper.rs.getString("VERSION");
                version = new Version(string2);
            }
        }
        finally {
            sQLHelper.close();
        }
        return version;
    }

    public static boolean isCompatibleDatabase(Connection connection) throws Exception {
        Version version = ConfigUtils.getDatabaseVersion(connection);
        if (version == null) {
            return false;
        }
        return version.toCanonicalString().startsWith("11.2") || version.toCanonicalString().startsWith("12.");
    }

    public static boolean isCompatibleXmlSchemaVersion(Connection connection, Version version) throws Exception {
        Version version2 = ConfigUtils.getXmlSchemaVersion(connection);
        if (version.toCanonicalString().startsWith("11.2.0.1.9")) {
            return true;
        }
        if (version2.toCanonicalString().startsWith("11.2.0.1.9") && version.toCanonicalString().startsWith("11.2.1.1.1")) {
            return true;
        }
        if (version2.toCanonicalString().startsWith("11.2.1.1.1") && (version.toCanonicalString().startsWith("11.2.0.1.9") || version.toCanonicalString().startsWith("11.2.1.1.1"))) {
            return true;
        }
        return version2.toCanonicalString().startsWith("11.2.1.1.2") && (version.toCanonicalString().startsWith("11.2.0.1.9") || version.toCanonicalString().startsWith("11.2.1.1.1") || version.toCanonicalString().startsWith("11.2.1.1.2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDataMiningOptionInstalled(Connection connection) throws Exception {
        boolean bl = false;
        String string = "select value from v$option where parameter = 'Data Mining'";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string2;
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next() && (string2 = sQLHelper.rs.getString(1)) != null && string2.equalsIgnoreCase("TRUE")) {
                bl = true;
            }
        }
        finally {
            sQLHelper.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDataMinerSchemaInstalled(Connection connection) throws Exception {
        boolean bl = false;
        String string = "select OWNER from ALL_XML_SCHEMAS where SCHEMA_URL like '%odmr.xsd'";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next() && sQLHelper.rs.getString(1) != null) {
                bl = true;
            }
        }
        finally {
            sQLHelper.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextAndXMLDBState isTextAndXMLDBInstalled(Connection connection) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        TextAndXMLDBState textAndXMLDBState = null;
        String string = "select username from ALL_USERS\nwhere username in ('XDB','CTXSYS')";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            String string2 = "";
            while (sQLHelper.rs.next()) {
                string2 = sQLHelper.rs.getString(1);
                if (string2.compareTo("XDB") == 0) {
                    bl2 = true;
                    continue;
                }
                if (string2.compareTo("CTXSYS") != 0) continue;
                bl = true;
            }
            textAndXMLDBState = bl2 && bl ? TextAndXMLDBState.BOTH : (!bl2 && !bl ? TextAndXMLDBState.NONE : (bl2 && !bl ? TextAndXMLDBState.XML_DB_ONLY : (!bl2 && bl ? TextAndXMLDBState.TEXT_ONLY : TextAndXMLDBState.NONE)));
        }
        finally {
            sQLHelper.close();
        }
        return textAndXMLDBState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isODMPrivsPresent(Connection connection) throws Exception {
        boolean bl = false;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string = "SELECT COUNT (DISTINCT (\n  CASE\n    WHEN privilege = 'ODMRUSER' THEN 'ODMRUSER'\n    ELSE NULL\n  END)) PRIVILEGE FROM (\n          SELECT ROLE AS PRIVILEGE FROM (         select role as ROLE from role_role_privs\n         UNION\n         select granted_role as ROLE from role_role_privs         UNION\n         select granted_role as ROLE from user_role_privs )         ROLES_QUERY \n      WHERE ROLE IN ('ODMRUSER'))";
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next() && sQLHelper.rs.getInt(1) == 1) {
                bl = true;
            }
        }
        finally {
            sQLHelper.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> isODMUserPrivsPresent(Connection connection) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string = "select OWNER, TABLE_NAME from (\nselect 'ODMRSYS' OWNER, 'AGGREGATION_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'ANOMALY_BUILD_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'APPLYTEXT_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'APPLY_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'ASSOC_BUILD_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'BUILDTEXT_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'BUILDTEXT_REF_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'CLASS_BUILD_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'CLEANUP_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'CLUST_BUILD_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'COLUMNFILTER_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'CREATETABLE_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'DATAPROFILE_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'DATASOURCE_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'FEATURE_BUILD_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'FILTERDETAILS_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'JOIN_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'MODELDETAILS_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'MODEL_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'ODMR_ENGINE_TEXT' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'REGRESS_BUILD_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'ROWFILTER_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'SAMPLE_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'START_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'SUBFLOW_CLEANUP_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'SUBFLOW_START_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'TEST_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'TEXT_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'TRANSFORMATIONS_PROG' TABLE_NAME from dual\nUNION\nselect 'ODMRSYS' OWNER, 'UPDATETABLE_PROG' TABLE_NAME from dual\nUNION\nselect 'CTXSYS' OWNER, 'CTX_DDL' TABLE_NAME from dual)\nMINUS\nselect OWNER, TABLE_NAME from user_tab_privs where grantor = 'ODMRSYS' OR grantor = 'CTXSYS'\n";
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                arrayList.add(sQLHelper.rs.getString("OWNER") + "." + sQLHelper.rs.getString("TABLE_NAME"));
            }
        }
        finally {
            sQLHelper.close();
        }
        return arrayList;
    }

    public static Boolean isValidUserConnection(String string) throws ConnectionException {
        Boolean bl = true;
        Properties properties = DatabaseConnections.getInstance().getProperties(string);
        Properties properties2 = (Properties)properties.clone();
        String string2 = (String)properties2.get("role");
        String string3 = (String)properties2.get("user");
        if (string2 != null && string2.equalsIgnoreCase("SYSDBA") || string3.equalsIgnoreCase("ODMRSYS")) {
            bl = false;
        }
        return bl;
    }

    public static Version getClientVersion() {
        Extension extension = ExtensionRegistry.getExtensionRegistry().findExtension("oracle.dmt.dataminer");
        int[] nArray = extension.getVersion().toIntArray();
        return new Version(nArray);
    }

    public static String getCurrentRepositoryVersion() {
        return KNOWN_RELEASE_COMPATIBLE.toString();
    }

    public static String getCurrentXMLSchemaInClient() {
        return CURRENT_WF_SCHEMA_IN_CLIENT.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getReposVersion(Connection connection) throws Exception {
        Version version = null;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string = "SELECT PROPERTY_STR_VALUE FROM ODMR_REPOSITORY_PROPERTIES WHERE PROPERTY_NAME='VERSION'";
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                String string2 = sQLHelper.rs.getString(1);
                version = new Version(string2);
            }
        }
        finally {
            sQLHelper.close();
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getXmlSchemaVersion(Connection connection) throws Exception {
        Version version = null;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string = "SELECT PROPERTY_STR_VALUE FROM ODMR_REPOSITORY_PROPERTIES WHERE PROPERTY_NAME='WF_VERSION'";
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                String string2 = sQLHelper.rs.getString(1);
                if (string2 == null) {
                    string2 = "11.2.0.1.9";
                }
                version = new Version(string2);
            } else {
                version = new Version("11.2.0.1.9");
            }
        }
        finally {
            sQLHelper.close();
        }
        return version;
    }

    public static boolean configureConnection(Context context, String string, RunMode runMode) {
        Object object;
        Object object2;
        if (context != null && !(context.getNode() instanceof ConnectionFolder)) {
            throw new RuntimeException("Unexpected Node Type");
        }
        if (context != null) {
            object2 = (ConnectionFolder)context.getNode();
            try {
                ((ConnectionFolder)object2).disconnect();
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
                return false;
            }
        }
        object2 = null;
        if (runMode == RunMode.GRANTS) {
            object = ConfigUtils.getSysConnection(string);
            if (object == null) {
                return false;
            }
            object2 = new ConfigurationWorkerDialog((Connection)object, string, runMode, null, null, context);
        } else if (runMode == RunMode.INSTALLSCHEMA) {
            object = new ConfigurationSettingsDialog(context);
            if (!((ConfigurationSettingsDialog)object).invoke()) {
                return false;
            }
            object2 = new ConfigurationWorkerDialog(((ConfigurationSettingsDialog)object).getConnection(), string, runMode, ((ConfigurationSettingsDialog)object).getDefaultTablespaceName(), ((ConfigurationSettingsDialog)object).getDefaultTempTablespaceName(), context);
        } else if (runMode == RunMode.UPGRADE_REPOS || runMode == RunMode.DROP_REPOS || runMode == RunMode.MIGRATE_REPOS) {
            object = ConfigUtils.getSysConnection(string);
            if (object == null) {
                return false;
            }
            if (!ConfigUtils.areWorkflowsInactive((Connection)object)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("WORKFLOWS_ARE_NOT_ALL_INACTIVE"), (String)UtilsLrb.get("WIZARD_TITLE"), null);
                return false;
            }
            try {
                List<DBSessionInfo> list = ConfigUtils.getSessionsRequiringDisconnect((Connection)object);
                if (!list.isEmpty()) {
                    DBSessionInfo dBSessionInfo2;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("username:module:program:type:sid:serial:status\n\n");
                    for (DBSessionInfo dBSessionInfo2 : list) {
                        stringBuffer.append(dBSessionInfo2.getUserName() + ":" + dBSessionInfo2.getModule() + ":" + dBSessionInfo2.getProgram() + ":" + dBSessionInfo2.getType() + ":" + dBSessionInfo2.getSid() + ":" + dBSessionInfo2.getSerial() + ":" + dBSessionInfo2.getStatus() + "\n");
                    }
                    DetailDialog detailDialog = DetailDialog.createDetailDialog((Component)Ide.getMainWindow(), (String)UtilsLrb.get("WIZARD_TITLE"), (int)19);
                    dBSessionInfo2 = new MessagePanel();
                    dBSessionInfo2.setMessageText(UtilsLrb.get("SESSIONS_MUST_BE_DISCONNECTED"));
                    dBSessionInfo2.setMessageType(4);
                    JTextArea jTextArea = new JTextArea();
                    jTextArea.setText(stringBuffer.toString());
                    JScrollPane jScrollPane = new JScrollPane(jTextArea);
                    detailDialog.setContent((Component)((Object)dBSessionInfo2));
                    detailDialog.setDetailContent((Component)jScrollPane);
                    jTextArea.setCaretPosition(0);
                    detailDialog.setDetailsButtonEnabled(true);
                    detailDialog.setButtonTextWhenDetailsShown(UtilsLrb.get("SESSION_DETAILS") + " <<", true);
                    detailDialog.setButtonTextWhenDetailsHidden(UtilsLrb.get("SESSION_DETAILS") + " >>", true);
                    detailDialog.setDetailVisible(true);
                    if (!detailDialog.runDialog()) {
                        return false;
                    }
                }
            }
            catch (Exception exception) {
                ExceptionHelper.displayException(exception);
                return false;
            }
            object2 = new ConfigurationWorkerDialog((Connection)object, string, runMode, null, null, context);
        }
        boolean bl = ((ConfigurationWorkerDialog)object2).getResult();
        return bl;
    }

    private static Connection getSysConnection(String string) {
        Connection connection = null;
        try {
            connection = ConnectionFolder.getSYSDBAConnection(string, "SYS");
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_TITLE"), (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_MSG"), null);
        }
        return connection;
    }

    public static boolean dbHasSchema(Connection connection, String string) {
        boolean bl = false;
        if (connection == null) {
            return bl;
        }
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement("select username from  dba_users where username = '" + string + "'");
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                bl = true;
            }
            sQLHelper.close();
        }
        catch (Exception exception) {
            sQLHelper.close();
        }
        return bl;
    }

    public static boolean isODMRSYSLoaded(Connection connection) {
        boolean bl = false;
        if (connection == null) {
            throw new RuntimeException("Null connection not expected");
        }
        String string = "SELECT PROPERTY_STR_VALUE FROM ODMR_REPOSITORY_PROPERTIES WHERE PROPERTY_NAME = 'REPOSITORY_STATUS' AND PROPERTY_STR_VALUE = 'LOADED'";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                bl = true;
            }
            sQLHelper.close();
        }
        catch (Exception exception) {
            sQLHelper.close();
        }
        return bl;
    }

    public static boolean isODMRSYSNotLoaded(Connection connection) {
        boolean bl = false;
        if (connection == null) {
            throw new RuntimeException("Null connection not expected");
        }
        String string = "SELECT PROPERTY_STR_VALUE FROM ODMR_REPOSITORY_PROPERTIES WHERE PROPERTY_NAME = 'REPOSITORY_STATUS' AND PROPERTY_STR_VALUE = 'NOT_LOADED'";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                bl = true;
            }
            sQLHelper.close();
        }
        catch (Exception exception) {
            sQLHelper.close();
        }
        return bl;
    }

    public static boolean areWorkflowsInactive(Connection connection) {
        boolean bl = false;
        if (connection == null) {
            throw new RuntimeException("Null connection not expected");
        }
        String string = "SELECT count(*) WORKFLOWS_NOT_INACTIVE from \"ODMRSYS\".\"ODMR$WORKFLOWS\" where status not in ('INACTIVE','STOPPED','STOPPING')";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            int n = 0;
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            sQLHelper.rs.next();
            n = sQLHelper.rs.getInt("WORKFLOWS_NOT_INACTIVE");
            bl = n == 0;
            sQLHelper.close();
        }
        catch (Exception exception) {
            int n = 0;
            if (exception instanceof SQLException && (n = ((SQLException)exception).getErrorCode()) == 942) {
                bl = true;
            }
            sQLHelper.close();
        }
        return bl;
    }

    public static boolean setODMRSYSStatus(Connection connection, String string) {
        boolean bl = false;
        if (connection == null) {
            return bl;
        }
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string2 = "UPDATE ODMRSYS.ODMR$REPOSITORY_PROPERTIES\n   SET PROPERTY_STR_VALUE = '" + string + "' " + "   WHERE PROPERTY_NAME = 'REPOSITORY_STATUS'";
            sQLHelper.pstmt = connection.prepareStatement(string2);
            int n = sQLHelper.pstmt.executeUpdate(string2);
            if (n == 1) {
                bl = true;
            }
            sQLHelper.close();
        }
        catch (Exception exception) {
            sQLHelper.close();
        }
        return bl;
    }

    public static List<DBSessionInfo> getSessionsRequiringDisconnect(Connection connection) throws Exception {
        ArrayList<DBSessionInfo> arrayList = new ArrayList<DBSessionInfo>();
        if (connection == null) {
            return arrayList;
        }
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string = "select v.sid, v.serial#, v.username, v.status, v.program, v.type , v.module from v$session v, dba_role_privs r\nwhere v.type = 'USER'\nAND v.username not in ('SYS', 'sys', 'SYSTEM', 'system')\nAND v.username = r.grantee\nAND r.granted_role = 'ODMRUSER'\nUNION \nselect v.sid, v.serial#, v.username, v.status, v.program, v.type , v.module from v$session v\nwhere v.type = 'USER'\nand v.username = 'ODMRSYS'";
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                DBSessionInfo dBSessionInfo = new DBSessionInfo(sQLHelper.rs.getString("USERNAME"), sQLHelper.rs.getString("STATUS"), sQLHelper.rs.getString("TYPE"), sQLHelper.rs.getString("PROGRAM"), sQLHelper.rs.getString("MODULE"), new Integer(sQLHelper.rs.getInt("SID")), new Integer(sQLHelper.rs.getInt("SERIAL#")));
                arrayList.add(dBSessionInfo);
            }
            sQLHelper.close();
        }
        catch (Exception exception) {
            sQLHelper.close();
            throw exception;
        }
        return arrayList;
    }

    public static boolean setDBRestricted(Connection connection, boolean bl) {
        boolean bl2 = false;
        if (connection == null) {
            return bl2;
        }
        SQLHelper sQLHelper = new SQLHelper();
        try {
            String string = bl ? "alter system enable restricted session" : "alter system disable restricted session";
            sQLHelper.pstmt = connection.prepareStatement(string);
            int n = sQLHelper.pstmt.executeUpdate(string);
            if (n == 0) {
                bl2 = true;
            }
            sQLHelper.close();
        }
        catch (Exception exception) {
            sQLHelper.close();
        }
        return bl2;
    }

    public static Boolean isReleaseWithNoMigration(Version version) {
        Version version2;
        Boolean bl = Boolean.FALSE;
        int[] nArray = version.toIntArray();
        if (nArray.length > 5) {
            int[] nArray2 = Arrays.copyOf(nArray, 5);
            version2 = new Version(nArray2);
        } else {
            version2 = version;
        }
        for (int i = 0; i < KNOWN_RELEASES_REQUIRE_UPGRADE.length; ++i) {
            if (!version2.equals((Object)KNOWN_RELEASES_REQUIRE_UPGRADE[i])) continue;
            bl = Boolean.TRUE;
            break;
        }
        return bl;
    }

    public static Boolean isAlphaRelease(Version version) {
        Version version2;
        Boolean bl = Boolean.FALSE;
        int[] nArray = version.toIntArray();
        if (nArray.length > 5) {
            int[] nArray2 = Arrays.copyOf(nArray, 5);
            version2 = new Version(nArray2);
        } else {
            version2 = version;
        }
        for (int i = 0; i < KNOWN_ALPHA_RELEASES.length; ++i) {
            if (!version2.equals((Object)KNOWN_ALPHA_RELEASES[i])) continue;
            bl = Boolean.TRUE;
            break;
        }
        return bl;
    }

    public static class DBSessionInfo {
        String _userName;
        String _status;
        String _type;
        String _program;
        String _module;
        Integer _sid;
        Integer _serial;

        public DBSessionInfo(String string, String string2, String string3, String string4, String string5, Integer n, Integer n2) {
            this._userName = string;
            this._status = string2;
            this._type = string3;
            this._program = string4;
            this._module = string5;
            this._sid = n;
            this._serial = n2;
        }

        public String getUserName() {
            return this._userName;
        }

        public String getStatus() {
            return this._status;
        }

        public String getType() {
            return this._type;
        }

        public String getModule() {
            return this._module;
        }

        public Integer getSid() {
            return this._sid;
        }

        public Integer getSerial() {
            return this._serial;
        }

        public String getProgram() {
            return this._program;
        }
    }

    public static class Compatibility {
        public static final int COMPATIBLE = 1;
        public static final int NOT_COMPATIBLE_OLD_CLIENT = 2;
        public static final int NOT_COMPATIBLE_UPGRADABLE = 3;
        public static final int NOT_COMPATIBLE_MIGRATABLE = 4;
        public static final int NOT_COMPATIBLE_OVERWRITE = 5;
        public static final int NOT_COMPATIBLE = 6;
        public static final int DB_NOT_COMPATIBLE_XML_SCHEMA_112019 = 7;
        private Version clientVersion = null;
        private Version reposVersion = null;
        private Version xmlSchemaVersion = null;
        private Version dbVersion = null;
        private int compatibilityLevel;

        public static Compatibility getCompatibility(Connection connection) throws Exception {
            Compatibility compatibility = new Compatibility();
            compatibility.clientVersion = ConfigUtils.getClientVersion();
            compatibility.reposVersion = ConfigUtils.getReposVersion(connection);
            compatibility.xmlSchemaVersion = ConfigUtils.getXmlSchemaVersion(connection);
            compatibility.dbVersion = ConfigUtils.getDatabaseVersion(connection);
            Compatibility.initCompatibilityLevel(compatibility, compatibility.reposVersion);
            return compatibility;
        }

        private static void initCompatibilityLevel(Compatibility compatibility, Version version) {
            if (version.equals((Object)KNOWN_RELEASE_COMPATIBLE)) {
                compatibility.compatibilityLevel = 1;
                if (Compatibility.detectedDBUpgradeAndXMLSchemaBug(compatibility)) {
                    compatibility.compatibilityLevel = 7;
                }
                return;
            }
            for (Version version2 : KNOWN_RELEASES_REQUIRE_UPGRADE) {
                if (!version.equals((Object)version2)) continue;
                compatibility.compatibilityLevel = 3;
                return;
            }
            for (Version version2 : KNOWN_RELEASES_REQUIRE_MIGRATION) {
                if (!version.equals((Object)version2)) continue;
                compatibility.compatibilityLevel = 4;
                return;
            }
            for (Version version2 : KNOWN_ALPHA_RELEASES) {
                if (!version.equals((Object)version2)) continue;
                compatibility.compatibilityLevel = 5;
                return;
            }
            if (version.compareTo((Object)KNOWN_RELEASE_COMPATIBLE) > 0) {
                compatibility.compatibilityLevel = 2;
                return;
            }
            compatibility.compatibilityLevel = 6;
        }

        private static boolean detectedDBUpgradeAndXMLSchemaBug(Compatibility compatibility) {
            boolean bl = false;
            Version version = new Version("11.2.0.1.9");
            Version version2 = compatibility.getXmlSchemaVersion();
            if (version.equals((Object)version2)) {
                Version version3 = compatibility.getDBVersion();
                bl = !version3.toCanonicalString().startsWith("11.2.0.1") && !version3.toCanonicalString().startsWith("11.2.0.2");
            }
            return bl;
        }

        public int getCompatibilityLevel() {
            return this.compatibilityLevel;
        }

        public Version getClientVersion() {
            return this.clientVersion;
        }

        public Version getReposVersion() {
            return this.reposVersion;
        }

        public Version getXmlSchemaVersion() {
            return this.xmlSchemaVersion;
        }

        public Version getDBVersion() {
            return this.dbVersion;
        }
    }

    public static enum TextAndXMLDBState {
        NONE,
        TEXT_ONLY,
        XML_DB_ONLY,
        BOTH;

    }

    public static enum RunMode {
        INSTALLSCHEMA,
        GRANTS,
        UPGRADE_REPOS,
        MIGRATE_REPOS,
        DROP_REPOS;

    }
}

