/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.awt.Component;
import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.UtilsLrb;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class CommentValidator {
    private static int MAX_LENGTH = 4000;

    public static boolean validateComment(String string, Context context, boolean bl) {
        if (string == null) {
            return true;
        }
        if (string.length() > MAX_LENGTH && bl) {
            String string2 = MessageFormat.format(UtilsLrb.get("COMMENT_ERROR_NAME_TOO_LONG"), MAX_LENGTH);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)UtilsLrb.get("COMMENT_ERROR_TITLE"), null);
            return false;
        }
        if (StringUtils.hasMultibyteCharactes(string) && !CommentValidator.isCommentLengthValidInDB(string, context, bl)) {
            String string3 = MessageFormat.format(UtilsLrb.get("COMMENT_ERROR_NAME_TOO_LONG_FOR_DB"), MAX_LENGTH);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)UtilsLrb.get("COMMENT_ERROR_TITLE"), null);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean executeCommentLengthValidInDB(String string, Context context, boolean bl) {
        boolean bl2 = false;
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(context);
            bl2 = StringUtils.checkStringDBLengthMax(string, connection, MAX_LENGTH);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)UtilsLrb.get("NAME_ERROR_TITLE"), (String)UtilsLrb.get("NAME_ERROR_UNEXPECTED_FAILURE_MESG"), null);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!bl2 && bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("NAME_ERROR_NAME_INVALID"), (String)UtilsLrb.get("NAME_ERROR_TITLE"), null);
        }
        return bl2;
    }

    public static boolean isCommentLengthValidInDB(final String string, final Context context, final boolean bl) {
        class Worker
        extends ProgressRunnable {
            private boolean _canceled;
            protected boolean isValid = false;
            protected String errorText;

            Worker() {
            }

            protected Object doWork() throws Exception {
                this.isValid = CommentValidator.executeCommentLengthValidInDB(string, context, bl);
                return this.isValid;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this._canceled = true;
            }

            public boolean isCanceled() {
                return this._canceled;
            }
        }
        Worker worker = new Worker();
        worker.setTitle(UtilsLrb.get("COMMENT_VALIDATION_TITLE"));
        worker.setMessage(UtilsLrb.get("COMMENT_VALIDATION_DB_BYTES"));
        worker.setCancelable(true);
        try {
            worker.start(true);
        }
        catch (ProgressException progressException) {
            progressException.printStackTrace();
        }
        return worker.isValid;
    }
}

