/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.trend;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DefaultTableCellRenderer2;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.NiceTable2;
import oracle.dmt.dataminer.controls.TimeSeriesGraphPanel;
import oracle.dmt.dataminer.legend.LegendEvent;
import oracle.dmt.dataminer.legend.LegendListener;
import oracle.dmt.dataminer.legend.LegendManager;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.tviewer.TestTrendNode;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.trend.CTrendTabState;
import oracle.dmt.dataminer.tviewer.trend.TrendEditor;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.SwingWorker;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;

public class TrendTabPanel
extends DataMinerViewGUI {
    CTrendTabState _perfTrendTabState;
    MeasureItem _selectedMeasureItem;
    MeasureItem _predictionConfidenceMeasureItem;
    MeasureItem _avgAccuracyMeasureItem;
    MeasureItem _overallAccuracyMeasureItem;
    MeasureItem _costMeasureItem;
    Context _context;
    private String[] _columnNames = null;
    private JComboBox _jCB_Measure;
    private JLabel _jLB_Measure;
    private JPanel _jPNL_Graph;
    private GenericTable _jPerfTable;
    private JSplitPane _jSPLPane;
    private JScrollPane _jSP_Table;

    public TrendTabPanel(TrendEditor trendEditor, Context context) {
        TestTrendNode testTrendNode = (TestTrendNode)context.getNode();
        if (testTrendNode.getTests() != null && testTrendNode.getTests().size() > 0) {
            this._perfTrendTabState = new CTrendTabState(testTrendNode.getTests(), testTrendNode.getTestGraphColors(), null, null);
        }
        this._context = context;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jLB_Measure = new JLabel();
        this._jCB_Measure = new JComboBox();
        this._jSPLPane = new JSplitPane();
        this._jSP_Table = new JScrollPane();
        this._jPerfTable = new NiceTable2();
        this._jPNL_Graph = new JPanel();
        this._jLB_Measure.setText("Measure:");
        this._jCB_Measure.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._jSPLPane.setDividerLocation(400);
        this._jSPLPane.setOrientation(0);
        this._jSPLPane.setOneTouchExpandable(true);
        this._jSPLPane.setPreferredSize(new Dimension(3, 4));
        this._jPerfTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this._jSP_Table.setViewportView((Component)this._jPerfTable);
        this._jSPLPane.setRightComponent(this._jSP_Table);
        this._jPNL_Graph.setLayout(new BorderLayout());
        this._jPNL_Graph.setMinimumSize(new Dimension(100, 100));
        this._jSPLPane.setLeftComponent(this._jPNL_Graph);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this._jSPLPane, GroupLayout.Alignment.LEADING, -1, 574, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this._jLB_Measure, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jCB_Measure, -2, 133, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLB_Measure).addComponent(this._jCB_Measure)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jSPLPane, -1, 493, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        this._jLB_Measure.setText(TestViewerLrb.get("MEASURE") + ":");
        this._jCB_Measure.removeAllItems();
        this._predictionConfidenceMeasureItem = new MeasureItem(CTrendTabState.Measure.PREDICTIVE_CONFIDENCE, TestViewerLrb.get("PREDICTIVE_CONFIDENCE"));
        this._avgAccuracyMeasureItem = new MeasureItem(CTrendTabState.Measure.AVG_ACCURACY, TestViewerLrb.get("AVG_ACCURACY"));
        this._overallAccuracyMeasureItem = new MeasureItem(CTrendTabState.Measure.OVERALL_ACCURACY, TestViewerLrb.get("OVERALL_ACCURACY"));
        this._costMeasureItem = new MeasureItem(CTrendTabState.Measure.COST, TestViewerLrb.get("COST"));
        this._jCB_Measure.addItem(this._predictionConfidenceMeasureItem);
        this._jCB_Measure.addItem(this._avgAccuracyMeasureItem);
        this._jCB_Measure.addItem(this._overallAccuracyMeasureItem);
        this._jCB_Measure.addItem(this._costMeasureItem);
        this._columnNames = new String[]{TestViewerLrb.get("NAME"), TestViewerLrb.get("CREATION_DATE"), TestViewerLrb.get("MODEL_NAME"), TestViewerLrb.get("ALGORITHM"), this._predictionConfidenceMeasureItem._displayName, this._overallAccuracyMeasureItem._displayName, this._avgAccuracyMeasureItem._displayName, this._costMeasureItem._displayName};
        this._jCB_Measure.addItem(new MeasureItem(CTrendTabState.Measure.MULTIPLE_SELECTION, TestViewerLrb.get("MULTIPLE_SELECTION")));
        this._selectedMeasureItem = this._predictionConfidenceMeasureItem;
    }

    @Override
    public void initUI() {
        this.setLoading(true);
        this._jCB_Measure.setSelectedItem(this._selectedMeasureItem);
        this._jSP_Table.setVisible(false);
        this._jCB_Measure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrendTabPanel.this._selectedMeasureItem = (MeasureItem)TrendTabPanel.this._jCB_Measure.getSelectedItem();
                TrendTabPanel.this.reloadGraphPanel();
            }
        });
        this.registerWithLegendDockable();
        LoadUI loadUI = new LoadUI();
        this._jPNL_Graph.add(GraphPanel.LOADING_GRAPH);
        loadUI.start();
    }

    private void registerWithLegendDockable() {
        LegendManager.getLegendManager().getLegendWindow().addLegendListener(new TestLegendListener(), (View)this._editor);
    }

    private void reloadGraphPanel() {
        this._jPerfTable.setDefaultRenderer(Double.class, (TableCellRenderer)new DefaultTableCellRenderer2());
        this._jPerfTable.setDefaultRenderer(Date.class, (TableCellRenderer)new DefaultTableCellRenderer2());
        if (CTrendTabState.Measure.MULTIPLE_SELECTION.equals((Object)this._selectedMeasureItem._measure)) {
            this._jPerfTable.setHiddenColumns(new int[0]);
            this._jPerfTable.setSortColumn(1, false);
            this._jPNL_Graph.removeAll();
            this._jPNL_Graph.setLayout(new GridLayout(2, 2));
            this._jPNL_Graph.add(new TimeSeriesGraphPanel(this._perfTrendTabState.getGraphDataModel(CTrendTabState.Measure.PREDICTIVE_CONFIDENCE)));
            this._jPNL_Graph.add(new TimeSeriesGraphPanel(this._perfTrendTabState.getGraphDataModel(CTrendTabState.Measure.OVERALL_ACCURACY)));
            this._jPNL_Graph.add(new TimeSeriesGraphPanel(this._perfTrendTabState.getGraphDataModel(CTrendTabState.Measure.AVG_ACCURACY)));
            GraphDataModel graphDataModel = this._perfTrendTabState.getGraphDataModel(CTrendTabState.Measure.COST);
            if (graphDataModel != null) {
                this._jPNL_Graph.add(new TimeSeriesGraphPanel(this._perfTrendTabState.getGraphDataModel(CTrendTabState.Measure.COST)));
            }
            this._jPNL_Graph.updateUI();
            this._jPerfTable.setHiddenColumns(new int[]{2, 3});
            this._jPerfTable.setSortColumn(1, true);
        } else {
            this._jPNL_Graph.removeAll();
            this._jPNL_Graph.setLayout(new BorderLayout());
            this._jPNL_Graph.add((Component)new TimeSeriesGraphPanel(this._perfTrendTabState.getGraphDataModel(this._selectedMeasureItem._measure)), "Center");
            this._jPNL_Graph.updateUI();
            if (CTrendTabState.Measure.PREDICTIVE_CONFIDENCE.equals((Object)this._selectedMeasureItem._measure)) {
                this._jPerfTable.setHiddenColumns(new int[]{2, 3, 5, 6, 7});
            } else if (CTrendTabState.Measure.OVERALL_ACCURACY.equals((Object)this._selectedMeasureItem._measure)) {
                this._jPerfTable.setHiddenColumns(new int[]{2, 3, 4, 6, 7});
            } else if (CTrendTabState.Measure.AVG_ACCURACY.equals((Object)this._selectedMeasureItem._measure)) {
                this._jPerfTable.setHiddenColumns(new int[]{2, 3, 4, 5, 7});
            } else if (CTrendTabState.Measure.COST.equals((Object)this._selectedMeasureItem._measure)) {
                this._jPerfTable.setHiddenColumns(new int[]{2, 3, 4, 5, 6});
            } else {
                this._jPerfTable.setHiddenColumns(new int[]{2, 3});
            }
            this._jPerfTable.setSortColumn(1, true);
        }
    }

    public void setLegendState(LegendEvent legendEvent) {
        LoadUI loadUI = new LoadUI();
        loadUI.start();
        this.repaint();
    }

    class TestLegendListener
    implements LegendListener {
        TestLegendListener() {
        }

        @Override
        public void addEvent(LegendEvent legendEvent) {
            TrendTabPanel.this.setLegendState(legendEvent);
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object construct() {
            Connection connection = null;
            try {
                connection = Connections.getUniqueConnection(TrendTabPanel.this._context);
                TrendTabPanel.this._perfTrendTabState.load(connection);
                GenericBaseTableModel genericBaseTableModel = TrendTabPanel.this._perfTrendTabState.getPerformanceTableModel();
                genericBaseTableModel.setColumnIdentifiers((Object[])TrendTabPanel.this._columnNames);
                TrendTabPanel.this._jPerfTable.setModel((TableModel)TrendTabPanel.this._perfTrendTabState.getPerformanceTableModel());
                TrendTabPanel.this._jPerfTable.setSorted(true);
                TrendTabPanel.this._jPerfTable.setSortColumn(1, true);
                TrendTabPanel.this._jPerfTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer2());
                TrendTabPanel.this._jPerfTable.getColumnModel().getColumn(4).setCellRenderer(new DefaultTableCellRenderer2());
                TrendTabPanel.this._jPerfTable.getColumnModel().getColumn(5).setCellRenderer(new DefaultTableCellRenderer2());
                TrendTabPanel.this._jPerfTable.getColumnModel().getColumn(6).setCellRenderer(new DefaultTableCellRenderer2());
                TrendTabPanel.this._jPerfTable.getColumnModel().getColumn(7).setCellRenderer(new DefaultTableCellRenderer2());
                TrendTabPanel.this._jPerfTable.setDefaultRenderer(Double.class, (TableCellRenderer)new DefaultTableCellRenderer2());
                TrendTabPanel.this._jPerfTable.setDefaultRenderer(Date.class, (TableCellRenderer)new DefaultTableCellRenderer2());
                TrendTabPanel.this._jPerfTable.setHiddenColumns(new int[]{2, 3, 5, 6, 7});
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return TrendTabPanel.this._perfTrendTabState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                if (this._success && this._ex == null) {
                    TrendTabPanel.this._jPNL_Graph.removeAll();
                    TrendTabPanel.this._jPNL_Graph.add((Component)new TimeSeriesGraphPanel(TrendTabPanel.this._perfTrendTabState.getGraphDataModel(TrendTabPanel.this._selectedMeasureItem._measure)), "Center");
                    TrendTabPanel.this._jSP_Table.setVisible(true);
                    TrendTabPanel.this._jPNL_Graph.updateUI();
                    TrendTabPanel.this._jSPLPane.setDividerLocation(0.8);
                    TrendTabPanel.this._jSPLPane.setResizeWeight(1.0);
                    TrendTabPanel.this.setLoaded(true);
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                TrendTabPanel.this.setLoading(false);
            }
        }
    }

    private class MeasureItem {
        CTrendTabState.Measure _measure;
        String _displayName;

        public MeasureItem(CTrendTabState.Measure measure, String string) {
            this._measure = measure;
            this._displayName = string;
        }

        public String toString() {
            return this._displayName;
        }

        public boolean equals(Object object) {
            if (object instanceof MeasureItem) {
                return this._measure.equals((Object)((MeasureItem)object)._measure);
            }
            return false;
        }
    }
}

