/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.roc;

import java.awt.Color;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.dialog.test.TuneState;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;

public class ROCTabPanelState {
    private SharedTestEditorState _parentTestViewerState;
    private Context _context;
    private List<TestResult> _testResults;
    private Vector<String> _targetValues;
    private String _selectedTargetValue;
    private String _selectedTestResult;
    private HashMap<String, Map<String, List<ROCData>>> _rocdata;
    private HashMap<String, Map<String, StatisticsData>> _statdata;
    private HashMap<String, Map<String, Integer>> _confusionMatrix;
    public static final String CUSTOM_THRESHOLD_OP_HIT_RATIO = "CUSTOM_THRESHOLD_OP_HIT_RATIO";
    public static final String CUSTOM_THRESHOLD_OP_FALSE_ALARM = "CUSTOM_THRESHOLD_OP_FALSE_ALARM";
    public static final String CUSTOM_THRESHOLD_OP_FALSE_RATIO = "CUSTOM_THRESHOLD_OP_FALSE_RATIO";
    private String _customThresholdOption;
    private double _customThresholdValue;
    private ROCTableModel _rocTableModel;
    private DefaultGraphDataModel _rocGraphModel;

    public SharedTestEditorState getParentTestViewerState() {
        return this._parentTestViewerState;
    }

    public ROCTabPanelState(SharedTestEditorState sharedTestEditorState, Context context) {
        this._parentTestViewerState = sharedTestEditorState;
        this._context = context;
        this._targetValues = new Vector();
        this._rocdata = new HashMap();
        this._statdata = new HashMap();
        this._confusionMatrix = new HashMap();
        this._customThresholdOption = CUSTOM_THRESHOLD_OP_HIT_RATIO;
        this._customThresholdValue = 0.0;
        this._rocTableModel = null;
        this._testResults = this._parentTestViewerState.getTestResults();
        this._rocGraphModel = new DefaultGraphDataModel(null, 61, null, null, null);
        this._rocGraphModel.setX1(TestViewerLrb.get("FALSE_POSITIVE_FRACTION"), 1.0);
        this._rocGraphModel.setY1(TestViewerLrb.get("TRUE_POSITIVE_FRACTION"), 1.0);
    }

    public void load() throws Exception {
        Connection connection = Connections.getUniqueConnection(this._context);
        SQLHelper sQLHelper = new SQLHelper();
        this._targetValues.clear();
        this._testResults = this._parentTestViewerState.getTestResults();
        try {
            for (TestResult testResult : this._testResults) {
                if (!((ClassTestResult)testResult).rocResultExists()) continue;
                Vector<String> vector = ((ClassTestResult)testResult).getTargetValues();
                for (String string : vector) {
                    if (this._targetValues.contains(string)) continue;
                    this._targetValues.add(string);
                }
            }
            Object object = ((ClassTestResult)this._testResults.get(0)).getLeastTargetValue();
            if (object == null) {
                object = this._targetValues.get(0);
            }
            this.setSelectedTargetValue((String)object);
            this.loadROC(connection);
            this.loadROCGraph();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw sQLException;
        }
        finally {
            sQLHelper.close();
            connection.close();
        }
    }

    public void refreshROCStatData() throws Exception {
        Connection connection = Connections.getUniqueConnection(this._context);
        try {
            this.loadROC(connection);
            this.loadROCGraph();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw sQLException;
        }
        finally {
            connection.close();
        }
    }

    private void loadROC(Connection connection) throws Exception {
        String string = this.getSelectedTargetValue();
        int n = 10;
        int n2 = 3000;
        SQLHelper sQLHelper = new SQLHelper();
        TreeMap<String, List<ROCData>> treeMap = new TreeMap<String, List<ROCData>>();
        TreeMap<String, StatisticsData> treeMap2 = new TreeMap<String, StatisticsData>();
        try {
            for (TestResult testResult : this._testResults) {
                Object object;
                List<ROCData> list;
                Map<String, List<ROCData>> map;
                Object object2;
                String string2;
                String string3 = testResult.toString();
                Map<String, Integer> map2 = this._confusionMatrix.get(string3);
                if (map2 == null) {
                    map2 = new HashMap<String, Integer>();
                    string2 = ((ClassTestResult)testResult).getConfusionMatrixTable();
                    object2 = "select actual_target_value, value from " + string2 + " where actual_target_value = predicted_target_value";
                    sQLHelper.pstmt = connection.prepareStatement((String)object2);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    while (sQLHelper.rs.next()) {
                        map = sQLHelper.rs.getString("actual_target_value");
                        int n3 = sQLHelper.rs.getInt("value");
                        map2.put((String)((Object)map), new Integer(n3));
                    }
                    this._confusionMatrix.put(string3, map2);
                }
                string2 = ((ClassTestResult)testResult).geRocResultTable(string);
                object2 = ((ClassTestResult)testResult).getRocAreaUnderCurve(string);
                map = this._rocdata.get(string);
                if (map == null) {
                    map = new HashMap<String, List<ROCData>>();
                    this._rocdata.put(string, map);
                }
                if ((list = map.get(string3)) == null) {
                    list = new ArrayList<ROCData>();
                    ((ArrayList)list).ensureCapacity(n2);
                    object = "SELECT TRUNC(PROBABILITY,25) PROBABILITY, TRUNC(TRUE_POSITIVE_FRACTION," + n + ") TRUE_POSITIVE_FRACTION, TRUNC(FALSE_POSITIVE_FRACTION," + n + ") FALSE_POSITIVE_FRACTION, " + "TRUE_POSITIVES, FALSE_NEGATIVES, FALSE_POSITIVES, TRUE_NEGATIVES " + "FROM (SELECT t.*, ROWNUM RNUM FROM " + string2 + " t) " + "WHERE ORA_HASH(RNUM,((SELECT COUNT(*) FROM " + string2 + ")-1),12345) < " + n2 + " " + "ORDER BY FALSE_POSITIVE_FRACTION , TRUE_POSITIVE_FRACTION ";
                    sQLHelper.pstmt = connection.prepareStatement((String)object);
                    sQLHelper.pstmt.setFetchSize(n2);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    while (sQLHelper.rs.next()) {
                        int n4 = sQLHelper.rs.getInt("TRUE_POSITIVES");
                        int n5 = sQLHelper.rs.getInt("FALSE_NEGATIVES");
                        int n6 = sQLHelper.rs.getInt("FALSE_POSITIVES");
                        int n7 = sQLHelper.rs.getInt("TRUE_NEGATIVES");
                        double d = sQLHelper.rs.getDouble("TRUE_POSITIVE_FRACTION");
                        double d2 = sQLHelper.rs.getDouble("FALSE_POSITIVE_FRACTION");
                        double d3 = sQLHelper.rs.getDouble("PROBABILITY");
                        ROCData rOCData = new ROCData(d3, n4, n5, n6, n7, d, d2);
                        list.add(rOCData);
                    }
                    map.put(string3, list);
                }
                this.loadStatisticsData(string3, (Double)object2, testResult.getMiningAlgorithm(), testResult.getCreationTime());
                treeMap.put(string3, list);
                object = this._statdata.get(this.getSelectedTargetValue()).get(string3);
                treeMap2.put(string3, (StatisticsData)object);
            }
            TuneState tuneState = (TuneState)this._context.getProperty("TUNE_STATE");
            this._rocTableModel = tuneState == null ? new ROCTableModel(treeMap2, treeMap) : new ROCTuneTableModel(tuneState, treeMap2, treeMap);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
    }

    private void loadROCGraph() {
        List<ROCData> list;
        Object object;
        Map<String, List<ROCData>> map = this._rocdata.get(this.getSelectedTargetValue());
        Map<String, StatisticsData> map2 = this._statdata.get(this.getSelectedTargetValue());
        this._rocGraphModel.clear();
        ArrayList<Color> arrayList = new ArrayList<Color>();
        int n = 0;
        int n2 = 0;
        for (TestResult testResult : this._testResults) {
            String string = testResult.toString();
            List<ROCData> list2 = map.get(string);
            if (list2 != null && list2.size() > 0) {
                ++n;
                object = this._parentTestViewerState.getTestResultGraphColors().get(n2);
                arrayList.add((Color)object);
            }
            ++n2;
        }
        Object[][] objectArray = new Object[n * 5][];
        Object[] objectArray2 = new Object[n * 5];
        Object[] objectArray3 = new Object[n * 5];
        int n3 = 0;
        int n4 = 0;
        for (TestResult testResult : this._testResults) {
            object = testResult.toString();
            list = map.get(object);
            objectArray[n3] = new Object[list.size() * 2];
            n4 = 0;
            for (int i = 0; i < list.size(); ++i) {
                objectArray[n3][n4++] = new Double(list.get(i).getFalsePositivesFraction());
                objectArray[n3][n4++] = new Double(list.get(i).getTruePositivesFraction());
            }
            objectArray2[n3] = TestViewerLrb.get("RESULT_NAME") + ": " + (String)object;
            objectArray3[n3] = 0;
            ++n3;
        }
        for (TestResult testResult : this._testResults) {
            object = testResult.toString();
            list = map.get(object);
            StatisticsData statisticsData = map2.get(object);
            n4 = 0;
            objectArray[n3] = new Object[2];
            objectArray[n3][n4++] = new Double(list.get(statisticsData.getMaxOverallAccuracyIdx()).getFalsePositivesFraction());
            objectArray[n3][n4++] = new Double(list.get(statisticsData.getMaxOverallAccuracyIdx()).getTruePositivesFraction());
            objectArray2[n3] = TestViewerLrb.get("MAX_OVERALL_ACCURACY_COL") + ": " + (String)object;
            objectArray3[n3] = 1;
            n4 = 0;
            objectArray[++n3] = new Object[2];
            objectArray[n3][n4++] = new Double(list.get(statisticsData.getMaxAvgAccuracyIdx()).getFalsePositivesFraction());
            objectArray[n3][n4++] = new Double(list.get(statisticsData.getMaxAvgAccuracyIdx()).getTruePositivesFraction());
            objectArray2[n3] = TestViewerLrb.get("MAX_AVG_ACCURACY_COL") + ": " + (String)object;
            objectArray3[n3] = 2;
            n4 = 0;
            objectArray[++n3] = new Object[2];
            if (statisticsData.getCustomAccuracyIdx() >= 0) {
                objectArray[n3][n4++] = new Double(list.get(statisticsData.getCustomAccuracyIdx()).getFalsePositivesFraction());
                objectArray[n3][n4++] = new Double(list.get(statisticsData.getCustomAccuracyIdx()).getTruePositivesFraction());
            } else {
                objectArray[n3][n4++] = new Double(0.0);
                objectArray[n3][n4++] = new Double(0.0);
            }
            objectArray2[n3] = TestViewerLrb.get("CUSTOM_ACCURACY_COL") + ": " + (String)object;
            objectArray3[n3] = 4;
            n4 = 0;
            objectArray[++n3] = new Object[2];
            objectArray[n3][n4++] = new Double(list.get(statisticsData.getModelAccuracyIdx()).getFalsePositivesFraction());
            objectArray[n3][n4++] = new Double(list.get(statisticsData.getModelAccuracyIdx()).getTruePositivesFraction());
            objectArray2[n3] = TestViewerLrb.get("CURRENT_ACCURACY_COL") + ": " + (String)object;
            objectArray3[n3] = 3;
            ++n3;
        }
        this._rocGraphModel.addRowLabels(objectArray2);
        this._rocGraphModel.addRowMarkerShapes(objectArray3);
        this._rocGraphModel.addGraphData(objectArray);
        this._rocGraphModel.addRowColors(arrayList.toArray(new Color[0]));
    }

    private void loadStatisticsData(String string, Double d, String string2, Date date) throws Exception {
        String string3 = this.getSelectedTargetValue();
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        Map<String, List<ROCData>> map = this._rocdata.get(string3);
        Map<String, StatisticsData> map2 = this._statdata.get(string3);
        if (map2 == null) {
            map2 = new HashMap<String, StatisticsData>();
            this._statdata.put(string3, map2);
        }
        if (map2.get(string) == null) {
            List<ROCData> list = map.get(string);
            for (int i = 0; i < list.size(); ++i) {
                ROCData rOCData = list.get(i);
                double d4 = rOCData._prob;
                double d5 = 0.0;
                if (i < list.size() - 1) {
                    d5 = list.get((int)(i + 1))._prob;
                }
                if (d4 >= 0.5 && d5 < 0.5) {
                    n3 = i;
                }
                if (d2 < rOCData.getAccuracy()) {
                    d2 = rOCData.getAccuracy();
                    n = i;
                }
                if (!(d3 < rOCData.getAvgAccuracy())) continue;
                d3 = rOCData.getAvgAccuracy();
                n2 = i;
            }
            map2.put(string, new StatisticsData(d, n, n2, n4, n3, string2, date));
        }
    }

    public void refreshCustomThresholdData() {
        String string = this.getSelectedTargetValue();
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        Map<String, List<ROCData>> map = this._rocdata.get(string);
        Map<String, StatisticsData> map2 = this._statdata.get(string);
        for (String string2 : map.keySet()) {
            List<ROCData> list = map.get(string2);
            for (int i = 0; i < list.size() - 1; ++i) {
                if (this.getCustomThresholdOption() == CUSTOM_THRESHOLD_OP_HIT_RATIO) {
                    d = list.get(i).getTruePositivesFraction();
                    d2 = list.get(i + 1).getTruePositivesFraction();
                } else if (this.getCustomThresholdOption() == CUSTOM_THRESHOLD_OP_FALSE_ALARM) {
                    d = list.get(i).getFalsePositivesFraction();
                    d2 = list.get(i + 1).getFalsePositivesFraction();
                } else if (this.getCustomThresholdOption() == CUSTOM_THRESHOLD_OP_FALSE_RATIO) {
                    d = (double)list.get(i).getFalsePositives() / (double)list.get(i).getFalseNegatives();
                    d2 = (double)list.get(i + 1).getFalsePositives() / (double)list.get(i + 1).getFalseNegatives();
                }
                if (!(this._customThresholdValue >= d) || !(this._customThresholdValue <= d2)) continue;
                double d3 = this._customThresholdValue - d;
                double d4 = d2 - this._customThresholdValue;
                if (d3 <= d4) {
                    n = i;
                    break;
                }
                n = i + 1;
                break;
            }
            StatisticsData statisticsData = map2.get(string2);
            statisticsData.setCustomAccuracyIdx(n);
        }
    }

    public void setSelectedTargetValue(String string) {
        this._selectedTargetValue = string;
    }

    public String getSelectedTargetValue() {
        return this._selectedTargetValue;
    }

    public void setCustomThresholdOption(String string) {
        this._customThresholdOption = string;
    }

    public String getCustomThresholdOption() {
        return this._customThresholdOption;
    }

    public void setCustomThresholdValue(double d) {
        this._customThresholdValue = d;
    }

    public double getCustomThresholdValue() {
        return this._customThresholdValue;
    }

    public Map<String, List<ROCData>> getROCData() {
        return this._rocdata.get(this.getSelectedTargetValue());
    }

    public Map<String, StatisticsData> getStatisticsData() {
        return this._statdata.get(this.getSelectedTargetValue());
    }

    public ROCTableModel getRocTableModel() {
        return this._rocTableModel;
    }

    public Vector<String> getTargetValues() {
        return this._targetValues;
    }

    public DefaultGraphDataModel getRocGraphModel() {
        return this._rocGraphModel;
    }

    public void setSelectedTestResult(String string) {
        this._selectedTestResult = string;
    }

    public String getSelectedTestResult() {
        return this._selectedTestResult;
    }

    public Context getContext() {
        return this._context;
    }

    public TestResult getSelectedTestResultObj() {
        for (TestResult testResult : this._testResults) {
            if (!testResult.toString().equals(this.getSelectedTestResult())) continue;
            return testResult;
        }
        return null;
    }

    public class ROCTuneTableModel
    extends ROCTableModel {
        private static final int COLUMN_COUNT = 9;
        public static final int MODEL = 0;
        public static final int TUNE = 1;
        public static final int AREA_UNDER_CURVE = 2;
        public static final int MAX_OVERALL = 3;
        public static final int MAX_AVG = 4;
        public static final int CUSTOM = 5;
        public static final int CURRENT = 6;
        public static final int ALGORITHM = 7;
        public static final int CREATION_DATE = 8;
        private TuneState _tuneState;
        private String TUNE_NONE;
        private String TUNE_BENEFIT;
        private String TUNE_COST;
        private String TUNE_ROC;
        private String TUNE_LIFT;
        private String TUNE_PROFIT;
        private String[] _columnNames;

        public ROCTuneTableModel(TuneState tuneState) {
            this.TUNE_NONE = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_NONE");
            this.TUNE_BENEFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_BENEFIT");
            this.TUNE_COST = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_COST");
            this.TUNE_ROC = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_ROC");
            this.TUNE_LIFT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_LIFT");
            this.TUNE_PROFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_PROFIT");
            this._columnNames = new String[]{TestViewerLrb.get("RESULT_NAME"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE"), TestViewerLrb.get("AREA_UNDER_CURVE"), TestViewerLrb.get("MAX_OVERALL_ACCURACY_COL"), TestViewerLrb.get("MAX_AVG_ACCURACY_COL"), TestViewerLrb.get("CUSTOM_ACCURACY_COL"), TestViewerLrb.get("CURRENT_ACCURACY_COL"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("CREATION_DATE")};
            this.setColumnIdentifiers(this._columnNames);
            this.setRowCount(1);
            this.setColumnCount(9);
            this._tuneState = tuneState;
        }

        public ROCTuneTableModel(TuneState tuneState, Map<String, StatisticsData> map, Map<String, List<ROCData>> map2) {
            super(map, map2);
            this.TUNE_NONE = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_NONE");
            this.TUNE_BENEFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_BENEFIT");
            this.TUNE_COST = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_COST");
            this.TUNE_ROC = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_ROC");
            this.TUNE_LIFT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_LIFT");
            this.TUNE_PROFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_PROFIT");
            this._columnNames = new String[]{TestViewerLrb.get("RESULT_NAME"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE"), TestViewerLrb.get("AREA_UNDER_CURVE"), TestViewerLrb.get("MAX_OVERALL_ACCURACY_COL"), TestViewerLrb.get("MAX_AVG_ACCURACY_COL"), TestViewerLrb.get("CUSTOM_ACCURACY_COL"), TestViewerLrb.get("CURRENT_ACCURACY_COL"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("CREATION_DATE")};
            this.setColumnIdentifiers(this._columnNames);
            this.setColumnCount(9);
            this._tuneState = tuneState;
        }

        @Override
        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return super.getValueAt(n, 0);
            }
            if (n2 == 2) {
                return super.getValueAt(n, 1);
            }
            if (n2 == 3) {
                return super.getValueAt(n, 2);
            }
            if (n2 == 4) {
                return super.getValueAt(n, 3);
            }
            if (n2 == 5) {
                return super.getValueAt(n, 4);
            }
            if (n2 == 6) {
                return super.getValueAt(n, 5);
            }
            if (n2 == 7) {
                return super.getValueAt(n, 6);
            }
            if (n2 == 8) {
                return super.getValueAt(n, 7);
            }
            if (n2 == 1 && this._statData != null) {
                Object[] objectArray = this._statData.keySet().toArray();
                String string = (String)objectArray[n];
                if (this._tuneState.isTuningNone(string)) {
                    return this.TUNE_NONE;
                }
                if (this._tuneState.isTuningBenefit(string)) {
                    return this.TUNE_BENEFIT;
                }
                if (this._tuneState.isTuningCost(string)) {
                    return this.TUNE_COST;
                }
                if (this._tuneState.isTuningCustomROC(string)) {
                    return this.TUNE_ROC;
                }
                if (this._tuneState.isTuningCustomLift(string)) {
                    return this.TUNE_LIFT;
                }
                if (this._tuneState.isTuningCustomProfit(string)) {
                    return this.TUNE_PROFIT;
                }
            }
            return null;
        }
    }

    public class ROCTableModel
    extends GenericBaseTableModel {
        private static final int COLUMN_COUNT = 8;
        public static final int MODEL = 0;
        public static final int AREA_UNDER_CURVE = 1;
        public static final int MAX_OVERALL = 2;
        public static final int MAX_AVG = 3;
        public static final int CUSTOM = 4;
        public static final int CURRENT = 5;
        public static final int ALGORITHM = 6;
        public static final int CREATION_DATE = 7;
        protected Map<String, StatisticsData> _statData = null;
        protected Map<String, List<ROCData>> _rocData = null;
        private String[] _columnNames = new String[]{TestViewerLrb.get("RESULT_NAME"), TestViewerLrb.get("AREA_UNDER_CURVE"), TestViewerLrb.get("MAX_OVERALL_ACCURACY_COL"), TestViewerLrb.get("MAX_AVG_ACCURACY_COL"), TestViewerLrb.get("CUSTOM_ACCURACY_COL"), TestViewerLrb.get("CURRENT_ACCURACY_COL"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("CREATION_DATE")};
        private final String LOADING = TestViewerLrb.get("LOADING");

        public ROCTableModel() {
            this.setColumnIdentifiers(this._columnNames);
            this.setRowCount(1);
            this.setColumnCount(8);
        }

        public ROCTableModel(Map<String, StatisticsData> map, Map<String, List<ROCData>> map2) {
            this.setColumnIdentifiers(this._columnNames);
            this._statData = map;
            this._rocData = map2;
            this.setRowCount(this._statData.size());
            this.setColumnCount(8);
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            if (this._statData == null) {
                if (n2 == 0) {
                    return this.LOADING;
                }
                return null;
            }
            Object[] objectArray = this._statData.keySet().toArray();
            List<ROCData> list = this._rocData.get(objectArray[n]);
            int n3 = 0;
            if (n2 == 0) {
                return objectArray[n];
            }
            if (n2 == 1) {
                return new Double(this._statData.get(objectArray[n]).getAreaUnderCurve());
            }
            if (n2 == 2) {
                n3 = this._statData.get(objectArray[n]).getMaxOverallAccuracyIdx();
                return new Double(list.get(n3).getAccuracy());
            }
            if (n2 == 3) {
                n3 = this._statData.get(objectArray[n]).getMaxAvgAccuracyIdx();
                return new Double(list.get(n3).getAvgAccuracy());
            }
            if (n2 == 4) {
                n3 = this._statData.get(objectArray[n]).getCustomAccuracyIdx();
                if (n3 >= 0) {
                    return new Double(list.get(n3).getAccuracy());
                }
                return new Double(0.0);
            }
            if (n2 == 5) {
                n3 = this._statData.get(objectArray[n]).getModelAccuracyIdx();
                return new Double(list.get(n3).getAccuracy());
            }
            if (n2 == 6) {
                return this._statData.get(objectArray[n]).getAlgorithm();
            }
            if (n2 == 7) {
                return this._statData.get(objectArray[n]).getCreationDate();
            }
            return "Undefined";
        }
    }

    public class StatisticsData {
        private double _areaUnderCurve;
        private int _maxOverallAccuracyIdx;
        private int _maxAvgAccuracyIdx;
        private int _customAccuracyIdx;
        private int _modelAccuracyIdx;
        private String _algorithm;
        private Date _creation_date;

        public StatisticsData(double d, int n, int n2, int n3, int n4, String string, Date date) {
            this._areaUnderCurve = d;
            this._maxOverallAccuracyIdx = n;
            this._maxAvgAccuracyIdx = n2;
            this._customAccuracyIdx = n3;
            this._modelAccuracyIdx = n4;
            this._algorithm = string;
            this._creation_date = date;
        }

        public double getAreaUnderCurve() {
            return this._areaUnderCurve;
        }

        public int getMaxOverallAccuracyIdx() {
            return this._maxOverallAccuracyIdx;
        }

        public int getMaxAvgAccuracyIdx() {
            return this._maxAvgAccuracyIdx;
        }

        public int getCustomAccuracyIdx() {
            return this._customAccuracyIdx;
        }

        public int getModelAccuracyIdx() {
            return this._modelAccuracyIdx;
        }

        public void setCustomAccuracyIdx(int n) {
            this._customAccuracyIdx = n;
        }

        public String getAlgorithm() {
            return this._algorithm;
        }

        public Date getCreationDate() {
            return this._creation_date;
        }
    }

    public class ROCData
    implements Element {
        protected double _prob;
        protected int _tp;
        protected int _fn;
        protected int _tn;
        protected int _fp;
        protected double _tpf;
        protected double _fpf;
        protected double _accuracy;
        protected double _avgAccuracy;
        private String _label;

        public void setLabel(String string) {
            this._label = string;
        }

        public ROCData(double d, int n, int n2, int n3, int n4, double d2, double d3) {
            this._prob = d;
            this._tp = n;
            this._fn = n2;
            this._tn = n4;
            this._fp = n3;
            this._tpf = d2;
            this._fpf = d3;
            this._accuracy = (double)(this._tp + this._tn) / (double)(this._tp + this._fp + this._tn + this._fn) * 100.0;
            this._avgAccuracy = ((double)this._tp / (double)(this._tp + this._fn) + (double)this._tn / (double)(this._tn + this._fp)) / 2.0 * 100.0;
        }

        public double getProb() {
            return this._prob;
        }

        public int getTruePositives() {
            return this._tp;
        }

        public int getFalseNegatives() {
            return this._fn;
        }

        public int getFalsePositives() {
            return this._fp;
        }

        public int getTrueNegatives() {
            return this._tn;
        }

        public double getTruePositivesFraction() {
            return this._tpf;
        }

        public double getFalsePositivesFraction() {
            return this._fpf;
        }

        public double getAccuracy() {
            return this._accuracy;
        }

        public double getAvgAccuracy() {
            return this._avgAccuracy;
        }

        public boolean mayHaveChildren() {
            return false;
        }

        public Iterator<Element> getChildren() {
            return null;
        }

        public Attributes getAttributes() {
            return null;
        }

        public Object getData() {
            return null;
        }

        public String getShortLabel() {
            return this._label;
        }

        public String getLongLabel() {
            return "";
        }

        public Icon getIcon() {
            return null;
        }

        public String getToolTipText() {
            return "";
        }

        public String toString() {
            return "";
        }
    }
}

