/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.profit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.aeditor.dialog.CompareTestResultsFlatDialog;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.DateCellRenderer2;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GenericTableFixedColumns;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.tviewer.AbstractTestEditor;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.profit.ProfitDetailDialog;
import oracle.dmt.dataminer.tviewer.profit.ProfitEditor;
import oracle.dmt.dataminer.tviewer.profit.ProfitInputDialog;
import oracle.dmt.dataminer.tviewer.profit.ProfitTabState;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controls.ColorIcon;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;

public class ProfitPanel
extends DataMinerViewGUI {
    private GraphPanel _graphPanel;
    private ProfitTabState _state;
    private boolean _loading = true;
    private static final String UPDATE_ALL = "UPDATE_ALL";
    private static final String UPDATE_GRAPH = "UPDATE_GRAPH";
    private static final String UPDATE_THRESHOLD = "UPDATE_THRESHOLD";
    private JPanel jGraphControl;
    private JPanel jGraphPanel;
    private JPanel jPanel;
    private JPanel jPanel1;
    private TransparentPanel jProfitPanel;
    private ComponentWithTitlebar<JComponent> jProfitToolbar;
    private JSlider jQuantileSlider;
    private JButton jSettingsBtn;
    private JSplitPane jSplitPane;
    private JComboBox jTargetComb;
    private JLabel jTargetLbl;
    private JButton jDetailBtn;
    private CustomGenericTable jResultTable;
    private JButton _jBT_AddOrRemove;
    private static Icon _detailBtnIconEna;
    private static Icon _detailBtnIconDis;
    private static Icon _jIC_UpdateENA;
    private static Icon _jIC_UpdateDIS;
    private JScrollPane tscroller;

    public ProfitPanel(ProfitEditor profitEditor, Context context) {
        super(profitEditor, context);
        this._state = new ProfitTabState((SharedTestEditorState)profitEditor.getCachedLegendState(), context);
        this.initComponents();
        this.initGraph();
        this.initRes();
        this.initUI();
    }

    private void initGraph() {
        this._graphPanel = new GraphPanel(new DefaultGraphDataModel(null, null, null, null, null));
        this.jGraphPanel.add((Component)new JTextArea(TestViewerLrb.get("LOADING_SHORTENED")), "Center");
        this.jGraphPanel.updateUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTargetLbl, (Component)this.jTargetComb, (String)TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleName(TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("TARGET_VALUE_ADA"));
        this.jTargetLbl.setLabelFor(this.jTargetComb);
        ResourceUtils.resButton((AbstractButton)this.jSettingsBtn, (String)TestViewerLrb.get("PROFIT_SETTINGS_BTN"));
        this.jSettingsBtn.getAccessibleContext().setAccessibleName(TestViewerLrb.get("PROFIT_SETTINGS_BTN"));
        this.jSettingsBtn.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("PROFIT_SETTINGS_BTN_ADA"));
    }

    @Override
    public void initUI() {
        this._loading = true;
        this.jResultTable = new CustomGenericTable();
        this.tscroller = new JScrollPane((Component)((Object)this.jResultTable));
        this.jResultTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int[] nArray = ProfitPanel.this.jResultTable.getSelectedRowsInModel();
                    String string = (String)ProfitPanel.this._state.getProfitTableModel().getValueAt(nArray[0], 0);
                    ProfitDetailDialog profitDetailDialog = new ProfitDetailDialog(string, ProfitPanel.this._state, ProfitPanel.this._state.getProfitData().get(string));
                    if (profitDetailDialog.invoke()) {
                        // empty if block
                    }
                }
            }
        });
        this.jProfitToolbar.setComponent((JComponent)this.tscroller);
        this.jProfitToolbar.setLabel(new JLabel(TestViewerLrb.get("MODELS")));
        ControlBar controlBar = new ControlBar();
        this.installProfitResultsActions(controlBar);
        this.jProfitToolbar.setControlBar(controlBar);
        this.initializeControls();
        this.jSplitPane.setDividerLocation(0.75);
        this.jSplitPane.setResizeWeight(0.75);
        LoadUI loadUI = new LoadUI(UPDATE_ALL);
        loadUI.start();
    }

    private void enableControls(boolean bl) {
        this.jTargetComb.setEnabled(bl);
        this.jSettingsBtn.setEnabled(bl);
        this.jDetailBtn.setEnabled(bl && this.jResultTable.getSelectedRowCount() > 0);
    }

    private void initializeControls() {
        this.jResultTable.setModel((TableModel)((Object)this._state.getLoadingProfitTableModel()));
        this.jResultTable.setSelectionMode(0);
        this.jTargetComb.setModel(new DefaultComboBoxModel<String>(new String[]{TestViewerLrb.get("LOADING_SHORTENED")}));
        ListSelectionModel listSelectionModel = this.jResultTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ProfitPanel.this.jResultTableValueChanged(listSelectionEvent);
            }
        });
        this.enableControls(false);
    }

    public void jResultTableValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            int[] nArray = this.jResultTable.getSelectedRowsInModel();
            String string = (String)this._state.getProfitTableModel().getValueAt(nArray[0], 0);
            this._state.setSelectedTestResult(string);
            this.enableControls(true);
            this.fireViewPropertySelectionChange(this, string);
        }
    }

    public ProfitTabState.ProfitData getProfitData() {
        String string = this._state.getSelectedTestResult();
        if (string == null) {
            int[] nArray = this.jResultTable.getSelectedRowsInModel();
            if (nArray.length > 0 && -1 != nArray[0]) {
                string = (String)this._state.getProfitTableModel().getValueAt(nArray[0], 0);
                this._state.setSelectedTestResult(string);
            }
            if (string == null) {
                return null;
            }
        }
        int n = this._state.getSelectedQuantileValue();
        ProfitTabState.ProfitData profitData = this._state.getProfitData().get(string).get(n);
        profitData.setLabel(string);
        return profitData;
    }

    private void initComponents() {
        this.jTargetLbl = new JLabel();
        this.jTargetComb = new JComboBox();
        this.jSettingsBtn = new JButton();
        this.jSplitPane = new JSplitPane();
        this.jPanel = new JPanel();
        this.jGraphPanel = new JPanel();
        this.jGraphControl = new JPanel();
        this.jQuantileSlider = new JSlider();
        this.jPanel1 = new JPanel();
        this.jProfitPanel = new TransparentPanel();
        this.jProfitToolbar = new ComponentWithTitlebar();
        this.jTargetLbl.setText("Target Value:");
        this.jTargetComb.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jTargetComb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfitPanel.this.jTargetCombActionPerformed(actionEvent);
            }
        });
        this.jSettingsBtn.setText("Settings...");
        this.jSettingsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfitPanel.this.jSettingsBtnActionPerformed(actionEvent);
            }
        });
        this.jSplitPane.setDividerLocation(400);
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setOneTouchExpandable(true);
        this.jGraphPanel.setLayout(new BorderLayout());
        this.jGraphControl.setLayout(new GridBagLayout());
        this.jQuantileSlider.setName("jQuantileSlider");
        this.jQuantileSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ProfitPanel.this.jQuantileSliderStateChanged(changeEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        this.jGraphControl.add((Component)this.jQuantileSlider, gridBagConstraints);
        GroupLayout groupLayout = new GroupLayout(this.jPanel);
        this.jPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jGraphControl, -1, 652, Short.MAX_VALUE).addComponent(this.jGraphPanel, -1, 652, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jGraphPanel, -1, 370, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jGraphControl, -2, -1, -2)));
        this.jSplitPane.setTopComponent(this.jPanel);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jProfitPanel);
        this.jProfitPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jProfitToolbar, -1, 652, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jProfitToolbar, -1, 89, Short.MAX_VALUE));
        GroupLayout groupLayout3 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jProfitPanel, -1, -1, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jProfitPanel, -1, -1, Short.MAX_VALUE));
        this.jSplitPane.setBottomComponent(this.jPanel1);
        GroupLayout groupLayout4 = new GroupLayout(this);
        this.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, -1, 654, Short.MAX_VALUE).addGroup(groupLayout4.createSequentialGroup().addComponent(this.jTargetLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetComb, 0, 310, Short.MAX_VALUE).addGap(192, 192, 192).addComponent(this.jSettingsBtn, -1, 83, Short.MAX_VALUE))).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLbl).addComponent(this.jSettingsBtn).addComponent(this.jTargetComb, -2, -1, -2)).addGap(14, 14, 14).addComponent(this.jSplitPane, -1, 495, Short.MAX_VALUE).addContainerGap()));
    }

    private void jSettingsBtnActionPerformed(ActionEvent actionEvent) {
        ProfitInputDialog profitInputDialog = new ProfitInputDialog(this._state);
        if (profitInputDialog.invoke()) {
            this._loading = true;
            this.enableControls(false);
            LoadUI loadUI = new LoadUI(UPDATE_GRAPH);
            loadUI.start();
        }
    }

    private void jTargetCombActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        this._state.setSelectedTargetValue((String)this.jTargetComb.getSelectedItem());
        this._loading = true;
        this.jGraphPanel.removeAll();
        this.jGraphPanel.add((Component)new JTextArea(TestViewerLrb.get("LOADING_SHORTENED")), "Center");
        this.jResultTable.setModel((TableModel)((Object)this._state.getLoadingProfitTableModel()));
        this.enableControls(false);
        LoadUI loadUI = new LoadUI(UPDATE_GRAPH);
        loadUI.start();
    }

    private void jQuantileSliderStateChanged(ChangeEvent changeEvent) {
        if (this._loading) {
            return;
        }
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (jSlider.getValueIsAdjusting()) {
            return;
        }
        BoundedRangeModel boundedRangeModel = this.jQuantileSlider.getModel();
        Integer n = boundedRangeModel.getValue();
        n = Math.max(1, n);
        this._state.setSelectedQuantileValue(n);
        this._loading = true;
        this.enableControls(false);
        LoadUI loadUI = new LoadUI(UPDATE_THRESHOLD);
        loadUI.start();
    }

    private void installProfitResultsActions(ControlBar controlBar) {
        Class<AbstractTestEditor> clazz = AbstractTestEditor.class;
        _detailBtnIconEna = OracleIcons.getIcon((String)"lov.png");
        _detailBtnIconDis = OracleIcons.getIcon((String)"lov.png");
        this.jDetailBtn = new JButton(_detailBtnIconEna);
        this.jDetailBtn.setDisabledIcon(_detailBtnIconDis);
        this.jDetailBtn.setToolTipText(TestViewerLrb.get("PROFIT_DETAIL_DIALOG"));
        this.jDetailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfitPanel.this.jDetailBtnActionPerformed(actionEvent);
            }
        });
        controlBar.add((Component)this.jDetailBtn);
        if (this._state.getParentTestViewerState().getAllTestResults().size() > 1) {
            _jIC_UpdateENA = UIResourceHelper.getImageIcon(clazz, TestViewerLrb.get("ADD_REMOVE_BTN_ICON_ENA"));
            _jIC_UpdateDIS = UIResourceHelper.getImageIcon(clazz, TestViewerLrb.get("ADD_REMOVE_BTN_ICON_DIS"));
            this._jBT_AddOrRemove = new JButton(_jIC_UpdateENA);
            this._jBT_AddOrRemove.setDisabledIcon(_jIC_UpdateDIS);
            this._jBT_AddOrRemove.setToolTipText(DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TITLE"));
            this._jBT_AddOrRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ProfitPanel.this._jBT_Compare_AddOrRemove_actionPerformed(actionEvent);
                }
            });
            controlBar.add((Component)this._jBT_AddOrRemove);
        }
    }

    private void _jBT_Compare_AddOrRemove_actionPerformed(ActionEvent actionEvent) {
        CompareTestResultsFlatDialog compareTestResultsFlatDialog = new CompareTestResultsFlatDialog();
        if (compareTestResultsFlatDialog.invoke(this._state.getParentTestViewerState(), this._state.getParentTestViewerState().getContext(), this._state.getParentTestViewerState().getParentActivity(), this._state.getParentTestViewerState().getAllTestResults(), this._state.getParentTestViewerState().getTestResults())) {
            List list = (List)compareTestResultsFlatDialog.getUserObject();
            this._state.getParentTestViewerState().setTestResults(list);
            this.jGraphPanel.removeAll();
            this.jGraphPanel.add((Component)new JTextArea(TestViewerLrb.get("LOADING_SHORTENED")), "Center");
            this.jResultTable.setModel((TableModel)((Object)this._state.getLoadingProfitTableModel()));
            this.enableControls(false);
            LoadUI loadUI = new LoadUI(UPDATE_ALL);
            loadUI.start();
        }
    }

    private void jDetailBtnActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.jResultTable.getSelectedRowsInModel();
        String string = (String)this._state.getProfitTableModel().getValueAt(nArray[0], 0);
        ProfitDetailDialog profitDetailDialog = new ProfitDetailDialog(string, this._state, this._state.getProfitData().get(string));
        if (profitDetailDialog.invoke()) {
            // empty if block
        }
    }

    public void setCachedPropertyState(Object object) {
    }

    public Object getCachedPropertyState() {
        return this._state;
    }

    class CustomGenericTable
    extends GenericTableFixedColumns {
        private DateFormat _df = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        private Preferences _p = Preferences.getPreferences();
        private ModelViewerPreferenceSettings _prefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)this._p);
        private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._prefenceSettings.getPercentagePrecisionLevel(), 0, 0);
        private NumberFormat _numericalFormat = NumericFormat.getInstance(true, this._prefenceSettings.getNumericalPrecisionLevel(), 0, 0);

        CustomGenericTable() {
            this._percentageFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
            this._percentageFormat.setMinimumIntegerDigits(1);
            this._numericalFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
            this._numericalFormat.setMinimumIntegerDigits(1);
        }

        @Override
        public void addDynamicCellRenderers() {
            NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
            this.addCellRenderer(ProfitPanel.this._state.getProfitTableModel().getColumnName(0), new CustomCellRenderer());
            this.addCellRenderer(ProfitPanel.this._state.getProfitTableModel().getColumnName(1), numberCellRenderer);
            this.addCellRenderer(ProfitPanel.this._state.getProfitTableModel().getColumnName(2), numberCellRenderer);
            this.addCellRenderer(ProfitPanel.this._state.getProfitTableModel().getColumnName(3), numberCellRenderer);
            this.addCellRenderer(ProfitPanel.this._state.getProfitTableModel().getColumnName(4), numberCellRenderer);
            this.addCellRenderer(ProfitPanel.this._state.getProfitTableModel().getColumnName(5), numberCellRenderer);
            this.addCellRenderer(ProfitPanel.this._state.getProfitTableModel().getColumnName(6), numberCellRenderer);
            this.addCellRenderer(ProfitPanel.this._state.getProfitTableModel().getColumnName(8), new DateCellRenderer2());
        }

        private String formatCellValue(Object object) {
            String string = null;
            if (object != null) {
                string = object instanceof Double ? this._percentageFormat.format((Double)object) : (object instanceof Integer ? this._numericalFormat.format(((Integer)object).intValue()) : (object instanceof BigDecimal ? this._numericalFormat.format(((BigDecimal)object).doubleValue()) : (object instanceof Date ? this._df.format(object) : object.toString())));
            }
            return string;
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = "";
            string = this.formatCellValue(object);
            return string;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string = "";
            Object object = null;
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            if (n == -1 || n2 == -1) {
                return null;
            }
            object = this.getValueAt(n, n2);
            string = this.formatCellValue(object);
            return string;
        }
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!(object instanceof String)) assert (false);
            String string = (String)object;
            Color color = ProfitPanel.this._state.getParentTestViewerState().getTestResultGraphColor(string);
            this.setIcon((Icon)new ColorIcon(color));
            return component;
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        String _updatemode;

        public LoadUI(String string) {
            this._updatemode = string;
        }

        public LoadUI() {
            this._updatemode = ProfitPanel.UPDATE_ALL;
        }

        public Object construct() {
            try {
                if (this._updatemode.equals(ProfitPanel.UPDATE_THRESHOLD)) {
                    ProfitPanel.this._state.refreshCustomThresholdData();
                    ProfitPanel.this._graphPanel.refreshGraph();
                } else if (this._updatemode.equals(ProfitPanel.UPDATE_GRAPH)) {
                    ProfitPanel.this.jGraphPanel.removeAll();
                    ProfitPanel.this.jGraphPanel.add((Component)new JTextArea(TestViewerLrb.get("LOADING_SHORTENED")), "Center");
                    ProfitPanel.this.jResultTable.setModel((TableModel)((Object)ProfitPanel.this._state.getLoadingProfitTableModel()));
                    ProfitPanel.this._state.refreshProfitData();
                    ProfitPanel.this._graphPanel.initGraph(ProfitPanel.this._state.getProfitGraphModel());
                } else {
                    ProfitPanel.this.jGraphPanel.removeAll();
                    ProfitPanel.this.jGraphPanel.add((Component)new JTextArea(TestViewerLrb.get("LOADING_SHORTENED")), "Center");
                    ProfitPanel.this.jResultTable.setModel((TableModel)((Object)ProfitPanel.this._state.getLoadingProfitTableModel()));
                    ProfitPanel.this._state.load();
                    ProfitPanel.this._graphPanel.initGraph(ProfitPanel.this._state.getProfitGraphModel());
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return ProfitPanel.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            int n = 1;
            try {
                if (this._success && this._ex == null) {
                    Object object;
                    ProfitPanel.this.jGraphPanel.removeAll();
                    ProfitPanel.this.jGraphPanel.add((Component)ProfitPanel.this._graphPanel, "Center");
                    ProfitPanel.this.jGraphPanel.updateUI();
                    String string = ProfitPanel.this._state.getSelectedTestResult();
                    ProfitPanel.this.jResultTable.setFixedColumnCount(n);
                    ProfitPanel.this.jResultTable.setModel((TableModel)((Object)ProfitPanel.this._state.getProfitTableModel()));
                    String string2 = ProfitPanel.this._state.getProfitTableModel().getColumnName(0);
                    ProfitPanel.this.jResultTable.setFixedColumnPreferredWidth(string2, 165);
                    ProfitPanel.this.jResultTable.findOrCreateTableRowHeader(ProfitPanel.this.tscroller);
                    ProfitPanel.this.jResultTable.setSorted(true);
                    ProfitPanel.this.jResultTable.setAutoResizeMode(0);
                    ProfitPanel.this.jResultTable.addDynamicCellRenderers();
                    TableColumnModel tableColumnModel = ProfitPanel.this.jResultTable.getColumnModel();
                    tableColumnModel.getColumn(1 - n).setPreferredWidth(60);
                    tableColumnModel.getColumn(2 - n).setPreferredWidth(60);
                    tableColumnModel.getColumn(3 - n).setPreferredWidth(140);
                    tableColumnModel.getColumn(4 - n).setPreferredWidth(160);
                    tableColumnModel.getColumn(5 - n).setPreferredWidth(80);
                    tableColumnModel.getColumn(6 - n).setPreferredWidth(150);
                    tableColumnModel.getColumn(7 - n).setPreferredWidth(135);
                    tableColumnModel.getColumn(8 - n).setPreferredWidth(135);
                    ProfitPanel.this.jResultTable.setSelectionMode(0);
                    ProfitPanel.this.jResultTable.setColumnSelectorAvailable(true);
                    ProfitPanel.this.jResultTable.setShowToolTips(true);
                    ProfitPanel.this.jResultTable.setSortRetainsSelection(true);
                    ProfitPanel.this.jResultTable.setRowSelectionAllowed(true);
                    ProfitPanel.this.jResultTable.setCellRenderers();
                    ProfitPanel.this.jResultTable.setRowHeaderCellRenderers();
                    int n2 = 0;
                    if (string == null) {
                        double d = 0.0;
                        double d2 = 0.0;
                        for (int i = 0; i < ProfitPanel.this.jResultTable.getRowCount(); ++i) {
                            d = (Double)ProfitPanel.this._state.getProfitTableModel().getValueAt(i, 5);
                            if (!(d2 < d)) continue;
                            d2 = d;
                            n2 = i;
                        }
                    } else {
                        for (int i = 0; i < ProfitPanel.this.jResultTable.getRowCount(); ++i) {
                            object = ProfitPanel.this._state.getProfitTableModel().getValueAt(i, 0);
                            if (!string.equals(object)) continue;
                            n2 = i;
                        }
                    }
                    ProfitPanel.this.jResultTable.setRowSelectionInterval(n2, n2);
                    if (this._updatemode.equals(ProfitPanel.UPDATE_ALL)) {
                        ProfitPanel.this.jTargetComb.setModel(new DefaultComboBoxModel<String>(ProfitPanel.this._state.getTargetValues()));
                        ProfitPanel.this.jTargetComb.setSelectedItem(ProfitPanel.this._state.getSelectedTargetValue());
                        Integer n3 = new Integer(ProfitPanel.this._state.getSelectedQuantileValue());
                        object = new Integer(0);
                        Integer n4 = new Integer(ProfitPanel.this._state.getMaxQuantileCnt() - 1);
                        ProfitPanel.this.jQuantileSlider.setMajorTickSpacing(10);
                        ProfitPanel.this.jQuantileSlider.setMinorTickSpacing(1);
                        ProfitPanel.this.jQuantileSlider.setPaintTicks(true);
                        ProfitPanel.this.jQuantileSlider.setPaintLabels(true);
                        ProfitPanel.this.jQuantileSlider.setSnapToTicks(true);
                        ProfitPanel.this.jQuantileSlider.setModel(new DefaultBoundedRangeModel(n3, 0, (Integer)object, n4));
                    }
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), null, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
                }
                ProfitPanel.this.enableControls(true);
                ProfitPanel.this.getEditor().updateSelection();
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                ProfitPanel.this._loading = false;
            }
        }
    }
}

