/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.profit;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewEvent;
import oracle.dmt.dataminer.DataMinerViewListener;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.BaseCostMatrixDataProvider;
import oracle.dmt.dataminer.controls.BaseCostMatrixTable;
import oracle.dmt.dataminer.controls.BaseCostMatrixTableModel;
import oracle.dmt.dataminer.controls.CostMatrixInfo;
import oracle.dmt.dataminer.controls.RowColumnValue;
import oracle.dmt.dataminer.generated.server.ODMRPkg_Activity;
import oracle.dmt.dataminer.generated.server.OdmrCostMatrix;
import oracle.dmt.dataminer.generated.server.OdmrCostMatrixDetail;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.Model;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.profit.ProfitTabState;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;

public class CostMatrixPanel
extends JPanel
implements DataminerGUIPanel,
DataMinerViewListener {
    private boolean _loaded;
    private ProfitTabState _state;
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private static final String _confirmMsg = "Profit-ApplyCostMatrixToModel";
    private JButton jApplyCostMatrixBtn;
    private JLabel jLabel1;
    private JLabel jMatrixLbl;
    private GenericTable jMatrixTable;
    private JScrollPane jScrollPane;

    public CostMatrixPanel(Object object) {
        this._state = (ProfitTabState)object;
        this.initComponents();
        this.initRes();
        this.initUI();
        this.setupUIDetail();
    }

    private void initComponents() {
        this.jMatrixLbl = new JLabel();
        this.jScrollPane = new JScrollPane();
        this.jMatrixTable = new BaseCostMatrixTable();
        this.jApplyCostMatrixBtn = new JButton();
        this.jLabel1 = new JLabel();
        this.jMatrixLbl.setText("Performance Matrix ");
        this.jMatrixTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jMatrixTable.setRowSelectionAllowed(false);
        this.jMatrixTable.setShowHorizontalLines(true);
        this.jMatrixTable.setShowVerticalLines(true);
        this.jScrollPane.setViewportView((Component)this.jMatrixTable);
        this.jApplyCostMatrixBtn.setText("Apply Derived Cost Matrix to Model");
        this.jApplyCostMatrixBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CostMatrixPanel.this.jApplyCostMatrixBtnActionPerformed(actionEvent);
            }
        });
        this.jLabel1.setText("Rows: Actual; Columns: Predicted");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jMatrixLbl, -1, 110, Short.MAX_VALUE).addGap(91, 91, 91)).addComponent(this.jScrollPane, -1, 201, Short.MAX_VALUE).addComponent(this.jLabel1).addComponent(this.jApplyCostMatrixBtn, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jMatrixLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(14, 14, 14).addComponent(this.jApplyCostMatrixBtn).addContainerGap(-1, Short.MAX_VALUE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jApplyCostMatrixBtnActionPerformed(ActionEvent actionEvent) {
        if (!MessageDialog.optionalConfirm((String)_confirmMsg, (Component)Ide.getMainWindow(), (String)TestViewerLrb.get("APPLY_COST_MATRIX_CONFIRMATION"), (String)TestViewerLrb.get("APPLY_COST_MATRIX_BTN"), (String)"")) {
            return;
        }
        String string = this._state.getSelectedTestResult();
        int n = 0;
        ProfitTabState.ProfitData profitData = this._state.getProfitData().get(string).get(this._state.getSelectedQuantileValue());
        double d = profitData._threshold;
        this._state.setCustomThresholdValue(d);
        double d2 = 1.0E-6f;
        double d3 = d - d2 < 0.0 ? d : d - d2;
        double d4 = (1.0 - d3) / d3;
        String string2 = null;
        String string3 = null;
        string2 = this._state.getSelectedTargetValue();
        Vector<String> vector = this._state.getTargetValues();
        string3 = vector.firstElement().equals(string2) ? vector.lastElement() : vector.firstElement();
        Vector<RowColumnValue> vector2 = new Vector<RowColumnValue>();
        vector2.add(new RowColumnValue(string2, string2, new BigDecimal(0.0)));
        vector2.add(new RowColumnValue(string3, string2, new BigDecimal(1.0)));
        vector2.add(new RowColumnValue(string2, string3, new BigDecimal(d4)));
        vector2.add(new RowColumnValue(string3, string3, new BigDecimal(0.0)));
        CostMatrixInfo costMatrixInfo = Model.getROCCostBenefit(vector2);
        Connection connection = null;
        ODMRPkg_Activity oDMRPkg_Activity = null;
        try {
            connection = Connections.getUniqueConnection(this._state.getContext());
            oDMRPkg_Activity = new ODMRPkg_Activity(connection);
            OdmrCostMatrixDetail[] odmrCostMatrixDetailArray = new OdmrCostMatrixDetail[costMatrixInfo.getRowCount() * costMatrixInfo.geColumnCount()];
            n = 0;
            for (int i = 0; i < costMatrixInfo.getRowCount(); ++i) {
                for (int j = 0; j < costMatrixInfo.geColumnCount(); ++j) {
                    RowColumnValue rowColumnValue = costMatrixInfo.getRowColumnValue(i, j);
                    if (rowColumnValue._row instanceof String) {
                        odmrCostMatrixDetailArray[n++] = new OdmrCostMatrixDetail((String)rowColumnValue._row, null, (String)rowColumnValue._col, null, rowColumnValue._value);
                        continue;
                    }
                    if (!(rowColumnValue._row instanceof BigDecimal)) continue;
                    odmrCostMatrixDetailArray[n++] = new OdmrCostMatrixDetail(null, (BigDecimal)rowColumnValue._row, null, (BigDecimal)rowColumnValue._col, rowColumnValue._value);
                }
            }
            OdmrCostMatrix odmrCostMatrix = new OdmrCostMatrix(odmrCostMatrixDetailArray);
            BigDecimal bigDecimal = this._state.getSelectedTestResultObj().getParentId();
            oDMRPkg_Activity.setModelCostBenefit2(bigDecimal, odmrCostMatrix);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void enableAllControls(boolean bl) {
        this.jApplyCostMatrixBtn.setVisible(false);
        this.jApplyCostMatrixBtn.setEnabled(false);
    }

    @Override
    public void viewPropertySelectionChange(DataMinerViewEvent dataMinerViewEvent) {
        if (dataMinerViewEvent.getAction() == "PROPERTY_SELECTION_EVENT") {
            this.loadConfusionMatrix();
        }
    }

    private void loadConfusionMatrix() {
        String string = this._state.getSelectedTestResult();
        ProfitTabState.ProfitData profitData = null;
        String string2 = null;
        String string3 = null;
        if (string != null) {
            profitData = this._state.getProfitData().get(string).get(this._state.getSelectedQuantileValue());
            string2 = this._state.getSelectedTargetValue();
            Vector<String> vector = this._state.getTargetValues();
            string3 = vector.size() == 2 ? (vector.firstElement().equals(string2) ? vector.lastElement() : vector.firstElement()) : TestViewerLrb.get("OTHER_TARGETS");
        }
        ((BaseCostMatrixTable)this.jMatrixTable).setModel(new PerformanceMatrixModel(new PerformanceMatrixDataProvider(this._state.getSelectedTargetValue(), string3, profitData)));
    }

    private void loadState() {
        this.loadConfusionMatrix();
    }

    private void setupUIDetail() {
        this.loadState();
        this.enableAllControls(true);
        this.setLoaded(true);
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    private void setLoaded(boolean bl) {
        this._loaded = bl;
    }

    @Override
    public void initUI() {
        this.enableAllControls(false);
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jMatrixLbl, (Component)this.jMatrixTable, (String)TestViewerLrb.get("PERFORMANCE_MATRIX_VALUE"));
        this.jMatrixLbl.getAccessibleContext().setAccessibleName(TestViewerLrb.get("PERFORMANCE_MATRIX_VALUE"));
        this.jMatrixLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("PERFORMANCE_MATRIX_VALUE_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jApplyCostMatrixBtn, (String)TestViewerLrb.get("APPLY_COST_MATRIX_BTN"));
        this.jApplyCostMatrixBtn.getAccessibleContext().setAccessibleName(TestViewerLrb.get("APPLY_COST_MATRIX_BTN"));
        this.jApplyCostMatrixBtn.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("APPLY_COST_MATRIX_BTN_ADA"));
    }

    @Override
    public void viewReady(DataMinerViewEvent dataMinerViewEvent) {
    }

    @Override
    public void viewBusy(DataMinerViewEvent dataMinerViewEvent) {
    }

    class PerformanceMatrixModel
    extends BaseCostMatrixTableModel {
        public PerformanceMatrixModel(PerformanceMatrixDataProvider performanceMatrixDataProvider) {
            super(performanceMatrixDataProvider);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return super.getValueAt(n, n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }

    private class PerformanceMatrixDataProvider
    implements BaseCostMatrixDataProvider {
        private String _positiveTarget;
        private String _otherTarget;
        private ProfitTabState.ProfitData _data;

        PerformanceMatrixDataProvider(String string, String string2, ProfitTabState.ProfitData profitData) {
            this._positiveTarget = string == null ? "" : string;
            this._otherTarget = string2 == null ? "" : string2;
            this._data = profitData;
        }

        @Override
        public Object[] getTargetValues() {
            return new Object[]{this._positiveTarget, this._otherTarget};
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this._data == null) {
                return null;
            }
            if (n == 0 && n2 == 0) {
                return CostMatrixPanel.this._percentageFormat.format(this._data._targetCum);
            }
            if (n == 0 && n2 == 1) {
                return CostMatrixPanel.this._percentageFormat.format(this._data._nonTargetCum);
            }
            if (n == 1 && n2 == 0) {
                return CostMatrixPanel.this._percentageFormat.format(0.0);
            }
            if (n == 1 && n2 == 1) {
                return CostMatrixPanel.this._percentageFormat.format(0.0);
            }
            return "Undefined";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }
}

