/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.lift;

import java.awt.Color;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.dialog.test.TuneState;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.Context;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;

public class LiftTabState {
    private SharedTestEditorState _parentTestViewerState;
    private Context _context;
    private List<TestResult> _testResults;
    private Vector<String> _targetValues;
    private String _selectedTargetValue;
    private String _selectedTestResult;
    private HashMap<String, Map<String, List<LiftData>>> _liftdata;
    public static final String DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES = "DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES";
    public static final String DISPLAY_OPTION_CUMULATIVE_LIFT = "DISPLAY_OPTION_CUMULATIVE_LIFT";
    private String _selectedDisplayOption;
    private int _selectedQuantileValue;
    private double _customThresholdValue;
    private LiftTableModel _liftTableModel;
    private DefaultGraphDataModel _liftGraphModel;
    private int _thresholdSeries;
    private double _maxCumLift;
    private int _maxQuantileCnt;
    private int _numPosTargets;
    private int _totNumRows;

    public SharedTestEditorState getParentTestViewerState() {
        return this._parentTestViewerState;
    }

    public LiftTabState(SharedTestEditorState sharedTestEditorState, Context context) {
        this._parentTestViewerState = sharedTestEditorState;
        this._context = context;
        this._targetValues = new Vector();
        this._liftdata = new HashMap();
        this._selectedDisplayOption = DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES;
        this._selectedQuantileValue = 20;
        this._liftTableModel = null;
        this._testResults = this._parentTestViewerState.getTestResults();
        this._liftGraphModel = new DefaultGraphDataModel(null, 61, null, null, null);
    }

    public void load() throws Exception {
        Connection connection = Connections.getUniqueConnection(this._context);
        this._targetValues.clear();
        this._testResults = this._parentTestViewerState.getTestResults();
        try {
            this.setSelectedDisplayOption(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES);
            for (TestResult testResult : this._testResults) {
                Vector<String> vector = ((ClassTestResult)testResult).getTargetValues();
                for (String string : vector) {
                    if (this._targetValues.contains(string)) continue;
                    this._targetValues.add(string);
                }
            }
            Object object = ((ClassTestResult)this._testResults.get(0)).getLeastTargetValue();
            if (object == null) {
                object = this._targetValues.get(0);
            }
            this.setSelectedTargetValue((String)object);
            this.loadLiftData(connection);
            this.loadLiftGraph();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw sQLException;
        }
        finally {
            connection.close();
        }
    }

    public void refreshLiftData() throws Exception {
        Connection connection = Connections.getUniqueConnection(this._context);
        try {
            this.loadLiftData(connection);
            this.loadLiftGraph();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw sQLException;
        }
        finally {
            connection.close();
        }
    }

    private void loadLiftData(Connection connection) throws Exception {
        String string = this.getSelectedTargetValue();
        SQLHelper sQLHelper = new SQLHelper();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        TreeMap<String, List<LiftData>> treeMap = new TreeMap<String, List<LiftData>>();
        try {
            String string2 = ((ClassTestResult)this._testResults.get(0)).getPerformanceMatrixTable();
            String string3 = Connections.getUserAccountName(this._context);
            String string4 = "SELECT METRIC_VARCHAR_VALUE FROM " + string2 + " where METRIC_NAME = 'MODEL_SCHEMA'";
            sQLHelper.pstmt = connection.prepareStatement(string4);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                string3 = sQLHelper.rs.getString("METRIC_VARCHAR_VALUE");
            }
            String string5 = "WITH target as (SELECT metric_varchar_value target_attr FROM " + string2 + " where metric_name = 'TARGET_ATTRIBUTE'), " + "model as (SELECT replace(metric_varchar_value,'\"') model_name FROM " + string2 + " where metric_name = 'MODEL_NAME') " + "SELECT a.data_type FROM all_mining_model_attributes a, target b, model c  " + "WHERE a.owner = '" + string3 + "' AND a.model_name = c.model_name AND a.attribute_name = b.target_attr";
            sQLHelper.pstmt = connection.prepareStatement(string5);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            String string6 = "VARCHAR2";
            if (sQLHelper.rs.next()) {
                string6 = sQLHelper.rs.getString("data_type");
            }
            String string7 = ((ClassTestResult)this._testResults.get(0)).getConfusionMatrixTable();
            String string8 = "WITH pos as (SELECT sum(value) numPosTargets FROM " + string7 + " WHERE actual_target_value = :1), " + "tot as (SELECT sum(value) totNumRows FROM " + string7 + ") " + "SELECT numPosTargets, totNumRows FROM pos, tot";
            sQLHelper.pstmt = connection.prepareStatement(string8);
            if (string6.equals("NUMBER")) {
                sQLHelper.pstmt.setDouble(1, Double.parseDouble(string));
            } else {
                sQLHelper.pstmt.setString(1, string);
            }
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                this._numPosTargets = sQLHelper.rs.getInt("numPosTargets");
                this._totNumRows = sQLHelper.rs.getInt("totNumRows");
            }
            sQLHelper.close();
            for (TestResult testResult : this._testResults) {
                Object object;
                List<LiftData> list;
                String string9 = ((ClassTestResult)testResult).geLiftResultTable(string);
                if (string9 == null) continue;
                String string10 = testResult.toString();
                Map<String, List<LiftData>> map = this._liftdata.get(string);
                if (map == null) {
                    map = new HashMap<String, List<LiftData>>();
                    this._liftdata.put(string, map);
                }
                if ((list = map.get(string10)) == null) {
                    list = new ArrayList<LiftData>();
                    d = 0.0;
                    d2 = 0.0;
                    object = "SELECT * FROM " + string9 + " ORDER BY QUANTILE_NUMBER";
                    sQLHelper.pstmt = connection.prepareStatement((String)object);
                    sQLHelper.pstmt.setFetchSize(100);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    int n4 = 0;
                    LiftData liftData = null;
                    while (sQLHelper.rs.next()) {
                        double d4;
                        n4 = sQLHelper.rs.getInt("QUANTILE_NUMBER");
                        try {
                            d4 = sQLHelper.rs.getDouble("PROBABILITY_THRESHOLD");
                        }
                        catch (SQLException sQLException) {
                            d4 = sQLHelper.rs.getDouble("COST_THRESHOLD");
                        }
                        double d5 = sQLHelper.rs.getDouble("GAIN_CUMULATIVE");
                        int n5 = sQLHelper.rs.getInt("QUANTILE_TOTAL_COUNT");
                        double d6 = sQLHelper.rs.getDouble("QUANTILE_TARGET_COUNT");
                        double d7 = sQLHelper.rs.getDouble("PERCENTAGE_RECORDS_CUMULATIVE");
                        double d8 = sQLHelper.rs.getDouble("LIFT_CUMULATIVE");
                        double d9 = sQLHelper.rs.getDouble("TARGET_DENSITY_CUMULATIVE");
                        double d10 = sQLHelper.rs.getDouble("TARGETS_CUMULATIVE");
                        double d11 = sQLHelper.rs.getDouble("NON_TARGETS_CUMULATIVE");
                        double d12 = sQLHelper.rs.getDouble("LIFT_QUANTILE");
                        double d13 = sQLHelper.rs.getDouble("TARGET_DENSITY");
                        d3 += (double)n5;
                        if (n3 == 0) {
                            if (d3 > (double)this._numPosTargets && n4 > 0) {
                                n3 = n4 - 1;
                            } else if (d3 == (double)this._numPosTargets) {
                                n3 = n4;
                            }
                        }
                        liftData = new LiftData(new Integer(n4), new Double(d4), new Double(d5), new Integer(n5), new Double(d6), new Double(d7), new Double(d8), new Double(d9), new Double(d10), new Double(d11), new Double(d12), new Double(d13), testResult.getMiningAlgorithm(), testResult.getCreationTime());
                        if (d < d5) {
                            d = d5;
                            n = n4;
                        }
                        if (d2 < d8) {
                            d2 = d8;
                            n2 = n4;
                        }
                        list.add(liftData);
                    }
                    while (n4 < 100) {
                        LiftData liftData2 = new LiftData(new Integer(++n4), new Double(liftData._threshold), new Double(liftData._gainCum), new Integer(liftData._quantileTotalCnt), new Double(liftData._quantileTargetCnt), new Double(liftData._percentRecordsCum / 100.0), new Double(liftData._liftCum), new Double(liftData._targetDensityCum), new Double(liftData._targetCum), new Double(liftData._nonTargetCum), new Double(liftData._liftQuantile), new Double(liftData._targetDensity), liftData._algorithm, liftData._creation_date);
                        list.add(liftData2);
                    }
                    LiftData liftData3 = new LiftData(new Integer(n4), new Double(0.0), new Double(0.0), new Integer(n), new Double(n2), new Double(0.0), new Double(list.get((int)1)._liftCum), new Double(d), new Double(d2), new Double(0.0), new Double(0.0), new Double(0.0), null, null);
                    liftData3._idealQuantile = Math.max(1, n3);
                    list.add(0, liftData3);
                    map.put(string10, list);
                }
                object = map.get(string10);
                treeMap.put(string10, (List<LiftData>)object);
            }
            TuneState tuneState = (TuneState)this._context.getProperty("TUNE_STATE");
            this._liftTableModel = tuneState == null ? new LiftTableModel(treeMap) : new LiftTuneTableModel(tuneState, treeMap);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
    }

    private void loadLiftGraph() {
        TestResult testResult;
        List<LiftData> list;
        double d;
        double d2;
        Map<String, List<LiftData>> map = this._liftdata.get(this.getSelectedTargetValue());
        this._liftGraphModel.clear();
        this._maxCumLift = 0.0;
        this._maxQuantileCnt = 0;
        ArrayList<Color> arrayList = new ArrayList<Color>();
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        for (TestResult testResult2 : this._testResults) {
            String string = testResult2.toString();
            List<LiftData> object = map.get(string);
            if (object == null) continue;
            int d22 = object.size();
            if (this._maxQuantileCnt < d22) {
                this._maxQuantileCnt = d22;
            }
            int n3 = object.get((int)0)._idealQuantile;
            n2 = Math.min(n2, n3);
            ++n;
        }
        Object[][] objectArray = new Object[this._maxQuantileCnt * 2][n + (n == 1 ? 3 : 3)];
        Object[] objectArray2 = new Object[n + (n == 1 ? 3 : 3)];
        Object[] objectArray3 = new Object[n + (n == 1 ? 3 : 3)];
        int n5 = 0;
        int n6 = 0;
        for (TestResult testResult2 : this._testResults) {
            String string = testResult2.toString();
            List<LiftData> list2 = map.get(string);
            if (list2 == null) continue;
            n6 = 0;
            for (int i = 0; i < list2.size(); ++i) {
                objectArray[n6++][n5] = new Double(i);
                if (this._selectedDisplayOption.equals(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES)) {
                    objectArray[n6++][n5] = list2.get((int)i)._gainCum;
                    continue;
                }
                objectArray[n6++][n5] = list2.get((int)i)._liftCum;
                this._maxCumLift = (double)this._totNumRows / (double)this._numPosTargets;
            }
            if (list2.get((int)0)._targetCum > this._maxCumLift) {
                this._maxCumLift = list2.get((int)0)._targetCum;
            }
            objectArray2[n5] = "Lift: " + string;
            objectArray3[n5] = 0;
            ++n5;
            Color d4 = this._parentTestViewerState.getTestResultGraphColor(string);
            arrayList.add(d4);
        }
        n6 = 0;
        double d3 = new Double(this._selectedQuantileValue);
        double d4 = new Double(this._selectedQuantileValue);
        if (this._selectedDisplayOption.equals(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES)) {
            d2 = new Double(0.0);
            d = new Double(1.0);
        } else {
            d2 = new Double(0.0);
            d = new Double(this._maxCumLift);
        }
        objectArray[n6++][n5] = d3;
        objectArray[n6++][n5] = d2;
        objectArray[n6++][n5] = d4;
        objectArray[n6++][n5] = d;
        objectArray2[n5] = TestViewerLrb.get("LIFT_GRAPH_DATA_THRESHOLD");
        objectArray3[n5] = 0;
        this._thresholdSeries = n5++;
        n6 = 0;
        d3 = new Double(0.0);
        d4 = new Double(this._maxQuantileCnt - 1);
        if (this._selectedDisplayOption.equals(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES)) {
            d2 = new Double(0.0);
            d = new Double(1.0);
        } else {
            d2 = new Double(1.0);
            d = new Double(1.0);
        }
        objectArray[n6++][n5] = d3;
        objectArray[n6++][n5] = d2;
        objectArray[n6++][n5] = d4;
        objectArray[n6++][n5] = d;
        objectArray2[n5] = TestViewerLrb.get("LIFT_GRAPH_DATA_RANDOM");
        objectArray3[n5] = 0;
        ++n5;
        n6 = 0;
        String string = null;
        Iterator<TestResult> iterator = this._testResults.iterator();
        while (iterator.hasNext() && (list = map.get(string = (testResult = iterator.next()).toString())) == null) {
        }
        if (this._selectedDisplayOption.equals(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES)) {
            objectArray[n6++][n5] = new Double(0.0);
            objectArray[n6++][n5] = new Double(0.0);
            objectArray[n6++][n5] = new Double(n2);
            objectArray[n6++][n5] = new Double(1.0);
            objectArray[n6++][n5] = new Double(this._maxQuantileCnt - 1);
            objectArray[n6++][n5] = new Double(1.0);
        } else {
            objectArray[n6++][n5] = new Double(0.0);
            objectArray[n6++][n5] = new Double((double)this._totNumRows / (double)this._numPosTargets);
            objectArray[n6++][n5] = new Double(n2);
            objectArray[n6++][n5] = new Double((double)this._totNumRows / (double)this._numPosTargets);
            objectArray[n6++][n5] = new Double(n2);
            objectArray[n6++][n5] = new Double(1.0);
            objectArray[n6++][n5] = new Double(this._maxQuantileCnt - 1);
            objectArray[n6++][n5] = new Double(1.0);
        }
        objectArray2[n5] = TestViewerLrb.get("LIFT_GRAPH_DATA_IDEAL");
        objectArray3[n5] = 0;
        this._liftGraphModel.addRowLabels(objectArray2);
        this._liftGraphModel.addRowMarkerShapes(objectArray3);
        this._liftGraphModel.addGraphData(objectArray);
        this._liftGraphModel.setLegendVisible(true);
        this._liftGraphModel.setLegendSeriesStart(n);
        this._liftGraphModel.setLegendSeriesCount(n == 1 ? 3 : 3);
        Object[] objectArray4 = new Object[this._maxQuantileCnt * 2];
        for (int i = 0; i < objectArray4.length; ++i) {
            objectArray4[i] = "";
        }
        this._liftGraphModel.addColumnLabels(objectArray4);
        arrayList.add(SharedTestEditorState.LIFT_QUANTILE_LINE);
        arrayList.add(SharedTestEditorState.LIFT_RANDOM_LINE);
        arrayList.add(SharedTestEditorState.LIFT_IDEAL_LINE);
        this._liftGraphModel.addRowColors(arrayList.toArray(new Color[0]));
        this._liftGraphModel.setX1(TestViewerLrb.get("QUANTILE"), this._maxQuantileCnt - 1);
        if (this._selectedDisplayOption.equals(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES)) {
            this._liftGraphModel.setY1(TestViewerLrb.get("CUMULATIVE_POSITIVE_CASES"), 0.0, 1.0);
        } else {
            this._liftGraphModel.setY1(TestViewerLrb.get("CUMULATIVE_LIFT"), 0.0, this._maxCumLift);
        }
    }

    public void refreshCustomThresholdData() {
        double d;
        double d2;
        Object[][] objectArray = this._liftGraphModel.getGraphData();
        this._liftGraphModel.clearGraphData();
        int n = 0;
        double d3 = new Double(this.getSelectedQuantileValue());
        double d4 = new Double(this.getSelectedQuantileValue());
        if (this._selectedDisplayOption.equals(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES)) {
            d2 = new Double(0.0);
            d = new Double(1.0);
        } else {
            d2 = new Double(0.0);
            d = new Double(this._maxCumLift);
        }
        objectArray[n++][this._thresholdSeries] = d3;
        objectArray[n++][this._thresholdSeries] = d2;
        objectArray[n++][this._thresholdSeries] = d4;
        objectArray[n][this._thresholdSeries] = d;
        this._liftGraphModel.addGraphData(objectArray);
    }

    public void setSelectedTargetValue(String string) {
        this._selectedTargetValue = string;
    }

    public String getSelectedTargetValue() {
        return this._selectedTargetValue;
    }

    public Map<String, List<LiftData>> getLiftData() {
        return this._liftdata.get(this.getSelectedTargetValue());
    }

    public LiftTableModel getLoadingLiftTableModel() {
        return new LiftTableModel();
    }

    public LiftTableModel getLiftTableModel() {
        return this._liftTableModel;
    }

    public Vector<String> getTargetValues() {
        return this._targetValues;
    }

    public DefaultGraphDataModel getLiftGraphModel() {
        return this._liftGraphModel;
    }

    public void setSelectedTestResult(String string) {
        this._selectedTestResult = string;
    }

    public String getSelectedTestResult() {
        return this._selectedTestResult;
    }

    public Context getContext() {
        return this._context;
    }

    public TestResult getSelectedTestResultObj() {
        for (TestResult testResult : this._testResults) {
            if (!testResult.toString().equals(this.getSelectedTestResult())) continue;
            return testResult;
        }
        return null;
    }

    public void setSelectedDisplayOption(String string) {
        this._selectedDisplayOption = string;
    }

    public String getSelectedDisplayOption() {
        return this._selectedDisplayOption;
    }

    public void setSelectedQuantileValue(int n) {
        this._selectedQuantileValue = n;
    }

    public int getSelectedQuantileValue() {
        return this._selectedQuantileValue;
    }

    public void setCustomThresholdValue(double d) {
        this._customThresholdValue = d;
    }

    public double getCustomThresholdValue() {
        return this._customThresholdValue;
    }

    public double getMaxCumLift() {
        return this._maxCumLift;
    }

    public int getMaxQuantileCnt() {
        return this._maxQuantileCnt;
    }

    public class LiftTuneTableModel
    extends LiftTableModel {
        public static final int RESULT_NAME = 0;
        public static final int TUNE = 1;
        public static final int LIFT_CUMULATIVE = 2;
        public static final int GAIN_CUMULATIVE = 3;
        public static final int PERCENTAGE_RECORDS_CUMULATIVE = 4;
        public static final int TARGET_DENSITY_CUMULATIVE = 5;
        public static final int ALGORITHM = 6;
        public static final int CREATION_DATE = 7;
        private TuneState _tuneState;
        private String TUNE_NONE;
        private String TUNE_BENEFIT;
        private String TUNE_COST;
        private String TUNE_ROC;
        private String TUNE_LIFT;
        private String TUNE_PROFIT;

        public LiftTuneTableModel() {
            this.TUNE_NONE = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_NONE");
            this.TUNE_BENEFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_BENEFIT");
            this.TUNE_COST = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_COST");
            this.TUNE_ROC = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_ROC");
            this.TUNE_LIFT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_LIFT");
            this.TUNE_PROFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_PROFIT");
        }

        public LiftTuneTableModel(TuneState tuneState, Map<String, List<LiftData>> map) {
            super(map);
            this.TUNE_NONE = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_NONE");
            this.TUNE_BENEFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_BENEFIT");
            this.TUNE_COST = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_COST");
            this.TUNE_ROC = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_ROC");
            this.TUNE_LIFT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_LIFT");
            this.TUNE_PROFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_PROFIT");
            this._colNames = new Vector();
            this._colNames.add(TestViewerLrb.get("RESULT_NAME"));
            this._colNames.add(PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE"));
            this._colNames.add(TestViewerLrb.get("LIFT_CUMULATIVE"));
            this._colNames.add(TestViewerLrb.get("GAIN_CUMULATIVE"));
            this._colNames.add(TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE"));
            this._colNames.add(TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE"));
            this._colNames.add(TestViewerLrb.get("ALGORITHM"));
            this._colNames.add(TestViewerLrb.get("CREATION_DATE"));
            this.setColumnIdentifiers(this._colNames);
            this.setColumnCount(this._colNames.size());
            this._tuneState = tuneState;
        }

        @Override
        public String getColumnName(int n) {
            return (String)this._colNames.get(n);
        }

        @Override
        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return super.getValueAt(n, 0);
            }
            if (n2 == 3) {
                return super.getValueAt(n, 2);
            }
            if (n2 == 4) {
                return super.getValueAt(n, 3);
            }
            if (n2 == 2) {
                return super.getValueAt(n, 1);
            }
            if (n2 == 5) {
                return super.getValueAt(n, 4);
            }
            if (n2 == 6) {
                return super.getValueAt(n, 5);
            }
            if (n2 == 7) {
                return super.getValueAt(n, 6);
            }
            if (n2 == 1 && this._liftData != null) {
                Object[] objectArray = this._liftData.keySet().toArray();
                String string = (String)objectArray[n];
                if (this._tuneState.isTuningNone(string)) {
                    return this.TUNE_NONE;
                }
                if (this._tuneState.isTuningBenefit(string)) {
                    return this.TUNE_BENEFIT;
                }
                if (this._tuneState.isTuningCost(string)) {
                    return this.TUNE_COST;
                }
                if (this._tuneState.isTuningCustomROC(string)) {
                    return this.TUNE_ROC;
                }
                if (this._tuneState.isTuningCustomLift(string)) {
                    return this.TUNE_LIFT;
                }
                if (this._tuneState.isTuningCustomProfit(string)) {
                    return this.TUNE_PROFIT;
                }
            }
            return null;
        }
    }

    public class LiftTableModel
    extends GenericBaseTableModel {
        public static final int RESULT_NAME = 0;
        public static final int LIFT_CUMULATIVE = 1;
        public static final int GAIN_CUMULATIVE = 2;
        public static final int PERCENTAGE_RECORDS_CUMULATIVE = 3;
        public static final int TARGET_DENSITY_CUMULATIVE = 4;
        public static final int ALGORITHM = 5;
        public static final int CREATION_DATE = 6;
        protected Vector<String> _colNames;
        protected Map<String, List<LiftData>> _liftData = null;
        private final String LOADING = TestViewerLrb.get("LOADING");

        public LiftTableModel() {
            this(null);
        }

        public LiftTableModel(Map<String, List<LiftData>> map) {
            this._colNames = new Vector();
            this._colNames.add(TestViewerLrb.get("RESULT_NAME"));
            this._colNames.add(TestViewerLrb.get("LIFT_CUMULATIVE"));
            this._colNames.add(TestViewerLrb.get("GAIN_CUMULATIVE"));
            this._colNames.add(TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE"));
            this._colNames.add(TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE"));
            this._colNames.add(TestViewerLrb.get("ALGORITHM"));
            this._colNames.add(TestViewerLrb.get("CREATION_DATE"));
            this.setColumnIdentifiers(this._colNames);
            this._liftData = map;
            this.setRowCount(this._liftData == null ? 1 : map.size());
            this.setColumnCount(this._colNames.size());
        }

        public String getColumnName(int n) {
            return this._colNames.get(n);
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            if (this._liftData == null) {
                if (n2 == 0) {
                    return this.LOADING;
                }
                return null;
            }
            Object[] objectArray = this._liftData.keySet().toArray();
            List<LiftData> list = this._liftData.get(objectArray[n]);
            int n3 = LiftTabState.this._selectedQuantileValue;
            if (n2 == 0) {
                return objectArray[n];
            }
            if (n2 == 2) {
                return list.get((int)n3)._gainCum * 100.0;
            }
            if (n2 == 3) {
                return list.get((int)n3)._percentRecordsCum;
            }
            if (n2 == 1) {
                return list.get((int)n3)._liftCum;
            }
            if (n2 == 4) {
                return list.get((int)n3)._targetDensityCum;
            }
            if (n2 == 5) {
                return list.get((int)n3)._algorithm;
            }
            if (n2 == 6) {
                return list.get((int)n3)._creation_date;
            }
            return "Undefined";
        }
    }

    private class DateComparator
    implements Comparator {
        private DateComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (object instanceof Date && object2 instanceof Date && object instanceof Comparable && object2 instanceof Comparable) {
                return ((Comparable)object).compareTo(object2);
            }
            return object.toString().compareTo(object2.toString());
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof DateComparator;
        }
    }

    public class LiftData
    implements Element {
        public Integer _quantile;
        public Double _threshold;
        public Double _gainCum;
        public Integer _quantileTotalCnt;
        public Double _quantileTargetCnt;
        public Double _percentRecordsCum;
        public Double _liftCum;
        public Double _targetDensityCum;
        public Double _targetCum;
        public Double _nonTargetCum;
        public Double _liftQuantile;
        public Double _targetDensity;
        public String _algorithm;
        public Date _creation_date;
        public Integer _idealQuantile;
        private String _label;

        public LiftData(Integer n, Double d, Double d2, Integer n2, Double d3, Double d4, Double d5, Double d6, Double d7, Double d8, Double d9, Double d10, String string, Date date) {
            this._quantile = n;
            this._threshold = d;
            this._gainCum = d2;
            this._quantileTotalCnt = n2;
            this._quantileTargetCnt = d3;
            this._percentRecordsCum = d4 * 100.0;
            this._liftCum = d5;
            this._targetDensityCum = d6;
            this._targetCum = d7;
            this._nonTargetCum = d8;
            this._liftQuantile = d9;
            this._targetDensity = d10;
            this._algorithm = string;
            this._creation_date = date;
        }

        public void setLabel(String string) {
            this._label = string;
        }

        public boolean mayHaveChildren() {
            return false;
        }

        public Iterator<Element> getChildren() {
            return null;
        }

        public Attributes getAttributes() {
            return null;
        }

        public Object getData() {
            return null;
        }

        public String getShortLabel() {
            return this._label;
        }

        public String getLongLabel() {
            return "";
        }

        public Icon getIcon() {
            return null;
        }

        public String getToolTipText() {
            return "";
        }

        public String toString() {
            return "";
        }
    }
}

