/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer;

import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.repository.Activity;
import oracle.dmt.dataminer.repository.Test;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dss.graph.Graph;
import oracle.dss.graph.Series;
import oracle.ide.Context;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.NodeFactory;

public class TestTrendNode
extends BaseTreeNode {
    private static Icon _icon;
    private List<Test> _tests;
    private List<Color> _testGraphColors;
    private Context _context;
    private Activity _parentActivity;
    private Date _lastUpdatedTime;

    public TestTrendNode() {
        this.getAttributes().set(ElementAttributes.CLOSEABLE);
    }

    public void setTests(List<Test> list) {
        this._tests = list;
        this.assignColors();
        this._lastUpdatedTime = new Date(System.currentTimeMillis());
    }

    public void setContext(Context context) {
        this._context = context;
    }

    public List<Color> getTestGraphColors() {
        return this._testGraphColors;
    }

    public Context getContext() {
        return this._context;
    }

    public List<Test> getTests() {
        return this._tests;
    }

    public void setParentActivity(Activity activity) {
        this._parentActivity = activity;
    }

    public Activity getParentActivity() {
        return this._parentActivity;
    }

    public boolean isDirty() {
        return false;
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        NodeFactory.uncache((URL)this.getURL());
    }

    public Icon getIcon() {
        if (_icon == null) {
            _icon = UIResourceHelper.getImageIcon(this.getClass(), TestViewerLrb.get("TREND_EDITOR_ICON"));
        }
        return _icon;
    }

    public void setLastUpdatedTime(Date date) {
        this._lastUpdatedTime = date;
    }

    public Date getLastUpdatedTime() {
        return this._lastUpdatedTime;
    }

    private void assignColors() {
        Graph graph = new Graph();
        Object[] objectArray = new Object[]{"TempRowLable1", "TempRowLable2"};
        Object[] objectArray2 = new Object[this._tests.size()];
        Object[][] objectArray3 = new Object[2][this._tests.size()];
        int n = 0;
        for (Test test : this._tests) {
            objectArray2[n] = test.getName();
            objectArray3[0][n] = new Double(0.5);
            objectArray3[1][n] = new Double(1.0);
            ++n;
        }
        graph.setGridData(objectArray, objectArray2, objectArray3);
        this._testGraphColors = new ArrayList<Color>();
        Series series = graph.getSeries();
        int n2 = 0;
        while (n < this._tests.size()) {
            try {
                Color color = series.getColor(n2);
                this._testGraphColors.add(color);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
    }
}

