/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewEvent;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.aeditor.dialog.CompareTestResultsFlatDialog;
import oracle.dmt.dataminer.controls.LegendsNiceTable;
import oracle.dmt.dataminer.legend.LegendConsumer;
import oracle.dmt.dataminer.legend.LegendWindowGUI;
import oracle.dmt.dataminer.repository.Test;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.tviewer.AbstractTestEditor;
import oracle.dmt.dataminer.tviewer.AbstractTestEditorAddin;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestTrendNode;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.ide.view.View;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class TestLegendsPanel
extends LegendWindowGUI {
    private View _consumerView;
    private boolean _loaded;
    private SharedTestEditorState _sharedTestEdiorState = null;
    private AbstractTestEditorAddin.MeasureType _measureType;
    private JButton _jBT_AddOrRemove;
    private Icon _jIC_UpdateENA;
    private Icon _jIC_UpdateDIS;
    private JLabel _jLB_Target;
    private JLabel _jLB_TargetValue;
    private ComponentWithTitlebar _jLegendsPanel;

    public TestLegendsPanel(AbstractTestEditorAddin.MeasureType measureType) {
        this._measureType = measureType;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public TestLegendsPanel() {
        this._measureType = null;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jLB_Target = new JLabel();
        this._jLB_TargetValue = new JLabel();
        this._jLegendsPanel = new ComponentWithTitlebar();
        this._jLB_Target.setText("Target:");
        this._jLB_TargetValue.setText("targetValue");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jLegendsPanel, -1, 188, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this._jLB_Target).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jLB_TargetValue))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLB_Target).addComponent(this._jLB_TargetValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this._jLegendsPanel, -1, 141, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        this._jIC_UpdateENA = UIResourceHelper.getImageIcon(this.getClass(), TestViewerLrb.get("ADD_REMOVE_BTN_ICON_ENA"));
        this._jIC_UpdateDIS = UIResourceHelper.getImageIcon(this.getClass(), TestViewerLrb.get("ADD_REMOVE_BTN_ICON_DIS"));
        this._jBT_AddOrRemove = new JButton(TestViewerLrb.get("ADD_REMOVE_BTN"), this._jIC_UpdateENA);
        this._jBT_AddOrRemove.setDisabledIcon(this._jIC_UpdateDIS);
        this._jLB_Target.setText(TestViewerLrb.get("TARGET_ATTRIBUTE"));
    }

    @Override
    public void initUI() {
        this._jBT_AddOrRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TestLegendsPanel.this._measureType == null) {
                    TestLegendsPanel.this._jBT_Trend_AddOrRemove_actionPerformed(actionEvent);
                } else {
                    TestLegendsPanel.this._jBT_Compare_AddOrRemove_actionPerformed(actionEvent);
                }
            }
        });
        this.enableAllControls(false);
    }

    protected void _jBT_Compare_AddOrRemove_actionPerformed(ActionEvent actionEvent) {
        CompareTestResultsFlatDialog compareTestResultsFlatDialog = new CompareTestResultsFlatDialog();
        if (compareTestResultsFlatDialog.invoke(this._sharedTestEdiorState, this._sharedTestEdiorState.getContext(), this._sharedTestEdiorState.getParentActivity(), this._sharedTestEdiorState.getTestResults())) {
            List list = (List)compareTestResultsFlatDialog.getUserObject();
            this._sharedTestEdiorState.setTestResults(list);
            Container container = ((AbstractTestEditor)this._consumerView).getParent();
            container.remove(((AbstractTestEditor)this._consumerView).getCurrentGUI());
            container.add(((AbstractTestEditor)this._consumerView).getGUI());
            if (this._measureType == null) {
                this.setupTrendUIDetail();
            } else {
                this.setupCompareUIDetail();
            }
        }
    }

    protected void _jBT_Trend_AddOrRemove_actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void setupUI(View view) {
        if (this._consumerView == view) {
            return;
        }
        if (view == null) {
            return;
        }
        LegendConsumer legendConsumer = (LegendConsumer)view;
        this._consumerView = view;
        DataMinerViewGUI dataMinerViewGUI = (DataMinerViewGUI)this._consumerView.getGUI();
        dataMinerViewGUI.addDataMinerViewListener(this);
        if (!legendConsumer.isLoaded()) {
            this._consumerView = view;
            if (this._measureType == null) {
                this.setupTrendUIDetail();
            } else {
                this.setupCompareUIDetail();
            }
            return;
        }
        if (this._measureType == null) {
            this.setupTrendUIDetail();
        } else {
            this.setupCompareUIDetail();
        }
    }

    private void setupCompareUIDetail() {
        Object object;
        this._sharedTestEdiorState = (SharedTestEditorState)((AbstractTestEditor)this._consumerView).getCachedLegendState();
        List<TestResult> list = this._sharedTestEdiorState.getTestResults();
        List<Color> list2 = this._sharedTestEdiorState.getTestResultGraphColors();
        boolean bl = false;
        Object[][] objectArray = new Object[0][2];
        if (list != null) {
            int n;
            if (AbstractTestEditorAddin.MeasureType.LIFT.equals((Object)this._measureType)) {
                if (list.size() == 1) {
                    objectArray = new Object[list.size() + 2][4];
                    objectArray[list.size()][0] = new LegendsNiceTable.LegendColumn(SharedTestEditorState.LIFT_IDEAL_LINE, TestViewerLrb.get("IDEAL_LINE"));
                    objectArray[list.size()][1] = null;
                    objectArray[list.size()][2] = null;
                    objectArray[list.size()][3] = null;
                    n = list.size() + 1;
                } else {
                    objectArray = new Object[list.size() + 1][4];
                    n = list.size();
                }
                objectArray[n][0] = new LegendsNiceTable.LegendColumn(SharedTestEditorState.LIFT_RANDOM_LINE, TestViewerLrb.get("RANDOM_LINE"));
                objectArray[n][1] = null;
                objectArray[n][2] = null;
                objectArray[n][3] = null;
            } else if (AbstractTestEditorAddin.MeasureType.PROFIT.equals((Object)this._measureType)) {
                objectArray = new Object[list.size() + 1][4];
                objectArray[list.size()][0] = new LegendsNiceTable.LegendColumn(SharedTestEditorState.PROFIT_BUDGET_LINE, TestViewerLrb.get("BUDGET_LINE"));
                objectArray[list.size()][1] = null;
                objectArray[list.size()][2] = null;
                objectArray[list.size()][3] = null;
            } else {
                objectArray = new Object[list.size()][4];
            }
            n = 0;
            for (TestResult object22 : list) {
                if (!bl) {
                    this._jLB_TargetValue.setText(object22.getColumnName());
                    bl = true;
                }
                objectArray[n][0] = object = new LegendsNiceTable.LegendColumn(list2.get(n), object22.getName());
                objectArray[n][1] = object22.getCreationTimestamp();
                objectArray[n][2] = object22.getModelName();
                objectArray[n][3] = ServerConstants.Algorithm.getUIAlgorithmName(object22.getMiningAlgorithm());
                ++n;
            }
        }
        Object[] objectArray2 = new String[]{TestViewerLrb.get("NAME"), TestViewerLrb.get("CREATION_DATE"), TestViewerLrb.get("MODEL_NAME"), TestViewerLrb.get("ALGORITHM")};
        Object object3 = new LegendsTableModel(objectArray, objectArray2);
        LegendsNiceTable legendsNiceTable = new LegendsNiceTable((TableModel)object3);
        legendsNiceTable.setHiddenColumns(new int[]{2, 3});
        object = new JScrollPane((Component)((Object)legendsNiceTable));
        this._jLegendsPanel.setComponent((JComponent)object);
        ControlBar controlBar = new ControlBar();
        controlBar.add((Component)this._jBT_AddOrRemove);
        this._jLegendsPanel.setControlBar(controlBar);
        if (list.size() <= 1) {
            this.enableAllControls(false);
        } else {
            this.enableAllControls(true);
        }
        this.setLoaded(true);
        this.updateUI();
    }

    private void setupTrendUIDetail() {
        Object object;
        TestTrendNode testTrendNode = (TestTrendNode)((LegendConsumer)this._consumerView).getCachedLegendState();
        List<Test> list = testTrendNode.getTests();
        List<Color> list2 = testTrendNode.getTestGraphColors();
        boolean bl = false;
        Object[][] objectArray = new Object[0][2];
        if (list != null) {
            objectArray = new Object[list.size()][3];
            int n = 0;
            for (Test object22 : list) {
                if (!bl) {
                    this._jLB_TargetValue.setText(object22.getTarget());
                    bl = true;
                }
                objectArray[n][0] = object = new LegendsNiceTable.LegendColumn(list2.get(n), object22.getName());
                objectArray[n][1] = ServerConstants.Algorithm.getUIAlgorithmName(object22.getAlgorithm());
                objectArray[n][2] = object22.getTestResultsWithinTimeframe().size();
                ++n;
            }
        }
        Object[] objectArray2 = new String[]{TestViewerLrb.get("NAME"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("NUMBER_OF_RESULTS")};
        Object object3 = new LegendsTableModel(objectArray, objectArray2);
        LegendsNiceTable legendsNiceTable = new LegendsNiceTable((TableModel)object3);
        legendsNiceTable.setHiddenColumns(new int[]{2});
        object = new JScrollPane((Component)((Object)legendsNiceTable));
        this._jLegendsPanel.setComponent((JComponent)object);
        ControlBar controlBar = new ControlBar();
        controlBar.add((Component)this._jBT_AddOrRemove);
        this._jLegendsPanel.setControlBar(controlBar);
        this.enableAllControls(true);
        this.setLoaded(true);
        this.updateUI();
    }

    @Override
    public void unloadUI() {
        if (this._consumerView == null) {
            return;
        }
        DataMinerViewGUI dataMinerViewGUI = (DataMinerViewGUI)this._consumerView.getGUI();
        dataMinerViewGUI.removeDataMinerViewListener(this);
        this.setLoaded(false);
    }

    private void enableAllControls(boolean bl) {
        this._jBT_AddOrRemove.setEnabled(bl);
    }

    @Override
    public boolean isLoaded() {
        return this._loaded;
    }

    private void setLoaded(boolean bl) {
        this._loaded = bl;
    }

    @Override
    public void viewReady(DataMinerViewEvent dataMinerViewEvent) {
    }

    @Override
    public void viewBusy(DataMinerViewEvent dataMinerViewEvent) {
    }

    public void addLegend(String string, Color color) {
        ((DefaultTableModel)((LegendsNiceTable)((Object)this._jLegendsPanel.getComponent())).getModel()).addRow(new Object[]{new LegendsNiceTable.LegendColumn(color, string), null, null, null});
    }

    public void removeLegend(int n) {
        ((DefaultTableModel)((LegendsNiceTable)((Object)this._jLegendsPanel.getComponent())).getModel()).removeRow(n);
    }

    private class LegendsTableModel
    extends GenericBaseTableModel {
        public LegendsTableModel(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

