/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.navigator.AbstractHiddenNode;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.ide.Context;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;

public abstract class AbstractTestEditor
extends DataMinerEditor {
    protected SharedTestEditorState _sharedState;
    protected long _lastUpdatedTime;
    private BaseTreeNode _projectFolder = null;
    private BaseTreeNode _connectionFolder = null;
    private BaseTreeNode _connectionsFolder = null;
    private WorkflowNode _wfNode = null;

    protected abstract DataMinerViewGUI getTestEditorGUI();

    public Component getGUI() {
        if (this._gui == null || this.isReloadDueToUpdates()) {
            try {
                this._gui = this.getTestEditorGUI();
                this._gui.setPreferredSize(new Dimension(350, 350));
                this.setToolbarVisible(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this._gui;
    }

    public void open() {
        Context context = this.getContext();
        BaseTreeNode baseTreeNode = (BaseTreeNode)context.getNode();
        if (baseTreeNode instanceof AbstractHiddenNode) {
            this.attach(((AbstractHiddenNode)baseTreeNode).getContext() != null);
        }
    }

    public void close() {
        this.attach(false);
    }

    private void attach(boolean bl) {
        if (bl) {
            AbstractHiddenNode abstractHiddenNode = (AbstractHiddenNode)this.getContext().getNode();
            this._wfNode = (WorkflowNode)abstractHiddenNode.getContext().getNode();
            TNode tNode = this._wfNode.getParent();
            this._projectFolder = (BaseTreeNode)tNode.getData();
            this._connectionFolder = (BaseTreeNode)tNode.getAncestor(ConnectionFolder.class, true);
            this._connectionsFolder = (BaseTreeNode)tNode.getAncestor(Connections.class, true);
            this._projectFolder.attach((Observer)this);
            this._connectionFolder.attach((Observer)this);
            this._connectionsFolder.attach((Observer)this);
        } else {
            if (this._projectFolder != null) {
                this._projectFolder.detach((Observer)this);
                this._projectFolder = null;
            }
            if (this._connectionFolder != null) {
                this._connectionFolder.detach((Observer)this);
                this._connectionFolder = null;
            }
            if (this._connectionsFolder != null) {
                this._connectionsFolder.detach((Observer)this);
                this._connectionsFolder = null;
            }
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (updateMessage.getMessageID() == UpdateMessage.CHILD_REMOVED) {
            List list = updateMessage.getRemoveObjects();
            if (list.contains(this._projectFolder) || list.contains(this._connectionFolder) || list.contains(this._connectionsFolder) || list.contains(this._wfNode)) {
                this.closeEditor();
            }
        } else if (updateMessage.getMessageID() == UpdateMessage.OBJECT_CLOSED && object == this._connectionFolder) {
            this.closeEditor();
        }
    }

    public Component getCurrentGUI() {
        return this._gui;
    }

    public Container getParent() {
        return this._gui.getParent();
    }

    protected void initSharedTestEditorState(Context context) {
        Node node = context.getNode();
        assert (node != null) : "Tree Node is not null";
        this._sharedState = new SharedTestEditorState(node);
        this._lastUpdatedTime = this._sharedState.getLastUpdateTime();
    }

    public Object getCachedLegendState() {
        return this._sharedState;
    }

    public void setCachedLegendState(Object object) {
        this._sharedState = (SharedTestEditorState)object;
    }

    private boolean isReloadDueToUpdates() {
        if (this._sharedState == null) {
            return true;
        }
        return this._lastUpdatedTime != this._sharedState.getLastUpdateTime();
    }
}

